#include <header.h>
#include <globals.h>

/****************************************************************************
	user attempts to drag a monster to the next room
*/
void EXPORT Drag_Mon(short m, short dir)
{
	long    my_roll;
	long    his_roll;
	long    my_strength;
	long    his_strength;
	short   outreacted;

	outreacted = Perform_Attack(MON);

	if (outreacted)
	{
		return;
	}

	if (Monster_Fled(m, TRUE))
	{
		return;
	}

	his_strength = (long) AMON->Str + (long) AMON->Dex;
	my_strength = ((long) me.Str + (long) me.Dex) * 2L;

	if 
	(
		AMON->next_hit == VULNERABLE || 
		AMON->bashed ||
		find_timer(SLEEP_TIME, MON) ||
		find_timer(KO_TIME, MON)
	)
	{
		his_strength = his_strength / 2L;
	}

	if (his_strength <= 0)
	{
		his_strength = 1;
	}

	if (my_strength <= 0)
	{
		my_strength = 1;
	}

	my_roll = LRAND(my_strength);
	his_roll = LRAND(his_strength);

	AMON->next_hit = NORMAL;
	AMON->Tired += (globals->bashftg / 2);
	Set_Mon_Name(name, m);
	
	if (my_roll < his_roll && !me.perm[KILLER_PERM])
	{
		prfmsg(MSG1543, name);
		return;
	}

	MY_PORT->drag_mon = m;
	MY_PORT->dragged = FALSE;

	if (dir != GO)
	{
		MY_PORT->misc = dir - NORTH;
		Moving(1);
	}
	else
	{
		Go_Special(1);
	}

	if (!MY_PORT->dragged)
	{
		prfmsg(MSG1543, name);
	}

	MY_PORT->drag_mon = -1;
}
/****************************************************************************
	user attempts to bash a monster
*/
short EXPORT Bash_Mon(short m)
{
	long    my_roll;
	long    his_roll;
	long    my_strength;
	long    his_strength;
	short   success = 0;
	short   mon_ac;
	short   my_ac;
	short   outreacted;
	char    *msg;

	outreacted = Perform_Attack(MON);

	if (outreacted)
	{
		return (TRUE);
	}

	if (Monster_Fled(m, TRUE))
	{
		return (TRUE);
	}

	his_strength = (long) AMON->Str + (long) AMON->Dex;
	my_strength = ((long) me.Str + (long) me.Dex) * 2L;

	if (AMON->next_hit == VULNERABLE)
	{
		his_strength = his_strength / 2L;
	}

	if (his_strength <= 0)
	{
		his_strength = 1;
	}

	if (my_strength <= 0)
	{
		my_strength = 1;
	}

	if (me.class == BARBARIAN)
	{
		my_strength = my_strength * 2L;
	}

	my_roll = LRAND(my_strength);
	his_roll = LRAND(his_strength);

	AMON->next_hit = NORMAL;
	Set_Mon_Name(name, m);

	if (my_roll > his_roll || me.perm[KILLER_PERM])
	{
		AMON->hurt_by[P] = TRUE;
		AMON->hurters[P] = TRUE; 
		AMON->next_hit = VULNERABLE;

		if (AMON->action_timer < globals->bashtime)
		{
			AMON->action_timer = globals->bashtime;
		}

		success = 1;
		my_roll = LRAND(my_strength / 3L);
		his_roll = LRAND(his_strength);

		if (my_roll > his_roll || me.perm[KILLER_PERM])
		{
			AMON->bashed = TRUE;
			success = 2;
			AMON->bashed_time = globals->bashtime;
		}
	}

	if (!success)
	{
		prfmsg(M444, name);
	}
	else if (success == 1)
	{
		prfmsg(MSG445, name);
		msg = getmsg(MSG446);
		sprintf(str, msg, me.name, name);
		Message(str, LOUD_LOCAL);
	}
	else
	{
		prfmsg(MSG447, name);
		msg = getmsg(MSG448);
		sprintf(str, msg, me.name, name);
		Message(str, LOUD_LOCAL);
	}

	AMON->Tired += (globals->bashftg / 2);

	mon_ac = Calc_Mon_AC(m, EQUIP_ONLY);
	my_ac = Calc_Player_AC(&me, P, EQUIP_ONLY);
	if (mon_ac < my_ac)
	{
		AMON->my_ac_was_lower[P] = TRUE;
	}

	if (Monster_Fled(m, FALSE))
	{
		return (TRUE);
	}

	return (FALSE); /* the monster did not flee */
}
/****************************************************************************
	user is attacking a monster, TRUE return value means monster 'm' is no more
*/
short Attack_Mon(short m)
{
	short   first_hit;
	short   bonus;
	short   easy_bonus;
	short   ok;
	MLONG   dmg;
	short   roll;
	short   mon_ac;
	short   my_ac;
	short   clean_miss = 0;
	short   armor_hit = 0;
	short   outreacted;
	short   asleep = find_timer(SLEEP_TIME, MON);
	char    *msg;
		
	outreacted = Perform_Attack(MON);

	if (outreacted)
	{
		return (TRUE);
	}

	if (Monster_Fled(m, TRUE))
	{
		return (TRUE);
	}

	mon_ac = Calc_Mon_AC(m, FULL_AC);

	if (AMON->magical)
	{
		ok = FALSE;

		if (me.lw >= 0 && me.item[me.lw].bonus > 0)
		{
			ok = TRUE;
		}
		else if (me.rw >= 0 && me.item[me.rw].bonus > 0)
		{
			ok = TRUE;
		}

		if (!ok && !me.perm[KILLER_PERM])
		{
			AMON->next_hit = NORMAL;

			if (me.lw >= 0 || me.rw >= 0)
			{
				prfmsg(M449);
			}
			else
			{
				prfmsg(M450);
			}
			BAD_EXIT;
		}
	}

	if (AMON->magic_immune)
	{
		ok = TRUE;

		if (me.lw >= 0 && me.item[me.lw].bonus > 0)
		{
			ok = FALSE;
		}
		else if (me.rw >= 0 && me.item[me.rw].bonus > 0)
		{
			ok = FALSE;
		}

		if (!ok && !me.perm[KILLER_PERM])
		{
			AMON->next_hit = NORMAL;

			prfmsg(M449);
			BAD_EXIT;
		}
	}

	Combat_Bonus(&bonus, WITH_SPELLS);
	roll = Roll_Dice(MON, bonus);

	if (AMON->sees[P])
	{
		AMON->last_attacker = P;
	}

	if (Flubbed())
	{
		MY_PORT->next_hit = NORMAL;
		BAD_EXIT;
	}

	if (!me.perm[KILLER_PERM])
	{
		if (roll - mon_ac < 20 || AMON->damage > AMON->dpts)
		{
			if (RANDOM(2) == 1 || asleep)
			{
				armor_hit = TRUE;
			}

			if (RANDOM(2) == 1)
			{
				clean_miss = TRUE;
			}
			else
			{
				if (command == GREATBLOW)
				{
					AMON->Tired += globals->gbftg / 2;
				}
				else if (command == HIT)
				{
					AMON->Tired += globals->hitftg / 2;
				}
			}

			if (armor_hit)
			{
				prfmsg(M451);
				Entropy(); 
			}
			else if (clean_miss)
			{
				prfmsg(M452);
			}
			else
			{
				Start_Mon_Name(name, m);
				prfmsg(M453, name);
			}

			AMON->next_hit = NORMAL;

			if (Monster_Fled(m, FALSE))
			{
				return (TRUE);
			}

			BAD_EXIT;
		}
	}

	dmg = (MLONG) Calc_Damage(MON, bonus);
	AMON->next_hit = NORMAL;

	if (AMON->damage)
	{
		first_hit = FALSE;
	}
	else
	{
		first_hit = TRUE;
	}

	if (me.perm[KILLER_PERM])
	{
		dmg = AMON->dpts + 1;
	}
	else if (dmg > AMON->dpts && first_hit)
	{
		dmg = AMON->dpts;
	}
 
	AMON->damage += dmg;
	AMON->hurt_by[P] = TRUE;
	AMON->hurters[P] = TRUE; 
	AMON->struck_by[P] = TRUE;

	mon_ac = Calc_Mon_AC(m, EQUIP_ONLY);
	my_ac = Calc_Player_AC(&me, P, EQUIP_ONLY);

	if (mon_ac < my_ac)
	{
		AMON->my_ac_was_lower[P] = TRUE;
	}

	Combat_Bonus(&easy_bonus, NO_SPELLS);
	if (easy_bonus > mon_ac)
	{
		AMON->easy_hit[P] = TRUE;
	}
		
	if (me.lw < 0 && me.rw < 0)
	{
		prfmsg(MSG454);
	}

	msg = getmsg(MSG455);
	sprintf(str, msg, dmg);
	prf(str);

	Entropy();

	if (AMON->damage <= AMON->dpts && me.rw >= 0)
	{
		Instilled_Weapons(MON, me.rw, first_hit);
	}

	if (AMON->damage <= AMON->dpts && me.lw >= 0)
	{
		Instilled_Weapons(MON, me.lw, first_hit);
	}

	if (AMON->damage > AMON->dpts || me.perm[KILLER_PERM])
	{
		Killed_Mon(m);
		return (TRUE);
	}
	else
	{
		Monster_Wounds(m);

		if (Monster_Fled(m, FALSE))
		{
			return (TRUE);
		}
	}

	return (FALSE);
}
/****************************************************************************
	describe the state of a monster's wounds
*/
void Monster_Wounds(short m)
{

	Start_Mon_Name(name, m);

	if (AMON->dpts - AMON->damage < 10)
	{
		prfmsg(MSG457, name);
	}
	else if (AMON->dpts - AMON->damage < 20)
	{
		prfmsg(MSG458, name);
	}
}
/****************************************************************************
	user killed a monster
*/
void Killed_Mon(short m)
{
	short   local_mon = FALSE;
	short   addevil;
	short   i;
	short   x;
	short   total;
	short   guys;
	short   hurters = 0;
	char    kill_date[DATE_SIZE];
	MLONG   coins;
	short   learned;

	Set_Mon_Name(name, m);
	prfmsg(MSG459, name);
	sprintf(str, getmsg(MSG460), me.name, name);

	if (AMON->permanant)
	{
		if (AMON->which == globals->rover)
		{
			++MY_PORT->rovers;
		}

		if (!me.perm[INVIS_PORT_PERM])
		{
			Message(str, GLOBAL);
		}

		TODAY(kill_date);
		sprintf
		(
			str, 
			getmsg(MSG461), 
			kill_date, 
			me.name, 
			AMON->article, 
			AMON->name
		);
		Write_News(str);

		if (ynopt(LOGPERMK))
		{
			sprintf
			(
				str,
				"%s(%s) killed %s (#%d)",
				me.name,
				me.Userid,
				AMON->name,
				AMON->which
			);
			NOTIFY(str);
		}
	}
	else
	{
		Message(str, LOUD_LOCAL);
	}

	if (AMON->attacked_vector == ADD_EVIL)
	{
		if (AMON->evil_pts > 0)
		{
			addevil = AMON->evil_pts;
		}
		else
		{
			addevil = numopt(ADDEVIL, -32767, 32767);
		}
		
		if (addevil)
		{
			prfmsg(M409, addevil);
			me.evil += addevil;
		}
	}

	for (i = guys = 0; i != NTERMS; ++i)
	{
		if (AMON->hurt_by[i])
		{
			++guys;
		}

		if (AMON->hurters[i])
		{
			++hurters;
		}
	}

	for (i = 0; i != NTERMS; ++i)
	{
		if (AMON->hurt_by[i])
		{
			if (AMON->Level > APORT(i)->mon_level)
			{
				APORT(i)->mon_level = AMON->Level;
			}

			++APORT(i)->kills;
			Give_Experience_From_Kill(m, i, guys);
		}
	}

	MY_PORT->enemy_mon = -1;

	if (hurters == 1 || AMON->what != LONER)
	{
		prfmsg(MSG462, name);
	}

	for (i= total = 0, x = 1; x > 0 && i != MAX_MON_ITEM; ++i)
	{
		if 
		(
			AMON->item_has[i].what &&
			(hurters == 1 || AMON->what != LONER)
		)
		{
			if
			(
				AMON->item_has[i].what == MAGIC_DEV &&
				AMON->item_has[i].which == SCROLL
			)
			{
				learned = FALSE;

				if (guys == 1)
				{
					learned = Find_Scroll(&AMON->item_has[i]);
				}

				if (learned)
				{
					++total;
				}
				else
				{
					if (AMON->item_has[i].finder < 0)
					{
						AMON->item_has[i].finder = MY_PORT->index;
					}

					Put_In_Room(&AMON->item_has[i]);
					++total;
					Color_Display_Item(&AMON->item_has[i]);
					prf(NL);
				}
			}
			else
			{
				if (AMON->item_has[i].finder < 0)
				{
					AMON->item_has[i].finder = MY_PORT->index;
				}

				Put_In_Room(&AMON->item_has[i]);
				++total;
				Color_Display_Item(&AMON->item_has[i]);
				prf(NL);
				AMON->item_has[i].what = 0;
			}
		}
	}

	if (total == 0)
	{
		if (hurters != 1 && AMON->what == LONER)
		{
			prfmsg(M711, name);
		}
		else
		{
			prfmsg(M463);
		}
	}

	if (AMON->permanant)
	{
		for (i = 0; i != MAX_PERM_MON; ++i)
		{
			if (globals->perm_mon_id[i] == AMON->which)
			{
				globals->perm_mon_loc[i] = 0;
				globals->perm_mon_id[i] = 0;
				globals->perm_mon_dmg[i] = 0;
			}
		}
	}
		
	ABUF(B)->rm2.last_kill = today();
	ABUF(B)->turf_change = TRUE;

	if (globals->turfmons)
	{
		local_mon = TRUE;
	}
	else if (AMON->permanant && !AMON->roving)
	{
		local_mon = TRUE;
	}
	else
	{
		for (i = 0; i != POSSIBLE_MONS; ++i)
		{
			if (ABUF(B)->rm.monster_here[i] == AMON->which)
			{
				local_mon = TRUE;
			}
		}
	}

	if (!me.Option[NO_TURF] && local_mon)
	{
		if
		(
			me.in_guild &&
			(
				MY_PORT->room_owner < 0 ||
				guild->status[me.in_guild][MY_PORT->room_owner] != 1
			)
		)
		{
			ABUF(B)->rm2.Turf_Kills[me.in_guild] += (AMON->Level / 10) + 1;
		}
		else if (!me.in_guild)
		{
			for (i = 0; i != NUM_SAVED_PLACES; ++i)
			{
				if (ABUF(B)->rm2.Turf_Kills[i])
				{
					ABUF(B)->rm2.Turf_Kills[i] -= (AMON->Level / 10) + 1;
				
					if (ABUF(B)->rm2.Turf_Kills[i] < 0)
					{
						ABUF(B)->rm2.Turf_Kills[i] = 0;
					}
				}
			}
		}
	}

	if (MY_PORT->questing && MY_PORT->quest_type == KILL_QUEST)
	{
		Monster_Name(str, AMON->article, AMON->name);

		if (sameas(str, MY_PORT->quest_thing))
		{
			prfmsg(MSG464);
			MY_PORT->quest_type = 0;
		}
	}
		
	if (sameas(AMON->plural_name, globals->bounty.plural_name))
	{
		coins = Max_Value(AMON->Level) + (short) RANDOM(AMON->Level);

		if ((double) coins + (double) me.bank + (double) me.gold < GCMAXLONG)
		{
			if (globals->autobank)
			{
				me.bank += coins;
			}
			else
			{
				me.gold += coins;
			}

			MY_PORT->bounty_gold += coins;

			sprintf(str, getmsg(MSG456), coins);
			prf(str);
		}
	}

	Remove_Mon(m, TRUE);
}
/****************************************************************************
	user found a scroll, see if they learn the spell
*/
short EXPORT Find_Scroll(struct item_struct *item)
{
	short   which;
	
	which = item->spell_cast;

	if (me.spell[which])
	{
		BAD_EXIT;
	}

	prfmsg(MSG465, spell_info[which].name);
	prfmsg(M466);
	me.spell[which] = TRUE;
	
	return (TRUE);
}
