#include <header.h>
#include <spells.h>
#include <stats.h>

/* global variables */

struct module angmod =
{
	"",
	chaos_login,
	chaos_input,
	chaos_status,
	NULL,
	NULL,
	chaos_hup,
	chaos_clean,
	chaos_delete,
	chaos_shutdown
};

struct  room_buffer_struct      *BUF[MAX_CHANNELS + 1];
struct  port_struct             *PORT[MAX_CHANNELS + 1];
struct  macro_struct            *macros[MAX_CHANNELS + 1];
struct  room_cache_struct       *room_cache[MAX_ROOM_CACHE];

struct  globals_struct          *globals;
struct  closet_struct           *a_closet;
struct  free_bag_struct         *free_bags;
struct  container_struct        *a_container;
struct  container_struct        *a_bag;
struct  guild_info_struct       *guild;
struct  pursuer_struct          *pursuers;
struct  invasion_struct         *invasion;
struct  charstruct              *temp_char;

struct  office_struct           vote; 
struct  charstruct              a_char;
struct  item_struct             item;
struct  item_struct             new_item;
struct  room_struct             a_room;
struct  room2_struct            a_room2;
struct  crit_struct             crit;
struct  fame_struct             fame;
struct  mon_struct              a_mon;
struct  public_post_struct      file_header;
struct  public_post_struct      temp_msg;
struct  ftime                   ftimep;

char    temp_userid[USERID_SIZE];
char    word1[LINE_LEN];
char    word2[LINE_LEN];
char    str[300];
char    name[LINE_LEN];
char    notify_buf[LINE_LEN];
char    *userid;

short   huntress_timer = 0;
short   real_which1;
short   which1;
short   real_which2;
short   which2;
short   file_timer = 0;
short   spell_type;
short   exp_mons = FALSE;
short   bp_mons = FALSE;
short   slow_mons = FALSE;
short   global_timer = 0;
short   users_today = 0;
short   kicked = FALSE;
short   context_count = 0;
short   my_module;

MLONG   secs_today = 0;
MLONG   last_tick;
MLONG   lsk;

#ifndef MBBS
HMCVFILE mui_cfg;
#else
FILE    *mui_cfg;
#endif

FILE    *fp_item;
FILE    *fp_crit;
FILE    *fp_room;
FILE    *fp_room2;

char    *yn[] = {"no", "yes"};
char    prompt[LINE_LEN];

char    *commands[] =
{
	"starting", 
	"stats",        "bounty",       "offices",      "who",        "instill",
	"drag",         "do",           "villains",     "help",       "look",
	"north",        "south",        "east",         "west",       "up",
	"down",         "out",          "search",       "go",         "dump",
	"berserk",      "save",         "experience",   "burden",     "inventory",
	"drop",         "get",          "gameop",       "where",      "send",
	"broadcast",    "say",          "dayfile",      "toss",       "ignore",
	"guard",        "macros",       "listen",       "hide",       "track",
	"use",          "flee",         "follow",       "lose",       "gsend",        
	"trance",       "give",         "poobahs",      "hit",        "bash",         
	"parry",        "greatblow",    "mail",         "monsters",   "whisper",      
	"cast",         "spells",       "health",       "talk",       "menu",       
	"timers",       "label",        "yell",         "smash",      "guilds",       
	"limbo",        "options",      "swap",         "rob",        "items",        
	"uncast"
};

short   command;
short   P;      /* currently referenced player */
short   B;      /* currently referenced room buffer */

short   big_warrior     = -2;
short   big_sorcerer    = -2;
short   big_barbarian   = -2;
short   big_thief       = -2;
short   big_duelist     = -2;
short   big_cleric      = -2;
short   big_mystic      = -2;

char    *mon_types[] =
{
		"?", 
		"NPC", 
		"MONSTER", 
		"ANIMAL", 
		"WEIRD", 
		"HUMANOID", 
		"ORACLE",
		"HUNTRESS",
		"AWESOME",
		"LONER"
};

char    *trap_types[] =
{
		"NONE",
		"POISON",
		"BOMB",
		"TELEPORT",
		"LANGOUR",
		"SLEEP",
		"AGGRIVATION",
		"WEAKNESS",
		"DISPEL"
};

char    *filters[] =
{
		"NONE",
		"GUILD1",
		"GUILD2",
		"GUILD3",
		"GUILD4",
		"GUILD5",
		"GUILD6",
		"GUILD7",
		"GUILD8",
		"GUILD9",
		"UNUSED",
		"ITEM",
		"CLASS",
		"RACE",
		"OFFICER",
		"GOVERNOR",
		"ASSASSIN",
		"PALADIN",
		"JUDGE",
		"LEVEL"
};

char    *spec_types[] =
{
		"NOTHING",
		"NORMAL",
		"DOOR",
		"MAGIC",
		"SPECIAL",
		"CHANT"
};

char    *room_types[] =
{
		"GUILD9",
		"GUILD8",
		"GUILD7",
		"GUILD6",
		"GUILD5",
		"GUILD4", 
		"GUILD3",
		"GUILD2",
		"GUILD1",
		"NOTHING",
		"ACADEMY",
		"ARENA",
		"ARMORSHOP",
		"HALLFAME",
		"DROWNING",
		"MERCANTILE",
		"BANK",
		"SAFEHAVEN",
		"BOAT",
		"CLOSET",
		"BURNING",
		"ONESHOT",
		"NOCAST",
		"NOMAGIC",
		"WEAPONSHOP",
		"MAGICSHOP",
		"UNUSED",
		"SOLO"
};

char    *att[] = {"NOTHING", "JAIL", "EVILPTS", "MORPHS", "FLEES"};
char    *hit[] = {"NOTHING", "POISONER", "STEALER", "DRAINER", "PEST"};

char    *item_types[] =
{
	"NOTHING",
	"EDGED", 
	"BLUNT", 
	"MAGICDEV", 
	"ARMOR", 
	"SHIELD", 
	"POLE",
	"CASH", 
	"JEWELS", 
	"TRINKET", 
	"UNARMED", 
	"CONTAINER", 
	"TALISMAN",
	"TRANSPORTER", 
	"AMULET", 
	"PSYFOCUS" 
};

char    *item_subtypes[] =
{
	"N/A",
	"TWOHANDWEP", 
	"LITEARMOR", 
	"LITEWEP", 
	"SKELETONKEY", 
	"SCROLL", 
	"NODROPSHIELD", 
	"LITESHIELD", 
	"MAGICRING", 
	"MAGICBOX", 
	"SPECIALKEY",
	"PUZZLEPIECE" 
};

char guy_screen_spec[] = "\
NAME \
TITLE \
USERID \
STR \
DEX \
CON \
INT \
PSY \
THIEF \
SHIELD \
TWOWEP \
DEFENSE \
EDGED \
BLUNT \
POLE \
NOHAND \
CLASS \
RACE \
OUTLAW(ALT=N ALT=Y MULTICHOICE) \
EVIL \
GUILD \
MASTER(ALT=N ALT=Y MULTICHOICE) \
GBAL \
BANK \
CASH \
ROOM \
LOROOM \
HIROOM \
LOCRIT \
HICRIT \
LOITEM \
HIITEM \
DONE(ALT=SAVE ALT=QUIT MULTICHOICE)";

char guy_edit_format[] =
	"NAME=%s%c"
	"TITLE=%s%c"
	"USERID=%s%c"
	"STR=%d%c"
	"DEX=%d%c"
	"CON=%d%c"
	"INT=%d%c"
	"PSY=%d%c"
	"THIEF=%d%c"
	"SHIELD=%d%c"
	"TWOWEP=%d%c"
	"DEFENSE=%d%c"
	"EDGED=%d%c"
	"BLUNT=%d%c"
	"POLE=%d%c"
	"NOHAND=%d%c"
	"CLASS=%c%c"
	"RACE=%c%c"
	"OUTLAW=%c%c"
	"EVIL=%d%c"
	"GUILD=%d%c"
	"MASTER=%c%c"
	"GBAL=%ld%c"
	"BANK=%ld%c"
	"CASH=%ld%c"
	"ROOM=%d%c"
	"LOROOM=%d%c"
	"HIROOM=%d%c"
	"LOCRIT=%d%c"
	"HICRIT=%d%c"
	"LOITEM=%d%c"
	"HIITEM=%d%c";

char mon_screen_spec[] = "\
ARTICLE \
NAME \
PLURAL \
TYPE(ALT=NPC ALT=MONSTER ALT=ANIMAL ALT=WEIRD ALT=HUMANOID ALT=ORACLE \
ALT=HUNTRESS ALT=AWESOME ALT=LONER MULTICHOICE) \
LEVEL \
GOOD(ALT=N ALT=Y MULTICHOICE) \
CASTER(ALT=N ALT=Y MULTICHOICE) \
MAGICAL(ALT=N ALT=Y MULTICHOICE) \
IMMUNE(ALT=N ALT=Y MULTICHOICE) \
BLOCK(ALT=N ALT=Y MULTICHOICE) \
PERM(ALT=N ALT=Y MULTICHOICE) \
ATTACKED(ALT=NOTHING ALT=JAIL ALT=EVILPTS ALT=MORPHS ALT=FLEES MULTICHOICE) \
HIT(ALT=NOTHING ALT=POISONER ALT=STEALER ALT=DRAINER ALT=PEST MULTICHOICE) \
DESCFILE(ALT=N ALT=Y MULTICHOICE) \
TALKFILE(ALT=N ALT=Y MULTICHOICE) \
PHRASE \
ITEM0 \
DESC0 \
ITEM1 \
DESC1 \
ITEM2 \
DESC2 \
ITEM3 \
DESC3 \
ITEM4 \
DESC4 \
DONE(ALT=SAVE ALT=QUIT MULTICHOICE)";

char mon_edit_format[] =
	"ARTICLE=%s%c"
	"NAME=%s%c"
	"PLURAL=%s%c"
	"TYPE=%s%c"
	"LEVEL=%d%c"
	"GOOD=%c%c"
	"CASTER=%c%c"
	"MAGICAL=%c%c"
	"IMMUNE=%c%c"
	"BLOCK=%c%c"
	"PERM=%c%c"
	"ATTACKED=%s%c"
	"HIT=%s%c"
	"DESCFILE=%c%c"
	"TALKFILE=%c%c"
	"PHRASE=%s%c"
	"ITEM0=%d%c"
	"DESC0=%s%c"
	"ITEM1=%d%c"
	"DESC1=%s%c"
	"ITEM2=%d%c"
	"DESC2=%s%c"
	"ITEM3=%d%c"
	"DESC3=%s%c"
	"ITEM4=%d%c"
	"DESC4=%s%c";

char room_screen_spec[] = "\
TYPE(ALT=GUILD9 ALT=GUILD8 ALT=GUILD7 ALT=GUILD6 ALT=GUILD5 ALT=GUILD4 \
ALT=GUILD3 ALT=GUILD2 ALT=GUILD1 ALT=NOTHING ALT=ACADEMY ALT=ARENA \
ALT=ARMORSHOP ALT=HALLFAME ALT=DROWNING ALT=MERCANTILE ALT=BANK \
ALT=SAFEHAVEN ALT=BOAT ALT=CLOSET ALT=BURNING ALT=ONESHOT ALT=NOCAST \
ALT=NOMAGIC ALT=WEAPONSHOP ALT=MAGICSHOP ALT=UNUSED ALT=SOLO MULTICHOICE) \
DESC0 \
DESC1 \
DESC2 \
DESC3 \
DESC4 \
DESC5 \
NEXIT \
SEXIT \
EEXIT \
WEXIT \
UEXIT \
DEXIT \
OEXIT \
NVIS(ALT=N ALT=Y MULTICHOICE) \
SVIS(ALT=N ALT=Y MULTICHOICE) \
EVIS(ALT=N ALT=Y MULTICHOICE) \
WVIS(ALT=N ALT=Y MULTICHOICE) \
UVIS(ALT=N ALT=Y MULTICHOICE) \
DVIS(ALT=N ALT=Y MULTICHOICE) \
OVIS(ALT=N ALT=Y MULTICHOICE) \
ARTICLE \
ADJ \
NOUN \
SPECTO \
SPECVIS \
SPECTYPE(ALT=NOTHING ALT=NORMAL ALT=DOOR ALT=MAGIC ALT=SPECIAL ALT=CHANT \
MULTICHOICE) \
FILTER(ALT=NONE ALT=GUILD1 ALT=GUILD2 ALT=GUILD3 ALT=GUILD4 ALT=GUILD5 \
ALT=GUILD6 ALT=GUILD7 ALT=GUILD8 ALT=GUILD9 ALT=UNUSED ALT=ITEM ALT=CLASS \
ALT=RACE ALT=OFFICER ALT=GOVERNOR ALT=ASSASSIN ALT=PALADIN ALT=JUDGE \
ALT=LEVEL MULTICHOICE) \
TRAP(ALT=NONE ALT=POISON ALT=BOMB ALT=TELEPORT ALT=LANGOUR ALT=SLEEP \
ALT=AGGRIVATION ALT=WEAKNESS ALT=DISPEL MULTICHOICE) \
COVER \
NOTPORT \
TOWN \
INVADER \
TEXTWORD \
MON0 \
NAME0 \
MON1 \
NAME1 \
MON2 \
NAME2 \
MON3 \
NAME3 \
MON4 \
NAME4 \
ECHANCE \
DONE(ALT=SAVE ALT=QUIT MULTICHOICE)";

char room_edit_format[] =
	"TYPE=%s%c"
	"DESC0=%s%c"
	"DESC1=%s%c"
	"DESC2=%s%c"
	"DESC3=%s%c"
	"DESC4=%s%c"
	"DESC5=%s%c"
	"NEXIT=%d%c"
	"SEXIT=%d%c"
	"EEXIT=%d%c"
	"WEXIT=%d%c"
	"UEXIT=%d%c"
	"DEXIT=%d%c"
	"OEXIT=%d%c"
	"NVIS=%c%c"
	"SVIS=%c%c"
	"EVIS=%c%c"
	"WVIS=%c%c"
	"UVIS=%c%c"
	"DVIS=%c%c"
	"OVIS=%c%c"
	"ARTICLE=%s%c"
	"ADJ=%s%c"
	"NOUN=%s%c"
	"SPECTO=%d%c"
	"SPECVIS=%c%c"
	"SPECTYPE=%s%c"
	"FILTER=%s%c"
	"TRAP=%s%c"
	"COVER=%d%c"
	"NOTPORT=%c%c"
	"TOWN=%c%c"
	"INVADER=%c%c"
	"TEXTWORD=%s%c"
	"MON0=%d%c"
	"NAME0=%s%c"
	"MON1=%d%c"
	"NAME1=%s%c"
	"MON2=%d%c"
	"NAME2=%s%c"
	"MON3=%d%c"
	"NAME3=%s%c"
	"MON4=%d%c"
	"NAME4=%s%c"
	"ECHANCE=%d%c";

char item_screen_spec[] = "\
ARTICLE \
ADJ \
NAME \
TYPE(ALT=EDGED ALT=BLUNT ALT=MAGICDEV ALT=ARMOR ALT=SHIELD ALT=POLE \
ALT=CASH ALT=JEWELS ALT=TRINKET ALT=UNARMED ALT=CONTAINER ALT=TALISMAN \
ALT=TRANSPORTER ALT=AMULET ALT=PSYFOCUS MULTICHOICE) \
SUBTYPE(ALT=N/A ALT=TWOHANDWEP ALT=LITEARMOR ALT=LITEWEP ALT=SKELETONKEY \
ALT=SCROLL ALT=NODROPSHIELD ALT=LITESHIELD ALT=MAGICRING ALT=MAGICBOX \
ALT=SPECIALKEY ALT=PUZZLEPIECE MULTICHOICE) \
LEVEL \
PERM(ALT=N ALT=Y MULTICHOICE) \
REPAIR(ALT=N ALT=Y MULTICHOICE) \
TEXT(ALT=N ALT=Y MULTICHOICE) \
INSTABLE(ALT=N ALT=Y MULTICHOICE) \
INSTILL(ALT=N ALT=Y MULTICHOICE) \
INFUSES(ALT=N ALT=Y MULTICHOICE) \
RACE \
CLASS \
STATIC(ALT=N ALT=Y MULTICHOICE) \
VALUE \
USES \
HITS \
AC \
BONUS \
DONE(ALT=SAVE ALT=QUIT MULTICHOICE)";

char item_edit_format[] =
	"ARTICLE=%s%c"
	"ADJ=%s%c"
	"NAME=%s%c"
	"TYPE=%s%c"
	"SUBTYPE=%s%c"
	"LEVEL=%d%c"
	"PERM=%c%c"
	"REPAIR=%c%c"
	"TEXT=%c%c"
	"INSTABLE=%c%c"
	"INSTILL=%c%c"
	"INFUSES=%c%c"
	"RACE=%c%c"
	"CLASS=%c%c"
	"STATIC=%c%c"
	"VALUE=%ld%c"
	"USES=%ld%c"
	"HITS=%d%c"
	"AC=%d%c"
	"BONUS=%d%c";

/**************************************************************************
	initialization routine
*/
#ifdef SOC2
void EXPORT init__muisoc(void)
#else
void EXPORT init__muichaos(void)
#endif
{
	short   i;
	MLONG   used = 0;

	sprintf(str, "Initializing %s", VERSION);
	NOTIFY(str);

#ifdef SOC2
	i = open("MUISOC.DLL", O_RDONLY); 
#else
	i = open("MUICHAOS.DLL", O_RDONLY);
#endif

	if (i)
	{
		getftime(i, &ftimep);
		close(i);
	}

#ifdef SOC2
	stzcpy(angmod.descrp, gmdnam("MUISOC.MDF"), MNMSIZ);
#else
	stzcpy(angmod.descrp, gmdnam("MUICHAOS.MDF"), MNMSIZ); 
#endif 

	my_module = register_module(&angmod);

	globals = (struct globals_struct *) alczer(GLOBALS_SIZE);
	used += GLOBALS_SIZE;

#ifdef SOC2
	mui_cfg = opnmsg("MUISOC.MCV");
#else
	mui_cfg = opnmsg("MUICHAOS.MCV"); 
#endif

	globals->actcode = stgopt(VALIDUS);
	Check_Validus(TRUE);
	
	globals->maxroom = numopt(MAXROOM, -32767, 32767);
	globals->maxmon = numopt(MAXMON, -32767, 32767);
	globals->maxitem = numopt(MAXITEM, -32767, 32767);

	Set_Globals();
	randomize();    
	Init_Data_Files();
	Open_Data_Files();

	dclvda(PUBLIC_MSG_SIZE);
	dclvda(MSG_SIZE);
	dclvda(EDIT_INFO_SIZE);
	dclvda(POOBAH_SIZE);
	dclvda(fsdroom(MSG1421A, guy_screen_spec, 0));
	dclvda(fsdroom(MSG1428, mon_screen_spec, 0));
	dclvda(fsdroom(MSG1443, room_screen_spec, 0));
	dclvda(fsdroom(MSG1459B, item_screen_spec, 0));

	invasion = (struct invasion_struct *) alczer(INVASION_SIZE);
	used += INVASION_SIZE;

	temp_char = (struct charstruct *) alczer(CHAR_SIZE);
	used += CHAR_SIZE;

	a_closet = (struct closet_struct *) alczer(CLOSET_SIZE);
	used += CLOSET_SIZE;

	free_bags = (struct free_bag_struct *) alczer(FREE_BAG_SIZE);
	used += FREE_BAG_SIZE;

	a_container = (struct container_struct *) alczer(CONTAINER_SIZE);
	used += CONTAINER_SIZE;

	a_bag = (struct container_struct *) alczer(CONTAINER_SIZE);
	used += CONTAINER_SIZE;
	
	guild = (struct guild_info_struct *) alczer(GUILD_INFO_SIZE);
	used += GUILD_INFO_SIZE;

	pursuers = (struct pursuer_struct *) alczer(PURSUER_SIZE);
	used += PURSUER_SIZE;

	for (i = 0; i != NTERMS + 1; ++i)
	{
		macros[i] = (struct macro_struct *) alczer(MACRO_SIZE);
		used += MACRO_SIZE;
	}

	for (i = 0; i != globals->cachbufs; ++i)
	{
		room_cache[i] = (struct room_cache_struct *) alczer(ROOM_CACHE_SIZE);
		used += ROOM_CACHE_SIZE;
	}

	for (B = 0; B != NTERMS + 1; ++B)
	{
		BUF[B] = (struct room_buffer_struct *) alczer(BUF_SIZE);
		used += BUF_SIZE;
	}
	
	for (P = 0; P != NTERMS + 1; ++P)
	{
		PORT[P] = (struct port_struct *) alczer(PORT_SIZE);
		used += PORT_SIZE;
	}
	
	used = used / 1000;

	if (globals->validus_users)
	{
		if (!globals->demo)
		{
			sprintf
			(
				str, 
				"%d/%d Users, Alloc'd %ldK", 
				globals->maxuser - 1, 
				globals->validus_users - 1,
				used
			);
		}
		else 
		{
			sprintf
			(
				str, 
				"%d Users, Alloc'd %ldK", 
				globals->maxuser - 1,
				used
			);
		}

		NOTIFY(str);
	}
	else
	{
		sprintf(str, "Allocated %ldK", used);
		NOTIFY(str);
	}
	
	Init_Guild_Stuff();
	Init_Perm_Mon();
	Init_Items();
	Init_Rooms();
	Init_Poobahs(); 
	Vote_Check();
	Close_Non_Mastered_Guilds();
	Sort_Spell_Info();

	invasion->active = FALSE;
	invasion->timer = numopt(BTWNINV, -32767, 32767) * 60;

	register_textvar("SOCBLURB", tvar_socblurb);
	register_textvar("SOCVER", tvar_socver);
	NOTIFY("Done Initializing");
}
/**************************************************************************
	logon entry point
*/
GBOOL EXPORT chaos_login(void)
{    
	short   index;

	if (usrptr->flags&WSGCSU)
	{
		return (FALSE);
	}

	if (globals->blurbon)
	{
		userid = usaptr->userid;
		index = Find_A_Char(&a_char, NULL);

		if (index < 0)
		{
			prf(globals->blurb);
			outprf(usrnum);
			clrprf();
		}
	}

	return (FALSE);
}
/**************************************************************************
	chaos status
*/
void EXPORT chaos_status(void)
{
	short   i;
	short   p = -1;
	short   old_p = P;
	unsigned long active;

	active = usrptr->flags & ACTIVE;

	for (i = 0; i != NTERMS && p < 0; ++i)
	{
		if (APORT(i)->status && APORT(i)->usrnum == usrnum)
		{
			p = i;
		}
	}

	if (p != -1 && status == 5)
	{
		Set_His_Prompt(p);
		prf("%s%s", APORT(p)->prompt, cyan);
		btuoes(usrnum, 0);
		outprf(usrnum);
		clrprf();
		APORT(p)->need_lf = TRUE;
	}
	else if (status == MYCYCLE && globals->poobing[usrnum])
	{
		P = p;
		Next_Poobah();
		P = old_p;
		if (prfbuf[0])
		{
			outprf(usrnum);
			clrprf();
		}
	}
	else if (status == MYCYCLE && globals->eviling[usrnum])
	{
		P = p;
		Next_Evil();
		P = old_p;
		if (prfbuf[0])
		{
			outprf(usrnum);
			clrprf();
		}
	}
	else if (p != -1 && status == MYCYCLE && APORT(p)->turfing)
	{
		setmbk(mui_cfg);
		P = p;
		Next_Turf();
		P = old_p;
		rstmbk();
	}
	else if (p != -1 && status == MYCYCLE && APORT(p)->finding)
	{
		setmbk(mui_cfg);
		P = p;
		Find_Stuff();
		P = old_p;
		rstmbk();
	}
	else
	{
		dfsthn();
	}
	
	if (usrptr->flags&ACTIVE)
	{
		usrptr->flags = usrptr->flags ^ ACTIVE;
	}

	usrptr->flags |= active;
}
/**************************************************************************
	user is signing on
*/
short Greet_User(void)
{
	short   i;
	short   j;
	short   index;
	char    ch;    
	char    name[NAME_LEN];

	if
	(
		STATE == DISPLAYING_POOBAHS ||
		STATE == DISPLAYING_OBITS ||
		STATE == DISPLAYING_FAME ||
		STATE == DISPLAYING_WHERE
	)
	{
		STATE = 0;

		if (margc)
		{
			ch = toupper(margv[0][0]);
		}
	}
	else if (STATE == 0 && usrptr->flags&CONCEX)    
	{
		bgncnc();

		if (morcnc())
		{
			cncchr();

			if (morcnc())
			{
				ch = cncchr();
				STATE = MAIN_MENU_PROMPT;
			}
			else
			{
				ch = 0;
			}
		}
		else
		{
			ch = 0;
		}

		endcnc();
		ch = toupper(ch);
	}
	else if (margc)
	{
		ch = toupper(margv[0][0]);
	}

	if (STATE == ENTERING_CLASS_PROMPT || STATE == ENTERING_RACE_PROMPT)
	{
		if (margc == 0 || ch == 'X')
		{
			STATE = 0;
		}
		else
		{
			index = Find_A_Char(&a_char, NULL);

			if (STATE == ENTERING_CLASS_PROMPT)
			{
				a_char.class = ch;
				Set_Class();
			}
			else
			{
				a_char.race = ch;
				Set_Race();
			}
			
			Write_A_Char(index, &a_char);
			
			if (today() != a_char.last_date)
			{
				a_char.secs_today = 0;
			}
			
			Sign_Me_On
			(
				a_char.perm[INVIS_PORT_PERM], 
				a_char.perm[INTERCEPT_PERM],
				a_char.name, 
				a_char.title,
				a_char.class,
				a_char.Option[NO_COLOR],
				a_char.race,
				a_char.suspended,
				index,
				a_char.secs_today
			);

			if (P == -1)
			{
				return (FALSE);
			}
			else if (P == -2)
			{
				STATE = ENTERING_CLASS_PROMPT;
				return (TRUE);
			}
			else if (P == -3)
			{
				STATE = ENTERING_RACE_PROMPT;
				return (TRUE);
			}

			me = a_char;
			MY_PORT->index = index;
			Newday(1);
			return (TRUE);
		}
	}

	if (STATE == MAIN_MENU_PROMPT)
	{
		if (ch == 'E' || ch == 'B' || ch == 'A' || ch == 'M' || ch == 'T')
		{
			globals->destination[usrnum] = ch;
			STATE = ENTERING_CHAOS;
			margc = 0;
		}
		else if (ch == 'P')
		{
			prf("%s", CLEAR_SCREEN);
			Poobahs();
			STATE = DISPLAYING_POOBAHS;
		}
		else if (ch == 'W')
		{
			prf("%s", CLEAR_SCREEN);
			P = -1;
			where();
			prf("\rPress [ENTER]: ");
			STATE = DISPLAYING_WHERE;
		}
		else if (ch == 'N')
		{
			prf("%s", CLEAR_SCREEN);
			btuxnf(usrnum, 0, 19);
			Display_Obits();
			prf("\rPress [ENTER]: ");
			STATE = DISPLAYING_OBITS;
		}
		else if (ch == 'H')
		{
			prf("%s", CLEAR_SCREEN);
			Hall_Of_Fame(0);
			prf("\rPress [ENTER]: ");
			STATE = DISPLAYING_FAME;
		}
		else if (ch == 'C')
		{
			index = Find_A_Char(&a_char, NULL);

			if (index >= 0)
			{
				prfmsg(MSG1567);
				STATE = SUICIDE_PROMPT;
			}
			else
			{
				prfmsg(MSG1566);
				prfmsg(TOPPRMPT);
			}
		}
		else if (ch == 'S')
		{
			index = Find_A_Char(&a_char, NULL);

			if (index >= 0) 
			{
				if (a_char.class == 'X')
				{
					prfmsg(MSG1574);
					prfmsg(TOPPRMPT);
				}
				else
				{
					Switch(0);

					if (STATE != SWITCH_PROMPT)
					{
						prfmsg(TOPPRMPT);
					}
				}
			}
			else
			{
				prfmsg(MSG1566);
				prfmsg(TOPPRMPT);
			}
		}
		else if (ch == 'O')
		{
			index = Find_A_Char(&a_char, NULL);

			if (index >= 0) 
			{
				Outlaw(0);

				if (STATE != OUTLAW_PROMPT)
				{
					prfmsg(TOPPRMPT);
				}
			}
			else
			{
				prfmsg(MSG1566);
				prfmsg(TOPPRMPT);
			}
		}
		else if (ch == 'R')
		{
			index = Find_A_Char(&a_char, NULL);

			if (index >= 0) 
			{
				prfmsg(MSG1583);
				STATE = RENAME_PROMPT;
			}
			else
			{
				prfmsg(MSG1566);
				prfmsg(TOPPRMPT);
			}
		}
		else if 
		(
			ch == '0' ||
			ch == '1' ||
			ch == '2' ||
			ch == '3' ||
			ch == '4' ||
			(ch == '5' && globals->sysopkey[0] && haskey(globals->sysopkey)) ||
			ch == '6' || 
			ch == '7'
		)
		{
			if (ftgnew() == 0)
			{
				ftgsbm("");
				STATE = 0;
			}
			else
			{
				STATE = 1;

				if (ch == '0')
				{
					stzcpy(ftgptr->tagspc, START_HELP_FILE, TSLENG);
				}
				else if (ch == '1')
				{
#ifdef SOC2
					stzcpy(ftgptr->tagspc, "MUISOC.DOC", TSLENG);
#else
					stzcpy(ftgptr->tagspc, "MUICHAOS.DOC", TSLENG); 
#endif
				}
				else if (ch == '2')
				{
					stzcpy(ftgptr->tagspc, MAGIC_HELP_FILE, TSLENG);
				}
				else if (ch == '3')
				{
					stzcpy(ftgptr->tagspc, CLASS_HELP_FILE, TSLENG);
				}
				else if (ch == '4')
				{
					stzcpy(ftgptr->tagspc, HINTS_FILE, TSLENG);
				}
				else if (ch == '5')
				{
					stzcpy(ftgptr->tagspc, SYSOP_HELP_FILE, TSLENG);
				}
				else if (ch == '6')
				{
					stzcpy(ftgptr->tagspc, MAP_FILE, TSLENG);
				}
				else if (ch == '7')
				{
					stzcpy(ftgptr->tagspc, CHANGE_LOG, TSLENG);
				}

				ftgptr->tshndl = Download_Handler;
				ftgsbm("?");
				return (-1);
			}
		}
		else if (ch == 'X')
		{
			return (FALSE);
		}
		else
		{
			STATE = 0;
		}
	}

	if 
	(
		STATE == 0 || 
		(STATE == MAIN_MENU_PROMPT && margc != 0 && ch == '?')
	)
	{
		if (usrptr->flags&CONCEX)
		{
			btuchi(usrnum, NULL); 
			return (FALSE);
		}
		else
		{
			Main_Menu();
		}
	}

	if (STATE == ENTERING_CHAOS)
	{
		index = Find_A_Char(&a_char, NULL);

		if (index >= 0)
		{
			if (today() != a_char.last_date)
			{
				a_char.secs_today = 0;
			}

			Sign_Me_On
			(
				a_char.perm[INVIS_PORT_PERM], 
				a_char.perm[INTERCEPT_PERM],
				a_char.name, 
				a_char.title,
				a_char.class,
				a_char.Option[NO_COLOR],
				a_char.race,
				a_char.suspended,
				index,
				a_char.secs_today
			);

			if (P == -1)
			{
				return (FALSE);
			}
			
			if (P == -2)
			{
				STATE = ENTERING_CLASS_PROMPT;
				return (TRUE);
			}
			
			if (P == -3)
			{
				STATE = ENTERING_RACE_PROMPT;
				return (TRUE);
			}

			me = a_char;
			MY_PORT->index = index;
			Newday(1);
		}
		else if (margc == 0)
		{
			prfmsg(MSG394);
		}
		else
		{
			rstrin();
			strncpy(name, input, globals->namesize);
			name[globals->namesize] = 0;

			for (i = 0; i != NAME_LEN && name[i] != 0; ++i)
			{   
				if (name[i] <= ' ' || name[i] > '~')
				{
					name[i] = '_';
				}
				else
				{
					for (j = 0; j != strlen(globals->badchars); ++j)
					{
						if (name[i] == globals->badchars[j])
						{
							name[i] = '_';
						}
					}
				}
			}

			if (sameas(name, "x"))
			{
				return (FALSE);
			}

			index = Find_A_Char(&a_char, name);

			if (sameas(name, BLANK_RECORD) || index != -1)
			{
				prfmsg(M395);
				prfmsg(MSG394);
			}
			else
			{
				New_Guy(name);
				Sign_Me_On(0, 0, name, "Neophyte", 0, 0, 0, 0, -1, 0);

				if (P == -1)
				{
					return (FALSE);
				}
				
				if (P == -2)
				{
					STATE = ENTERING_CLASS_PROMPT;
					return (TRUE);
				}
				
				if (P == -3)
				{
					STATE = ENTERING_RACE_PROMPT;
					return (TRUE);
				}

				MY_PORT->index = Find_A_Char(&a_char, name);
				Newday(1);
				setmem(&macros[P], MACRO_SIZE, 0);
				Erase_Mail(MY_PORT->index);
				Erase_Votes(MY_PORT->index);
			}
		}
	}

	return (TRUE);
}
/**************************************************************************
	called after user enters a line and hits c/r
*/
GBOOL EXPORT chaos_input(void)
{
	short   staying;
	short   i;
	short   found;
	
	setmbk(mui_cfg);
	btuoes(usrnum, 0);
	btutsw(usrnum, 80);
	btuhcr(usrnum, 13);
	btuscr(usrnum, 10);
	usrptr->flags &= ~NOGLOB;

	if (!kicked)
	{
		kicked = TRUE;
		rtkick(1, Chaos_Server);
	}

	userid = usaptr->userid;

	for (i = 0, found = FALSE; i != NTERMS && !found; ++i)
	{
		if (APORT(i)->status && APORT(i)->usrnum == usrnum)
		{
			P = i;
			found = TRUE;
		}
	}

	if (!found)
	{
		if (usrptr->flags&CONCEX && STATE == FINISHED_DOWNLOAD)
		{
			btuchi(usrnum, NULL); 
			outprf(usrnum);
			clrprf();
			rstmbk();
			return (FALSE);
		}

		if (STATE == SUICIDE_PROMPT)
		{
			if (margc && sameas(margv[0], "Y"))
			{
				Suicide();
				prfmsg(TOPPRMPT);
				outprf(usrnum);
				clrprf();
				rstmbk();
				STATE = MAIN_MENU_PROMPT;
				return (TRUE);
			}
			
			Main_Menu();
			outprf(usrnum);
			clrprf();
			rstmbk();
			return (TRUE);
		}

		if (STATE == SWITCH_PROMPT)
		{
			if (margc && sameas(margv[0], "Y"))
			{
				Switch(1);
				prfmsg(TOPPRMPT);
				outprf(usrnum);
				clrprf();
				rstmbk();
				STATE = MAIN_MENU_PROMPT;
				return (TRUE);
			}
			
			Main_Menu();
			outprf(usrnum);
			clrprf();
			rstmbk();
			return (TRUE);
		}

		if (STATE == RENAME_PROMPT)
		{
			Change_Name_Title(STATE);

			if (STATE != RETITLE_PROMPT)
			{
				prfmsg(TOPPRMPT);
				STATE = MAIN_MENU_PROMPT;
			}

			outprf(usrnum);
			clrprf();
			rstmbk();
			return (TRUE);
		}
		
		if (STATE == RETITLE_PROMPT)
		{
			Change_Name_Title(STATE);
			prfmsg(TOPPRMPT);
			outprf(usrnum);
			clrprf();
			rstmbk();
			STATE = MAIN_MENU_PROMPT;
			return (TRUE);
		}

		if (STATE == OUTLAW_PROMPT)
		{
			if (margc && sameas(margv[0], "Y"))
			{
				Outlaw(1);
				prfmsg(TOPPRMPT);
				outprf(usrnum);
				clrprf();
				rstmbk();
				STATE = MAIN_MENU_PROMPT;
				return (TRUE);
			}
			
			Main_Menu();
			outprf(usrnum);
			clrprf();
			rstmbk();
			return (TRUE);
		}

		if (margc == 0 && STATE == MAIN_MENU_PROMPT)
		{
			if (usrptr->flags&CONCEX)
			{
				btuchi(usrnum, NULL); 
				outprf(usrnum);
				clrprf();
				rstmbk();
				return (FALSE);
			}
			else
			{
				Main_Menu();
				outprf(usrnum);
				clrprf();
				rstmbk();
				return (TRUE);
			}
		}

		btuchi(usrnum, escape_key);
		staying = Greet_User();

		if (staying == -1)
		{
			outprf(usrnum);
			clrprf();
			rstmbk();
			return (TRUE);
		}

		outprf(usrnum);
		clrprf();

		if (!staying)
		{
			STATE = 0;
			btuchi(usrnum, NULL);
		}

		rstmbk();
		return (staying);
	}
	
	btuxnf(usrnum, 0, 19);

	if (MY_PORT->big_sleep)
	{
		Write_My_Rec(SUICIDE);
		rstrxf();
		sign_me_off();

		if (usrptr->flags&CONCEX)
		{
			btuchi(usrnum, NULL); 
			outprf(usrnum);
			clrprf();
			rstmbk();
			return (FALSE);
		}
		else
		{
			Main_Menu();
			outprf(usrnum);
			clrprf();
			rstmbk();
			return (TRUE);
		}
	}

	B = MY_PORT->B;
	btuchi(usrnum, escape_key);
	MY_PORT->need_lf = TRUE;

	if
	(
		margc == 0 &&
		MY_PORT->status != MERC_PROMPT &&
		MY_PORT->status != MERC_PROMPT1 &&
		MY_PORT->status != MERC_PROMPT2 &&
		MY_PORT->status != TREASURY_PROMPT &&
		MY_PORT->status != TREASURY_PROMPT1 &&
		MY_PORT->status != TREASURY_PROMPT2 &&
		MY_PORT->status != TREASURY_PROMPT3 &&
		MY_PORT->status != TREASURY_PROMPT4 &&
		MY_PORT->status != ANNOUNCE_PROMPT &&
		MY_PORT->status != ACADEMY_PROMPT &&
		MY_PORT->status != ACADEMY_PROMPT1 &&
		MY_PORT->status != ACADEMY_PROMPT2 &&
		MY_PORT->status != BANK_PROMPT &&
		MY_PORT->status != BANK_PROMPT1 &&
		MY_PORT->status != BANK_PROMPT2 &&
		MY_PORT->status != BANK_PROMPT3 &&
		MY_PORT->status != BANK_PROMPT4 &&
		MY_PORT->status != BANK_PROMPT5 &&
		MY_PORT->status != SCRAWL_PROMPT &&
		MY_PORT->status != EDIT_GUY_PROMPT1 &&
		MY_PORT->status != EDIT_GUY_PROMPT2 &&
		MY_PORT->status != EDIT_GUY_PROMPT3 &&
		MY_PORT->status != EDIT_GUY_PROMPT4 &&
		MY_PORT->status != EDIT_GUY_PROMPT5 &&
		MY_PORT->status != EDIT_STORE_PROMPT &&
		MY_PORT->status != EDIT_ROOM_PROMPT1 &&
		MY_PORT->status != EDIT_ROOM_PROMPT3 && 
		MY_PORT->status != EDIT_ROOM_PROMPT5 && 
		MY_PORT->status != EDIT_ROOM_PROMPT7 && 
		MY_PORT->status != EDIT_ROOM_PROMPT9 && 
		MY_PORT->status != EDIT_ROOM_PROMPT11 && 
		MY_PORT->status != EDIT_ROOM_PROMPT13 && 
		MY_PORT->status != EDIT_ROOM_PROMPT15 && 
		MY_PORT->status != EDIT_ITEM_PROMPT1 &&
		MY_PORT->status != EDIT_ITEM_PROMPT2 &&
		MY_PORT->status != EDIT_ITEM_PROMPT3 &&
		MY_PORT->status != EDIT_ITEM_PROMPT4 &&
		MY_PORT->status != EDIT_ITEM_PROMPT5 &&
		MY_PORT->status != EDIT_ITEM_PROMPT6 &&
		MY_PORT->status != EDIT_ITEM_PROMPT7 &&
		MY_PORT->status != EDIT_ITEM_PROMPT9 &&
		MY_PORT->status != EDIT_ITEM_PROMPT11 &&
		MY_PORT->status != EDIT_ITEM_PROMPT13 &&
		MY_PORT->status != EDIT_ITEM_PROMPT14 &&
		MY_PORT->status != EDIT_ITEM_PROMPT16 &&
		MY_PORT->status != EDIT_MON_PROMPT1 &&
		MY_PORT->status != EDIT_MON_PROMPT3 &&
		MY_PORT->status != EDIT_MON_PROMPT5 &&
		MY_PORT->status != EDIT_MON_PROMPT7 &&
		MY_PORT->status != EDIT_MON_PROMPT9 &&
		MY_PORT->status != EDIT_MON_PROMPT11 &&
		MY_PORT->status != EDIT_MON_PROMPT13 &&
		MY_PORT->status != EDIT_MON_PROMPT15 &&
		MY_PORT->status != EDIT_GUILD_PROMPT &&
		MY_PORT->status != ORACLE_PROMPT &&
		MY_PORT->status != HUNTRESS_PROMPT &&
		MY_PORT->status != EDIT_PERM_PROMPT &&
		MY_PORT->status != EDIT_OFFICE_PROMPT &&
		MY_PORT->status != REPORT_PROMPT &&
		MY_PORT->status != VOTE_PROMPT &&
		MY_PORT->status != VOTE_NAME_PROMPT &&
		MY_PORT->status != ABDICATE_PROMPT &&
		MY_PORT->status != GUILD_SELL_PROMPT &&
		MY_PORT->status != INVASION_MON_PROMPT &&
		MY_PORT->status != INVASION_LEVEL_PROMPT &&
		MY_PORT->status != INVASION_MINS_PROMPT &&
		MY_PORT->status != INVASION_SIZE_PROMPT &&
		MY_PORT->status != INVASION_HEIR_PROMPT &&
		MY_PORT->status != INVASION_ROOM_PROMPT &&
		MY_PORT->status != READ_FORUM_PROMPT &&
		MY_PORT->status != READ_GUILD_FORUM_PROMPT &&
		MY_PORT->status != GAMEOP_PROMPT &&
		MY_PORT->status != LOCATE_ITEM_PROMPT &&
		MY_PORT->status != LOCATE_MON_PROMPT &&
		MY_PORT->status != CREATE_NUM_PROMPT &&
		MY_PORT->status != CREATE_LEVEL_PROMPT &&
		MY_PORT->status != ZAP_PROMPT &&
		MY_PORT->status != SUSPEND_PROMPT &&
		MY_PORT->status != BOUNTY_PROMPT1 &&
		MY_PORT->status != BOUNTY_PROMPT2 &&
		MY_PORT->status != PERMIT_PROMPT &&
		MY_PORT->status != GUILD_PROMPT &&
		MY_PORT->status != MEMBER_PROMPT &&
		MY_PORT->status != ACCEPT_PROMPT &&
		MY_PORT->status != BLACKBALL_PROMPT &&
		MY_PORT->status != APPOINT_PROMPT &&
		MY_PORT->status != DEBT_PROMPT1 &&
		MY_PORT->status != DEBT_PROMPT2 &&
		MY_PORT->status != OFFICE_PROMPT &&
		MY_PORT->status != MAIL_PROMPT &&
		MY_PORT->status != POST_GUILD_PROMPT &&
		MY_PORT->status != FORUM_PROMPT &&
		MY_PORT->status != GUILD_FORUM_PROMPT &&
		MY_PORT->status != CENSOR_PROMPT &&
		MY_PORT->status != POST_PROMPT &&
		MY_PORT->status != IMPEACH_PROMPT &&
		MY_PORT->status != ARREST_PROMPT1 &&
		MY_PORT->status != ARREST_PROMPT2 &&
		MY_PORT->status != PARDON_PROMPT1 &&
		MY_PORT->status != PARDON_PROMPT2 &&
		MY_PORT->status != PENALIZE_PROMPT1 &&
		MY_PORT->status != PENALIZE_PROMPT2 &&
		MY_PORT->status != PAROLE_PROMPT &&
		MY_PORT->status != CHANT_PROMPT &&
		MY_PORT->status != FAME_PROMPT &&
		MY_PORT->status != BET_PROMPT
	)
	{
		if (MY_PORT->status == DO_PROMPT && !(usrptr->flags&INJOIP))
		{
			MY_PORT->last_bp = -1;
			MY_PORT->show_pts = TRUE;
			i = me.Option[HEALTH_STATUS];
			me.Option[HEALTH_STATUS] = TRUE;
			Set_Main_Prompt();
			me.Option[HEALTH_STATUS] = i;
		}
		else
		{
			Set_His_Prompt(P);
			prf("%s", MY_PORT->prompt);
		}

		outprf(usrnum);
		clrprf();
		rstmbk();
		return (TRUE);
	}

	if 
	(
		MY_PORT->status == DO_PROMPT && 
		(globals->poobing[usrnum] ||
		 globals->eviling[usrnum] ||
		 MY_PORT->turfing ||
		 MY_PORT->finding)
	)
	{
		globals->poobing[usrnum] = FALSE;
		globals->eviling[usrnum] = FALSE;
		MY_PORT->turfing = FALSE;
		MY_PORT->finding = FALSE;
		prfmsg(M1373);
	}
	else if (MY_PORT->status == DO_PROMPT)
	{
		Misc_Checks();
		if (me.in_guild)
		{
			check_turf();
		}

		command = 0;
			
		if (MY_PORT->trance)
		{
			prfmsg(MSG396);
			MY_PORT->trance = FALSE;
		}
		
		Macro_Check();

		if (sameas(margv[0], globals->againkey))
		{
			prfmsg(MSSG397, MY_PORT->last_input);

			if (MY_PORT->last_input[0] != 0)
			{
				strcpy(input, MY_PORT->last_input);
			}
		}
		else
		{
			rstrin();
			strncpy(MY_PORT->last_input, input, LINE_LEN - 1);
			MY_PORT->last_input[LINE_LEN - 1] = 0;
			MY_PORT->next_input[0] = 0;
		}

		parsin();
		Unique_Check();

		if (command)
		{
			do_command();
		}
	}
	else if (MY_PORT->status == GUILD_PROMPT)
	{
		if (margc == 0)
		{
			Guild_Menu(0);
		}
		else if (sameas(margv[0], "X"))
		{
			MY_PORT->hot_menu = FALSE;
			MY_PORT->status = DO_PROMPT;
		}
		else
		{
			Guild_Menu(2);
		}
	}
	else if (MY_PORT->status == DEBT_PROMPT1)
	{
		if (margc == 0)
		{
			Guild_Menu(1);
		}
		else
		{
			MY_PORT->misc = Find_A_Char(&a_char, margv[0]);

			if (MY_PORT->misc < 0)
			{
				prfmsg(M920, margv[0]);
				Guild_Menu(1);
			}
			else if (a_char.in_guild != me.in_guild)
			{
				prfmsg(M734, a_char.name);
				Guild_Menu(1);
			}
			else
			{
				Set_Prompt(getmsg(MSG1406), DEBT_PROMPT2);
			}
		}
	}
	else if (MY_PORT->status == DEBT_PROMPT2)
	{
		if (margc)
		{
			Change_Debt();
		}

		Guild_Menu(1);
	}
	else if (MY_PORT->status == ACCEPT_PROMPT)
	{
		if (margc)
		{
			Accept();
		}

		Guild_Menu(1);
	}
	else if (MY_PORT->status == BLACKBALL_PROMPT)
	{
		if (margc)
		{
			Black_Ball();
		}

		Guild_Menu(1);
	}
	else if (MY_PORT->status == APPOINT_PROMPT)
	{
		if (margc)
		{
			Appoint_Guild_Master();
		}

		Guild_Menu(1);
	}
	else if (MY_PORT->status == ACADEMY_PROMPT)
	{
		if (margc == 0)
		{
			prfmsg(MSG1587);
			Set_Prompt(getmsg(MSG1588), ACADEMY_PROMPT);
		}
		else if (sameas(margv[0], "X") || ABUF(B)->rm.rmtype != ACADEMY)
		{
			MY_PORT->status = DO_PROMPT;
		}
		else
		{
			if (sameas(margv[0], "Q"))
			{
				Display_Quests(ACTIVE_QUESTS);
				Display_Quests(INACTIVE_QUESTS);
				Set_Prompt(getmsg(MSG1588), ACADEMY_PROMPT);
			}
			else if (sameas(margv[0], "T"))
			{
				Display_Quests(ACTIVE_QUESTS);
				Display_Quests(INACTIVE_QUESTS);
				Set_Prompt(getmsg(MSG1589), ACADEMY_PROMPT1);
			}
			else if (sameas(margv[0], "C"))
			{
				Display_Quests(ACTIVE_QUESTS);
				Display_Quests(INACTIVE_QUESTS);
				Set_Prompt(getmsg(MSG1591), ACADEMY_PROMPT2);
			}
			else
			{
				Set_Prompt(getmsg(MSG1588), ACADEMY_PROMPT); 
			}
		}
	}
	else if (MY_PORT->status == ACADEMY_PROMPT1)
	{
		if (margc != 0)
		{
			if (sameas(margv[0], "?"))
			{
				prfmsg(MSG1590);
				Set_Prompt(getmsg(MSG1589), ACADEMY_PROMPT1);
			}
			else
			{
				Train();
				Set_Prompt(getmsg(MSG1588), ACADEMY_PROMPT);
			}
		}
		else
		{
			Set_Prompt(getmsg(MSG1588), ACADEMY_PROMPT);
		}
	}
	else if (MY_PORT->status == ACADEMY_PROMPT2)
	{
		if (margc != 0)
		{
			if (sameas(margv[0], "?"))
			{
				prfmsg(MSG1592);
				Set_Prompt(getmsg(MSG1591), ACADEMY_PROMPT2);
			}
			else
			{
				Train();
				Set_Prompt(getmsg(MSG1588), ACADEMY_PROMPT);
			}
		}
		else
		{
			Set_Prompt(getmsg(MSG1588), ACADEMY_PROMPT);
		}
	}
	else if (MY_PORT->status == BANK_PROMPT)
	{
		if (margc == 0)
		{
			prfmsg(MSG1504, l2as(me.bank), l2as(me.gold));
			if (me.in_guild)
			{
				prfmsg
				(
					MSG1505, 
					l2as(me.guild_balance), 
					l2as(guild->treasury[me.in_guild])
				);
			}
			prfmsg(MSG1506);
			Set_Prompt(getmsg(MSG1507), BANK_PROMPT);
		}
		else if (sameas(margv[0], "X") || ABUF(B)->rm.rmtype != BANK)
		{
			MY_PORT->status = DO_PROMPT;
		}
		else
		{
			if (sameas(margv[0], "D"))
			{
				if (me.gold == 0)
				{
					prfmsg(MSG1508);
				}
				else
				{
					Bank_Deposit();
				}

				Set_Prompt(getmsg(MSG1507), BANK_PROMPT);
			}
			else if (sameas(margv[0], "W"))
			{
				if (!me.perm[GAMEOP_PERM] && me.Int < globals->minint)
				{
					prfmsg(MSG1512, globals->minint);
					Set_Prompt(getmsg(MSG1507), BANK_PROMPT);
				}
				else if 
				(
					!me.perm[GAMEOP_PERM] &&
					me.race == HUMAN && 
					me.Int - 10 < globals->minint
				)
				{
					prfmsg(MSG1512, globals->minint + 10);
					Set_Prompt(getmsg(MSG1507), BANK_PROMPT);
				}
				else
				{
					Set_Prompt(getmsg(MSG1511), BANK_PROMPT1);
				}
			}
			else if (sameas(margv[0], "T"))
			{
				if (!me.perm[GAMEOP_PERM] && me.Int < globals->minint)
				{
					prfmsg(MSG1512, globals->minint);
					Set_Prompt(getmsg(MSG1507), BANK_PROMPT);
				}
				else if 
				(
					!me.perm[GAMEOP_PERM] &&
					me.race == HUMAN && 
					me.Int - 10 < globals->minint
				)
				{
					prfmsg(MSG1512, globals->minint + 10);
					Set_Prompt(getmsg(MSG1507), BANK_PROMPT);
				}
				else
				{
					Set_Prompt(getmsg(MSG1517), BANK_PROMPT2);
				}
			}
			else if (sameas(margv[0], "G"))
			{
				if (!me.in_guild)
				{
					prfmsg(M727);
					Set_Prompt(getmsg(MSG1507), BANK_PROMPT);
				}
				else if (!me.perm[GAMEOP_PERM] && me.Int < globals->minint)
				{
					prfmsg(MSG1512, globals->minint);
					Set_Prompt(getmsg(MSG1507), BANK_PROMPT);
				}
				else if 
				(
					!me.perm[GAMEOP_PERM] &&
					me.race == HUMAN && 
					me.Int - 10 < globals->minint
				)
				{
					prfmsg(MSG1512, globals->minint + 10);
					Set_Prompt(getmsg(MSG1507), BANK_PROMPT);
				}
				else
				{
					Set_Prompt(getmsg(MSG1518), BANK_PROMPT4);
				}
			}
			else
			{
				Set_Prompt(getmsg(MSG1507), BANK_PROMPT);
			}
		}
	}
	else if (MY_PORT->status == BANK_PROMPT1)
	{
		if (margc != 0)
		{
			Bank_Withdrawl();
		}

		Set_Prompt(getmsg(MSG1507), BANK_PROMPT);
	}
	else if (MY_PORT->status == BANK_PROMPT2)
	{
		if (margc != 0)
		{
			Transfer_Funds(FROM_BANK);
		}
		else
		{
			Set_Prompt(getmsg(MSG1507), BANK_PROMPT);
		}
	}
	else if (MY_PORT->status == BANK_PROMPT3)
	{
		if (margc != 0)
		{
			Transfer_Funds(FROM_BANK);
		}
		
		Set_Prompt(getmsg(MSG1507), BANK_PROMPT);
	}
	else if (MY_PORT->status == BANK_PROMPT4)
	{
		if (margc != 0)
		{
			Transfer_To_Guild();
		}
		
		Set_Prompt(getmsg(MSG1507), BANK_PROMPT);
	}
	else if (MY_PORT->status == BANK_PROMPT5)
	{
		if (margc != 0 && sameas(margv[0], "Y"))
		{
			Bank_Deposit();
		}

		prfmsg(M1503);
		MY_PORT->status = DO_PROMPT;
	}
	else if (MY_PORT->status == TREASURY_PROMPT)
	{
		if (margc == 0)
		{
			prfmsg(MSG1504, l2as(me.bank), l2as(me.gold));
			prfmsg
			(
				MSG1505, 
				l2as(me.guild_balance), 
				l2as(guild->treasury[me.in_guild])
			);
			prfmsg(MSG1524);
			Set_Prompt(getmsg(MSG1507), TREASURY_PROMPT);
		}
		else if (sameas(margv[0], "X") || !IN_GUILD)
		{
			MY_PORT->status = DO_PROMPT;
		}
		else
		{
			if (sameas(margv[0], "D"))
			{
				if (me.gold == 0)
				{
					prfmsg(MSG1508);
				}
				else
				{
					Guild_Deposit();
				}

				Set_Prompt(getmsg(MSG1507), TREASURY_PROMPT);
			}
			else if (sameas(margv[0], "W"))
			{
				Set_Prompt(getmsg(MSG1511), TREASURY_PROMPT1);
			}
			else if (sameas(margv[0], "T"))
			{
				Set_Prompt(getmsg(MSG1517), TREASURY_PROMPT2);
			}
			else if (sameas(margv[0], "G"))
			{
				if (!me.perm[GAMEOP_PERM] && me.Int < globals->minint)
				{
					prfmsg(MSG1512, globals->minint);
					Set_Prompt(getmsg(MSG1507), TREASURY_PROMPT);
				}
				else if 
				(
					!me.perm[GAMEOP_PERM] &&
					me.race == HUMAN && 
					me.Int - 10 < globals->minint
				)
				{
					prfmsg(MSG1512, globals->minint + 10);
					Set_Prompt(getmsg(MSG1507), TREASURY_PROMPT);
				}
				else
				{
					Set_Prompt(getmsg(MSG1518), TREASURY_PROMPT4);
				}
			}
			else
			{
				Set_Prompt(getmsg(MSG1507), TREASURY_PROMPT);
			}
		}
	}
	else if (MY_PORT->status == TREASURY_PROMPT1)
	{
		if (margc != 0)
		{
			Guild_Withdrawl();
		}

		Set_Prompt(getmsg(MSG1507), TREASURY_PROMPT);
	}
	else if (MY_PORT->status == TREASURY_PROMPT2)
	{
		if (margc != 0)
		{
			Transfer_Funds(FROM_GUILD);
		}
		else
		{
			Set_Prompt(getmsg(MSG1507), TREASURY_PROMPT);
		}
	}
	else if (MY_PORT->status == TREASURY_PROMPT3)
	{
		if (margc != 0)
		{
			Transfer_Funds(FROM_GUILD);
		}
		
		Set_Prompt(getmsg(MSG1507), TREASURY_PROMPT);
	}
	else if (MY_PORT->status == TREASURY_PROMPT4)
	{
		if (margc != 0)
		{
			Transfer_To_Guild();
		}
		
		Set_Prompt(getmsg(MSG1507), TREASURY_PROMPT);
	}
	else if (MY_PORT->status == MERC_PROMPT)
	{
		if (margc == 0)
		{
			prfmsg(MSG1504, l2as(me.bank), l2as(me.gold));
			prfmsg(MSG1526);
			Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
		}
		else if 
		(
			sameas(margv[0], "X") || 
			(
				TYPE != ALCHEMIST &&
				TYPE != ARMORY &&
				TYPE != WEAPONSMITH &&
				TYPE != MERCANTILE &&
				(
					!ABUF(B)->rm.spec_exit.filter || 
					ABUF(B)->rm.spec_exit.filter > NUM_SAVED_PLACES - 1
				)
			)
		)
		{
			MY_PORT->status = DO_PROMPT;
		}
		else
		{
			if (sameas(margv[0], "C"))
			{
				Catalog();
				Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
			}
			else if (sameas(margv[0], "I"))
			{
				Inventory();
				Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
			}
			else if (sameas(margv[0], "B"))
			{
				if (Catalog())
				{
					Set_Prompt(getmsg(MSG1528), MERC_PROMPT1);
				}
				else
				{
					Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
				}
			}
			else if (sameas(margv[0], "S"))
			{
				Inventory();
				
				if
				(
					TYPE == ALCHEMIST ||
					TYPE == ARMORY ||
					TYPE == WEAPONSMITH ||
					TYPE == MERCANTILE
				)
				{
					Set_Prompt(getmsg(MSG1529), MERC_PROMPT2);
				}
				else
				{
					Set_Prompt(getmsg(MSG1533), MERC_PROMPT2);
				}
			}
			else
			{
				Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
			}
		}
	}
	else if (MY_PORT->status == MERC_PROMPT1)
	{
		if 
		(
			TYPE != ALCHEMIST &&
			TYPE != ARMORY &&
			TYPE != WEAPONSMITH &&
			TYPE != MERCANTILE &&
			(
				!ABUF(B)->rm.spec_exit.filter || 
				ABUF(B)->rm.spec_exit.filter > NUM_SAVED_PLACES - 1
			)
		)
		{
			MY_PORT->status = DO_PROMPT;
		}
		else
		{
			if (margc != 0)
			{
				Buy();
			}
		
			if (MY_PORT->hot_menu)
			{
				MY_PORT->hot_menu = FALSE;
				MY_PORT->status = DO_PROMPT;
			}
			else
			{
				Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
			}
		}
	}
	else if (MY_PORT->status == MERC_PROMPT2)
	{
		if 
		(
			TYPE != ALCHEMIST &&
			TYPE != ARMORY &&
			TYPE != WEAPONSMITH &&
			TYPE != MERCANTILE &&
			(
				!ABUF(B)->rm.spec_exit.filter || 
				ABUF(B)->rm.spec_exit.filter > NUM_SAVED_PLACES - 1
			)
		)
		{
			MY_PORT->status = DO_PROMPT;
		}
		else
		{
			if (margc != 0)
			{
				if (sameas(margv[0], "?"))
				{
					prfmsg(MSG1530);
					Set_Prompt(getmsg(MSG1529), MERC_PROMPT2);
				}
				else
				{
					Sell();
				}
			}
			else
			{
				if (MY_PORT->hot_menu)
				{
					MY_PORT->hot_menu = FALSE;
					MY_PORT->status = DO_PROMPT;
				}
				else
				{
					Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
				}
			}
		}
	}
	else if (MY_PORT->status == CONFIRM_SELL_PROMPT)
	{
		if 
		(
			TYPE != ALCHEMIST &&
			TYPE != ARMORY &&
			TYPE != WEAPONSMITH &&
			TYPE != MERCANTILE &&
			(
				!ABUF(B)->rm.spec_exit.filter || 
				ABUF(B)->rm.spec_exit.filter > NUM_SAVED_PLACES - 1
			)
		)
		{
			MY_PORT->status = DO_PROMPT;
		}
		else
		{
			if (sameas(margv[0], "Y"))
			{
				Sell();
			}
			else
			{
				if (MY_PORT->hot_menu)
				{
					MY_PORT->hot_menu = FALSE;
					MY_PORT->status = DO_PROMPT;
				}
				else
				{
					Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
				}
			}
		}
	}
	else if (MY_PORT->status == OFFICE_PROMPT)
	{
		if (margc == 0)
		{
			Office_Menu(0);
		}
		else if (sameas(margv[0], "X"))
		{
			MY_PORT->status = DO_PROMPT;
		}
		else
		{
			Office_Menu(2);
		}
	}
	else if (MY_PORT->status == MAIL_PROMPT)
	{
		if (margc == 0)
		{
			Mail_Menu(0);
		}
		else if (sameas(margv[0], "X"))
		{
			MY_PORT->status = DO_PROMPT;
		}
		else
		{
			Mail_Menu(2);
		}
	}
	else if (MY_PORT->status == POST_GUILD_PROMPT)
	{
		if (margc == 0)
		{
			if (!me.in_guild)
			{
				Guild_Menu(1);
			}
			else
			{
				Post_Forum(me.in_guild);
			}
		}
		else if (sameas(margv[0], "X"))
		{
			Guild_Menu(1);
		}
		else
		{
			i = INUM(margv[0]);

			if (i)
			{
				Post_Forum(i);
			}
			else
			{
				Guild_Menu(1);
			}
		}
	}
	else if (MY_PORT->status == POST_PROMPT)
	{
		if (margc == 0 || sameas(margv[0], "X"))
		{
			Mail_Menu(1);
		}
		else
		{
			Post();
		}
	}
	else if (MY_PORT->status == FORUM_PROMPT)
	{
		if (margc != 0 && sameas(margv[0], "X"))
		{
			Mail_Menu(1);
		}
		else
		{
			Check_Public();
		}
	}
	else if (MY_PORT->status == GUILD_FORUM_PROMPT)
	{
		if (margc != 0 && sameas(margv[0], "X"))
		{
			Guild_Menu(1);
		}
		else
		{
			Check_Guild_Forum();
		}
	}
	else if (MY_PORT->status == CENSOR_PROMPT)
	{
		if (margc == 0 || sameas(margv[0], "X"))
		{
			Mail_Menu(1);
		}
		else
		{
			Censor();
		}
	}
	else if (MY_PORT->status == VOTE_NAME_PROMPT)
	{
		if (margc == 0)
		{
			Office_Menu(1);
		}
		else
		{
			MY_PORT->misc = Find_A_Char(&a_char, margv[0]);
	
			if (MY_PORT->misc < 0)
			{
				prfmsg(M920, word1);
				Office_Menu(1);
			}
			else if 
			(
				globals->outlaws && 
				a_char.outlaw != 'Y' && 
				!me.perm[GAMEOP_PERM]
			)
			{
				prfmsg(MSG1353);
				Office_Menu(1);
			}
			else
			{
				for (i = 0; i != NUM_OFFICES; ++i)
				{
					prfmsg(MSG1169, i + 1, globals->offices[i]);
				}

				sprintf(str, getmsg(MSG1191), a_char.name, NUM_OFFICES);
				Set_Prompt(str, VOTE_PROMPT);
			}
		}
	}
	else if (MY_PORT->status == VOTE_PROMPT)
	{
		if (margc)
		{
			i = INUM(margv[0]);
			
			if (i < 1 || i > NUM_OFFICES)
			{
				prfmsg(M398, NUM_OFFICES);
			}
			else
			{
				Cast_Vote();
			}
		}

		Office_Menu(1);
	}
	else if (MY_PORT->status == IMPEACH_PROMPT)
	{
		if (margc)
		{
			Impeach();
		}
		
		Office_Menu(1);
	}
	else if (MY_PORT->status == ARREST_PROMPT2)
	{
		if (margc)
		{
			MY_PORT->misc3 = LNUM(margv[0]);

			if (MY_PORT->misc3)
			{
				Set_Prompt(getmsg(MSG1411), ARREST_PROMPT1); 
			}
			else
			{
				Office_Menu(1);
			}
		}
		else
		{
			Office_Menu(1);
		}
	}
	else if (MY_PORT->status == ARREST_PROMPT1)
	{
		if (margc)
		{
			if (Arrest())
			{
				MY_PORT->status = DO_PROMPT;
			}
			else
			{
				Office_Menu(1);
			}
		}
		else
		{
			Office_Menu(1);
		}
	}
	else if (MY_PORT->status == PARDON_PROMPT2)
	{
		if (margc)
		{
			MY_PORT->misc = INUM(margv[0]);

			if (MY_PORT->misc)
			{
				Set_Prompt(getmsg(MSG1417), PARDON_PROMPT1); 
			}
			else
			{
				Office_Menu(1);
			}
		}
		else
		{
			Office_Menu(1);
		}
	}
	else if (MY_PORT->status == PARDON_PROMPT1)
	{
		if (margc)
		{
			Pardon();
		}
		
		Office_Menu(1);
	}
	else if (MY_PORT->status == PENALIZE_PROMPT2)
	{
		if (margc)
		{
			MY_PORT->misc = INUM(margv[0]);

			if (MY_PORT->misc)
			{
				Set_Prompt(getmsg(MSG1419), PENALIZE_PROMPT1); 
			}
			else
			{
				Office_Menu(1);
			}
		}
		else
		{
			Office_Menu(1);
		}
	}
	else if (MY_PORT->status == PENALIZE_PROMPT1)
	{
		if (margc)
		{
			Penalize();
		}
		
		Office_Menu(1);
	}
	else if (MY_PORT->status == PAROLE_PROMPT)
	{
		if (margc)
		{
			Parole();
		}
		
		Office_Menu(1);
	}
	else if (MY_PORT->status == GAMEOP_PROMPT)
	{
		if (margc == 0)
		{
			GameOp_Menu(0);
		}
		else if (sameas(margv[0], "X"))
		{
			MY_PORT->status = DO_PROMPT;
		}
		else
		{
			GameOp_Menu(1);
		}
	}
	else if (MY_PORT->status == PERMIT_PROMPT)
	{
		if (margc && !sameas(margv[0], "X"))
		{
			i = Set_Permit(&me);
			MY_PORT->intercepting = me.perm[INTERCEPT_PERM];

			if (i >= 0)
			{
				List_Permits(&me, i);
			}

			prf(NL);
			sprintf(prompt, getmsg(MSG1397), NUM_PERMS - 1);
			Set_Prompt(prompt, PERMIT_PROMPT);
		}
		else
		{
			GameOp_Menu(0);
		}
	}
	else if (MY_PORT->status == BOUNTY_PROMPT1)
	{
		if (margc)
		{
			MY_PORT->misc = INUM(margv[0]);
		}
		else
		{
			MY_PORT->misc = 0;
		}

		sprintf(prompt, getmsg(MSG1395), globals->maxmon);
		Set_Prompt(prompt, BOUNTY_PROMPT2);
	}
	else if (MY_PORT->status == BOUNTY_PROMPT2)
	{
		if (margc)
		{
			strcpy(word1, margv[0]);
			real_which1 = MY_PORT->misc;
			Display_Current_Bounty();
		}

		GameOp_Menu(0);
	}
	else if (MY_PORT->status == LOCATE_ITEM_PROMPT)
	{
		if (margc == 0)
		{
			GameOp_Menu(0);
		}
		else
		{
			MY_PORT->find_i = 0;
			MY_PORT->finding = FIND_ITEM;
			strncpy(MY_PORT->str, margv[0], NAME_LEN);
			MY_PORT->str[NAME_LEN - 1] = 0;
			MY_PORT->misc = FALSE;
			Find_Stuff();
		}
	}
	else if (MY_PORT->status == LOCATE_MON_PROMPT)
	{
		if (margc == 0)
		{
			GameOp_Menu(0);
		}
		else
		{
			MY_PORT->find_m = 0;
			MY_PORT->finding = FIND_CRIT;
			strncpy(MY_PORT->str, margv[0], NAME_LEN);
			MY_PORT->str[NAME_LEN - 1] = 0;
			MY_PORT->misc = FALSE;
			Find_Stuff();
		}
	}
	else if (MY_PORT->status == CREATE_NUM_PROMPT)
	{
		if (margc == 0)
		{   
			GameOp_Menu(0);
		}
		else
		{
			MY_PORT->misc = atoi(margv[0]);

			if (MY_PORT->misc == 0 || MY_PORT->misc >= MAX_ITEM)
			{
				prfmsg(MSG1025, MAX_ITEM - 1);
				GameOp_Menu(0);
			}
			else
			{
				sprintf(prompt, getmsg(MSG1392), Stat_Lev(me.Psy));
				Set_Prompt(prompt, CREATE_LEVEL_PROMPT);
			}
		}
	}
	else if (MY_PORT->status == CREATE_LEVEL_PROMPT)
	{
		struct  item_struct *item;

		if (margc == 0)
		{
			i = Stat_Lev(me.Psy);
		}
		else
		{
			i = atoi(margv[0]);

			if (i <= 0)
			{
				i = Stat_Lev(me.Psy);
			}
		}

		item = Create_Item(MY_PORT->misc, NULL, 100, i, FALSE);
		i = Give_Me(item);

		if (i)
		{
			prfmsg(MSG1026);
			Display_Item(item);
			prf(NL);
		}
		
		GameOp_Menu(0);
	}
	else if (MY_PORT->status == ZAP_PROMPT)
	{
		if (margc != 0)
		{
			Zap();
		}

		GameOp_Menu(0);
	}
	else if (MY_PORT->status == SUSPEND_PROMPT)
	{
		if (margc != 0)
		{
			Suspend();
		}

		GameOp_Menu(0);
	}
	else if (MY_PORT->status == INVASION_MON_PROMPT)
	{
		if (margc)
		{
			globals->next_invader = atoi(margv[0]);

			if 
			(
				globals->next_invader < 1 || 
				globals->next_invader > globals->maxmon
			)
			{
				prf("Bad monster number.\r");
				MY_PORT->status = DO_PROMPT;
				globals->next_invader = 0;
			}
			else
			{
				Set_Prompt(getmsg(MSG1320), INVASION_LEVEL_PROMPT);
			}
		}
		else
		{
			GameOp_Menu(0);
		}
	}
	else if (MY_PORT->status == INVASION_LEVEL_PROMPT)
	{
		if (margc)
		{
			globals->next_invasion_level = atoi(margv[0]);

			if (globals->next_invasion_level < 1)
			{
				globals->next_invasion_level = 0;
			}
		}
		else
		{
			globals->next_invasion_level = 0;
		}

		Set_Prompt(getmsg(MSG1321), INVASION_SIZE_PROMPT);
	}
	else if (MY_PORT->status == INVASION_SIZE_PROMPT)
	{
		if (margc)
		{
			globals->next_invasion_size = atoi(margv[0]);

			if (globals->next_invasion_size < 8)
			{
				globals->next_invasion_size = 0;
			}
		}
		else
		{
			globals->next_invasion_size = 0;
		}

		Set_Prompt(getmsg(MSG1322), INVASION_MINS_PROMPT);
	}
	else if (MY_PORT->status == INVASION_MINS_PROMPT)
	{
		if (margc)
		{
			globals->next_invasion_mins = atoi(margv[0]);

			if (globals->next_invasion_mins < 1)
			{
				globals->next_invasion_mins = 0;
			}
		}
		else
		{
			globals->next_invasion_mins = 0;
		}

		Set_Prompt(getmsg(MSG1323), INVASION_ROOM_PROMPT);
	}
	else if (MY_PORT->status == INVASION_ROOM_PROMPT)
	{
		if (margc)
		{
			globals->next_invasion_room = atoi(margv[0]);

			if 
			(
				globals->next_invasion_room < 1 ||
				globals->next_invasion_room > globals->maxroom
			)
			{
				globals->next_invasion_room = 0;
			}
		}
		else
		{
			globals->next_invasion_room = 0;
		}

		Set_Prompt(getmsg(MSG1324), INVASION_HEIR_PROMPT);
	}
	else if (MY_PORT->status == INVASION_HEIR_PROMPT)
	{
		if (margc)
		{
			if (sameas(margv[0], "Y"))
			{
				globals->next_invasion_heir = 'Y';
			}
			else if (sameas(margv[0], "N"))
			{
				globals->next_invasion_heir = 'N';
			}
			else
			{
				globals->next_invasion_heir = 0;
			}
		}
		else
		{
			globals->next_invasion_heir = 0;
		}

		prf("OK\r");
		GameOp_Menu(0);
		invasion->timer = 0;
	}
	else if (MY_PORT->status == DANGER_MOVE_PROMPT)
	{
		if (sameas(margv[0], "y"))
		{
			Moving(1);
			MY_PORT->status = DO_PROMPT;
		}
		else
		{
			MY_PORT->status = DO_PROMPT;
		}
	}
	else if (MY_PORT->status == CHANT_PROMPT)
	{
		if (margc != 0)
		{             
			rstrin();
			Chant(input);
		}
		
		MY_PORT->status = DO_PROMPT;
	}
	else if (MY_PORT->status == FAME_PROMPT)
	{
		if (margc == 0 || sameas(margv[0], "X"))
		{             
			GameOp_Menu(0);
		}
		else
		{
			Edit_Fame();
		}
	}
	else if (MY_PORT->status == BET_PROMPT)
	{
		if (margc == 0)
		{             
			word1[0] = 0;
		}
		else
		{
			strcpy(word1, margv[0]);
		}

		Arena_Bet();
		MY_PORT->status = DO_PROMPT;
	}
	else if (MY_PORT->status == DANGER_GO_PROMPT)
	{
		if (sameas(margv[0], "y"))
		{
			Go_Special(1);
			MY_PORT->status = DO_PROMPT;
		}
		else
		{
			MY_PORT->status = DO_PROMPT;
		}
	}
	else if (MY_PORT->status == FINE_MOVE_PROMPT)
	{
		if (sameas(margv[0], "y"))
		{
			Pay_Fine();
		}
		else if (MY_PORT->arrest_timer)
		{
			prfmsg(MSG1415, MY_PORT->arrest_timer);
		}
		else
		{
			Moving(1);
		}
		
		MY_PORT->status = DO_PROMPT;
	}
	else if (MY_PORT->status == FINE_GO_PROMPT)
	{
		if (sameas(margv[0], "y"))
		{
			Pay_Fine();
		}
		else if (MY_PORT->arrest_timer)
		{
			prfmsg(MSG1415, MY_PORT->arrest_timer);
		}
		else
		{
			Go_Special(1);
		}
		
		MY_PORT->status = DO_PROMPT; 
	}
	else if (MY_PORT->status == SCRAWL_PROMPT)
	{
		if (margc == 0)
		{
			ABUF(B)->rm2.scrawl[0] = 0;
		}
		else
		{
			rstrin();
			input[SCRAWL_SIZE - 1] = 0;
			strcpy(ABUF(B)->rm2.scrawl, input);
		}

		Guild_Menu(1);
	}
	else if (MY_PORT->status == ORACLE_PROMPT)
	{
		Oracle(ORACLE_PROMPT);
		MY_PORT->status = DO_PROMPT;
	}
	else if (MY_PORT->status == GET_PUB_BODY_PROMPT)
	{
		Post_Forum(0);
	}
	else if (MY_PORT->status == GET_MSG_BODY_PROMPT)
	{
		Post();
	}
	else if (MY_PORT->status == READ_FORUM_PROMPT)
	{
		Check_Public();
	}
	else if (MY_PORT->status == READ_GUILD_FORUM_PROMPT)
	{
		Check_Guild_Forum();
	}
	else if (MY_PORT->status == REPORT_PROMPT)
	{
		Reports();
	}
	else if 
	(
		MY_PORT->status == NEXT_MSG_PROMPT || 
		MY_PORT->status == ERASE_MSG_PROMPT
	)
	{
		Check_Mail(-1);
	}
	else if (MY_PORT->status == LABEL_PROMPT)
	{
		Label_Item(LABEL_PROMPT);
		MY_PORT->status = DO_PROMPT;
	}
	else if (MY_PORT->status == QUIT_PROMPT)
	{
		Quit(QUIT_PROMPT);
		if (P >= 0)
		{
			MY_PORT->status = DO_PROMPT;
		}
	}
	else if (MY_PORT->status == RESIGN_PROMPT)
	{
		if (sameas(margv[0], "y"))
		{
			Resign(&me);
			Write_My_Rec(EXISTS);
			prfmsg(M729);
		}

		Guild_Menu(1);
	}
	else if (MY_PORT->status == ABDICATE_PROMPT)
	{
		short   held;

		if (margc)
		{
			Abdicate(ABDICATE_PROMPT);
		}

		held = MY_PORT->guv + MY_PORT->paladin + MY_PORT->assassin; 
		held += MY_PORT->judge;

		if (held > 1)
		{
			MY_PORT->hot_menu = TRUE;
			prfmsg(M399);
			Abdicate(0);
		}
		else
		{
			Office_Menu(1);
		}
	}
	else if (MY_PORT->status == CLOSE_GUILD_PROMPT)
	{
		Master_Resign();
		Guild_Menu(1);
	}
	else if (MY_PORT->status == HUNTRESS_PROMPT)
	{
		Huntress(HUNTRESS_PROMPT);
		MY_PORT->status = DO_PROMPT;
	}
	else if (MY_PORT->status == DUMP_FILE_PROMPT)
	{
		Dump_File(NULL, -1);
	}
	else if (MY_PORT->status == ANNOUNCE_PROMPT)
	{
		MY_PORT->announce = FALSE;
		Newday(0);
	}
	else if (MY_PORT->status == WHO_PROMPT)
	{
		who();
	}
	else if (MY_PORT->status == CONTAINER_PROMPT)
	{
		Print_Bag_Contents(1, MY_PORT->misc2);
	}
	else if 
	(
		MY_PORT->status == MEMBERS_PROMPT || 
		MY_PORT->status == MEMBER_PROMPT
	)
	{   
		Guild_Members();
	}
	else if (MY_PORT->status == GUILD_SELL_PROMPT)
	{
		Guild_Sell(GUILD_SELL_PROMPT);
	}
	else if (MY_PORT->status == EDIT_PERM_PROMPT)
	{
		Edit_Perm_Mon();

		if (STATE == 0)
		{
			GameOp_Menu(0);
		}
	}
	else if (MY_PORT->status == EDIT_OFFICE_PROMPT)
	{
		Edit_Offices();

		if (STATE == 0)
		{
			GameOp_Menu(0);
		}
	}
	else if (MY_PORT->status == EDIT_GUY_PROMPT1)
	{
		Edit_Guy(1);
	}
	else if (MY_PORT->status == EDIT_GUY_PROMPT2)
	{
		if (margc == 0)
		{
			Set_Prompt(getmsg(MSG1423), EDIT_GUY_PROMPT2);
		}
		else if (sameas(margv[0], "A"))
		{
			Edit_Guy(2);
			rstmbk();
			return (TRUE);
		}
		else if (sameas(margv[0], "B"))
		{
			Edit_Guy(3);
		}
		else if (sameas(margv[0], "C"))
		{
			if (globals->sysopkey[0] && haskey(globals->sysopkey))
			{
				Edit_Guy(4);
			}
			else
			{
				prfmsg(M880);
				Set_Prompt(getmsg(MSG1423), EDIT_GUY_PROMPT2);
			}
		}
		else if (sameas(margv[0], "D"))
		{
			Edit_Guy(5);
		}
		else if (sameas(margv[0], "X"))
		{
			Edit_Guy(6);
		}
		else
		{
			Set_Prompt(getmsg(MSG1423), EDIT_GUY_PROMPT2);
		}
	}
	else if (MY_PORT->status == EDIT_GUY_PROMPT3)
	{
		if (margc == 0 || sameas(margv[0], "X"))
		{
			prfmsg(MSG1422);
			Set_Prompt(getmsg(MSG1423), EDIT_GUY_PROMPT2);
		}
		else
		{
			i = INUM(margv[0]);

			if (i > 0 && i <= NUM_SPELLS)
			{
				if (MY_PORT->edit.a_char.spell[i - 1])
				{
					MY_PORT->edit.a_char.spell[i - 1] = FALSE;
				}
				else
				{
					MY_PORT->edit.a_char.spell[i - 1] = TRUE;
				}
			}

			Edit_Guy(3);
		}
	}
	else if (MY_PORT->status == EDIT_GUY_PROMPT4)
	{
		if (margc && !sameas(margv[0], "X"))
		{
			Set_Permit(&MY_PORT->edit.a_char);
			Edit_Guy(4);
		}
		else
		{
			prfmsg(MSG1422);
			Set_Prompt(getmsg(MSG1423), EDIT_GUY_PROMPT2);
		}
	}
	else if (MY_PORT->status == EDIT_GUY_PROMPT5)
	{
		if (margc && !sameas(margv[0], "X"))
		{
			strcpy(word1, margv[0]);
			Set_Options(&MY_PORT->edit.a_char);
			Edit_Guy(5);
		}
		else
		{
			prfmsg(MSG1422);
			Set_Prompt(getmsg(MSG1423), EDIT_GUY_PROMPT2);
		}
	}
	else if (MY_PORT->status == EDIT_STORE_PROMPT)
	{
		Edit_Store();

		if (STATE == 0)
		{
			GameOp_Menu(0);
		}
	}
	else if (MY_PORT->status == EDIT_ROOM_PROMPT1)
	{
		if (Edit_Room(1))
		{
			rstmbk();
			return (TRUE);
		}
		else
		{
			GameOp_Menu(0);
		}
	}
	else if (MY_PORT->status == EDIT_ROOM_PROMPT3)
	{
		Edit_Room(3);
	}
	else if (MY_PORT->status == EDIT_ROOM_PROMPT5)
	{
		Edit_Room(5);
	}
	else if (MY_PORT->status == EDIT_ROOM_PROMPT7)
	{
		Edit_Room(7);
	}
	else if (MY_PORT->status == EDIT_ROOM_PROMPT9)
	{
		Edit_Room(9);
	}
	else if (MY_PORT->status == EDIT_ROOM_PROMPT11)
	{
		Edit_Room(11);
	}
	else if (MY_PORT->status == EDIT_ROOM_PROMPT13)
	{
		Edit_Room(13);
	}
	else if (MY_PORT->status == EDIT_ROOM_PROMPT15)
	{
		Edit_Room(15);
	}
	else if (MY_PORT->status == EDIT_ITEM_PROMPT1)
	{
		if (!Edit_Items(1))
		{
			GameOp_Menu(0);
		}
	}
	else if (MY_PORT->status == EDIT_ITEM_PROMPT2)
	{
		if (Edit_Items(2))
		{
			rstmbk();
			return (TRUE);
		}
		else
		{
			GameOp_Menu(0);
		}
	}
	else if (MY_PORT->status == EDIT_ITEM_PROMPT3)
	{
		if (!Edit_Items(3))
		{
			GameOp_Menu(0);
		}
	}
	else if (MY_PORT->status == EDIT_ITEM_PROMPT4)
	{
		if (!Edit_Items(4))
		{
			GameOp_Menu(0);
		}
	}
	else if (MY_PORT->status == EDIT_ITEM_PROMPT5)
	{
		if (Edit_Items(5))
		{
			rstmbk();
			return (TRUE);
		}
		else
		{
			GameOp_Menu(0);
		}
	}
	else if (MY_PORT->status == EDIT_ITEM_PROMPT6)
	{
		if (Edit_Items(6))
		{
			rstmbk();
			return (TRUE);
		}
		else
		{
			GameOp_Menu(0);
		}
	}
	else if (MY_PORT->status == EDIT_ITEM_PROMPT7)
	{
		GameOp_Menu(0);
	}
	else if (MY_PORT->status == EDIT_ITEM_PROMPT9)
	{
		Edit_Items(9);
	}
	else if (MY_PORT->status == EDIT_ITEM_PROMPT11)
	{
		Edit_Items(11);
	}
	else if (MY_PORT->status == EDIT_ITEM_PROMPT13)
	{
		Edit_Items(13);
	}
	else if (MY_PORT->status == EDIT_ITEM_PROMPT14)
	{
		Edit_Items(14);
	}
	else if (MY_PORT->status == EDIT_ITEM_PROMPT16)
	{
		Edit_Items(16);
	}
	else if (MY_PORT->status == EDIT_MON_PROMPT1)
	{
		if (Edit_Monsters(1))
		{
			rstmbk();
			return (TRUE);
		}
		else
		{
			GameOp_Menu(0);
		}
	}
	else if (MY_PORT->status == EDIT_MON_PROMPT3)
	{
		Edit_Monsters(3);
	}
	else if (MY_PORT->status == EDIT_MON_PROMPT5)
	{
		Edit_Monsters(5);
	}
	else if (MY_PORT->status == EDIT_MON_PROMPT7)
	{
		Edit_Monsters(7);
	}
	else if (MY_PORT->status == EDIT_MON_PROMPT9)
	{
		Edit_Monsters(9);
	}
	else if (MY_PORT->status == EDIT_MON_PROMPT11)
	{
		Edit_Monsters(11);
	}
	else if (MY_PORT->status == EDIT_MON_PROMPT13)
	{
		Edit_Monsters(13);
	}
	else if (MY_PORT->status == EDIT_MON_PROMPT15)
	{
		Edit_Monsters(15);
	}
	else if (MY_PORT->status == EDIT_GUILD_PROMPT)
	{
		Edit_Guild();

		if (STATE == 0)
		{
			Guild_Menu(0);
		}
	}

	if 
	(
		globals->daymins &&
		P >= 0 && 
		MY_PORT->status && 
		me.secs_today / 60 >= globals->daymins &&
		!me.perm[GAMEOP_PERM]
	)
	{
		prfmsg(MSG1300, globals->daymins);
		strcpy(margv[0], "y");
		Quit(QUIT_PROMPT);
	}

	if (P >= 0 && MY_PORT->status)
	{
		if (MY_PORT->big_sleep)
		{
			Write_My_Rec(SUICIDE);
			rstrxf();
			sign_me_off();
			outprf(usrnum);
			clrprf();
			btuchi(usrnum, NULL);
			STATE = 0;
			rstmbk();
			return (FALSE);
		}

		if (me.in_guild)
		{
			check_turf();
		}

		if (MY_PORT->status == DO_PROMPT)
		{
			Set_Main_Prompt();
			STATE = 0;
		}

		MY_PORT->need_lf = TRUE;
		btuoes(usrnum, 0);
		outprf(usrnum);
		clrprf();
		rstmbk();
		return (TRUE);
	}
	else
	{
		rstrxf();

		if (usrptr->flags&CONCEX)
		{
			btuchi(usrnum, NULL); 
			outprf(usrnum);
			clrprf();
			rstmbk();
			return (FALSE);
		}
		else
		{
			Main_Menu();
			outprf(usrnum);
			clrprf();
			rstmbk();
			return (TRUE);
		}
	}
}
/**************************************************************************
	user has hung up
*/
void chaos_hup(void)
{
	short   i;

	for (i = 0; i != NTERMS; ++i)
	{
		if (APORT(i)->status && APORT(i)->usrnum == usrnum)
		{
			if (APORT(i)->status == NEXT_MSG_PROMPT)
			{
				Check_Mail(i);
			}
				
			if (APORT(i)->status == DUMP_FILE_PROMPT)
			{
				Dump_File(NULL, i);
			}   

			APORT(i)->hung_up = TRUE;
		}
	}
}
/**************************************************************************
	clean up routine, called once daily (generally 3:00 AM)
*/
void chaos_clean(void)
{
	short   oldusn = usrnum;

	setmbk(mui_cfg); 
	usrnum = -2;
	
#ifdef SOC2
	shocst("SoCA: Cleanup Starting", "%s", "Cleanup Starting");
#else
	shocst("SoC: Cleanup Starting", "%s", "Cleanup Starting");
#endif
	
	if (secs_today > 60 * 10)
	{
#ifdef SOC2
		sprintf
		(
			str, 
			"SoCA: %d users, %ld mins", 
			users_today,
			secs_today / 60
		);
#else
		sprintf
		(
			str, 
			"SoC: %d users, %ld mins", 
			users_today,
			secs_today / 60
		);
#endif
		shocst(str, "%s", str);
		secs_today = 0;
		users_today = 0;
	}

	if (globals->autorpts)
	{
#ifdef SOC2
		shocst
		(
			"SoCA: Writing Reports...", 
			"%s", 
			"Writing Report..."
		); 
#else
		shocst
		(
			"SoC: Writing Reports...", 
			"%s", 
			"Writing Reports..."
		); 
#endif
		
		Monster_Report();
		Room_Report();
		Item_Report();
	}

#ifdef SOC2
	shocst("SoCA: Housekeeping...", "%s", "Housekeeping...");
#else
	shocst("SoC: Housekeeping...", "%s", "Housekeeping...");
#endif

	Guild_Turf_Check();
	Clear_Old_Turf();
	
	if (globals->inactdys)
	{
		Clear_Old_Characters(); 
	}

#ifdef SOC2
	shocst("SoCA: Cleanup Finished", "%s", "Cleanup Finished");
#else
	shocst("SoC: Cleanup Finished", "%s", "Cleanup Finished");
#endif
	
	usrnum = oldusn;
	rstmbk(); 
}
/**************************************************************************
	user is being deleted, remove his characters, etc.
*/
void chaos_delete(account)
char *account;
{
	short   index;

	userid = account;
	index = Find_A_Char(&a_char, NULL);

	if (index >= 0)
	{
		Remove_User(index);
	}
}
/**************************************************************************
	user is being deleted, remove his characters, etc.
*/
void Remove_User(short index)
{
	short   in_guild;
	short   master;
	short   i;
	char    name[NAME_LEN];

	Read_A_Char(index, &a_char); 
	
	strcpy(name, a_char.name);
	in_guild = a_char.in_guild;
	master = a_char.guild_master;

	for (i = 0; i != NUM_ITEMS; ++i)
	{
		if (a_char.item[i].what == CONTAINER)
		{
			Kill_Container(&a_char.item[i]);
		}
	}

	Read_Closet(index, a_closet);
	   
	for (i = 0; i != NUM_ITEMS; ++i)
	{
		if (a_closet->item[i].what == CONTAINER)
		{
			Kill_Container(&a_closet->item[i]);
		}
	}
		
	setmem(a_closet, CLOSET_SIZE, 0);
	Write_Closet(index, a_closet);
	Erase_Macros(index);
	Erase_Mail(index);
	Erase_Votes(index);
	strcpy(a_char.name, BLANK_RECORD);
	Write_A_Char(index, &a_char);

	if (master)
	{
		Guild_Master_Died(name, in_guild);
	}
}
/**************************************************************************
	system is shutting down, perform any cleanups
*/
void chaos_shutdown(void)
{

	NOTIFY("Shutdown Starting");

	for (P = 0; P != NTERMS; ++P)
	{
		if (MY_PORT->status)
		{
			for (B = 0; B != NTERMS; ++B)
			{
				if (ABUF(B)->guy[P])
				{
					lose_player();
				}
			}

			if (MY_PORT->limbo_return)
			{
				me.location = MY_PORT->limbo_return;
			}

			Write_Him(P);
			MY_PORT->status = 0;
		}
	}

	if (secs_today > 60 * 10)
	{
		sprintf
		(
			str, 
			"%d users, %ld mins", 
			users_today,
			secs_today / 60
		);
		NOTIFY(str);
		secs_today = 0;
		users_today = 0;
	}

	Close_Data_Files();
	clsmsg(mui_cfg);
	NOTIFY("Done Shutting Down");
}
/***************************************************************************
	see if the command entered is unique
*/
short Unique_Check(void)
{
	short   i;
	short   n = 0;
	short   abs_match = 0;

	if (sameas(margv[0], "n"))
	{
		command = NORTH;
		strcpy(MY_PORT->command, "north");
		BAD_EXIT;
	}
	else if (sameas(margv[0], "s"))
	{
		command = SOUTH;
		strcpy(MY_PORT->command, "south");
		BAD_EXIT;
	}
	else if (sameas(margv[0], "e"))
	{
		command = EAST;
		strcpy(MY_PORT->command, "east");
		BAD_EXIT;
	}
	else if (sameas(margv[0], "w"))
	{
		command = WEST;
		strcpy(MY_PORT->command, "west");
		BAD_EXIT;
	}
	else if (sameas(margv[0], "u"))
	{
		command = UP;
		strcpy(MY_PORT->command, "up");
		BAD_EXIT;
	}
	else if (sameas(margv[0], "d"))
	{
		command = DOWN;
		strcpy(MY_PORT->command, "down");
		BAD_EXIT;
	}
	else if (sameas(margv[0], "o"))
	{
		command = OUT;
		strcpy(MY_PORT->command, "out");
		BAD_EXIT;
	}
	else if (sameas(margv[0], "x"))
	{
		command = QUIT;
		strcpy(MY_PORT->command, "quit");
		BAD_EXIT;
	}
	else if (sameas(margv[0], "?"))
	{
		command = HELP;
		strcpy(MY_PORT->command, "help");
		BAD_EXIT;
	}
	else if (sameas(margv[0], "c"))
	{
		command = CAST;
		strcpy(MY_PORT->command, "cast");
		Parse_Input();
		BAD_EXIT;
	}
	else if (sameas(margv[0], "l"))
	{
		command = LOOK;
		strcpy(MY_PORT->command, "look");
		Parse_Input();
		BAD_EXIT;
	}
	else if (sameas(margv[0], "m"))
	{
		command = ACTIVATE_MENU;
		strcpy(MY_PORT->command, "menu");
		Parse_Input();
		BAD_EXIT;
	}

	for (i = 1; i != NUM_COMMANDS && !abs_match; ++i)
	{
		if (sameto(margv[0], commands[i]))
		{
			++n;
			command = i;
			strcpy(MY_PORT->command, commands[i]);

			if (sameas(margv[0], commands[i]))
			{
				n = 1;
				abs_match = TRUE;
			}
		}
	}

	if (n > 1)
	{
		if (me.Option[NO_SEND])
		{
			MY_PORT->saying = TRUE;
			command = SEND;
			strcpy(MY_PORT->command, "send");
			Parse_Input();
		}
		else if (me.Option[NO_SAY])
		{
			MY_PORT->saying = TRUE;
			command = SAY;
			strcpy(MY_PORT->command, "say");
			Parse_Input();
		}
		else
		{
			prfmsg(M167, margv[0]);
			command = 0;
			MY_PORT->last_input[0] = 0;
			MY_PORT->command[0] = 0;
		}
	}
	else if (n == 0)
	{
		if (me.Option[NO_SEND])
		{
			MY_PORT->saying = TRUE;
			command = SEND;
			Parse_Input();
			strcpy(MY_PORT->command, "send");
		}
		else if (me.Option[NO_SAY])
		{
			MY_PORT->saying = TRUE;
			command = SAY;
			Parse_Input();
			strcpy(MY_PORT->command, "say");
		}
		else
		{
			prfmsg(M400, margv[0]);
			command = 0;
			MY_PORT->last_input[0] = 0;
			MY_PORT->command[0] = 0;
			Menu_Notice();
		}
	}
	else
	{
		Parse_Input();
	}

	DONE;
}
/*****************************************************************************
	new user has signed on, check for new day status. if new day, clean
	up the character's woes, put him into his room and on with the fun.
*/
void Newday(short announce)
{
	short   i;
	short   j;
	short   held;
	short   subevil;
	short   addevil;

	btuxnf(usrnum, 0, 19);

	if (announce)
	{
		Display_Announcement();

		if (MY_PORT->announce)
		{
			return;
		}
	}

	if 
	(
		(me.Option[NO_POOBAH] != FALSE && me.Option[NO_POOBAH] != TRUE) ||
		!globals->option7
	)
	{
		me.Option[NO_POOBAH] = FALSE;
	}

	if (me.focus >= 0 && me.item[me.focus].what != PSY_FOCUS)
	{
		me.focus = -1;
	}

	for (i = 0; i != strlen(me.name); ++i)
	{   
		for (j = 0; j != strlen(globals->badchars); ++j)
		{
			if (me.name[i] == globals->badchars[j])
			{
				me.name[i] = '_';
			}
		}
	}

	strcpy(me.data3, DATA3);
	prfmsg(M401, me.name);
	Titles(MY_PORT->index, str);

	if (str[0])
	{
		prf("%s\r", str);
	}

	if (today() != me.last_date)
	{
		me.posts = 0;
		me.secs_today = 0;
		++users_today;
		subevil = numopt(SUBEVIL, -32767, 32767);
		addevil = numopt(ADDEVIL, -32767, 32767);

		prfmsg(MSG403);
		if (me.in_guild && guild->dues[me.in_guild])
		{
			do_dues();
		}

		if (subevil && me.evil)
		{
			if (me.evil < subevil)
			{
				subevil = me.evil;
			}

			prfmsg(M404, subevil);
			me.evil -= subevil;

			if (me.evil < 0)
			{
				me.evil = 0;
			}
		}
		else if (me.evil && (!addevil || !subevil))
		{
			me.evil = 0;
		}

		me.damaged = me.magic_used = 0;
		restore_stats(TOTAL_RESTORE);
		Write_My_Rec(EXISTS);
	}
	else
	{
		restore_stats(PARTIAL_RESTORE);
	}

	where();
	prfmsg(MSG0);
	New_Mail_Check();
	New_Public();
	if (me.in_guild)
	{
		New_Guild_Messages(me.in_guild);
	}

	me.last_date = today();
	me.location = Closet_Check(me.location);
	STATE = 0;

	Read_Room(me.location, &globals->next_room, &a_room2);

	if 
	(
		globals->next_room.no_teleport != TRUE && 
		me.location != globals->prison && 
		!Coward_Check()
	)
	{
		if (globals->destination[usrnum] == 'B')
		{
			me.location = globals->abank;
		}
		else if (globals->destination[usrnum] == 'M')
		{
			me.location = globals->amerc;
		}
		else if (globals->destination[usrnum] == 'A')
		{
			me.location = globals->anacad;
		}
		else if (globals->destination[usrnum] == 'T')
		{
			me.location = globals->townsq;
		}
	}

	move_me_to(me.location, NO_CLEAR);
	Read_My_Macros();
	Got_Weak(P);
	Misc_Checks();
	held = MY_PORT->guv + MY_PORT->paladin + MY_PORT->assassin; 
	held += MY_PORT->judge;

	if (held > 1)
	{
		MY_PORT->hot_menu = TRUE;
		prfmsg(M399);
		Abdicate(0);
	}
	else if (MY_PORT->status != BET_PROMPT && MY_PORT->status != BANK_PROMPT5)
	{
		MY_PORT->last_bp = me.damaged;
		MY_PORT->last_ftg = me.ftg;
		MY_PORT->last_mp = me.magic_used;

		Set_Main_Prompt();
	}
}
/*****************************************************************************
	character requested not found in user file, roll up a new one
*/
void New_Guy(name)
char *name;
{
	setmem(&a_char, CHAR_SIZE, 0);

	strcpy(a_char.name, name);
	strcpy(a_char.title, "Neophyte");
	strcpy(a_char.Userid, userid);

	a_char.newbie = 3;
	a_char.last_date = today();
	a_char.Str = globals->strtstat / 5;
	a_char.Dex = globals->strtstat / 5;
	a_char.Int = globals->strtstat / 5;
	a_char.Psy = globals->strtstat / 5;
	a_char.Con = globals->strtstat / 5;

	Set_Guy_Points
	(
		&a_char.dpts, 
		&a_char.mpts, 
		a_char.Str, 
		a_char.Con, 
		a_char.Psy, 
		0
	);

	No_Quests(&a_char);
	a_char.lw = a_char.shld = a_char.focus = -1;
	a_char.location = globals->townsq;
	a_char.shield = globals->startshd;
	a_char.two_wep = globals->start2wp;
	a_char.bank = globals->startgld;
	a_char.outlaw = 'N';

	setmem(&item, ITEMSIZE, 0);
	strcpy(item.article, "some");
	strcpy(item.adjective, "leather");
	strcpy(item.name, "armor");
	item.what = ARMOR;
	item.which = LITE_ARMOR;
	item.ac = 5;
	item.uses = 100;
	item.worth = 1;
	item.item_level = 1;
	item.merc_item = TRUE;
	a_char.item[0] = item;
	a_char.armor = 0;

	setmem(&item, ITEMSIZE, 0);
	strcpy(item.article, "a");
	strcpy(item.adjective, "small");
	strcpy(item.name, "dagger");
	item.what = EDGED;
	item.Hits = globals->wephits;
	item.uses = 100;
	item.worth = 1;
	item.item_level = 1;
	item.merc_item = TRUE;
	a_char.item[1] = item;
	a_char.rw = 1;

	a_char.Option[NOVICE] = TRUE;
	a_char.Option[NO_SEND] = TRUE;
	a_char.Option[HEALTH_STATUS] = TRUE;

	Add_Guy(&a_char);
	prf(NL);
}
/**************************************************************************
	if user hit escape, clear their input line
*/
char escape_key(int chan, int c)
{
	short   i;
	short   p = -1;
	short   found;
		
	for (i = 0, found = FALSE; i != NTERMS && !found; ++i)
	{
		if (APORT(i)->status && APORT(i)->usrnum == chan)
		{
			p = i;
			found = TRUE;
		}
	}

	if (c == 8)
	{
		if (found && strlen(APORT(p)->input))
		{
			APORT(p)->input[strlen(APORT(p)->input) - 1] = 0;
		}

		return (c);
	}
	
	if (c == 13)
	{
		btuoes(chan, 0);

		if 
		(
			found &&
			APORT(p)->input[0] &&
			(
				globals->g1[0] || 
				globals->g2[0] || 
				globals->g3[0] || 
				globals->g4[0] || 
				globals->g5[0]
			)
		)
		{
			if (globals->g1[0]) 
			{
				if (same_to(globals->g1, APORT(p)->input))
				{
#ifdef MBBS
					user[chan].flags |= NOGLOB;
#else
					usroff(chan)->flags |= NOGLOB;
#endif
				}
			}
				
			if (globals->g2[0])
			{
				if (same_to(globals->g2, APORT(p)->input))
				{                   
#ifdef MBBS
					user[chan].flags |= NOGLOB;
#else
					usroff(chan)->flags |= NOGLOB;
#endif
				}
			}

			if (globals->g3[0]) 
			{
				if (same_to(globals->g3, APORT(p)->input))
				{
#ifdef MBBS
					user[chan].flags |= NOGLOB;
#else
					usroff(chan)->flags |= NOGLOB;
#endif
				}
			}

			if (globals->g4[0])
			{
				if (same_to(globals->g4, APORT(p)->input))
				{
#ifdef MBBS
					user[chan].flags |= NOGLOB;
#else
					usroff(chan)->flags |= NOGLOB;
#endif
				}
			}
				
			if (globals->g5[0])
			{
				if (same_to(globals->g5, APORT(p)->input))
				{
#ifdef MBBS
					user[chan].flags |= NOGLOB;
#else
					usroff(chan)->flags |= NOGLOB;
#endif
				}
			}
		}

		if (found)
		{
			APORT(p)->input[0] = 0;
			APORT(p)->input[1] = 0;
		}

		return (c);
	}
	
	if (c < ' ' || c > 127 || c == ESC)
	{
		if (c == ESC && found && p >= 0)
		{
			btuoes(chan, 0);
			Set_His_Prompt(p);
			sprintf(globals->temp_buf, "\r%s", APORT(p)->prompt);
			btuxmt(chan, globals->temp_buf);
			btucli(chan);
			APORT(p)->input[0] = 0;
			APORT(p)->input[1] = 0;
		}

		return (FALSE);
	}

	if (found && strlen(APORT(p)->input) < LINE_LEN - 10)
	{
		APORT(p)->input[strlen(APORT(p)->input)] = c;
		APORT(p)->input[strlen(APORT(p)->input)] = 0;
		APORT(p)->input[strlen(APORT(p)->input) + 1] = 0;
	}

	return (c);
}
/***************************************************************************
	populate the globals structure
*/
void Set_Globals(void)
{
	short   i;

	globals->last_invasion_room = 0;
	globals->invdtuff = numopt(INVADTUF, -32767, 32767);
	globals->extmon = numopt(EXTMON, -32767, 32767);
	globals->monregen = numopt(MONREGEN, -32767, 32767);
	globals->monregen = globals->monregen * 60;
	
	globals->mondd = numopt(MONDD, -32767, 32767);    
	globals->barbdd = numopt(BARBDD, -32767, 32767);
	globals->wardd = numopt(WARDD, -32767, 32767);
	globals->dueldd = numopt(DUELDD, -32767, 32767);
	globals->thiefdd = numopt(THIEFDD, -32767, 32767);
	globals->sorcdd = numopt(SORCDD, -32767, 32767);
	globals->mystdd1 = numopt(MYSTDD1, -32767, 32767);
	globals->mystdd2 = numopt(MYSTDD2, -32767, 32767);
	globals->clerdd1 = numopt(CLERDD1, -32767, 32767);
	globals->clerdd2 = numopt(CLERDD2, -32767, 32767);

	globals->focus1 = numopt(FOCUS1, -32767, 32767);
	if (globals->focus1 == 1)
	{
		globals->focus1 = 15;
	}
	else if (globals->focus1 == 2)
	{
		globals->focus1 = 20;
	}
	else if (globals->focus1 == 3)
	{
		globals->focus1 = 25;
	}
	else 
	{
		globals->focus1 = 30;
	}

	globals->focus2 = numopt(FOCUS2, -32767, 32767);
	if (globals->focus2 == 1)
	{
		globals->focus2 = 15;
	}
	else if (globals->focus2 == 2)
	{
		globals->focus2 = 20;
	}
	else if (globals->focus2 == 3)
	{
		globals->focus2 = 25;
	}
	else 
	{
		globals->focus2 = 30;
	}
	
	globals->focus3 = numopt(FOCUS3, -32767, 32767);
	if (globals->focus3 == 1)
	{
		globals->focus3 = 15;
	}
	else if (globals->focus3 == 2)
	{
		globals->focus3 = 20;
	}
	else if (globals->focus3 == 3)
	{
		globals->focus3 = 25;
	}
	else 
	{
		globals->focus3 = 30;
	}
	
	globals->sorbonus = numopt(SORBONUS, -32767, 32767);
	if (globals->sorbonus == 1)
	{
		globals->sorbonus = 15;
	}
	else if (globals->sorbonus == 2)
	{
		globals->sorbonus = 20;
	}
	else if (globals->sorbonus == 3)
	{
		globals->sorbonus = 25;
	}
	else
	{
		globals->sorbonus = 30;
	}
	
	globals->sordmg = numopt(SORDMG, -32767, 32767);
	if (globals->sordmg == 1)
	{
		globals->sordmg = 15;
	}
	else if (globals->sordmg == 2)
	{
		globals->sordmg = 20;
	}
	else if (globals->sordmg == 3)
	{
		globals->sordmg = 25;
	}
	else if (globals->sordmg == 4)
	{
		globals->sordmg = 30;
	}
	else if (globals->sordmg == 5)
	{
		globals->sordmg = 35;
	}
	else
	{
		globals->sordmg = 40;
	}

	globals->mysbonus = numopt(MYSBONUS, -32767, 32767);
	if (globals->mysbonus == 1)
	{
		globals->mysbonus = 15;
	}
	else if (globals->mysbonus == 2)
	{
		globals->mysbonus = 20;
	}
	else if (globals->mysbonus == 3)
	{
		globals->mysbonus = 25;
	}
	else
	{
		globals->mysbonus = 30;
	}
	
	globals->mysdmg = numopt(MYSDMG, -32767, 32767);
	if (globals->mysdmg == 1)
	{
		globals->mysdmg = 15;
	}
	else if (globals->mysdmg == 2)
	{
		globals->mysdmg = 20;
	}
	else if (globals->mysdmg == 3)
	{
		globals->mysdmg = 25;
	}
	else if (globals->mysdmg == 4)
	{
		globals->mysdmg = 30;
	}
	else if (globals->mysdmg == 5)
	{
		globals->mysdmg = 35;
	}
	else
	{
		globals->mysdmg = 40;
	}
	
	globals->clebonus = numopt(CLEBONUS, -32767, 32767);
	if (globals->clebonus == 1)
	{
		globals->clebonus = 15;
	}
	else if (globals->clebonus == 2)
	{
		globals->clebonus = 20;
	}
	else if (globals->clebonus == 3)
	{
		globals->clebonus = 25;
	}
	else 
	{
		globals->clebonus = 30;
	}
	
	globals->itmboost = numopt(ITMBOOST, -32767, 32767);
	if (globals->itmboost == 1)
	{
		globals->itmboost = 13;
	}
	else if (globals->itmboost == 2)
	{
		globals->itmboost = 16;
	}
	else if (globals->itmboost == 3)
	{
		globals->itmboost = 19;
	}
	else if (globals->itmboost == 4)
	{
		globals->itmboost = 22;
	}
	else
	{
		globals->itmboost = 25;
	}

	globals->barbbsk = numopt(BARBBSK, -32767, 32767);
	if (globals->barbbsk == 1)
	{
		globals->barbbsk = 15;
	}
	else if (globals->barbbsk == 2)
	{
		globals->barbbsk = 20;
	}
	else if (globals->barbbsk == 3)
	{
		globals->barbbsk = 25;
	}
	else if (globals->barbbsk == 4)
	{
		globals->barbbsk = 30;
	}
	else if (globals->barbbsk == 5)
	{
		globals->barbbsk = 35;
	}
	else
	{
		globals->barbbsk = 40;
	}
	
	globals->warbonus = numopt(WARBONUS, -32767, 32767);
	if (globals->warbonus == 1)
	{
		globals->warbonus = 12;
	}
	else if (globals->warbonus == 2)
	{
		globals->warbonus = 15;
	}
	else if (globals->warbonus == 3)
	{
		globals->warbonus = 18;
	}
	else if (globals->warbonus == 4)
	{
		globals->warbonus = 20;
	}
	else if (globals->warbonus == 5)
	{
		globals->warbonus = 22;
	}
	else
	{
		globals->warbonus = 25;
	}
	
	globals->duebonus = numopt(DUEBONUS, -32767, 32767);
	if (globals->duebonus == 1)
	{
		globals->duebonus = 12;
	}
	else if (globals->duebonus == 2)
	{
		globals->duebonus = 15;
	}
	else if (globals->duebonus == 3)
	{
		globals->duebonus = 18;
	}
	else if (globals->duebonus == 4)
	{
		globals->duebonus = 20;
	}
	else if (globals->duebonus == 5)
	{
		globals->duebonus = 22;
	}
	else
	{
		globals->duebonus = 25;
	}

	globals->fexplev = numopt(FEXPLEV, -32767, 32767);
	globals->xplev15 = numopt(XPLEV15, -32767, 32767);

	globals->monreact = numopt(MONREACT, -32767, 32767);
	globals->monspell = numopt(MONSPELL, -32767, 32767);
	globals->monrob = numopt(MONROB, -32767, 32767);
	globals->mongb = numopt(MONGB, -32767, 32767);
	globals->monbash = numopt(MONBASH, -32767, 32767);
	globals->monparry = numopt(MONPARY, -32767, 32767);

	globals->perm_regen_timer = numopt(PRMREGEN, -32767, 32767);
	globals->perm_regen_timer = globals->perm_regen_timer * 60;
	globals->item_regen_timer = numopt(ITMREGEN, -32767, 32767);
	globals->item_regen_timer = globals->item_regen_timer * 60L;

	globals->next_bounty = 0;
	globals->next_bounty_mins = 0;
	globals->next_invader = 0;
	globals->next_invasion_mins = 0;
	globals->next_invasion_size = 0;
	globals->next_invasion_heir = 0;
	globals->next_invasion_room = 0;
	globals->next_invasion_level = 0;

	globals->main_prompt1 = stgopt(MAINP1);
	globals->main_prompt2 = stgopt(MAINP2);
	globals->main_prompt3 = stgopt(MAINP3);

	globals->textdir = stgopt(TEXTDIR);
	mkdir(globals->textdir);
	globals->anncfile = stgopt(ANNCFILE);

	globals->room1 = stgopt(MSG259);
	globals->room2 = stgopt(MSG260);
	globals->room3 = stgopt(MSG261);
	globals->cover1 = stgopt(M553);
	globals->cover2 = stgopt(M554);
	globals->cover3 = stgopt(M555);
	globals->cover4 = stgopt(M556);
	globals->north = stgopt(M227);
	globals->south = stgopt(M228);
	globals->east = stgopt(M229);
	globals->west = stgopt(M230);
	globals->up = stgopt(M231);
	globals->down = stgopt(M232);
	globals->out = stgopt(M233);
	globals->turf1 = stgopt(MSG718);
	globals->turf2 = stgopt(MSG719);
	globals->turf3 = stgopt(M720);
	globals->turf4 = stgopt(M721);
	globals->turf5 = stgopt(M722);
	globals->turf6 = stgopt(M723);
	globals->bounty.plural_name[0] = 0;
	globals->bounty_timer = 0;
	globals->captive = stgopt(HEIRNAME);
	globals->captive_speed = numopt(CAPMOVE, -32767, 32767);
	globals->intercept = stgopt(MSG329);
	globals->maxgenxp = lngopt(MAXGENXP, 1L, GCMAXLONG);
	globals->selldisc = numopt(SELLDISC, -32767, 32767);
	globals->buydisc = numopt(BUYDISC, -32767, 32767);
	globals->joekill1 = numopt(JOEKILL1, -32767, 32767);
	globals->joekill2 = numopt(JOEKILL2, -32767, 32767);
	globals->minarmor = numopt(MINARMOR, -32767, 32767);
	globals->minwep = numopt(MINWEP, -32767, 32767);
	globals->minmagic = numopt(MINMAGIC, -32767, 32767);
	globals->monleave = numopt(MONLEAVE, -32767, 32767);
	globals->outlaws = ynopt(OUTLAWS);
	globals->sticky = ynopt(STICKYI);
	globals->yell2 = ynopt(YELL2);
	globals->autorpts = ynopt(AUTORPTS);
	globals->turfmons = ynopt(TURFMONS);
	globals->ambush = ynopt(AMBUSH);
	globals->ambushm = numopt(AMBUSHM, -32767, 32767);
	globals->playkey = stgopt(PLAYKEY);
	globals->guildkey = stgopt(GUILDKEY); 
	globals->blurbon = ynopt(BLURBON);
	globals->blurb = stgopt(BLURB);
	globals->option7 = ynopt(OPTION7);

	for (i = 0; i != nterms; ++i)
	{
		globals->poobing[i] = FALSE;
		globals->eviling[i] = FALSE;
	}

	for (i = 0; i != MAX_TRACKS; ++i)
	{
		globals->track_room[i] = 0;
	}

	globals->msg61 = stgopt(MSSG61);
	globals->msg62 = stgopt(MSG62);
	globals->msg103 = stgopt(MSG103);
	globals->msg104 = stgopt(MSG104);
	globals->msg105 = stgopt(MSG105);
	globals->msg106 = stgopt(MSG106);
	globals->msg107 = stgopt(MSG107);
	globals->msg108 = stgopt(MSG108);
	globals->msg109 = stgopt(MSG109);
	globals->msg110 = stgopt(MSG110);
	globals->msg111 = stgopt(MSG111);
	globals->msg112 = stgopt(MSG112);
	globals->msg113 = stgopt(MSG113);
	globals->msg114 = stgopt(MSG114);
	globals->msg1364 = stgopt(MSG1364);
	globals->msg1365 = stgopt(MSG1365);
	globals->msg1366 = stgopt(MSG1366);
	globals->againkey = stgopt(AGAINKEY);
	globals->sysfame = ynopt(SYSFAME);
	globals->minturf = numopt(MINTURF, -32767, 32767);
	globals->wepfactr = numopt(WEPFACTR, -32767, 32767);
	globals->armfactr = numopt(ARMFACTR, -32767, 32767);
	globals->shdfactr = numopt(SHDFACTR, -32767, 32767);
	globals->combat = numopt(COMBAT, -32767, 32767);
	globals->daymins = numopt(DAYMINS, -32767, 32767);
	globals->talindex = numopt(TALINDEX, -32767, 32767);  
	globals->cachbufs = numopt(CACHBUFS, -32767, 32767);
	globals->slowtics = lngopt(SLOWTICS, 0L, GCMAXLONG);
	globals->bagtals = ynopt(BAGTALS);
	globals->autobank = ynopt(AUTOBANK);
	globals->robthfs = ynopt(ROBTHFS);
	globals->turfmin = numopt(TURFMIN, -32767, 32767);
	globals->evilness = numopt(EVILNESS, -32767, 32767);
	globals->bntyitem = numopt(BNTYITEM, -32767, 32767);
	globals->invasmin = numopt(INVASMN, -32767, 32767);
	globals->invasmax = numopt(INVASMX, -32767, 32767);
	globals->instlgld = lngopt(INSTGOLD, 1L, GCMAXLONG);
	globals->votemins = numopt(VOTEMINS, -32767, 32767);
	globals->votestat = numopt(VOTESTAT, -32767, 32767);
	globals->inactdys = numopt(INACTDYS, -32767, 32767);
	globals->voteterm = numopt(VOTETERM, -32767, 32767);
	globals->votedays = numopt(VOTEDAYS, -32767, 32767);
	globals->namesize = numopt(NAMESIZE, -32767, 32767);
	globals->pvplevel = numopt(PVPLEVEL, -32767, 32767);
	globals->bntymins = numopt(BNTYMINS, -32767, 32767);
	globals->offices[0] = stgopt(GUVNAME);
	globals->offices[1] = stgopt(PALNAME);
	globals->offices[2] = stgopt(ASSNAME);
	globals->offices[3] = stgopt(JDGNAME);
	globals->ttrack = numopt(TTRACK, -32767, 32767);
	globals->tfollow = numopt(TFOLLOW, -32767, 32767);
	globals->thide = numopt(THIDE, -32767, 32767);
	globals->tlose = numopt(TLOSE, -32767, 32767);
	globals->tstealth = numopt(TSTEALTH, -32767, 32767);
	globals->tlock = numopt(TLOCK, -32767, 32767);
	globals->tambush = numopt(TAMBUSH, -32767, 32767);
	globals->townsq = numopt(TOWNSQ, -32767, 32767);
	globals->newsstnd = numopt(NEWSSTND, -32767, 32767);
	globals->prison = numopt(PRISON, -32767, 32767);
	globals->sanctum = numopt(SANCTUM, -32767, 32767);
	globals->abank = numopt(ABANK, -32767, 32767);
	globals->amerc = numopt(AMERC, -32767, 32767);
	globals->anacad = numopt(ANACAD, -32767, 32767);
	globals->armorwgt = numopt(ARMORWGT, -32767, 32767);
	globals->shldwgt = numopt(SHLDWGT, -32767, 32767);
	globals->wepwgt = numopt(WEPWGT, -32767, 32767);
	globals->miscwgt = numopt(MISCWGT, -32767, 32767);
	globals->limboloc = numopt(LIMBOLOC, -32767, 32767);
	globals->thiefexp = numopt(THIEFEXP, -32767, 32767);
	globals->escape = numopt(ESCAPE, -32767, 32767);
	globals->startgld = numopt(STARTGLD, -32767, 32767);
	globals->cheapexp = (MLONG) numopt(CHEAPEXP, -32767, 32767);
	globals->bonusexp = (MLONG) numopt(BONUSEXP, -32767, 32767);
	globals->speedbon = numopt(SPEEDBON, -32767, 32767);
	globals->start2wp = numopt(START2WP, -32767, 32767);
	globals->startshd = numopt(STARTSHD, -32767, 32767);
	globals->shoplevl = numopt(SHOPLEVL, -32767, 32767);
	globals->twohndst = numopt(TWOHNDST, -32767, 32767);
	globals->wakeup = numopt(WAKEUP, -32767, 32767);
	globals->basempts = numopt(BASEMPTS, -32767, 32767);
	globals->baseexp = numopt(BASEEXP, -32767, 32767);
	globals->monexp = numopt(MONEXP, -32767, 32767);
	globals->encrate = numopt(ENCRATE, -32767, 32767);
	globals->flubfctr = numopt(FLUBFCTR, -32767, 32767);
	globals->goldfctr = numopt(GOLDFCTR, -32767, 32767);
	globals->treasure = numopt(TREASURE, -32767, 32767);
	globals->statcurv = numopt(STATCURV, -32767, 32767);
	globals->bashftg = numopt(BASHFTG, -32767, 32767);
	globals->moveftg = numopt(MOVEFTG, -32767, 32767);
	globals->folchnc = numopt(FOLCHNC, -32767, 32767);
	globals->bashtime = numopt(BASHTIME, -32767, 32767);
	globals->gbftg = numopt(GBFTG, -32767, 32767);
	globals->turfdur = numopt(TURFDUR, -32767, 32767);
	globals->hitftg = numopt(HITFTG, -32767, 32767);
	globals->ringdur = numopt(RINGDUR, -32767, 32767);
	globals->curvecut = numopt(CURVECUT, -32767, 32767);
	globals->strtstat = numopt(STRTSTAT, -32767, 32767);
	globals->minint = numopt(MININT, -32767, 32767);
	globals->noteable = numopt(NOTEABLE, -32767, 32767);

	globals->feefctr = numopt(FEEFACTR, -32767, 32767);
	if (globals->feefctr == 0)
	{
		globals->feefctr = 1;
	}

	globals->socvote = stgopt(SOCVOTE);
	globals->g1 = stgopt(GLOB1);
	globals->g2 = stgopt(GLOB2);
	globals->g3 = stgopt(GLOB3);
	globals->g4 = stgopt(GLOB4);
	globals->g5 = stgopt(GLOB5);
	globals->gldmsmx = numopt(GLDMSMX, -32767, 32767);
	globals->rover = numopt(ROVER, -32767, 32767);
	globals->rovrsecs = numopt(ROVRSECS, -32767, 32767);
	globals->invdsecs = numopt(INVDSECS, -32767, 32767);
	globals->socccr = numopt(SOCCCR, -32767, 32767);
	globals->wephits = numopt(WEPHITS, -32767, 32767);
	globals->huntmins = numopt(HUNTMINS, -32767, 32767);
	globals->huntqsts = numopt(HUNTRQST, -32767, 32767);
	globals->oraclegd = numopt(ORACLEGD, -32767, 32767);
	globals->strfctr = numopt(STRFCTR, -32767, 32767);
	globals->baguses = numopt(BAGUSES, -32767, 32767);
	globals->sysopkey = stgopt(SYSOPKEY); 
	globals->badchars = stgopt(BADCHARS);
	globals->maxposts = numopt(MAXPOSTS, -32767, 32767);
	globals->poobvote = numopt(POOBVOTE, -32767, 32767);
}    
/***************************************************************************
	set the configurable options
*/
void Check_Validus(short audit)
{
	short   i;
	short   demo_days;
	short   banned = FALSE;
	short   cur_days = cofdat(today());
	MLONG   key;
	char    mask[9];
	char    activation[9];
	char    *regnum;
	struct  demo_record_struct demo_record;

	globals->validus_users = 0;
	globals->demo = FALSE;

	regnum = spr("%s", bturno);

	for (i = 0; i != strlen(regnum); ++i)
	{
		if (regnum[i] != '0' && regnum[i] != '9')
		{
			++regnum[i];
		}
	}

	/* disabled regnums- note, these are encrypted. To get the 
	   actual regnum, subtract 1 from each non-0 and non-9 digit.
	   These are people who have either transferred ownership or
	   are known or suspected pirates */

	if
	(
		globals->actcode[0] == 0 ||
		atol(regnum) == 68570464L ||
		atol(regnum) == 43506744L ||
		atol(regnum) == 52964968L ||
		atol(regnum) == 26839509L ||
		atol(regnum) == 27947046L ||
		atol(regnum) ==  6922728L ||
		atol(regnum) == 37039902L ||
		atol(regnum) == 60243264L ||
		atol(regnum) == 26543239L || 
		atol(regnum) == 59909624L ||
		atol(regnum) == 69829924L ||
		atol(regnum) == 46724424L ||
		atol(regnum) == 50868736L ||  /* nonexistant? */
		atol(regnum) == 83833736L ||  /* gcomm pirate */
		atol(regnum) == 42869856L ||  /* gcomm pirate */
		atol(regnum) == 89093709L ||  /* gcomm pirate */
		atol(regnum) == 20430432L     /* pirate? 303-431-9894 */
	)
	{
		globals->demo = TRUE;
		banned = TRUE;
	}

	regnum = spr("%s", bturno);

	if (!globals->demo)
	{
#ifdef MBBS
#ifdef SOC2
		key = 47189342L;
#else
		key = 29356898L;
#endif
#else
#ifdef SOC2
		key = 39012756L;
#else
		key = 28569120L;
#endif
#endif
		sprintf(mask, "%ld", key); /* unlimited */
	
		for (i = 0; i != strlen(mask); ++i)
		{
			activation[i] = 'A' + regnum[i] - '0';
			activation[i] += mask[i] - '0';
		}
		activation[8] = 0;
		
		if (sameas(activation, globals->actcode))     
		{
			globals->validus_users = 101;
		}

		/*-------------------------------------*/

#ifdef MBBS
#ifdef SOC2
		key = 74510972L;
#else
		key = 18235133L;
#endif
#else
		key = 21950367L;
#endif
		sprintf(mask, "%ld", key); /* 32 user */
	
		for (i = 0; i != strlen(mask); ++i)
		{
			activation[i] = 'A' + regnum[i] - '0';
			activation[i] += mask[i] - '0';
		}
		activation[8] = 0;
		
		if (sameas(activation, globals->actcode))     
		{
			globals->validus_users = 101;
		}
		
		/*--------------------------------------*/

#ifdef MBBS
#ifdef SOC2
		key = 51209427L;
#else
		key = 83356743L;
#endif
#else
		key = 19291179L;
#endif
		sprintf(mask, "%ld", key); /* 16 user */
	
		for (i = 0; i != strlen(mask); ++i)
		{
			activation[i] = 'A' + regnum[i] - '0';
			activation[i] += mask[i] - '0';
		}
		activation[8] = 0;
		
		if (sameas(activation, globals->actcode))     
		{
			globals->validus_users = 101;
		}
		
		/*--------------------------------------*/

#ifdef MBBS
#ifdef SOC2
		key = 86048719L;
#else
		key = 32987150L;
#endif
#else
		key = 39630127L;
#endif
		sprintf(mask, "%ld", key); /* 8 user */
	
		for (i = 0; i != strlen(mask); ++i)
		{
			activation[i] = 'A' + regnum[i] - '0';
			activation[i] += mask[i] - '0';
		}
		activation[8] = 0;
		
		if (sameas(activation, globals->actcode))     
		{
			globals->validus_users = 101;
		}
		
		/*--------------------------------------*/

#ifdef MBBS
#ifdef SOC2
		key = 94751023L;
#else
		key = 30815952L;
#endif
#else
		key = 41045830L;
#endif

		sprintf(mask, "%ld", key); /* 4 user */
	
		for (i = 0; i != strlen(mask); ++i)
		{
			activation[i] = 'A' + regnum[i] - '0';
			activation[i] += mask[i] - '0';
		}
		activation[8] = 0;
		
		if (sameas(activation, globals->actcode))     
		{
			globals->validus_users = 101;
		}
		
		/*--------------------------------------*/

#ifdef MBBS
#ifdef SOC2
		key = 59619237L;
#else
		key = 58698734L;
#endif
#else
		key = 59307521L;
#endif

		sprintf(mask, "%ld", key); /* 2 user */
	
		for (i = 0; i != strlen(mask); ++i)
		{
			activation[i] = 'A' + regnum[i] - '0';
			activation[i] += mask[i] - '0';
		}
		activation[8] = 0;
		
		if (sameas(activation, globals->actcode))     
		{
			globals->validus_users = 101;
		}
	}

	globals->maxuser = numopt(MAXUSER, -32767, 32767) + 1;
	if (globals->maxuser > MAX_CHANNELS)
	{
		globals->maxuser = MAX_CHANNELS;
	}

	if (globals->validus_users)
	{
		if (globals->maxuser > globals->validus_users)
		{
			globals->maxuser = globals->validus_users;
		}
	}
	else
	{
		globals->validus_users = globals->maxuser;
		globals->demo = TRUE;

#ifdef MBBS
		setbtv(genbb);
#else
		dfaSetBlk(genbb);
#endif

#ifdef SOC2
		stzcpy(demo_record.modnam, gmdnam("MUISOC.MDF"), MNMSIZ);
		strcpy(demo_record.userid, "mjp");
#else
		stzcpy(demo_record.modnam, gmdnam("MUICHAOS.MDF"), MNMSIZ); 
		strcpy(demo_record.userid, "mjp");
#endif

#ifdef MBBS
		if (acqbtv(&demo_record, &demo_record, 0) || banned)
#else
		if (dfaAcqEQ(&demo_record, &demo_record, 0) || banned)
#endif
		{
			if (!banned)
			{
				demo_days = cofdat(demo_record.install_date);
			}

			if 
			(
				cur_days - demo_days >= DEMO_DAYS || 
				demo_days > cur_days ||
				banned
			)
			{
				if (audit)
				{
					NOTIFY("Deactivated!");
					NOTIFY("To register, call:");
					NOTIFY("Adept Communications");
					NOTIFY("800-294-3044");
				}

				globals->validus_users = 0;
			}
			else if (audit)
			{
				sprintf
				(
					str, 
					"%d more days", 
					DEMO_DAYS - (cur_days - demo_days)
				);
				NOTIFY(str);
			}
		}
		else
		{
			demo_record.install_date = today();
#ifdef MBBS
			invbtv(&demo_record, sizeof(demo_record));
#else
			dfaInsertV(&demo_record, sizeof(demo_record));
#endif

			if (audit)
			{
				NOTIFY("Demo Activated");
			}
		}

#ifdef MBBS
		rstbtv();
#else
		dfaRstBlk();
#endif
	}
}
/****************************************************************************
	Download Handler
*/
int Download_Handler(int tshcod)
{
	int     rc = FALSE;

	switch (tshcod)
	{
		case TSHVIS:
			rc = TRUE;
			break;

		case TSHDSC:
			sprintf(tshmsg, "file %s", ftgptr->tagspc);
			break;

		case TSHBEG:
#ifdef SOC2
			sprintf(tshmsg, "MUISOC\\DATA\\HELP\\%s", ftgptr->tagspc);
#else
			sprintf(tshmsg, "MUICHAOS\\DATA\\HELP\\%s", ftgptr->tagspc); 
#endif

			strcpy(ftfscb->fname, ftgptr->tagspc);
			rc = TRUE;
			break;

		case TSHFIN:
			setmbk(mui_cfg);
			usrptr->state = my_module;
			STATE = 0;
			rc = TRUE;
			prf("\rPress [ENTER]: ");
			
			if (usrptr->flags&CONCEX)
			{
				STATE = FINISHED_DOWNLOAD;
				btuchi(usrnum, NULL); 
			}
			else
			{
				STATE = DISPLAYING_OBITS;
			}

			rstmbk();

			break;
	}

	return (rc);
}
/****************************************************************************
	Display the main menu
*/
void Main_Menu(void)
{

	prf("%s%s", CLEAR_SCREEN, BOLD);
	prfmsg
	(
		MAINMENU,
		VERSION,
		ftimep.ft_month,
		ftimep.ft_day,
		ftimep.ft_year + 80,  
		ftimep.ft_hour,
		ftimep.ft_min
	);
	prfmsg(TOPPRMPT);
	STATE = MAIN_MENU_PROMPT;
}
/****************************************************************************
	send a message to the audit trail
*/
void NOTIFY(txt)
char    *txt;
{
	short   oldusn;

	oldusn = usrnum;
	usrnum = -1;

#ifdef SOC2
	sprintf(notify_buf, "SoCA: %s", txt);
#else
	sprintf(notify_buf, "SoC: %s", txt);
#endif

	shocst(notify_buf, "%s", txt);
	usrnum = oldusn;
}
/****************************************************************************
	set my class
*/
void Set_Class(void)
{

	if (a_char.class == WARRIOR)
	{
		strcpy(a_char.title, "Warrior");

		if (a_char.shield < 3)
		{
			a_char.shield = 3;
		}

		if (a_char.two_wep < 3)
		{
			a_char.two_wep = 3;
		}

		if (a_char.defense < 3)
		{
			a_char.defense = 3;
		}
	}
	else if (a_char.class == SORCERER)
	{
		strcpy(a_char.title, "Sorcerer");

		a_char.spell[LIGHTNING] = TRUE;
		a_char.spell[LANGOUR] = TRUE;
	}
	else if (a_char.class == BARBARIAN)
	{
		strcpy(a_char.title, "Barbarian");
	}
	else if (a_char.class == THIEF)
	{
		strcpy(a_char.title, "Thief");

		if (a_char.thief < START_THIEF)
		{
			a_char.thief = START_THIEF;
		}
	}
	else if (a_char.class == DUELIST)
	{
		strcpy(a_char.title, "Duelist");

		if (a_char.wep_plus[EDGED_IND] < 3)
		{
			a_char.wep_plus[EDGED_IND] = 3;
		}

		if (a_char.wep_plus[POLE_IND] < 3)
		{
			a_char.wep_plus[POLE_IND] = 3;
		}

		if (a_char.wep_plus[BLUNT_IND] < 3)
		{
			a_char.wep_plus[BLUNT_IND] = 3;
		}
	}
	else if (a_char.class == CLERIC)
	{
		strcpy(a_char.title, "Cleric");
		
		if (a_char.wep_plus[BLUNT_IND] < 5)
		{
			a_char.wep_plus[BLUNT_IND] = 5;
		}

		a_char.spell[HEAL] = TRUE;
		a_char.spell[VIGOR] = TRUE;
	}
	else if (a_char.class == MYSTIC)
	{
		strcpy(a_char.title, "Mystic");

		if (a_char.wep_plus[HAND_IND] < 5)
		{
			a_char.wep_plus[HAND_IND] = 5;
		}

		if (a_char.defense < 5)
		{
			a_char.defense = 5;
		}

		a_char.spell[BRING] = TRUE;
		a_char.spell[SEEK] = TRUE;
		a_char.spell[SAFE_RETURN] = TRUE;
	}

	Set_Guy_Points
	(
		&a_char.dpts, 
		&a_char.mpts, 
		a_char.Str, 
		a_char.Con, 
		a_char.Psy, 
		a_char.class
	);
}
/****************************************************************************
	set my race
*/
void Set_Race(void)
{

	if (a_char.race == ELF)
	{
		if (a_char.Psy < (globals->strtstat / 5) + 10)
		{
			a_char.Psy = (globals->strtstat / 5) + 10;
		}
	}
	else if (a_char.race == DWARF)
	{
		if (a_char.Con < (globals->strtstat / 5) + 10)
		{
			a_char.Con = (globals->strtstat / 5) + 10;
		}
	}
	else if (a_char.race == HUMAN)
	{
		if (a_char.Int < (globals->strtstat / 5) + 10)
		{
			a_char.Int = (globals->strtstat / 5) + 10;
		}
	}
	else if (a_char.race == OGRE)
	{
		if (a_char.Str < (globals->strtstat / 5) + 10)
		{
			a_char.Str = (globals->strtstat / 5) + 10;
		}
	}
	else if (a_char.race == HALFLING)
	{
		if (a_char.Dex < (globals->strtstat / 5) + 10)
		{
			a_char.Dex = (globals->strtstat / 5) + 10;
		}
	}

	Set_Guy_Points
	(
		&a_char.dpts, 
		&a_char.mpts, 
		a_char.Str, 
		a_char.Con, 
		a_char.Psy, 
		a_char.class
	);
}
/****************************************************************************
	text variable: SOCBLURB
*/
char * EXPORT tvar_socblurb(void)
{
	short   index;
		
	userid = usaptr->userid;
	index = Find_A_Char(&a_char, NULL);

	if (index < 0)
	{
		return(globals->blurb);
	}
	else
	{
		return("");
	}
}
/****************************************************************************
	text variable: SOCVER
*/
char * EXPORT tvar_socver(void)
{
		
	return(VERSION);
}
/****************************************************************************
	user wants to erase his character 
*/
void EXPORT Suicide(void)
{
	short   i;
	short   index;
	FILE    *fp_user;

	index = Find_A_Char(temp_char, NULL);
	
	if (index == big_warrior)
	{
		big_warrior = -2;
	}
	else if (index == big_sorcerer)
	{
		big_sorcerer = -2;
	}
	else if (index == big_barbarian)
	{
		big_barbarian = -2;
	}
	else if (index == big_thief)
	{
		big_thief = -2;
	}
	else if (index == big_duelist)
	{
		big_duelist = -2;
	}
	else if (index == big_cleric)
	{
		big_cleric = -2;
	}
	else if (index == big_mystic)
	{
		big_mystic = -2;
	}

	if (temp_char->guild_master)
	{
		Guild_Master_Died(temp_char->name, temp_char->in_guild);
	}

	if (temp_char->in_guild)
	{
		Resign(temp_char);
	}

	for (i = 0; i != NUM_ITEMS; ++i)
	{
		if (temp_char->item[i].what == CONTAINER)
		{
			Kill_Container(&temp_char->item[i]);
		}
	}

	Read_Closet(index, a_closet);
	for (i = 0; i != NUM_ITEMS; ++i)
	{
		if (a_closet->item[i].what == CONTAINER)
		{
			Kill_Container(&a_closet->item[i]);
		}
	}
	setmem(a_closet, CLOSET_SIZE, 0);
	Write_Closet(index, a_closet);
	Erase_Macros(index);
	Erase_Mail(index);
	Erase_Votes(index);

	fp_user = fopen(CHAOS_USER_FILE, RDWR);
	lsk = (MLONG) index * CHAR_SIZE;
	fseek(fp_user, lsk, TOP);
	strcpy(temp_char->name, BLANK_RECORD);
	fwrite(temp_char, CHAR_SIZE, 1, fp_user);
	fclose(fp_user);

	Write_Username(temp_char, index, FALSE);
	prfmsg(MSG1568);
}
/****************************************************************************
	user wants to switch class/race
*/
void EXPORT Switch(short option)
{
	short   i;
	short   index;
	short   mutate = numopt(MUTATE, -32767, 32767);
	float   cost = (float) numopt(SWTCHCST, -32767, 32767) / (float) 10;
	short   penalty = numopt(SWTCHCST, -32767, 32767);
	float   gold;
	FILE    *fp_user;

	if (option == 0) 
	{
		if (!a_char.perm[SUPER_PERM] && a_char.switches >= mutate)
		{
			if (mutate == 0)
			{
				prfmsg(MSG1570);
			}
			else
			{
				prfmsg(MSG1571);
			}

			return;
		}

		if (penalty != 10 && !a_char.perm[SUPER_PERM])
		{
			sprintf(str, getmsg(MSG1572), 100 - (penalty * 10), "%%");
			prf(str);
		}

		prfmsg(MSG1573);
		STATE = SWITCH_PROMPT;
		return;
	}

	index = Find_A_Char(temp_char, NULL);
	
	++temp_char->switches;
	temp_char->class = 'X';
	temp_char->race = 'X';

	if (!temp_char->perm[SUPER_PERM])
	{
		temp_char->Str = (float) temp_char->Str * cost;

		if (temp_char->Str < 1)
		{
			temp_char->Str = 1;
		}

		temp_char->Dex = (float) temp_char->Dex * cost;

		if (temp_char->Dex < 1)
		{
			temp_char->Dex = 1;
		}
	
		temp_char->Con = (float) temp_char->Con * cost;

		if (temp_char->Con < 1)
		{
			temp_char->Con = 1;
		}
	
		temp_char->Psy = (float) temp_char->Psy * cost;

		if (temp_char->Psy < 1)
		{
			temp_char->Psy = 1;
		}

		temp_char->Int = (float) temp_char->Int * cost;

		if (temp_char->Int < 1)
		{
			temp_char->Int = 1;
		}

		if (temp_char->thief > 0)
		{
			temp_char->thief = (float) temp_char->thief * cost;
		}

		if (temp_char->shield > 0)
		{
			temp_char->shield = (float) temp_char->shield * cost;
		}

		if (temp_char->two_wep > 0)
		{
			temp_char->two_wep = (float) temp_char->two_wep * cost;
		}

		if (temp_char->defense > 0)
		{
			temp_char->defense = (float) temp_char->defense * cost;
		}

		for (i = 0; i != NUM_WEAPONS; ++i)
		{
			if (temp_char->wep_plus[i] > 0)
			{
				temp_char->wep_plus[i] = (float) temp_char->wep_plus[i] * cost;
			}
		}

		if ((double) temp_char->bank + (double) temp_char->gold <= GCMAXLONG) 
		{
			gold = temp_char->bank + temp_char->gold;
		}
		else
		{
			gold = GCMAXLONG;
		}

		gold = gold * cost;
		temp_char->bank = (MLONG) gold;
		temp_char->gold = 0;
	}

	fp_user = fopen(CHAOS_USER_FILE, RDWR);
	lsk = (MLONG) index * CHAR_SIZE;
	fseek(fp_user, lsk, TOP);
	fwrite(temp_char, CHAR_SIZE, 1, fp_user);
	fclose(fp_user);

	Write_Username(temp_char, index, FALSE);
	prfmsg(MSG1569);
}
/****************************************************************************
	user wants to become an outlaw
*/
void EXPORT Outlaw(short option)
{
	short   index;
	FILE    *fp_user;

	if (option == 0)
	{
		if (!globals->outlaws)
		{
			prfmsg(MSG1575);
			return;
		}
		
		if (a_char.outlaw == 'Y')
		{
			prfmsg(MSG1576);
			return;
		}

		prfmsg(MSG1577);
		prfmsg(MSG1578); 
		STATE = OUTLAW_PROMPT;
		return;
	}

	index = Find_A_Char(temp_char, NULL);

	temp_char->outlaw = 'Y';
	fp_user = fopen(CHAOS_USER_FILE, RDWR);
	lsk = (MLONG) index * CHAR_SIZE;
	fseek(fp_user, lsk, TOP);
	fwrite(temp_char, CHAR_SIZE, 1, fp_user);
	fclose(fp_user);

	Write_Username(temp_char, index, FALSE);
	prfmsg(MSG1579);
}
/*****************************************************************************
	user wants to change his title and/or name
*/
void EXPORT Change_Name_Title(short option)
{
	short   i;
	short   j;
	short   index;
	FILE    *fp_user;

	if (option == RENAME_PROMPT)
	{
		if (margc)
		{
			rstrin();
			strncpy(name, input, globals->namesize);
			name[globals->namesize] = 0;

			for (i = 0; i != NAME_LEN && name[i] != 0; ++i)
			{
				if (name[i] <= ' ' || name[i] > '~')
				{
					name[i] = '_';
				}
				else
				{
					for (j = 0; j != strlen(globals->badchars); ++j)
					{
						if (name[i] == globals->badchars[j])
						{
							name[i] = '_';
						}
					}
				}
			}

			index = Find_A_Char(&a_char, name);
	
			if 
			(
				sameas(name, BLANK_RECORD) || 
				sameas(name, "x") || 
				index >= 0
			)
			{
				prfmsg(MSG1580, name);
				return;
			}
			
			index = Find_A_Char(temp_char, NULL);
			strcpy(temp_char->name, name);
			fp_user = fopen(CHAOS_USER_FILE, RDWR);
			lsk = (MLONG) index * CHAR_SIZE;
			fseek(fp_user, lsk, TOP);
			fwrite(temp_char, CHAR_SIZE, 1, fp_user);
			fclose(fp_user);
			Write_Username(temp_char, index, FALSE);

			prfmsg(MSG1581, temp_char->name, temp_char->title);
		}

		prfmsg(MSG1582);
		STATE = RETITLE_PROMPT;
		return;
	}
	
	if (margc)
	{
		rstrin();
		index = Find_A_Char(temp_char, NULL);
		
		strncpy(temp_char->title, input, TYPE_SIZE);
		temp_char->title[TYPE_SIZE - 1] = 0;

		fp_user = fopen(CHAOS_USER_FILE, RDWR);
		lsk = (MLONG) index * CHAR_SIZE;
		fseek(fp_user, lsk, TOP);
		fwrite(temp_char, CHAR_SIZE, 1, fp_user);
		fclose(fp_user);
		Write_Username(temp_char, index, FALSE);

		prfmsg(MSG1581, temp_char->name, temp_char->title);
	}
}


