#include <header.h>
#include <globals.h>

/****************************************************************************
    mail functions
*/
short EXPORT Mail_Menu(short option)
{

    MY_PORT->status = MAIL_PROMPT;

    if (option == 0)
    {
        prfmsg(MSG1491);
        Set_Prompt(getmsg(MSG1492), MAIL_PROMPT); 
    }
    else if (option == 1)
    {
        if (MY_PORT->hot_menu)
        {
            MY_PORT->hot_menu = FALSE;
            MY_PORT->status = DO_PROMPT;
        }
        else
        {
            Set_Prompt(getmsg(MSG1492), MAIL_PROMPT); 
        }
    }
    else if (sameas(margv[0], "A"))
    {
        Check_Mail(-1);
    }
    else if (sameas(margv[0], "B"))
    {
        if (me.posts >= globals->maxposts && !me.perm[GAMEOP_PERM])
        {
            prfmsg(MSG1317, globals->maxposts);
            Mail_Menu(1);
        }
        else
        {
            Set_Prompt(getmsg(MSG1493), POST_PROMPT);
        }
    }
    else if (sameas(margv[0], "C"))
    {
        Check_Public();
    }
    else if (sameas(margv[0], "D"))
    {
        if (me.posts >= globals->maxposts && !me.perm[GAMEOP_PERM])
        {
            prfmsg(MSG1317, globals->maxposts);
            Mail_Menu(1);
        }
        else
        {
            Post_Forum(0);
        }
    }
    else if (sameas(margv[0], "E"))
    {
        if (!me.perm[GAMEOP_PERM])
        {
            Mail_Menu(1);
        }
        else
        {
            Censor();
        }
    }          
    else
    {
        prfmsg(MSG1491);
        Set_Prompt(getmsg(MSG1492), MAIL_PROMPT);
    }
    
    DONE;
}
/****************************************************************************
    put a message in the public forum
*/
void EXPORT Put_Public_Message(struct public_post_struct *msg)
{
    short   n;
    short   msg_num;
    FILE    *fp_forum;

    if (msg->to == 0)
    {
        strcpy(globals->path, PUBLIC_FORUM);
    }
    else
    {
        sprintf(globals->path, "%s\\GUILD%d.DAT", GUILD_FORUM_PATH, msg->to);
        Create_New(globals->path);
    }
    
    fp_forum = fopen(globals->path, RDWR);
    n = fread(&file_header, PUBLIC_MSG_SIZE, 1, fp_forum);

    if (n != 1)
    {
        setmem(&file_header, PUBLIC_MSG_SIZE, 0);
        fseek(fp_forum, 0, TOP);
        fwrite(&file_header, PUBLIC_MSG_SIZE, 1, fp_forum);
        msg_num = 1;
    }
    else
    {
        lsk = (MLONG) PUBLIC_MSG_SIZE * -1;
        fseek(fp_forum, lsk, BOTTOM);
        fread(&temp_msg, PUBLIC_MSG_SIZE, 1, fp_forum);
        msg_num = temp_msg.msg_num + 1;
        if (msg_num > 32000)
        {
            msg_num = 1;
        }
    }

    msg->msg_num = msg_num;

    if (file_header.from == globals->gldmsmx)
    {
        for (n = 2; n <= globals->gldmsmx; ++n)
        {
            lsk = (MLONG) n * PUBLIC_MSG_SIZE;
            fseek(fp_forum, lsk, TOP);
            fread(&temp_msg, PUBLIC_MSG_SIZE, 1, fp_forum);

            lsk = ((MLONG) (n - 1)) * PUBLIC_MSG_SIZE;
            fseek(fp_forum, lsk, TOP);
            fwrite(&temp_msg, PUBLIC_MSG_SIZE, 1, fp_forum);
        }

        lsk = (MLONG) globals->gldmsmx * PUBLIC_MSG_SIZE;
        fseek(fp_forum, lsk, TOP);
        fwrite(msg, PUBLIC_MSG_SIZE, 1, fp_forum);
    }
    else
    {
        fclose(fp_forum);
        fp_forum = fopen(globals->path, APPEND);

        ++file_header.from;
        fwrite(msg, PUBLIC_MSG_SIZE, 1, fp_forum);
        
        fclose(fp_forum);
        fp_forum = fopen(globals->path, RDWR);
    }

    file_header.msg_num = msg_num;
    fseek(fp_forum, 0, TOP);
    fwrite(&file_header, PUBLIC_MSG_SIZE, 1, fp_forum);
    fclose(fp_forum);
}
/*****************************************************************************
    post a public message
*/
short EXPORT Post_Forum(short to_guild)
{
    char    prompt[LINE_SIZE];
    char    today_date[DATE_SIZE];
    char    now_time[TIME_SIZE];
    struct  public_post_struct *msg;
        
    msg = (struct public_post_struct *) vdaptr;                          
    
    if 
    (
        MY_PORT->status == MAIL_PROMPT || 
        MY_PORT->status == POST_GUILD_PROMPT
    )
    {
        setmem(msg, PUBLIC_MSG_SIZE, 0);
        msg->from = me.in_guild;

        if (to_guild)
        {
            msg->to = to_guild;

            if (msg->to < 1 || msg->to > NUM_SAVED_PLACES - 1)
            {
                prfmsg(M756, NUM_SAVED_PLACES - 1);
                Guild_Menu(1);
                BAD_EXIT;
            }
            
            if (sameas(guild->name[msg->to], OPEN_GUILD))
            {
                prfmsg(MSG1499, msg->to);
                Guild_Menu(1);
                BAD_EXIT;
            }

            prfmsg(MSG1245, guild->name[msg->to]);
        }
        else
        {
            prfmsg(MSG1247);
            msg->to = 0;
        }
        
        TODAY(today_date);
        NOW(now_time);

        if (!me.in_guild)
        {
            sprintf
            (
                str, 
                getmsg(MSG1251A),
                me.name,
                Brief_Userid(me.Userid),
                today_date,
                now_time
            );
        }
        else 
        {
            sprintf
            (  
                str, 
                getmsg(MSG1252A),
                me.name,
                Brief_Userid(me.Userid),
                today_date,
                now_time,
                me.in_guild
            );
        }

        strcpy(msg->header, str);
        MY_PORT->misc = 0;
        prfmsg(MSG1254);
        sprintf(prompt, getmsg(MSG1255), MY_PORT->misc + 1, MESSAGE_LEN);
        Set_Prompt(prompt, GET_PUB_BODY_PROMPT);
        btumil(usrnum, LINE_SIZE - 1);
        DONE;
    }

    if (sameas(margv[0], "/c") || sameas(margv[0], "x"))
    {
        prfmsg(MSG1256);
        btumil(usrnum, 127);

        if (msg->to == 0)
        {
            Mail_Menu(1);
        }
        else
        {
            Guild_Menu(1);
        }

        DONE;
    }
    
    if (!sameas(margv[0], "/s"))
    {
        rstrin();

        if (strlen(input) > LINE_SIZE - 1)
        {
            input[LINE_SIZE - 1] = 0;
        }

        strcpy(msg->body[MY_PORT->misc], input);
        ++MY_PORT->misc;
        
        if (MY_PORT->misc < MESSAGE_LEN)
        {
            sprintf(prompt, getmsg(MSG1255), MY_PORT->misc + 1, MESSAGE_LEN);
            Set_Prompt(prompt, GET_PUB_BODY_PROMPT);
            btumil(usrnum, LINE_SIZE - 1);
            DONE;
        }
    }

    if (!MY_PORT->misc)
    {
        prfmsg(MSG1257);
        btumil(usrnum, 127);

        if (msg->to == 0)
        {
            Mail_Menu(1);
        }
        else
        {
            Guild_Menu(1);
        }
        BAD_EXIT;
    }
    
    Put_Public_Message(msg);

    if (msg->to == 0)
    {
        prfmsg(MSG1258A);
        Mail_Menu(1);
    }
    else
    {
        prfmsg(MSG1262);
        Guild_Menu(1);
    }

    btumil(usrnum, 127);
    ++me.posts;
    DONE;
}
/*****************************************************************************
    post a message to someone's mailbox
*/
short EXPORT Post(void)
{
    FILE    *fp;
    short   i;
    char    today_date[DATE_SIZE];
    char    now_time[TIME_SIZE];
    char    prompt[10];
    struct  brief_char_struct brief;
    struct  post_struct *msg;    
        
    msg = (struct post_struct *) vdaptr;                  

    if (MY_PORT->status != GET_MSG_BODY_PROMPT)
    {
        setmem(msg, MSG_SIZE, 0);
        MY_PORT->misc2 = Find_Name_Index(margv[0], &brief);

        if (MY_PORT->misc2 < 0)
        {
            prfmsg(M920, margv[0]);
            Mail_Menu(1);
            BAD_EXIT;
        }

        prfmsg(MSG1260, brief.name);
        TODAY(today_date);
        NOW(now_time);

        sprintf
        (
            msg->from,
            getmsg(MSG1261),
            me.name,
            Brief_Userid(me.Userid),
            today_date,
            now_time
        );

        MY_PORT->misc = 0;
        prfmsg(MSG1254);
        
        sprintf(prompt, getmsg(MSG1255), MY_PORT->misc + 1, MESSAGE_LEN);
        Set_Prompt(prompt, GET_MSG_BODY_PROMPT);
        btumil(usrnum, LINE_SIZE - 1);
        DONE;
    }

    if (sameas(margv[0], "/c") || sameas(margv[0], "x"))
    {
        prfmsg(MSG1256);
        MY_PORT->status = DO_PROMPT;
        btumil(usrnum, 127);
        Mail_Menu(1);
        DONE;
    }
    
    if (!sameas(margv[0], "/s"))
    {
        rstrin();

        if (strlen(input) > LINE_SIZE - 1)
        {
            input[LINE_SIZE - 1] = 0;
        }

        strcpy(msg->body[MY_PORT->misc], input);
        ++MY_PORT->misc;
        
        if (MY_PORT->misc < MESSAGE_LEN)
        {
            sprintf(prompt, getmsg(MSG1255), MY_PORT->misc + 1, MESSAGE_LEN);
            Set_Prompt(prompt, GET_MSG_BODY_PROMPT);
            btumil(usrnum, LINE_SIZE - 1);
            DONE;
        }
    }

    if (!MY_PORT->misc)
    {
        prfmsg(MSG1257);
        btumil(usrnum, 127);
        Mail_Menu(1);
        BAD_EXIT;
    }

    sprintf(globals->path, "%s\\MAIL%d.DAT", MAIL_PATH, MY_PORT->misc2);
    Create_New(globals->path);
    fp = fopen(globals->path, APPEND); 
    
    if (fp == NULL)
    {
        NOTIFY("MAIL OPEN FAILED!");
        prf("file error\r");
        btumil(usrnum, 127);
        Mail_Menu(1);
        BAD_EXIT;
    }
    
    fwrite(msg, MSG_SIZE, 1, fp);
    fclose(fp);
    
    ++me.posts;
    btumil(usrnum, 127);
    prfmsg(MSG1262);

    for (i = 0; i != NTERMS; ++i)
    {
        if (APORT(i)->status && APORT(i)->index == MY_PORT->misc2)
        {
            sprintf(str, getmsg(MSG1263), me.name);
            Message(str, i);
        }
    }

    Mail_Menu(1);
    DONE;
}
/*****************************************************************************
    check user's mail
*/
short EXPORT Check_Mail(short close_it)
{
    short   i;
    short   n;
    struct  post_struct msg;

    if (close_it != -1)
    {
        fclose(APORT(close_it)->fp);
    }

    if (MY_PORT->status == MAIL_PROMPT)
    {
        sprintf(globals->path, "%s\\MAIL%d.DAT", MAIL_PATH, MY_PORT->index); 
        MY_PORT->fp = fopen(globals->path, RDWR);

        if (MY_PORT->fp == NULL)
        {
            prfmsg(MSG1264);
            Mail_Menu(1);
            DONE;
        }
    }
    else if (MY_PORT->status == ERASE_MSG_PROMPT)
    {
        if (sameas(margv[0], "y"))
        {
           sprintf(globals->path, "%s\\MAIL%d.DAT", MAIL_PATH, MY_PORT->index); 
           unlink(globals->path);
           prfmsg(MSG1265);
        }
           
        Mail_Menu(1);
        DONE;
    }
    else if (MY_PORT->status == NEXT_MSG_PROMPT)
    {
        if (sameas(margv[0], "n"))
        {
            fclose(MY_PORT->fp);
            Mail_Menu(1);
            DONE;
        }
    }

    n = fread(&msg, MSG_SIZE, 1, MY_PORT->fp);

    if (n == 0)
    {
        fclose(MY_PORT->fp);
        Set_Prompt(getmsg(MSG1266), ERASE_MSG_PROMPT);
        DONE;
    }
    
    prf("\r");
    prfmsg(MSG1267, msg.from);

    for (i = 0; i != MESSAGE_LEN; ++i)
    {
        if (msg.body[i][0])
        {
            prfmsg(MSG1274, msg.body[i]);
        }
    }

    prf("\r");
    n = fread(&msg, MSG_SIZE, 1, MY_PORT->fp);
    
    if (n == 0)
    {
        fclose(MY_PORT->fp);
        Set_Prompt(getmsg(MSG1266), ERASE_MSG_PROMPT);
        DONE;
    }
    
    lsk = (MLONG) MSG_SIZE * (-1); 
    fseek(MY_PORT->fp, lsk, CURRENT_LOC);
    Set_Prompt(getmsg(MSG1243), NEXT_MSG_PROMPT);
    DONE;
}
/****************************************************************************
    see if I have any personal mail
*/
void EXPORT New_Mail_Check(void)
{
    FILE    *fp;

    sprintf(globals->path, "%s\\MAIL%d.DAT", MAIL_PATH, MY_PORT->index); 
    fp = fopen(globals->path, RDWR);
    if (fp != NULL)
    {
        prfmsg(MSG1268A);
        fclose(fp);
    }
}
/****************************************************************************
    remove my mail file
*/
void EXPORT Erase_Mail(short index)
{

    sprintf(globals->path, "%s\\MAIL%d.DAT", MAIL_PATH, index); 
    unlink(globals->path);
}
/*****************************************************************************
    check public messages
*/
short EXPORT Check_Public(void)
{
    short   i;
    short   done = FALSE;
    short   n;
    FILE    *fp_forum;

    if (MY_PORT->status == MAIL_PROMPT)
    {
        fp_forum = fopen(PUBLIC_FORUM, RDWR);
        n = fread(&file_header, PUBLIC_MSG_SIZE, 1, fp_forum);
        fclose(fp_forum);

        if (n == 0)
        {
            prfmsg(MSG1240A);
            Mail_Menu(1);
            BAD_EXIT;
        }

        sprintf
        (
            str,
            getmsg(MSG1494),
            file_header.msg_num - file_header.from + 1,
            file_header.msg_num
        );
        Set_Prompt(str, FORUM_PROMPT);
        DONE;
    }

    if (MY_PORT->status == FORUM_PROMPT)
    {
        fp_forum = fopen(PUBLIC_FORUM, RDWR);
        fread(&file_header, PUBLIC_MSG_SIZE, 1, fp_forum);
        fclose(fp_forum);

        if (margc == 0)
        {
            MY_PORT->misc = me.public_read + 1;
        }
        else
        {
            MY_PORT->misc = INUM(margv[0]);
        }

        if (MY_PORT->misc > file_header.msg_num)
        {
            MY_PORT->misc = file_header.msg_num;
        }
        else if (MY_PORT->misc < 1)
        {
            MY_PORT->misc = 1;
        }

        MY_PORT->misc2 = 1;
    }
    else if (sameas(margv[0], "n"))
    {
        me.public_read = MY_PORT->misc - 1;
        Mail_Menu(1);
        DONE;
    }

    fp_forum = fopen(PUBLIC_FORUM, RDWR);

    do
    {
        lsk = (MLONG) MY_PORT->misc2 * PUBLIC_MSG_SIZE;
        fseek(fp_forum, lsk, TOP);
        n = fread(&temp_msg, PUBLIC_MSG_SIZE, 1, fp_forum);

        if (n == 0)
        {
            prfmsg(MSG1241);
            me.public_read = MY_PORT->misc;
            fclose(fp_forum);
            Mail_Menu(1);
            DONE;
        }
        
        if (temp_msg.msg_num < MY_PORT->misc)
        {
            ++MY_PORT->misc2;
        }
        else
        {
            MY_PORT->misc = temp_msg.msg_num;
            prfmsg(MSG1273, temp_msg.msg_num, temp_msg.header);

            for (i = 0; i != MESSAGE_LEN; ++i)
            {
                if (temp_msg.body[i][0])
                {
                    prfmsg(MSG1274, temp_msg.body[i]);
                }
            }

            prf(NL);

            lsk = (MLONG) (MY_PORT->misc2 + 1) * PUBLIC_MSG_SIZE;
            fseek(fp_forum, lsk, TOP);
            n = fread(&temp_msg, PUBLIC_MSG_SIZE, 1, fp_forum);

            if (n == 0)
            {   
                prfmsg(MSG1241);
                me.public_read = MY_PORT->misc;
                fclose(fp_forum);
                Mail_Menu(1);
                DONE;
            }

            ++MY_PORT->misc2;
            fclose(fp_forum);
            Set_Prompt(getmsg(MSG1243), READ_FORUM_PROMPT);
            DONE;
        }   
    }       
    while (!done);

    me.public_read = MY_PORT->misc;
    prfmsg(MSG1241);
    fclose(fp_forum);
    Mail_Menu(1);
    DONE;
}
/*****************************************************************************
    check guild forum messages
*/
short EXPORT Check_Guild_Forum(void)
{
    short   i;
    short   done = FALSE;
    short   n = 0;
    FILE    *fp_forum;

    sprintf(globals->path, "%s\\GUILD%d.DAT", GUILD_FORUM_PATH, me.in_guild);

    if (MY_PORT->status == GUILD_PROMPT)
    {
        fp_forum = fopen(globals->path, RDWR);

        if (fp_forum != NULL)
        {
            n = fread(&file_header, PUBLIC_MSG_SIZE, 1, fp_forum);
            fclose(fp_forum);
        }

        if (n == 0)
        {
            prfmsg(MSG1240B);
            Guild_Menu(1);
            BAD_EXIT;
        }

        sprintf
        (
            str,
            getmsg(MSG1494),
            file_header.msg_num - file_header.from + 1,
            file_header.msg_num
        );
        Set_Prompt(str, GUILD_FORUM_PROMPT);
        DONE;
    }

    if (MY_PORT->status == GUILD_FORUM_PROMPT)
    {
        fp_forum = fopen(globals->path, RDWR);
        fread(&file_header, PUBLIC_MSG_SIZE, 1, fp_forum);
        fclose(fp_forum);

        if (margc == 0)
        {
            MY_PORT->misc = me.guild_read + 1;
        }
        else
        {
            MY_PORT->misc = INUM(margv[0]);
        }

        if (MY_PORT->misc > file_header.msg_num)
        {
            MY_PORT->misc = file_header.msg_num;
        }
        else if (MY_PORT->misc < 1)
        {
            MY_PORT->misc = 1;
        }

        MY_PORT->misc2 = 1;
    }
    else if (sameas(margv[0], "n"))
    {
        me.guild_read = MY_PORT->misc - 1;
        Guild_Menu(1);
        DONE;
    }

    fp_forum = fopen(globals->path, RDWR);

    do
    {
        lsk = (MLONG) MY_PORT->misc2 * PUBLIC_MSG_SIZE;
        fseek(fp_forum, lsk, TOP);
        n = fread(&temp_msg, PUBLIC_MSG_SIZE, 1, fp_forum);

        if (n == 0)
        {
            prfmsg(MSG1241);
            me.guild_read = MY_PORT->misc;
            fclose(fp_forum);
            Guild_Menu(1);
            DONE;
        }
        
        if (temp_msg.msg_num < MY_PORT->misc)
        {
            ++MY_PORT->misc2;
        }
        else
        {
            MY_PORT->misc = temp_msg.msg_num;
            prfmsg(MSG1273, temp_msg.msg_num, temp_msg.header);

            for (i = 0; i != MESSAGE_LEN; ++i)
            {
                if (temp_msg.body[i][0])
                {
                    prfmsg(MSG1274, temp_msg.body[i]);
                }
            }

            prf(NL);

            lsk = (MLONG) (MY_PORT->misc2 + 1) * PUBLIC_MSG_SIZE;
            fseek(fp_forum, lsk, TOP);
            n = fread(&temp_msg, PUBLIC_MSG_SIZE, 1, fp_forum);

            if (n == 0)
            {   
                prfmsg(MSG1241);
                me.guild_read = MY_PORT->misc;
                fclose(fp_forum);
                Guild_Menu(1);
                DONE;
            }

            ++MY_PORT->misc2;
            fclose(fp_forum);
            Set_Prompt(getmsg(MSG1243), READ_GUILD_FORUM_PROMPT);
            DONE;
        }   
    }       
    while (!done);

    me.guild_read = MY_PORT->misc;
    prfmsg(MSG1241);
    fclose(fp_forum);
    Guild_Menu(1);
    DONE;
}
/*****************************************************************************
    inform user of unread public messages
*/
void EXPORT New_Public(void)
{
    short   n;
    FILE    *fp_forum;

    fp_forum = fopen(PUBLIC_FORUM, RDWR);
    n = fread(&temp_msg, PUBLIC_MSG_SIZE, 1, fp_forum);
    fclose(fp_forum);

    if (n == 0)
    {
        me.public_read = 0;
    }
    else if (temp_msg.msg_num < me.public_read)
    {
        me.public_read = temp_msg.msg_num;
    }
    else if (temp_msg.msg_num > me.public_read)
    {
        prfmsg(MSG1244A);
    }
}
/*****************************************************************************
    inform user of unread guild messages
*/
void EXPORT New_Guild_Messages(short g)
{
    short   n = 0;
    FILE    *fp_forum;

    sprintf(globals->path, "%s\\GUILD%d.DAT", GUILD_FORUM_PATH, g);
    fp_forum = fopen(globals->path, RDWR);

    if (fp_forum != NULL)
    {
        n = fread(&temp_msg, PUBLIC_MSG_SIZE, 1, fp_forum);
        fclose(fp_forum);
    }

    if (n == 0)
    {
        me.guild_read = 0;
    }
    else if (temp_msg.msg_num < me.guild_read)
    {
        me.guild_read = temp_msg.msg_num;
    }
    else if (temp_msg.msg_num > me.guild_read)
    {
        prfmsg(MSG1500);
    }
}
/*****************************************************************************
    censor a public message
*/
short EXPORT Censor(void)
{
    short   i;
    short   n;
    FILE    *fp_forum;

    if (MY_PORT->status == MAIL_PROMPT)
    {
        fp_forum = fopen(PUBLIC_FORUM, RDWR);
        n = fread(&file_header, PUBLIC_MSG_SIZE, 1, fp_forum);
        fclose(fp_forum);

        if (n == 0)
        {
            prfmsg(MSG1240A);
            Mail_Menu(1);
            BAD_EXIT;
        }

        sprintf
        (
            str,
            getmsg(MSG1495),
            file_header.msg_num - file_header.from + 1,
            file_header.msg_num
        );
        Set_Prompt(str, CENSOR_PROMPT);
        DONE;
    }

    if (MY_PORT->status == CENSOR_PROMPT)
    {
        fp_forum = fopen(PUBLIC_FORUM, RDWR);
        fread(&file_header, PUBLIC_MSG_SIZE, 1, fp_forum);
        fclose(fp_forum);

        MY_PORT->misc = INUM(margv[0]);

        if 
        (
            MY_PORT->misc > file_header.msg_num ||
            MY_PORT->misc < file_header.msg_num - file_header.from + 1
        )
        {
            Mail_Menu(1);
            DONE;
        }
    }

    fp_forum = fopen(PUBLIC_FORUM, RDWR);
    lsk = (MLONG) MY_PORT->misc * PUBLIC_MSG_SIZE;
    fseek(fp_forum, lsk, TOP);
    n = fread(&temp_msg, PUBLIC_MSG_SIZE, 1, fp_forum);

    if (n == 1)
    {
        for (i = 0; i != MESSAGE_LEN; ++i)
        {
            temp_msg.body[i][0] = 0;
        }

        strcpy(temp_msg.body[0], "**This Message Has Been Censored**");
        fseek(fp_forum, lsk, TOP);
        fwrite(&temp_msg, PUBLIC_MSG_SIZE, 1, fp_forum);
    }

    fclose(fp_forum);
    prfmsg(MSG1496);
    Mail_Menu(1);
    DONE;
}

