#include <header.h>
#include <globals.h>

/****************************************************************************
	user wants to chant open a door
*/
short EXPORT Chant(char *text)
{

	if 
	(
		ABUF(B)->rm.spec_exit.type != CHANT_DOOR ||
		ABUF(B)->rm.spec_exit.leads_to == 0 ||
		ABUF(B)->rm.chant[0] == 0
	)
	{
		prfmsg(M558);
		BAD_EXIT;
	}
	
	if (!sameas(ABUF(B)->rm.chant, text))
	{
		prfmsg(M558);
		BAD_EXIT;
	}

	if (!ABUF(B)->rm.spec_exit.locked)
	{
		strcpy(name, "locked");
		ABUF(B)->rm.spec_exit.locked = TRUE;
		sprintf(str, getmsg(MSG559), me.name);
	}
	else
	{
		strcpy(name, "unlocked");
		ABUF(B)->rm.spec_exit.locked = FALSE;
		sprintf(str, getmsg(MSG560), me.name);
	}
			
	cat_spec_ex(str);
	Message(str, LOUD_LOCAL);
	prfmsg(MSG561, name);

	return (TRUE);
}
/****************************************************************************
	user wants to instill a spell into an item
*/
short Instill(void)
{
	MLONG   cost;
	short   i;
	short   count;
	short   spell_num;
	short   index;
	short   absolute_match  = 0;
	short   fail_chance = numopt(INSTFAIL, -32767, 32767);

	if 
	(
		me.class != SORCERER && 
		me.class != CLERIC && 
		me.class != MYSTIC &&
		!ynopt(ALLINSTL)
	)
	{
		prfmsg(M562);
		BAD_EXIT;
	}

	if (word1[0] == 0)
	{
		prfmsg(M563);
		BAD_EXIT;
	}

	index = find_item(word1, which1, 1, &absolute_match);

	if (index < 0)
	{
		BAD_EXIT;
	}

	item = me.item[index];
	
	if 
	(
		!ARSH(item) && 
		item.what != TRINKET && 
		item.what != JOOLS &&
		item.what != MAGIC_DEV && 
		!WEAPON(item)
	)
	{
		prfmsg(M565);
		BAD_EXIT;
	}

	if (item.no_instill)
	{
		prfmsg(MSG1490, "instilled");
		BAD_EXIT;
	}

	spell_num = INUM(word2);

	if (spell_num < 1 || spell_num > NUM_SPELLS)
	{
		for (i = count = 0; i != NUM_SPELLS; ++i)
		{
			if (sameto(word2, spell_info[i].name))
			{
				++count;
				spell_num = i;
			}
		}
	}
	else
	{
		--spell_num;
		count = 1;
	}

	if (count > 1)
	{
		prfmsg(M167, word2);
		BAD_EXIT;
	}

	if (count == 0)
	{
		prfmsg(M566, word2);
		BAD_EXIT;
	}

	if (!me.perm[MPTS_PERM])
	{
		if (me.spell[spell_num] == 0)
		{
			prfmsg(M567);
			BAD_EXIT;
		}
		
		if (Local_Psy(P) < spell_info[spell_num].power)
		{
			short ok = FALSE;

			if 
			(
				me.class == SORCERER && 
				(spell_num == LIGHTNING || spell_num == LANGOUR)
			)
			{
				ok = TRUE;
			}
			else if
			(
				me.class == CLERIC &&
				(spell_num == HEAL || spell_num == VIGOR)
			)
			{
				ok = TRUE;
			}
			else if
			(
				me.class == MYSTIC &&
				(
					spell_num == BRING || 
					spell_num == SEEK || 
					spell_num == SAFE_RETURN
				)
			)
			{
				ok = TRUE;
			}

			if (!ok)
			{
				prfmsg(M568, spell_info[spell_num].power);
				BAD_EXIT;
			}
		}
	}

	if (ARSH(item))
	{
		if (me.armor == index)
		{                                               
			prfmsg(MSG1480);
			BAD_EXIT;
		}

		if (me.shld == index)
		{                                               
			prfmsg(MSG1481);
			BAD_EXIT;
		}

		cost = (MLONG) globals->instlgld * (MLONG) spell_info[spell_num].pts;

		if 
		(
			spell_num != REVEAL &&
			spell_num != VIGOR &&       
			spell_num != HEAL &&
			spell_num != INVISIBILITY &&
			spell_num != PURIFY &&
			spell_num != RESTORE &&
			spell_num != PROTECT &&
			spell_num != LEVITATE &&
			spell_num != INVULNERABILITY &&
			spell_num != STRENGTH &&
			spell_num != STURDINESS &&
			spell_num != MAGIC_SHIELD &&
			spell_num != SEE_INVISIBLE &&
			spell_num != HASTE &&
			spell_num != STEALTH &&
			spell_num != MANIA
		)
		{
			prfmsg(M569, spell_info[spell_num].name);
			BAD_EXIT;
		}
	}
	else if (WEAPON(item))
	{
		if (me.lw == index || me.rw == index)
		{                                               
			prfmsg(MSG1481);
			BAD_EXIT;
		}

		cost = (MLONG) globals->instlgld * (MLONG) spell_info[spell_num].pts;
		
		if
		(
			spell_num != LANGOUR &&
			spell_num != MESMERIZE &&
			spell_num != LIGHTNING &&
			spell_num != BLAST &&
			spell_num != EXHAUSTION &&
			spell_num != FIREBALL &&
			spell_num != WEAKNESS &&
			spell_num != DISPEL_MAGIC &&
			spell_num != CURSE
		)
		{
			prfmsg(M570, spell_info[spell_num].name);
			BAD_EXIT;
		}
	}
	else
	{
		cost = (MLONG) globals->instlgld * (MLONG) spell_info[spell_num].pts;
		cost = cost / 10;
	}

	if (me.gold + me.bank < cost && !me.perm[SUPER_PERM])
	{
		sprintf(str, getmsg(M571), cost);
		prf(str);
		BAD_EXIT;
	}

	me.gold -= cost;
	if (me.gold < 0)
	{
		me.bank += me.gold;
		me.gold = 0;
	}

	sprintf(str, getmsg(MSG572), cost);
	prf(str);

	if (RANDOM(100) < fail_chance)
	{
		prfmsg(MSG1011, me.item[index].name);
		Lose_Item(index);
		BAD_EXIT;
	}

	if (!ARSH(item))
	{
		me.item[index].item_level = Stat_Lev(Local_Psy(P));
	}

	me.item[index].spell_cast = spell_num;

	if (item.what == TRINKET || item.what == JOOLS)
	{
		me.item[index].what = MAGIC_DEV;
		me.item[index].which = 0;
		me.item[index].uses = Stat_Lev(Local_Psy(P)) + 1;
		
		if (me.item[index].uses > 100)
		{
			me.item[index].uses = 100;
		}

		prfmsg(MSG573, me.item[index].name, spell_info[spell_num].name);
	}
	else
	{
		me.item[index].ring_used = TRUE;
		me.item[index].uses += Stat_Lev(Local_Psy(P)) + 1;

		prfmsg(MSG574, me.item[index].name, spell_info[spell_num].name);
	}

	DONE;
}
/****************************************************************************
	user wants to enter a trance
*/
short Trance(void)
{
	int     g;

	if (me.class != SORCERER && me.class != MYSTIC && me.class != CLERIC)
	{
		prfmsg(M575);
		BAD_EXIT;
	}

	if (!action_ok())
	{
		BAD_EXIT;
	}

	prfmsg(MSG576);
	sprintf(str, getmsg(MSG577), me.name);
	Message(str, QUIET_LOCAL);
	MY_PORT->trance = TRUE;
	MY_PORT->action_timer = 10;
   
	for (g = 0; g != NTERMS; ++g)
	{
		APORT(g)->follower[P] = 0;
	}

	DONE;
}
/****************************************************************************
	user wants to cancel certain spells
*/
short uncast_spells(void)
{
	short   t;
	short   i;
	short   count;
	short   spell_num;
	short   did_one = 0;

	if (!word1[0])
	{
		spell_num = -1;
	}
	else
	{
		spell_num = INUM(word1);
	
		if (spell_num < 1 || spell_num > NUM_SPELLS)
		{
			for (i = count = 0; i != NUM_SPELLS; ++i)
			{
				if (sameto(word1, spell_info[i].name))
				{
					++count;
					spell_num = i;
				}
			}
		}
		else
		{
			--spell_num;
			count = 1;
		}
	
		if (count > 1)
		{
			prfmsg(M167, word1);
			BAD_EXIT;
		}
	
		if (count == 0)
		{
			prfmsg(M566, word1);
			BAD_EXIT;
		}
	}

	if (spell_num < 0 || spell_num == PROTECT)
	{
		for (t = 0; t != NUM_GUY_TIMERS; ++t)
		{
			if (MY_PORT->misc_type[t] == PROTECTED_TIME)
			{
				did_one = TRUE;
				MY_PORT->timer[t] = 1;
			}
		}
	}

	if (spell_num < 0 || spell_num == LEVITATE)
	{
		for (t = 0; t != NUM_GUY_TIMERS; ++t)
		{
			if (MY_PORT->misc_type[t] == FLOAT_TIME)
			{
				did_one = TRUE;
				MY_PORT->timer[t] = 1;
			}
		}
	}

	if (spell_num < 0 || spell_num == MAGIC_SHIELD)
	{
		for (t = 0; t != NUM_GUY_TIMERS; ++t)
		{
			if (MY_PORT->misc_type[t] == SHIELD_TIME)
			{
				did_one = TRUE;
				MY_PORT->timer[t] = 1;
			}
		}
	}

	if (spell_num < 0 || spell_num == INVISIBILITY)
	{
		for (t = 0; t != NUM_GUY_TIMERS; ++t)
		{
			if (MY_PORT->misc_type[t] == INVISIBLE_TIME)
			{
				did_one = TRUE;
				MY_PORT->timer[t] = 1;
			}
		}
	}

	if (spell_num == SAFE_RETURN)
	{
		if (me.return_to)
		{
			me.return_to = 0;
			did_one = TRUE;
			prfmsg(MSG1294);
		}
		else
		{
			prfmsg(MSG1295);
		}
	}

	if (!did_one)
	{
		prfmsg(M578);
		BAD_EXIT;
	}
	
	return (TRUE);
}
/****************************************************************************
	user wants to cast a spell
*/
short cast(void)
{
	short   count;
	short   spell_num;
	short   i;
	short   revealed;
	short   pts;

	if (word1[0] == 0)
	{
		prfmsg(M579);
		BAD_EXIT;
	}

	spell_num = INUM(word1);

	if (spell_num < 1 || spell_num > NUM_SPELLS)
	{
		for (i = count = 0; i != NUM_SPELLS; ++i)
		{
			if (sameto(word1, spell_info[i].name))
			{
				++count;
				spell_num = i;
			}
		}
	}
	else
	{
		--spell_num;
		count = 1;
	}

	if (count > 1)
	{
		prfmsg(M167, word1);
		BAD_EXIT;
	}

	if (count == 0)
	{
		prfmsg(M566, word1);
		BAD_EXIT;
	}

	if (me.spell[spell_num] == 0)
	{
		prfmsg(M567);
		BAD_EXIT;
	}
	
	if (me.armor >= 0 && !me.perm[SUPER_PERM])
	{
		if (me.item[me.armor].which != LITE_ARMOR)
		{
			prfmsg(M582);
			BAD_EXIT;
		}
	}

	if (spell_num != ELICITATION && !action_ok())
	{
		BAD_EXIT;
	}

	revealed = Make_Magic(spell_num, word2, which2, -1);

	if (!revealed)
	{
		return (FALSE);
	}

	if (me.focus >= 0 && me.item[me.focus].uses <= 0)
	{
		Lose_Item(me.focus);
	}

	if (!me.perm[MPTS_PERM])
	{
		pts = spell_info[spell_num].pts;

		if (me.class == CLERIC)
		{
			pts = pts / 2;
		}

		me.magic_used += pts;
	}

	if (spell_num == ELICITATION)
	{
		revealed = FALSE;
	}

	return (revealed);
}
/****************************************************************************
	user is casting elicitation
*/
short Elicit(char *target, short t_num)
{
	short   i;
	short   g;
	short   m;
	short   absolute_match = 0;

	if (target[0] == 0)
	{
		prfmsg(M585);
		BAD_EXIT;
	}

	i = find_item(target, t_num, FALSE, &absolute_match);

	if (i >= 0)
	{
		Look_At_Item(i);
		return (TRUE);
	}

	i = findguy_or_mon(target, t_num, !OFFENSIVE, &absolute_match);
	GUY_OR_MON;

	if (g >= 0 && absolute_match != ABS_MON)
	{
		Look_At_Guy(g, TRUE);
		return (TRUE);
	}
	else if (m >= 0)
	{
		Look_At_Monster(m, TRUE);
		return (TRUE);
	}

	BAD_EXIT;
}
/****************************************************************************
	user is casting curse
*/
short Curse(short g, short m, short dur)
{
	short   tal_index;
	short   addevil;
	short   i;
	MLONG   e;
	char    what[20];

	if (g >= 0)
	{
		for (i = 0, tal_index = -1; i != NUM_ITEMS; ++i)
		{
			if (AGUY->item[i].what == TALISMAN)
			{
				tal_index = i;
			}
		}

		if (tal_index != -1)
		{
			prfmsg
			(
				MSG1310, 
				AGUY->name, 
				AGUY->item[tal_index].article,
				AGUY->item[tal_index].name
			);
			sprintf(str, getmsg(MSG1091), AGUY->item[tal_index].name);
			Message(str, g);

			addevil = numopt(ADDEVIL, -32767, 32767);
			if (addevil)
			{
				prfmsg(M409, addevil);
				me.evil += addevil;
			}

			Next_User(g);
			Lose_Item(tal_index);
			Previous_User();
			DONE;
		}
	}

	i = RANDOM(5);

	if (i == 1)
	{
		strcpy(what, "less intelligent!");
			
		if (g >= 0)
		{
			if (AGUY->Int > dur)
			{
				AGUY->Int -= dur;

				e = Calc_Exp_Needed(AGUY->Int, FALSE);

				if (AGUY->int_exp > e)
				{
					AGUY->int_exp = e;
				}
			}
		}
		else
		{
			if (AMON->Int > dur)
			{
				AMON->Int -= dur;
			}
		}
	}
	else if (i == 2)
	{
		strcpy(what, "weaker!");
		if (g >= 0)
		{
			if (AGUY->Str > dur)
			{
				AGUY->Str -= dur;

				e = Calc_Exp_Needed(AGUY->Str, FALSE);

				if (AGUY->str_exp > e)
				{
					AGUY->str_exp = e;
				}

				Set_Guy_Points
				(
					&AGUY->dpts,
					&AGUY->mpts,
					AGUY->Str,
					AGUY->Con,
					AGUY->Psy,
					AGUY->class
				);
			}
		}
		else
		{
			if (AMON->Str > dur)
			{
				AMON->Str -= dur;
			}

			Set_Mon_Points
			(
				&AMON->dpts,
				&AMON->mpts,
				AMON->Str,
				AMON->Con,
				AMON->Psy
			);

			if (bp_mons)
			{
				AMON->dpts = (AMON->dpts * 2L) / 3L;
			}
		}
	}
	else if (i == 3)
	{
		strcpy(what, "less cosmic!");
		if (g >= 0)
		{
			if (AGUY->Psy > dur)
			{
				AGUY->Psy -= dur;

				e = Calc_Exp_Needed(AGUY->Psy, FALSE);

				if (AGUY->psy_exp > e)
				{
					AGUY->psy_exp = e;
				}

				Set_Guy_Points
				(
					&AGUY->dpts,
					&AGUY->mpts,
					AGUY->Str,
					AGUY->Con,
					AGUY->Psy,
					AGUY->class
				);
			}
		}
		else
		{
			if (AMON->Psy > dur)
			{
				AMON->Psy -= dur;
				Set_Mon_Points
				(
					&AMON->dpts,
					&AMON->mpts,
					AMON->Str,
					AMON->Con,
					AMON->Psy
				);

				if (bp_mons)
				{
					AMON->dpts = (AMON->dpts * 2L) / 3L;
				}
			}
		}
	}
	else if (i == 4)
	{
		strcpy(what, "clumsier!");
		if (g >= 0)
		{
			if (AGUY->Dex > dur)
			{
				AGUY->Dex -= dur;
				e = Calc_Exp_Needed(AGUY->Dex, FALSE);

				if (AGUY->dex_exp > e)
				{
					AGUY->dex_exp = e;
				}
			}
		}
		else
		{
			if (AMON->Dex > dur)
			{
				AMON->Dex -= dur;
			}
		}
	}
	else if (i == 5)
	{
		strcpy(what, "less sturdy!");
		if (g >= 0)
		{
			if (AGUY->Con > dur)
			{
				AGUY->Con -= dur;

				e = Calc_Exp_Needed(AGUY->Con, FALSE);

				if (AGUY->con_exp > e)
				{
					AGUY->con_exp = e;
				}

				Set_Guy_Points
				(
					&AGUY->dpts,
					&AGUY->mpts,
					AGUY->Str,
					AGUY->Con,
					AGUY->Psy,
					AGUY->class
				);
			}
		}
		else
		{
			if (AMON->Con > dur)
			{
				AMON->Con -= dur;

				Set_Mon_Points
				( 
					&AMON->dpts,
					&AMON->mpts,
					AMON->Str,
					AMON->Con,
					AMON->Psy
				);

				if (bp_mons)
				{
					AMON->dpts = (AMON->dpts * 2L) / 3L;
				}
			}
		}
	}

	if (g >= 0)
	{
		prfmsg(MSG435, AGUY->name, what);
		sprintf(str, getmsg(MSG436), what);
		Message(str, g);

		addevil = numopt(ADDEVIL, -32767, 32767);
		if (addevil)
		{
			prfmsg(M409, addevil);
			me.evil += addevil;
		}
	}
	else if (m >= 0)
	{
		prfmsg(MSG435, name, what);
		AMON->hurt_by[P] = TRUE;
		AMON->hurters[P] = TRUE;
		AMON->spelled_by[P] = TRUE;
		Award_Trancers(m);
		Vector_Check(m);
		Monster_Fled(m, FALSE);
	}

	DONE;
}
/****************************************************************************
	user is casting a fear spell
*/
void Fear_Spell(short g, short m)
{
	short   i;

	if (g >= 0)
	{
		outprf(MY_PORT->usrnum);
		clrprf();
		Next_User(g);
		Flee();
		Send_Buf(APORT(g)->usrnum);
		Previous_User();
	}
	else if (m >= 0)
	{
		sprintf(str, getmsg(MSG592), name);
		Message(str, LOUD_LOCAL);
		prf("%s\r", str);
 
		if (!invasion->active || AMON->which != invasion->crit)
		{
			for (i = 0; i != MAX_MON_ITEM; ++i)
			{
				if (AMON->item_used[i] && WEAPON(AMON->item_has[i]))
				{
					Put_In_Room(&AMON->item_has[i]);
				}
				else if 
				(
					AMON->item_used[i] && 
					AMON->item_has[i].what == SHIELD
				)
				{
					Put_In_Room(&AMON->item_has[i]);
				}
			}
		}

		Remove_Mon(m, FALSE);
	}
}
/****************************************************************************
	user is casting a sleep spell
*/
short Sleep(short s, char *target)
{
	short   fled;
	short   dur;
	short   temp_dur;
	short   m;
	short   out_reacted;
	short   t;
	short   revealed = FALSE;
	short   dodged;
	short   g;

	dur = spell_info[s].dur;
	sprintf(str, getmsg(MSG610), me.name);
	Message(str, QUIET_LOCAL);

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what && !AMON->hidden)
		{
			out_reacted = Perform_Attack(MON);

			if (out_reacted)
			{
				return (TRUE);
			}
		}
	}

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		t = find_timer(SLEEP_TIME, MON);

		if (AMON->what && !t && !AMON->hidden)
		{
			revealed = TRUE;
			fled = Monster_Fled(m, TRUE);

			if (!fled)
			{
				dodged = Dodged(MON, FALSE, s);
			}

			if (!fled && (!dodged || dodged == PARTIAL_DODGE))
			{
				if (!dodged)
				{
					dodged = 1;
				}

				Start_Mon_Name(name, m);

				if (!MY_PORT->focused)
				{
					Make_A_Timer(SLEEP_TIME, dur / dodged, MON, RESET);
				}
				else
				{
					temp_dur = (short) (((MLONG) dur * (MLONG) globals->focus1) / 10L);
					Make_A_Timer(SLEEP_TIME, temp_dur / dodged, MON, RESET);
				}

				AMON->hurt_by[P] = TRUE;
				AMON->hurters[P] = TRUE;
				AMON->spelled_by[P] = TRUE;
				Award_Trancers(m);
			}
			else if (!fled)
			{
				fled = Monster_Fled(m, FALSE);
			}

			if (fled)
			{
				--m;
			}
		}
	}

	if (me.perm[SUPER_PERM] && target[0])
	{
		for (g = 0; g != NTERMS; ++g)
		{
			if (ABUF(B)->guy[g] && g != P)
			{
				++revealed;
				Perform_Attack(GUY);

				prfmsg(MSG611, AGUY->name);
				strcpy(str, getmsg(MSG612));
				Message(str, g);
				Make_A_Timer(SLEEP_TIME, dur, GUY, RESET);
			}
		}
	}

	if (revealed == 0)
	{
		prfmsg(M613);
	}

	MY_PORT->enemy_mon = -1;
	return (revealed);
}
/****************************************************************************
	user is casting a shockwave spell
*/
void Shockwave(short dur, short itm)
{
	short   my_level;
	short   fled;
	short   m;
	short   out_reacted;
	short   dodged;
	short   s = SHOCKWAVE;
	short   mons = 0;
	MLONG   dmg;
	MLONG   dmg2;

	sprintf(str, getmsg(MSG1563), me.name);
	Message(str, LOUD_LOCAL);
	prfmsg(MSG1564);

	if (me.focus != -1)
	{
		if (!me.item[me.focus].infinite_uses)
		{
			--me.item[me.focus].uses;
		}

		if (me.item[me.focus].uses <= 0)
		{
			prfmsg(MSG1340, me.item[me.focus].name);
		}
		else
		{
			prfmsg(MSG1339, me.item[me.focus].name);
		}

		MY_PORT->focused = 2;
		dur = (short) (((MLONG) dur * (MLONG) globals->focus1) / 10L);
	}

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what && !AMON->hidden)
		{
			++mons;
			out_reacted = Perform_Attack(MON);

			if (out_reacted)
			{
				MY_PORT->enemy_mon = m;
				return;
			}
		}
	}

	if (mons == 0)
	{
		return;
	}

	if (itm >= 0)
	{
		my_level = me.item[itm].item_level;
	}
	else
	{
		my_level = Stat_Lev(Local_Psy(P));
	}

	dmg = (MLONG) my_level * (MLONG) dur;
	dmg += RANDOM(my_level);

	if (me.class == SORCERER)
	{
		dmg = (dmg * globals->sordmg) / 10;
	}
	else if (me.class == MYSTIC)
	{
		dmg = (dmg * globals->mysdmg) / 10;
	}

	dmg = dmg / (MLONG) mons;

	if (dmg < 1)
	{
		dmg = 1;
	}

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what && !AMON->hidden)
		{
			fled = Monster_Fled(m, TRUE);

			if (!fled)
			{
				dodged = Dodged(MON, FALSE, s);
			}

			if (!fled && (!dodged || dodged == PARTIAL_DODGE))
			{
				if (!dodged)
				{
					dodged = 1;
				}

				dmg2 = dmg / (MLONG) dodged;

				if (dmg2 < 1)
				{
					dmg2 = 1;
				}

				if (AMON->damage == 0 && dmg2 > AMON->dpts)
				{
					dmg2 = AMON->dpts;
				}

				Set_Mon_Name(name, m);
				AMON->hurt_by[P] = TRUE;
				AMON->hurters[P] = TRUE; 
				AMON->spelled_by[P] = TRUE;
				Award_Trancers(m);
				AMON->damage += dmg2;
			
				sprintf(str, getmsg(MSG1565), name, dmg2);
				prf(str);

				if (AMON->damage > AMON->dpts || me.perm[KILLER_PERM])
				{
					Killed_Mon(m);
					--m;
				}
				else
				{
					if (Vector_Check(m))
					{
						return;
					}
					
					fled = Monster_Fled(m, FALSE);
					
					if (!fled)
					{
						Monster_Wounds(m);
					}
				}
			}
			else if (!fled)
			{
				fled = Monster_Fled(m, FALSE);
			}

			if (fled)
			{
				--m;
			}
		}
	}

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what && !AMON->hidden)
		{
			MY_PORT->enemy_mon = m;
		}
	}
}
/****************************************************************************
	user is casting a spell
*/
short Make_Magic(short s, char *target, short t_num, short itm)
{       
	short   my_level;
	short   loc;
	short   t;
	short   i;
	short   g;
	short   m;
	short   pts;
	short   ok;
	short   to;
	short   dodged;
	short   dur;
	short   revealed = FALSE;
	short   absolute_match = 0;
	short   mon_ac;
	short   my_ac;
	short   out_reacted;
	short   did_it = FALSE;
	short   num_items;
	MLONG   carrying;
	MLONG   max;
	MLONG   dmg;
	MLONG   psy;
	MLONG   gold;
	
	MY_PORT->focused = FALSE;

	if (s == ELICITATION)
	{
		return (Elicit(target, t_num));
	}

	if (itm < 0 && !me.perm[MPTS_PERM] && s != REPAIR)
	{
		pts = spell_info[s].pts;

		if (me.class == CLERIC)
		{
			pts = pts / 2;
		}

		if (me.mpts - me.magic_used < pts)           
		{
			if (!sameas(target, "finish"))
			{
				prfmsg(M581);
			}

			BAD_EXIT;
		}
		
		if (Local_Psy(P) >= spell_info[s].power)    
		{
			ok = TRUE;
		}
		else if (me.class == SORCERER && (s == LIGHTNING || s == LANGOUR))
		{
			ok = TRUE;
		}
		else if (me.class == CLERIC && (s == HEAL || s == VIGOR))
		{
			ok = TRUE;
		}
		else if (me.class == MYSTIC && (s == BRING || s == SEEK || s == SAFE_RETURN))
		{
			ok = TRUE;
		}
		else
		{
			ok = FALSE;
		}

		if (!ok && me.focus != -1)
		{
			psy = ((MLONG) Local_Psy(P) * globals->focus3) / 10L;

			if 
			(
				psy >= spell_info[s].power ||
				me.class == SORCERER ||
				me.class == MYSTIC ||
				me.class == CLERIC
			)
			{
				ok = TRUE;
				MY_PORT->focused = TRUE;
			}
		}

		if (!ok)
		{
			prfmsg(M580, spell_info[s].power, spell_info[s].name);

			if (MY_PORT->last_attack == CAST && MY_PORT->last_spell == s)
			{
				MY_PORT->last_attack = HIT;
			}

			BAD_EXIT;
		}
	}

	if (!me.perm[SUPER_PERM])
	{
		if (itm < 0)
		{
			if 
			(
				ABUF(B)->rm.rmtype == NO_CAST || 
				ABUF(B)->rm.rmtype == NO_MAGIC ||
				MY_PORT->limbo_return
			)
			{
				prfmsg(M583);
				BAD_EXIT;
			}
		}
		else
		{
			if (ABUF(B)->rm.rmtype == NO_MAGIC || MY_PORT->limbo_return)
			{
				prfmsg(M584, me.item[itm].name);
				BAD_EXIT;
			}
		}
	}
	
	if (!action_ok())
	{
		BAD_EXIT;
	}

	if (s != REPAIR)
	{
		dur = spell_info[s].dur; 
	}

	if
	(
		s == HEAL ||
		s == INVISIBILITY ||
		s == PURIFY ||
		s == VIGOR ||
		s == INVULNERABILITY ||
		s == MAGIC_SHIELD ||
		s == SEE_INVISIBLE ||
		s == STEALTH ||
		s == HASTE ||
		s == PROTECT ||
		s == STRENGTH ||
		s == RESTORE ||
		s == STURDINESS ||
		s == MANIA ||
		s == LEVITATE
	)
	{
		if (me.class == CLERIC)
		{
			if (s != MANIA)
			{
				dur = (short) (((MLONG) dur * (MLONG) globals->clebonus) / 10L);
			}
		}
		else if (me.class == MYSTIC)
		{
			dur = (short) (((MLONG) dur * (MLONG) globals->mysbonus) / 10L);
		}
		else if (me.class == SORCERER)
		{
			if (s == MANIA)
			{
				dur = (short) (((MLONG) dur * (MLONG) globals->sorbonus) / 10L);
			}
		}

		if 
		(
			me.class == CLERIC || 
			me.class == SORCERER || 
			me.class == MYSTIC ||
			itm >= 0
		)
		{
			if 
			(
				s == INVISIBILITY || 
				s == PROTECT || 
				s == STURDINESS ||
				s == STRENGTH || 
				s == INVULNERABILITY ||
				s == MAGIC_SHIELD ||
				s == SEE_INVISIBLE ||
				s == STEALTH ||
				s == LEVITATE ||
				s == HASTE
			)
			{
				if (itm >= 0)
				{
					dur += me.item[itm].item_level;
				}
				else
				{
					dur += me.Psy;
				}
			}
			else if (s == MANIA)
			{
				if (itm >= 0)
				{
					dur += me.item[itm].item_level;
				}
				else
				{
					dur += Stat_Lev(me.Psy);
				}
			}
		}

		if 
		(
			me.focus != -1 &&
			(
				itm < 0 || 
				me.class == SORCERER || 
				me.class == MYSTIC ||
				me.class == CLERIC
			)
		)
		{
			dur = (short) (((MLONG) dur * (MLONG) globals->focus1) / 10L);
			MY_PORT->focused = TRUE;
		}

		if (target[0] == 0 || s == MANIA || s == LEVITATE)
		{
			g = P;
		}
		else
		{
			i = findguy_or_mon(target, 0, !OFFENSIVE, &absolute_match);
			GUY_OR_MON;
		}

		if (g >= 0 && absolute_match != ABS_MON)
		{
			inform_room(s, GUY);
			revealed = TRUE;

			if 
			(
				MY_PORT->focused && 
				s != HEAL &&
				s != VIGOR &&
				s != RESTORE
			)
			{
				if (!me.item[me.focus].infinite_uses)
				{
					--me.item[me.focus].uses;
				}

				if (me.item[me.focus].uses <= 0)
				{
					prfmsg(MSG1340, me.item[me.focus].name);
				}
				else
				{
					prfmsg(MSG1339, me.item[me.focus].name);
				}
			}
		}
		else
		{
			return (FALSE);
		}
	}
	else if
	(
		s == LANGOUR ||
		s == WEAKNESS ||
		s == MESMERIZE ||
		s == LIGHTNING ||
		s == BLAST ||
		s == SHOCKWAVE ||
		s == EXHAUSTION ||
		s == FIREBALL ||
		s == FEAR ||
		s == CURSE ||
		s == DISPEL_MAGIC ||
		s == AGGRAVATE
	)
	{
		if (s == CURSE)
		{
			dur = 1;
		}

		if (me.class == SORCERER)
		{
			dur = (short) (((MLONG) dur * (MLONG) globals->sorbonus) / 10L);
		}
		else if (me.class == MYSTIC)
		{
			dur = (short) (((MLONG) dur * (MLONG) globals->mysbonus) / 10L);
		}

		if 
		(
			me.class == CLERIC || 
			me.class == SORCERER || 
			me.class == MYSTIC ||
			itm >= 0
		)
		{
			if (s == AGGRAVATE || s == LANGOUR || s == WEAKNESS)
			{
				if (itm >= 0)
				{
					dur += me.item[itm].item_level;
				}
				else
				{
					dur += me.Psy;
				}
			}
			else if (s == MESMERIZE)
			{
				if (itm >= 0)
				{
					dur += me.item[itm].item_level;
				}
				else
				{
					dur += Stat_Lev(me.Psy);
				}
			}
		}

		if (s != SHOCKWAVE)
		{
			if (sameas(target, "finish"))
			{
				g = -1;
				m = t_num;
			}
			else
			{
				i = findguy_or_mon(target, t_num, OFFENSIVE, &absolute_match);
				GUY_OR_MON;
			}
		}

		if (s == SHOCKWAVE)
		{
			MY_PORT->last_spell = s;

			if (itm < 0)
			{
				MY_PORT->last_attack = CAST;
			}
			else
			{
				MY_PORT->last_attack = USE;
			}

			Shockwave(dur, itm);
			return (TRUE);
		}
		else if (g >= 0 && absolute_match != ABS_MON)
		{
			if (!Can_Attack_Guy(g))
			{
				return (FALSE);
			}
			
			m = -1;
			revealed = TRUE;
			Perform_Attack(GUY);
			inform_room(s, GUY);
			dodged = Dodged(GUY, FALSE, s);

			if (dodged && dodged != PARTIAL_DODGE)
			{
				return (TRUE);
			}
				
			if (!dodged)
			{
				dodged = 1;
			}
		}
		else if (m >= 0)
		{
			MY_PORT->last_spell = s;

			if (itm < 0)
			{
				MY_PORT->last_attack = CAST;
			}
			else
			{
				MY_PORT->last_attack = USE;
			}

			MY_PORT->enemy_mon = m;
			g = -1;
			revealed = TRUE;

			out_reacted = Perform_Attack(MON);
			inform_room(s, MON);

			if (out_reacted)
			{
				return (TRUE);
			}

			if (Monster_Fled(m, TRUE))
			{
				return (TRUE);
			}
			
			dodged = Dodged(MON, FALSE, s);

			if (dodged && dodged != PARTIAL_DODGE)
			{
				Vector_Check(m);
				return (TRUE);
			}
			
			if (!dodged)
			{
				dodged = 1;
			}

			Start_Mon_Name(name, m);
			mon_ac = Calc_Mon_AC(m, EQUIP_ONLY);
			my_ac = Calc_Player_AC(&me, P, EQUIP_ONLY);
			
			if (mon_ac < my_ac)
			{
				AMON->my_ac_was_lower[P] = TRUE;
			}
		}
		else
		{
			return (FALSE);
		}

		if (MY_PORT->focused)
		{
			dur = (short) (((MLONG) dur * (MLONG) globals->focus1) / 10L);
		}
	}
	else if (MY_PORT->focused && s != SLEEP)
	{
		if (!me.item[me.focus].infinite_uses)
		{
			--me.item[me.focus].uses;
		}

		if (me.item[me.focus].uses <= 0)
		{
			prfmsg(MSG1340, me.item[me.focus].name);
		}
		else
		{
			prfmsg(MSG1339, me.item[me.focus].name);
		}
	}

	if (s == HEAL || s == RESTORE || s == VIGOR)
	{
		if (itm >= 0)
		{
			revealed = Healing(g, s, me.item[itm].item_level, dur);
		}
		else
		{
			revealed = Healing(g, s, Stat_Lev(Local_Psy(P)), dur);
		}
	}
	else if (s == AGGRAVATE)
	{
		if (g >= 0)
		{
			prfmsg(MSG589, AGUY->name);
			strcpy(str, getmsg(MSG590));
			Message(str, g);
			Make_A_Timer(MAGNET_TIME, dur / dodged, GUY, RESET);
		}             
	}
	else if (s == CURSE)
	{
		if (TYPE == ARENA)
		{
			prfmsg(MSG1299);
			BAD_EXIT;
		}

		Curse(g, m, dur);
		return (TRUE);
	}
	else if (s == LANGOUR)
	{
		if (g >= 0)
		{
			prfmsg(MSG424, AGUY->name);
			strcpy(str, getmsg(MSG591));
			Message(str, g);
			Make_A_Timer(SLOW_TIME, dur / dodged, GUY, RESET);
		}
		else if (m >= 0)
		{
			prfmsg(MSG424, name);
			AMON->hurt_by[P] = TRUE;
			AMON->hurters[P] = TRUE;
			AMON->spelled_by[P] = TRUE;
			Award_Trancers(m);
			Make_A_Timer(SLOW_TIME, dur / dodged, MON, RESET);
			Vector_Check(m);
			Monster_Fled(m, FALSE);
		}
	}
	else if (s == FEAR)
	{
		Fear_Spell(g, m);
	}
	else if (s == INVISIBILITY)
	{
		Go_Invisible(g, FALSE, dur);
	}
	else if (s == PURIFY)
	{
		for (t = 0; t != NUM_GUY_TIMERS; ++t)
		{
			if (AGUY->poison_timer)
			{
				AGUY->poison_timer = 0;
				did_it = TRUE;
			}
		}

		if (!did_it)
		{
			prfmsg(MSG593);
			BAD_EXIT;
		}

		if (g == P)
		{
			prfmsg(MSG594);
		}
		else
		{
			prfmsg(MSG595, AGUY->name);
			strcpy(str, getmsg(MSG594));
			Message(str, g);
		}
	}
	else if (s == SPY)
	{
		revealed = Spying(target);
	}
	else if (s == REVEAL)
	{
		++revealed;
		revelation();
	}
	else if (s == VISION)
	{
		revealed = visioning(target);
	}
	else if (s == ENCHANT || s == ENHANCE)
	{
		if (target[0] == 0)
		{
			prfmsg(M601);
			BAD_EXIT;
		}

		i = find_item(target, t_num, 1, &absolute_match);

		if (i >= 0)
		{
			if (!(ARSH(me.item[i])) && !(WEAPON(me.item[i])))
			{
				prfmsg(M602);
				Display_Item(&me.item[i]);
				prf("!\r");
			}
			else if (me.item[i].bonus)
			{
				prfmsg(M603);
			}
			else if (me.item[i].merc_item)
			{
				prfmsg(M558);
			}
			else
			{
				++revealed;

				if (WEAPON(me.item[i]))
				{
					me.item[i].bonus = RANDOM(spell_info[s].dur);
				}
				else
				{
					if 
					(
						me.item[i].what == ARMOR &&
						me.item[i].which != LITE_ARMOR
					)
					{
						me.item[i].bonus = RANDOM(spell_info[s].dur);
					}
					else
					{
						me.item[i].bonus = RANDOM(spell_info[s].dur / 2);
					}
				}

				prfmsg(MSG604);
				Display_Item(&me.item[i]);
				prf("!\r");
			}
		}
	}
	else if (s == ALCHEMY)
	{
		if (target[0] == 0)
		{
			prfmsg(MSG1560);
			BAD_EXIT;
		}

		i = find_item(target, t_num, 1, &absolute_match);

		if (i >= 0)
		{
			++revealed;
			gold = Calc_Val(&me.item[i]);

			if (me.item[i].what == CONTAINER)
			{
				gold += Bag_Value(&me.item[i]);
			}

			gold = gold / 2;

			if (gold <= 0)
			{
				gold = 1;
			}

			Calc_Weight(&num_items, &carrying, &max);

			if 
			(
				carrying + gold - Weight(&me.item[i]) > max && 
				!me.perm[SUPER_PERM]
			)
			{
				prfmsg(MSG1584);
				BAD_EXIT;
			}

			if ((double) me.gold + (double) gold < GCMAXLONG)
			{   
				me.gold += gold;
				sprintf(str, getmsg(MSG1562), me.item[i].name, gold);
				prf(str);
				Lose_Item(i);
			}
		}
	}
	else if (s == REPAIR)
	{
		if (target[0] == 0)
		{
			prfmsg(M605);
			BAD_EXIT;
		}

		i = find_item(target, t_num, 1, &absolute_match);

		if (i >= 0)
		{
			if (!(ARSH(me.item[i])) && !(WEAPON(me.item[i])))
			{
				prfmsg(M606);
				Display_Item(&me.item[i]);
				prf("!\r");
			}
			else if (me.item[i].no_repair)
			{
				prfmsg(MSG1490, "repaired");
			}
			else
			{
				++revealed;
				me.item[i].uses += me.item[itm].item_level;
				if (me.item[i].uses < 0)
				{
					me.item[i].uses = 32767;
				}
				prfmsg(MSG607, me.item[i].name, me.item[i].uses);
			}
		}
	}
	else if (s == WEAKNESS)
	{
		if (g >= 0)
		{
			prfmsg(MSG430, AGUY->name);
			strcpy(str, getmsg(MSG608));
			Message(str, g);
			Make_A_Timer(WEAK_TIME, dur / dodged, GUY, RESET);
		}
		else if (m >= 0)
		{
			prfmsg(MSG430, name);
			AMON->hurt_by[P] = TRUE;
			AMON->hurters[P] = TRUE; 
			AMON->spelled_by[P] = TRUE;
			Award_Trancers(m);
			Make_A_Timer(WEAK_TIME, dur / dodged, MON, RESET);
			Vector_Check(m);
		}
	}
	else if (s == MESMERIZE)
	{
		if (g >= 0)
		{
			prfmsg(MSG426, AGUY->name);
			strcpy(str, getmsg(MSG609));
			Message(str, g);

			if (APORT(g)->action_timer < dur / dodged)
			{
				APORT(g)->action_timer = dur / dodged;
			}
			
			Make_A_Timer(MES_TIME, APORT(g)->action_timer, GUY, RESET);
		}
		else if (m >= 0)
		{
			prfmsg(MSG426, name);
			AMON->hurt_by[P] = TRUE;
			AMON->hurters[P] = TRUE; 
			AMON->spelled_by[P] = TRUE;
			Award_Trancers(m);

			if (AMON->action_timer < dur / dodged)
			{
				AMON->action_timer = dur / dodged;
				Make_A_Timer(MES_TIME, dur / dodged, MON, RESET);
			}
			Monster_Fled(m, FALSE);
		}
	}
	else if (s == SLEEP)
	{
		revealed = Sleep(s, target);
	}
	else if (s == PASS_DOOR)
	{
		if (ABUF(B)->rm.id == globals->prison)
		{
			prfmsg(M614);
			BAD_EXIT;
		}

		if (target[0] == 0)
		{
			prfmsg(M615);
		}
		else if (ABUF(B)->rm.spec_exit.type == 0)
		{
			prfmsg(M542, target);
		}
		else if (!sameto(target, ABUF(B)->rm.spec_exit.descriptor))
		{
			prfmsg(M542, target);
		}
		else if (ABUF(B)->rm.spec_exit.type == NOT_SPECIAL)
		{
			prfmsg(M616);
		}
		else if (ABUF(B)->rm.spec_exit.type == SPECIAL_DOOR)
		{
			prfmsg(M617);
		}
		else if (ABUF(B)->rm.spec_exit.type == CHANT_DOOR)
		{
			prfmsg(M617);
		}
		else
		{
			if (Filter_Check())
			{
				Went_Spec();
			}
		}
	}
	else if (s == KEY || s == MAGIC_KEY)
	{
		if (target[0] == 0)
		{
			prfmsg(M618);
		}
		else if (ABUF(B)->rm.spec_exit.type == 0)
		{
			prfmsg(M542, target);
		}
		else if (!sameto(target, ABUF(B)->rm.spec_exit.descriptor))
		{
			prfmsg(M542, target);
		}
		else if (ABUF(B)->rm.spec_exit.type == NOT_SPECIAL)
		{
			prfmsg(M619, me.name);
		}
		else if (ABUF(B)->rm.spec_exit.type == MAGIC_DOOR && s == KEY)
		{
			prfmsg(M620);
		}
		else if 
		(
			ABUF(B)->rm.spec_exit.type == SPECIAL_DOOR && 
			(itm < 0 || me.item[itm].which != SPECIAL_KEY)
		)
		{
			prfmsg(M621);
		}
		else if 
		(
			ABUF(B)->rm.spec_exit.type == CHANT_DOOR ||
			(ABUF(B)->rm.spec_exit.type == SPECIAL_DOOR && 
			me.item[itm].holding != ABUF(B)->rm.door_index)
		)
		{
			prfmsg(M621);
		}
		else
		{
			if (!ABUF(B)->rm.spec_exit.locked)
			{
				strcpy(name, "locked");
				ABUF(B)->rm.spec_exit.locked = TRUE;
				sprintf(str, getmsg(MSG559), me.name);
			}
			else
			{
				strcpy(name, "unlocked");
				ABUF(B)->rm.spec_exit.locked = FALSE;
				sprintf(str, getmsg(MSG560), me.name);
			}
			cat_spec_ex(str);
			Message(str, QUIET_LOCAL);
			prfmsg(MSG623, name);
			++revealed;
		}
	}
	else if (s == SEEK)
	{
		if (!me.perm[GAMEOP_PERM])
		{
			if (ABUF(B)->rm.id == globals->prison)
			{
				prfmsg(M614);
				BAD_EXIT;
			}
		
			if (ABUF(B)->rm.no_teleport == TRUE)
			{
				prfmsg(M614);
				BAD_EXIT;
			}
		}
		
		if (MY_PORT->limbo_return)
		{
			prfmsg(M614);
			BAD_EXIT;
		}

		g = find_remote_guy(target);

		if (g > 0)
		{
			if (ABUF(B)->guy[g])
			{
				prfmsg(M691A);
				return (revealed);
			}

			++revealed;
			sprintf(str, getmsg(MSG624), me.name);
			Message(str, QUIET_LOCAL);
			prfmsg(MSG625);

			if (Seek_OK(g))
			{
				teleport_to(AGUY->location);
				return(revealed);
			}
		}
	}
	else if (s == BRING)
	{
		if (ABUF(B)->rm.id == globals->prison)
		{
			prfmsg(M614);
			BAD_EXIT;
		}

		if (MY_PORT->limbo_return)
		{
			prfmsg(M614);
			BAD_EXIT;
		}

		g = find_remote_guy(target);

		if (g > 0)
		{
			if (ABUF(B)->guy[g])
			{
				prfmsg(M691A);
				return (revealed);
			}

			if (itm >= 0)
			{
				my_level = me.item[itm].item_level;
			}
			else
			{
				my_level = Stat_Lev(Local_Psy(P));
			}

			prfmsg(MSG626);
			sprintf(str, getmsg(MSG627), me.name);
			Message(str, QUIET_LOCAL);
			sprintf(str, getmsg(MSG628), me.name);
			Message(str, g);

			revealed = TRUE;

			if (!Bring_OK(g, my_level))
			{
				Set_Action_Time(6);
				return (revealed);
			}

			if 
			(
				real_which2 > 0 && 
				real_which2 < MAX_ROOM && 
				me.perm[GAMEOP_PERM]
			)
			{
				loc = real_which2;
			}
			else
			{
				loc = me.location;
			}

			outprf(MY_PORT->usrnum);
			clrprf();
			APORT(g)->limbo_return = 0;
			Force_Guy_Move(g, loc);
			Send_Buf(APORT(g)->usrnum);
			return(revealed);
		}
	}
	else if (s == TELEPORT)
	{
		if (ABUF(B)->rm.id == globals->prison && !me.perm[GAMEOP_PERM])
		{
			prfmsg(M614);
			BAD_EXIT;
		}

		if (TYPE == ARENA && !me.perm[GAMEOP_PERM])
		{
			prfmsg(MSG1299);
			BAD_EXIT;
		}

		if (ABUF(B)->rm.no_teleport == TRUE && !me.perm[GAMEOP_PERM])
		{
			prfmsg(M614);
			BAD_EXIT;
		}
		
		if (MY_PORT->limbo_return)
		{
			prfmsg(M614);
			BAD_EXIT;
		}

		to = Find_Teleport_Room();
		
		if (target[0] == 0)
		{
			g = P;
			if 
			(
				real_which1 < MAX_ROOM && 
				real_which1 > 0 &&
				me.perm[GAMEOP_PERM]
			)
			{
				g = P;
				to = real_which1;
			}
		}
		else
		{
			i = findguy_or_mon(target, 0, !OFFENSIVE, &absolute_match);
			if (i > 0)
			{
				 g = i - 1;
			}
			else
			{
				g = -1;
			}            
				
			if 
			( 
				real_which2 < MAX_ROOM && 
				real_which2 > 0 &&
				me.perm[GAMEOP_PERM]
			)
			{
				to = real_which2;
			}
		}

		if (g >= 0 && absolute_match != ABS_MON)
		{
			inform_room(s, GUY);
		}
		else
		{
			return (revealed);
		}
		++revealed;

		if (g == P)
		{
			teleport_to(to);
		}
		else if (g >= 0)
		{
			if (!Can_Attack_Guy(g))
			{
				BAD_EXIT;
			}

			dodged = Dodged(GUY, FALSE, s);
			MY_PORT->assassin_timer = ASSASSIN_TIME;

			if (dodged && dodged != PARTIAL_DODGE)
			{
				return(revealed);
			}

			sprintf(str, getmsg(MSG629), AGUY->name);

			for (i = 0; i != NTERMS; ++i)
			{
				APORT(i)->follower[g] = 0;
				APORT(g)->follower[i] = 0;
			}
			Message(str, -(g + 1));
			outprf(MY_PORT->usrnum);
			clrprf();
			Force_Guy_Move(g, to);
			Send_Buf(APORT(g)->usrnum);
			return (revealed);
		}
	}
	else if (s == LIGHTNING || s == BLAST || s == FIREBALL)
	{
		if (itm >= 0)
		{
			my_level = me.item[itm].item_level;
		}
		else
		{
			my_level = Stat_Lev(Local_Psy(P));
		}

		dmg = (MLONG) my_level * (MLONG) dur;
		dmg += RANDOM(my_level);

		if (me.class == SORCERER)
		{
			dmg = (dmg * globals->sordmg) / 10;
		}
		else if (me.class == MYSTIC)
		{
			dmg = (dmg * globals->mysdmg) / 10;
		}

		dmg = dmg / (MLONG) dodged;

		if (dmg < 1)
		{
			dmg = 1;
		}

		if (g >= 0)
		{
			if (AGUY->damaged == 0 && dmg > AGUY->dpts)
			{
				dmg = AGUY->dpts;
			}
			else if (dmg > AGUY->dpts - AGUY->damaged)
			{
				dmg = (AGUY->dpts - AGUY->damaged) + 1;
			}

			sprintf(str, getmsg(MSSG428), me.name, dmg);
			Message(str, g);
			
			AGUY->damaged += (short) dmg;
			sprintf(str, getmsg(MSSG429), AGUY->name, dmg);
			prf(str);

			if (AGUY->damaged > AGUY->dpts || me.perm[KILLER_PERM])
			{
				Killed_Guy(g);
				MY_PORT->assassin_timer = ASSASSIN_TIME;
			}
		}
		else if (m >= 0)
		{
			if (AMON->damage == 0 && dmg > AMON->dpts)
			{
				dmg = AMON->dpts;
			}

			Set_Mon_Name(name, m);
			AMON->hurt_by[P] = TRUE;
			AMON->hurters[P] = TRUE; 
			AMON->spelled_by[P] = TRUE;
			Award_Trancers(m);
			AMON->damage += dmg;
			
			sprintf(str, getmsg(MSSG429), name, dmg);
			prf(str);

			if (AMON->damage > AMON->dpts || me.perm[KILLER_PERM])
			{
				Killed_Mon(m);
			}
			else
			{
				Monster_Wounds(m);
				Vector_Check(m);
				Monster_Fled(m, FALSE);
			}
		}
	}
	else if (s == EXHAUSTION)
	{
		if (itm >= 0)
		{
			my_level = me.item[itm].item_level;
		}
		else
		{
			my_level = Stat_Lev(Local_Psy(P));
		}

		dmg = (MLONG) my_level * (MLONG) dur;
		dmg += RANDOM(my_level);

		if (me.class == SORCERER)
		{
			dmg = (dmg * globals->sordmg) / 10;
		}
		else if (me.class == MYSTIC)
		{
			dmg = (dmg * globals->sordmg) / 10;
		}

		dmg = dmg / (MLONG) dodged;

		if (dmg < 1)
		{
			dmg = 1;
		}

		if (g >= 0)
		{
			if (AGUY->ftg == 0 && dmg > AGUY->dpts)
			{
				dmg = AGUY->dpts;
			}
			else if (dmg > AGUY->dpts - AGUY->ftg)
			{
				dmg = (AGUY->dpts - AGUY->ftg) + 5;
			}

			sprintf(str, getmsg(MSSG1332), me.name, dmg);
			Message(str, g);
			
			AGUY->ftg += (short) dmg;
			sprintf(str, getmsg(MSSG1333), dmg, AGUY->name);
			prf(str);
		}
		else if (m >= 0)
		{
			Set_Mon_Name(name, m);
			AMON->hurt_by[P] = TRUE;
			AMON->hurters[P] = TRUE; 
			AMON->spelled_by[P] = TRUE;
			Award_Trancers(m);
			AMON->Tired += dmg;
			sprintf(str, getmsg(MSSG1333), dmg, name);
			prf(str);
			Vector_Check(m);
			Monster_Fled(m, FALSE);
		}
	}
	else if (s == PROTECT)
	{
		Make_A_Timer(PROTECTED_TIME, dur, GUY, RESET);
		
		if (g == P)
		{
			prfmsg(MSG631);
		}
		else
		{
			strcpy(str, getmsg(MSG632));
			Message(str, g);
			prfmsg(MSG633, AGUY->name);
		}
	}
	else if (s == STURDINESS)
	{
		Make_A_Timer(STURDY_TIME, dur, GUY, RESET);
		
		if (g == P)
		{
			prfmsg(MSG634);
		}
		else
		{
			strcpy(str, getmsg(MSG635));
			Message(str, g);
			prfmsg(MSG636, AGUY->name);
		}
	}
	else if (s == STRENGTH)
	{
		Make_A_Timer(STRONG_TIME, dur, GUY, RESET);
		
		if (g == P)
		{
			prfmsg(MSG637);
		}
		else
		{
			strcpy(str, getmsg(MSG638));
			Message(str, g);
			prfmsg(MSG639, AGUY->name);
		}
	}
	else if (s == INVULNERABILITY)
	{
		Make_A_Timer(INVULNERABLE_TIME, dur, GUY, RESET);
		
		if (g == P)
		{
			prfmsg(MSG640);
		}
		else
		{
			strcpy(str, getmsg(MSG641));
			Message(str, g);
			prfmsg(MSG642, AGUY->name);
		}
	}
	else if (s == MAGIC_SHIELD)
	{
		Make_A_Timer(SHIELD_TIME, dur, GUY, RESET);
		
		if (g == P)
		{
			prfmsg(MSG643);
		}
		else
		{
			strcpy(str, getmsg(MSG644));
			Message(str, g);
			prfmsg(MSG645, AGUY->name);
		}
	}
	else if (s == DISPEL_MAGIC)
	{
		Dispel_Magic(g, m, absolute_match, dodged);

		if (m >= 0)
		{
			AMON->hurt_by[P] = TRUE;
			AMON->hurters[P] = TRUE; 
			AMON->spelled_by[P] = TRUE;
			Award_Trancers(m);
			Vector_Check(m);
		}
	}
	else if (s == MAGIC_CIRCLE)
	{
		++revealed;
		g = P;

		prfmsg(MSG646);
		sprintf(str, getmsg(MSG647), me.name);
		Message(str, QUIET_LOCAL);

		if (RANDOM(3) == 1)
		{
			prfmsg(MSG648);
			sprintf(str, getmsg(M649), me.name);
			Message(str, QUIET_LOCAL);
			
			dur = spell_info[s].dur;

			if 
			(
				me.class == CLERIC || 
				me.class == MYSTIC || 
				me.class == SORCERER
			)
			{
				dur = dur / 2;
			}
			
			Make_A_Timer(KO_TIME, dur, GUY, RESET);

			for (t = 0; t != NUM_GUY_TIMERS; ++t)
			{
				if (APORT(g)->misc_type[t] == CIRCLE_TIME)
				{
					MY_PORT->timer[t] = 0;
				}
			}
		}
		else
		{
			if 
			(
				me.class == CLERIC || 
				me.class == MYSTIC || 
				me.class == SORCERER ||
				itm >= 0
			)
			{
				if (itm >= 0)
				{
					dur += me.item[itm].item_level;
				}
				else
				{
					dur += me.Psy;
				}
			}

			prfmsg(MSG650);
			sprintf(str, getmsg(MSG651), me.name);
			Message(str, QUIET_LOCAL);
			Make_A_Timer(CIRCLE_TIME, dur, GUY, RESET);
		}
	}
	else if (s == SAFE_RETURN)
	{
		if (ABUF(B)->rm.id == globals->prison && !me.perm[GAMEOP_PERM])
		{
			prfmsg(M614);
			BAD_EXIT;
		}

		if (MY_PORT->limbo_return)
		{
			prfmsg(M614);
			BAD_EXIT;
		}
		
		if (ABUF(B)->rm.no_teleport == TRUE && !me.perm[GAMEOP_PERM])
		{
			prfmsg(M614);
			BAD_EXIT;
		}

		++revealed;

		if (itm < 0)
		{
			if 
			(
				me.return_to == 0 ||
				me.return_to == me.location
			)
			{
				if (ABUF(B)->rm.no_teleport == TRUE && !me.perm[GAMEOP_PERM])
				{
					prfmsg(M558);
				}
				else
				{
					prfmsg(MSG652);
					me.return_to = me.location;
				}

				revealed = FALSE;
			}
			else
			{
				to = me.return_to;
				me.return_to = 0;
			}
		}
		else
		{
			if (me.item[itm].room == 0)
			{
				if (ABUF(B)->rm.no_teleport == TRUE && !me.perm[GAMEOP_PERM])
				{
					prfmsg(M558);
				}
				else
				{
					prfmsg(MSG653);
					me.item[itm].room = me.location;
				}
				
				revealed = FALSE;
			}
			else if (me.item[itm].room == me.location)
			{
				prfmsg(M654);
				me.item[itm].room = 0;
				revealed = FALSE;
			}
			else
			{
				to = me.item[itm].room;
				me.item[itm].room = 0;
			}
		}

		if (revealed)
		{
			if (to == globals->sanctum)
			{
				prfmsg(M655);
				teleport_to(Find_Teleport_Room());
				Set_Action_Time(30);
			}
			else if (to < MAX_ROOM)
			{
				teleport_to(to);
			}
		}
	}
	else if (s == SEE_INVISIBLE)
	{
		Make_A_Timer(SEE_INVIS_TIME, dur, GUY, RESET);
		
		if (g == P)
		{
			prfmsg(MSG656);
		}
		else
		{
			strcpy(str, getmsg(MSG657));
			Message(str, g);
			prfmsg(MSG658, AGUY->name);
		}
	}
	else if (s == SUMMON)
	{
		if ((SAFE_AREA || TYPE == ARENA) && !me.perm[GAMEOP_PERM])
		{
			prfmsg(M614);
			BAD_EXIT;
		}

		++revealed;
		sprintf(str, getmsg(M659), me.name);
		Message(str, QUIET_LOCAL);

		if (ABUF(B)->mon[MAX_ROOM_MON - 1].what)
		{
			prfmsg(M660B);
			prfmsg(M660A);
			BAD_EXIT;
		}

		prfmsg(M661);

		if (real_which1 && me.perm[GAMEOP_PERM])
		{
			i = real_which1;

			if (i > 0 && i < MAX_MONSTER) 
			{
				Summon(i, SUMMON_RANDOM, 0L);
			}
			else
			{
				prfmsg(M662, i);
			}
		}
		else
		{
			if (itm >= 0)
			{
				i = find_a_mon(me.item[itm].item_level);
			}
			else
			{
				i = find_a_mon(Stat_Lev(Local_Psy(P)));
			}

			Summon(i, SUMMON_RANDOM, 0L);
		}
	}
	else if (s == STEALTH)
	{
		Make_A_Timer(STEALTH_TIME, dur, GUY, RESET);
		
		if (g == P)
		{
			prfmsg(MSG663);
		}
		else
		{
			strcpy(str, getmsg(MSG664));
			Message(str, g);
			prfmsg(MSG665, AGUY->name);
		}
	}
	else if (s == MANIA)
	{
		if (g == P)
		{
			Make_A_Timer(MANIA_TIME, dur, GUY, RESET);
			prfmsg(MSG666);
		}
		else
		{
			prfmsg(MSG1344);
		}
	}
	else if (s == LEVITATE)
	{
		if (g == P)
		{
			prfmsg(MSG669);
			Make_A_Timer(FLOAT_TIME, dur, GUY, RESET);
		}
		else
		{
			prfmsg(MSG1344);
		}
	}
	else if (s == HASTE)
	{
		Make_A_Timer(FAST_TIME, dur, GUY, RESET);
		
		if (g == P)
		{
			prfmsg(MSG672);
		}
		else
		{
			strcpy(str, getmsg(MSG673));
			Message(str, g);
			prfmsg(MSG674, AGUY->name);
		}
	}

	return (revealed);
}
/****************************************************************************
	dispel magic spell
*/
short Dispel_Magic(short g, short m, short absolute_match, short dodged)
{
	short   t;
	short   shield_t = -1;

	if (g >= 0 && absolute_match != ABS_MON)
	{
		for (t = 0; t != NUM_GUY_TIMERS; ++t)
		{
			if (APORT(g)->misc_type[t] == SHIELD_TIME)
			{
				shield_t = t;
			}
		}

		if (shield_t >= 0)
		{
			if (dodged == PARTIAL_DODGE)
			{
				prfmsg(MSG432, AGUY->name);

				if (APORT(g)->timer[shield_t] > 1)
				{
					APORT(g)->timer[shield_t] = APORT(g)->timer[shield_t] / 2;
				}
			}
			else
			{
				prfmsg(MSG433, AGUY->name);
				APORT(g)->timer[shield_t] = 1;
			}

			DONE;
		}
		
		prfmsg(MSG434, AGUY->name);

		if (dodged == PARTIAL_DODGE)
		{
			if (AGUY->magic_used < AGUY->mpts / 2)
			{
				AGUY->magic_used = AGUY->mpts / 2;
			}

			for (t = 0; t != NUM_GUY_TIMERS; ++t)
			{
				if 
				(
					APORT(g)->timer[t] > 1 && 
					APORT(g)->misc_type[t] != KO_TIME
				)
				{
					APORT(g)->timer[t] = APORT(g)->timer[t] / 2;

					if (APORT(g)->misc_type[t] == MES_TIME)
					{
						APORT(g)->action_timer = APORT(g)->action_timer / 2;
					}
				}
			}

			DONE;
		}
		
		AGUY->magic_used = AGUY->mpts;
					
		for (t = 0; t != NUM_GUY_TIMERS; ++t)
		{
			if (APORT(g)->misc_type[t] != KO_TIME)
			{
				APORT(g)->timer[t] = 1;

				if (APORT(g)->misc_type[t] == MES_TIME)
				{
					APORT(g)->action_timer = 1;
				}
			}
		}

		DONE;
	}
		
	if (m < 0)
	{
		DONE;
	}

	for (t = 0; t != NUM_MON_TIMERS; ++t)
	{
		if (AMON->misc_type[t] == SHIELD_TIME)
		{
			shield_t = t;
		}
	}

	if (shield_t >= 0)
	{
		if (dodged == PARTIAL_DODGE)
		{
			prfmsg(MSG432, name);

			if (AMON->timer[shield_t] > 1)
			{
				AMON->timer[shield_t] = AMON->timer[shield_t] / 2;
			}
		}
		else
		{
			AMON->timer[shield_t] = 1;
		}

		DONE;
	}
	
	name[0] = 0;
	Start_Mon_Name(name, m);
	prfmsg(MSG434, name);

	if (dodged == PARTIAL_DODGE)
	{
		if (AMON->magic_used < AMON->mpts / 2)
		{
			AMON->magic_used = AMON->mpts / 2;
		}
					
		for (t = 0; t != NUM_MON_TIMERS; ++t)
		{
			if (AMON->timer[t] > 1 && AMON->misc_type[t] != KO_TIME)
			{
				AMON->timer[t] = AMON->timer[t] / 2;

				if (AMON->misc_type[t] == MES_TIME)
				{
					AMON->action_timer = AMON->action_timer / 2;
				}
			}
		}

		DONE;
	}
	
	AMON->magic_used = AMON->mpts;
		
	for (t = 0; t != NUM_MON_TIMERS; ++t)
	{
		if (AMON->misc_type[t] != KO_TIME)
		{
			AMON->timer[t] = 1;
	
			if (AMON->misc_type[t] == MES_TIME)
			{
				AMON->action_timer = 1;
			}
		}
	}

	DONE;
}
/****************************************************************************
	summon a specific monster
*/
short Summon(short which, short option, MLONG dmg)
{
	short   i;
	short   t;
	short   avail;
	short   m;
	short   mutated = FALSE;
	MLONG   level;

	for (m = 0, avail = -1; avail < 0 && m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what == 0)
		{
			avail = m;
		}
	}

	if (avail < 0)
	{
		DONE;
	}

	Read_Critter(which, &crit);

	if (!crit.permanant)
	{
		if (option == SUMMON_PERM)
		{
			sprintf(str, "SUMMON ERROR! Mon: %d", crit.which);
			NOTIFY(str);
			BAD_EXIT;
		}

		crit.alg = 0;
		crit.blocks = 1;

		if (option == SUMMON_RANDOM && RANDOM(4) == 1)
		{
			mutated = TRUE;
			level = (MLONG) crit.Level * 2L;

			if (level > 32767)
			{
				crit.Level = 32767;
			}
			else
			{
				crit.Level = (short) level;
			}
		}
		else if (option == SUMMON_INVADER)
		{
			crit.Level = invasion->level;

			if (crit.hit_vector == 0 || crit.hit_vector == PEST)
			{
				crit.hit_vector = STEALER;
			}

			if 
			(
				crit.attacked_vector == JAILED || 
				crit.attacked_vector == ADD_EVIL
			)
			{
				crit.attacked_vector = 0;
			}
		}
	}

	if 
	(
		option == SUMMON_PERM && 
		which == globals->rover &&
		invasion->active &&
		globals->captive_safe
	)
	{
		DONE;
	}

	setmem(&ABUF(B)->mon[avail], MON_SIZE, 0);
	memcpy(&ABUF(B)->mon[avail], &crit, CRIT_SIZE);

	Set_Mon_Stats(&ABUF(B)->mon[avail], NO_RANDOM);

	Set_Mon_Points
	(
		&ABUF(B)->mon[avail].dpts,
		&ABUF(B)->mon[avail].mpts,
		ABUF(B)->mon[avail].Str,
		ABUF(B)->mon[avail].Con,
		ABUF(B)->mon[avail].Psy
	);
	
	if (ABUF(B)->mon[avail].spell_caster)
	{
		for (i = 0; i != NUM_SPELLS; ++i)
		{
			ABUF(B)->mon[avail].spell[i] = TRUE;
		}
	}

	if 
	(
		me.perm[GAMEOP_PERM] || 
		crit.permanant || 
		RANDOM(30) == 1 ||
		option == SUMMON_INVADER
	)
	{
		for (i = 0; i != POSSIBLE_MON_ITEM; ++i)
		{
			if (crit.Item[i])
			{
				Create_Item
				(
					crit.Item[i], 
					&ABUF(B)->mon[avail], 
					100, 
					TO_MONSTER,
					(option != SUMMON_RANDOM)
				);
			}
		}
	}

	if (option == SUMMON_INVADER)
	{
		for (i = 0; i != MAX_MON_ITEM; ++i)
		{
			if 
			(
				ABUF(B)->mon[avail].item_has[i].what && 
				ABUF(B)->mon[avail].item_has[i].which == SCROLL
			)
			{
				ABUF(B)->mon[avail].item_has[i].what = 0;
			}
		}
	}

	if (bp_mons)
	{
		ABUF(B)->mon[avail].dpts = (ABUF(B)->mon[avail].dpts * 2L) / 3L;
	}

	for (i = 1; i != NTERMS; ++i)
	{
		t = find_timer(INVISIBLE_TIME, i, -1);
		if (!APORT(i)->hidden && !t || (i == P && option != SUMMON_INVADER))
		{
			ABUF(B)->mon[avail].sees[i] = TRUE;
		}
	}

	ABUF(B)->mon[avail].last_attacker = -1;
	ABUF(B)->mon[avail].summoned_by = -1;
	ABUF(B)->mon[avail].damage = dmg;

	if (ABUF(B)->mon[avail].what == AWESOME)
	{
		ABUF(B)->mon[avail].enhanced = TRUE;
	}
	else if (ABUF(B)->mon[avail].attacked_vector == MORPH)
	{
		ABUF(B)->mon[avail].enhanced = TRUE;
	}
	else
	{
		ABUF(B)->mon[avail].enhanced = (option != SUMMON_RANDOM);
	}

	if (option == SUMMON_RANDOM)
	{
		ABUF(B)->mon[avail].pursue_forever = TRUE;
		ABUF(B)->mon[avail].summoned_by = MY_PORT->index;

		if (!me.perm[SUPER_PERM])
		{
			ABUF(B)->mon[avail].last_attacker = P;
		}

		if (mutated)
		{
			strcpy(name, getmsg(MSG675));
		}
		else if (crit.article[0])
		{
			strcpy(name, crit.article);
			strcat(name, " ");
		}
		else
		{
			name[0] = 0;
		}

		strcat(name, crit.name);

		sprintf(str, getmsg(MSG676), name);
		prf("%s\r", str);
		Message(str, LOUD_LOCAL);
	}

	DONE;
}
/****************************************************************************
	user has just teleported
*/
void teleport_to(short room)
{

	sprintf(str, getmsg(MSG678), me.name);
	Message(str, QUIET_LOCAL);
	prfmsg(MSG679);
	No_Follow();
	me.location = Closet_Check(room);
	MY_PORT->hidden = 0;
	Reveal_Me(-1);
	move_me_to(me.location, CLEAR_OLD);
	MY_PORT->limbo_return = 0;
}
/****************************************************************************
	inform the room that I cast a spell at a guy or monster.
*/
void inform_room(short s, short g, short m)
{

	if (g >= 0)
	{
		if (g != P)
		{
			sprintf(str, getmsg(MSG680), me.name, spell_info[s].name);
			Message(str, g);

			sprintf(str, getmsg(MSG681), me.name, spell_info[s].name, AGUY->name);
			Message(str, -(g + 1));
		}
	}
	else
	{
		Set_Mon_Name(name, m);
		sprintf(str, getmsg(MSG681), me.name, spell_info[s].name, name);
		Message(str, LOUD_LOCAL);
	}
}
/****************************************************************************
	see if target dodges an offensive spell aimed their way
*/
short Dodged(short g, short m, short instill, short s)
{
	short   amulet_index;
	short   i;
	MLONG   his_dex;
	MLONG   my_dex = me.Dex;
	short   dodged;
	MLONG   his_factor;
	MLONG   my_factor;
	short   sleep_t;
	short   shield_t;

	my_factor = (MLONG) Local_Psy(P);

	if (me.class == MYSTIC || me.class == SORCERER || me.class == CLERIC)
	{
		my_factor += (MLONG) Stat_Lev(me.Psy);
	}

	if (me.focus != -1 && !instill)
	{
		my_factor = (my_factor * globals->focus2) / 10L;

		if (MY_PORT->focused != 2)
		{
			if (!me.item[me.focus].infinite_uses)
			{
				--me.item[me.focus].uses;
			}

			if (me.item[me.focus].uses <= 0)
			{
				prfmsg(MSG1340, me.item[me.focus].name);
			}
			else
			{
				prfmsg(MSG1339, me.item[me.focus].name);
			}
		}

		MY_PORT->focused = 2;
	}

	if (g >= 0)
	{
		for (i = 0, amulet_index = -1; i != NUM_ITEMS; ++i)
		{
			if (AGUY->item[i].what == AMULET)
			{
				amulet_index = i;
			}
		}

		if (amulet_index != -1)
		{
			prfmsg
			(
				MSG1312, 
				AGUY->name, 
				AGUY->item[amulet_index].name
			);

			sprintf(str, getmsg(MSG1314), AGUY->item[amulet_index].name);
			Message(str, g);

			if (!AGUY->item[amulet_index].infinite_uses)
			{
				AGUY->item[amulet_index].uses -= spell_info[s].pts;
			}

			if (me.focus != -1)
			{
				AGUY->item[amulet_index].uses = 0;
			}

			if (AGUY->item[amulet_index].uses <= 0)
			{
				sprintf(str, getmsg(MSG1091), AGUY->item[amulet_index].name);
				Message(str, g);

				Next_User(g);
				Lose_Item(amulet_index);
				Previous_User();
			}

			return (TRUE);
		}

		his_dex = AGUY->Dex;

		if (AGUY->race == HALFLING)
		{
			his_dex = his_dex * 3;
		}

		sleep_t = find_timer(SLEEP_TIME, GUY);
		shield_t = find_timer(SHIELD_TIME, GUY);
		his_factor = Local_Psy(g);

		if (shield_t && s != DISPEL_MAGIC)
		{
			his_factor = his_factor * 3;
		}

		dodged = LRAND(his_dex) + his_factor > LRAND(my_dex) + my_factor;

		if (dodged)
		{
			dodged = LRAND(his_dex + his_factor) > LRAND(my_dex + my_factor);

			if (!dodged)
			{
				dodged = PARTIAL_DODGE;
			}
		}

		if (AGUY->perm[NOHIT_PERM])
		{
			dodged = TRUE;
		}
		if (!shield_t && (sleep_t || APORT(g)->bashed))
		{
			dodged = FALSE;
		}
		else if (me.perm[KILLER_PERM])
		{
			dodged = FALSE;
		}

		if (dodged == PARTIAL_DODGE)
		{
			if (!instill)
			{
				sprintf(str, getmsg(MSG682), AGUY->name);
				prf("%s\r", str);
				Message(str, -(g + 1));
				strcpy(str, getmsg(MSG683));
				Message(str, g);
			}
		}
		else if (dodged)
		{
			if (!instill)
			{
				sprintf(str, getmsg(MSG684), AGUY->name);
				prf("%s\r", str);
				Message(str, -(g + 1));
				strcpy(str, getmsg(MSG685));
				Message(str, g);
			}
		}
		else
		{
			if (!instill)
			{
				sprintf(str, getmsg(MSG686), AGUY->name);
				prf("%s\r", str);
				Message(str, -(g + 1));
			}
		}

		return (dodged);
	}
	
	Start_Mon_Name(name, m);

	for (i = 0; i != MAX_MON_ITEM; ++i)
	{
		if (AMON->item_has[i].what == AMULET)
		{
			name[0] = tolower(name[0]);
			sprintf(str, getmsg(MSG1313), name, AMON->item_has[i].name);
			prf("%s\r", str);
			Message(str, LOUD_LOCAL);

			if (me.focus != -1)
			{
				AMON->item_has[i].what = 0;
			}

			return (TRUE);
		}
	}
	
	his_dex = AMON->Dex;
	his_factor = AMON->Psy;

	sleep_t = find_timer(SLEEP_TIME, MON);
	shield_t = find_timer(SHIELD_TIME, MON);

	if (shield_t && s != DISPEL_MAGIC)
	{
		his_factor = his_factor * 3;
	}

	dodged = LRAND(his_dex) + his_factor > LRAND(my_dex) + my_factor;

	if (dodged)
	{
		dodged = LRAND(his_dex + his_factor) > LRAND(my_dex + my_factor);
	
		if (!dodged)
		{
			dodged = PARTIAL_DODGE;
		}
	}

	if (!shield_t && (sleep_t || AMON->bashed))
	{
		dodged = FALSE;
	}
		
	if (me.perm[KILLER_PERM])
	{
		dodged = FALSE;
	}
	else if (AMON->magic_immune)
	{
		dodged = TRUE;
	}
	else if (s == FEAR && AMON->permanant)
	{
		dodged = TRUE;
	}

	if (dodged == PARTIAL_DODGE)
	{
		if (!instill)
		{
			sprintf(str, getmsg(MSG682), name);
			prf("%s\r", str);
			Message(str, LOUD_LOCAL);
		}
	}
	else if (dodged)
	{
		if (!instill)
		{
			if (AMON->magic_immune)
			{
				name[0] = tolower(name[0]);
				sprintf(str, getmsg(MSG1306), name);
			}
			else
			{
				sprintf(str, getmsg(MSG684), name);
			}
			prf("%s\r", str);
			Message(str, LOUD_LOCAL);
		}
	}
	else
	{
		if (!instill)
		{
			sprintf(str, getmsg(MSG686), name);
			prf("%s\r", str);
			Message(str, LOUD_LOCAL);
		}
	}

	return (dodged);
}
/****************************************************************************
	see if someone is bringable
*/
short Bring_OK(short g, short my_level)
{
	short   me_level;
	short   his_level;
	short   diff;
	short   old_b;
	short   safe;
	short   id;
	short   no_teleport;

	if (APORT(g)->limbo_return)
	{
		prfmsg(MSG1298, AGUY->name);
		BAD_EXIT;
	}

	if (me.perm[GAMEOP_PERM])
	{
		return (TRUE);
	}

	if (TYPE == ARENA)
	{
		prfmsg(M614);
		BAD_EXIT;
	}

	old_b = B;
	B = APORT(g)->B;
	id = ABUF(B)->rm.id;
	no_teleport = ABUF(B)->rm.no_teleport;
	safe = SAFE_AREA;
	B = old_b;

	if (id == globals->prison && !me.perm[GAMEOP_PERM] && !MY_PORT->paladin)
	{
		prfmsg(M694, AGUY->name);
		BAD_EXIT;
	}

	if (ABUF(B)->rm.no_teleport == TRUE || no_teleport == TRUE)
	{
		prfmsg(MSG1278, AGUY->name);
		BAD_EXIT;
	}

	if (AGUY->Option[ALL_BRING])
	{
		return (TRUE);
	}

	if (find_timer(SHIELD_TIME, GUY))
	{
		prfmsg(M693, AGUY->name);
		BAD_EXIT;
	}
	
	if (!SAFE_AREA && globals->outlaws)
	{
		if (me.outlaw != 'Y')
		{
			prfmsg(MSG1286);
			BAD_EXIT;
		}

		if (AGUY->outlaw != 'Y')
		{
			prfmsg(MSG1287);
			BAD_EXIT;
		}
	}

	if (safe && !me.perm[GAMEOP_PERM] && !MY_PORT->assassin)
	{
		prfmsg(M695, AGUY->name);
		BAD_EXIT;
	}

	if (safe && MY_PORT->assassin_timer)
	{
		prfmsg(M540, MY_PORT->assassin_timer);
		BAD_EXIT;
	}
	
	if (safe)
	{
		MY_PORT->assassin_timer = ASSASSIN_TIME;
	}
  
	if (Stat_Lev(AGUY->Psy) > my_level)
	{
		prfmsg(M697, AGUY->name);
		BAD_EXIT;
	}

	me_level = Approximate_Level(P);
	his_level = Approximate_Level(g);
	diff = abs(me_level - his_level);

	if (!SAFE_AREA && (diff > globals->pvplevel || globals->pvplevel == 0))
	{
		prfmsg(M698);
		BAD_EXIT;
	}

	return (TRUE);
}
/****************************************************************************
	see if someone is seekable
*/
short Seek_OK(short g)
{
	short   t;

	if (me.perm[GAMEOP_PERM])
	{
		return (TRUE);
	}

	for (t = 0; t != NUM_GUY_TIMERS; ++t)
	{
		if 
		(
			APORT(g)->misc_type[t] == SHIELD_TIME && 
			!MY_PORT->paladin &&
			!MY_PORT->assassin
		)
		{
			prfmsg(M693, AGUY->name);
			BAD_EXIT;
		}
	}

	if (ABUF(APORT(g)->B)->rm.rmtype < 0 && AGUY->in_guild != me.in_guild)
	{
		prfmsg(M700, AGUY->name);
		BAD_EXIT;
	}

	if (ABUF(APORT(g)->B)->rm.rmtype == CLOSET)
	{
		prfmsg(M701, AGUY->name);
		BAD_EXIT;
	}

	if (ABUF(APORT(g)->B)->rm.no_teleport == TRUE)
	{
		prfmsg(MSG1277);
		BAD_EXIT;
	}

	if (APORT(g)->limbo_return)
	{
		prfmsg(MSG1298, AGUY->name);
		BAD_EXIT;
	}

	return (TRUE);
}
/****************************************************************************
	clear the monsters out of a room
*/
void Terror(void)
{
	short   m;
	short   did_one = FALSE;

	sprintf(str, getmsg(MSG702), me.name);
	Message(str, QUIET_LOCAL);

	for (m = MAX_ROOM_MON - 1; m >= 0; --m)
	{
		if (AMON->what && !AMON->permanant)
		{
			did_one = TRUE;
			Remove_Mon(m, FALSE);
		}
	}

	if (!did_one)
	{
		prfmsg(M703);
	}
	else
	{
		prfmsg(MSG704);
	}
}
/****************************************************************************
	visioning spell
*/
short visioning(char *word)
{
	short   dir = 0;
	short   loc;
	short   b;
	short   old_b;
	short   old_owner;
	short   old_lucky;
	short   looked = FALSE;
	short   revealed;

	if (word[0] == 0)
	{
		if (margc < 3)
		{
			prfmsg(M705);
			BAD_EXIT;
		}
		else
		{
			strcpy(word, margv[2]);
		}
	}

	if (ABUF(B)->rm.spec_exit.leads_to)
	{
		if (sameto(word, ABUF(B)->rm.spec_exit.descriptor))
		{
			dir = -1;
		}
		else if (sameto(word, ABUF(B)->rm.spec_exit.adjective))
		{
			dir = -1;
		}
	}

	if (dir == 0)
	{
		if (word[0] == 'n')
		{
			dir = NORTH;
		}
		else if (word[0] == 's')
		{
			dir = SOUTH;
		}
		else if (word[0] == 'e')
		{
			dir = EAST;
		}
		else if (word[0] == 'w')
		{
			dir = WEST;
		}
		else if (word[0] == 'u')
		{
			dir = UP;
		}
		else if (word[0] == 'd')
		{
			dir = DOWN;
		}
		else if (word[0] == 'o')
		{
			dir = OUT;
		}
	}

	if (dir == 0)
	{
		prfmsg(M705);
		BAD_EXIT;
	}

	revealed = TRUE;

	if (dir > 0)
	{
		dir = dir - NORTH;

		if (ABUF(B)->rm.exit[dir] == 0)
		{
			prfmsg(M706);
			BAD_EXIT;
		}

		loc = ABUF(B)->rm.exit[dir];
	}
	else
	{
		loc = ABUF(B)->rm.spec_exit.leads_to;
	}

	prfmsg(MSG707);

	for (b = 0; b != NTERMS && !looked; ++b)
	{
		if (ABUF(B)->rm.id == loc && b != B && ABUF(B)->in_use)
		{
			old_b = B;
			old_lucky = MY_PORT->lucky_room;
			old_owner = MY_PORT->room_owner;

			B = b;
			command = LOOK;
			print_room();

			B = old_b;
			MY_PORT->lucky_room = old_lucky;
			MY_PORT->room_owner = old_owner;
			looked = TRUE;
		}
	}

	if (!looked)
	{
		Vision_Room(loc);
	}

	return (revealed);
}
/****************************************************************************
	display room via visioning
*/
void Vision_Room(short loc)
{
	short   i;
	short   old_b = B;
	short   old_owner = MY_PORT->room_owner;
	short   old_lucky = MY_PORT->lucky_room;

	B = NTERMS;
	Read_Room(loc, &ABUF(B)->rm, &a_room2);

	if (ABUF(B)->rm.items_or_mons)
	{
		Read_Sticky();
	}
	else
	{
		setmem(ABUF(B)->item, CLOSET_SIZE, 0);
		setmem(ABUF(B)->mon, PURSUER_SIZE, 0);
	}

	command = LOOK;
	print_room();

	for (i = 0; i != MAX_PERM_MON; ++i)
	{
		if (abs(globals->perm_mon_loc[i]) == loc)
		{
			if
			(
				globals->perm_mon_id[i] != globals->rover ||
				!invasion->active ||
				!globals->captive_safe
			)
			{
				Read_Critter(globals->perm_mon_id[i], &crit);
				prfmsg(MSG785, crit.article, crit.name);
			}
		}
	}

	if (invasion->active)
	{
		for (i = 0; i != MAX_INVASION_ROOMS; ++i)
		{
			if (invasion->room[i] == loc)
			{
				Read_Critter(invasion->crit, &crit);

				if (invasion->count[i] == 1)
				{
					prfmsg(MSG785, crit.article, crit.name);
				}
				else if (invasion->count[i])
				{
					prfmsg(MSG786, invasion->count[i], crit.plural_name);
				}
			}
		}
	}

	B = old_b;
	MY_PORT->lucky_room = old_lucky;
	MY_PORT->room_owner = old_owner;
}
/****************************************************************************
	spying spell
*/
short Spying(char *target)
{
	short   b;
	short   g;
	short   old_b;
	short   old_lucky;
	short   old_owner;

	g = find_remote_guy(target);

	if (g <= 0)
	{
		DONE;
	}

	if (ABUF(B)->guy[g])
	{
		prfmsg(M691A);
		DONE;
	}

	sprintf(str, getmsg(MSG597), me.name);
	Message(str, QUIET_LOCAL);
	prfmsg(MSG598);

	if (g == P)
	{
		prfmsg(M599);
		DONE;
	}

	if (!Spying_OK(g))
	{
		DONE;
	}

	b = APORT(g)->B;
	prfmsg(MSG707);

	old_b = B;
	old_lucky = MY_PORT->lucky_room;
	old_owner = MY_PORT->room_owner;
	B = b;

	command = LOOK;
	print_room();

	B = old_b;
	MY_PORT->lucky_room = old_lucky;
	MY_PORT->room_owner = old_owner;

	if (!me.perm[GAMEOP_PERM])
	{
		strcpy(str, getmsg(MSG600));
		Message(str, g);
	}

	return (TRUE);
}
/****************************************************************************
	user has revealed hidden exits
*/
void revelation(void)
{
	short   m;
	short   i;
	short   found_one = FALSE;

	for (i = 0; i != NUM_EXITS; ++i)
	{
		if (!ABUF(B)->visible[i] && ABUF(B)->rm.exit[i])
		{
			ABUF(B)->visible[i] = TRUE;

			if (!found_one)
			{
				prfmsg(MSG788);
				found_one = TRUE;
			}
			else
			{
				prf(", ");
			}

			print_exit(i);
		}
	}

	if (found_one)
	{
		prf(".\r");
	}

	if 
	(
		ABUF(B)->rm.spec_exit.leads_to &&
		ABUF(B)->rm.spec_exit.type && 
		(!ABUF(B)->visible[NUM_EXITS])
	)
	{
		prfmsg(MSG789);
		Special_Exit(1);
		found_one = TRUE;
		ABUF(B)->visible[NUM_EXITS] = TRUE;
	}

	for (i = 0; i != NTERMS; ++i)
	{
		if (ABUF(B)->guy[i] && i != P)
		{
			if (APORT(i)->hidden)
			{
				prfmsg(MSG790, APORT(i)->chr.name);
				found_one = TRUE;
			}
		}
	}

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what && AMON->hidden)
		{
			Monster_Name(name, AMON->article, AMON->name);
			sprintf(str, getmsg(MSG1350), me.name, name);
			Message(str, LOUD_LOCAL);
			prfmsg(MSG1351, name);
			AMON->hidden = FALSE;
			AMON->action_timer = AMON->action_timer / 3;
			found_one = TRUE;
		}
	}

	if (!found_one)
	{
		prfmsg(MSG791);
	}
}
/****************************************************************************
	see if someone is spyable
*/
short Spying_OK(short g)
{
	short   t;

	if (me.perm[GAMEOP_PERM])
	{
		return (TRUE);
	}

	if (AGUY->perm[GAMEOP_PERM])
	{
		prfmsg(MSG792, AGUY->name);
		BAD_EXIT;
	}

	for (t = 0; t != NUM_GUY_TIMERS; ++t)
	{
		if (APORT(g)->misc_type[t] == PROTECTED_TIME)
		{
			prfmsg(MSG792, AGUY->name);
			BAD_EXIT;
		}
	}

	return (TRUE);
}
/****************************************************************************
	user has performed a healing-type action
*/
short Healing(short g, short s, short my_level, short dur)
{
	short   did_ftg = FALSE;
	short   did_body = FALSE;
	short   did_poison = FALSE;
	short   pts;
	short   mania_t;
	short   t;
	short   m;
	short   in_combat = FALSE;

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if 
		(
			ABUF(B)->mon[m].what && 
			(ABUF(B)->mon[m].last_attacker == g ||
			 ABUF(B)->mon[m].last_attacker == P)
		)
		{
			in_combat = TRUE;
		}
	}

	if (APORT(g)->enemy_mon >= 0 || MY_PORT->enemy_mon >= 0)
	{
		in_combat = TRUE;
	}

	pts = RANDOM(dur) * RANDOM(dur);
	pts += (dur + my_level);

	for (t = 0; t != NUM_GUY_TIMERS; ++t)
	{
		if (AGUY->poison_timer)
		{
			did_poison = TRUE;
			
			if (AGUY->poison_timer < 32000)
			{
				AGUY->poison_timer += 60;
			}
		}
	}

	if (AGUY->damaged)
	{
		if (s == HEAL || s == RESTORE)
		{
			if (me.class == CLERIC && !in_combat)
			{
				pts = AGUY->damaged + 1;
			}

			if (pts > AGUY->damaged)
			{
				pts -= AGUY->damaged;
				did_body = AGUY->damaged;
			}
			else
			{
				did_body = pts;
				pts = 0;
			}
			AGUY->damaged -= did_body;
		}
	}

	mania_t = find_timer(MANIA_TIME, GUY);

	if (AGUY->ftg && pts && !mania_t)
	{
		if (s == VIGOR || s == RESTORE)
		{
			if (me.class == CLERIC && !in_combat)
			{
				pts = AGUY->ftg;
			}

			if (pts > AGUY->ftg)
			{
				did_ftg = AGUY->ftg;
			}
			else
			{
				did_ftg = pts;
			}

			AGUY->ftg -= did_ftg;
		}
	}

	if (!did_ftg && !did_body && !did_poison)
	{
		prfmsg(M558);

		if (g != P)
		{
			strcpy(str, getmsg(M558));
			Message(str, g);
		}
		BAD_EXIT;
	}

	if (MY_PORT->focused)
	{
		if (!me.item[me.focus].infinite_uses)
		{
			--me.item[me.focus].uses;
		}

		if (me.item[me.focus].uses <= 0)
		{
			prfmsg(MSG1340, me.item[me.focus].name);
		}
		else
		{
			prfmsg(MSG1339, me.item[me.focus].name);
		}
	}

	if (did_body)
	{
		prfmsg(MSSG793, did_body);
		prf(NL);

		if (g != P)
		{
			sprintf(str, getmsg(MSSG793), did_body);
			Message(str, g);
		}
	}

	if (did_ftg)
	{
		prfmsg(MSSG796, did_ftg);
		prf(NL);

		if (g != P)
		{
			sprintf(str, getmsg(MSSG796), did_ftg);
			Message(str, g);
		}
	}

	if (did_poison)
	{
		prfmsg(MSG798);

		if (g == P)
		{
			prfmsg(MSG799, me.poison_timer);
		}
		else
		{
			prf(NL);

			sprintf(str, getmsg(MSG800), AGUY->poison_timer);
			Message(str, g);
		}
	}

	return (TRUE);
}
/****************************************************************************
	find a monster around "my_level"
*/
short find_a_mon(short my_level)
{
	short   which;
	short   done;
	short   tries = 0;
	short   max_level;
	short   default_mon = -1;
	short   default_lev = 0;

	max_level = my_level + spell_info[SUMMON].dur;

	do
	{
		done = TRUE;
		++tries;
		which = RANDOM(MAX_MONSTER - 1);
		Read_Critter(which, &crit);

		if (crit.permanant)
		{
			done = FALSE;
		}
		else if (crit.attacked_vector == JAILED)
		{
			done = FALSE;
		}
		else if (crit.kills >= globals->extmon)
		{
			done = FALSE;
		}
		else if (crit.Level < my_level || crit.Level > max_level)
		{
			if (crit.Level > default_lev)
			{
				default_lev = crit.Level;
				default_mon = which;
			}

			done = FALSE;
		}
	}
	while (!done && tries < 50);
	
	if (!done)
	{
		tries = 0;
		max_level = my_level * 2;

		do
		{
			done = TRUE;
			++tries;
			which = RANDOM(MAX_MONSTER - 1);
			Read_Critter(which, &crit);

			if (crit.permanant)
			{
				done = FALSE;
			}
			else if (crit.attacked_vector == JAILED)
			{
				done = FALSE;
			}
			else if (crit.kills >= globals->extmon)
			{
				done = FALSE;
			}
			else if (crit.Level < my_level || crit.Level > max_level)
			{
				if (crit.Level > default_lev)
				{
					default_lev = crit.Level;
					default_mon = which;
				}

				done = FALSE;
			}
		}
		while (!done && tries < 50);
	}

	if (!done)
	{
		if (default_mon != -1)
		{
			which = default_mon;
		}
		else
		{
			which = 1;
		}
	}

	return (which);
}
/****************************************************************************
	user just turned invisible
*/
void Go_Invisible(short g, short ring, short dur)
{
	short   i;
	short   see_invis;

	for (i = 1; i != NTERMS; ++i)
	{
		if (ABUF(B)->guy[i])
		{
			see_invis = find_timer(SEE_INVIS_TIME, i, -1); 
			if (!see_invis)
			{
				APORT(g)->follower[i] = 0;
			}
		}
	}

	if (g == P)
	{
		prfmsg(MSG801);
		sprintf(str, getmsg(MSG802), me.name);
		Message(str, QUIET_LOCAL);
	}
	else
	{
		prfmsg(MSG803, AGUY->name);
		strcpy(str, getmsg(MSG804));
		Message(str, g);
		sprintf(str, getmsg(MSG802), AGUY->name);
		Message(str, -(g + 1));
	}

	if (!ring)
	{
		Make_A_Timer(INVISIBLE_TIME, dur, GUY, RESET);
	}
}
/****************************************************************************
	User wants to wear a magic ring
*/
short Ring_Magic(short index)
{
	short   i;
	short   ring_count;

	item = me.item[index];

	if (item.ring_used)
	{
		prfmsg(MSG805);
		Display_Item(&item);
		prf(NL);
		me.item[index].ring_used = FALSE;
		Affect_Expired(me.item[index].spell_cast, P);
		BAD_EXIT;
	}

	for (i = ring_count = 0; i != NUM_ITEMS; ++i)
	{
		if
		(
			me.item[i].what == MAGIC_DEV &&
			me.item[i].which == MAGIC_RING &&
			me.item[i].ring_used
		)
		{
			++ring_count;
		}
	}

	if (ring_count == 2)
	{
		prfmsg(MSG806);
		BAD_EXIT;
	}

	prfmsg(MSG807);
	Display_Item(&item);
	prf(NL);
	me.item[index].ring_used = TRUE;
	Permanant_Affect(item.spell_cast);

	DONE;
}
/****************************************************************************
	User put on armor or ring
*/
void Permanant_Affect(short s)
{

	if (s == VIGOR)
	{
		prfmsg(MSG808);
	}
	else if (s == HEAL)
	{
		prfmsg(MSG809);
	}
	else if (s == INVISIBILITY)
	{
		Go_Invisible(P, TRUE, 0);
	}
	else if (s == PURIFY)
	{
		prfmsg(MSG810);
	}
	else if (s == ELICITATION)
	{
		prfmsg(MSG811);
	}
	else if (s == PASS_DOOR)
	{
		prfmsg(MSG812);
	}
	else if (s == MANIA)
	{
		prfmsg(MSG813);
	}
	else if (s == REVEAL)
	{
		prfmsg(MSG814);
	}
	else if (s == RESTORE)
	{
		prfmsg(MSG815);
	}
	else if (s == PROTECT)
	{
		prfmsg(MSG816);
	}
	else if (s == LEVITATE)
	{
		prfmsg(MSG817);
	}
	else if (s == INVULNERABILITY)
	{
		prfmsg(MSG818);
	}
	else if (s == STRENGTH)
	{
		prfmsg(MSG819);
	}
	else if (s == STURDINESS)
	{
		prfmsg(MSG820);
	}
	else if (s == MAGIC_SHIELD)
	{
		prfmsg(MSG821);
	}
	else if (s == SEE_INVISIBLE)
	{
		prfmsg(MSG822);
	}
	else if (s == HASTE)
	{
		prfmsg(MSG823);
	}
	else if (s == STEALTH)
	{
		prfmsg(MSG824);
	}
}
/****************************************************************************
	a players ring has run out of time or he took off his instilled armor
*/
void Affect_Expired(short s, short g)
{

	if (s == VIGOR)
	{
		prfmsg(M121);
	}
	else if (s == HEAL)
	{
		prfmsg(M122);
	}
	else if (s == INVISIBILITY)
	{
		Guy_Becomes_Visible(g);
	}
	else if (s == PURIFY)
	{
		prfmsg(M123);
	}
	else if (s == ELICITATION)
	{
		prfmsg(M124);
	}
	else if (s == PASS_DOOR)
	{
		prfmsg(M125);
	}
	else if (s == MANIA)
	{
		if (find_timer(MANIA_TIME, GUY) == 0)
		{
			prfmsg(M126);
		}     
	}
	else if (s == REVEAL)
	{
		prfmsg(M127);
	}
	else if (s == RESTORE)
	{
		prfmsg(M128);
	}
	else if (s == PROTECT)
	{
		if (find_timer(PROTECTED_TIME, GUY) == 0)
		{
			prfmsg(M129);
		}
	}
	else if (s == LEVITATE)
	{
		if (find_timer(FLOAT_TIME, GUY) == 0)
		{
			prfmsg(MSG130);
		}
	}
	else if (s == INVULNERABILITY)
	{
		if (find_timer(INVULNERABLE_TIME, GUY) == 0)
		{
			prfmsg(M131);
		}
	}
	else if (s == STRENGTH)
	{
		if (find_timer(STRONG_TIME, GUY) == 0)
		{
			prfmsg(M132);
			Got_Weak(g);
		}
	}
	else if (s == STURDINESS)
	{
		if (find_timer(STURDY_TIME, GUY) == 0)
		{
			prfmsg(M133);
		}
	}
	else if (s == MAGIC_SHIELD)
	{
		if (find_timer(SHIELD_TIME, GUY) == 0)
		{
			prfmsg(M134);
		}
	}
	else if (s == SEE_INVISIBLE)
	{
		if (find_timer(SEE_INVIS_TIME, GUY) == 0)
		{
			prfmsg(M135);
		}
	}
	else if (s == HASTE)
	{
		if (find_timer(FAST_TIME, GUY) == 0)
		{
			prfmsg(M136);
		}
	}
	else if (s == STEALTH)
	{
		if (find_timer(STEALTH_TIME, GUY) == 0)
		{
			prfmsg(M137);
		}
	}
}
/***************************************************************************
	find a room that's OK to teleport to
*/
short EXPORT Find_Teleport_Room(void)
{
	short   n;
	short   tries = 0;
	short   done;
	short   room_num;

	do
	{
		room_num = RANDOM(globals->maxroom);
		Read_Room(room_num, &a_room, &a_room2);
		
		done = TRUE;
		++tries;
				
		if 
		(
			a_room.invaders == 'N' || 
			a_room.rmtype < 0 || 
			a_room.rmtype == DAMAGE_ROOM ||
			a_room.exit[6] == globals->townsq ||
			a_room.no_teleport == TRUE
		)
		{
			done = FALSE;
		}
		else if 
		(
			room_num == globals->prison || 
			room_num == globals->sanctum || 
			room_num == globals->limboloc ||
			room_num == globals->townsq
		)
		{
			done = FALSE;
		}
		
		for (n = 0; n != MAX_PERM_MON; ++n)
		{
			if (abs(globals->perm_mon_loc[n]) == room_num)
			{
				done = FALSE;
			}
		}
	} 
	while (!done && tries < 300);

	return (room_num);
}

