#include <header.h>
#include <globals.h>

/****************************************************************************
	zero out my macros
*/
void EXPORT Erase_Macros(short index)
{

	Write_Macros(index, macros[NTERMS]);
}
/****************************************************************************
	see if user has invoked a macro
*/
short Macro_Check(void)
{
	short   i;
	short   len;
	char    word[LINE_LEN];
	char    str[LINE_LEN * 2];

	rstrin();
	for (i = 0; i != LINE_LEN; ++i)
	{
		word[i] = 0;
	}

	for (i = 0; i < LINE_LEN; ++i)
	{
		if (input[i] == ' ' || input[i] == 0)
		{
			strncpy(word, input, i);
			len = i;
			i = LINE_LEN;
		}
	}

	if (word[0])
	{
		for (i = 0; i < NUM_MACROS; ++i)
		{
			if (sameas(word, macros[P]->macro_name[i]))
			{
				if (input[len] != 0)
				{
					sprintf
					(
						str, 
						"%s %s", 
						macros[P]->macro_txt[i], 
						&input[len + 1]
					);
					str[LINE_SIZE - 5] = 0;
				}
				else
				{
					strcpy(str, macros[P]->macro_txt[i]);
				}

				prfmsg(MSG860, str);
				strcpy(input, str);

				i = NUM_MACROS;
			}
		}
	}

	parsin();
	DONE;
}
/****************************************************************************
	user wants to set a macro
*/
short Set_Macro(void)
{
	short   which;
	short   i;
	short   j;
	short   n;
	short   avail = -1;
	short   num_macs = 0;

	if (word1[0] == 0)
	{
		prfmsg(MSG861);
		BAD_EXIT;
	}

	for (i = 0; i != NUM_MACROS; ++i)
	{
		if (macros[P]->macro_name[i][0])
		{
			++num_macs;
		}
		else if (avail < 0)
		{
			avail = i;
		}
	}

	which = INUM(word1);

	if (which > 0 && which <= NUM_MACROS)
	{
		if (macros[P]->macro_name[which - 1][0])
		{
			prfmsg(MSG862, macros[P]->macro_name[which - 1]);
			macros[P]->macro_name[which - 1][0] = 0;
			Write_Macros(MY_PORT->index, macros[P]);
		}
		else
		{
			prfmsg(MSG863, which);
		}
	}
	else if (strlen(word1) > MACRO_NAME_SIZE - 1)
	{
		prfmsg(MSG865, MACRO_NAME_SIZE - 1);
	}
	else
	{
		for (i = 0; i != NUM_MACROS; ++i)
		{
			if (sameas(macros[P]->macro_name[i], word1))
			{
				prfmsg(MSG866, macros[P]->macro_name[i]);
				macros[P]->macro_name[i][0] = 0;
				Write_Macros(MY_PORT->index, macros[P]);
				BAD_EXIT;
			}
		}
	
		if (num_macs == NUM_MACROS)
		{
			prfmsg(MSG864, NUM_MACROS);
			BAD_EXIT;
		}

		rstrin();
		i = 0;

		do
		{
			++i;
		}
		while (input[i] != ' ');

		++i;

		do
		{
			++i;
		}
		while (input[i] != ' ');

		++i;

		if (input[i] == 0 || margc == 2)
		{
			prfmsg(MSG867, word1);
			BAD_EXIT;
		}

		strcpy(macros[P]->macro_name[avail], word1);
		for (n = 0; n != LINE_SIZE - 10; ++n)
		{
			macros[P]->macro_txt[avail][n] = 0;
		}

		for (j = 0; i != LINE_LEN && input[i] && j < LINE_SIZE - 12; ++j)
		{
			macros[P]->macro_txt[avail][j] = input[i];
			++i;
		}

		prfmsg
		(
			MSG868, 
			avail + 1, 
			macros[P]->macro_name[avail],
			macros[P]->macro_txt[avail]
		);

		Write_Macros(MY_PORT->index, macros[P]);
	}
	DONE;
}
/****************************************************************************
	list a user's macros
*/
void EXPORT List_Macros(void)
{
	short   i;

	prfmsg(MSG869);

	for (i = 0; i != NUM_MACROS; ++i)
	{
		if (macros[P]->macro_name[i][0])
		{
			prfmsg
			(
				MACDISP,
				i + 1,
				macros[P]->macro_name[i],
				macros[P]->macro_txt[i]
			);
		}
		else
		{
			prfmsg(MSG870, i + 1);
		}
	}
}
/****************************************************************************
	read a user's macros
*/
void Read_My_Macros(void)
{
	short   i;
	FILE    *fp_macro;

	fp_macro = fopen(CHAOS_MACRO_FILE, RDWR);
	lsk = (MLONG) MY_PORT->index * MACRO_SIZE;
	fseek(fp_macro, lsk, TOP);
	i = fread(macros[P], MACRO_SIZE, 1, fp_macro);

	if (i == 0)
	{
		setmem(macros[P], MACRO_SIZE, 0);
		Write_Macros(MY_PORT->index, macros[P]);
	}

	fclose(fp_macro);
}
/****************************************************************************
	write a user's macros
*/
void Write_Macros(short index, struct macro_struct *macro)
{
	FILE    *fp_macro;

	fp_macro = fopen(CHAOS_MACRO_FILE, RDWR);
	lsk = (MLONG) index * MACRO_SIZE;
	fseek(fp_macro, lsk, TOP);
	fwrite(macro, MACRO_SIZE, 1, fp_macro);
	fclose(fp_macro);
}
