#include <header.h>
#include <globals.h>

/****************************************************************************
	an item has left the ground
*/
void EXPORT Lose_Ground_Item(short index)
{
	short   i;
	short   count;

	if (ABUF(B)->item[index].permanant)
	{
		Update_Perm_Item(ABUF(B)->item[index].id, 0);
	}

	for (i = count = 0; i != NUM_ITEMS; ++i)
	{
		if (ABUF(B)->item[i].what)
		{
			++count;
		}
	}

	ABUF(B)->item[index].what = 0;

	if (index + 1 != NUM_ITEMS)
	{
		for (i = index + 1; i != NUM_ITEMS; ++i)
		{
			ABUF(B)->item[i - 1] = ABUF(B)->item[i];
		}
	}

	ABUF(B)->item[count - 1].what = 0;
	ABUF(B)->item_change = TRUE;
}
/****************************************************************************
	add an item to the room
*/
void EXPORT Put_In_Room(struct item_struct *item)
{
	short   i;

	ABUF(B)->item_change = TRUE;

	for (i = 0; i != NUM_ITEMS; ++i)
	{
		if (ABUF(B)->item[i].what == 0)
		{
			memcpy(&ABUF(B)->item[i], item, ITEMSIZE);
			return;
		}
	}

	if (ABUF(B)->item[0].what == CONTAINER)
	{   
		Kill_Container(&ABUF(B)->item[0]);
	}

	for (i = 1; i != NUM_ITEMS; ++i)
	{
		ABUF(B)->item[i - 1] = ABUF(B)->item[i];
	}
	
	memcpy(&ABUF(B)->item[NUM_ITEMS - 1], item, ITEMSIZE);
}
/****************************************************************************
	add an item to the room (no scroll)
*/
short EXPORT Dump_In_Room(struct item_struct *item)
{
	short   i;

	ABUF(B)->item_change = TRUE;

	for (i = 0; i != NUM_ITEMS; ++i)
	{
		if (ABUF(B)->item[i].what == 0)
		{
			memcpy(&ABUF(B)->item[i], item, ITEMSIZE);
			return(TRUE);
		}
	}

	prfmsg(M534);
	BAD_EXIT;
}
/***************************************************************************
	determine where dead guy's stuff goes
*/
short EXPORT lose_items(void)
{
	short   i;
	short   talismans;

	if (me.gold)
	{
		setmem(&item, ITEMSIZE, 0);
		strcpy(item.article, "a");
		strcpy(item.name, "pile of coins");
		item.what = CASH;
		item.worth = me.gold;
		me.gold = 0;
		Give_Me(&item);
	}

	if (me.item[0].what == 0)
	{
		BAD_EXIT;
	}

	for (i = talismans = 0; i != NUM_ITEMS; ++i)
	{
		if (me.item[i].what == TALISMAN)
		{
			++talismans;
		}
		else if (globals->bagtals && me.item[i].what == CONTAINER)
		{
			talismans += Talisman_Count(&me.item[i]);
		}
	}

	if (talismans)
	{
		for (i = 0; i != NUM_ITEMS; ++i)
		{
			if (me.item[i].what)
			{
				if (me.item[i].what == CONTAINER)
				{   
					Kill_Container(&me.item[i]);
				}

				Lose_Item(i);
				--i;
			}
		}

		return (talismans);
	}

	for (i = 0; i != NUM_ITEMS; ++i)
	{
		if (me.item[i].what)
		{
			Put_In_Room(&me.item[i]);
			Lose_Item(i);
			--i;
		}
	}
	
	BAD_EXIT;
}
/****************************************************************************
	look through my inventory for the requested item
*/
short EXPORT find_item
(
	char    *item, 
	short   which, 
	short   inform, 
	short   *absolute_match
)
{
	short   count;
	short   i;
	short   index = NOT_FOUND;
	short   unique = 1;
	short   local_abs = 0;
	char    *word;
	char    match[LINE_LEN];

	match[0] = 0;
	i = atoi(item);

	if (i > 0 && i <= NUM_ITEMS)
	{
		--i;
		if (me.item[i].what)
		{
			return(i);
		}
		
		if (inform)
		{
			prfmsg(MSG1019, i + 1);
		}

		return (NOT_FOUND);
	}
	else if (i > NUM_ITEMS)
	{
		if (inform)
		{
			prfmsg(MSG1020);
		}

		return (NOT_FOUND);
	}

	for (i = count = 0; i != NUM_ITEMS; ++i)
	{
		if (me.item[i].what)
		{
			strcpy(name, me.item[i].name);
			word = strtok(name, " ");

			if (sameas(word, item))
			{
				++count;
				if (count <= which)
				{
					index = i;
				}
				*absolute_match = ABS_ITM;
				++local_abs;
			}
		}
	}

	if (!local_abs)
	{
		match[0] = 0;
		for (i = count = 0; i != NUM_ITEMS; ++i)
		{
			if (me.item[i].what)
			{
				strcpy(name, me.item[i].name);
				word = strtok(name, " ");
				if (sameto(item, word))
				{
					if (match[0] == 0)
					{
						strcpy(match, word);
					}
					else
					{
						if (!sameas(word, match))
						{
							unique = 0;
						}
					}

					++count;

					if (count <= which)
					{
						index = i;
					}
				}
			}
		}
	}

	if (count == 0)
	{
		if (inform)
		{
			prfmsg(M542, item);
		}
	}
	else if (!unique)
	{
		if (inform)
		{
			prfmsg(M167, item);
		}

		index = NOT_UNIQUE;
	}
	else if (count < which)
	{
		if (inform)
		{
			prfmsg(MSG1021);
		}

		index = NOT_THAT_MANY;
	}

	return(index);
}
/****************************************************************************
	calculate weight and # of items user is carrying
*/
void EXPORT Calc_Weight(short *num_items, MLONG *carrying, MLONG *max)
{
	short   i;
	short   strong_t;

	*num_items = 0;
	*carrying = 0;

	for (i = 0; i != NUM_ITEMS; ++i)
	{
		if (me.item[i].what)
		{
			++*num_items;
			*carrying += Weight(&me.item[i]);
		}
	}

	*carrying += me.gold;

	strong_t = find_timer(STRONG_TIME, ME);

	*max = ((MLONG) me.Str * globals->strfctr);
	
	if (strong_t)
	{
		*max = *max * 2;
	}

	if (me.class == BARBARIAN)
	{
		*max = *max * 2;
	}
}
/****************************************************************************
	user is receiving an item
*/
short EXPORT Give_Me(struct item_struct *item)
{
	short   i;
	short   num_items;
	MLONG   carrying;
	MLONG   max;

	Calc_Weight(&num_items, &carrying, &max);

	if (num_items == NUM_ITEMS)
	{
		prfmsg(M1022, NUM_ITEMS);
		BAD_EXIT;
	}

	if (carrying + Weight(item) > max && !me.perm[SUPER_PERM])
	{
		prfmsg(M1023);
		BAD_EXIT;
	}

	for (i = 0; i != NUM_ITEMS; ++i)
	{
		if (me.item[i].what == 0)
		{
			memcpy(&me.item[i], item, (size_t) ITEMSIZE);

			if (me.item[i].what == MAGIC_DEV) 
			{
				me.item[i].room = 0;
			}

			if 
			(
				me.item[i].what == MAGIC_DEV && 
				me.item[i].which == MAGIC_RING
			)
			{
				me.item[i].ring_used = FALSE;
			}

			me.item[i].permanant = FALSE;

			return(TRUE);
		}
	}

	BAD_EXIT;
}
/****************************************************************************
	take an item out of user's inventory
*/
void EXPORT Lose_Item(short i)
{
	short   j;
	short   num_items;
	short   spell_cast = -1;
	MLONG   carrying;
	MLONG   max;

	if (i == me.lw)
	{
		me.lw = -1;
	}
	else if (i == me.rw)
	{
		me.rw = -1;
	}
	else if (i == me.armor)
	{
		me.armor = -1;
		
		if (me.item[i].ring_used)
		{
			spell_cast = me.item[i].spell_cast;
		}
	}
	else if (i == me.shld)
	{
		me.shld = -1;
		
		if (me.item[i].ring_used)
		{
			spell_cast = me.item[i].spell_cast; 
		}
	}
	else if (i == me.focus)
	{
		me.focus = -1;
	}

	Calc_Weight(&num_items, &carrying, &max);

	me.item[i].what = 0;

	if (i + 1 != NUM_ITEMS)
	{
		for (j = i + 1; j != NUM_ITEMS; ++j)
		{
			me.item[j - 1] = me.item[j];
		}
	}

	me.item[num_items - 1].what = 0;

	if (me.lw > i)
	{
		--me.lw;
	}
	if (me.rw > i)
	{
		--me.rw;
	}
	if (me.armor > i)
	{
		--me.armor;
	}
	if (me.shld > i)
	{
		--me.shld;
	}
	if (me.focus > i)
	{
		--me.focus;
	}

	if (spell_cast != -1)
	{
		Affect_Expired(spell_cast, P);
	}
}
/****************************************************************************
	calculate an item's value
*/
MLONG EXPORT Set_Value(struct item_struct *item)
{
	MLONG   value;

	if (item->uses == 0)
	{
		item->uses = 1;
	}

	if (WEAPON_P(item) || ARSH_P(item))
	{
		value = item->worth - (item->bonus * 200);
		value = (value * 100) / item->uses;
	}
	else if 
	(
		item->what == MAGIC_DEV ||
		item->what == CONTAINER ||
		item->what == AMULET ||
		item->what == PSY_FOCUS
	)
	{
		if (item->which == MAGIC_RING)
		{
			value = item->worth;
		}
		else
		{
			value = (item->worth * 100) / item->uses;
		}
	}
	else
	{
		value = item->worth;
	}

	if (value <= 0)
	{
		value = 1;
	}

	return (value);
}
/****************************************************************************
	calculate an item's value
*/
MLONG EXPORT Calc_Val(struct item_struct *item)
{
	float   used;
	MLONG   offered;
	MLONG   offer;
	float   uses;

	if (item->which == MAGIC_RING)
	{
		float   uses;

		uses = (60 * 5);
		uses += (item->item_level / 10) * globals->ringdur;
		used = (float) item->uses / uses;
	}
	else
	{
		uses = (float) item->uses;

		if (uses > 300)
		{
			uses = (float) 300;
		}

		used = (float) uses / (float) 100;
	}

	offered = (float) item->worth * used;

	if (WEAPON_P(item))
	{
		offer = (MLONG) offered + (item->bonus * 200);
	}
	else if (ARSH_P(item))
	{
		offer = (MLONG) offered + (item->bonus * 200);
	}
	else if 
	(
		item->what == MAGIC_DEV ||
		item->what == CONTAINER ||
		item->what == AMULET ||
		item->what == PSY_FOCUS
	)
	{
		offer = (MLONG) offered;
	}
	else
	{
		offer = item->worth;
	}

	if (offer <= 0)
	{
		offer = 1;
	}

	return (offer);
}
/****************************************************************************
	user wants to rob someone
*/
short EXPORT steal_item(void)
{
	short   g;
	short   m;
	short   i;
	short   revealed = FALSE;
	short   absolute_match = 0;

	if (word1[0] == 0 && MY_PORT->enemy_mon == -1)
	{
		prfmsg(MSG1027);
		BAD_EXIT;
	}

	if (me.armor >= 0)
	{
		if (me.item[me.armor].which != LITE_ARMOR)
		{
			prfmsg(MSG1028);
			BAD_EXIT;
		}
	}

	i = findguy_or_mon(word1, which1, OFFENSIVE, &absolute_match);
	GUY_OR_MON;

	if (m >= 0 && absolute_match != ABS_GUY)
	{
		revealed = rob_monster(m);
	}
	else if (g >= 0 && absolute_match != ABS_MON)
	{
		if (TYPE == ARENA)
		{
			prfmsg(MSG1299);
			BAD_EXIT;
		}

		revealed = rob_guy(g);
	}

	return (revealed);
}
/****************************************************************************
	user wants to rob a player
*/
short EXPORT rob_guy(short g)
{
	short   my_class_factor;
	short   his_class_factor;
	short   robevil;
	short   i;
	short   x;
	short   failed;
	short   his_factor;
	short   my_factor;
	short   revealed = FALSE;
	struct  item_struct item;

	if (!Can_Attack_Guy(g))
	{
		BAD_EXIT;
	}

	for (i = x = 0; i != NUM_ITEMS; ++i)
	{
		if (AGUY->item[i].what && AGUY->item[i].what != ARMOR)
		{
			++x;
		}
	}

	if (me.class == THIEF)
	{
		my_class_factor = 7;
	}
	else
	{
		my_class_factor = 5;
	}

	if (AGUY->class == THIEF)
	{
		his_class_factor = 7;
	}
	else
	{
		his_class_factor = 5;
	}

	his_factor = (AGUY->thief * his_class_factor) + 1;
	my_factor = (me.thief * my_class_factor) + 1;
	failed = AGUY->Int + RANDOM(his_factor) > me.Dex + RANDOM(my_factor);

	if (AGUY->perm[SUPER_PERM])
	{
		failed = TRUE;
	}
	else if (AGUY->class == THIEF && !globals->robthfs)
	{
		failed = TRUE;
	}

	if (me.perm[ROB_PERM])
	{
		failed = FALSE;
	}

	if (x == 0)
	{
		failed = TRUE;
	}
	
	if (failed)
	{
		++revealed;
		prfmsg(MSG1029);
		sprintf(str, getmsg(MSG1030), me.name);
		Message(str, g);
	}
	else
	{
		do
		{
			i = RANDOM(NUM_ITEMS) - 1;
		}
		while (AGUY->item[i].what == 0 || i == AGUY->armor);

		item = AGUY->item[i];
		x = Give_Me(&item);

		if (x)
		{
			++revealed;
			prfmsg(MSG1031);
			Display_Item(&item);
			prfmsg(MSG1032, AGUY->name);
			sprintf(str, getmsg(MSG1033), me.name);
			Cat_Item(str, &item);
			Message(str, g);

			if (prfbuf[0])
			{
				outprf(MY_PORT->usrnum);
				clrprf();
			}

			Next_User(g);
			Lose_Item(i);
			
			if (prfbuf[0])
			{
				outprf(MY_PORT->usrnum);
				clrprf();
			}

			Previous_User();

			robevil = numopt(ROBEVIL, -32767, 32767);
			if (robevil)
			{   
				prfmsg(M409, robevil);
				me.evil += robevil;
			}
		}
	}

	if (me.class != THIEF)
	{
		Set_Action_Time(5);
	}
	else
	{
		Set_Action_Time(3);
	}

	return (revealed);
}
/****************************************************************************
	user wants to rob a monster
*/
short EXPORT rob_monster(short m)
{
	short   asleep;
	short   class_factor;
	short   my_factor;
	short   his_factor;
	short   x;
	short   noticed;
	short   failed;
	short   sleep_time;
	short   item_num;
	short   num_items;
	MLONG   carrying, max;
	short   non_weps = 0;
	short   done = FALSE;
	short   stealable = FALSE;
	short   revealed = FALSE;
	short   fled;
	struct  item_struct an_item;

	Read_Critter(AMON->which, &crit);
	crit.last_kill = time(0);
	++crit.kills;
	Write_Critter(&crit);

	if (AMON->attacked_vector == MORPH)
	{
		if (Morphed(m, P))
		{
			Start_Mon_Name(name, m);
			prfmsg(MSG1305, name, AMON->Level);
		}
	}

	Set_Mon_Name(name, m);

	if (me.class == THIEF)
	{
		class_factor = 7;
	}
	else
	{
		class_factor = 5;
	}

	his_factor = AMON->Level * 5;
	my_factor = me.thief * class_factor;
	asleep = find_timer(SLEEP_TIME, MON);

	if (!AMON->sees[P])
	{
		noticed = AMON->Int + RANDOM(his_factor) > me.Dex + RANDOM(my_factor);
	}
	else
	{
		noticed = TRUE;
	}

	failed = AMON->Int + RANDOM(his_factor) > me.Dex + RANDOM(my_factor);

	if (me.thief <= 1 && AMON->Level <= 3 && RANDOM(3) == 1)
	{
		failed = FALSE;
	}

	if (AMON->permanant || (AMON->hit_vector == STEALER && !globals->robthfs))
	{
		noticed = failed = TRUE;
	}

	if (asleep)
	{
		noticed = FALSE;
	}

	if (me.perm[ROB_PERM])
	{
		failed = noticed = FALSE;
	}

	for (x = 0; x != MAX_MON_ITEM; ++x)
	{
		if (AMON->item_has[x].what)
		{
			if (AMON->item_has[x].what != ARMOR)
			{
				++stealable;

				if (!AMON->item_used[x])
				{
					++non_weps;
				}
			}
		}
	}

	if (stealable == 0)
	{
		failed = noticed = TRUE;
	}
	else
	{
		do
		{
			item_num = RANDOM(MAX_MON_ITEM) - 1;
			
			if (AMON->item_has[item_num].what)
			{
				if
				(
					AMON->item_has[item_num].what != ARMOR ||
					!AMON->item_used[item_num]
				)
				{
					done = TRUE;

					if (non_weps && AMON->item_used[item_num])
					{
						done = FALSE;
					}
				}
			}
		}
		while (!done);

		if (AMON->item_used[item_num])
		{
			noticed = TRUE;
		}
	}

	if (RANDOM(2) == 1)
	{
		fled = FALSE;
	}
	else
	{
		fled = Monster_Fled(m, TRUE);
	}

	if (fled)
	{
		return (TRUE);
	}

	if (failed)
	{
		for (sleep_time = 0; sleep_time != NUM_MON_TIMERS; ++sleep_time)
		{
			if (AMON->misc_type[sleep_time] == SLEEP_TIME)
			{
				AMON->timer[sleep_time] = 1;
			}
		}

		if (!noticed)
		{
			prfmsg(MSG1035, name);
		}
		else
		{
			++revealed;

			if (stealable)
			{
				prfmsg(MSG1035);
			}
			else
			{
				name[0] = toupper(name[0]);
				prfmsg(MSG1296, name);
				name[0] = tolower(name[0]);
			}

			sprintf(str, getmsg(MSG1036), me.name, name);
			Message(str, QUIET_LOCAL);
			AMON->pursue_forever = TRUE;
			AMON->last_attacker = P;
			AMON->sees[P] = TRUE;
		}
	}
	else
	{
		an_item = AMON->item_has[item_num];

		if (an_item.finder < 0)
		{
			an_item.finder = MY_PORT->index;
		}

		x = 0;

		if (an_item.what == CASH)
		{
			Calc_Weight(&num_items, &carrying, &max);

			if 
			(
				(carrying + an_item.worth > max && !me.perm[SUPER_PERM]) ||
				((double) an_item.worth + (double) me.gold > GCMAXLONG)
			)
			{
				prfmsg(MSSG955);
			}
			else
			{
				me.gold += an_item.worth;
				x = 1;
			}
		}
		else if (an_item.what == MAGIC_DEV && an_item.which == SCROLL)
		{
			x = Find_Scroll(&an_item);
			if (!x)
			{
				x = Give_Me(&an_item);
			}
		}
		else
		{
			x = Give_Me(&an_item);
		}

		if (x)
		{
			++MY_PORT->thefts;
			AMON->item_has[item_num].what = 0;
			AMON->item_used[item_num] = 0;

			prfmsg(MSG1031);
			Display_Item(&an_item);

			if (an_item.what == CASH)
			{
				sprintf(str, getmsg(MSG1039), an_item.worth);
				prf(str);
			}

			if (noticed)
			{
				++revealed;
				prfmsg(MSG1032, name);
				sprintf(str, getmsg(MSG1040), me.name, name);
				Message(str, QUIET_LOCAL);
				Thief_Robbing_Experience(AMON->Level);
				AMON->pursue_forever = TRUE;
				AMON->last_attacker = P;
				AMON->sees[P] = TRUE;
			}
			else
			{
				prfmsg(MSG1041, name);
				Thief_Robbing_Experience(AMON->Level);
			}
		}
	}

	if (!fled)
	{
		MY_PORT->enemy_mon = m;
	}

	if (me.class != THIEF)
	{
		Set_Action_Time(5);
	}
	else
	{
		Set_Action_Time(3);
	}

	return (revealed);
}
/****************************************************************************
	user wants to give something to another player
*/
short EXPORT give_item(void)
{           
	short   g;
	short   invis_t;
	short   item;
	MLONG   cash;
	short   see_invis_t;
	short   which = 1;
	short   revealed = 0;
	short   absolute_match = 0;
	char    who[LINE_LEN];
	char    word[LINE_LEN];
	char    what[LINE_LEN];

	who[0] = 0;
	what[0] = 0;
	word[0] = 0;

	if (margc > 1)
	{
		strcpy(who, margv[1]);
	}

	if (margc > 2)
	{
		strcpy(what, margv[2]);
	}

	if (margc > 3)
	{
		strcpy(word, margv[3]);
	}

	if (who[0] == 0)
	{
		prfmsg(MSG1065);
		BAD_EXIT;
	}
	else if (what[0] == 0)
	{
		prfmsg(MSG1066);
		BAD_EXIT;
	}

	g = find_guy(who, 1, &absolute_match);

	if (g < 0)
	{
		BAD_EXIT;
	}
	else if (g == P)
	{
		prfmsg(MSG1067);
		BAD_EXIT;
	}

	invis_t = find_timer(INVISIBLE_TIME, g, -1);
	see_invis_t = find_timer(SEE_INVIS_TIME, ME);

	if (invis_t && !see_invis_t)
	{
		prfmsg(M543, who);
		BAD_EXIT;
	}

	if (sameas(word, "gold"))
	{
		cash = LNUM(what);

		if (cash > me.gold && !me.perm[SUPER_PERM])
		{
			prfmsg(MSG1068);
			BAD_EXIT;
		}

		if (cash_offered(g, cash))
		{
			++revealed;
		}
	}
	else
	{
		if (word[0])
		{
			which = INUM(word);
		}

		if (which == 0)
		{
			which = 1;
		}

		item = find_item(what, which, 1, &absolute_match);

		if (item >= 0)
		{
			if (item_offered(g, item))
			{
				++revealed;
			}
		}
	}

	return (revealed);
}
/*******************************************************************************
	user has been offered an item, see if he can carry it
*/
short EXPORT item_offered(short g, short what)
{ 
	short   i;
	short   x = 1;
	short   num_items;
	MLONG   carrying;
	MLONG   max;
	struct  item_struct an_item;

	an_item = me.item[what];
	sprintf(str, getmsg(MSG1069), me.name);
	Cat_Item(str, &an_item);
	Message(str, g);

	prfmsg(MSG1070);
	Display_Item(&an_item);
	prfmsg(MSG1071, AGUY->name);

	Next_User(g);
	Calc_Weight(&num_items, &carrying, &max);

	if (num_items == NUM_ITEMS)
	{
		x = 0;
	}
	else if (carrying + Weight(&an_item) > max && !me.perm[SUPER_PERM])
	{
		x = 0;
	}
	else
	{
		for (i = 0; i < NUM_ITEMS; ++i)
		{
			if (me.item[i].what == 0)
			{
				me.item[i] = an_item;

				if 
				(
					me.item[i].what == MAGIC_DEV && 
					me.item[i].which == MAGIC_RING
				)
				{
					me.item[i].ring_used = FALSE;
				}

				i = NUM_ITEMS;
			}
		}
	}

	Previous_User();

	if (x)
	{
		prfmsg(MSG956, AGUY->name);
		sprintf
		(
			str, 
			getmsg(MSG1073), 
			me.name, 
			AGUY->name
		);
		Cat_Item(str, &an_item);
		Message(str, -(g + 1));
		Lose_Item(what);
	}
	else
	{
		prfmsg(MSG954, AGUY->name);
		strcpy(str, getmsg(MSSG955));
		Message(str, g);
	}

	DONE;
}
/****************************************************************************
	user wants to stop using something
*/
void EXPORT Return_Item(short index)
{
	short   do_expire = FALSE;

	if (index == me.lw)
	{
		me.lw = -1;
	}
	else if (index == me.rw)
	{
		me.rw = -1;
	}
	else if (index == me.armor)
	{
		me.armor = -1;
		do_expire = TRUE;
	}
	else if (index == me.shld)
	{
		me.shld = -1;
		do_expire = TRUE;
	}
	else if (index == me.focus)
	{
		me.focus = -1;
	}

	prfmsg(MSG1085);
	Display_Item(&me.item[index]);
	prf(NL);
	sprintf(str, getmsg(MSG1086), me.name);
	Cat_Item(str, &me.item[index]);
	Message(str, QUIET_LOCAL);

	if (do_expire)
	{
		if (me.item[index].ring_used)
		{
			Affect_Expired(me.item[index].spell_cast, P);
		}
	}
}
/****************************************************************************
	change the adjective on an item
*/
short EXPORT Label_Item(short option)
{
	short   absolute_match = 0;
	char    label[LINE_LEN];

	if (option == 0)
	{
		if (word1[0] == 0)
		{
			prfmsg(MSG1087);
			BAD_EXIT;
		}

		MY_PORT->misc = find_item(word1, which1, 1, &absolute_match);

		if (MY_PORT->misc >= 0)
		{
			Set_Prompt(getmsg(MSG1088), LABEL_PROMPT);
		}
	}
	else
	{
		strncpy(label, margv[0], LABEL_SIZE);
		label[LABEL_SIZE - 1] = 0;
		strcpy(me.item[MY_PORT->misc].adjective, label);
		prfmsg(MSG1089);
		Display_Item(&me.item[MY_PORT->misc]);
		me.item[MY_PORT->misc].labeled = TRUE;
		prf(NL);
	}

	DONE;
}
/****************************************************************************
	see if I am restricted from using an item
*/
short EXPORT Restricted_Item(struct item_struct *item)
{
	short   itmlevl1 = numopt(ITMLEVL1, -32767, 32767);
	short   itmlevl2 = numopt(ITMLEVL2, -32767, 32767);
	short   calc;

	if 
	(
		(item->class != 0 && item->class != ' ' && me.class != item->class) ||
		(item->race != 0 && item->race != ' ' && me.race != item->race)
	)
	{
		if (!me.perm[SUPER_PERM])
		{
			prfmsg(M281B);
			Display_Item(item);
			prf(NL);
			return (TRUE);
		}
	}

	if (item->org_item_level == 0)
	{
		item->org_item_level = item->item_level;
	}

	calc = ((Approximate_Level(P) * 2) + itmlevl1) * itmlevl2;

	if 
	(
		item->finder != MY_PORT->index &&
		item->what != TALISMAN &&
		!me.perm[SUPER_PERM] && 
		calc < item->org_item_level
	)
	{
		prfmsg(M281A);
		Display_Item(item);
		prf(NL);
		return (TRUE);
	}

	DONE;
}
/****************************************************************************
	use an item
*/
short EXPORT Use_Item(void)
{
	short   index;
	short   revealed = 0;
	short   absolute_match  = 0;

	if (word1[0] == 0)
	{
		prfmsg(MSG1090);
		BAD_EXIT;
	}

	index = find_item(word1, which1, 1, &absolute_match);

	if (index < 0)
	{
		BAD_EXIT;
	}

	if (Restricted_Item(&me.item[index]))
	{
		BAD_EXIT;
	}

	item = me.item[index];

	if (item.what == TRINKET && item.which == PUZZLE)
	{
		Assemble_Puzzle(index);
		DONE;
	}
	
	if (item.what == MAGIC_DEV)
	{
		revealed = use_magic_device(index, word2, which2);
	}
	else if (item.what == TRANSPORTER)
	{
		if (ABUF(B)->rm.id == globals->prison)
		{
			prfmsg(M614);
			BAD_EXIT;
		}
		
		if (MY_PORT->action_timer && !me.perm[ACTION_PERM])
		{
			prfmsg(M544, MY_PORT->action_timer);
			rstrin();
			strncpy(MY_PORT->next_input, input, LINE_LEN - 1);
			MY_PORT->next_input[LINE_LEN - 1] = 0;
			return (FALSE);
		}
		
		No_Follow();

		if (item.room < 1 || item.room > globals->maxroom)
		{
			item.room = 1;
		}

		teleport_to(item.room);
		prfmsg(MSG1091, item.name);
		Lose_Item(index);
	}
	else if (item.what == TALISMAN)
	{
		if (me.class == WARRIOR || me.class == DUELIST || ynopt(ALLRPAIR))
		{
			revealed = use_magic_device(index, word2, which2);
		}
		else
		{
			prfmsg(MSG1092);
			BAD_EXIT;
		}
	}
	else if (item.what == ARMOR)
	{
		revealed = Wear_It(index);
	}
	else if (item.what == SHIELD)
	{
		revealed = Hold_It(index);
	}
	else if (WEAPON(item))
	{
		revealed = Wield(index);
	}
	else if (item.what == PSY_FOCUS)
	{
		revealed = Focus_It(index);
	}
	else
	{
		prfmsg(MSG1093);
		BAD_EXIT;
	}

	return (revealed);
}
/****************************************************************************
	user wants to use a magic device
*/
short EXPORT use_magic_device(short index, char *target, short target_num)
{
	short   revealed;

	if (MY_PORT->action_timer && !me.perm[ACTION_PERM])
	{
		prfmsg(M544, MY_PORT->action_timer);
		rstrin();
		strncpy(MY_PORT->next_input, input, LINE_LEN - 1);
		MY_PORT->next_input[LINE_LEN - 1] = 0;
		return (FALSE);
	}

	item = me.item[index];
	
	if (item.what == TALISMAN)
	{
		revealed = Make_Magic(REPAIR, target, target_num, index);

		if (revealed && !me.item[index].infinite_uses)
		{
			me.item[index].uses = 0; 
		}
	}
	else if (item.uses <= 0)
	{
		prfmsg(MSG1094);
		BAD_EXIT;
	}
	else if (item.which == MAGIC_RING)
	{
		Ring_Magic(index);
		BAD_EXIT;
	}
	else
	{
		revealed = Make_Magic(item.spell_cast, target, target_num, index);
	}

	if (revealed)
	{
		if (!me.item[index].infinite_uses)
		{
			--me.item[index].uses;
		}

		if (item.spell_cast == ELICITATION)
		{
			revealed = FALSE;
		}
	}
	else if 
	(
		item.spell_cast == MAGIC_CIRCLE ||
		item.spell_cast == PASS_DOOR
	)
	{
		if (!me.item[index].infinite_uses)
		{
			--me.item[index].uses;
		}
	}

	item = me.item[index];
				
	if (item.which == SPECIAL_KEY && revealed && !item.infinite_uses)
	{
		prfmsg(MSG1095, item.name);
		Lose_Item(index);
	}
	else if (item.uses <= 0)
	{
		switch (item.which)
		{
			case SKELETON_KEY:
				prfmsg(MSG1095, item.name);
				Lose_Item(index);
				break;

			default:
				prfmsg(MSG1091, item.name);
				Lose_Item(index);
				break;
		}
	}

	if (me.focus >= 0 && me.item[me.focus].uses <= 0)
	{
		Lose_Item(me.focus);
	}

	return (revealed);
}
/****************************************************************************
	user wants to use a shield
*/
short EXPORT Hold_It(short item)
{
	short   done = FALSE;
	short   strength = me.Str;

	if (MY_PORT->action_timer && !me.perm[ACTION_PERM])
	{
		prfmsg(M544, MY_PORT->action_timer);
		rstrin();
		strncpy(MY_PORT->next_input, input, LINE_LEN - 1);
		MY_PORT->next_input[LINE_LEN - 1] = 0;
		return (FALSE);
	}

	if (find_timer(STRONG_TIME, ME))
	{
		strength = strength * 2;
	}

	if (me.shld >= 0)
	{
		if (me.shld == item)
		{
			done = TRUE;
		}

		Return_Item(me.shld);
	}

	if (done)
	{
		return (TRUE);
	}
	
	if (me.lw >= 0 && me.rw >= 0)
	{
		prfmsg(MSG1098);
		BAD_EXIT;
	}
	else if ((me.lw >= 0 || me.rw >= 0) && me.focus >= 0)
	{
		prfmsg(MSG1098);
		BAD_EXIT;
	}

	if
	(
		me.lw >= 0 && me.item[me.lw].which == TWOHAND ||
		me.rw >= 0 && me.item[me.rw].which == TWOHAND
	)
	{
		if (strength < globals->twohndst)
		{
			prfmsg(MSG1099);
			BAD_EXIT;
		}
	}

	me.shld = item;

	prfmsg(MSG1100);
	Display_Item(&me.item[item]);
	prf(NL);

	sprintf(str, getmsg(MSG1101), me.name);
	Cat_Item(str, &me.item[item]);
	Message(str, QUIET_LOCAL);

	if (me.item[item].ring_used)
	{
		Permanant_Affect(me.item[item].spell_cast);
	}

	return (TRUE);
}
/****************************************************************************
	user wants to use a focus
*/
short EXPORT Focus_It(short item)
{
	short   done = FALSE;
	short   strength = me.Str;

	if (MY_PORT->action_timer && !me.perm[ACTION_PERM])
	{
		prfmsg(M544, MY_PORT->action_timer);
		rstrin();
		strncpy(MY_PORT->next_input, input, LINE_LEN - 1);
		MY_PORT->next_input[LINE_LEN - 1] = 0;
		return (FALSE);
	}

	if (find_timer(STRONG_TIME, ME))
	{
		strength = strength * 2;
	}

	if (me.focus >= 0)
	{
		if (me.focus == item)
		{
			done = TRUE;
		}

		Return_Item(me.focus);
	}

	if (done)
	{
		return (TRUE);
	}

	if (me.lw >= 0 && me.rw >= 0)
	{
		prfmsg(MSG1098);
		BAD_EXIT;
	}

	if ((me.lw >= 0 || me.rw >= 0) && me.shld >= 0)
	{
		prfmsg(MSG1098);
		BAD_EXIT;
	}

	if
	(
		me.lw >= 0 && me.item[me.lw].which == TWOHAND ||
		me.rw >= 0 && me.item[me.rw].which == TWOHAND
	)
	{
		if (strength < globals->twohndst)
		{
			prfmsg(MSG1099);
			BAD_EXIT;
		}
	}

	me.focus = item;

	prfmsg(MSG1109);
	Display_Item(&me.item[item]);
	prf(NL);

	sprintf(str, getmsg(MSG1110), me.name);
	Cat_Item(str, &me.item[item]);
	Message(str, QUIET_LOCAL);
	return (TRUE);
}
/****************************************************************************
	user wants to put on some armor
*/
short EXPORT Wear_It(short item)
{
	short   done = FALSE;

	if (MY_PORT->action_timer && !me.perm[ACTION_PERM])
	{
		prfmsg(M544, MY_PORT->action_timer);
		rstrin();
		strncpy(MY_PORT->next_input, input, LINE_LEN - 1);
		MY_PORT->next_input[LINE_LEN - 1] = 0;
		return (FALSE);
	}

	if (me.armor >= 0)
	{
		if (item == me.armor)
		{
			done = TRUE;
		}

		Return_Item(me.armor);
	}

	if (done)
	{
		return (TRUE);
	}

	me.armor = item;
	prfmsg(MSG1103);
	Display_Item(&me.item[item]);
	prf(NL);
	sprintf(str, getmsg(MSG1104), me.name);
	Cat_Item(str, &me.item[item]);
	Message(str, QUIET_LOCAL);

	if (me.item[item].ring_used)
	{
		Permanant_Affect(me.item[item].spell_cast);
	}

	return (TRUE);
}
/****************************************************************************
	user wants to use a weapon
*/
short EXPORT Wield(short item)
{
	short   strength = me.Str;

	if (MY_PORT->action_timer && !me.perm[ACTION_PERM])
	{
		prfmsg(M544, MY_PORT->action_timer);
		rstrin();
		strncpy(MY_PORT->next_input, input, LINE_LEN - 1);
		MY_PORT->next_input[LINE_LEN - 1] = 0;
		return (FALSE);
	}

	if (find_timer(STRONG_TIME, ME))
	{
		strength = strength * 2;
	}

	if (me.rw == item)
	{
		Return_Item(me.rw);
		return (TRUE);
	}

	if (me.lw == item)
	{
		Return_Item(me.lw);
		return (TRUE);
	}

	if (me.rw >= 0 && me.lw >= 0)
	{
		prfmsg(MSG1106);
		BAD_EXIT;
	}

	if ((me.lw >= 0 || me.rw >= 0) && me.shld >= 0)
	{
		prfmsg(MSG1107);
		BAD_EXIT;
	}

	if ((me.lw >= 0 || me.rw >= 0) && me.focus >= 0)
	{
		prfmsg(MSG1107);
		BAD_EXIT;
	}

	if (me.lw >= 0 || me.rw >= 0 || me.shld >= 0 || me.focus >= 0)
	{
		if (me.item[item].which == TWOHAND)
		{
			if (strength < globals->twohndst)
			{
				prfmsg(MSG1108);
				BAD_EXIT;
			}
		}
	}

	if
	(
		(me.rw >= 0 && me.item[me.rw].which == TWOHAND) ||
		(me.lw >= 0 && me.item[me.lw].which == TWOHAND)
	)
	{
		if (strength < globals->twohndst)
		{
			prfmsg(MSG1108);
			BAD_EXIT;
		}
	}

	if (me.rw < 0)
	{
		me.rw = item;
	}
	else
	{
		me.lw = item;
	}

	prfmsg(MSG1109);
	Display_Item(&me.item[item]);
	prf(NL);

	sprintf(str, getmsg(MSG1110), me.name);
	Cat_Item(str, &me.item[item]);
	Message(str, QUIET_LOCAL);

	return (TRUE);
}
/****************************************************************************
	find an item on the ground
*/
short EXPORT find_ground_item(char *what, short which)
{
	short   i;
	short   count;
	short   index = -1;
	short   unique = 1;
	short   done = FALSE;
	char    *word;
	char    match[LINE_LEN];

	for (i = count = 0; i != NUM_ITEMS; ++i)
	{
		if (ABUF(B)->item[i].what)
		{
			++count;
		}
	}

	i = atoi(what);

	if (i > 0 && i <= count)
	{
		if (Blocked())
		{
			return (-1);
		}
		else
		{
			return (i - 1);
		}
	}
	else if (i > count)
	{
		prfmsg(MSG1111);
		return(index);
	}

	if (which == 0)
	{
		which = 1;
	}

	match[0] = 0;

	for (i = count = 0; i != NUM_ITEMS && !done; ++i)
	{
		if (ABUF(B)->item[i].what)
		{
			strcpy(name, ABUF(B)->item[i].name);
			word = strtok(name, " ");

			if (sameto(what, word))
			{
				if (match[0] == 0)
				{
					strcpy(match, word);
				}
				else
				{
					if (!sameas(word, match))
					{
						unique = 0;
					}
				}

				++count;

				if (count <= which)
				{
					index = i;
				}

				if (strlen(word) == strlen(what) && which == 1)
				{
					count = unique = done = 1;
				}
			}
		}
	}

	if (count == 0)
	{
		prfmsg(M542, what);
	}
	else if (!unique)
	{
		index = -1;
		prfmsg(M167, what);
	}
	else if (count < which)
	{
		prfmsg(MSG1112);
		index = -1;
	}
	else if (Blocked())
	{
		index = -1;
	}

	return(index);
}
/****************************************************************************
	drop an item
*/
short EXPORT drop_item(void)
{
	short   m;
	short   huntress_here;
	short   huntress_took = FALSE;
	short   dropped = TRUE;
	short   index;
	short   bag_index;
	short   revealed;
	short   absolute_match = 0;

	if (word1[0] == 0)
	{
		prfmsg(MSG1119);
		BAD_EXIT;
	}

	index = find_item(word1, which1, 1, &absolute_match);

	if (index < 0)
	{
		BAD_EXIT;
	}

	if (word2[0])
	{
		bag_index = find_item(word2, which2, 1, &absolute_match);

		if (bag_index < 0)
		{
			BAD_EXIT;
		}

		if (me.item[bag_index].what != CONTAINER)
		{
			prfmsg(MSG1120);
			Display_Item(&me.item[bag_index]);
			prf("!\r");
			BAD_EXIT;
		}
		else if (index == bag_index || me.item[index].what == CONTAINER)
		{
			prfmsg(MSG1121);
			BAD_EXIT;
		}
	}
	else
	{
		bag_index = -1;
	}

	revealed = TRUE;

	if (bag_index >= 0)
	{
		Put_In_Bag(index, bag_index);
	}
	else
	{
		for (m = huntress_here = 0; m != MAX_ROOM_MON; ++m)
		{
			if 
			(
				AMON->what == HUNTRESS && 
				sameas(AMON->name, MY_PORT->quest_mon)
			)
			{
				huntress_here = TRUE;
			}
		}

		if
		(
			MY_PORT->questing &&
			MY_PORT->quest_type == ITEM_QUEST &&
			huntress_here &&
			!me.item[index].labeled
		)
		{
			str[0] = 0;
			Cat_Item(str, &me.item[index]);

			if (sameas(str, MY_PORT->quest_thing))
			{
				huntress_took = TRUE;
				--MY_PORT->quests_left;
				Lose_Item(index);
				prfmsg(MSG677, me.name);
				New_Huntress_Quest();
			}
			else
			{
				dropped = Dump_In_Room(&me.item[index]);
			}
		}
		else
		{
			dropped = Dump_In_Room(&me.item[index]);
		}

		if (!huntress_took && dropped)
		{
			prfmsg(MSG1125);
			Display_Item(&me.item[index]);
			prf(NL);

			sprintf(str, getmsg(MSG1126), me.name);
			Cat_Item(str, &me.item[index]);
			Message(str, LOUD_LOCAL);
			Lose_Item(index);
		}

		Write_My_Rec(EXISTS);
	}

	return (revealed);
}
/****************************************************************************
	assemble a puzzle
*/
short EXPORT Assemble_Puzzle(short index)
{
	short   i;
	short   j;
	short   found;
	short   count;
	short   done;
	short   item_num;
	short   pieces[NUM_ITEMS];
	struct  item_struct *item;

	for (i = count = 0; i != NUM_ITEMS; ++i)
	{
		if (me.item[i].what == TRINKET && me.item[i].which == PUZZLE)
		{
			if (me.item[i].holding == me.item[index].holding)
			{
				for (j = found = 0; j != count; ++j)
				{
					if (pieces[j] == me.item[i].id)
					{
						found = TRUE;
					}
				}

				if (!found)
				{
					pieces[count] = me.item[i].id;
					++count;
				}
			}
		}
	}

	if (count < me.item[index].ac)
	{
		prfmsg(MSG1076, me.item[index].ac - count);
		BAD_EXIT;
	}

	item_num = me.item[index].bonus;

	for (i = 0; i != count; ++i)
	{
		for (j = done = 0; j != NUM_ITEMS && !done; ++j)
		{
			if (me.item[j].id == pieces[i])
			{
				prfmsg(MSG1077, me.item[j].name);
				Lose_Item(j);
				done = TRUE;
			}
		}
	}

	item = Create_Item(item_num, NULL, 100, 1, FALSE);
	i = Give_Me(item);
	
	if (i)
	{
		prfmsg(MSG1078);
		Display_Item(item);
		prf("!\r");
	}

	DONE;
}
/****************************************************************************
	get an item
*/
short EXPORT get_item(void)
{
	short   i;
	short   revealed = 0;
	short   index;
	short   bag_index;
	short   num_items;
	MLONG   carrying;
	MLONG   max;
	short   absolute_match = 0;

	if (word1[0] == 0)
	{
		prfmsg(MSG1127);
		BAD_EXIT;
	}

	if (word2[0])
	{
		bag_index = find_item(word2, which2, 1, &absolute_match);

		if (bag_index < 0)
		{
			BAD_EXIT;
		}

		if (me.item[bag_index].what != CONTAINER)
		{
			prfmsg(MSG1128);
			Display_Item(&me.item[bag_index]);
			prf(NL);
			BAD_EXIT;
		}

		revealed = Get_From_Bag(bag_index);
		return(revealed);
	}

	i = find_timer(FLOAT_TIME, ME);

	if (i)
	{
		prfmsg(MSG884);
		BAD_EXIT;
	}

	index = find_ground_item(word1, which1);

	if (index < 0)
	{
		BAD_EXIT;
	}

	Calc_Weight(&num_items, &carrying, &max);

	if (ABUF(B)->item[index].what == CASH)
	{
		if 
		(
			(carrying + ABUF(B)->item[index].worth > max && !me.perm[SUPER_PERM]) ||
			((double) ABUF(B)->item[index].worth + (double) me.gold > GCMAXLONG)
		)
		{
			prfmsg(MSG1037);
		}
		else
		{
			++revealed;
			me.gold += ABUF(B)->item[index].worth;
			MY_PORT->cash += ABUF(B)->item[index].worth;
		}
	}
	else if (Give_Me(&ABUF(B)->item[index]))
	{
		++revealed;
	}

	if (revealed)
	{
		prfmsg(MSG1129);
		Display_Item(&ABUF(B)->item[index]);

		if (ABUF(B)->item[index].what == CASH)
		{
			sprintf(str, getmsg(MSG1039), ABUF(B)->item[index].worth);
			prf(str);
		}           

		prf(NL);

		sprintf(str, getmsg(MSG1130), me.name);
		Cat_Item(str, &ABUF(B)->item[index]);
		Message(str, LOUD_LOCAL);

		Lose_Ground_Item(index);
	}

	return (revealed);
}
/****************************************************************************
	toss an item
*/
short EXPORT toss_item(void)
{
	short   index;
	short   bag_index;
	short   revealed;
	short   absolute_match = 0;

	if (word1[0] == 0)
	{
		prfmsg(MSG1131);
		BAD_EXIT;
	}

	if (word2[0])
	{
		bag_index = find_item(word2, which2, 1, &absolute_match);

		if (bag_index < 0)
		{
			BAD_EXIT;
		}

		if (me.item[bag_index].what != CONTAINER)
		{
			prfmsg(MSG1132);
			Display_Item(&me.item[bag_index]);
			prf(NL);
			BAD_EXIT;
		}

		revealed = Toss_From_Bag(bag_index);
		return(revealed);
	}

	index = find_ground_item(word1, which1);
	if (index < 0)
	{
		BAD_EXIT;
	}

	prfmsg(MSG1133);
	Display_Item(&ABUF(B)->item[index]);
	item = ABUF(B)->item[index];

	if (ABUF(B)->item[index].what == CASH)
	{
		sprintf(str, getmsg(MSG1039), ABUF(B)->item[index].worth);
		prf(str);
	}
	prf(NL);

	sprintf(str, getmsg(MSG1134), me.name);
	Cat_Item(str, &ABUF(B)->item[index]);
	Message(str, LOUD_LOCAL);

	if (item.what == CONTAINER)
	{
		Kill_Container(&item);
	}

	Lose_Ground_Item(index);
	return (TRUE);
}
/****************************************************************************
	look at the specified item
*/
void EXPORT Look_At_Item(short i)
{
	short   elicited = FALSE;    
	long    offer;
	
	if 
	(
		me.perm[SUPER_PERM] || 
		command == CAST || 
		command == USE ||
		Find_Ring(ELICITATION, ME)
	)
	{
		elicited = TRUE;
	}

	prfmsg(MSG1135);
	Display_Item(&me.item[i]);
	prfmsg(MSG1136);

	if (me.item[i].which == TWOHAND)
	{
		prfmsg(MSG1137);
	}

	switch (me.item[i].what)
	{
		case EDGED:
			prfmsg(MSG1138, me.item[i].Hits, me.item[i].bonus);
			break;

		case BLUNT:
			prfmsg(MSG1139, me.item[i].Hits, me.item[i].bonus);
			break;

		case NOHAND:
			prfmsg(MSG1140, me.item[i].Hits, me.item[i].bonus);
			break;

		case POLE:
			prfmsg(MSSG1141, me.item[i].Hits, me.item[i].bonus);
			break;

		case TRANSPORTER:
			prfmsg(MSG1142);
			break;

		case MAGIC_DEV:
			if (me.item[i].which == MAGIC_RING)
			{
				prfmsg(MSG1143);
			}
			else
			{
				prfmsg(MSG1144);
			}

			prfmsg(MSG1145, spell_info[me.item[i].spell_cast].name);
			break;

		case CONTAINER:
			prfmsg(MSG1146);
			break;

		case TRINKET:
			if (me.item[i].which != PUZZLE)
			{
				prfmsg(MSG1147);
			}
			else
			{
				prfmsg(MSG1148);
			}

			break;

		case JOOLS:
			prfmsg(MSG1149);
			break;

		case TALISMAN:
			if 
			(
				me.class == WARRIOR || 
				me.class == DUELIST || 
				ynopt(ALLRPAIR)
			)
			{
				prfmsg(MSG1151);
				prfmsg(MSG1152, me.item[i].item_level);
			}
			else
			{
				prfmsg(MSG1150);
			}
			break;

		case ARMOR:
		case SHIELD:
			prfmsg(MSG1153);
			break;

		case AMULET:
			prfmsg(MSG1311);
			break;

		case PSY_FOCUS:
			prfmsg(MSG1337);
			break;
	}

	if (WEAPON(me.item[i]) || ARSH(me.item[i]))
	{
		if (me.item[i].ring_used)
		{
			prfmsg(MSG1154, spell_info[me.item[i].spell_cast].name);
		}
	}

	offer = Calc_Val(&me.item[i]);

	if (offer <= 0)
	{
		offer = 1;
	}

	if (me.item[i].what == CONTAINER && me.item[i].holding)
	{
		offer = Bag_Value(&me.item[i]);
	}

	sprintf(str, getmsg(M1155), Weight(&me.item[i]), offer);
	prf(str);

	if (elicited)
	{
		if (me.item[i].what == MAGIC_DEV)
		{
			if (me.item[i].which == MAGIC_RING)
			{
				prfmsg(MSG586, me.item[i].uses);
			}
			else
			{
				prfmsg(MSG587, me.item[i].uses);
			}
		}
		else
		{
			prfmsg(MSG587, me.item[i].uses);
		}
		
		if 
		(
			me.item[i].what != JOOLS &&
			me.item[i].what != TRINKET &&
			me.item[i].what != CONTAINER &&
			me.item[i].what != TRANSPORTER
		)
		{
			prfmsg(MSG1308, me.item[i].item_level);
		}
	}

	if (me.item[i].what == CONTAINER)
	{
		Print_Bag_Contents(0, i);
	}

	if (me.item[i].text_file)
	{
		Print_Text_File("I", me.item[i].id);
	}
}
/****************************************************************************
	print an item name
*/
void EXPORT Display_Item(struct item_struct *item)
{
	short   what;

	strncpy(globals->txt, item->name, 80);
	globals->txt[80] = 0;
	globals->txt[0] = toupper(globals->txt[0]);
	what = item->what;
	
	if (item->article[0])
	{
		prf("%s ", item->article);
	}

	if (item->adjective[0])
	{
		prf("%s ", item->adjective);
	}

	prf("%s", globals->txt);

	if (what == EDGED || what == BLUNT || what == POLE || what == NOHAND)
	{
		prf(" (%d +%d)", item->Hits, item->bonus);
	}
	else if (what == SHIELD || what == ARMOR)
	{
		prf(" (%d +%d)", item->ac, item->bonus);
	}
}
/****************************************************************************
	print an item name using colors
*/
void EXPORT Color_Display_Item(struct item_struct *item)
{
	short   what;

	strncpy(globals->txt, item->name, 80);
	globals->txt[80] = 0;
	globals->txt[0] = toupper(globals->txt[0]);
	what = item->what;
	
	if (what == EDGED || what == BLUNT || what == POLE || what == NOHAND)
	{
		if (item->article[0])
		{
			prfmsg(MSG1156, item->article);
			prf(" ");
		}

		if (item->adjective[0])
		{
			prfmsg(MSG1156, item->adjective);
			prf(" ");
		}

		prfmsg(MSG1156, globals->txt);
	}
	else if (what == SHIELD || what == ARMOR)
	{
		if (item->article[0])
		{
			prfmsg(MSG1157, item->article);
			prf(" ");
		}

		if (item->adjective[0])
		{
			prfmsg(MSG1157, item->adjective);
			prf(" ");
		}

		prfmsg(MSG1157, globals->txt);
	}
	else if 
	(
		what == MAGIC_DEV || 
		what == TRANSPORTER || 
		what == AMULET ||
		what == PSY_FOCUS
	)
	{
		if (item->article[0])
		{
			prfmsg(MSG1158, item->article);
			prf(" ");
		}

		if (item->adjective[0])
		{
			prfmsg(MSG1158, item->adjective);
			prf(" ");
		}

		prfmsg(MSG1158, globals->txt);
	}
	else if (what == JOOLS || what == TRINKET || what == CASH)
	{
		if (item->article[0])
		{
			prfmsg(MSG1159, item->article);
			prf(" ");
		}

		if (item->adjective[0])
		{
			prfmsg(MSG1159, item->adjective);
			prf(" ");
		}

		prfmsg(MSG1159, globals->txt);
	}
	else if (what == CONTAINER)
	{
		if (item->article[0])
		{
			prfmsg(MSG1160, item->article);
			prf(" ");
		}

		if (item->adjective[0])
		{
			prfmsg(MSG1160, item->adjective);
			prf(" ");
		}

		prfmsg(MSG1160, globals->txt);
	}
	else if (what == TALISMAN)
	{
		if (item->article[0])
		{
			prfmsg(MSG1161, item->article);
			prf(" ");
		}

		if (item->adjective[0])
		{
			prfmsg(MSG1161, item->adjective);
			prf(" ");
		}

		prfmsg(MSG1161, globals->txt);
	}

	if (what == EDGED || what == BLUNT || what == POLE || what == NOHAND)
	{
		prfmsg(MSG1163, item->Hits, item->bonus);
	}
	else if (what == SHIELD || what == ARMOR)
	{
		prfmsg(MSG1163, item->ac, item->bonus);
	}
}

