#include <header.h>
#include <globals.h>

/***************************************************************************
	send the output buffer to the specified user
*/
void EXPORT Send_Buf(short usr)
{
	
	if (usrnum != usr || P == -1)
	{
		btuoes(usr, 1);
	}

	outprf(usr);
	clrprf();
}
/*****************************************************************************
	send a message to the specified other ports
*/
void EXPORT Message(char *msg, short send_to)
{
	short   in_guild;
	short   i;
	short   ti;
	short   tsi;
	short   ign;

	if (send_to == P && P >= 0)
	{
		prf(msg);
		prf(NL);
		outprf(MY_PORT->usrnum);
		clrprf();
	}
	else if (send_to == GLOBAL)
	{
		for (i = 0; i != NTERMS; ++i)
		{
			ign = APORT(i)->chr.Option[IGNORE_GLOBAL];

			if (APORT(i)->status && i != P && !ign)
			{
				if (P < 0 || (!APORT(i)->ignore[P] && !MY_PORT->ignore[i]))
				{
					send(i, msg);
				}
			}
		}
	}
	else if (send_to == GUILD_GLOBAL)
	{
		sprintf(globals->itxt, globals->intercept, msg);

		for (i = 0; i != NTERMS; ++i)
		{
			if (APORT(i)->status && i != P)
			{
				if (!APORT(i)->ignore[P] && !MY_PORT->ignore[i])
				{
					in_guild = APORT(i)->chr.in_guild == me.in_guild; 
					
					if (in_guild)
					{
						send(i, msg);
					}
					else if (APORT(i)->intercepting)
					{
						send(i, globals->itxt);
					}
				}
			}
		}
	}
	else if (send_to == LOUD_LOCAL)
	{
		for (i = 0; i != NTERMS; ++i)
		{
			if (APORT(i)->status && i != P && ABUF(B)->guy[i])
			{
				send(i, msg);
			}
		}
	}
	else if (send_to == QUIET_LOCAL)
	{
		ti = find_timer(INVISIBLE_TIME, ME);

		for (i = 0; i != NTERMS; ++i)
		{
			if (APORT(i)->status && i != P && ABUF(B)->guy[i])
			{
				tsi = find_timer(SEE_INVIS_TIME, i, -1);
				if (APORT(i)->chr.perm[SUPER_PERM])
				{
					tsi = TRUE;
				}

				if (me.perm[INVIS_PORT_PERM])
				{
					ti = TRUE;
					tsi = FALSE;
				}

				if (!ti || tsi)
				{
					send(i, msg);
				}
			}
		}
	}
	else if (send_to < 0)
	{
		send_to = abs(send_to) - 1;

		for (i = 0; i != NTERMS; ++i)
		{
			if (APORT(i)->status && i != send_to && i != P && ABUF(B)->guy[i])
			{
				send(i, msg);
			}
		}
	}
	else if (send_to == SAYING)
	{
		sprintf(globals->itxt, globals->intercept, msg);

		for (i = 0; i != NTERMS; ++i)
		{
			if (APORT(i)->status && i != P && ABUF(B)->guy[i])
			{
				send(i, msg);
			}
		}

		for (i = 0; i != NTERMS; ++i)
		{
			if (i != P && APORT(i)->intercepting)
			{
				if (APORT(i)->status && !ABUF(B)->guy[i])
				{
					send(i, globals->itxt);
				}
			}
		}
	}
	else
	{
		sprintf(globals->itxt, globals->intercept, msg);
		send(send_to, msg);

		for (i = 0; i != NTERMS; ++i)
		{
			if (i != P && APORT(i)->intercepting)
			{
				if (APORT(i)->status && i != send_to)
				{
					send(i, globals->itxt);
				}
			}
		}
	}
}
/****************************************************************************
	clear my buffer, send text to other port
*/
void EXPORT send(short p, char *msg)
{
		   
	if (!APORT(p)->editing && !APORT(p)->announce)
	{
		if (prfbuf[0] && P >= 0)
		{
			outprf(APORT(P)->usrnum);
			clrprf();
		}

		if (APORT(p)->need_lf)
		{
			prf(NL);
			APORT(p)->need_lf = FALSE;
		}
		
		prf("%s\r", msg);
		Send_Buf(APORT(p)->usrnum);
	}
}
/*******************************************************************************
	find a port for a new user
*/
short EXPORT Sign_Me_On
(
	short   monitor, 
	short   intercept, 
	char    *name, 
	char    *title, 
	char    class, 
	short   no_color,
	char    race,
	short   suspended,
	short   index,
	MLONG   secs_today
)
{
	short   i;
	char    *msg;

	P = -1;

	if (globals->validus_users == 0)
	{
		prfmsg(MSG1354);
		BAD_EXIT;
	}
	
	if (suspended == -1)
	{
		prfmsg(MSG330);
		BAD_EXIT;
	}
	
	if (globals->daymins && secs_today / 60 >= globals->daymins)
	{
		prfmsg(MSG1300, globals->daymins);
		BAD_EXIT;
	}
	
	if (globals->playkey[0] && !haskey(globals->playkey))
	{
		prfmsg(MSG1288);
		BAD_EXIT;
	}

	if
	(
		class != WARRIOR &&
		class != SORCERER &&
		class != BARBARIAN &&
		class != THIEF &&
		class != DUELIST &&
		class != CLERIC &&
		class != MYSTIC
	)
	{
		prf("%s", CLEAR_SCREEN);
		prfmsg(MSG331);
		P = -2;
		BAD_EXIT;
	}

	if
	(
		race != ELF &&
		race != DWARF &&
		race != HUMAN &&
		race != OGRE &&
		race != HALFLING
	)
	{
		prf("%s", CLEAR_SCREEN);
		prfmsg(MSG332);
		P = -3;
		BAD_EXIT;
	}

	for (i = 0; i != NTERMS; ++i)
	{
		if (APORT(i)->status && sameas(APORT(i)->chr.Userid, userid))
		{
			APORT(i)->hung_up = TRUE;
		}
	}

	if (monitor && !APORT(0)->status)
	{
		P = 0;
	}
	else
	{
		for (i = 1; i != NTERMS && P < 0; ++i)
		{
			if (!APORT(i)->status)
			{
				P = i;
			}
		}
	}

	if (P == -1)
	{
		prfmsg(MSG333);
		BAD_EXIT;
	}

	for (i = 0; i != NTERMS; ++i)
	{
		MY_PORT->ignore[i] = FALSE;
		APORT(i)->ignore[P] = FALSE;
	}

	for (i = 0; i != NTERMS; ++i)
	{
		MY_PORT->follower[i] = 0;
	}

	for (i = 0; i != NUM_GUY_TIMERS; ++i)
	{
		MY_PORT->misc_type[i] = 0;
		MY_PORT->timer[i] = 0;
	}

	strncpy(MY_PORT->time_on, nctime(now()), TIME_SIZE - 1);
	MY_PORT->time_on[TIME_SIZE - 1] = 0;
	strcpy(MY_PORT->command, "login");

	MY_PORT->old_credit_rate = usrptr->crdrat;
	usrptr->crdrat += globals->socccr;
	if (usrptr->crdrat < 0)
	{
		usrptr->crdrat = 0;
	}
	
	if (no_color)
	{
		usaptr->ansifl = 0;
		stansi();
	}
	else
	{
		usaptr->ansifl = ANSON;
		stansi();
	}

	MY_PORT->show_pts        = FALSE;
	MY_PORT->last_bp         = -1;
	MY_PORT->last_ftg        = -1;
	MY_PORT->last_mp         = -1;
	MY_PORT->saying          = FALSE;
	MY_PORT->hot_menu        = FALSE;
	MY_PORT->warn_5          = FALSE;
	MY_PORT->warn_1          = FALSE;
	MY_PORT->zapped          = FALSE;
	MY_PORT->assassin_timer  = ASSASSIN_TIME;
	MY_PORT->arrest_timer    = 0;
	MY_PORT->arena_timer     = 0;
	MY_PORT->need_lf         = TRUE;
	MY_PORT->focused         = FALSE;
	MY_PORT->drag_mon        = -1;
	MY_PORT->drag_guy        = -1;
	MY_PORT->dragged         = FALSE;
	globals->poobing[usrnum] = FALSE;
	globals->eviling[usrnum] = FALSE;
	MY_PORT->turfing         = FALSE;
	MY_PORT->finding         = FALSE;
	MY_PORT->announce        = FALSE;
	MY_PORT->invader_count   = 0;
	MY_PORT->last_input[0]   = 0;
	MY_PORT->last_input[1]   = 0;
	MY_PORT->next_input[0]   = 0;
	MY_PORT->next_input[1]   = 0;
	MY_PORT->input[0]        = 0;
	MY_PORT->secs_on         = 0;
	MY_PORT->berserk         = 0;
	MY_PORT->trance          = 0;
	MY_PORT->editing         = FALSE;
	MY_PORT->rovers          = 0;
	MY_PORT->invaders        = 0;
	MY_PORT->fine            = 0;
	MY_PORT->bashed          = 0;
	MY_PORT->death[0]        = 0;
	MY_PORT->big_sleep       = FALSE;
	MY_PORT->bashed_time     = 0;
	MY_PORT->heal_time       = 0;
	MY_PORT->magic_time      = 0;
	MY_PORT->usrnum          = usrnum;
	MY_PORT->questing        = FALSE;
	MY_PORT->limbo_return    = 0;
	MY_PORT->next_hit        = NORMAL;
	MY_PORT->my_bet          = 0;
	MY_PORT->hung_up         = 0;
	MY_PORT->hidden          = 0;
	MY_PORT->room_owner      = -1;
	MY_PORT->lucky_room      = 0;
	MY_PORT->last_attack     = 0;
	MY_PORT->last_spell      = 0;
	MY_PORT->damage_timer    = 0;
	MY_PORT->action_timer    = 0;
	MY_PORT->intercepting    = intercept;
	MY_PORT->experience      = 0;
	MY_PORT->kills           = 0;
	MY_PORT->murders         = 0;
	MY_PORT->cash            = 0;
	MY_PORT->bounty_gold     = 0;
	MY_PORT->deaths          = 0;
	MY_PORT->quests          = 0;
	MY_PORT->thefts          = 0;
	MY_PORT->theft_exp       = 0;
	MY_PORT->mon_level       = 0;

	MY_PORT->status = TRUE;

	if (P)
	{
		msg = getmsg(MSG334);
		sprintf(str, msg, P, Brief_Userid(userid), name, title);
		Message(str, GLOBAL);

		Titles(index, str);

		if (str[0])
		{
			Message(str, GLOBAL);
		}
	}

	DONE;
}
/******************************************************************************
	user is leaving, release his port
*/
void EXPORT sign_me_off()
{

	Day_Out();
	usrptr->crdrat = MY_PORT->old_credit_rate;
	MY_PORT->status = 0;
	P = -1;
}
