#include <header.h>
#include <globals.h>

/****************************************************************************
    information on how to use chaos
*/
void help(void)
{
    short   i;
    short   n;
    short   cmd;
    short   spell_num;

    if (word1[0] == 0)
    {
        prfmsg(MSSG234);
    }
    else if (sameas(word1, "commands"))
    {
        help_commands();
    }
    else if (sameas(word1, "elf"))
    {
        Class_Help(word1);
    }
    else if (sameas(word1, "dwarf"))
    {
        Class_Help(word1);
    }
    else if (sameas(word1, "human"))
    {
        Class_Help(word1);
    }
    else if (sameas(word1, "ogre"))
    {
        Class_Help(word1);
    }
    else if (sameas(word1, "halfling"))
    {
        Class_Help(word1);
    }
    else if (sameas(word1, "warrior"))
    {
        Class_Help(word1);
    }
    else if (sameas(word1, "sorcerer"))
    {
        Class_Help(word1);
    }
    else if (sameas(word1, "barbarian"))
    {
        Class_Help(word1);
    }
    else if (sameas(word1, "thief"))
    {
        Class_Help(word1);
    }
    else if (sameas(word1, "duelist"))
    {
        Class_Help(word1);
    }
    else if (sameas(word1, "cleric"))
    {
        Class_Help(word1);
    }
    else if (sameas(word1, "mystic"))
    {
        Class_Help(word1);
    }
    else
    {
        for (i = 1, n = 0; i < NUM_COMMANDS; ++i)
        {
            if (sameto(word1, commands[i]))
            {
                ++n;
                cmd = i;

                if (sameas(word1, commands[i]))
                {
                    n = 1;
                    i = NUM_COMMANDS;
                }
            }
        }

        if (n == 0)
        {
            for (i = n = 0; i != NUM_SPELLS; ++i)
            {
                if (sameto(word1, spell_info[i].name))
                {
                    ++n;
                    spell_num = i;
                }
            }

            if (n == 1)
            {
                Spell_Help(spell_num);
            }
            else
            {
                prfmsg(M235, word1);
            }
        }
        else if (n > 1)
        {
            prfmsg(M236, word1);
        }
        else
        {
            help_command(cmd);
        }
    }
}
/****************************************************************************
    list help for the specified command
*/
void help_command(short cmd)
{
    short   i;
    short   l = 1;
    short   n;
    char    word[LINE_LEN];
    char    path[LINE_LEN];

    if (cmd == NORTH)
    {
        strcpy(word, "n");
    }
    else if (cmd == SOUTH)
    {
        strcpy(word, "s");
    }
    else if (cmd == EAST)
    {
        strcpy(word, "e");
    }
    else if (cmd == WEST)
    {
        strcpy(word, "w");
    }
    else if (cmd == UP)
    {
        strcpy(word, "u");
    }
    else if (cmd == DOWN)
    {
        strcpy(word, "d");
    }
    else if (cmd == OUT)
    {
        strcpy(word, "o");
    }
    else if (cmd == CAST)
    {
        strcpy(word, "c");
    }
    else if (cmd == LOOK)
    {
        strcpy(word, "l");
    }
    else if (cmd == ACTIVATE_MENU)
    {
        strcpy(word, "m");
    }
    else
    {
        do
        {
            word[0] = 0;
            strncat(word, commands[cmd], l);

            for (i = 1, n = 0; i < NUM_COMMANDS; ++i)
            {
                if (sameto(word, commands[i]))
                {
                    ++n;

                    if (strlen(commands[i]) == l)
                    {
                        n = 1;
                        i = NUM_COMMANDS;
                    }
                }
            }
            ++l;
        }
        while (n != 1);
    }

    if (cmd)
    {
        prfmsg(MSG237, commands[cmd], word);
    }

    strcpy(word, commands[cmd]);
    word[8] = 0;

    sprintf(path, "%s/%s.txt", CHAOS_HELP_PATH, word);
    Dump_File(path, -1);
}
/****************************************************************************
    make a sorted command list along with a sorted index
*/
short command_sort(short *sorted_index)
{
    short   i, n, t;
    char    cmd_sort[NUM_COMMANDS][20];
    char    temp_cmd[20];

    setmem(cmd_sort, sizeof(cmd_sort), 0);

    for (i = 1; i != NUM_COMMANDS; ++i)
    {
        strcpy(cmd_sort[i], commands[i]);
        sorted_index[i] = i;
    }
    sorted_index[0] = 0;

    for (i = 1; i != NUM_COMMANDS; ++i)
    {
        for (n = 1; n != NUM_COMMANDS; ++n)
        {
            if (strcmp(cmd_sort[i], cmd_sort[n]) < 0)
            {
                strcpy(temp_cmd, cmd_sort[i]);
                strcpy(cmd_sort[i], cmd_sort[n]);
                strcpy(cmd_sort[n], temp_cmd);

                t = sorted_index[i];
                sorted_index[i] = sorted_index[n];
                sorted_index[n] = t;
            }
        }
    }
    DONE;
}
/****************************************************************************
    list all of the commands in alphabetical order
*/
void help_commands(void)
{
    short   i;
    short   l;
    short   ok;
    short   sorted_index[NUM_COMMANDS];

    command_sort(sorted_index);
    prfmsg(MSG238);

    for (i = 1, l = 0; i != NUM_COMMANDS; ++i)
    {       
        ok = TRUE;

        if 
        (
            sorted_index[i] == SAVE || 
            sorted_index[i] == HELP ||
            sorted_index[i] == ACTIVATE_MENU
        )
        {
            ok = FALSE;
        }
        else if (sorted_index[i] == BROADCAST)
        {
            if (!me.perm[GAMEOP_PERM])
            {
                ok = FALSE;
            }
        }
        else if (sorted_index[i] == BERSERK)
        {
            if (me.class != BARBARIAN)
            {
                ok = FALSE;
            }
        }
        else if (sorted_index[i] == TRANCE)
        {
            if 
            (
                me.class != MYSTIC &&
                me.class != SORCERER &&
                me.class != CLERIC
            )
            {
                ok = FALSE;
            }
        }
        else if (sorted_index[i] == GSEND)
        {
            if (!me.in_guild)
            {
                ok = FALSE;
            }
        }
        else if (sorted_index[i] == GAMEOP)
        {   
            ok = FALSE;

            if 
            (
                me.perm[GAMEOP_PERM] ||
                me.perm[PLAYER_EDIT_PERM] ||
                me.perm[EDIT_PERM] ||
                (globals->sysopkey[0] && haskey(globals->sysopkey))
            )
            {
                ok = TRUE;
            }
        }
        
        if (ok)
        {
            prf("%-10s ", commands[sorted_index[i]]);
            ++l;
            
            if (l == 7)
            {
                l = 0;
                prf("\r");
            }
        }
    }

    prf("\r\r");
}
/****************************************************************************
    displays help for the specified spell
*/
short Spell_Help(short spell_num)
{
    short   displaying = FALSE;
    short   done = FALSE;
    char    *read_result;
    char    txt[LINE_LEN];

    sprintf(globals->path, "%s\\MAGIC.TXT", CHAOS_HELP_PATH);
    MY_PORT->fp = fopen(globals->path, READONLY);

    if (MY_PORT->fp == NULL)
    {
        prfmsg(MSG1239);
        BAD_EXIT;
    }

    do
    {
        read_result = fgets(txt, 1000, MY_PORT->fp);
    
        if (read_result == NULL)
        {
            done = TRUE;
        }
        else
        {
            if (txt[0] == '*')
            {
                if (displaying)
                {
                    displaying = FALSE;
                    done = TRUE;
                }
                else if (sameto(spell_info[spell_num].name, &txt[1]))
                {
                    displaying = TRUE;
                }
            }

            if (displaying)
            {
                prfmsg(MSG1272, txt);
            }
        }
    }
    while (!done);
    fclose(MY_PORT->fp);
    
    DONE;
}
/****************************************************************************
    displays help for the specified race/class
*/
short Class_Help(char *word)
{
    short   displaying = FALSE;
    short   done = FALSE;
    char    *read_result;
    char    txt[LINE_LEN];

    sprintf(globals->path, "%s\\CLASSES.TXT", CHAOS_HELP_PATH);
    MY_PORT->fp = fopen(globals->path, READONLY);

    if (MY_PORT->fp == NULL)
    {
        prfmsg(MSG1239);
        BAD_EXIT;
    }

    do
    {
        read_result = fgets(txt, 1000, MY_PORT->fp);
    
        if (read_result == NULL)
        {
            done = TRUE;
        }
        else
        {
            if (txt[0] == '*')
            {
                if (displaying)
                {
                    displaying = FALSE;
                    done = TRUE;
                }
                else if (sameto(word, &txt[1]))
                {
                    displaying = TRUE;
                }
            }

            if (displaying)
            {
                prfmsg(MSG1272, txt);
            }
        }
    }
    while (!done);
    fclose(MY_PORT->fp);
    
    DONE;
}
