#include <header.h>
#include <globals.h>

/****************************************************************************
	guild functions
*/
short EXPORT Guild_Menu(short option)
{

	if (option == 0)
	{
		prfmsg(MSG1398A);
		Set_Prompt(getmsg(MSG1399A), GUILD_PROMPT); 
	}
	else if (option == 1)
	{
		if (MY_PORT->hot_menu)
		{
			MY_PORT->hot_menu = FALSE;
			MY_PORT->status = DO_PROMPT;
		}
		else
		{
			Set_Prompt(getmsg(MSG1399A), GUILD_PROMPT); 
		}
	}
	else if (sameas(margv[0], "A"))
	{
		Turf_Status();
	}
	else if (sameas(margv[0], "B"))
	{
		List_Masters();
		prf(NL);
		Guild_Menu(1);
	}
	else if (sameas(margv[0], "C"))
	{
		if (!me.in_guild)
		{
			sprintf(prompt, getmsg(MSG1400), NUM_SAVED_PLACES - 1);
		}
		else
		{
			sprintf(prompt, getmsg(MSG1401), NUM_SAVED_PLACES - 1);
		}
		
		Set_Prompt(prompt, MEMBER_PROMPT);
	}
	else if (sameas(margv[0], "D"))
	{
		Join_Guild();
		Guild_Menu(1);
	}
	else if (sameas(margv[0], "E"))
	{
		if (me.guild_master)
		{
			Edit_Guild();
		}
		else
		{
			prfmsg(M761);
			Guild_Menu(1);
		}
	}          
	else if (sameas(margv[0], "F"))
	{
		if (!me.in_guild)
		{
			prfmsg(M727);
			Guild_Menu(1);
		}
		else if (!me.guild_master && !guild->anyone_accept[me.in_guild])
		{
			prfmsg(M737);
			Guild_Menu(1);
		}
		else
		{
			Set_Prompt(getmsg(MSG1402), ACCEPT_PROMPT);
		}
	}
	else if (sameas(margv[0], "G"))
	{
		if (!me.in_guild)
		{
			prfmsg(M727);
			Guild_Menu(1);
		}
		else if (!me.guild_master && !guild->anyone_accept[me.in_guild])
		{
			prfmsg(M730);
			Guild_Menu(1);
		}
		else
		{   
			Set_Prompt(getmsg(MSG1403), BLACKBALL_PROMPT);
		}
	}
	else if (sameas(margv[0], "H"))
	{
		if (!me.in_guild)
		{
			prfmsg(M727);
			Guild_Menu(1);
		}                    
		else if (!me.guild_master)
		{
			prfmsg(M761);
			Guild_Menu(1);
		}
		else
		{   
			Set_Prompt(getmsg(MSG1404), APPOINT_PROMPT);
		}
	}
	else if (sameas(margv[0], "I"))
	{
		if (!me.in_guild)
		{
			prfmsg(M727);
			Guild_Menu(1);
		}
		else if (me.guild_master)
		{
			if (Find_Guild_Member())
			{
				Guild_Menu(1);
			}
			else
			{
				Set_Prompt(getmsg(MSG760), CLOSE_GUILD_PROMPT);
			}
		}
		else
		{
			Set_Prompt(getmsg(MSG728), RESIGN_PROMPT);
		}
	}
	else if (sameas(margv[0], "J"))
	{
		if (!me.guild_master)
		{
			prfmsg(M761); 
			Guild_Menu(1);
		}
		else
		{
			Set_Prompt(getmsg(MSG1405), DEBT_PROMPT1);
		}
	}
	else if (sameas(margv[0], "K"))
	{
		if (!me.in_guild && !me.perm[GAMEOP_PERM])
		{
			prfmsg(M714);
			Guild_Menu(1);
		}
		else if 
		(
			!IN_GUILD && 
			MY_PORT->room_owner != me.in_guild && 
			!me.perm[GAMEOP_PERM]
		)
		{
			prfmsg(M715);
			Guild_Menu(1);
		}
		else
		{
			prfmsg(MSG716);
			Set_Prompt(getmsg(MSG717), SCRAWL_PROMPT); 
			ABUF(B)->turf_change = TRUE;
		}
	}
	else if (sameas(margv[0], "L"))
	{
		if (!me.in_guild)
		{
			prfmsg(M727);
			Guild_Menu(1);
		}
		else
		{
			Check_Guild_Forum();
		}
	}
	else if (sameas(margv[0], "M"))
	{
		if (me.posts >= globals->maxposts && !me.perm[GAMEOP_PERM])
		{
			prfmsg(MSG1317, globals->maxposts);
			Guild_Menu(1);
		}
		else if (me.in_guild)
		{
			Set_Prompt(getmsg(MSG1497), POST_GUILD_PROMPT);
		}
		else
		{
			Set_Prompt(getmsg(MSG1498), POST_GUILD_PROMPT);
		}
	}
	else
	{
		prfmsg(MSG1398A);
		Set_Prompt(getmsg(MSG1399A), GUILD_PROMPT);
	}
	
	DONE;
}
/****************************************************************************
	see if the person I just murdered controlled this turf
*/
short steal_turf(short g)
{
	MLONG  hi = globals->turfmin;
	short  which = -1;
	short  i;

	if (me.in_guild == 0)
	{
		BAD_EXIT;
	}

	for (i = 1; i != NUM_SAVED_PLACES; ++i)
	{
		if (ABUF(B)->rm2.Turf_Kills[i] >= hi)
		{
			which = i;
			hi = ABUF(B)->rm2.Turf_Kills[i];
		}
	}

	if (which < 0)
	{
		BAD_EXIT;
	}

	if (which == AGUY->in_guild)
	{
		ABUF(B)->rm2.Turf_Kills[me.in_guild] =
			ABUF(B)->rm2.Turf_Kills[AGUY->in_guild] + 1;
		ABUF(B)->turf_change = TRUE;
	}
	DONE;
}
/****************************************************************************
	see if my turf status has changed
*/
short check_turf(void)
{
	short   cur_days = cofdat(today());
	short   i;
	MLONG   hi;
	short   old_owner;

	old_owner = MY_PORT->room_owner;

	if (cur_days - cofdat(ABUF(B)->rm2.last_kill) > globals->turfdur)
	{
		for (i = 0; i != NUM_SAVED_PLACES; ++i)
		{
			ABUF(B)->rm2.Turf_Kills[i] = 0;
		}
		ABUF(B)->turf_change = TRUE;
		ABUF(B)->rm2.last_kill = today();
	}

	for (i = 0, hi = globals->turfmin; i != NUM_SAVED_PLACES; ++i)
	{
		if 
		(
			ABUF(B)->rm2.Turf_Kills[i] && 
			sameas(guild->name[i], OPEN_GUILD)
		)
		{
			ABUF(B)->rm2.Turf_Kills[i] = 0;
			ABUF(B)->turf_change = TRUE;
		}
		else if (ABUF(B)->rm2.Turf_Kills[i] >= hi)
		{
			MY_PORT->room_owner = i;
			hi = ABUF(B)->rm2.Turf_Kills[i];
		}
	}

	if (old_owner == MY_PORT->room_owner || me.in_guild == 0)
	{
		BAD_EXIT;
	}

	if (MY_PORT->room_owner == me.in_guild && MY_PORT->lucky_room != 3) 
	{
		ABUF(B)->rm2.scrawl[0] = 0;

		for (i = 0; i != NUM_SAVED_PLACES; ++i)
		{
			if (i != me.in_guild)
			{
				ABUF(B)->rm2.Turf_Kills[i] = 0;
			}
		}
	}

	command = LOOK;
	lucky_room_check();
	DONE;
}
/****************************************************************************
	determine my turf bonus/penalty
*/
short lucky_room_check(void)
{
	MLONG  hi = globals->turfmin;
	short  next_hi = -1;
	short  i, g;

	MY_PORT->room_owner = -1;
	MY_PORT->lucky_room = 0;

	if (me.in_guild == 0)
	{
		BAD_EXIT;
	}

	g = me.in_guild;

	for (i = 0; i != NUM_SAVED_PLACES; ++i)
	{
		if (ABUF(B)->rm2.Turf_Kills[i] >= hi)
		{
			MY_PORT->room_owner = i;
			hi = ABUF(B)->rm2.Turf_Kills[i];
		}
	}

	if (MY_PORT->room_owner < 0)
	{
		if (!SAFE_AREA)
		{
			prf(globals->turf1);
		}
		BAD_EXIT;
	}

	if (MY_PORT->room_owner == g)
	{
		MY_PORT->lucky_room = 3;

		sprintf(str, globals->turf2, ABUF(B)->rm2.Turf_Kills[g]);
		prf(str);

		for (i = 0, hi = globals->turfmin; i != NUM_SAVED_PLACES; ++i)
		{
			if (ABUF(B)->rm2.Turf_Kills[i] >= hi && i != g)
			{
				next_hi = i;
				hi = ABUF(B)->rm2.Turf_Kills[i];
			}
		}

		if (next_hi >= 0)
		{
			sprintf(str, globals->turf3, guild->name[next_hi], hi);
			prf(str);
		}
		prf("\r");
	}
	else
	{
		if (guild->status[MY_PORT->room_owner][g] == -1)
		{
			MY_PORT->lucky_room = -6;

			sprintf
			(
				str,
				globals->turf4,
				guild->name[MY_PORT->room_owner],
				MY_PORT->room_owner,
				ABUF(B)->rm2.Turf_Kills[g],
				hi
			);
			prf(str);

			do_turf_fee(MY_PORT->room_owner, EXTRA * 4);
		}
		else if (guild->status[MY_PORT->room_owner][g] == 1)
		{
			MY_PORT->lucky_room = -1;

			sprintf
			(
				str,
				globals->turf5,
				guild->name[MY_PORT->room_owner],
				MY_PORT->room_owner,
				ABUF(B)->rm2.Turf_Kills[g],
				hi
			);
			prf(str);

			do_turf_fee(MY_PORT->room_owner, (EXTRA / 2) + 1);
		}
		else
		{
			MY_PORT->lucky_room = -3;

			sprintf
			(
				str,
				globals->turf6,
				guild->name[MY_PORT->room_owner],
				MY_PORT->room_owner,
				ABUF(B)->rm2.Turf_Kills[g],
				hi
			);
			prf(str);

			do_turf_fee(MY_PORT->room_owner, EXTRA);
		}
	}
	DONE;
}
/****************************************************************************
	extract turf fee
*/
short do_turf_fee(short which, short amt)
{
	short  x;

	amt -= me.thief;

	if (command == LOOK || amt <= 0)
	{
		BAD_EXIT;
	}

	if (me.gold >= amt)
	{
		me.gold -= amt;
		change_treasury(which, amt);
	}
	else if (me.bank >= amt)
	{
		me.bank -= amt;
		change_treasury(which, amt);
	}
	else
	{
		x = change_treasury(me.in_guild, -amt);
		
		if (x)
		{
			me.guild_balance -= amt;
			change_treasury(which, amt);
		}
		else
		{
			me.bank -= amt;
		}
	}
	DONE;
}
/*****************************************************************************
	a guild members has to pay his daily dues
*/
short do_dues(void)
{
	short   g;

	g = me.in_guild;

	if (guild->dues[g] < 0)
	{
		if (labs(guild->dues[g]) > guild->treasury[g])
		{
			DONE;
		}

		if ((double) me.bank + (double) labs(guild->dues[g]) > GCMAXLONG)
		{
			DONE;
		}
	}

	if (!me.guild_master)
	{
		sprintf(str, getmsg(MSG724), guild->dues[g]);
		prf(str);
	}

	if (me.bank >= guild->dues[g])
	{
		me.bank -= guild->dues[g];
		change_treasury(g, guild->dues[g]);
		sprintf(str, getmsg(MSG725), guild->dues[g]);
		prf(str);
	}

	DONE;
}
/*****************************************************************************
	change a guild treasury
*/
short change_treasury(short g, MLONG amt)
{

	if (g == 0)
	{
		BAD_EXIT;
	}

	if (amt < 0 && guild->treasury[g] < labs(amt))
	{
		BAD_EXIT;
	}

	if ((double) guild->treasury[g] + (double) amt > GCMAXLONG)
	{
		BAD_EXIT;
	}

	guild->treasury[g] += amt;
	return (TRUE);
}
/*****************************************************************************
	user wants to resign a guild membership
*/
void Resign(struct charstruct *member)
{
	char    today_date[DATE_SIZE];
	char    now_time[TIME_SIZE];
	struct  public_post_struct *msg;    
	
	msg = (struct public_post_struct *) vdaptr;                          
	setmem(msg, PUBLIC_MSG_SIZE, 0);
	msg->from = member->in_guild;
	msg->to = member->in_guild;
	
	TODAY(today_date);
	NOW(now_time);

	sprintf
	(
		msg->header, 
		getmsg(MSG726),
		member->in_guild,
		member->name,
		Brief_Userid(member->Userid),
		today_date,
		now_time
	);

	sprintf
	(
		msg->body[0], 
		"%s the %s has resigned! Guild Balance: %ld",
		member->name,
		member->title,
		member->guild_balance
	);

	Put_Public_Message(msg);

	member->in_guild = FALSE;
	member->guild_balance = 0;
}
/*****************************************************************************
	guild master is black-balling a member
*/
short Black_Ball(void)
{
	short   i;
	short   index;
	short   online = -1;

	if (sameas(margv[0], me.name))
	{
		prfmsg(M732);
		BAD_EXIT;
	}

	index = Find_A_Char(&a_char, margv[0]);

	if (index < 0)
	{
		prfmsg(M920, margv[0]);
		BAD_EXIT;
	}

	if (a_char.in_guild != me.in_guild)
	{
		prfmsg(M734, a_char.name);
		BAD_EXIT;
	}

	if (a_char.guild_master)
	{
		prfmsg(MSG1331);
		BAD_EXIT;
	}

	for (i = 0; i != NTERMS; ++i)
	{
		if (APORT(i)->status && sameas(APORT(i)->chr.name, a_char.name))
		{
			APORT(i)->chr.in_guild = FALSE;
			APORT(i)->chr.guild_balance = 0;
			sprintf(str, getmsg(MSG735), me.name);
			Message(str, i);
			online = i;
		}
	}

	if (online >= 0)
	{
		Write_Him(online);
	}
	else
	{
		a_char.in_guild = 0;
		a_char.guild_master = 0;
		a_char.guild_balance = 0;
		Write_A_Char(index, &a_char);
	}

	prfmsg(M736, a_char.name);
	DONE;
}
/*****************************************************************************
	guild master is accepting a new member
*/
short Accept(void)
{
	short   i;
	short   index;
	short   online = -1;

	index = Find_A_Char(&a_char, margv[0]);

	if (index < 0)
	{
		prfmsg(M920, margv[0]);
		BAD_EXIT;
	}

	if (a_char.in_guild)
	{
		prfmsg(M738, a_char.name);
		BAD_EXIT;
	}

	if (a_char.Option[NO_GUILD])
	{
		prfmsg(M739, a_char.name);
		BAD_EXIT;
	}

	for (i = 0; i != NTERMS; ++i)
	{
		if (APORT(i)->status && sameas(APORT(i)->chr.name, a_char.name))
		{
			APORT(i)->chr.in_guild = me.in_guild;
			APORT(i)->chr.guild_balance = 0;
			APORT(i)->chr.guild_read = 0;
			sprintf(str, getmsg(MSG740), me.name);
			Message(str, i);
			online = i;
		}
	}

	if (online >= 0)
	{
		Write_Him(online);
	}
	else
	{
		a_char.in_guild = me.in_guild;
		a_char.guild_balance = 0;
		a_char.guild_read = 0;
		Write_A_Char(index, &a_char);
	}

	prfmsg(MSG741, a_char.name);
	DONE;
}
/*****************************************************************************
	guild master is changing a member's debt status
*/
short Change_Debt(void)
{
	short   i;
	MLONG   debt;
	short   index = MY_PORT->misc;
	short   online = -1;

	Read_A_Char(index, &a_char);

	if (a_char.in_guild != me.in_guild)
	{
		BAD_EXIT;
	}

	debt = LNUM(margv[0]);

	if (margv[0][0] == '-')
	{
		debt = debt * (MLONG) -1;
	}

	for (i = 0; i != NTERMS; ++i)
	{
		if (APORT(i)->status && sameas(APORT(i)->chr.name, a_char.name))
		{
			online = i;
			APORT(i)->chr.guild_balance = debt;
			sprintf(str, getmsg(MSG752), me.name, debt);
			
			if (i != P)
			{
				Message(str, i);
			}
		}
	}

	if (online >= 0)
	{
		Write_Him(online);
	}
	else
	{
		a_char.guild_balance = debt;
		Write_A_Char(index, &a_char);
	}

	sprintf(str, getmsg(MSG753), a_char.name, debt);
	prf(str);
	DONE;
}
/*****************************************************************************
	user wants to start a guild
*/
short Join_Guild(void)
{
	short   i;
	short   guild_num = -1;

	if (globals->guildkey[0] && !haskey(globals->guildkey))
	{
		prfmsg(M754);
		BAD_EXIT;
	}

	for (i = 1; i != NUM_SAVED_PLACES && guild_num < 0; ++i)
	{
		if (sameas(guild->name[i], OPEN_GUILD))
		{
			guild_num = i;
		}
	}

	if (guild_num == -1)
	{
		prfmsg(MS757);
		BAD_EXIT;
	}

	if (me.in_guild)
	{
		prfmsg(M758);
		BAD_EXIT;
	}

	me.guild_master = TRUE;
	me.guild_read = 0;
	me.in_guild = guild_num;
	guild->treasury[me.in_guild] = 0;

	prfmsg(MG759, guild_num);
	sprintf(guild->name[guild_num], "Guild #%d", guild_num);
	Write_My_Rec(EXISTS);
	sprintf(str, "%s\\GUILD%d.DAT", GUILD_FORUM_PATH, guild_num);
	unlink(str);
	DONE;
}
/*****************************************************************************
	user wants to resign a guild mastership
*/
void Master_Resign(void)
{

	if (sameas(margv[0], "y"))
	{
		Clean_Closed_Guild(me.in_guild);
		me.in_guild = 0;
		me.guild_master = 0;
		me.guild_balance = 0;
		Write_My_Rec(EXISTS);
		prfmsg(M729);
	}
}
/*****************************************************************************
	user wants to re-assign guild mastership to someone else
*/
short Appoint_Guild_Master(void)
{
	short   i;
	short   online = -1;
	short   index;

	index = Find_A_Char(&a_char, margv[0]);
	if (index < 0)
	{
		prfmsg(M920, word1);
		BAD_EXIT;
	}

	if (a_char.in_guild != me.in_guild)
	{
		prfmsg(M734, a_char.name);
		BAD_EXIT;
	}

	me.guild_master = FALSE;
	Write_My_Rec(EXISTS);

	for (i = 0; i != NTERMS; ++i)
	{
		if (APORT(i)->status && sameas(APORT(i)->chr.name, a_char.name))
		{
			APORT(i)->chr.guild_master = TRUE;
			sprintf(str, getmsg(MSG764), me.name);
			Message(str, i);
			online = i;
		}
	}

	if (online >= 0)
	{
		Write_Him(online);
	}
	else
	{
		a_char.guild_master = TRUE;
		Write_A_Char(index, &a_char);
	}

	prfmsg(MSG765, a_char.name);
	DONE;
}
/****************************************************************************
	compile a list of turf
*/
void Turf_Status(void)
{
	short   i;
	struct  turf_struct *turf = (struct turf_struct *) &MY_PORT->turf;
	
	prfmsg(MSG766);

	for (i = 1; i != NUM_SAVED_PLACES; ++i)
	{
		turf->controlled[i] = 0;
	}

	turf->index = 1;
	MY_PORT->turfing = TRUE;
	btuinj(usrnum, MYCYCLE);
}
/****************************************************************************
	continue turf calculations
*/
short Next_Turf(void)
{
	short  i;
	MLONG  kills;
	short  which;
	short  n;
	MLONG  num_kills[NUM_SAVED_PLACES];
	char   condition[4];
	struct turf_struct *turf = (struct turf_struct *) &MY_PORT->turf;    

	lsk = (MLONG) turf->index * (MLONG) ROOM2_SIZE;
	fseek(fp_room2, lsk, TOP);
	n = fread(&a_room2, ROOM2_SIZE, 1, fp_room2);
	
	if (n == 1)
	{
		which = -1;
		kills = globals->turfmin;
		
		for (i = 1; i != NUM_SAVED_PLACES; ++i)
		{
			num_kills[i] = a_room2.Turf_Kills[i];
		}

		for (i = 1; i != NUM_SAVED_PLACES; ++i)
		{
			if (num_kills[i] && num_kills[i] >= kills)
			{
				kills = num_kills[i];
				which = i;
			}
		}

		if (which >= 0)
		{
			++turf->controlled[which];
		}

		++turf->index; 
	}
		
	if (n == 1 && turf->index <= globals->maxroom)
	{
		MY_PORT->turfing = TRUE;
		btuinj(usrnum, MYCYCLE);
		DONE;
	}

	strcpy(condition, "WPA");

	prf("\r");
	for (i = 1; i != NUM_SAVED_PLACES; ++i)
	{
		short  fee;

		guild->rooms_controlled[i] = turf->controlled[i];

		if (!me.in_guild)
		{
			fee = 0;
		}
		else if (i != me.in_guild)
		{
			if (globals->feefctr > 0)
			{
				if (guild->status[i][me.in_guild] == -1)
				{
					fee = (turf->controlled[i] / globals->feefctr) * 4;
				}
				else if (guild->status[i][me.in_guild] == 1)
				{
					fee = ((turf->controlled[i] / globals->feefctr) / 2) + 1;
				}
				else
				{
					fee = (turf->controlled[i] / globals->feefctr);
				}
			}
			else
			{
				if (guild->status[i][me.in_guild] == -1)
				{
					fee = (turf->controlled[i] * abs(globals->feefctr)) * 4;
				}
				else if (guild->status[i][me.in_guild] == 1)
				{
					fee = ((turf->controlled[i] * abs(globals->feefctr)) / 2) + 1;
				}
				else
				{
					fee = (turf->controlled[i] * abs(globals->feefctr));
				}
			}

			fee -= me.thief;

			if (fee < 0)
			{
				fee = 0;
			}
		}
		else
		{
			if (globals->feefctr > 0)
			{
				fee = (turf->controlled[i] / globals->feefctr);
			}
			else
			{
				fee = (turf->controlled[i] * abs(globals->feefctr));
			}
		}

		if (sameas(guild->name[i], OPEN_GUILD))
		{
			prfmsg(MSG767, i, guild->name[i]);
		}
		else
		{
			prfmsg
			(
				MSG768,
				i,
				condition[guild->status[me.in_guild][i] + 1],
				condition[guild->status[i][me.in_guild] + 1],
				guild->name[i],
				turf->controlled[i],
				fee
			);
		}
	}
		
	if (globals->minturf)
	{
		prfmsg(MSG1292, globals->minturf);
	}

	prf(NL);
	if (MY_PORT->hot_menu)
	{
		MY_PORT->hot_menu = FALSE;
		MY_PORT->status = DO_PROMPT;
		Set_Main_Prompt();
	}
	else
	{
		Set_Prompt(getmsg(MSG1399A), GUILD_PROMPT); 
	}

	MY_PORT->turfing = FALSE;
	outprf(MY_PORT->usrnum);
	clrprf();

	DONE;
}
/****************************************************************************
	edit guild info
*/
short EXPORT Edit_Guild(void)
{
	short   i;
	short   g = me.in_guild;
	char    prompt[LINE_LEN];
	char    today_date[DATE_SIZE];
	char    now_time[TIME_SIZE];
	struct  public_post_struct *msg;    
	
	TODAY(today_date);
	NOW(now_time);

	msg = (struct public_post_struct *) vdaptr;                          
	setmem(msg, PUBLIC_MSG_SIZE, 0);
	msg->from = me.in_guild;
	msg->to = 0;

	if (STATE == 0)
	{
		prfmsg(MSG769);

		sprintf(prompt, getmsg(MSSG770), guild->dues[g]);
		Set_Prompt(prompt, EDIT_GUILD_PROMPT);
		++STATE;
	}
	else if (STATE == 1)
	{
		Set_Long(&guild->dues[g]);

		sprintf(prompt, getmsg(MSG771), guild->name[g]);
		Set_Prompt(prompt, EDIT_GUILD_PROMPT);
		++STATE;
	}
	else if (STATE == 2)
	{
		if (!sameas(margv[0], OPEN_GUILD) || me.perm[GAMEOP_PERM])
		{
			Set_Str(guild->name[g], GUILD_NAME_SIZE);

			for (i = 1; i != NUM_SAVED_PLACES; ++i)
			{
				if (i != g && sameas(guild->name[g], guild->name[i]))
				{
					prfmsg(M772);
					sprintf(guild->name[g], "Guild #%d", g);
				}
			}
		}
		else
		{
			prfmsg(MSG773);
		}

		sprintf(prompt, getmsg(MSG774), guild->master_name[g]);
		Set_Prompt(prompt, EDIT_GUILD_PROMPT);
		++STATE;
	}
	else if (STATE == 3)
	{
		Set_Str(guild->master_name[g], GUILD_NAME_SIZE);

		sprintf(prompt, getmsg(MSG775), guild->member_name[g]);
		Set_Prompt(prompt, EDIT_GUILD_PROMPT);
		++STATE;
	}
	else if (STATE == 4)
	{
		Set_Str(guild->member_name[g], GUILD_NAME_SIZE);

		sprintf(prompt, getmsg(MSG776), yn[guild->anyone_accept[g]]);
		Set_Prompt(prompt, EDIT_GUILD_PROMPT);
		++STATE;
	}
	else if (STATE == 5)
	{
		if (sameas(margv[0], "y"))
		{
			guild->anyone_accept[g] = TRUE;
		}
		else if (sameas(margv[0], "n"))
		{
			guild->anyone_accept[g] = FALSE;
		}

		MY_PORT->misc = 1;

		while 
		(
			MY_PORT->misc < NUM_SAVED_PLACES &&
			(
				MY_PORT->misc == g || 
				sameas(guild->name[MY_PORT->misc], OPEN_GUILD)
			)
		)
		{
			++MY_PORT->misc;
		}

		if (MY_PORT->misc >= NUM_SAVED_PLACES)
		{
			STATE = 0;
		}
		else
		{
			Set_Prompt(getmsg(MSG777), EDIT_GUILD_PROMPT);
			++STATE;
		}
	}
	else if (STATE == 6)
	{
		if (!sameas(margv[0], "y"))
		{
			STATE = 0;
		}
		else
		{
			prfmsg(MSG779, guild->name[MY_PORT->misc]);
			Set_Prompt(getmsg(MSG778), EDIT_GUILD_PROMPT);
			++STATE;
		}
	}
	else if (STATE == 7)
	{
		if (margc)
		{
			if 
			(
				sameas(margv[0], "w") && 
				guild->status[g][MY_PORT->misc] != -1
			)
			{
				guild->status[g][MY_PORT->misc] = -1;
				
				sprintf
				(
					msg->header, 
					getmsg(MSG1359),
					me.name,
					Brief_Userid(me.Userid),
					today_date,
					now_time
				);

				sprintf
				(
					msg->body[0], 
					"Guild #%d has declared war on Guild #%d!",
					g,
					MY_PORT->misc
				);

				Put_Public_Message(msg);
			}
			else if 
			(
				sameas(margv[0], "p") && 
				guild->status[g][MY_PORT->misc] != 0
			)
			{
				guild->status[g][MY_PORT->misc] = 0;
				
				sprintf
				(
					msg->header, 
					getmsg(MSG1360),
					me.name,
					Brief_Userid(me.Userid),
					today_date,
					now_time
				);

				sprintf
				(
					msg->body[0], 
					"Guild #%d has declared peace with Guild #%d!",
					g,
					MY_PORT->misc
				);

				Put_Public_Message(msg);
			}
			else if 
			(
				sameas(margv[0], "a") && 
				guild->status[g][MY_PORT->misc] != 1
			)
			{
				guild->status[g][MY_PORT->misc] = 1;
				
				sprintf
				(
					msg->header, 
					getmsg(MSG1361),
					me.name,
					Brief_Userid(me.Userid),
					today_date,
					now_time
				);

				sprintf
				(
					msg->body[0], 
					"Guild #%d has declared an alliance with Guild #%d!",
					g,
					MY_PORT->misc
				);

				Put_Public_Message(msg);
			}
		}

		++MY_PORT->misc;

		if (MY_PORT->misc >= NUM_SAVED_PLACES)
		{
			STATE = 0;
		}
		else
		{
			while 
			(
				MY_PORT->misc < NUM_SAVED_PLACES &&
				(
					MY_PORT->misc == g || 
					sameas(guild->name[MY_PORT->misc], OPEN_GUILD)
				)
			)
			{
				++MY_PORT->misc;
			}
		}

		if (MY_PORT->misc >= NUM_SAVED_PLACES)
		{
			STATE = 0;
		}
		else
		{
			prfmsg(MSG779, guild->name[MY_PORT->misc]);
			Set_Prompt(getmsg(MSG778), EDIT_GUILD_PROMPT);
		}
	}
 
	DONE;
}
/*****************************************************************************
	find someone (anyone) in my guild
*/
short Find_Guild_Member(void)
{
	short   n;
	FILE    *fp_brief;
	struct  brief_char_struct brief;

	fp_brief = fopen(CHAOS_NAME_FILE, RDWR);

	do
	{
		n = fread(&brief, BRIEF_CHAR_SIZE, 1, fp_brief);

		if
		(
			n == 1 &&
			!sameas(brief.name, me.name) &&
			!sameas(brief.name, BLANK_RECORD)
		)
		{
			if (brief.in_guild == me.in_guild)
			{
				prfmsg(MSG1204, brief.name);
				prfmsg(MSG1205, brief.name);
				fclose(fp_brief);
				return (TRUE);
			}
		}
	}
	while (n == 1);

	fclose(fp_brief);
	BAD_EXIT;
}
/*****************************************************************************
	I died, appoint mastership to someone else or close the gold
*/
short Guild_Master_Died(char *name, short in_guild)
{
	short   n;
	short   i;
	short   index = -1;
	FILE    *fp_brief;
	struct  brief_char_struct brief;

	do
	{
		++index;

		fp_brief = fopen(CHAOS_NAME_FILE, RDWR);
		lsk = (MLONG) index * BRIEF_CHAR_SIZE;
		fseek(fp_brief, lsk, TOP);
		n = fread(&brief, BRIEF_CHAR_SIZE, 1, fp_brief);
		fclose(fp_brief);

		if
		(
			n &&
			!sameas(brief.name, name) &&
			!sameas(brief.name, BLANK_RECORD)
		)
		{
			if (brief.in_guild == in_guild)
			{
				Read_A_Char(index, &a_char);
				a_char.guild_master = TRUE;
				Write_A_Char(index, &a_char);

				for (i = 0; i != NTERMS; ++i)
				{
					if 
					(
						APORT(i)->status && 
						sameas(APORT(i)->chr.name, brief.name)
					)
					{
						APORT(i)->chr.guild_master = TRUE;
					}
				}
				return (TRUE);
			}
		}
	}
	while (n == 1);

	Clean_Closed_Guild(in_guild);
	BAD_EXIT;
}
/****************************************************************************
	a guild has closed, clean it up
*/
void Clean_Closed_Guild(short g)
{
	short   i;

	strcpy(guild->name[g], OPEN_GUILD);
	guild->master_name[g][0] = 0;
	guild->member_name[g][0] = 0;
	guild->dues[g] = 0;
	guild->anyone_accept[g] = FALSE;
	
	for (i = 0; i != NUM_SAVED_PLACES; ++i)
	{
		guild->status[g][i] = 0;
	}
	guild->treasury[g] = 0;

	setmem(a_closet, CLOSET_SIZE, 0);
	Write_Guild_Catalog(g, a_closet);
	sprintf(str, "%s\\GUILD%d.DAT", GUILD_FORUM_PATH, g);
	unlink(str);
}
/****************************************************************************
	display fellow guild members
*/
short Guild_Members(void)
{
	short   n;
	short   l = 0;
	short   lev;
	short   done = FALSE;
	MLONG   total;
	char    master;
	char    *msg;
	FILE    *fp_brief;
	struct  brief_char_struct brief;

	if (MY_PORT->status != MEMBERS_PROMPT)
	{
		if (margc)
		{
			MY_PORT->misc2 = INUM(margv[0]);

			if (MY_PORT->misc2 < 1 || MY_PORT->misc2 > NUM_SAVED_PLACES - 1)
			{
				prfmsg(M756, NUM_SAVED_PLACES - 1);
				Guild_Menu(1);
				DONE;
			}
		}
		else
		{
			if (!me.in_guild)
			{
				prfmsg(M727);
				Guild_Menu(1);
				DONE;
			}

			MY_PORT->misc2 = me.in_guild;
		}
		
		if (sameas(guild->name[MY_PORT->misc2], OPEN_GUILD))
		{
			prfmsg(MSG1207, MY_PORT->misc2);
			Guild_Menu(1);
			DONE;
		}

		prfmsg(MSG1208, guild->name[MY_PORT->misc2]);
		MY_PORT->misc = 0;
	}
	else if (margc)
	{
		if (sameas(margv[0], "n"))
		{
			Guild_Menu(1);
			DONE;
		}
	}

	setmbk(mui_cfg);

	if (MY_PORT->misc2 == me.in_guild)
	{
		msg = getmsg(GLDMBERS);
	}
	else
	{
		msg = getmsg(MSSG1014);
	}

	fp_brief = fopen(CHAOS_NAME_FILE, RDWR);
	lsk = (MLONG) MY_PORT->misc * BRIEF_CHAR_SIZE;
	fseek(fp_brief, lsk, TOP);

	do
	{
		n = fread(&brief, BRIEF_CHAR_SIZE, 1, fp_brief);
		++MY_PORT->misc;
		
		if (n == 0)
		{
			done = TRUE;
		}
		else if (!sameas(brief.name, BLANK_RECORD))
		{
			if (brief.guild_master)
			{
				master = 'M';
			}
			else
			{
				master = ' ';
			}

			if (brief.in_guild == MY_PORT->misc2)
			{
				Read_A_Char(MY_PORT->misc - 1, &a_char);
				
				total = a_char.Psy;
				total += a_char.Int;
				total += a_char.Str;
				total += a_char.Dex;
				total += a_char.Con;
				total = total / 5;
				lev = (short) total;
				lev = Stat_Lev(lev); 

				if (brief.in_guild == me.in_guild)
				{
					sprintf
					(
						str,
						msg,
						master,
						brief.name,
						Brief_Userid(brief.Userid),
						lev,
						brief.guild_balance
					);
				}
				else
				{
					sprintf
					(
						str,
						msg,
						master,
						brief.name,
						Brief_Userid(brief.Userid),
						lev
					);
				}

				prf(str);
				++l;
			}
		}
	}
	while (!done && l < 21);

	fclose(fp_brief);

	if (!done)
	{
		Set_Prompt(getmsg(MSG1209), MEMBERS_PROMPT);
	}
	else
	{
		prf(NL);
		Guild_Menu(1);
	}

	rstmbk();
	DONE;
}
/****************************************************************************
	display guild masters
*/
void List_Masters(void)
{
	short   i;
	short   n;
	short   index = 0;
	FILE    *fp_brief;
	short   master_index[NUM_SAVED_PLACES];
	char    userid_str[LINE_SIZE];
	struct  brief_char_struct brief;

	prfmsg(MSG1210);

	for (i = 1; i != NUM_SAVED_PLACES; ++i)
	{
		master_index[i] = -1;
	}
  
	fp_brief = fopen(CHAOS_NAME_FILE, RDWR);

	do
	{
		n = fread(&brief, BRIEF_CHAR_SIZE, 1, fp_brief);

		if (n && !sameas(brief.name, BLANK_RECORD) && brief.guild_master)
		{
			master_index[brief.in_guild] = index;
		}
		++index;
	}
	while (n);

	for (n = 1; n != NUM_SAVED_PLACES; ++n)
	{
		if (master_index[n] >= 0)
		{
			lsk = (MLONG) master_index[n] * BRIEF_CHAR_SIZE;
			fseek(fp_brief, lsk, TOP);
			fread(&brief, BRIEF_CHAR_SIZE, 1, fp_brief);
			sprintf(userid_str, getmsg(MSG1211), Brief_Userid(brief.Userid));
			
			prfmsg
			(
				GLDMSTR,
				brief.in_guild,
				guild->name[brief.in_guild],
				brief.name,
				userid_str
			);
		}
	}

	fclose(fp_brief);
}
/****************************************************************************
	close guilds that don't have minturf
*/
void Guild_Turf_Check(void)
{
	short   i;
	short   r;
	MLONG   kills;
	short   which;
	short   n;
	short   index;
	MLONG   num_kills[NUM_SAVED_PLACES];
	char    today_date[DATE_SIZE];
	char    now_time[TIME_SIZE];
	FILE    *fp_brief;
	struct  turf_struct turf;
	struct  brief_char_struct brief;
	
	for (i = 1; i != NUM_SAVED_PLACES; ++i)
	{
		turf.controlled[i] = 0;
	}

	for (r = 1; r != MAX_ROOM; ++r)
	{
		lsk = (MLONG) r * (MLONG) ROOM2_SIZE;
		fseek(fp_room2, lsk, TOP);
		n = fread(&a_room2, ROOM2_SIZE, 1, fp_room2);
	
		if (n == 1)
		{
			which = -1;
			kills = globals->turfmin;
		
			for (i = 1; i != NUM_SAVED_PLACES; ++i)
			{
				num_kills[i] = a_room2.Turf_Kills[i];
			}

			for (i = 1; i != NUM_SAVED_PLACES; ++i)
			{
				if (num_kills[i] && num_kills[i] >= kills)
				{
					kills = num_kills[i];
					which = i;
				}
			}

			if (which >= 0)
			{
				++turf.controlled[which];
			}
		}
	}
		
	for (i = 1; i != NUM_SAVED_PLACES; ++i)
	{
		if (!sameas(guild->name[i], OPEN_GUILD))
		{
			if (turf.controlled[i] < globals->minturf)
			{
				index = 0;

				do
				{
					fp_brief = fopen(CHAOS_NAME_FILE, RDWR);
					lsk = (MLONG) index * (MLONG) BRIEF_CHAR_SIZE;
					fseek(fp_brief, lsk, TOP);
					n = fread(&brief, BRIEF_CHAR_SIZE, 1, fp_brief);
					fclose(fp_brief);

					if (n == 1 && !sameas(brief.name, BLANK_RECORD)) 
					{
						if (brief.in_guild == i)
						{
							Read_A_Char(index, &a_char);
							a_char.guild_master = FALSE;
							a_char.in_guild = 0;
							Write_A_Char(index, &a_char);
						}
					}

					++index;
				}
				while (n == 1);

				setmem(&globals->msg, PUBLIC_MSG_SIZE, 0);
				globals->msg.from = 0;
				globals->msg.to = 0;
	
				TODAY(today_date);
				NOW(now_time);

				sprintf
				(
					globals->msg.header, 
					getmsg(MSG1290),
					today_date,
					now_time
				);
				
				sprintf(globals->msg.body[0], getmsg(MSG1291), i);
				Put_Public_Message(&globals->msg);
				Clean_Closed_Guild(i);
			}
		}
	}
}
/****************************************************************************
	close guilds that have no guild master
*/
void Close_Non_Mastered_Guilds(void)
{
	short   i;
	short   n;
	short   index = 0;
	FILE    *fp_brief;
	short   master_index[NUM_SAVED_PLACES];
	short   member_index[NUM_SAVED_PLACES];
	struct  brief_char_struct brief;

	for (i = 0; i != NUM_SAVED_PLACES; ++i)
	{
		master_index[i] = -1;
		member_index[i] = -1;
	}
  
	fp_brief = fopen(CHAOS_NAME_FILE, RDWR);

	do
	{
		n = fread(&brief, BRIEF_CHAR_SIZE, 1, fp_brief);

		if (n == 1 && !sameas(brief.name, BLANK_RECORD)) 
		{
			if (brief.guild_master)
			{
				master_index[brief.in_guild] = index;
			}
			else if (brief.in_guild)
			{
				member_index[brief.in_guild] = index;
			}
		}
		++index;
	}
	while (n == 1);

	fclose(fp_brief);

	for (n = 1; n != NUM_SAVED_PLACES; ++n)
	{
		if (master_index[n] == -1 && !sameas(guild->name[n], OPEN_GUILD))
		{
			sprintf(str, "Fixing masterless guild #%d", n);
			NOTIFY(str);

			if (member_index[n] != -1)
			{
				Read_A_Char(member_index[n], &a_char);
				a_char.guild_master = TRUE;
				Write_A_Char(member_index[n], &a_char);
			}
			else
			{
				Clean_Closed_Guild(n);
			}
		}
		else if (master_index[n] != -1 && sameas(guild->name[n], OPEN_GUILD))
		{
			sprintf(guild->name[n], "Guild #%d", n);
		}
	}
}
/****************************************************************************
	write guild stuff to disk
*/
void Write_Guild_Stuff(void)
{
	FILE    *fp;

	fp = fopen(GUILD_FILE, RDWR);
	
	if (fp == NULL)
	{
		NOTIFY("GUILD WRITE FAILED!");
	}
	else
	{
		fwrite(guild, GUILD_INFO_SIZE, 1, fp);
		fclose(fp);
	}
}
/****************************************************************************
	initialize saved items segment, read guild parameters
*/
void Init_Guild_Stuff(void)
{
	FILE    *fp;
	short   n;
	short   i;

	fp = fopen(GUILD_FILE, RDWR);
	
	if (fp == NULL)
	{
		NOTIFY("Guild Info File Open FAILED!");
		n = 0;
	}
	else
	{
		n = fread(guild, GUILD_INFO_SIZE, 1, fp);
		fclose(fp);
	}

	if (n == 0)
	{
		for (i = 0; i != NUM_SAVED_PLACES; ++i)
		{
			strcpy(guild->name[i], OPEN_GUILD);
		}
	}

	for (i = 0; i != NUM_SAVED_PLACES; ++i)
	{
		if (guild->anyone_accept[i] < 0 || guild->anyone_accept[i] > 1)
		{
			guild->anyone_accept[i] = 0;
		}

		for (n = 0; n != NUM_SAVED_PLACES; ++n)
		{
			if (guild->status[i][n] < -1 || guild->status[i][n] > 1)
			{
				guild->status[i][n] = 0;
			}
		}
	}
}
/****************************************************************************
	find inactive turf and clear it
*/
void Clear_Old_Turf(void)
{
	short   cur_days = cofdat(today());
	short   i;
	short   j;
	struct  room2_struct room2;

	fseek(fp_room2, 0, TOP);

	for (i = 1; i != MAX_ROOM; ++i)
	{
		lsk = (MLONG) i * ROOM2_SIZE;
		fseek(fp_room2, lsk, TOP);
		fread(&room2, ROOM2_SIZE, 1, fp_room2);

		if (cur_days - cofdat(room2.last_kill) > globals->turfdur)
		{
			for (j = 0; j != NUM_SAVED_PLACES; ++j)
			{
				room2.Turf_Kills[j] = 0;
			}

			room2.scrawl[0] = 0;
			room2.last_kill = today();
			
			fseek(fp_room2, lsk, TOP);
			fwrite(&room2, ROOM2_SIZE, 1, fp_room2);
		}
	}
}
/****************************************************************************
	read a guild storage closet
*/
void Read_Guild_Storage(short g, struct closet_struct *closet)
{
	short   i;
	FILE    *fp;

	sprintf(globals->path, "%s\\GUILD%d.DAT", DATA_PATH, g);
	fp = fopen(globals->path, READB);

	if (fp == NULL)
	{
		setmem(closet, CLOSET_SIZE, 0);
	}
	else
	{
		i = fread(closet, CLOSET_SIZE, 1, fp);
		fclose(fp);

		if (i == 0)
		{
			setmem(closet, CLOSET_SIZE, 0);
		}
	}

	unlink(globals->path);
}
