#include <header.h>
#include <globals.h>

/****************************************************************************
	user is attempting to drag another player to the next room
*/
void EXPORT Drag_Guy(short g, short dir)
{
	long    my_roll;
	long    his_roll;
	long    my_strength;
	long    his_strength;

	Perform_Attack(GUY);
	his_strength = (long) AGUY->Str + (long) AGUY->Dex;
	my_strength = (long) me.Str + (long) me.Dex;

	if (APORT(g)->next_hit == VULNERABLE)
	{
		his_strength = his_strength / 2L;
	}

	if 
	(
		his_strength <= 0 ||
		find_timer(KO_TIME, GUY) ||
		find_timer(SLEEP_TIME, GUY) ||
		find_timer(MES_TIME, GUY) ||
		APORT(g)->bashed
	)
	{
		his_strength = 1;
	}

	if (my_strength <= 0)
	{
		my_strength = 1;
	}

	my_roll = LRAND(my_strength);
	his_roll = LRAND(his_strength);
	APORT(g)->next_hit = NORMAL;
	AGUY->ftg += (globals->bashftg / 2);

	if (my_roll < his_roll && !me.perm[KILLER_PERM])
	{
		prfmsg(MSG1543, AGUY->name);
		sprintf(str, getmsg(MSG1545), me.name);
		Message(str, g);
		return;
	}

	MY_PORT->drag_guy = g;
	MY_PORT->dragged = FALSE;

	if (dir != GO)
	{
		MY_PORT->misc = dir - NORTH;
		Moving(1);
	}
	else
	{
		Go_Special(1);
	}

	if (!MY_PORT->dragged)
	{
		prfmsg(MSG1543, AGUY->name);
	}

	MY_PORT->drag_guy = -1;
}
/****************************************************************************
	user is attempting to bash another player
*/
short EXPORT Bash_Guy(short g)
{
	long    my_roll;
	long    his_roll;
	long    my_strength;
	long    his_strength;
	short   success = 0;
	short   floating;

	Perform_Attack(GUY);

	floating = find_timer(FLOAT_TIME, GUY);
	his_strength = (long) AGUY->Str + (long) AGUY->Dex;
	my_strength = (long) me.Str + (long) me.Dex;

	if (APORT(g)->next_hit == VULNERABLE)
	{
		his_strength = his_strength / 2L;
	}

	if (his_strength <= 0)
	{
		his_strength = 1;
	}

	if (my_strength <= 0)
	{
		my_strength = 1;
	}

	if (me.class == BARBARIAN)
	{
		my_strength = my_strength * 2L;
	}

	my_roll = LRAND(my_strength);
	his_roll = LRAND(his_strength);

	if (AGUY->race == OGRE)
	{
		his_roll += (long) his_strength;
	}

	APORT(g)->next_hit = NORMAL;

	if (my_roll > his_roll || me.perm[KILLER_PERM])
	{
		APORT(g)->next_hit = VULNERABLE;

		if (APORT(g)->action_timer < globals->bashtime)
		{
			APORT(g)->action_timer = globals->bashtime;
		}

		success = 1;
		my_roll = LRAND(my_strength / 3L);
		his_roll = LRAND(his_strength);

		if ((my_roll > his_roll || me.perm[KILLER_PERM]) && !floating)
		{
			APORT(g)->bashed = TRUE;
			APORT(g)->bashed_time = globals->bashtime;
			success = 2;
		}
	}

	if (!success)
	{
		prfmsg(M444, AGUY->name);
		sprintf(str, getmsg(MSG475), me.name);
		Message(str, g);
	}
	else if (success == 1)
	{
		if (!floating)
		{
			prfmsg(MSG445, AGUY->name);
			sprintf(str, getmsg(MSG54), me.name);
			Message(str, g);
			sprintf(str, getmsg(MSG55), me.name, AGUY->name);
			Message(str, -(g + 1));
		}
		else
		{
			prfmsg(MSG476, AGUY->name);
			sprintf(str, getmsg(MSG56), me.name);
			Message(str, g);
			sprintf(str, getmsg(MSG57), me.name, AGUY->name);
			Message(str, -(g + 1));
		}
	}
	else
	{
		prfmsg(MSG447, AGUY->name);
		sprintf(str, getmsg(MSG58), me.name);
		Message(str, g);
		sprintf(str, getmsg(MSG59), me.name, AGUY->name);
		Message(str, -(g + 1));
	}

	AGUY->ftg += (globals->bashftg / 2);
	DONE;
}
/****************************************************************************
	user is attacking another player
*/
short Attack_Guy(short g)
{
	short   bonus;
	short   his_ac;
	short   dmg;
	short   roll;
	short   clean_miss = 0;
	short   armor_hit = 0;

	Perform_Attack(GUY);
	his_ac = Calc_Player_AC(AGUY, g, FULL_AC);
	Combat_Bonus(&bonus, WITH_SPELLS);

	if (AGUY->perm[NOHIT_PERM])
	{
		roll = 0;
	}
	else
	{
		roll = Roll_Dice(GUY, bonus);
	}

	if (Flubbed())
	{
		MY_PORT->next_hit = NORMAL;
		BAD_EXIT;
	}

	if (!me.perm[KILLER_PERM])
	{
		if (roll - his_ac < 20 || AGUY->damaged > AGUY->dpts)
		{
			if (RANDOM(2) == 1)
			{
				Entropy();
				armor_hit = TRUE;
			}

			if (RANDOM(2) == 1)
			{
				clean_miss = TRUE;
			}
			else
			{
				if (command == GREATBLOW)
				{
					AGUY->ftg += (globals->gbftg / 2);
				}
				else if (command == HIT)
				{
					AGUY->ftg += (globals->hitftg / 2);
				}
			}

			if (armor_hit)
			{
				prfmsg(M451);
			}
			else if (clean_miss)
			{
				prfmsg(M452);
			}
			else
			{
				prfmsg(M453, AGUY->name);
			}

			APORT(g)->next_hit = NORMAL;
			BAD_EXIT;
		}
	}

	Entropy();

	dmg = Calc_Damage(GUY, bonus);
	if (dmg > AGUY->dpts && !me.perm[KILLER_PERM] && AGUY->dpts > 4)
	{
		dmg = AGUY->dpts;
	}

	APORT(g)->next_hit = NORMAL;
	AGUY->damaged += dmg;

	sprintf(str, getmsg(MSG428), me.name, dmg);
	Message(str, g);
		
	if (me.lw < 0 && me.rw < 0)
	{
		prfmsg(MSG454);
	}

	sprintf(str, getmsg(MSG455), (MLONG) dmg);
	prf(str);

	if (AGUY->damaged <= AGUY->dpts && me.rw >= 0)
	{
		Instilled_Weapons(GUY, me.rw, FALSE);
	}

	if (AGUY->damaged <= AGUY->dpts && me.lw >= 0)
	{
		Instilled_Weapons(GUY, me.lw, FALSE);
	}

	if (AGUY->damaged > AGUY->dpts || me.perm[KILLER_PERM])
	{
		Killed_Guy(g);
		MY_PORT->assassin_timer = ASSASSIN_TIME;
	}
	DONE;
}
/****************************************************************************
	user killed another player
*/
void EXPORT Killed_Guy(short g)
{
	short   addevil;
	short   i;
	short   items = 0;
	char    kill_date[DATE_SIZE];

	prfmsg(MSG459, AGUY->name);

	if (TYPE != ARENA)
	{
		++MY_PORT->murders;
		sprintf(str, getmsg(M477), me.name, AGUY->name);
		Message(str, GLOBAL);
		prfmsg(MSG462, AGUY->name);
	
		for (i = 0; i != NUM_ITEMS; ++i)
		{
			if (AGUY->item[i].what != 0)
			{
				++items;
				Display_Item(&AGUY->item[i]);
				prf(NL);
			}
		}

		if (items == 0)
		{
			prfmsg(M463);
		}

		addevil = numopt(ADDEVIL, -32767, 32767);
		if (addevil)
		{
			prfmsg(M409, addevil);
			me.evil += addevil;
		}

		steal_turf(g);

		TODAY(kill_date);
		sprintf(str, getmsg(MSG708), kill_date, me.name, AGUY->name);
		Write_News(str);
	}
	else
	{
		sprintf(str, getmsg(MSG478), me.name, AGUY->name);
		Message(str, GLOBAL);

		if (APORT(g)->my_bet > AGUY->gold + AGUY->bank)
		{
			APORT(g)->my_bet = AGUY->gold + AGUY->bank;
		}

		sprintf(str, getmsg(MSSG479), APORT(g)->my_bet);
		prf(str);

		if ((double) me.bank + (double) me.gold + (double) APORT(g)->my_bet < GCMAXLONG) 
		{
			if (globals->autobank)
			{
				me.bank += APORT(g)->my_bet;
			}
			else
			{
				me.gold += APORT(g)->my_bet;
			}

			AGUY->gold -= APORT(g)->my_bet;

			if (AGUY->gold < 0)
			{
				AGUY->bank += AGUY->gold;
				AGUY->gold = 0;
			}
		}

		APORT(g)->my_bet = 0;

		TODAY(kill_date);
		sprintf(str, getmsg(MSG709), kill_date, me.name, AGUY->name);
		Write_News(str);
	}

	outprf(MY_PORT->usrnum);
	clrprf();
	Next_User(g);
	Got_Killed(MURDERED);
	Previous_User();
}
