#include <header.h>
#include <globals.h>

/*struct flddef exitFDA[] =
{
	{
		CVTFLD_CHAR,
		SPEC_ARTICLE_SIZE + LABEL_SIZE + DESCRIPTOR_SIZE,
		fldoff(spec_exit_struct, article),
		NULL
	},
	{
		CVTFLD_SHORT,
		5,
		fldoff(spec_exit_struct, type),
		NULL
	},
	{
		CVTFLD_END,
		0,
		0,
		NULL
	}
};
			 
struct flddef roomFDA[] =
{
	{
		CVTFLD_SHORT,
		2,
		fldoff(room_struct, id),
		NULL
	},
	{
		CVTFLD_CHAR,
		DESC_LINES * DESC_SIZE,
		fldoff(room_struct, desc),
		NULL
	},
	{
		CVTFLD_SHORT,
		NUM_EXITS + NUM_EXITS,
		fldoff(room_struct, exit),
		NULL
	},
	{
		CVTFLD_STRUCT,
		1,
		fldoff(room_struct, spec_exit),
		exitFDA
	},
	{
		CVTFLD_SHORT,
		POSSIBLE_MONS + 3,
		fldoff(room_struct, monster_here),
		NULL
	},
	{
		CVTFLD_LONG,
		1,
		fldoff(room_struct, door_index),
		NULL
	},
	{
		CVTFLD_SHORT,
		5,
		fldoff(room_struct, no_teleport),
		NULL
	},
	{
		CVTFLD_CHAR,
		CHANT_SIZE + 1,
		fldoff(room_struct, chant),
		NULL
	},
	{
		CVTFLD_SHORT,
		1,
		fldoff(room_struct, text_file),
		NULL
	},
	{
		CVTFLD_CHAR,
		TEXT_DESCRIPTOR_SIZE + 5 + 51,
		fldoff(room_struct, text_descriptor),
		NULL
	},
	{
		CVTFLD_END,
		0,
		0,
		NULL
	}
};

struct flddef itemFDA[] =
{
	{
		CVTFLD_SHORT,
		2,
		fldoff(item_struct, id),
		NULL
	},
	{
		CVTFLD_CHAR,
		ARTICLE_SIZE + LABEL_SIZE + ITEM_NOUN_SIZE,
		fldoff(item_struct, article),
		NULL
	},
	{
		CVTFLD_SHORT,
		3,
		fldoff(item_struct, what),
		NULL
	},
	{
		CVTFLD_LONG,
		1,
		fldoff(item_struct, uses),
		NULL
	},
	{
		CVTFLD_SHORT,
		2,
		fldoff(item_struct, spell_cast),
		NULL
	},
	{
		CVTFLD_LONG,
		1,
		fldoff(item_struct, bag_index),
		NULL
	},
	{
		CVTFLD_SHORT,
		1,
		fldoff(item_struct, ac),
		NULL
	},
	{
		CVTFLD_LONG,
		1,
		fldoff(item_struct, worth),
		NULL
	},
	{
		CVTFLD_SHORT,
		9,
		fldoff(item_struct, Hits),
		NULL
	},
	{
		CVTFLD_LONG,
		1,
		fldoff(item_struct, old_worth),
		NULL
	},
	{
		CVTFLD_SHORT,
		5,
		fldoff(item_struct, text_file),
		NULL
	},
	{
		CVTFLD_CHAR,
		2,
		fldoff(item_struct, race),
		NULL
	},
	{
		CVTFLD_SHORT,
		7,
		fldoff(item_struct, available),
		NULL
	},
	{
		CVTFLD_END,
		0,
		0,
		NULL
	}
};

struct flddef critFDA[] =
{
	{
		CVTFLD_SHORT,
		3,
		fldoff(crit_struct, what),
		NULL
	},
	{
		CVTFLD_CHAR,
		ARTICLE_SIZE + NAME_LEN + PLURAL_SIZE,
		fldoff(crit_struct, article),
		NULL
	},
	{
		CVTFLD_SHORT,
		8 + POSSIBLE_MON_ITEM,
		fldoff(crit_struct, Level),
		NULL
	},
	{
		CVTFLD_CHAR,
		TALK_SIZE,
		fldoff(crit_struct, talk),
		NULL
	},
	{
		CVTFLD_SHORT,
		6,
		fldoff(crit_struct, hit_vector),
		NULL
	},
	{
		CVTFLD_LONG,
		1,
		fldoff(crit_struct, last_kill),
		NULL
	},
	{
		CVTFLD_SHORT,
		4,
		fldoff(crit_struct, kills),
		NULL
	},
	{
		CVTFLD_LONG,
		1,
		fldoff(crit_struct, perm_damage),
		NULL
	},
	{
		CVTFLD_SHORT,
		7,
		fldoff(crit_struct, available),
		NULL
	},
	{
		CVTFLD_END,
		0,
		0,
		NULL
	}
};*/

/****************************************************************************
	view some info about a particular player
*/
void EXPORT Who_Is(void)
{
	short   lev;
	MLONG   total;
	short   index = -1;
	short   found = FALSE;
	short   read_result;
	char    last_date[DATE_SIZE];
	FILE    *fp_brief;
	struct  brief_char_struct brief;

	fp_brief = fopen(CHAOS_NAME_FILE, RDWR);
	
	do
	{
		read_result = fread(&brief, BRIEF_CHAR_SIZE, 1, fp_brief);
		++index;

		if 
		(
			read_result == 1 &&
			!sameas(brief.name, BLANK_RECORD) &&
			(sameto(margv[1], brief.name) || sameto(margv[1], brief.Userid))
		)
		{
			Read_A_Char(index, &a_char);
			found = TRUE;

			prfmsg(MSG188, a_char.name, a_char.title);

			if (a_char.race == ELF)
			{
				prfmsg(MSG189);
			}
			else if (a_char.race == DWARF)
			{
				prfmsg(MSG190);
			}
			else if (a_char.race == HUMAN)
			{
				prfmsg(MSG191);
			}
			else if (a_char.race == OGRE)
			{
				prfmsg(MSG192);
			}
			else if (a_char.race == HALFLING)
			{
				prfmsg(MSG193);
			}

			if (a_char.outlaw == 'Y')
			{
				prfmsg(MSG1285);
			}

			if (a_char.class == WARRIOR)
			{
				prfmsg(MSG194);
			}
			else if (a_char.class == SORCERER)
			{
				prfmsg(MSG195);
			}
			else if (a_char.class == BARBARIAN)
			{
				prfmsg(MSG196);
			}
			else if (a_char.class == THIEF)
			{
				prfmsg(MSG197);
			}
			else if (a_char.class == DUELIST)
			{
				prfmsg(MSG198);
			}
			else if (a_char.class == CLERIC)
			{
				prfmsg(MSG199);
			}
			else if (a_char.class == MYSTIC)
			{
				prfmsg(MSG200);
			}

			if (a_char.guild_master)
			{
				prfmsg(MSG990, a_char.in_guild);
			}
			else if (a_char.in_guild)
			{
				prfmsg(MSG991, a_char.in_guild);  
			}
 
			CONV_DATE(last_date, a_char.last_date);
			sprintf(str, getmsg(MSSG992), last_date, a_char.secs_today / 60);
			prf(str);

			prfmsg(MSG993, a_char.Userid);
				
			total = a_char.Psy;
			total += a_char.Int;
			total += a_char.Str;
			total += a_char.Dex;
			total += a_char.Con;
			total = total / 5;
			lev = (short) total;
			lev = Stat_Lev(lev);
			prfmsg(MSG994, lev);
		}
	}
	while (read_result == 1);

	fclose(fp_brief);

	if (!found)
	{
		prfmsg(M920, margv[1]);
	}
}
/****************************************************************************
	create a data file
*/
void EXPORT Create_New(char *path)
{
	FILE    *fp;

	fp = fopen(path, "a+b");
	fclose(fp);
}
/****************************************************************************
	display a custom text file
*/
short Print_Text_File(char *type, short index)
{
	short   done = FALSE;
	char    *read_result;
	char    txt[LINE_LEN];
	FILE    *fp;

	sprintf(globals->path, "%s\\%s%d.TXT", globals->textdir, type, index);
	fp = fopen(globals->path, READONLY);

	if (fp == NULL)
	{
		prfmsg(MSG1380, globals->path);
		sprintf(str, "Can't find %s", globals->path);
		NOTIFY(str);
		BAD_EXIT;
	}
	
	do
	{
		read_result = fgets(txt, 1000, fp);
	
		if (read_result != NULL)
		{
			prfmsg(MSG1384, txt);
		}
		else
		{
			done = TRUE;
		}
	}
	while (!done);

	fclose(fp);
	DONE;
}
/****************************************************************************
	init the non-static Chaos data files
*/
void Init_Data_Files(void)
{
/*
	short   n;       
	FILE    *fp;
	FILE    *new_fp;    
	char    buf[701];

	unlink(ITEM_FILE);
	Create_New(ITEM_FILE);
	fp = fopen("/wgservd/muichaos/data/itemfile.dat", READB);
	new_fp = fopen(ITEM_FILE, "a+b");

	do
	{
		n = fread(buf, 111, 1, fp);

		if (n == 1)
		{
			cvtData
			(
				buf,
				&item,
				111,
				itemFDA,
				CVTPACKED,
				CVTSERVER,
				CHAN_NUL
			);
			fwrite(&item, ITEMSIZE, 1, new_fp);
		}
	}
	while (n == 1);

	fclose(new_fp);
	fclose(fp);

	unlink(MONSTER_FILE);
	Create_New(MONSTER_FILE);
	fp = fopen("/wgservd/muichaos/data/critfile.dat", READB);
	new_fp = fopen(MONSTER_FILE, "a+b");

	do
	{
		n = fread(buf, 188, 1, fp);

		if (n == 1)
		{
			cvtData
			(
				buf,
				&crit,
				188,
				critFDA,
				CVTPACKED,
				CVTSERVER,
				CHAN_NUL
			);
			fwrite(&crit, CRIT_SIZE, 1, new_fp);
		}
	}
	while (n == 1);

	fclose(new_fp);
	fclose(fp);

	unlink(ROOM_FILE);
	Create_New(ROOM_FILE);
	fp = fopen("/wgservd/muichaos/data/roomfile.dat", READB);
	new_fp = fopen(ROOM_FILE, "a+b");

	do
	{
		n = fread(buf, 701, 1, fp);

		if (n == 1)
		{
			cvtData
			(
				buf,
				&a_room,
				701,
				roomFDA,
				CVTPACKED,
				CVTSERVER,
				CHAN_NUL
			);
			fwrite(&a_room, ROOMSIZE, 1, new_fp);
		}
	}
	while (n == 1);

	fclose(new_fp);
	fclose(fp);
*/

	Create_New(ROOM2_FILE);
	Create_New(CHAOS_USER_FILE);
	Create_New(CHAOS_NAME_FILE);
	Create_New(VOTE_FILE);
	Create_New(CHAOS_FAME);
	Create_New(CHAOS_MACRO_FILE);
	Create_New(NEWS_FILE);
	Create_New(CLOSET_FILE);    
	Create_New(PUBLIC_FORUM);     
	Create_New(GUILD_FILE);     
	Create_New(CHAOS_DAYFILE);     
	mkdir(BAG_PATH); 
	mkdir(GUILD_FORUM_PATH);
	mkdir(ROOM_ITEM_PATH);
}
/****************************************************************************
	open the Chaos data files
*/
void Open_Data_Files(void)
{
		
	if (ynopt(UPDATES))
	{
		fp_item = fopen(TEMP_ITEM_FILE, RDWR);

		if (fp_item != NULL)
		{
			fclose(fp_item);
			unlink(ITEM_FILE);
			unlink(ROOM_FILE);
			unlink(MONSTER_FILE);
		}
	}

	fp_item = fopen(ITEM_FILE, RDWR);

	if (fp_item == NULL)
	{
		Create_New(ROOM_FILE);
		Create_New(ITEM_FILE);
		Create_New(MONSTER_FILE);

		Copy_Static_Data();

		fp_item = fopen(ITEM_FILE, RDWR);
		fp_crit = fopen(MONSTER_FILE, RDWR);
		fp_room = fopen(ROOM_FILE, RDWR);
	}
	else
	{  
		fclose(fp_item);
		unlink(TEMP_MONSTER_FILE);
		unlink(TEMP_ITEM_FILE);
		unlink(TEMP_ROOM_FILE);
		
		fp_item = fopen(ITEM_FILE, RDWR);
		fp_crit = fopen(MONSTER_FILE, RDWR);
		fp_room = fopen(ROOM_FILE, RDWR);
	}

	fp_room2 = fopen(ROOM2_FILE, RDWR);
	
	if 
	(
		fp_item == NULL || 
		fp_crit == NULL || 
		fp_room == NULL || 
		fp_room2 == NULL
	)
	{
		NOTIFY("File Open Failed!");
	}
}
/****************************************************************************
	Close the data files
*/
void Close_Data_Files(void)
{

	fclose(fp_item);
	fclose(fp_room);
	fclose(fp_room2);
	fclose(fp_crit);
	Write_Guild_Stuff();
}
/****************************************************************************
	sort the spell_info structure (get the spells in the correct indexed
	order - they are listed in order of desireability in the header file.
*/
void Sort_Spell_Info(void)
{
	short   m;
	short   i;
	short   s1;
	short   s2;
	struct  spell_info_struct temp;

	for (s1 = 0; s1 != NUM_SPELLS; ++s1)
	{
		for (s2 = 0; s2 != NUM_SPELLS; ++s2)
		{
			if (spell_info[s1].index < spell_info[s2].index)
			{
				temp = spell_info[s1];
				spell_info[s1] = spell_info[s2];
				spell_info[s2] = temp;
			}
		}
	}

	for (m = 1; m != MAX_MONSTER; ++m)
	{
		lsk = (MLONG) m * CRIT_SIZE;
		fseek(fp_crit, lsk, TOP);
		fread(&crit, CRIT_SIZE, 1, fp_crit);

		for (i = 0; i != POSSIBLE_MON_ITEM; ++i)
		{
			if (crit.Item[i])
			{
				lsk = (MLONG) crit.Item[i] * ITEMSIZE;
				fseek(fp_item, lsk, TOP);
				fread(&item, ITEMSIZE, 1, fp_item);
			
				if (item.which == SCROLL)
				{
					spell_info[item.spell_cast].power = crit.Level;
				}
			}
		}
	}
		
	if (numopt(EXHAUSTY, -32767, 32767))
	{
		spell_info[EXHAUSTION].power = numopt(EXHAUSTY, -32767, 32767);
	}

	if (numopt(VIGORY, -32767, 32767))
	{
		spell_info[VIGOR].power = numopt(VIGORY, -32767, 32767);
	}
	
	if (numopt(LANGOURY, -32767, 32767))
	{
		spell_info[LANGOUR].power = numopt(LANGOURY, -32767, 32767);
	}
	
	if (numopt(HEALY, -32767, 32767))
	{
		spell_info[HEAL].power = numopt(HEALY, -32767, 32767);
	}
	
	if (numopt(SLEEPY, -32767, 32767))
	{
		spell_info[SLEEP].power = numopt(SLEEPY, -32767, 32767);
	}
	
	if (numopt(FEARY, -32767, 32767))
	{
		spell_info[FEAR].power = numopt(FEARY, -32767, 32767);
	}
	
	if (numopt(INVISIBY, -32767, 32767))
	{
		spell_info[INVISIBILITY].power = numopt(INVISIBY, -32767, 32767);
	}
	
	if (numopt(PURIFYY, -32767, 32767))
	{
		spell_info[PURIFY].power = numopt(PURIFYY, -32767, 32767);
	}
	
	if (numopt(ENCHANTY, -32767, 32767))
	{
		spell_info[ENCHANT].power = numopt(ENCHANTY, -32767, 32767);
	}
	
	if (numopt(MESMERIY, -32767, 32767))
	{
		spell_info[MESMERIZE].power = numopt(MESMERIY, -32767, 32767);
	}
	
	if (numopt(ELICITY, -32767, 32767))
	{
		spell_info[ELICITATION].power = numopt(ELICITY, -32767, 32767);
	}
	
	if (numopt(ALCHEMYY, -32767, 32767))
	{
		spell_info[ALCHEMY].power = numopt(ALCHEMYY, -32767, 32767);
	}

	if (numopt(PASSDORY, -32767, 32767))
	{
		spell_info[PASS_DOOR].power = numopt(PASSDORY, -32767, 32767);
	}
	
	if (numopt(KEYY, -32767, 32767))
	{
		spell_info[KEY].power = numopt(KEYY, -32767, 32767);
	}
	
	if (numopt(MAGKEYY, -32767, 32767))
	{
		spell_info[MAGIC_KEY].power = numopt(MAGKEYY, -32767, 32767);
	}
	
	if (numopt(TELEPORY, -32767, 32767))
	{
		spell_info[TELEPORT].power = numopt(TELEPORY, -32767, 32767);
	}
	
	if (numopt(RESTOREY, -32767, 32767))
	{
		spell_info[RESTORE].power = numopt(RESTOREY, -32767, 32767);
	}
	
	if (numopt(PROTECTY, -32767, 32767))
	{
		spell_info[PROTECT].power = numopt(PROTECTY, -32767, 32767);
	}
	
	if (numopt(LIGHTNIY, -32767, 32767))
	{
		spell_info[LIGHTNING].power = numopt(LIGHTNIY, -32767, 32767);
	}
	
	if (numopt(LEVITATY, -32767, 32767))
	{
		spell_info[LEVITATE].power = numopt(LEVITATY, -32767, 32767);
	}
	
	if (numopt(VISIONY, -32767, 32767))
	{
		spell_info[VISION].power = numopt(VISIONY, -32767, 32767);
	}
	
	if (numopt(BLASTY, -32767, 32767))
	{
		spell_info[BLAST].power = numopt(BLASTY, -32767, 32767);
	}
	
	if (numopt(SHOCKY, -32767, 32767))
	{
		spell_info[SHOCKWAVE].power = numopt(SHOCKY, -32767, 32767);
	}

	if (numopt(SEEKY, -32767, 32767))
	{
		spell_info[SEEK].power = numopt(SEEKY, -32767, 32767);
	}
	
	if (numopt(INVULNEY, -32767, 32767))
	{
		spell_info[INVULNERABILITY].power = numopt(INVULNEY, -32767, 32767);
	}
	
	if (numopt(STRENGTY, -32767, 32767))
	{
		spell_info[STRENGTH].power = numopt(STRENGTY, -32767, 32767);
	}
	
	if (numopt(CIRCLEY, -32767, 32767))
	{
		spell_info[MAGIC_CIRCLE].power = numopt(CIRCLEY, -32767, 32767);
	}
	
	if (numopt(STURDINY, -32767, 32767))
	{
		spell_info[STURDINESS].power = numopt(STURDINY, -32767, 32767);
	}
	
	if (numopt(ENHANCEY, -32767, 32767))
	{
		spell_info[ENHANCE].power = numopt(ENHANCEY, -32767, 32767);
	}
	
	if (numopt(WEAKNESY, -32767, 32767))
	{
		spell_info[WEAKNESS].power = numopt(WEAKNESY, -32767, 32767);
	}
	
	if (numopt(BRINGY, -32767, 32767))
	{
		spell_info[BRING].power = numopt(BRINGY, -32767, 32767);
	}
	
	if (numopt(SHIELDY, -32767, 32767))
	{
		spell_info[MAGIC_SHIELD].power = numopt(SHIELDY, -32767, 32767);
	}
	
	if (numopt(DISPELY, -32767, 32767))
	{
		spell_info[DISPEL_MAGIC].power = numopt(DISPELY, -32767, 32767);
	}
	
	if (numopt(RETURNY, -32767, 32767))
	{
		spell_info[SAFE_RETURN].power = numopt(RETURNY, -32767, 32767);
	}
	
	if (numopt(SEEINVIY, -32767, 32767))
	{
		spell_info[SEE_INVISIBLE].power = numopt(SEEINVIY, -32767, 32767);
	}
	
	if (numopt(SUMMONY, -32767, 32767))
	{
		spell_info[SUMMON].power = numopt(SUMMONY, -32767, 32767);
	}
	
	if (numopt(HASTEY, -32767, 32767))
	{
		spell_info[HASTE].power = numopt(HASTEY, -32767, 32767);
	}
	
	if (numopt(STEALTHY, -32767, 32767))
	{
		spell_info[STEALTH].power = numopt(STEALTHY, -32767, 32767);
	}
	
	if (numopt(AGGRAVAY, -32767, 32767))
	{
		spell_info[AGGRAVATE].power = numopt(AGGRAVAY, -32767, 32767);
	}
	
	if (numopt(MANIAY, -32767, 32767))
	{
		spell_info[MANIA].power = numopt(MANIAY, -32767, 32767);
	}
	
	if (numopt(SPYY, -32767, 32767))
	{
		spell_info[SPY].power = numopt(SPYY, -32767, 32767);
	}
	
	if (numopt(REVEALY, -32767, 32767))
	{
		spell_info[REVEAL].power = numopt(REVEALY, -32767, 32767);
	}
	
	if (numopt(CURSEY, -32767, 32767))
	{
		spell_info[CURSE].power = numopt(CURSEY, -32767, 32767);
	}
	
	if (numopt(FIREBALY, -32767, 32767))
	{
		spell_info[FIREBALL].power = numopt(FIREBALY, -32767, 32767);
	}
	
	if (numopt(EXHAUSTY, -32767, 32767))
	{
		spell_info[EXHAUSTION].power = numopt(EXHAUSTY, -32767, 32767);
	}

	spell_info[STRENGTH].dur        = numopt(STRENGTX, -32767, 32767);
	spell_info[AGGRAVATE].dur       = numopt(AGGRAVAX, -32767, 32767);
	spell_info[MAGIC_CIRCLE].dur    = numopt(CIRCLEX, -32767, 32767);
	spell_info[ENCHANT].dur         = numopt(ENCHANTX, -32767, 32767);
	spell_info[PROTECT].dur         = numopt(PROTECTX, -32767, 32767);
	spell_info[LEVITATE].dur        = numopt(LEVITATX, -32767, 32767);
	spell_info[ENHANCE].dur         = numopt(ENHANCEX, -32767, 32767);
	spell_info[SUMMON].dur          = numopt(SUMMONX, -32767, 32767);
	spell_info[STEALTH].dur         = numopt(STEALTHX, -32767, 32767);
	spell_info[HEAL].dur            = numopt(HEALX, -32767, 32767);
	spell_info[SEE_INVISIBLE].dur   = numopt(SEEINVIX, -32767, 32767);
	spell_info[INVULNERABILITY].dur = numopt(INVULNEX, -32767, 32767);
	spell_info[STURDINESS].dur      = numopt(STURDINX, -32767, 32767);
	spell_info[SLEEP].dur           = numopt(SLEEPX, -32767, 32767);
	spell_info[LIGHTNING].dur       = numopt(LIGHTNIX, -32767, 32767);
	spell_info[LANGOUR].dur         = numopt(LANGOURX, -32767, 32767);
	spell_info[MANIA].dur           = numopt(MANIAX, -32767, 32767);
	spell_info[MAGIC_SHIELD].dur    = numopt(SHIELDX, -32767, 32767);
	spell_info[VIGOR].dur           = numopt(VIGORX, -32767, 32767);
	spell_info[BLAST].dur           = numopt(BLASTX, -32767, 32767);
	spell_info[SHOCKWAVE].dur      = numopt(SHOCKX, -32767, 32767);
	spell_info[FIREBALL].dur        = numopt(FIREBALX, -32767, 32767); 
	spell_info[HASTE].dur           = numopt(HASTEX, -32767, 32767);
	spell_info[RESTORE].dur         = numopt(RESTOREX, -32767, 32767);
	spell_info[INVISIBILITY].dur    = numopt(INVISIBX, -32767, 32767);
	spell_info[MESMERIZE].dur       = numopt(MESMERIX, -32767, 32767);
	spell_info[WEAKNESS].dur        = numopt(WEAKNESX, -32767, 32767);
	spell_info[EXHAUSTION].dur      = numopt(EXHAUSTX, -32767, 32767);
}
/****************************************************************************
	remove inactive characters
*/
void Clear_Old_Characters(void)
{
	short   cur_days = cofdat(today());
	short   index = -1;
	short   n;
	short   done = FALSE;
	struct  brief_char_struct brief;
	short   in_guild;
	short   master;
	short   i;
	FILE    *fp_brief;
	char    name[NAME_LEN];

	do
	{
		++index;
		fp_brief = fopen(CHAOS_NAME_FILE, RDWR);
		lsk = (MLONG) index * BRIEF_CHAR_SIZE;
		fseek(fp_brief, lsk, TOP);
		n = fread(&brief, BRIEF_CHAR_SIZE, 1, fp_brief);
		fclose(fp_brief);

		if (n == 0)
		{
			done = TRUE;
		}
		else if (!sameas(brief.name, BLANK_RECORD))
		{
			if (cur_days - cofdat(brief.last_date) >= globals->inactdys)
			{
				Read_A_Char(index, &a_char);
				strcpy(name, a_char.name);
				in_guild = a_char.in_guild;
				master = a_char.guild_master;

				for (i = 0; i != NUM_ITEMS; ++i)
				{
					if (a_char.item[i].what == CONTAINER)
					{
						Kill_Container(&a_char.item[i]);
					}
				}

				Read_Closet(index, a_closet);
		
				for (i = 0; i != NUM_ITEMS; ++i)
				{
					if (a_closet->item[i].what == CONTAINER)
					{
						Kill_Container(&a_closet->item[i]);
					}
				}
		
				setmem(a_closet, CLOSET_SIZE, 0);
				Write_Closet(index, a_closet);
				Erase_Macros(index);
				Erase_Mail(index);
				Erase_Votes(index);
				strcpy(a_char.name, BLANK_RECORD);
				Write_A_Char(index, &a_char);

				if (master)
				{
					Guild_Master_Died(name, in_guild);
				}
			}  
		}
	}
	while (!done);
}
/****************************************************************************
	copy in the static data files
*/
short Copy_Static_Data(void)
{
	short   done;
	short   n;
	FILE    *fp;

	NOTIFY("INSTALLING ITEMS");
	
	Create_New(ITEM_FILE);

	fp_item = fopen(TEMP_ITEM_FILE, RDWR);
	fp = fopen(ITEM_FILE, APPEND);

	if (fp_item == NULL || fp == NULL)
	{
		NOTIFY("NO ITEMS TO INSTALL!");
		BAD_EXIT;
	}

	done = FALSE;
	globals->maxitem = 0;
	
	do
	{
		n = fread(&item, ITEMSIZE, 1, fp_item);

		if (n == 1)
		{
			++globals->maxitem;
			fwrite(&item, ITEMSIZE, 1, fp);
		}
		else
		{
			done = TRUE;
		}
	}
	while (!done);

	fclose(fp);
	fclose(fp_item);
	unlink(TEMP_ITEM_FILE);

	--globals->maxitem;
	msgscan(MSG_FILE, ITEM_CNF); 
	sprintf(str, "%d", globals->maxitem);
	setcnf(ITEM_CNF, str);
	applyem(MSG_FILE);

	NOTIFY("INSTALLING ROOMS");
	
	Create_New(ROOM_FILE);
	
	fp_room = fopen(TEMP_ROOM_FILE, RDWR);
	fp = fopen(ROOM_FILE, APPEND);

	if (fp_room == NULL || fp == NULL)
	{
		NOTIFY("NO ROOMS TO INSTALL!");
		BAD_EXIT;
	}

	done = FALSE;
	globals->maxroom = 0;
	
	do
	{
		n = fread(&a_room, ROOMSIZE, 1, fp_room);
		a_room.sticky_fix = FALSE;

		if (n == 1)
		{
			++globals->maxroom;
			fwrite(&a_room, ROOMSIZE, 1, fp);
		}
		else
		{
			done = TRUE;
		}
	}
	while (!done);

	fclose(fp);
	fclose(fp_room);
	unlink(TEMP_ROOM_FILE);
	
	--globals->maxroom;
	msgscan(MSG_FILE, ROOM_CNF); 
	sprintf(str, "%d", globals->maxroom);
	setcnf(ROOM_CNF, str);
	applyem(MSG_FILE);

	NOTIFY("INSTALLING MONSTERS");
	
	Create_New(MONSTER_FILE);
	
	fp_crit = fopen(TEMP_MONSTER_FILE, RDWR);
	fp = fopen(MONSTER_FILE, APPEND);

	if (fp_crit == NULL || fp == NULL)
	{
		NOTIFY("NO MONSTERS TO INSTALL!");
		BAD_EXIT;
	}

	done = FALSE;
	globals->maxmon = 0;

	do
	{
		n = fread(&crit, CRIT_SIZE, 1, fp_crit);

		if (n == 1)
		{
			++globals->maxmon;
			fwrite(&crit, CRIT_SIZE, 1, fp);
		}
		else
		{
			done = TRUE;
		}
	}
	while (!done);

	fclose(fp);
	fclose(fp_crit);
	unlink(TEMP_MONSTER_FILE);
	
	--globals->maxmon;
	msgscan(MSG_FILE, MON_CNF); 
	sprintf(str, "%d", globals->maxmon);
	setcnf(MON_CNF, str);
	applyem(MSG_FILE);

	DONE;
}
/*****************************************************************************
	find my user record
*/
short Find_A_Char(struct charstruct *some_char, char *name)
{
	short   index;
	struct  brief_char_struct brief;
	
	index = Find_Name_Index(name, &brief);

	if (index >= 0)
	{
		Read_A_Char(index, some_char);
	}
	else
	{
		index = -1;
	}

	return (index);
}
/*****************************************************************************
   adds my character to user file
*/
void Add_Guy(struct charstruct *guy)
{
	short   n;
	short   add_flag;
	short   index = -1;
	FILE    *fp;
	FILE    *fp_macro;
	FILE    *fp_user;
	FILE    *fp_brief;
	struct  brief_char_struct brief;

	fp_brief = fopen(CHAOS_NAME_FILE, RDWR);

	do
	{
		n = fread(&brief, BRIEF_CHAR_SIZE, 1, fp_brief);
		++index;
	}
	while (n && !sameas(brief.name, BLANK_RECORD));

	fclose(fp_brief);

	if (n)
	{
		fp_user = fopen(CHAOS_USER_FILE, RDWR);
		lsk = (MLONG) index * CHAR_SIZE;
		fseek(fp_user, lsk, TOP);
		fwrite(guy, CHAR_SIZE, 1, fp_user);
		fclose(fp_user);
		add_flag = FALSE;

		setmem(a_closet, CLOSET_SIZE, 0);
		Write_Closet(index, a_closet);

		Write_Macros(index, macros[NTERMS]);
	}
	else
	{
		fp_user = fopen(CHAOS_USER_FILE, APPEND);
		fwrite(guy, CHAR_SIZE, 1, fp_user);
		fclose(fp_user);
 
		add_flag = TRUE;

		setmem(a_closet, CLOSET_SIZE, 0);
		fp = fopen(CLOSET_FILE, APPEND);
		fwrite(a_closet, CLOSET_SIZE, 1, fp);
		fclose(fp);

		fp_macro = fopen(CHAOS_MACRO_FILE, APPEND);
		fwrite(macros[NTERMS], MACRO_SIZE, 1, fp_macro);
		fclose(fp_macro);
	}

	Write_Username(guy, index, add_flag);
}
/*****************************************************************************
   writes my character out to user file
*/
void Write_My_Rec(short option)
{
	short   index;
	FILE    *fp_user;

	index = MY_PORT->index;
	fp_user = fopen(CHAOS_USER_FILE, RDWR);
	lsk = (MLONG) index * CHAR_SIZE;
	fseek(fp_user, lsk, TOP);

	if (option == SUICIDE)
	{
		strcpy(me.name, BLANK_RECORD);
	}

	fwrite(&me, CHAR_SIZE, 1, fp_user);
	fclose(fp_user);

	Write_Username(&me, index, FALSE);
}
/*****************************************************************************
   write a character out to userfile (called by the server)
*/
void Write_Him(short g)
{

	if (APORT(g)->index >= 0)
	{
		Write_A_Char(APORT(g)->index, AGUY);
	}
}
/******************************************************************************
	find the requested user name
*/
short Find_Name_Index(char *name, struct brief_char_struct *brief)
{
	short   index = -1;
	short   read_result;
	FILE    *fp_brief;

	fp_brief = fopen(CHAOS_NAME_FILE, RDWR);

	if (name != NULL)
	{
		do
		{
			read_result = fread(brief, BRIEF_CHAR_SIZE, 1, fp_brief);
			++index;
		}
		while (read_result && !sameas(brief->name, name));
	}
	else
	{
		do
		{
			read_result = fread(brief, BRIEF_CHAR_SIZE, 1, fp_brief);
			++index;
		}
		while 
		(
			read_result && 
			(
				!sameas(brief->Userid, userid) ||
				sameas(brief->name, BLANK_RECORD)
			)
		);
	}

	fclose(fp_brief);

	if (read_result)
	{
		return (index);
	}
	else
	{
		return (-1);
	}
}
/****************************************************************************
	write the username file
*/
void Write_Username(struct charstruct *guy, short index, short add_flag)
{
	FILE    *fp_brief;
	struct  brief_char_struct brief;
	
	setmem(&brief, BRIEF_CHAR_SIZE, 0);

	strcpy(brief.name,   guy->name);
	strcpy(brief.Userid, guy->Userid);
	brief.in_guild      = guy->in_guild;
	brief.guild_master  = guy->guild_master;
	brief.guild_balance = guy->guild_balance;
	brief.last_date     = guy->last_date;

	if (!add_flag)
	{
		fp_brief = fopen(CHAOS_NAME_FILE, RDWR);
		lsk = (MLONG) index * BRIEF_CHAR_SIZE;
		fseek(fp_brief, lsk, TOP);
		fwrite(&brief, BRIEF_CHAR_SIZE, 1, fp_brief);
		fclose(fp_brief);
	}
	else
	{
		fp_brief = fopen(CHAOS_NAME_FILE, APPEND);
		fwrite(&brief, BRIEF_CHAR_SIZE, 1, fp_brief);
		fclose(fp_brief);
	}
}
/*****************************************************************************
	read a user record
*/
void Read_A_Char(short index, struct charstruct *some_char)
{
	FILE    *fp_user;

	fp_user = fopen(CHAOS_USER_FILE, RDWR);
	lsk = (MLONG) index * CHAR_SIZE;
	fseek(fp_user, lsk, TOP);
	fread(some_char, CHAR_SIZE, 1, fp_user);
	fclose(fp_user);
}
/*****************************************************************************
   write a character out to the main user file
*/
void Write_A_Char(short index, struct charstruct *some_char)
{
	FILE    *fp_user;

	fp_user = fopen(CHAOS_USER_FILE, RDWR);
	lsk = (MLONG) index * CHAR_SIZE;
	fseek(fp_user, lsk, TOP);
	fwrite(some_char, CHAR_SIZE, 1, fp_user);
	fclose(fp_user);

	Write_Username(some_char, index, FALSE);
}
/****************************************************************************
	display sysops
*/
void List_Sysops(void)
{
	short   i;
	short   n;
	short   has_permits;
	FILE    *fp_user;

	prf(NL);
	fp_user = fopen(CHAOS_USER_FILE, RDWR);

	do
	{
		n = fread(&a_char, CHAR_SIZE, 1, fp_user);

		if (n == 1 && !sameas(a_char.name, BLANK_RECORD))
		{
			for (i = has_permits = 0; i != NUM_PERMS; ++i)
			{
				if (a_char.perm[i])
				{
					has_permits = TRUE;
				}
			}
			
			if (has_permits)
			{
				prfmsg(MSG1213, a_char.name, a_char.Userid);
			}
		}
	}
	while (n == 1);

	fclose(fp_user);
}
/*****************************************************************************
	put new entry in the news of the realm
*/
short Write_News(char *news)
{
	short   i;
	short   n;
	FILE    *fp;
	struct  news_struct old[22];

	if (P != -1 && me.perm[GAMEOP_PERM] && !ynopt(SYSNEWS))
	{
		BAD_EXIT;
	}

	setmem(old, (NEWS_SIZE * 22), 0);

	fp = fopen(NEWS_FILE, RDWR);

	if (fp == NULL)
	{
		NOTIFY("NEWS FILE OPEN FAILED!");
		BAD_EXIT;
	}

	n = fread(old, NEWS_SIZE, 22, fp);

	if (n != 22)
	{
		fclose(fp);
		fp = fopen(NEWS_FILE, APPEND);
	}

	for (i = 20; i >= 0; --i)
	{
		strcpy(old[i + 1].news, old[i].news);
	}

	fseek(fp, 0, TOP);
	strcpy(old[0].news, news);
	fwrite(old, NEWS_SIZE, 22, fp);
	fclose(fp);
	DONE;
}
/****************************************************************************
	initialize permanant monster segment
*/
void Init_Perm_Mon(void)
{
	short   last_ok_mon = 0;
	short   done = FALSE;
	short   i;
	short   n;
	short   index = 0;

	for (i = 0; i != MAX_PERM_MON; ++i)
	{
		if (globals->perm_mon_id[i] != globals->rover)
		{
			globals->perm_mon_loc[i] = 0;
			globals->perm_mon_id[i] = 0;
			globals->perm_mon_dmg[i] = 0;
		}
	}

	lsk = CRIT_SIZE;
	fseek(fp_crit, lsk, TOP);

	for (i = 1; i != MAX_MONSTER && !done; ++i)
	{
		n = fread(&crit, CRIT_SIZE, 1, fp_crit);

		if (n == 1)
		{
			if 
			(
				index != MAX_PERM_MON &&
				globals->perm_mon_id[index] == globals->rover
			)
			{
				++index;
			}

			last_ok_mon = crit.which;

			if (crit.loc && crit.permanant && i != globals->rover)
			{
				if (index == MAX_PERM_MON)
				{
					NOTIFY("TOO MANY PERM MONS");
				}
				else
				{
					if (!crit.roving)
					{
						globals->perm_mon_loc[index] = crit.loc;
					}
					else
					{
						if (crit.static_rover)
						{
							globals->perm_mon_loc[index] = -(crit.loc);
						}
						else
						{
							n = -(Find_Non_Town_Room());
							globals->perm_mon_loc[index] = n;
						}
					}

					globals->perm_mon_id[index] = crit.which;
					++index;
				}
			}
		}
		else
		{
			done = TRUE;
		}
	}

	if (last_ok_mon < globals->maxmon)
	{
		sprintf(str, "ADDING %d MONSTERS", globals->maxmon - last_ok_mon);
		NOTIFY(str);

		setmem(&crit, CRIT_SIZE, 0);
		crit.what = NPC;
		strcpy(crit.article, "a");
		strcpy(crit.plural_name, "nobodies");
		crit.Level = 1;
		crit.alg = TRUE;
	 
		fclose(fp_crit);
		fp_crit = fopen(MONSTER_FILE, APPEND);

		if (last_ok_mon == 0)
		{
			last_ok_mon = -1;
		}

		for (i = last_ok_mon + 1; i != MAX_MONSTER; ++i)
		{
			crit.which = i;

			if (i == 0)
			{
				strcpy(crit.name, DATA3);
			}
			else
			{
				strcpy(crit.name, "nobody");
			}

			fwrite(&crit, CRIT_SIZE, 1, fp_crit);
		}

		fclose(fp_crit);
		fp_crit = fopen(MONSTER_FILE, RDWR);
	}
}
/****************************************************************************
	initialize items
*/
void Init_Items(void)
{
	short   index = 0;
	short   i;
	short   done;
	short   n;
	short   last_ok_item = 0;

	for (i = 0; i != MAX_PERM_ITEM; ++i)
	{
		globals->perm_item_loc[i] = 0;
		globals->perm_item_id[i] = 0;
	}

	fseek(fp_item, 0, TOP);

	for (i = done = 0; i != MAX_ITEM && !done; ++i)
	{
		n = fread(&item, ITEMSIZE, 1, fp_item);

		if (n == 1)
		{
			last_ok_item = i;
			
			if (item.what == CONTAINER)
			{
				Init_Free_Bag(&item);
			}

			if (item.permanant)
			{
				if (index == MAX_PERM_ITEM)
				{
					NOTIFY("TOO MANY PERM ITEMS");
				}
				else
				{
					if (item.room == 0)
					{
						globals->perm_item_loc[index] = RANDOM(globals->maxroom);
					}
					else
					{
						globals->perm_item_loc[index] = item.room;
					}

					globals->perm_item_id[index] = item.id;
					++index;
				}
			}
		}
		else
		{
			done = TRUE;
		}
	}

	if (last_ok_item < globals->maxitem)
	{
		sprintf(str, "ADDING %d ITEMS", globals->maxitem - last_ok_item);
		NOTIFY(str);
  
		setmem(&item, ITEMSIZE, 0);
		strcpy(item.article, "a");
		strcpy(item.adjective, "big");
		strcpy(item.name, "nothing");
		item.what = TRINKET;

		fclose(fp_item);
		fp_item = fopen(ITEM_FILE, APPEND);
		
		if (last_ok_item == 0)
		{
			last_ok_item = -1;
		}

		for (i = last_ok_item + 1; i != MAX_ITEM; ++i)
		{
			item.id = i;
			
			if (i == 0)
			{
				strcpy(item.name, DATA3);
			}
			else
			{
				strcpy(item.name, "nothing");
			}

			fwrite(&item, ITEMSIZE, 1, fp_item);
		}

		fclose(fp_item);
		fp_item = fopen(ITEM_FILE, RDWR);
	}
}
/****************************************************************************
	initialize misc room data segment
*/
void Init_Rooms(void)
{
	short   i;
	short   done;
	short   n;
	short   last_ok_room = 0;

	fseek(fp_room, 0, TOP);

	for (i = done = 0; i != MAX_ROOM && !done; ++i)
	{
		lsk = (MLONG) i * ROOMSIZE;
		fseek(fp_room, lsk, TOP);
		n = fread(&a_room, ROOMSIZE, 1, fp_room);

		if (n == 1)
		{
			last_ok_room = a_room.id;

			if (globals->abank == 0 && a_room.rmtype == BANK)
			{
				globals->abank = a_room.id;
			}
			else if (globals->amerc == 0 && a_room.rmtype == MERCANTILE)
			{
				globals->amerc = a_room.id;
			}
			else if (globals->anacad == 0 && a_room.rmtype == ACADEMY)
			{
				globals->anacad = a_room.id;
			}
		}
		else
		{
			done = TRUE;
		}
	}

	if (globals->anacad == 0)
	{
		globals->anacad = globals->townsq;
	}

	if (globals->abank == 0)
	{
		globals->abank = globals->townsq;
	}

	if (globals->amerc == 0)
	{
		globals->amerc = globals->townsq;
	}

	if (last_ok_room < globals->maxroom)
	{
		sprintf(str, "ADDING %d ROOMS", globals->maxroom - last_ok_room);
		NOTIFY(str);

		setmem(&a_room, ROOMSIZE, 0);
		a_room.exit[6] = globals->townsq;
		a_room.Visible[6] = TRUE;

		fclose(fp_room);
		fp_room = fopen(ROOM_FILE, APPEND);

		if (last_ok_room == 0)
		{
			last_ok_room = -1;
		}

		for (i = last_ok_room + 1; i != MAX_ROOM; ++i)
		{
			a_room.id = i;
			a_room.no_teleport = TRUE;

			if (i == 0)
			{
				strcpy(a_room.desc[0], DATA3);
			}
			else
			{
				strcpy(a_room.desc[0], "You are nowhere.");
			}

			fwrite(&a_room, ROOMSIZE, 1, fp_room);
		}

		fclose(fp_room);
		fp_room = fopen(ROOM_FILE, RDWR);
	}

	fseek(fp_room2, 0, TOP);

	for (i = done = last_ok_room = 0; i != MAX_ROOM && !done; ++i)
	{
		n = fread(&a_room2, ROOM2_SIZE, 1, fp_room2);

		if (n == 1)
		{
			last_ok_room = i;
		}
		else
		{
			done = TRUE;
		}
	}

	if (last_ok_room < globals->maxroom)
	{
		sprintf
		(
			str, 
			"ADDING %d TEMP ROOM BUFS", 
			globals->maxroom - last_ok_room
		);
		NOTIFY(str);

		setmem(&a_room2, ROOM2_SIZE, 0);

		fclose(fp_room2);
		fp_room2 = fopen(ROOM2_FILE, APPEND);

		if (last_ok_room == 0)
		{
			last_ok_room = -1;
		}

		for (i = last_ok_room + 1; i != MAX_ROOM; ++i)
		{
			fwrite(&a_room2, ROOM2_SIZE, 1, fp_room2);
		}

		fclose(fp_room2);
		fp_room2 = fopen(ROOM2_FILE, RDWR);
	}
}
/****************************************************************************
	read a room
*/
void Read_Room(short r, struct room_struct *room, struct room2_struct *room2)
{
	int     i;
	int     avail = -1;

	for (i = 0; i != globals->cachbufs; ++i)
	{
		if (room_cache[i]->rm.id == r)
		{
			memcpy(room2, &room_cache[i]->rm2, ROOM2_SIZE);
			memcpy(room, &room_cache[i]->rm, ROOMSIZE);
			return;
		}
	}

	lsk = (MLONG) r * ROOMSIZE;
	fseek(fp_room, lsk, TOP);
	fread(room, ROOMSIZE, 1, fp_room);
	
	lsk = (MLONG) r * ROOM2_SIZE;
	fseek(fp_room2, lsk, TOP);
	fread(room2, ROOM2_SIZE, 1, fp_room2);

	for (i = 0; i != globals->cachbufs && avail < 0; ++i)
	{
		if (room_cache[i]->rm.id == 0)
		{
			avail = i;
		}
	}

	if (avail < 0)
	{
		for (i = 1; i != globals->cachbufs; ++i)
		{
			memcpy(room_cache[i - 1], room_cache[i], ROOM_CACHE_SIZE);
		}
		
		avail = globals->cachbufs - 1;
	}

	memcpy(&room_cache[avail]->rm, room, ROOMSIZE);
	memcpy(&room_cache[avail]->rm2, room2, ROOM2_SIZE);
}
/****************************************************************************
	write a room
*/
void Write_Room(struct room_struct *room)
{
	short   i;

	lsk = (MLONG) room->id * ROOMSIZE;
	fseek(fp_room, lsk, TOP);
	fwrite(room, ROOMSIZE, 1, fp_room);

	for (i = 0; i != globals->cachbufs; ++i)
	{
		if (room_cache[i]->rm.id == room->id)
		{
			memcpy(&room_cache[i]->rm, room, ROOMSIZE);
			return;
		}
	}
}
/****************************************************************************
	write a room buffer
*/
void Write_Room2(struct room2_struct *room2, short r)
{
	short   j;

	lsk = (MLONG) r * ROOM2_SIZE;
	fseek(fp_room2, lsk, TOP);
	fwrite(room2, ROOM2_SIZE, 1, fp_room2);

	for (j = 0; j != globals->cachbufs; ++j)
	{
		if (room_cache[j]->rm.id == r)
		{
			memcpy(&room_cache[j]->rm2, room2, ROOM2_SIZE);
			return;
		}
	}
}
/****************************************************************************
	read an item
*/
void Read_Item(short i, struct item_struct *item)
{
	lsk = (MLONG) i * ITEMSIZE;
	fseek(fp_item, lsk, TOP);
	fread(item, ITEMSIZE, 1, fp_item);
}
/****************************************************************************
	write an item
*/
void Write_Item(struct item_struct *item, short index)
{

	lsk = (MLONG) index * ITEMSIZE;
	fseek(fp_item, lsk, TOP);
	fwrite(item, ITEMSIZE, 1, fp_item);
}
/****************************************************************************
	read a monster
*/
void Read_Critter(short c, struct crit_struct *crit)
{

	lsk = (MLONG) c * CRIT_SIZE;
	fseek(fp_crit, lsk, TOP);
	fread(crit, CRIT_SIZE, 1, fp_crit);
}
/****************************************************************************
	write a monster
*/
void Write_Critter(struct crit_struct *crit)
{

	lsk = (MLONG) crit->which * CRIT_SIZE;
	fseek(fp_crit, lsk, TOP);
	fwrite(crit, CRIT_SIZE, 1, fp_crit);
}
/****************************************************************************
	display the obituary
*/
short Display_Obits(void)
{
	short   n;
	FILE    *fp;
	struct  news_struct news[22];

	fp = fopen(NEWS_FILE, RDWR);
	if (fp == NULL)
	{
		NOTIFY("NEWS FILE OPEN FAILED(2)");
		BAD_EXIT;
	}

	prfmsg(M1214B);
	n = fread(news, NEWS_SIZE, 22, fp);

	if (n != 22)
	{
		prfmsg(M1214A);
	}
	else
	{
		for (n = 0; n != 17; ++n)
		{
			if (news[n].news[0])
			{
				prf("%s\r", news[n].news);
			}
		}
	}
	
	fclose(fp);
	DONE;
}
/*****************************************************************************
	see if I hung up the last time I was on
*/
short Coward_Check(void)
{
	short   i;
	short   coward = FALSE;
	FILE    *fp;
	char    coward_port_path[LINE_LEN];
	struct  port_struct *coward_port;

	coward_port = APORT(NTERMS);
	sprintf(coward_port_path, "%s\\%dp.DAT", COWARD_PATH, MY_PORT->index);
	fp = fopen(coward_port_path, RDWR);

	if (fp != NULL)
	{
		coward = TRUE;
		fread(coward_port, PORT_SIZE, 1, fp);
		fclose(fp);

		if (sameas(coward_port->chr.name, me.name))
		{
			MY_PORT->action_timer   = coward_port->action_timer;
			MY_PORT->bashed         = coward_port->bashed;
			MY_PORT->bashed_time    = coward_port->bashed_time;
			MY_PORT->next_hit       = coward_port->next_hit;
			MY_PORT->fine           = coward_port->fine;
			MY_PORT->questing       = coward_port->questing;
			MY_PORT->quests_left    = coward_port->quests_left;
			MY_PORT->quest_type     = coward_port->quest_type;
			MY_PORT->quest_timer    = coward_port->quest_timer;
			MY_PORT->quest_reward   = coward_port->quest_reward;
			strcpy(MY_PORT->quest_mon, coward_port->quest_mon);
			strcpy(MY_PORT->quest_thing, coward_port->quest_thing);

			for (i = 0; i != NUM_GUY_TIMERS; ++i)
			{
				MY_PORT->misc_type[i] = coward_port->misc_type[i];
				MY_PORT->timer[i] = coward_port->timer[i];
			}
		}
	}

	unlink(coward_port_path);
	return (coward);
}
/*****************************************************************************
	write a coward out to disk
*/
void Write_Coward(short p)
{
	FILE    *fp;

	sprintf(globals->path, "%s\\%dp.DAT", COWARD_PATH, APORT(p)->index);

	fp = fopen(globals->path, APPEND);
	if (fp == NULL)
	{
		NOTIFY("COWARD WRITE FAILED(2)!");
	}
	else
	{
		fwrite(APORT(p), PORT_SIZE, 1, fp);
		fclose(fp);
	}
}
/****************************************************************************
	print a list of current chaos users
*/
short who(void)
{
	short   n;
	short   l = 0;
	short   lev;
	long    total;
	FILE    *fp;
	short   done = FALSE;
	char    last_date[DATE_SIZE];
	char    outlaw;
	char    race[9];
	char    class[10];
	char    guild[4];

	if (MY_PORT->status != WHO_PROMPT)
	{
		if (word1[0])
		{
			Who_Is();
			BAD_EXIT;
		}
		else
		{
			MY_PORT->misc = 0;
		}
	}
	else if (margc)
	{
		if (sameas(margv[0], "n"))
		{
			MY_PORT->status = DO_PROMPT;
			BAD_EXIT;
		}
	}

	setmbk(mui_cfg);
	fp = fopen(CHAOS_USER_FILE, RDWR);
	lsk = (MLONG) MY_PORT->misc * CHAR_SIZE;
	fseek(fp, lsk, TOP);

	do
	{
		n = fread(&a_char, CHAR_SIZE, 1, fp);
		++MY_PORT->misc;

		if (n == 0)
		{
			done = TRUE;
		}
		else if (!sameas(a_char.name, BLANK_RECORD))
		{
			CONV_DATE(last_date, a_char.last_date);
			if (globals->outlaws && a_char.outlaw == 'Y')
			{
				outlaw = '*';
			}
			else
			{
				outlaw = ' ';
			}

			if (a_char.race == ELF)
			{
				strcpy(race, "Elf");
			}
			else if (a_char.race == DWARF)
			{
				strcpy(race, "Dwarf");
			}
			else if (a_char.race == HUMAN)
			{
				strcpy(race, "Human");
			}
			else if (a_char.race == OGRE)
			{
				strcpy(race, "Ogre");
			}
			else if (a_char.race == HALFLING)
			{
				strcpy(race, "Halfling");
			}

			if (a_char.class == WARRIOR)
			{
				strcpy(class, "Warrior");
			}
			else if (a_char.class == SORCERER)
			{
				strcpy(class, "Sorcerer");
			}
			else if (a_char.class == BARBARIAN)
			{
				strcpy(class, "Barbarian");
			}
			else if (a_char.class == THIEF)
			{
				strcpy(class, "Thief");
			}
			else if (a_char.class == DUELIST)
			{
				strcpy(class, "Duelist");
			}
			else if (a_char.class == CLERIC)
			{
				strcpy(class, "Cleric");
			}
			else if (a_char.class == MYSTIC)
			{
				strcpy(class, "Mystic");
			}

			if (a_char.guild_master)
			{
				sprintf(guild, "GM%d", a_char.in_guild);
			}
			else if (a_char.in_guild)
			{
				sprintf(guild, "G%d", a_char.in_guild);
			}
			else
			{
				guild[0] = 0;
			}
 
			total = (long) a_char.Psy;
			total += (long) a_char.Int;
			total += (long) a_char.Str;
			total += (long) a_char.Dex;
			total += (long) a_char.Con;
			total = total / 5L;
			lev = (short) total;
			lev = Stat_Lev(lev);

			prfmsg
			(
				WHOGUY1, 
				outlaw,
				last_date, 
				a_char.name,
				Brief_Userid(a_char.Userid),
				race,
				class,
				guild,
				lev
			);

			++l;
		}
	}
	while (!done && l < 21);

	fclose(fp);

	if (!done)
	{
		Set_Prompt(getmsg(MSG1209), WHO_PROMPT);
	}
	else
	{
		MY_PORT->status = DO_PROMPT;
		prf(NL);
	}
	
	rstmbk(); 
	DONE;
}
/****************************************************************************
	print a list of powerful chaos users
*/
void Poobahs(void)
{
	short   i;
	struct  poobah_struct *poobah = (struct poobah_struct *) vdaptr;
	
	prfmsg(MSG1215);

	for (i = 0; i != 20; ++i)
	{
		poobah->pts[i] = 0L;
		poobah->outlaw[i] = ' ';
		poobah->level[i] = 0;
	}
	
	poobah->w_index = -1;
	poobah->w_stats = 0L;
	poobah->s_index = -1;
	poobah->s_stats = 0L;
	poobah->b_index = -1;
	poobah->b_stats = 0L;
	poobah->t_index = -1;
	poobah->t_stats = 0L;
	poobah->d_index = -1;
	poobah->d_stats = 0L;
	poobah->c_index = -1;
	poobah->c_stats = 0L;
	poobah->m_index = -1;
	poobah->m_stats = 0L;

	poobah->user_index = 0;
	globals->poobing[usrnum] = TRUE;
	btuinj(usrnum, MYCYCLE);
}
/****************************************************************************
	print a list of evil chaos users
*/
void Villains(void)
{
	short   i;
	struct  poobah_struct *evil = (struct poobah_struct *) vdaptr;
	
	Write_My_Rec(EXISTS);
	prfmsg(MSG1216);

	for (i = 0; i != 20; ++i)
	{
		evil->pts[i] = 0L;
	}

	evil->user_index = 0;
	globals->eviling[usrnum] = TRUE;
	btuinj(usrnum, MYCYCLE);
}
/****************************************************************************
	print a list of powerful chaos users
*/
short Next_Poobah(void)
{
	short   n;
	short   j;
	short   i;
	short   lev;
	MLONG   total;
	MLONG   p;
	MLONG   lowest;
	char    title[LINE_SIZE];
	char    outlaw;
	FILE    *fp_user;
	FILE    *fp_brief;
	struct  brief_char_struct brief;
	struct  poobah_struct *poobah = (struct poobah_struct *) vdaptr;    

	fp_user = fopen(CHAOS_USER_FILE, RDWR);
	fseek(fp_user, (MLONG) poobah->user_index * CHAR_SIZE, TOP);
	n = fread(&a_char, CHAR_SIZE, 1, fp_user);
	fclose(fp_user);

	if 
	(
		!sameas(a_char.name, BLANK_RECORD) && 
		n && 
		(!a_char.Option[NO_POOBAH] || !globals->option7)
	)
	{
		p = (MLONG) a_char.Str + (MLONG) a_char.Dex + 
			(MLONG) a_char.Int + (MLONG) a_char.Con + (MLONG) a_char.Psy;

		lowest = 9999999L;

		for (j = 0; j != 20; ++j)
		{
			if (poobah->pts[j] < lowest)
			{
				lowest = poobah->pts[j];
				poobah->low_index = j;
			}
		}

		if (p > lowest)
		{
			poobah->pts[poobah->low_index] = p;

			if (globals->outlaws && a_char.outlaw == 'Y')                 
			{
				poobah->outlaw[poobah->low_index] = '*';
			}
			else
			{
				poobah->outlaw[poobah->low_index] = ' ';
			}

			total = a_char.Psy;
			total += a_char.Int;
			total += a_char.Str;
			total += a_char.Dex;
			total += a_char.Con;
			total = total / 5L;
			lev = (short) total;
			poobah->level[poobah->low_index] = Stat_Lev(lev);

			poobah->index[poobah->low_index] = poobah->user_index;
		}

		if (a_char.class == WARRIOR)
		{
			if (p > poobah->w_stats)
			{
				poobah->w_stats = p;
				poobah->w_index = poobah->user_index;
				big_warrior = poobah->w_index;
			}
		}
		else if (a_char.class == SORCERER)
		{
			if (p > poobah->s_stats)
			{
				poobah->s_stats = p;
				poobah->s_index = poobah->user_index;
				big_sorcerer = poobah->s_index;
			}
		}
		else if (a_char.class == BARBARIAN)
		{
			if (p > poobah->b_stats)
			{
				poobah->b_stats = p;
				poobah->b_index = poobah->user_index;
				big_barbarian = poobah->b_index;
			}
		}
		else if (a_char.class == THIEF)
		{
			if (p > poobah->t_stats)
			{
				poobah->t_stats = p;
				poobah->t_index = poobah->user_index;
				big_thief = poobah->t_index;
			}
		}
		else if (a_char.class == DUELIST)
		{
			if (p > poobah->d_stats)
			{
				poobah->d_stats = p;
				poobah->d_index = poobah->user_index;
				big_duelist = poobah->d_index;
			}
		}
		else if (a_char.class == CLERIC)
		{
			if (p > poobah->c_stats)
			{
				poobah->c_stats = p;
				poobah->c_index = poobah->user_index;
				big_cleric = poobah->c_index;
			}
		}
		else if (a_char.class == MYSTIC)
		{
			if (p > poobah->m_stats)
			{
				poobah->m_stats = p;
				poobah->m_index = poobah->user_index;
				big_mystic = poobah->m_index;
			}
		}
	}

	if (n == 1)
	{
		++poobah->user_index; 
		globals->poobing[usrnum] = TRUE;
		btuinj(usrnum, MYCYCLE);
		DONE;
	}
		
	for (i = 0; i != 20; ++i)
	{
		for (j = 0; j != 20; ++j)
		{
			if (poobah->pts[j] < poobah->pts[i])
			{
				p = poobah->pts[j];
				poobah->pts[j] = poobah->pts[i];
				poobah->pts[i] = p;

				outlaw = poobah->outlaw[j];
				poobah->outlaw[j] = poobah->outlaw[i];
				poobah->outlaw[i] = outlaw;

				lev = poobah->level[j];
				poobah->level[j] = poobah->level[i];
				poobah->level[i] = lev;

				n = poobah->index[j];
				poobah->index[j] = poobah->index[i];
				poobah->index[i] = n;
			}
		}
	}

	prf(NL);
	setmbk(mui_cfg);
	fp_brief = fopen(CHAOS_NAME_FILE, RDWR);

	for (i = 0; i != 20; ++i)
	{
		if (poobah->pts[i])
		{
			lsk = (MLONG) poobah->index[i] * BRIEF_CHAR_SIZE;
			fseek(fp_brief, lsk, TOP);
			fread(&brief, BRIEF_CHAR_SIZE, 1, fp_brief);
			
			strcpy(title, "  ");

			if (poobah->index[i] == poobah->w_index)
			{
				strcat(title, getmsg(BIGWAR));
			}
			else if (poobah->index[i] == poobah->s_index)
			{
				strcat(title, getmsg(BIGSOR));
			}
			else if (poobah->index[i] == poobah->b_index)
			{
				strcat(title, getmsg(BIGBAR));
			}
			else if (poobah->index[i] == poobah->t_index)
			{
				strcat(title, getmsg(BIGTHI));
			}
			else if (poobah->index[i] == poobah->d_index)
			{
				strcat(title, getmsg(BIGDUE));
			}
			else if (poobah->index[i] == poobah->c_index)
			{
				strcat(title, getmsg(BIGCLE));
			}
			else if (poobah->index[i] == poobah->m_index)
			{
				strcat(title, getmsg(BIGMYS));
			}

			sprintf
			(
				str,
				getmsg(POOBAHM1),
				i + 1,
				poobah->outlaw[i],
				brief.name,
				poobah->pts[i],
				poobah->level[i],
				title
			);
			prf(str);
		}
	}

	fclose(fp_brief);

	if (P != -1)
	{
		prf("%s", MY_PORT->prompt);
	}
	else
	{
		prfmsg(MSG1217);
	}

	rstmbk();

	globals->poobing[usrnum] = FALSE;
	DONE;
}
/****************************************************************************
	print a list of evil chaos users
*/
short Next_Evil(void)
{
	short   did_one = FALSE;
	short   i;
	MLONG   p;
	short   n;
	short   j;
	MLONG   lowest;
	FILE    *fp_user;
	FILE    *fp_brief;
	struct  brief_char_struct brief;
	struct  poobah_struct *evil = (struct poobah_struct *) vdaptr;    

	fp_user = fopen(CHAOS_USER_FILE, RDWR);
	fseek(fp_user, (MLONG) evil->user_index * CHAR_SIZE, TOP);
	n = fread(&a_char, CHAR_SIZE, 1, fp_user);
	fclose(fp_user);

	if (!sameas(a_char.name, BLANK_RECORD) && n == 1)
	{
		p = a_char.evil;
		lowest = 9999999L;

		for (j = 0; j != 20; ++j)
		{
			if (evil->pts[j] < lowest)
			{
				lowest = evil->pts[j];
				evil->low_index = j;
			}
		}

		if (p > lowest)
		{
			evil->pts[evil->low_index] = p;
			evil->index[evil->low_index] = evil->user_index;
		}
	}

	if (n == 1)
	{
		++evil->user_index; 
		globals->eviling[usrnum] = TRUE;
		btuinj(usrnum, MYCYCLE);
		DONE;
	}
		
	for (i = 0; i != 20; ++i)
	{
		for (j = 0; j != 20; ++j)
		{
			if (evil->pts[j] < evil->pts[i])
			{
				p = evil->pts[j];
				evil->pts[j] = evil->pts[i];
				evil->pts[i] = p;

				n = evil->index[j];
				evil->index[j] = evil->index[i];
				evil->index[i] = n;
			}
		}
	}

	prf(NL);
	setmbk(mui_cfg);
	fp_brief = fopen(CHAOS_NAME_FILE, RDWR);

	for (i = 0; i != 20; ++i)
	{
		if (evil->pts[i])
		{
			did_one = TRUE;
			lsk = (MLONG) evil->index[i] * BRIEF_CHAR_SIZE;
			fseek(fp_brief, lsk, TOP);
			fread(&brief, BRIEF_CHAR_SIZE, 1, fp_brief);

			n = (short) evil->pts[i];
			
			prfmsg
			(
				VILLAIN,
				i + 1,
				brief.name,
				Brief_Userid(brief.Userid),
				n
			);
		}
	}

	fclose(fp_brief);

	if (!did_one)
	{
		prfmsg(MSG1218);
	}

	rstmbk();
	prf("%s", MY_PORT->prompt);
	globals->eviling[usrnum] = FALSE;
	DONE;
}
/****************************************************************************
	get a list of powerful chaos users
*/
void Init_Poobahs(void)
{
	short   i;
	MLONG   p;
	short   n;
	short   j;
	MLONG    lowest;
	FILE    *fp_user;
	struct  poobah_struct poobah;

	for (i = 0; i != 20; ++i)
	{
		poobah.pts[i] = 0L;
	}
	
	poobah.w_stats = 0L;
	poobah.s_stats = 0L;
	poobah.b_stats = 0L;
	poobah.t_stats = 0L;
	poobah.d_stats = 0L;
	poobah.c_stats = 0L;
	poobah.m_stats = 0L;
	poobah.user_index = 0;

	fp_user = fopen(CHAOS_USER_FILE, RDWR);
	
	do 
	{
		n = fread(&a_char, CHAR_SIZE, 1, fp_user);

		if 
		(
			n == 1 &&
			!sameas(a_char.name, BLANK_RECORD) && 
			(!a_char.Option[NO_POOBAH] || !globals->option7)
		)
		{
			p = (MLONG) a_char.Str + (MLONG) a_char.Dex + 
				(MLONG) a_char.Int + (MLONG) a_char.Con + (MLONG) a_char.Psy;
			lowest = 9999999L;

			for (j = 0; j != 20; ++j)
			{
				if (poobah.pts[j] < lowest)
				{
					lowest = poobah.pts[j];
					poobah.low_index = j;
				}
			}

			if (p > lowest)
			{
				poobah.pts[poobah.low_index] = p;
				poobah.index[poobah.low_index] = poobah.user_index;
			}

			if (a_char.class == WARRIOR)
			{
				if (p > poobah.w_stats)
				{
					poobah.w_stats = p;
					big_warrior = poobah.user_index;
				}
			}
			else if (a_char.class == SORCERER)
			{
				if (p > poobah.s_stats)
				{
					poobah.s_stats = p;
					big_sorcerer = poobah.user_index;
				}
			}
			else if (a_char.class == BARBARIAN)
			{
				if (p > poobah.b_stats)
				{
					poobah.b_stats = p;
					big_barbarian = poobah.user_index;
				}
			}
			else if (a_char.class == THIEF)
			{
				if (p > poobah.t_stats)
				{
					poobah.t_stats = p;
					big_thief = poobah.user_index;
				}
			}
			else if (a_char.class == DUELIST)
			{
				if (p > poobah.d_stats)
				{
					poobah.d_stats = p;
					big_duelist = poobah.user_index;
				}
			}
			else if (a_char.class == CLERIC)
			{
				if (p > poobah.c_stats)
				{
					poobah.c_stats = p;
					big_cleric = poobah.user_index;
				}
			}
			else if (a_char.class == MYSTIC)
			{
				if (p > poobah.m_stats)
				{
					poobah.m_stats = p;
					big_mystic = poobah.user_index;
				}
			}
		}

		++poobah.user_index;
	}
	while (n == 1);

	fclose(fp_user);
}
/****************************************************************************
	list permanant monsters and their location
*/
void List_Perm_Monsters(void)
{
	short   l = 0;
	short   i;

	for (i = 0; i != MAX_PERM_MON; ++i)
	{
		if (globals->perm_mon_id[i])
		{
			lsk = (MLONG) globals->perm_mon_id[i] * CRIT_SIZE;
			fseek(fp_crit, lsk, TOP);
			fread(&crit, CRIT_SIZE, 1, fp_crit);

			prfmsg
			(
				MSG1219, 
				globals->perm_mon_id[i], 
				crit.name, 
				globals->perm_mon_loc[i]
			);
			++l;

			if (l == 2)
			{
				prf(NL);
				l = 0;
			}
		}
	}

	if (l != 0)
	{
		prf(NL);
	}

	if (me.perm[GAMEOP_PERM] && invasion->active)
	{
		Read_Critter(invasion->crit, &crit);
		prfmsg(MSG1220, crit.plural_name);

		for (i = l = 0; i != MAX_INVASION_ROOMS; ++i)
		{
			if (invasion->room[i] && invasion->count[i])
			{
				sprintf
				(
					str, 
					getmsg(MSG1221), 
					invasion->room[i], 
					invasion->count[i]
				);

				prf("%s", str);

				++l;

				if (l == 4)
				{
					prf(NL);
					l = 0;
				}
			}
		}
	}

	if (l != 0)
	{
		prf(NL);
	}
}
/****************************************************************************
	list permanant items and their location
*/
void List_Perm_Items(void)
{
	short   l = 0;
	short   i;

	for (i = 0; i != MAX_PERM_ITEM; ++i)
	{
		if (globals->perm_item_id[i])
		{
			lsk = (MLONG) globals->perm_item_id[i] * ITEMSIZE;
			fseek(fp_item, lsk, TOP);
			fread(&item, ITEMSIZE, 1, fp_item);

			prfmsg
			(
				MSG1219, 
				globals->perm_item_id[i], 
				item.name, 
				globals->perm_item_loc[i]
			);
			++l;

			if (l == 2)
			{
				prf(NL);
				l = 0;
			}
		}
	}

	if (l != 0)
	{
		prf(NL);
	}
}
/****************************************************************************
	read a user's storage closet
*/
void Read_Closet(short index, struct closet_struct *closet)
{
	short   i;
	FILE    *fp;

	fp = fopen(CLOSET_FILE, RDWR);
	lsk = (MLONG) index * CLOSET_SIZE;
	fseek(fp, lsk, TOP);

	i = fread(closet, CLOSET_SIZE, 1, fp);

	if (i != 1)
	{
		setmem(closet, CLOSET_SIZE, 0);
	}
	else
	{
		for (i = 0; i != NUM_ITEMS; ++i)
		{
			if 
			(
				closet->item[i].what < 0 || 
				closet->item[i].what >= MAX_ITEM_WHAT)
			{
				setmem(closet, CLOSET_SIZE, 0);
			}
		}
	}

	fclose(fp);
}
/****************************************************************************
	write items for a sticky room
*/
short Write_Sticky(void)
{
	short   m;
	short   i;
	short   total;
	FILE    *fp;

	if (!ABUF(B)->rm.items_or_mons)
	{
		ABUF(B)->rm.mons = 0;
		ABUF(B)->rm.evil_mons = 0;
		ABUF(B)->rm.visible_mons = 0;
		DONE;
	}

	sprintf(globals->path, "%s\\R%d.DAT", ROOM_ITEM_PATH, ABUF(B)->rm.id);
	fp = fopen(globals->path, RDWR);

	if (fp == NULL)
	{
		Create_New(globals->path);
		fp = fopen(globals->path, RDWR);

		if (fp == NULL)
		{
			NOTIFY("STICKY WRITE FAILED!");
			BAD_EXIT;
		}
	}
	
	if (!globals->sticky && !ABUF(B)->death_room && !SAFE_AREA)
	{
		for (i = 0; i != NUM_ITEMS; ++i)
		{
			if (ABUF(B)->item[i].what)
			{
				if (ABUF(B)->item[i].what == CONTAINER)
				{
					Kill_Container(&ABUF(B)->item[i]);
				}

				ABUF(B)->item[i].what = 0;
			}
		}
	}

	fwrite(ABUF(B)->item, CLOSET_SIZE, 1, fp);
	ABUF(B)->rm.evil_mons = 0;
	ABUF(B)->rm.visible_mons = 0;
	ABUF(B)->rm.mons = 0;

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what)
		{
			if 
			(
				AMON->permanant || 
				(invasion->active && AMON->which == invasion->crit) ||
				RANDOM(globals->monleave) == 1 ||
				ABUF(B)->death_room
			)
			{
				for (i = 0; i != MAX_MON_ITEM; ++i)
				{
					if (AMON->item_has[i].what == CONTAINER)
					{
						Kill_Container(&AMON->item_has[i]);
					}
				}

				for (i = total = 0; i != MAX_ROOM_MON; ++i)
				{
					if (ABUF(B)->mon[i].what)
					{
						++total;
					}
				}

				AMON->what = 0;

				if (m != MAX_ROOM_MON - 1)
				{
					for (i = m + 1; i != MAX_ROOM_MON; ++i)
					{
						ABUF(B)->mon[i - 1] = ABUF(B)->mon[i];
					}
				}

				ABUF(B)->mon[total - 1].what = 0;
				--m;
			}
			else
			{
				++ABUF(B)->rm.mons;

				if (!AMON->hidden)
				{
					++ABUF(B)->rm.visible_mons;

					if (!AMON->alg)
					{
						++ABUF(B)->rm.evil_mons;
					}
				}
			}
		}
	}

	fwrite(ABUF(B)->mon, PURSUER_SIZE, 1, fp);
	fclose(fp);
	DONE;
}
/****************************************************************************
	read items for a sticky room
*/
void Read_Sticky(void)
{
	short   i;
	short   m;
	short   g;
	short   t;
	FILE    *fp;

	sprintf(globals->path, "%s\\R%d.DAT", ROOM_ITEM_PATH, ABUF(B)->rm.id);
	fp = fopen(globals->path, RDWR);

	if (fp == NULL)
	{
		ABUF(B)->item_change = TRUE;
		setmem(ABUF(B)->item, CLOSET_SIZE, 0);
		setmem(ABUF(B)->mon, PURSUER_SIZE, 0);
		unlink(globals->path);
		return;
	}
	
	i = fread(ABUF(B)->item, CLOSET_SIZE, 1, fp);

	if (i != 1)
	{
		ABUF(B)->item_change = TRUE;
		setmem(ABUF(B)->item, CLOSET_SIZE, 0);
	}

	i = fread(ABUF(B)->mon, PURSUER_SIZE, 1, fp);
	fclose(fp);

	if (i != 1)
	{
		ABUF(B)->item_change = TRUE;
		setmem(ABUF(B)->mon, PURSUER_SIZE, 0);
	}
	else
	{
		for (m = 0; m != MAX_ROOM_MON; ++m)
		{
			if (AMON->what)
			{
				ABUF(B)->crit_change = TRUE;

				for (g = 0; g != NTERMS; ++g)
				{
					AMON->sees[g] = FALSE;
					AMON->hurt_by[g] = FALSE;
					AMON->spelled_by[g] = FALSE;
					AMON->tranced_by[g] = FALSE;
					AMON->struck_by[g] = FALSE;
					AMON->my_ac_was_lower[g] = FALSE;
					AMON->easy_hit[g] = FALSE;
					AMON->I_hit[g] = FALSE;
					AMON->sees[g] = FALSE;
					AMON->last_attacker = -1;
				}

				for (t = 0; t != NUM_MON_TIMERS; ++t)
				{
					if 
					(
						AMON->misc_type[t] == SLEEP_TIME ||
						AMON->misc_type[t] == MES_TIME
					)
					{
						AMON->timer[t] = 1;
						AMON->action_timer = 1;
					}
				}

				if (AMON->bashed_time)
				{
					AMON->bashed_time = 1;
					AMON->action_timer = 1;
				}

				for (i = 0; i != MAX_MON_ITEM; ++i)
				{
					if 
					(
						AMON->item_has[i].what && 
						AMON->item_has[i].which == SCROLL
					)
					{
						AMON->item_has[i].what = 0;
					}
				}
			}
		}
	}

	ABUF(B)->rm.items_or_mons = FALSE;

	for (i = 0; i != NUM_ITEMS; ++i)
	{
		if (ABUF(B)->item[i].what)
		{
			ABUF(B)->rm.items_or_mons = TRUE;
		}
	}

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what)
		{
			ABUF(B)->rm.items_or_mons = TRUE;
		}
	}

	if (!ABUF(B)->rm.items_or_mons)
	{
		unlink(globals->path);
	}
}
/****************************************************************************
	read items for a sticky room
*/
void Old_Read_Sticky(short r, struct closet_struct *closet)
{
	short   i;
	FILE    *fp;

	sprintf(globals->path, STICKY_PATH, r);
	Create_New(globals->path);
	fp = fopen(globals->path, RDWR);

	if (fp == NULL)
	{
		NOTIFY("STICKY READ FAILED!");
	}
	else
	{
		i = fread(closet, CLOSET_SIZE, 1, fp);
		fclose(fp);

		if (i != 1)
		{
			setmem(closet, CLOSET_SIZE, 0);
		}
	}

	unlink(globals->path);
}
/****************************************************************************
	write a user's storage closet
*/
void Write_Closet(short index, struct closet_struct *closet)
{
	FILE    *fp;

	fp = fopen(CLOSET_FILE, RDWR);
	lsk = (MLONG) index * CLOSET_SIZE;
	fseek(fp, lsk, TOP);
	fwrite(closet, CLOSET_SIZE, 1, fp);
	fclose(fp);
}
/****************************************************************************
	displays the contents of a text file
*/
void Display_Announcement(void)
{
	FILE    *fp;

	MY_PORT->announce = FALSE;

	if (globals->anncfile[0])
	{
		fp = fopen(globals->anncfile, READONLY);

		if (fp != NULL)
		{
			fclose(fp);
			MY_PORT->announce = TRUE;
			Dump_File(globals->anncfile, -1);
		}
	}
}
/****************************************************************************
	displays the contents of a text file
*/
short Dump_File(char *file, short close_it)
{
	short   i;
	short   done = FALSE;
	char    *read_result;
	char    txt[LINE_LEN];

	if (close_it != -1)
	{
		fclose(APORT(close_it)->fp);
		DONE;
	}

	if (MY_PORT->status != DUMP_FILE_PROMPT)
	{
		for (i = 0; i != strlen(file); ++i)
		{
			file[i] = toupper(file[i]);
		}

		MY_PORT->fp = fopen(file, READONLY);

		if (MY_PORT->fp == NULL)
		{
			prfmsg(MSG1239);
			BAD_EXIT;
		}
	}
	else if (margc)
	{
		if (sameas(margv[0], "n"))
		{
			fclose(MY_PORT->fp);
			MY_PORT->status = DO_PROMPT;

			if (MY_PORT->announce)
			{
				MY_PORT->announce = FALSE;
				Newday(0);
			}

			BAD_EXIT;
		}
	}

	for (i = 0; i != 18 && !done; ++i)
	{
		read_result = fgets(txt, 1000, MY_PORT->fp);
	
		if (read_result != NULL)
		{
			prfmsg(MSG1272, txt);
		}
		else
		{
			fclose(MY_PORT->fp);
			done = TRUE;
			MY_PORT->status = DO_PROMPT;
		}
	}

	if (!done)
	{
		Set_Prompt(getmsg(MSG1209), DUMP_FILE_PROMPT);
	}
	else
	{
		prf(NL);

		if (MY_PORT->announce)
		{
			Set_Prompt(getmsg(MSG1217), ANNOUNCE_PROMPT);
		}
	}
	
	DONE;
}
/****************************************************************************
	print who was on
*/
short Dayfile(void)
{
	FILE    *fp;
	short   i;
	short   n;
	short   done = FALSE;
	struct  day_struct day_entry;
		 
	fp = fopen(CHAOS_DAYFILE, RDWR);

	if (fp == NULL)
	{
		NOTIFY("DAYFILE OPEN FAILED!");
		BAD_EXIT;
	}

	prfmsg(MSG1269);

	for (i = 0; i < 22 && !done; ++i)
	{
		n = fread(&day_entry, DAYSIZE, 1, fp);
		
		if (n == 0 || day_entry.port > NTERMS || day_entry.port < 0)
		{
			done = TRUE;
		}
		else
		{
			sprintf
			(
				str,
				getmsg(MSG1270),
				day_entry.port,
				day_entry.dateon,
				day_entry.timeon,
				day_entry.secs / 60,
				day_entry.userid
			);
			prf(str);
		}
	}

	fclose(fp);
	DONE;
}
/*****************************************************************************
	put new entry in dayfile
*/
short EXPORT Day_Out(void)
{
	short   i;
	FILE    *fp;
	struct  day_struct  day_entry;

	if (P == 0 || MY_PORT->secs_on < 60)
	{
		BAD_EXIT;
	}

	fp = fopen(CHAOS_DAYFILE, RDWR);
	if (fp == NULL)
	{
		NOTIFY("DAYFILE OPEN FAILED!");
		BAD_EXIT;
	}

	for (i = 20; i > -1; --i)
	{
		lsk = (MLONG) i * DAYSIZE;
		fseek(fp, lsk, TOP);
		fread(&day_entry, DAYSIZE, 1, fp);

		lsk = (MLONG) (i + 1) * DAYSIZE;
		fseek(fp, lsk, TOP);
		fwrite(&day_entry, DAYSIZE, 1, fp);
	}

	day_entry.port = P;
	day_entry.secs = MY_PORT->secs_on;
	TODAY(day_entry.dateon);
	strcpy(day_entry.timeon, MY_PORT->time_on);
	strcpy(day_entry.userid, me.Userid);

	lsk = 0;
	fseek(fp, lsk, TOP); 
	fwrite(&day_entry, DAYSIZE, 1, fp);
	fclose(fp);
	DONE;
}
