#include <header.h>
#include <globals.h>

/****************************************************************************
	selectively remove hall of fame records
*/
short EXPORT Edit_Fame(void)
{
	int     n;

	if (MY_PORT->status != FAME_PROMPT)
	{
		Hall_Of_Fame(1);
		prf(NL);
		sprintf(str, getmsg(MSG1501), MAX_FAME);
		Set_Prompt(str, FAME_PROMPT);
		DONE;
	}

	n = INUM(margv[0]);

	if (n < 1 || n > MAX_FAME)
	{
		sprintf(str, getmsg(MSG1501), MAX_FAME);
		Set_Prompt(str, FAME_PROMPT);
		DONE;
	}

	--n;
	Read_Fame();
	fame.record[n] = 0;
	Write_Fame();
	MY_PORT->status = 0;
	Edit_Fame();
	DONE;
}
/****************************************************************************
	see if I set a new record
*/
void EXPORT Fame_Check(void)
{
	short   i;

	i = Read_Fame();
	
	if (i != 1)
	{
		unlink(CHAOS_FAME);
		Create_New(CHAOS_FAME);
	}

	if (MY_PORT->invaders > fame.record[INVADER_KILLS])
	{
		Record_Set(INVADER_KILLS, MY_PORT->invaders);
	}

	if (MY_PORT->rovers > fame.record[ROVER_KILLS])
	{
		Record_Set(ROVER_KILLS, MY_PORT->rovers);
	}

	if (MY_PORT->secs_on > fame.record[SECS_ON])
	{
		Record_Set(SECS_ON, MY_PORT->secs_on);
	}

	if (MY_PORT->experience > fame.record[EXP_EARNED])
	{
		Record_Set(EXP_EARNED, MY_PORT->experience);
	}

	if (MY_PORT->theft_exp > fame.record[THEFT_EXP])
	{
		Record_Set(THEFT_EXP, MY_PORT->theft_exp);
	}

	i = me.Str + me.Int + me.Dex + me.Psy + me.Con;

	if (i > fame.record[MAX_STATS])
	{
		Record_Set(MAX_STATS, i);
	}

	if (MY_PORT->kills > fame.record[KILLS])
	{
		Record_Set(KILLS, MY_PORT->kills);
	}

	if (MY_PORT->murders > fame.record[MURDERS])
	{
		Record_Set(MURDERS, MY_PORT->murders);
	}

	if (MY_PORT->cash > fame.record[CASH_FOUND])
	{
		Record_Set(CASH_FOUND, MY_PORT->cash);
	}

	if (MY_PORT->bounty_gold > fame.record[BOUNTY_GOLD])
	{
		Record_Set(BOUNTY_GOLD, MY_PORT->bounty_gold);
	}

	if (MY_PORT->deaths > fame.record[DEATHS])
	{
		Record_Set(DEATHS, MY_PORT->deaths);
	}

	if (MY_PORT->quests > fame.record[QUESTS_DONE])
	{
		Record_Set(QUESTS_DONE, MY_PORT->quests);
	}

	if (MY_PORT->thefts > fame.record[THEFTS])
	{
		Record_Set(THEFTS, MY_PORT->thefts);
	}

	if (MY_PORT->mon_level > fame.record[MON_LEVEL])
	{
		Record_Set(MON_LEVEL, MY_PORT->mon_level);
	}

	Write_Fame();
}
/****************************************************************************
	I set a record
*/
void Record_Set(short r, MLONG amount)
{

	fame.record[r] = amount;
	TODAY(fame.date[r]);
	strcpy(fame.name[r], me.name);
	strcpy(fame.title[r], me.title);
}
/****************************************************************************
	Display the hall of fame
*/
short Hall_Of_Fame(short option)
{
	short   i;
	short   r;

	prfmsg(MSG282);
	i = Read_Fame();

	if (i != 1)
	{
		unlink(CHAOS_FAME);
		Create_New(CHAOS_FAME);
		BAD_EXIT;
	}

	r = QUESTS_DONE;

	if (fame.record[r])
	{
		if (option)
		{
			prfmsg(MSG1467, r + 1);
		}

		sprintf
		(
			str,
			getmsg(MSG293),
			fame.date[r],
			fame.name[r],
			fame.title[r],
			fame.record[r]
		);
		prf(str);
	}

	r = EXP_EARNED;

	if (fame.record[r])
	{
		if (option)
		{
			prfmsg(MSG1467, r + 1);
		}

		sprintf
		(
			str,
			getmsg(MSG284),
			fame.date[r],
			fame.name[r],
			fame.title[r],
			fame.record[r]
		);
		prf(str);
	}

	r = MAX_STATS;

	if (fame.record[r])
	{
		if (option)
		{
			prfmsg(MSG1467, r + 1);
		}

		sprintf
		(
			str,
			getmsg(MSG286),
			fame.date[r],
			fame.name[r],
			fame.title[r],
			fame.record[r]
		);
		prf(str);
	}

	r = KILLS;

	if (fame.record[r])
	{
		if (option)
		{
			prfmsg(MSG1467, r + 1);
		}

		sprintf
		(
			str,
			getmsg(MSG287),
			fame.date[r],
			fame.name[r],
			fame.title[r],
			fame.record[r]
		);
		prf(str);
	}

	r = MURDERS;

	if (fame.record[r])
	{
		if (option)
		{
			prfmsg(MSG1467, r + 1);
		}

		sprintf
		(
			str,
			getmsg(MSG288),
			fame.date[r],
			fame.name[r],
			fame.title[r],
			fame.record[r]
		);
		prf(str);
	}

	r = CASH_FOUND;

	if (fame.record[r])
	{
		if (option)
		{
			prfmsg(MSG1467, r + 1);
		}

		sprintf
		(
			str,
			getmsg(MSG289),
			fame.date[r],
			fame.name[r],
			fame.title[r],
			fame.record[r]
		);
		prf(str);
	}

	r = DEATHS;

	if (fame.record[r])
	{
		if (option)
		{
			prfmsg(MSG1467, r + 1);
		}

		sprintf
		(
			str,
			getmsg(MSG291),
			fame.date[r],
			fame.name[r],
			fame.title[r],
			fame.record[r]
		);
		prf(str);
	}

	r = THEFTS;

	if (fame.record[r])
	{
		if (option)
		{
			prfmsg(MSG1467, r + 1);
		}

		sprintf
		(
			str,
			getmsg(MSG292),
			fame.date[r],
			fame.name[r],
			fame.title[r],
			fame.record[r]
		);
		prf(str);
	}

	r = MON_LEVEL;

	if (fame.record[r])
	{
		if (option)
		{
			prfmsg(MSG1467, r + 1);
		}

		sprintf
		(
			str,
			getmsg(MSG294),
			fame.date[r],
			fame.name[r],
			fame.title[r],
			fame.record[r]
		);
		prf(str);
	}

	r = SECS_ON;

	if (fame.record[r])
	{
		if (option)
		{
			prfmsg(MSG1467, r + 1);
		}

		sprintf
		(
			str,
			getmsg(MSG283),
			fame.date[r],
			fame.name[r],
			fame.title[r],
			fame.record[r] / 60
		);
		prf(str);
	}
	
	r = ROVER_KILLS;

	if (fame.record[r])
	{
		if (option)
		{
			prfmsg(MSG1467, r + 1);
		}

		sprintf
		(
			str,
			getmsg(MSG295),
			fame.date[r],
			fame.name[r],
			fame.title[r],
			fame.record[r]
		);
		prf(str);
	}

	r = THEFT_EXP;

	if (fame.record[r])
	{
		if (option)
		{
			prfmsg(MSG1467, r + 1);
		}

		sprintf
		(
			str,
			getmsg(MSG285),
			fame.date[r],
			fame.name[r],
			fame.title[r],
			fame.record[r]
		);
		prf(str);
	}
	
	r = INVADER_KILLS;

	if (fame.record[r])
	{
		if (option)
		{
			prfmsg(MSG1467, r + 1);
		}

		sprintf
		(
			str,
			getmsg(MSG296),
			fame.date[r],
			fame.name[r],
			fame.title[r],
			fame.record[r]
		);
		prf(str);
	}

	r = BOUNTY_GOLD;

	if (fame.record[r])
	{
		if (option)
		{
			prfmsg(MSG1467, r + 1);
		}

		sprintf
		(
			str,
			getmsg(MSG290),
			fame.date[r],
			fame.name[r],
			fame.title[r],
			fame.record[r]
		);
		prf(str);
	}
	
	DONE;
}
/****************************************************************************
	Display my current record status
*/
void EXPORT My_Current_Fame(void)
{
	sprintf(str, getmsg(MSG297), MY_PORT->secs_on / 60);
	prf(str);

	if (MY_PORT->experience)
	{
		sprintf(str, getmsg(MSG298), MY_PORT->experience);
		prf(str);
	}

	if (MY_PORT->theft_exp)
	{
		sprintf(str, getmsg(MSG299), MY_PORT->theft_exp);
		prf(str);
	}

	if (MY_PORT->kills)
	{
		sprintf(str, getmsg(MSG300), MY_PORT->kills);
		prf(str);
	}

	if (MY_PORT->murders)
	{
		sprintf(str, getmsg(MSG301), MY_PORT->murders);
		prf(str);
	}

	if (MY_PORT->cash)
	{
		sprintf(str, getmsg(MSG302), MY_PORT->cash);
		prf(str);
	}

	if (MY_PORT->bounty_gold)
	{
		sprintf(str, getmsg(MSG303), MY_PORT->bounty_gold);
		prf(str);
	}

	if (MY_PORT->deaths)
	{
		sprintf(str, getmsg(MSG304), MY_PORT->deaths);
		prf(str);
	}

	if (MY_PORT->thefts)
	{
		sprintf(str, getmsg(MSG305), MY_PORT->thefts);
		prf(str);
	}

	if (MY_PORT->quests)
	{
		sprintf(str, getmsg(MSG306), MY_PORT->quests);
		prf(str);
	}

	if (MY_PORT->rovers)
	{
		sprintf(str, getmsg(MSG307), MY_PORT->rovers);
		prf(str);
	}

	if (MY_PORT->invaders)
	{
		sprintf(str, getmsg(MSG308), MY_PORT->invaders);
		prf(str);
	}

	if (MY_PORT->mon_level)
	{
		sprintf(str, getmsg(MSG309), MY_PORT->mon_level);
		prf(str);
	}
}
/****************************************************************************
	read the hall of fame file
*/
short Read_Fame(void)
{
	short   i;
	FILE    *fp;

	fp = fopen(CHAOS_FAME, RDWR);
	i = fread(&fame, FAME_SIZE, 1, fp);
	fclose(fp);

	if (i != 1)
	{
		setmem(&fame, FAME_SIZE, 0);
	}

	return (i);
}
/****************************************************************************
	write the hall of fame file
*/
void Write_Fame(void)
{
	FILE    *fp;

	fp = fopen(CHAOS_FAME, RDWR);
	fwrite(&fame, FAME_SIZE, 1, fp);
	fclose(fp);
}
