#include <header.h>
#include <globals.h>

/****************************************************************************
	gameop functions
*/
short EXPORT GameOp_Menu(short option)
{
	short   can_edit = FALSE;
	short   gameop = FALSE;
	short   can_toggle = FALSE;
	short   can_edit_players = FALSE;

	if (me.perm[GAMEOP_PERM])
	{
		gameop = TRUE;
		can_edit = TRUE;
	}
	
	if (me.perm[PLAYER_EDIT_PERM])
	{
		can_edit_players = TRUE;
	}

	if (me.perm[EDIT_PERM])
	{
		can_edit = TRUE;
	}

	if (globals->sysopkey[0] && haskey(globals->sysopkey))
	{
		can_toggle = TRUE;
	}

	if (!gameop && !can_edit && !can_toggle && !can_edit_players)
	{
		prfmsg(M880);
		BAD_EXIT;
	}

	if (option == 0)
	{
		prfmsg(MSG1387A);
		Set_Prompt(getmsg(MSG1388A), GAMEOP_PROMPT); 
	}
	else if (sameas(margv[0], "A") && can_edit)
	{
		prfmsg(MSG1460);
		Set_Prompt(getmsg(MSG1461), EDIT_ITEM_PROMPT1);
	}
	else if (sameas(margv[0], "B") && can_edit)
	{
		if (me.lo_room == 0 && me.hi_room == 0)
		{
			sprintf(str, getmsg(MSG1444A), 1, globals->maxroom);
		}
		else
		{
			sprintf(str, getmsg(MSG1444A), me.lo_room, me.hi_room);
		}

		Set_Prompt(str, EDIT_ROOM_PROMPT1);
	}
	else if (sameas(margv[0], "C") && can_edit)
	{
		if (me.lo_crit == 0 && me.hi_crit == 0)
		{
			sprintf(str, getmsg(MSG1429A), 1, globals->maxmon);
		}
		else
		{
			sprintf(str, getmsg(MSG1429A), me.lo_crit, me.hi_crit);
		}

		Set_Prompt(str, EDIT_MON_PROMPT1);
	}
	else if (sameas(margv[0], "D") && can_edit_players)
	{
		Set_Prompt(getmsg(MSG1424), EDIT_GUY_PROMPT1);
	}
	else if (sameas(margv[0], "E") && gameop)
	{
		MY_PORT->status = EDIT_PERM_PROMPT;
		STATE = 0;
		Edit_Perm_Mon();
	}
	else if (sameas(margv[0], "F") && gameop)
	{
		MY_PORT->status = EDIT_STORE_PROMPT;
		STATE = 0;
		Edit_Store();
	}
	else if (sameas(margv[0], "G") && gameop)
	{
		MY_PORT->status = EDIT_OFFICE_PROMPT;
		STATE = 0;
		Edit_Offices();
	}
	else if (sameas(margv[0], "H") && gameop) 
	{
		Set_Globals();
		prfmsg(MSG1307);
	}
	else if (sameas(margv[0], "I") && gameop) 
	{
		if (invasion->active)
		{
			invasion->duration = 1;
		}

		Set_Prompt(getmsg(MSG1319), INVASION_MON_PROMPT);
	}
	else if (sameas(margv[0], "J") && gameop) 
	{
		Set_Prompt(getmsg(MSG1389), LOCATE_ITEM_PROMPT); 
	}
	else if (sameas(margv[0], "K") && gameop) 
	{
		Set_Prompt(getmsg(MSG1390), LOCATE_MON_PROMPT); 
	}
	else if (sameas(margv[0], "L") && gameop) 
	{
		sprintf(prompt, getmsg(MSG1391), globals->maxitem);
		Set_Prompt(prompt, CREATE_NUM_PROMPT);
	}
	else if (sameas(margv[0], "M") && gameop) 
	{
		Reports();
	}
	else if (sameas(margv[0], "N") && gameop) 
	{
		Set_Prompt(getmsg(MSG1393), ZAP_PROMPT);
	}
	else if (sameas(margv[0], "O") && gameop) 
	{
		Set_Prompt(getmsg(MSG1394), SUSPEND_PROMPT);
	}
	else if (sameas(margv[0], "P") && gameop) 
	{
		List_Sysops();
		prf(NL);
		Set_Prompt(getmsg(MSG1388A), GAMEOP_PROMPT); 
	}
	else if (sameas(margv[0], "Q") && gameop) 
	{
		Terror();
		Set_Prompt(getmsg(MSG1388A), GAMEOP_PROMPT); 
	}
	else if (sameas(margv[0], "R") && gameop) 
	{
		Set_Prompt(getmsg(MSG1396), BOUNTY_PROMPT1); 
	}
	else if (sameas(margv[0], "S") && can_toggle) 
	{
		prf(NL);
		List_Permits(&me, -1);
		prf(NL);
		sprintf(prompt, getmsg(MSG1397), NUM_PERMS - 1);
		Set_Prompt(prompt, PERMIT_PROMPT);
	}
	else if (sameas(margv[0], "T") && gameop) 
	{
		Edit_Fame();
	}
	else
	{
		Set_Prompt(getmsg(MSG1388A), GAMEOP_PROMPT);
	}
	
	DONE;
}
/****************************************************************************
	prints users limits
*/
void List_Permits(struct charstruct *guy, short perm)
{

	ON_OFF(PLAYER_EDIT_PERM)
	prfmsg(M244A);

	ON_OFF(SUPER_PERM)
	prfmsg(M245);
	
	ON_OFF(NOHIT_PERM)
	prfmsg(MSG246);
	
	ON_OFF(KILLER_PERM)
	prfmsg(MSG247);
	
	ON_OFF(ROB_PERM)
	prfmsg(MSG248);
	
	ON_OFF(INVIS_PORT_PERM)
	prfmsg(MSG249);
	
	ON_OFF(ACTION_PERM)
	prfmsg(MSG250);
	
	ON_OFF(MPTS_PERM)
	prfmsg(MSG251);
	
	ON_OFF(GAMEOP_PERM)
	prfmsg(M252);
	
	ON_OFF(INTERCEPT_PERM)
	prfmsg(MSG253);

	ON_OFF(DEATH_PERM)
	prfmsg(MSG1502);

	ON_OFF(EDIT_PERM)
	prfmsg(MSG1534);
}
/****************************************************************************
	allows validated users to toggle their permissions
*/
short Set_Permit(struct charstruct *guy)
{
	short   perm;

	perm = INUM(margv[0]);

	if (perm >= NUM_PERMS)
	{
		prfmsg(MSG971, perm);
		return (-1);
	}

	guy->perm[perm] = abs(guy->perm[perm] - 1);
	return (perm);
}
/****************************************************************************
	edit a store's default items
*/
short Edit_Store(void)
{
	short   i;
	short   n;
	struct  item_struct         *item;
	struct  edit_info_struct    *e;

	e = &MY_PORT->edit;
	
	if (STATE == 0)
	{
		Set_Prompt("Enter room #:", EDIT_STORE_PROMPT);
		++STATE;
	}
	else if (STATE == 1)
	{
		if (margc == 0)
		{
			STATE = 0;
			BAD_EXIT;
		}

		e->room_num = INUM(margv[0]);
	
		if (e->room_num > globals->maxroom || e->room_num < 1)
		{
			prf("Valid room numbers are 1-%d.\r", globals->maxroom);
			STATE = 0;
			BAD_EXIT;
		}

		Read_Room(e->room_num, &e->room, &e->room2);

		if 
		(
			e->room.rmtype != ALCHEMIST &&
			e->room.rmtype != ARMORY &&
			e->room.rmtype != WEAPONSMITH &&
			e->room.rmtype != MERCANTILE
		)
		{
			prf("Room #%d is not a store.\r", e->room_num);
			STATE = 0;
			BAD_EXIT;
		}

		Read_Catalog(&globals->a_store, e->room_num, e->room.rmtype);

		for (i = 0; i != MAX_MERC_ITEM; ++i)
		{
			n = globals->a_store.new[i];

			if (n)
			{
				item = Create_Item(n, NULL, 100, globals->shoplevl, FALSE),
				prf("%2d. (%5d) ", i + 1, item->id);
				Display_Item(item);
				prf("\r");
			}
			else
			{
				prf("%2d. (not assigned)\r", i + 1);
			}
		}

		Set_Prompt("Enter catalog # to change:", EDIT_STORE_PROMPT);
		++STATE;
	}
	else if (STATE == 2)
	{
		if (margc == 0)
		{
			STATE = 0;
			BAD_EXIT;
		}

		e->item_num = INUM(margv[0]);
	
		if (e->item_num > MAX_MERC_ITEM || e->item_num < 1)
		{
			prf("Valid catalog numbers are 1-%d.\r", MAX_MERC_ITEM);
			STATE = 0;
			BAD_EXIT;
		}
		
		--e->item_num;
		Set_Prompt("Enter item #:", EDIT_STORE_PROMPT);
		++STATE;
	}
	else if (STATE == 3)
	{
		if (margc == 0)
		{
			STATE = 0;
			BAD_EXIT;
		}

		i = INUM(margv[0]);
	
		if (i > globals->maxitem || i < 1)
		{
			prf("Valid item numbers are 1-%d.\r", globals->maxitem);
			STATE = 0;
			BAD_EXIT;
		}

		Read_Catalog(&globals->a_store, e->room_num, e->room.rmtype);
		globals->a_store.new[e->item_num] = i;
		Write_Catalog(&globals->a_store, e->room_num);
		prf("Catalog Changed\r");

		if (ynopt(LOGEDITS))
		{
			sprintf
			(
				str,
				"%s edited store %d",
				me.Userid,
				e->room_num
			);
			NOTIFY(str);
		}

		STATE = 0;
	}

	DONE;
}
/****************************************************************************
	edit office holders
*/
short Edit_Offices(void)
{
	short   office_num;
	short   n;
	FILE    *fp;
	char    today_date[DATE_SIZE];
	char    now_time[TIME_SIZE];
	struct  public_post_struct *msg;    
	struct  edit_info_struct    *e;
	
	e = &MY_PORT->edit;
	
	if (STATE == 0)
	{
		for (n = 0; n != NUM_OFFICES; ++n)
		{
			prfmsg(MSG1169, n + 1, globals->offices[n]);
		}

		Set_Prompt("Enter office to set (1-4):", EDIT_OFFICE_PROMPT);
		++STATE;
	}
	else if (STATE == 1)
	{
		if (margc == 0)
		{
			STATE = 0;
			BAD_EXIT;
		}

		e->office_num = INUM(margv[0]);
	
		if (e->office_num > NUM_OFFICES || e->office_num < 1)
		{
			prf("Valid office numbers are 1-%d.\r", NUM_OFFICES);
			STATE = 0;
			BAD_EXIT;
		}

		Set_Prompt("Enter name of new office holder:", EDIT_OFFICE_PROMPT);
		++STATE;
	}
	else if (STATE == 2)
	{
		STATE = 0;

		if (margc == 0)
		{
			BAD_EXIT;
		}
		
		e->index = Find_A_Char(&a_char, margv[0]);

		if (e->index < 0)
		{
			prf("'%s' not found.\r", margv[0]);
			STATE = 0;
			BAD_EXIT;
		}

		office_num = e->office_num - 1;
			
		fp = fopen(VOTE_FILE, RDWR);
	
		if (fp == NULL)
		{
			NOTIFY("VOTE FILE OPEN FAILED!");
			BAD_EXIT;
		}
		
		lsk = (MLONG) office_num * OFFICE_SIZE;
		fseek(fp, lsk, TOP);
		fread(&vote, OFFICE_SIZE, 1, fp);

		globals->officers[office_num] = e->index;
		vote.index = e->index;
			   
		lsk = (MLONG) office_num * OFFICE_SIZE; 
		fseek(fp, lsk, TOP);
		fwrite(&vote, OFFICE_SIZE, 1, fp);
		fclose(fp);
			
		prfmsg
		(
			MSG1343,
			a_char.name,
			a_char.title,
			globals->offices[office_num]
		);
		prf("\r");

		msg = (struct public_post_struct *) vdaptr;                          
		setmem(msg, PUBLIC_MSG_SIZE, 0);
		msg->from = 0;
		msg->to = 0;
	
		TODAY(today_date);
		NOW(now_time);

		sprintf
		(
			msg->header, 
			getmsg(MSG1181),
			me.name,
			Brief_Userid(me.Userid),
			today_date,
			now_time
		);

		sprintf
		(
			msg->body[0], 
			getmsg(MSG1343),
			a_char.name,
			a_char.title,
			globals->offices[office_num]
		);

		Put_Public_Message(msg);
	}

	DONE;
}
/****************************************************************************
	god-like users can edit characters
*/
short Edit_Guy(short option)
{
	short   i;
	short   col;
	char    y_or_n[2];
	struct  edit_info_struct *e;

	e = &MY_PORT->edit;
	y_or_n[0] = 'N';
	y_or_n[1] = 'Y';

	if (option == 1)
	{
		if (margc == 0)
		{
			GameOp_Menu(0);
			DONE;
		}

		e->index = Find_A_Char(&e->a_char, margv[0]);

		if (e->index < 0)
		{
			prfmsg(M920, margv[0]);
			GameOp_Menu(0);
			DONE;
		}

		for (i = 0, e->active = -1; i != NTERMS; ++i)
		{
			if (sameas(APORT(i)->chr.name, margv[0]) && APORT(i)->status)
			{
				e->active = i;
				e->a_char = APORT(i)->chr;
				strcpy(e->old_name, e->a_char.name);
			}
		}
		
		prfmsg(MSG1422);
		Set_Prompt(getmsg(MSG1423), EDIT_GUY_PROMPT2);
		DONE;
	}
	else if (option == 2)
	{
		sprintf
		(
			vdatmp, 
			guy_edit_format, 
			e->a_char.name, '\0',
			e->a_char.title, '\0',
			e->a_char.Userid, '\0',
			e->a_char.Str, '\0',
			e->a_char.Dex, '\0',
			e->a_char.Con, '\0',
			e->a_char.Int, '\0',
			e->a_char.Psy, '\0',
			e->a_char.thief, '\0',
			e->a_char.shield, '\0',
			e->a_char.two_wep, '\0',
			e->a_char.defense, '\0',
			e->a_char.wep_plus[EDGED_IND], '\0',
			e->a_char.wep_plus[BLUNT_IND], '\0',
			e->a_char.wep_plus[POLE_IND], '\0',
			e->a_char.wep_plus[HAND_IND], '\0',
			e->a_char.class, '\0',
			e->a_char.race, '\0',
			e->a_char.outlaw, '\0',
			e->a_char.evil, '\0',
			e->a_char.in_guild, '\0',
			y_or_n[e->a_char.guild_master], '\0',
			e->a_char.guild_balance, '\0',
			e->a_char.bank, '\0',
			e->a_char.gold, '\0',
			e->a_char.location, '\0',
			e->a_char.lo_room, '\0',
			e->a_char.hi_room, '\0',
			e->a_char.lo_crit, '\0',
			e->a_char.hi_crit, '\0',
			e->a_char.lo_item, '\0',
			e->a_char.hi_item, '\0'
		);           

		clrprf();
		STATE = MSG1421A; 
		fsdroom(MSG1421A, guy_screen_spec, 1);
		fsdapr(vdaptr, vdasiz, vdatmp);
		fsdbkg(fsdrft());
		fsdego(vfyadn, Guy_Edit_Done);
		outprf(MY_PORT->usrnum);
		MY_PORT->editing = TRUE;
		DONE;
	}
	else if (option == 3)
	{
		for (i = col = 0; i != NUM_SPELLS; ++i)
		{
			prfmsg
			(
				MSG1425, 
				i + 1, 
				y_or_n[e->a_char.spell[i]], 
				spell_info[i].name
			);

			++col;

			if (col == 3)
			{
				col = 0;
				prf("\r");
			}
		}

		prf(NL);
		sprintf(str, getmsg(MSG1426), NUM_SPELLS);
		Set_Prompt(str, EDIT_GUY_PROMPT3);
	}
	else if (option == 4)
	{
		prf(NL);
		List_Permits(&MY_PORT->edit.a_char, -1);
		prf(NL);
		sprintf(prompt, getmsg(MSG1397), NUM_PERMS - 1);
		Set_Prompt(prompt, EDIT_GUY_PROMPT4);
	}
	else if (option == 5)
	{
		prf(NL);
		List_Options(&MY_PORT->edit.a_char, -1);
		prf(NL);
		sprintf(prompt, getmsg(MSG1427), NUM_OPTS - 1);
		Set_Prompt(prompt, EDIT_GUY_PROMPT5);
	}
	else if (option == 6)
	{
		if (e->active >= 0)
		{
			if 
			(
				sameas(e->old_name, APORT(e->active)->chr.name) && 
				APORT(e->active)->status
			)
			{
				APORT(e->active)->chr = e->a_char;
				Write_Him(e->active);
			}
		}
		else
		{
			Write_A_Char(e->index, &e->a_char);
		}

		if (ynopt(LOGEDITU))
		{
			sprintf
			(
				str,
				"%s edited %s",
				me.Userid,
				e->a_char.Userid
			);
			NOTIFY(str);
		}

		GameOp_Menu(0);
	}

	DONE;
}
/****************************************************************************
	finished editing player
*/
VOID Guy_Edit_Done(MSHORT save)
{
	short   i;
	struct  edit_info_struct *e;

	usrptr->state = my_module;

	for (i = 0; i != NTERMS; ++i)
	{
		if (APORT(i)->status && APORT(i)->usrnum == usrnum)
		{
			P = i;
			e = &MY_PORT->edit;
		}
	}

	setmbk(mui_cfg);

	if (save)
	{
		fsdfxt(0, e->a_char.name, NAME_LEN);
		fsdfxt(1, e->a_char.title, TYPE_SIZE);
		fsdfxt(2, e->a_char.Userid, USERID_SIZE);

		fsdfxt(3, str, 6);
		e->a_char.Str = POSNUM(str);
		fsdfxt(4, str, 6);
		e->a_char.Dex = POSNUM(str);
		fsdfxt(5, str, 6);
		e->a_char.Con = POSNUM(str);
		fsdfxt(6, str, 6);
		e->a_char.Int = POSNUM(str);
		fsdfxt(7, str, 6);
		e->a_char.Psy = POSNUM(str);
		fsdfxt(8, str, 6);
		e->a_char.thief = INUM(str);
		fsdfxt(9, str, 6);
		e->a_char.shield = atoi(str);
		fsdfxt(10, str, 6);
		e->a_char.two_wep = atoi(str);
		fsdfxt(11, str, 6);
		e->a_char.defense = atoi(str);
		fsdfxt(12, str, 6);
		e->a_char.wep_plus[EDGED_IND] = atoi(str);
		fsdfxt(13, str, 6);
		e->a_char.wep_plus[BLUNT_IND] = atoi(str);
		fsdfxt(14, str, 6);
		e->a_char.wep_plus[POLE_IND] = atoi(str);
		fsdfxt(15, str, 6);
		e->a_char.wep_plus[HAND_IND] = atoi(str);

		fsdfxt(16, str, 2);
		e->a_char.class = toupper(str[0]);
		fsdfxt(17, str, 2);
		e->a_char.race = toupper(str[0]);
		fsdfxt(18, str, 2);
		e->a_char.outlaw = toupper(str[0]);
		fsdfxt(19, str, 6);
		e->a_char.evil = atoi(str);
		fsdfxt(20, str, 2);
		e->a_char.in_guild = atoi(str);

		fsdfxt(21, str, 2);
		if (sameas(str, "Y"))
		{
			e->a_char.guild_master = TRUE;
		}
		else
		{
			e->a_char.guild_master = FALSE;
		}

		fsdfxt(22, str, 11);
		e->a_char.guild_balance = atol(str);
		fsdfxt(23, str, 11);
		e->a_char.bank = atol(str);
		fsdfxt(24, str, 11);
		e->a_char.gold = atol(str);
		fsdfxt(25, str, 6);
		e->a_char.location = atoi(str);

		fsdfxt(26, str, 6);
		e->a_char.lo_room = atoi(str);
		fsdfxt(27, str, 6);
		e->a_char.hi_room = atoi(str);
		fsdfxt(28, str, 6);
		e->a_char.lo_crit = atoi(str);
		fsdfxt(29, str, 6);
		e->a_char.hi_crit = atoi(str);
		fsdfxt(30, str, 6);
		e->a_char.lo_item = atoi(str);
		fsdfxt(31, str, 6);
		e->a_char.hi_item = atoi(str);

		Set_Guy_Points
		(
			&e->a_char.dpts,
			&e->a_char.mpts,
			e->a_char.Str,
			e->a_char.Con,
			e->a_char.Psy,
			e->a_char.class
		);
	}
	
	prfmsg(MSG1422);
	Set_Prompt(getmsg(MSG1423), EDIT_GUY_PROMPT2);
	outprf(MY_PORT->usrnum);
	clrprf();
	MY_PORT->editing = FALSE;
	rstmbk();
}
/****************************************************************************
	god-like users can edit perm monsters locations
*/
short Edit_Perm_Mon(void)
{
	short   loc;
	struct  edit_info_struct *e;

	e = &MY_PORT->edit;

	if (STATE == 0)
	{
		List_Perm_Monsters();
		++STATE;
		Set_Prompt("Enter monster #: ", EDIT_PERM_PROMPT);
	}
	else if (STATE == 1)
	{
		if (margc == 0)
		{
			STATE = 0;
			BAD_EXIT;
		}

		e->index = INUM(margv[0]);

		if (e->index >= MAX_MONSTER || e->index < 1)
		{
			prf("Bad monster number.\r");
			STATE = 0;
			BAD_EXIT;
		}

		Read_Critter(e->index, &crit);

		if (!crit.permanant)
		{
			prf
			(
				"Monster #%d (%s) is not a permanant monster\r",
				e->index,
				crit.name
			);
			STATE = 0;
			BAD_EXIT;
		}

		sprintf(prompt, "Location (%d)? ", crit.loc);
		Set_Prompt(prompt, EDIT_PERM_PROMPT);
		++STATE;
	}
	else if (STATE == 2)
	{
		if (margc == 0)
		{
			STATE = 0;
			BAD_EXIT;
		}

		loc = INUM(margv[0]);
		if (loc >= MAX_ROOM)
		{
			prf("Bad room number.\r");
			STATE = 0;
			BAD_EXIT;
		}

		if (crit.roving)
		{
			loc = -loc;
		}
	
		Update_Perm_Mon(e->index, loc);
		prf("%s moved to room %d.\r", crit.name, abs(loc));
		STATE = 0;

		if (ynopt(LOGEDITP))
		{
			sprintf
			(
				str,
				"%s edited perm %d",
				me.Userid,
				crit.which
			);
			NOTIFY(str);
		}
	}
	DONE;
}
/****************************************************************************
	god-like users can add/edit items
*/
short Edit_Items(short option)
{
	short   i;
	short   n;
	short   ac;
	short   bonus;
	short   hits;
	long    uses;
	long    worth;
	char    y_or_n[2];
	struct  edit_info_struct *e = &MY_PORT->edit;

	y_or_n[0] = 'N';
	y_or_n[1] = 'Y';

	if (option == 1)
	{
		if (margc == 0)
		{
			DONE;
		}

		e->where = margv[0][0];

		if (e->where == '1')
		{
			if (me.lo_item == 0 && me.hi_item == 0)
			{
				sprintf(str, getmsg(MSG1462A), 1, globals->maxitem);
			}
			else
			{
				sprintf(str, getmsg(MSG1462A), me.lo_item, me.hi_item);
			}

			Set_Prompt(str, EDIT_ITEM_PROMPT2);
			return (TRUE);
		}
		
		if (e->where == '2')
		{
			if (!me.perm[GAMEOP_PERM])
			{
				prfmsg(M880);
				DONE;
			}
			
			for (i = 0; i != NTERMS; ++i)
			{
				if (ABUF(i)->in_use)
				{
					prfmsg(MSG1463, i, ABUF(i)->rm.id);

					for (n = 0; n != NTERMS; ++n)
					{
						if (ABUF(i)->guy[n])
						{   
							prfmsg(MSG1464, n);
						}
					}
					prf(NL);
				}
			}

			Set_Prompt(getmsg(MSG1465), EDIT_ITEM_PROMPT3);
			return (TRUE);
		}
		
		if (e->where == '3')
		{
			if (!me.perm[GAMEOP_PERM])
			{
				prfmsg(M880);
				DONE;
			}

			Set_Prompt(getmsg(MSG1466), EDIT_ITEM_PROMPT4);
			return (TRUE);
		}
		
		if (e->where == '4')
		{
			List_Perm_Items();
			prf(NL);
			Set_Prompt(getmsg(MSG1217), EDIT_ITEM_PROMPT7);
			return (TRUE);
		}

		DONE;
	}
	
	if (option == 2)
	{
		if (margc == 0)
		{
			DONE;
		}

		n = INUM(margv[0]);
	
		if (n > globals->maxitem || n < 1)
		{
			DONE;
		}

		if 
		(
			(me.lo_item && n < me.lo_item) ||
			(me.hi_item && n > me.hi_item)
		)
		{
			prfmsg(MSG1487, me.lo_item, me.hi_item);
			BAD_EXIT;
		}
		
		e->item_num = n;
		Read_Item(n, &e->item);
		option = 7;
	}
	
	if (option == 3)
	{
		if (margc == 0)
		{
			DONE;
		}

		e->b = INUM(margv[0]);
		if (e->b >= NTERMS || !ABUF(e->b)->in_use)
		{
			DONE;
		}

		for (i = 0; i != NUM_ITEMS; ++i)
		{
			if (ABUF(e->b)->item[i].what)
			{
				prfmsg(MSG1467, i);
				Display_Item(&ABUF(e->b)->item[i]);
				prf(NL);
			}
		}
		
		Set_Prompt(getmsg(MSG1468), EDIT_ITEM_PROMPT5);
		return (TRUE);
	}
	
	if (option == 4)
	{
		if (margc == 0)
		{
			DONE;
		}
		
		e->index = Find_A_Char(&e->a_char, margv[0]);

		if (e->index < 0)
		{
			prfmsg(M920, margv[0]);
			DONE;
		}

		for (i = 0, e->active = -1; i != NTERMS; ++i)
		{
			if (sameas(APORT(i)->chr.name, margv[0]) && APORT(i)->status)
			{
				e->active = i;
				e->a_char = APORT(i)->chr;
			}
		}

		for (i = 0; i != NUM_ITEMS; ++i)
		{
			if (e->a_char.item[i].what)
			{
				prfmsg(MSG1467, i);
				Display_Item(&e->a_char.item[i]);
				prf(NL);
			}
		}

		Set_Prompt(getmsg(MSG1468), EDIT_ITEM_PROMPT6);
		return (TRUE);
	}
	
	if (option == 5)
	{
		if (margc == 0)
		{
			BAD_EXIT;
		}

		e->item_num = INUM(margv[0]);

		if 
		(
			e->item_num >= NUM_ITEMS || 
			ABUF(e->b)->item[e->item_num].what == 0
		)
		{
			DONE;
		}

		e->item = ABUF(e->b)->item[e->item_num];
		option = 7;
	}
	
	if (option == 6)
	{
		if (margc == 0)
		{
			DONE;
		}

		e->item_num = INUM(margv[0]);

		if 
		(
			e->item_num >= NUM_ITEMS || 
			e->a_char.item[e->item_num].what == 0
		)
		{
			DONE;
		}

		e->item = e->a_char.item[e->item_num];
		option = 7;
	}

	if (option == 7)
	{
		if (e->item.what == TRINKET && e->item.which == PUZZLE)
		{
			hits = 0;
			ac = 0;
			bonus = 0;
			uses = 0;
		}
		else if ((e->where != '1' || e->item.static_item) && ARSH(e->item))
		{
			hits = 0;
			ac = e->item.ac;
			bonus = e->item.bonus;
			uses = e->item.uses;
		}
		else if ((e->where != '1' || e->item.static_item) && WEAPON(e->item))
		{
			hits = e->item.Hits;
			bonus = e->item.bonus;
			ac = 0;
			uses = e->item.uses;
		}
		else if
		(
			(e->where != '1' || e->item.static_item) &&
			(
				e->item.what == CONTAINER ||
				e->item.what == MAGIC_DEV ||
				e->item.what == AMULET ||
				e->item.what == PSY_FOCUS
			)
		)
		{
			hits = 0;
			ac = 0;
			bonus = 0;
			uses = e->item.uses;
		}
		else
		{
			hits = 0;
			ac = 0;
			bonus = 0;
			uses = 0;
		}
		
		if (e->where != '1' || e->item.static_item)
		{
			worth = e->item.worth;
		}
		else
		{
			worth = 0;
		}

		if (e->item.class == 0)
		{
			e->item.class = ' ';
		}

		if (e->item.race == 0)
		{
			e->item.race = ' ';
		}

		sprintf
		(
			vdatmp, 
			item_edit_format, 
			e->item.article, '\0',
			e->item.adjective, '\0',
			e->item.name, '\0',
			item_types[e->item.what], '\0',
			item_subtypes[e->item.which], '\0',
			e->item.item_level, '\0',
			y_or_n[e->item.permanant], '\0',
			y_or_n[abs(e->item.no_repair - 1)], '\0',
			y_or_n[e->item.text_file], '\0',
			y_or_n[abs(e->item.no_instill - 1)], '\0',
			y_or_n[e->item.ring_used], '\0',
			y_or_n[e->item.infinite_uses], '\0',
			e->item.race, '\0',
			e->item.class, '\0',
			y_or_n[e->item.static_item], '\0',
			worth, '\0',
			uses, '\0',
			hits, '\0',
			ac, '\0',
			bonus, '\0'
		);           

		clrprf();
		STATE = MSG1459B; 
		fsdroom(MSG1459B, item_screen_spec, 1);
		fsdapr(vdaptr, vdasiz, vdatmp);
		fsdbkg(fsdrft());
		fsdego(vfyadn, Item_FSE_Done);
		outprf(MY_PORT->usrnum);
		MY_PORT->editing = TRUE;
		return (TRUE);
	}

	if (option == 8)
	{
		if (e->item.what == MAGIC_DEV && e->item.which == SPECIAL_KEY)
		{
			e->item.spell_cast = MAGIC_KEY;
		}
		else if (e->item.ring_used || e->item.what == MAGIC_DEV)
		{
			prf(NL);

			if (e->item.what == MAGIC_DEV)
			{
				Print_All_Spells();
			}
			else if (WEAPON(e->item))
			{
				Print_Weapon_Spells();
			}
			else
			{
				Print_Arsh_Spells();
			}
	
			sprintf
			(
				prompt,
				getmsg(MSG1469),
				e->item.spell_cast,
				spell_info[e->item.spell_cast].name
			);
			Set_Prompt(prompt, EDIT_ITEM_PROMPT9);
			DONE;
		}
		else
		{
			e->item.spell_cast = 0;
		}

		option = 10;
	}
	
	if (option == 9)
	{
		Set_Int(&e->item.spell_cast);
		option = 10;
	}

	if (option == 10)
	{
		if (e->item.what == MAGIC_DEV && e->item.which == SPECIAL_KEY)
		{
			sprintf(prompt, getmsg(MSG1471), e->item.holding);
			Set_Prompt(prompt, EDIT_ITEM_PROMPT11);
			DONE;
		}
		
		if (e->item.what == TRINKET && e->item.which == PUZZLE)
		{
			sprintf(prompt, getmsg(MSG1472), e->item.holding);
			Set_Prompt(prompt, EDIT_ITEM_PROMPT11);
			DONE;
		}
		
		if (e->item.what != CONTAINER)
		{
			e->item.holding = 0;
		}

		option = 12;
	}
	
	if (option == 11)
	{
		Set_Int(&e->item.holding);
		option = 12;
	}

	if (option == 12)
	{
		if (e->item.what == TRINKET && e->item.which == PUZZLE)
		{                                               
			sprintf(prompt, getmsg(MSG1473), e->item.ac);
			Set_Prompt(prompt, EDIT_ITEM_PROMPT13);
			DONE;
		}
		
		if ((e->where == '1' && !e->item.static_item) || !ARSH(e->item))
		{
			e->item.ac = 0;
		}

		option = 15;
	}
	
	if (option == 13)                        
	{
		Set_Int(&e->item.ac);

		if (e->item.ac < 1 || e->item.ac > NUM_ITEMS)
		{
			prfmsg(MSG1474, NUM_ITEMS); 
			e->item.ac = 1;
		}

		if (e->item.bonus > 0 && e->item.bonus <= globals->maxitem)
		{
			Read_Item(e->item.bonus, &item);
		}
		else
		{
			strcpy(item.name, "Nothing");
		}

		sprintf(prompt, getmsg(MSG1475), e->item.bonus, item.name);
		Set_Prompt(prompt, EDIT_ITEM_PROMPT14);
		DONE;
	}

	if (option == 14)
	{
		Set_Int(&e->item.bonus);

		if (e->item.bonus < 1 || e->item.bonus > globals->maxitem)
		{
			prfmsg(MSG1476, globals->maxitem); 
			e->item.bonus = 1;           
		}

		option = 15;
	}

	if (option == 15)
	{
		if (e->item.what == TRANSPORTER)    
		{
			sprintf(prompt, getmsg(MSG1477), e->item.room);
			Set_Prompt(prompt, EDIT_ITEM_PROMPT16);
			DONE;
		}
		
		if (e->item.permanant)
		{
			sprintf(prompt, getmsg(MSG1478), e->item.room);
			Set_Prompt(prompt, EDIT_ITEM_PROMPT16);
			DONE;
		}

		option = 17;
	}
	
	if (option == 16)
	{
		Set_Int(&e->item.room);

		if (e->item.room < 1 || e->item.room > globals->maxroom)
		{
			i = RANDOM(globals->maxroom);
		}
		else
		{
			i = e->item.room;
		}

		if (margc && e->item.permanant)
		{
			Update_Perm_Item(e->item_num, i);
			prfmsg(MSG1479, e->item.name, i);
		}

		option = 17;
	}

	if (option == 17)
	{
		if (e->where == '1')
		{
			Write_Item(&e->item, e->item_num);

			if (e->item.what == CONTAINER)
			{
				Init_Free_Bag(&e->item);
			}

			if (ynopt(LOGEDITI))
			{
				sprintf
				(
					str,
					"%s edited file item %d",
					me.Userid,
					e->item.id
				);
				NOTIFY(str);
			}
		}
		else if (e->where == '2')
		{
			ABUF(e->b)->item[e->item_num] = e->item;

			if (ynopt(LOGEDITI))
			{
				sprintf
				(
					str,
					"%s edited room item %d",
					me.Userid,
					e->item.id
				);
				NOTIFY(str);
			}
		}
		else
		{
			if (e->active >= 0)
			{
				if 
				(
					sameas(e->a_char.name, APORT(e->active)->chr.name) && 
					APORT(e->active)->status
				)
				{
					APORT(e->active)->chr.item[e->item_num] = e->item;
					Write_Him(e->active);
				}
			}
			else
			{
				e->a_char.item[e->item_num] = e->item;
				Write_A_Char(e->index, &e->a_char);
			}

			if (ynopt(LOGEDITI))
			{
				sprintf
				(
					str,
					"%s edited %s's item %d",
					me.Userid,
					e->a_char.Userid,
					e->item.id
				);
				NOTIFY(str);
			}
		}

		prfmsg(MSG1460);
		Set_Prompt(getmsg(MSG1461), EDIT_ITEM_PROMPT1);
	}

	DONE;
}
/****************************************************************************
	finished item FSDE
*/
VOID Item_FSE_Done(MSHORT save)
{
	short   i;
	struct  edit_info_struct *e;

	usrptr->state = my_module;

	for (i = 0; i != NTERMS; ++i)
	{
		if (APORT(i)->status && APORT(i)->usrnum == usrnum)
		{
			P = i;
			e = &MY_PORT->edit;
		}
	}

	setmbk(mui_cfg);

	if (save)
	{
		fsdfxt(0, e->item.article, ARTICLE_SIZE);
		fsdfxt(1, e->item.adjective, LABEL_SIZE);
		fsdfxt(2, e->item.name, ITEM_NOUN_SIZE);
	 
		fsdfxt(3, str, 13);
		for (i = 0; i != MAX_ITEM_WHAT; ++i)
		{
			if (sameas(str, item_types[i]))
			{
				e->item.what = i;
			}
		}

		fsdfxt(4, str, 13);
		for (i = 0; i != MAX_ITEM_WHICH; ++i)
		{
			if (sameas(str, item_subtypes[i]))
			{
				e->item.which = i;
			}
		}

		if (WEAPON(e->item))
		{
			if (e->item.which != TWOHAND && e->item.which != LITE_WEP)
			{
				e->item.which = 0;
			}
		}
		else if (e->item.what == ARMOR)
		{
			if (e->item.which != LITE_ARMOR)
			{
				e->item.which = 0;
			}
		}
		else if (e->item.what == SHIELD)
		{
			if (e->item.which != LITE_SHIELD && e->item.which != NODROP)
			{
				e->item.which = 0;
			}
		}
		else if (e->item.what == MAGIC_DEV)
		{
			if 
			(
				e->item.which != SKELETON_KEY && 
				e->item.which != SCROLL &&
				e->item.which != MAGIC_RING && 
				e->item.which != SPECIAL_KEY
			)
			{
				e->item.which = 0;
			}
		}
		else if (e->item.what == CONTAINER)
		{
			if (e->item.which != MAGIC_CONT)
			{
				e->item.which = 0;
			}
		}
		else if (e->item.what == TRINKET)
		{
			if (e->item.which != PUZZLE)
			{
				e->item.which = 0;
			}
		}
		else
		{
			e->item.which = 0;
		}

		fsdfxt(5, str, 6);
		e->item.item_level = atoi(str);
		if (e->item.item_level < 0)
		{
			e->item.item_level = 0;
		}

		fsdfxt(6, str, 2);
		if (sameas(str, "Y"))
		{
			e->item.permanant = TRUE;
		}
		else
		{
			e->item.permanant = FALSE;
		}

		fsdfxt(7, str, 2);
		if (sameas(str, "Y"))
		{
			e->item.no_repair = FALSE;
		}
		else
		{
			e->item.no_repair = TRUE;
		}

		fsdfxt(8, str, 2);
		if (sameas(str, "Y"))
		{
			e->item.text_file = TRUE;
		}
		else
		{
			e->item.text_file = FALSE;
		}

		fsdfxt(9, str, 2);
		if (sameas(str, "Y"))
		{
			e->item.no_instill = FALSE;
		}
		else
		{
			e->item.no_instill = TRUE;
		}

		if (ARSH(e->item) || WEAPON(e->item))
		{
			fsdfxt(10, str, 2);
			if (sameas(str, "Y"))
			{
				e->item.ring_used = TRUE;
			}
			else
			{
				e->item.ring_used = FALSE;
			}
		}
		else
		{
			e->item.ring_used = FALSE;
		}

		fsdfxt(11, str, 2);
		if (sameas(str, "Y"))
		{
			e->item.infinite_uses = TRUE;
		}
		else
		{
			e->item.infinite_uses = FALSE;
		}

		fsdfxt(12, str, 2);
		str[0] = toupper(str[0]);
		e->item.race = str[0];

		fsdfxt(13, str, 2);
		str[0] = toupper(str[0]);
		e->item.class = str[0];

		fsdfxt(14, str, 2);
		if (sameas(str, "Y"))
		{
			e->item.static_item = TRUE;
		}
		else
		{
			e->item.static_item = FALSE;
		}

		if (e->where != '1' || e->item.static_item)
		{
			fsdfxt(15, str, 10);
			e->item.worth = atol(str);
			if (e->item.worth < 0)
			{
				e->item.worth = 0;
			}
		}
		else
		{
			e->item.worth = 0;
		}

		if
		(
			(e->where != '1' || e->item.static_item) &&
			(
				ARSH(e->item) || 
				WEAPON(e->item) ||
				e->item.what == CONTAINER ||
				e->item.what == MAGIC_DEV ||
				e->item.what == AMULET ||
				e->item.what == PSY_FOCUS
			)
		)
		{
			fsdfxt(16, str, 6);
			e->item.uses = atol(str);
			if (e->item.uses < 1)
			{
				e->item.uses = 1;
			}
		}
		else
		{
			e->item.uses = 0;
		}

		if ((e->where != '1' || e->item.static_item) && WEAPON(e->item))
		{
			fsdfxt(17, str, 6);
			e->item.Hits = atoi(str);
			if (e->item.Hits < 1)
			{
				e->item.Hits = 1;
			}
		}
		else
		{
			e->item.Hits = 0;
		}

		if ((e->where != '1' || e->item.static_item) && ARSH(e->item))
		{
			fsdfxt(18, str, 6);
			e->item.ac = atoi(str);
			if (e->item.ac < 1)
			{
				e->item.ac = 1;
			}
		}

		if 
		(
			(e->where != '1' || e->item.static_item) && 
			(ARSH(e->item) || WEAPON(e->item))
		)
		{
			fsdfxt(19, str, 6);
			e->item.bonus = atoi(str);
			if (e->item.bonus < 0)
			{
				e->item.bonus = 0;
			}
		}

		if (e->item.what == CONTAINER)
		{
			sprintf(str, getmsg(MSG1470), e->item.bag_index);
			prf(str);
		}
		
		if (e->item.text_file)
		{
			sprintf(str, "%s\\I%d.TXT", globals->textdir, e->item.id);
			prfmsg(M1379, str);
		}

		Edit_Items(8);
	}
	else
	{
		GameOp_Menu(0);
	}

	outprf(MY_PORT->usrnum);
	clrprf();
	MY_PORT->editing = FALSE;
	rstmbk();
}
/****************************************************************************
	god-like users can add/edit monsters
*/
short Edit_Monsters(short option)
{
	short   done;
	short   i;
	short   n;
	struct  edit_info_struct *e = &MY_PORT->edit;
	char    y_or_n[2];
	char    item_name[POSSIBLE_MON_ITEM][ITEM_NAME_SIZE];
	
	y_or_n[0] = 'N';
	y_or_n[1] = 'Y';

	if (option == 1)
	{
		if (margc == 0)
		{
			DONE;
		}

		n = INUM(margv[0]);
	
		if (n > globals->maxmon || n < 1)
		{
			DONE;
		}

		if 
		(
			(me.lo_crit && n < me.lo_crit) ||
			(me.hi_crit && n > me.hi_crit)
		)
		{
			prfmsg(MSG1486, me.lo_crit, me.hi_crit);
			BAD_EXIT;
		}

		Read_Critter(n, &e->crit);

		for (i = 0; i != POSSIBLE_MON_ITEM; ++i)
		{
			if (!e->crit.Item[i])
			{
				item_name[i][0] = 0;
			}
			else
			{
				Read_Item(e->crit.Item[i], &item);
				sprintf
				(
					item_name[i], 
					"%s %s %s", 
					item.article,
					item.adjective,
					item.name
				);
			}
		}

		sprintf
		(
			vdatmp, 
			mon_edit_format, 
			e->crit.article, '\0',
			e->crit.name, '\0',
			e->crit.plural_name, '\0',
			mon_types[e->crit.what], '\0',
			e->crit.Level, '\0',
			y_or_n[e->crit.alg], '\0',
			y_or_n[e->crit.spell_caster], '\0',
			y_or_n[e->crit.magical], '\0',
			y_or_n[e->crit.magic_immune], '\0',
			y_or_n[e->crit.blocks], '\0',
			y_or_n[e->crit.permanant], '\0',
			att[e->crit.attacked_vector], '\0',
			hit[e->crit.hit_vector], '\0',
			y_or_n[e->crit.look_text_file], '\0',
			y_or_n[e->crit.talk_text_file], '\0',
			e->crit.talk, '\0',
			e->crit.Item[0], '\0',
			item_name[0], '\0',
			e->crit.Item[1], '\0',
			item_name[1], '\0',
			e->crit.Item[2], '\0',
			item_name[2], '\0',
			e->crit.Item[3], '\0',
			item_name[3], '\0',
			e->crit.Item[4], '\0',
			item_name[4], '\0'
		);           

		clrprf();
		STATE = MSG1428; 
		fsdroom(MSG1428, mon_screen_spec, 1);
		fsdapr(vdaptr, vdasiz, vdatmp);
		fsdbkg(fsdrft());
		fsdscb->flddat[17].flags |= FFFAVD;
		fsdscb->flddat[19].flags |= FFFAVD;
		fsdscb->flddat[21].flags |= FFFAVD;
		fsdscb->flddat[23].flags |= FFFAVD;
		fsdscb->flddat[25].flags |= FFFAVD;
		fsdego(vfyadn, Mon_FSE_Done);
		outprf(MY_PORT->usrnum);
		MY_PORT->editing = TRUE;
		return (TRUE);
	}
	
	if (option == 2)
	{
		if (e->crit.permanant)
		{
			prfmsg(MSG1431);
			sprintf(prompt, getmsg(MSG1432), yn[e->crit.roving]);
			Set_Prompt(prompt, EDIT_MON_PROMPT3);
			DONE;
		}
		else
		{
			option += 2;
		}
	}
	
	if (option == 3)
	{
		if (margc && sameas(margv[0], "y"))
		{
			e->crit.roving = TRUE;
		}
		else if (margc && sameas(margv[0], "n"))
		{
			e->crit.roving = FALSE;
		}

		++option;
	}

	if (option == 4)
	{
		if (e->crit.permanant && e->crit.roving)
		{
			prfmsg(MSG1433);
			sprintf(prompt, getmsg(MSG1434), yn[e->crit.static_rover]);
			Set_Prompt(prompt, EDIT_MON_PROMPT5);
			DONE;
		}
		else
		{
			option += 2;
		}
	}

	if (option == 5)
	{
		if (margc && sameas(margv[0], "y"))
		{
			e->crit.static_rover = TRUE;
		}
		else if (margc && sameas(margv[0], "n"))
		{
			e->crit.static_rover = FALSE;
		}

		++option;
	}

	if (option == 6)
	{
		if (e->crit.permanant)
		{
			if (e->crit.roving && !e->crit.static_rover)
			{
				e->crit.loc = Find_Non_Town_Room();
				++option;
			}
			else
			{
				sprintf(prompt, getmsg(MSG1435), e->crit.loc);
				Set_Prompt(prompt, EDIT_MON_PROMPT7);
				DONE;
			}
		}
		else
		{
			option += 2;
		}
	}

	if (option == 7)
	{
		if (margc && (!e->crit.roving || e->crit.static_rover))
		{
			Set_Int(&e->crit.loc);
		}

		for (i = done = 0; i != MAX_PERM_MON && !done; ++i)
		{
			if (globals->perm_mon_id[i] == e->crit.which)
			{
				done = TRUE;

				if (e->crit.roving)
				{
					globals->perm_mon_loc[i] = -(e->crit.loc);
				}
				else
				{
					globals->perm_mon_loc[i] = e->crit.loc;
				}
			}
		}           
		
		if (!done)
		{
			for (i = done = 0; i != MAX_PERM_MON && !done; ++i)
			{
				if (globals->perm_mon_id[i] == 0)
				{
					globals->perm_mon_id[i] = e->crit.which;
					done = TRUE;

					if (e->crit.roving)
					{
						globals->perm_mon_loc[i] = -(e->crit.loc);
					}
					else
					{
						globals->perm_mon_loc[i] = e->crit.loc;
					}
				}
			}
		}           

		++option;
	}

	if (option == 8)
	{
		if (e->crit.what != HUNTRESS)
		{
			option += 2;
		}
		else
		{
			if 
			(
				e->crit.huntress_item > globals->maxitem ||
				e->crit.huntress_item < 1
			)
			{
				e->crit.huntress_item = globals->talindex;
			}

			item.name[0] = 0;
			Read_Item(e->crit.huntress_item, &item);

			prfmsg(MSG1436);
			sprintf(prompt, getmsg(MSG1437), e->crit.huntress_item, item.name);
			Set_Prompt(prompt, EDIT_MON_PROMPT9);
			DONE;
		}
	}

	if (option == 9)
	{
		Set_Int(&e->crit.huntress_item);

		if 
		(
			e->crit.huntress_item > globals->maxitem ||
			e->crit.huntress_item < 1
		)
		{
			e->crit.huntress_item = globals->talindex;
		}

		++option;
	}

	if (option == 10)
	{
		if (e->crit.what != HUNTRESS)
		{
			option += 2;
		}
		else
		{
			if (e->crit.quests <= 0)
			{
				e->crit.quests = globals->huntqsts;
			}

			sprintf
			(
				prompt, 
				getmsg(MSG1438),
				e->crit.quests 
			);
			Set_Prompt(prompt, EDIT_MON_PROMPT11);
			DONE;
		}
	}

	if (option == 11)
	{
		Set_Int(&e->crit.quests);

		if (e->crit.quests <= 0)
		{
			e->crit.quests = globals->huntqsts;
		}

		++option;
	}

	if (option == 12)
	{
		if (e->crit.attacked_vector != MORPH)
		{
			option += 2;
		}
		else
		{
			if (e->crit.morph < 1)
			{
				e->crit.morph = 1;
			}

			prfmsg(MSG1439);
			sprintf(prompt, getmsg(MSG1440), e->crit.morph);
			Set_Prompt(prompt, EDIT_MON_PROMPT13);
			DONE;
		}
	}

	if (option == 13)
	{
		Set_Int(&e->crit.morph);
		
		if (e->crit.morph < 1)
		{
			e->crit.morph = 1;
		}

		++option;
	}

	if (option == 14)
	{
		if (e->crit.attacked_vector != ADD_EVIL)
		{
			option += 2;
		}
		else
		{
			if (e->crit.evil_pts <= 0)
			{
				e->crit.evil_pts = numopt(ADDEVIL, -32767, 32767);
			}

			prfmsg(MSG1441);
			sprintf(prompt, getmsg(MSG1442), e->crit.evil_pts);
			Set_Prompt(prompt, EDIT_MON_PROMPT15);
			DONE;
		}
	}

	if (option == 15)
	{
		Set_Int(&e->crit.evil_pts);

		if (e->crit.evil_pts <= 0)
		{
			e->crit.evil_pts = numopt(ADDEVIL, -32767, 32767);
		}
	}

	Mon_Edit_Done();
	DONE;
}
/****************************************************************************
	finished monster FSDE
*/
VOID Mon_FSE_Done(MSHORT save)
{
	short   i;
	struct  edit_info_struct *e;

	usrptr->state = my_module;

	for (i = 0; i != NTERMS; ++i)
	{
		if (APORT(i)->status && APORT(i)->usrnum == usrnum)
		{
			P = i;
			e = &MY_PORT->edit;
		}
	}

	setmbk(mui_cfg);

	if (save)
	{
		fsdfxt(0, e->crit.article, ARTICLE_SIZE);
		fsdfxt(1, e->crit.name, NAME_LEN);
		fsdfxt(2, e->crit.plural_name, PLURAL_SIZE);

		fsdfxt(3, str, 9);
		for (i = 0; i != MAX_MON_WHAT; ++i)
		{
			if (sameas(str, mon_types[i]))
			{
				e->crit.what = i;
			}
		}

		fsdfxt(4, str, 6);
		e->crit.Level = atoi(str);
		if (e->crit.Level <= 0)
		{
			e->crit.Level = 1;
		}

		fsdfxt(5, str, 2);
		if (sameas(str, "Y"))
		{
			e->crit.alg = TRUE;
		}
		else
		{
			e->crit.alg = FALSE;
		}

		fsdfxt(6, str, 2);
		if (sameas(str, "Y"))
		{
			e->crit.spell_caster = TRUE;
		}
		else
		{
			e->crit.spell_caster = FALSE;
		}

		fsdfxt(7, str, 2);
		if (sameas(str, "Y"))
		{
			e->crit.magical = TRUE;
		}
		else
		{
			e->crit.magical = FALSE;
		}
		
		fsdfxt(8, str, 2);
		if (sameas(str, "Y"))
		{
			e->crit.magic_immune = TRUE;
		}
		else
		{
			e->crit.magic_immune = FALSE;
		}
		
		fsdfxt(9, str, 2);
		if (sameas(str, "Y"))
		{
			e->crit.blocks = TRUE;
		}
		else
		{
			e->crit.blocks = FALSE;
		}
		
		fsdfxt(10, str, 2);
		if (sameas(str, "Y"))
		{
			e->crit.permanant = TRUE;
		}
		else
		{
			e->crit.permanant = FALSE;
		}
		
		fsdfxt(11, str, 11);
		for (i = 0; i != NUM_ATT_VECTORS; ++i)
		{
			if (sameas(str, att[i]))
			{
				e->crit.attacked_vector = i;
			}
		}

		fsdfxt(12, str, 11);
		for (i = 0; i != NUM_HIT_VECTORS; ++i)
		{
			if (sameas(str, hit[i]))
			{
				e->crit.hit_vector = i;
			}
		}

		fsdfxt(13, str, 2);
		if (sameas(str, "Y"))
		{
			e->crit.look_text_file = TRUE;
		}
		else
		{
			e->crit.look_text_file = FALSE;
		}

		fsdfxt(14, str, 2);
		if (sameas(str, "Y"))
		{
			e->crit.talk_text_file = TRUE;
		}
		else
		{
			e->crit.talk_text_file = FALSE;
		}

		fsdfxt(15, e->crit.talk, TALK_SIZE);

		fsdfxt(16, str, 6);
		e->crit.Item[0] = INUM(str);
		fsdfxt(18, str, 6);
		e->crit.Item[1] = INUM(str);
		fsdfxt(20, str, 6);
		e->crit.Item[2] = INUM(str);
		fsdfxt(22, str, 6);
		e->crit.Item[3] = INUM(str);
		fsdfxt(24, str, 6);
		e->crit.Item[4] = INUM(str);

		for (i = 0; i != POSSIBLE_MON_ITEM; ++i)
		{
			if (e->crit.Item[i] > globals->maxitem)
			{
				e->crit.Item[i] = 0;
			}
		}

		if (!e->crit.permanant)
		{
			for (i = 0; i != MAX_PERM_MON; ++i)
			{
				if (globals->perm_mon_id[i] == e->crit.which)
				{
					globals->perm_mon_loc[i] = 0;
					globals->perm_mon_id[i] = 0;
					globals->perm_mon_dmg[i] = 0;
				}
			}

			e->crit.loc = 0;
			e->crit.roving = FALSE;
		}

		Edit_Monsters(2);
	}
	else
	{
		GameOp_Menu(0);
	}

	outprf(MY_PORT->usrnum);
	clrprf();
	MY_PORT->editing = FALSE;
	rstmbk();
}
/****************************************************************************
	finished room FSDE
*/
VOID Room_FSE_Done(MSHORT save)
{
	short   i;
	short   n;
	struct  edit_info_struct *e;

	usrptr->state = my_module;

	for (i = 0; i != NTERMS; ++i)
	{
		if (APORT(i)->status && APORT(i)->usrnum == usrnum)
		{
			P = i;
			e = &MY_PORT->edit;
		}
	}

	setmbk(mui_cfg);

	if (save)
	{
		fsdfxt(0, str, 14);

		for (i = 0; i != NUM_ROOM_TYPES; ++i)
		{
			if (sameas(str, room_types[i]))
			{
				e->room.rmtype = i - 9;
			}
		}

		fsdfxt(1, e->room.desc[0], DESC_SIZE);
		fsdfxt(2, e->room.desc[1], DESC_SIZE);
		fsdfxt(3, e->room.desc[2], DESC_SIZE);
		fsdfxt(4, e->room.desc[3], DESC_SIZE);
		fsdfxt(5, e->room.desc[4], DESC_SIZE);
		fsdfxt(6, e->room.desc[5], DESC_SIZE);

		for (i = 0; i != NUM_EXITS; ++i)
		{
			fsdfxt(i + 7, str, 6);
			n = atoi(str);

			if (n > 0 && n <= globals->maxroom)
			{
				e->room.exit[i] = n;
			}
			else
			{
				e->room.exit[i] = 0;
			}
		}

		for (i = 0; i != NUM_EXITS; ++i)
		{
			fsdfxt(i + 14, str, 2);

			if (sameas(str, "Y") && e->room.exit[i])
			{
				e->room.Visible[i] = TRUE;
			}
			else
			{
				e->room.Visible[i] = FALSE;
			}
		}

		fsdfxt(21, e->room.spec_exit.article, SPEC_ARTICLE_SIZE);
		fsdfxt(22, e->room.spec_exit.adjective, LABEL_SIZE);
		fsdfxt(23, e->room.spec_exit.descriptor, DESCRIPTOR_SIZE);

		fsdfxt(24, str, 6);
		n = atoi(str);

		if (n > 0 && n <= globals->maxroom)
		{
			e->room.spec_exit.leads_to = n;
		}
		else
		{
			e->room.spec_exit.leads_to = 0;
		}

		fsdfxt(25, str, 2);
		if (sameas(str, "Y") && e->room.spec_exit.leads_to)
		{
			e->room.spec_exit.Visible = TRUE;
		}
		else
		{
			e->room.spec_exit.Visible = FALSE;
		}

		fsdfxt(26, str, 8);

		for (i = 0; i != NUM_SPEC_TYPES; ++i)
		{
			if (sameas(str, spec_types[i]))
			{
				e->room.spec_exit.type = i;

				if (e->room.spec_exit.leads_to && i == 0)
				{
					e->room.spec_exit.type = NOT_SPECIAL;
				}
			}
		}

		if (e->room.spec_exit.type <= NOT_SPECIAL)
		{
			e->room.spec_exit.locked = FALSE;
		}
		else
		{
			e->room.spec_exit.locked = TRUE;
		}

		fsdfxt(27, str, 9);

		for (i = 0; i != MAX_FILTERS; ++i)
		{
			if (sameas(str, filters[i]))
			{
				e->room.spec_exit.filter = i;
			}
		}

		if (e->room.spec_exit.leads_to == 0)
		{
			e->room.spec_exit.article[0] = 0;
			e->room.spec_exit.adjective[0] = 0;
			e->room.spec_exit.descriptor[0] = 0;
			e->room.spec_exit.Visible = FALSE;
			e->room.spec_exit.type = 0;
			e->room.spec_exit.filter = 0;
		}

		fsdfxt(28, str, 12);

		for (i = 0; i != NUM_TRAPS; ++i)
		{
			if (sameas(str, trap_types[i]))
			{
				e->room.trap = i;
			}
		}

		fsdfxt(29, str, 4);
		e->room.cover = atoi(str);

		if (e->room.cover < 0)
		{
			e->room.cover = 0;
		}
		else if (e->room.cover > 100)
		{
			e->room.cover = 100;
		}

		fsdfxt(30, str, 2);
		if (sameas(str, "Y"))
		{
			e->room.no_teleport = TRUE;
		}
		else
		{
			e->room.no_teleport = FALSE;
		}

		fsdfxt(31, str, 2);
		if (sameas(str, "Y"))
		{
			e->room.town = TRUE;
		}
		else
		{
			e->room.town = FALSE;
		}

		fsdfxt(32, str, 2);
		if (sameas(str, "Y"))
		{
			e->room.invaders = 'Y';
		}
		else
		{
			e->room.invaders = 'N';
		}

		fsdfxt(33, e->room.text_descriptor, TEXT_DESCRIPTOR_SIZE);

		if (e->room.text_descriptor[0])
		{
			e->room.text_file = TRUE;
		}
		else
		{
			e->room.text_file = FALSE;
		}

		fsdfxt(34, str, 6);
		n = atoi(str);
		if (n > 0 && n <= globals->maxmon)
		{
			e->room.monster_here[0] = n;
		}
		else
		{
			e->room.monster_here[0] = 0;
		}

		fsdfxt(36, str, 6);
		n = atoi(str);
		if (n > 0 && n <= globals->maxmon)
		{
			e->room.monster_here[1] = n;
		}
		else
		{
			e->room.monster_here[1] = 0;
		}

		fsdfxt(38, str, 6);
		n = atoi(str);
		if (n > 0 && n <= globals->maxmon)
		{
			e->room.monster_here[2] = n;
		}
		else
		{
			e->room.monster_here[2] = 0;
		}

		fsdfxt(40, str, 6);
		n = atoi(str);
		if (n > 0 && n <= globals->maxmon)
		{
			e->room.monster_here[3] = n;
		}
		else
		{
			e->room.monster_here[3] = 0;
		}

		fsdfxt(42, str, 6);
		n = atoi(str);
		if (n > 0 && n <= globals->maxmon)
		{
			e->room.monster_here[4] = n;
		}
		else
		{
			e->room.monster_here[4] = 0;
		}

		fsdfxt(44, str, 4);
		e->room.enc_chance = atoi(str);

		if (e->room.enc_chance < 0)
		{
			e->room.enc_chance = 0;
		}
		else if (e->room.enc_chance > 100)
		{
			e->room.enc_chance = 100;
		}

		if (e->room.enc_chance == 0)
		{
			for (i = 0; i != POSSIBLE_MONS; ++i)
			{
				e->room.monster_here[i] = 0; 
			}
		}

		Edit_Room(2);
	}
	else
	{
		GameOp_Menu(0);
	}

	outprf(MY_PORT->usrnum);
	clrprf();
	MY_PORT->editing = FALSE;
	rstmbk();
}
/****************************************************************************
	finished editing monster
*/
void Mon_Edit_Done(void)
{
	struct  edit_info_struct *e = &MY_PORT->edit;

	if (e->crit.talk_text_file)
	{
		sprintf(str, "%s\\MT%d.TXT", globals->textdir, e->crit.which);
		prfmsg(MSG1381, str);
	}

	if (e->crit.look_text_file)
	{
		sprintf(str, "%s\\ML%d.TXT", globals->textdir, e->crit.which);
		prfmsg(MSG1383, str);
	}

	if (e->crit.magical && e->crit.magic_immune)
	{
		prfmsg(MSG1430);
	}

	Write_Critter(&e->crit);

	if (ynopt(LOGEDITM))
	{
		sprintf
		(
			str,
			"%s edited monster %d",
			me.Userid,
			e->crit.which
		);
		NOTIFY(str);
	}

	GameOp_Menu(0);
}
/****************************************************************************
	god-like users can add/edit rooms
*/
short EXPORT Edit_Room(short option)
{
	short   i;
	short   n;
	struct  edit_info_struct *e = &MY_PORT->edit;
	char    y_or_n[2];
	char    monster_here[POSSIBLE_MONS][NAME_LEN];
	
	y_or_n[0] = 'N';
	y_or_n[1] = 'Y';

	if (option == 1)
	{
		if (margc == 0)
		{
			BAD_EXIT;
		}

		e->room_num = INUM(margv[0]);
	
		if (e->room_num > globals->maxroom || e->room_num < 1)
		{
			BAD_EXIT;
		}

		if 
		(
			(me.lo_room && e->room_num < me.lo_room) ||
			(me.hi_room && e->room_num > me.hi_room)
		)
		{
			prfmsg(MSG1485, me.lo_room, me.hi_room);
			BAD_EXIT;
		}

		for (n = 0, e->active = -1; n != NTERMS; ++n)
		{
			if (ABUF(n)->rm.id == e->room_num && ABUF(n)->in_use)
			{
				e->room = ABUF(n)->rm;
				e->active = n;
			}
		}

		if (e->active < 0)
		{
			Read_Room(e->room_num, &e->room, &e->room2);
		}

		for (i = 0; i != NUM_EXITS; ++i)
		{
			if (e->room.exit[i] == 0)
			{
				e->room.Visible[i] = FALSE;
			}
		}

		for (i = 0; i != POSSIBLE_MONS; ++i)
		{
			if (e->room.monster_here[i] && e->room.enc_chance)
			{
				Read_Critter(e->room.monster_here[i], &crit);
				strcpy(monster_here[i], crit.name);
			}
			else
			{
				monster_here[i][0] = 0;
				e->room.monster_here[i] = 0;
			}
		}

		if (e->room.invaders != 'N' && e->room.invaders != 'Y')
		{
			e->room.invaders = 'Y';

			if (e->room.town == TRUE)
			{
				e->room.invaders = 'N';
			}
		}

		if (e->room.town == -1)
		{
			e->room.town = TRUE;
		}
		else if (labs(e->room.town > 1))
		{
			e->room.town = 0;
		}

		if (e->room.no_teleport != TRUE && e->room.no_teleport != FALSE)
		{
			e->room.no_teleport = FALSE;
		}

		if (e->room.spec_exit.leads_to == 0)
		{
			e->room.spec_exit.article[0] = 0;
			e->room.spec_exit.adjective[0] = 0;
			e->room.spec_exit.descriptor[0] = 0;
			e->room.spec_exit.Visible = FALSE;
			e->room.spec_exit.type = 0;
			e->room.spec_exit.filter = 0;
		}

		if (!e->room.text_file)
		{
			e->room.text_descriptor[0] = 0;
		}

		sprintf
		(
			vdatmp, 
			room_edit_format, 
			room_types[e->room.rmtype + 9], '\0',
			e->room.desc[0], '\0',
			e->room.desc[1], '\0',
			e->room.desc[2], '\0',
			e->room.desc[3], '\0',
			e->room.desc[4], '\0',
			e->room.desc[5], '\0',
			e->room.exit[0], '\0',
			e->room.exit[1], '\0',
			e->room.exit[2], '\0',
			e->room.exit[3], '\0',
			e->room.exit[4], '\0',
			e->room.exit[5], '\0',
			e->room.exit[6], '\0',
			y_or_n[e->room.Visible[0]], '\0',
			y_or_n[e->room.Visible[1]], '\0',
			y_or_n[e->room.Visible[2]], '\0',
			y_or_n[e->room.Visible[3]], '\0',
			y_or_n[e->room.Visible[4]], '\0',
			y_or_n[e->room.Visible[5]], '\0',
			y_or_n[e->room.Visible[6]], '\0',
			e->room.spec_exit.article, '\0',
			e->room.spec_exit.adjective, '\0',
			e->room.spec_exit.descriptor, '\0',
			e->room.spec_exit.leads_to, '\0',
			y_or_n[e->room.spec_exit.Visible], '\0',
			spec_types[e->room.spec_exit.type], '\0',
			filters[e->room.spec_exit.filter], '\0',
			trap_types[e->room.trap], '\0',
			e->room.cover, '\0',
			y_or_n[e->room.no_teleport], '\0',
			y_or_n[e->room.town], '\0',
			e->room.invaders, '\0',
			e->room.text_descriptor, '\0',
			e->room.monster_here[0], '\0',
			monster_here[0], '\0',
			e->room.monster_here[1], '\0',
			monster_here[1], '\0',
			e->room.monster_here[2], '\0',
			monster_here[2], '\0',
			e->room.monster_here[3], '\0',
			monster_here[3], '\0',
			e->room.monster_here[4], '\0',
			monster_here[4], '\0',
			e->room.enc_chance, '\0'
		);           
		
		clrprf();
		STATE = MSG1443; 
		fsdroom(MSG1443, room_screen_spec, 1);
		fsdapr(vdaptr, vdasiz, vdatmp);
		fsdbkg(fsdrft());
		fsdscb->flddat[35].flags |= FFFAVD;
		fsdscb->flddat[37].flags |= FFFAVD;
		fsdscb->flddat[39].flags |= FFFAVD;
		fsdscb->flddat[41].flags |= FFFAVD;
		fsdscb->flddat[43].flags |= FFFAVD;
		fsdego(vfyadn, Room_FSE_Done);
		outprf(MY_PORT->usrnum);
		MY_PORT->editing = TRUE;
		return (TRUE);
	}

	if (option == 2)
	{
		if (e->room.spec_exit.type != SPECIAL_DOOR)
		{
			option = 4;
		}
		else
		{
			if (e->room.door_index > 32767)
			{
				e->room.door_index = 0;
			}

			prfmsg(MSG1445);
			sprintf(prompt, getmsg(MSG1446), e->room.door_index);
			Set_Prompt(prompt, EDIT_ROOM_PROMPT3);
			DONE;
		}
	}

	if (option == 3)
	{
		Set_Long(&e->room.door_index);
		option = 4;
	}

	if (option == 4)
	{
		if (e->room.spec_exit.type != CHANT_DOOR)
		{
			option = 6;
		}
		else
		{
			prfmsg(MSG1447);
			sprintf(prompt, getmsg(MSG1448), e->room.chant);
			Set_Prompt(prompt, EDIT_ROOM_PROMPT5);
			DONE;
		}
	}

	if (option == 5)
	{
		Set_Str(e->room.chant, CHANT_SIZE);
		option = 6;
	}

	if (option == 6)
	{
		if (e->room.rmtype >= 0)
		{
			option = 8;
		}
		else
		{
			prfmsg(MSG1449);
			sprintf
			(
				prompt, 
				getmsg(MSG1450), 
				guild->treasury[abs(e->room.rmtype)]
			);
			Set_Prompt(prompt, EDIT_ROOM_PROMPT7);
			DONE;
		}
	}

	if (option == 7)
	{
		Set_Long(&guild->treasury[abs(e->room.rmtype)]);
		option = 8;
	}

	if (option == 8)
	{
		if (e->room.spec_exit.filter != ITEM_FILTER)
		{
			option = 10;
		}
		else
		{
			if (e->room.filter_spec > 0 && e->room.filter_spec < MAXITEM)
			{
				Read_Item(e->room.filter_spec, &item);
			}
			else
			{
				item.name[0] = 0;
			}

			prfmsg(MSG1451);
			sprintf(prompt, getmsg(MSG1452), e->room.filter_spec, item.name);
			Set_Prompt(prompt, EDIT_ROOM_PROMPT9);
			DONE;
		}
	}

	if (option == 9)
	{
		Set_Int(&e->room.filter_spec);
			
		if (e->room.filter_spec > globals->maxitem)
		{
			e->room.filter_spec = 0;
		}

		option = 10;
	}

	if (option == 10)
	{
		if (e->room.spec_exit.filter != CLASS_FILTER)
		{
			option = 12;
		}
		else
		{
			if (e->room.filter_spec < 'A' || e->room.filter_spec > 'Z')
			{
				e->room.filter_spec = 'A';
			}

			prfmsg(MSG1453);
			sprintf(prompt, getmsg(MSG1454), e->room.filter_spec);
			Set_Prompt(prompt, EDIT_ROOM_PROMPT11);
			DONE;
		}
	}

	if (option == 11)
	{
		if (margc)
		{
			e->room.filter_spec = toupper(margv[0][0]);
		}

		option = 12;
	}

	if (option == 12)
	{
		if (e->room.spec_exit.filter != RACE_FILTER)
		{
			option = 14;
		}
		else
		{
			if (e->room.filter_spec < 'A' || e->room.filter_spec > 'Z')
			{
				e->room.filter_spec = 'A';
			}

			prfmsg(MSG1455);
			sprintf(prompt, getmsg(MSG1456), e->room.filter_spec);
			Set_Prompt(prompt, EDIT_ROOM_PROMPT13);
			DONE;
		}
	}

	if (option == 13)
	{
		if (margc)
		{
			e->room.filter_spec = toupper(margv[0][0]);
		}

		option = 14;
	}

	if (option == 14)
	{
		if (e->room.spec_exit.filter != LEVEL_FILTER)
		{
			option = 16;
		}
		else
		{               
			prfmsg(MSG1457);
			sprintf(prompt, getmsg(MSG1458), e->room.filter_spec);
			Set_Prompt(prompt, EDIT_ROOM_PROMPT15);
			DONE;
		}
	}

	if (option == 15)
	{
		if (margc)
		{
			e->room.filter_spec = atoi(margv[0]);
		}

		option = 16;
	}

	if (option == 16)
	{
		if (e->room.text_file)
		{
			sprintf(str, "%s\\R%d.TXT", globals->textdir, e->room.id);
			prfmsg(MSG1385, e->room.text_descriptor, str);
		}

		if (e->active >= 0)
		{
			if 
			(
				ABUF(e->active)->in_use && 
				ABUF(e->active)->rm.id == e->room_num
			)
			{
				ABUF(e->active)->rm = e->room;
			}
		}

		Write_Room(&e->room);

		if (ynopt(LOGEDITR))
		{
			sprintf
			(
				str,
				"%s edited room %d",
				me.Userid,
				e->room.id
			);
			NOTIFY(str);
		}

		GameOp_Menu(0);
	}

	DONE;
}
