#include <header.h>
#include <globals.h>

/****************************************************************************
	display the current time
*/
void EXPORT Current_Time(void)
{
	char    now_date[DATE_SIZE];
	char    now_time[TIME_SIZE];

	NOW(now_time);
	TODAY(now_date);

	prfmsg(M146, now_date, now_time);
	sprintf(str, getmsg(M1303), me.secs_today / 60);
	prf(str);
}
/****************************************************************************
	let user know of ruckuses in nearby rooms.
*/
short Listen(void)
{
	short   r;
	short   i;
	short   j;
	short   overheard = FALSE;
	short   noises[NUM_EXITS + 1];

	for (i = 0; i != NUM_EXITS + 1; ++i)
	{
		noises[i] = FALSE;
		
		if (i != NUM_EXITS)
		{
			if (ABUF(B)->visible[i])
			{
				r = ABUF(B)->rm.exit[i];
			}
			else
			{
				r = 0;
			}
		}
		else
		{
			if (ABUF(B)->visible[NUM_EXITS])
			{
				r = ABUF(B)->rm.spec_exit.leads_to;
			}
			else
			{
				r = 0;
			}
		}

		if (r)
		{
			if (invasion->active)
			{
				for (j = 0; j != MAX_INVASION_ROOMS; ++j)
				{
					if (invasion->room[j] == r && invasion->count[j])
					{
						noises[i] = TRUE;
					}
				}
			}

			for (j = 0; j != MAX_PERM_MON; ++j)
			{
				if (abs(globals->perm_mon_loc[j]) == r)
				{
					if 
					(
						globals->perm_mon_id[j] != globals->rover ||
						!invasion->active ||
						!globals->captive_safe
					)
					{
						noises[i] = TRUE;
					}
				}
			}

			if (!noises[i])
			{
				Read_Room(r, &globals->next_room, &a_room2);
				
				if (globals->next_room.visible_mons)
				{
					noises[i] = TRUE;
				}
			}
		}
	}

	for (i = 0; i != 4; ++i)
	{
		if (ABUF(B)->rm.exit[i])
		{
			if (Ruckus(ABUF(B)->rm.exit[i]))
			{
				overheard = TRUE;
				prfmsg(M147);
				print_exit(i);
				prf("!\r");
			}
			else if (noises[i])
			{
				overheard = TRUE;
				prfmsg(MSG995);
				print_exit(i);
				prf("!\r");
			}
		}
	}

	if (ABUF(B)->rm.exit[NUM_EXITS - 3])
	{
		if (Ruckus(ABUF(B)->rm.exit[NUM_EXITS - 3]))
		{
			overheard = TRUE;
			prfmsg(M148);
		}
		else if (noises[NUM_EXITS - 3])
		{
			overheard = TRUE;
			prfmsg(MSG996);
		}
	}

	if (ABUF(B)->rm.exit[NUM_EXITS - 2])
	{
		if (Ruckus(ABUF(B)->rm.exit[NUM_EXITS - 2]))
		{
			overheard = TRUE;
			prfmsg(M149);
		}
		else if (noises[NUM_EXITS - 2])
		{
			overheard = TRUE;
			prfmsg(MSG997);
		}
	}

	if (ABUF(B)->rm.exit[NUM_EXITS - 1])
	{
		if (Ruckus(ABUF(B)->rm.exit[NUM_EXITS - 1]))
		{
			overheard = TRUE;
			prfmsg(M150);
		}
		else if (noises[NUM_EXITS - 1])
		{
			overheard = TRUE;
			prfmsg(MSG998);
		}
	}

	if (ABUF(B)->rm.spec_exit.leads_to)
	{
		if (Ruckus(ABUF(B)->rm.spec_exit.leads_to))
		{
			overheard = TRUE;
			prfmsg(M151);
			Special_Exit(0);
		}
		else if (noises[NUM_EXITS])
		{
			overheard = TRUE;
			prfmsg(MSG999);
			Special_Exit(0);
		}
	}

	return (overheard);
}
/****************************************************************************
	check for action in room
*/
short Ruckus(short room)
{
	short   i;
	short   m;
	short   c;

	if (room == ABUF(B)->rm.id)
	{
		BAD_EXIT;
	}

	for (i = 0; i != NTERMS; ++i)
	{
		if (ABUF(i)->in_use && ABUF(i)->rm.id == room)
		{
			for (m = 0; m != MAX_ROOM_MON; ++m)
			{
				if 
				(
					ABUF(i)->mon[m].what && 
					ABUF(i)->mon[m].last_attacker >= 0
				)
				{
					return (TRUE);
				}
			}

			for (c = 0; c != NTERMS; ++c)
			{
				if (ABUF(i)->guy[c] && APORT(c)->enemy_mon >= 0)
				{
					return (TRUE);
				}
			}
		}
	}

	return (FALSE);
}
/****************************************************************************
	list a monster's timers
*/
void List_Mon_Timers(short m)
{
	short   x = 0;

	if (AMON->action_timer)
	{
		++x;
		prfmsg(MSG152, AMON->action_timer);
	}

	x += FIND_MON(m, WEAK_TIME, spell_info[WEAKNESS].name);
	x += FIND_MON(m, SLOW_TIME, spell_info[LANGOUR].name);
	x += FIND_MON(m, MES_TIME, spell_info[MESMERIZE].name);
	x += FIND_MON(m, INVISIBLE_TIME, spell_info[INVISIBILITY].name);
	x += FIND_MON(m, SEE_INVIS_TIME, spell_info[SEE_INVISIBLE].name);
	x += FIND_MON(m, SLEEP_TIME, spell_info[SLEEP].name);
	x += FIND_MON(m, INVULNERABLE_TIME, spell_info[INVULNERABILITY].name);
	x += FIND_MON(m, SHIELD_TIME, spell_info[MAGIC_SHIELD].name);
	x += FIND_MON(m, FAST_TIME, spell_info[HASTE].name);
	x += FIND_MON(m, STURDY_TIME, spell_info[STURDINESS].name);
	x += FIND_MON(m, MANIA_TIME, spell_info[MANIA].name);

	if (!x)
	{
		prfmsg(MSG153);
	}
}
/****************************************************************************
	list my timers
*/
void list_timers(void)
{
	short   t;
	short   x = 0;

	Current_Time();

	if (me.spell[SAFE_RETURN])
	{
		if (me.return_to == me.location)
		{
			prfmsg(MSG1008);
		}
		else if (me.return_to)
		{
			prfmsg(MSG1009);
		}
		else
		{
			prfmsg(MSG1010);
		}
	}

	if (me.poison_timer)
	{
		++x;
		prfmsg(MSG154, me.poison_timer);
	}
	
	for (t = 0; t != NUM_GUY_TIMERS; ++t)
	{
		if (MY_PORT->misc_type[t] == KO_TIME)
		{
			prfmsg(ATIMER1, "Unconsciousness", MY_PORT->timer[t]);
		}
	}
	
	x += FIND(WEAK_TIME, spell_info[WEAKNESS].name);
	x += FIND(SLEEP_TIME, spell_info[SLEEP].name);
	x += FIND(SLOW_TIME, spell_info[LANGOUR].name);
	x += FIND(MES_TIME, spell_info[MESMERIZE].name);
	x += FIND(CIRCLE_TIME, spell_info[MAGIC_CIRCLE].name);
	x += FIND(INVISIBLE_TIME, spell_info[INVISIBILITY].name);
	x += FIND(SEE_INVIS_TIME, spell_info[SEE_INVISIBLE].name);
	x += FIND(INVULNERABLE_TIME, spell_info[INVULNERABILITY].name);
	x += FIND(PROTECTED_TIME, spell_info[PROTECT].name);
	x += FIND(SHIELD_TIME, spell_info[MAGIC_SHIELD].name);
	x += FIND(STEALTH_TIME, spell_info[STEALTH].name);
	x += FIND(FLOAT_TIME, spell_info[LEVITATE].name);
	x += FIND(MAGNET_TIME, spell_info[AGGRAVATE].name);
	x += FIND(FAST_TIME, spell_info[HASTE].name);
	x += FIND(STRONG_TIME, spell_info[STRENGTH].name);
	x += FIND(STURDY_TIME, spell_info[STURDINESS].name);
	x += FIND(MANIA_TIME, spell_info[MANIA].name);

	if (x == 0)
	{
		prfmsg(MSG155);
	}
}
/****************************************************************************
	print player stats
*/
void Stats(void)
{
	short   i;
	short   strength;
	short   maniac_t;
	short   strong_t;
	short   combat_bonus;
	short   burden;
	short   bonus;
	short   ac;
	short   ring1 = -1;
	short   ring2 = -1;
	short   wielded = 0;
	short   count = 0;
	short   num_items;
	MLONG   carrying;
	MLONG   carry_max;
	char    *msg = (char *) vdaptr;

	for (i = 0; i != NUM_ITEMS; ++i)
	{
		if
		(
			me.item[i].what == MAGIC_DEV &&
			me.item[i].which == MAGIC_RING &&
			me.item[i].ring_used
		)
		{
			if (ring1 < 0)
			{
				ring1 = i;
			}
			else
			{
				ring2 = i;
			}
		}
	}

	prfmsg(MSG188, me.name, me.title);

	if (me.race == ELF)
	{
		prfmsg(MSG189);
	}
	else if (me.race == DWARF)
	{
		prfmsg(MSG190);
	}
	else if (me.race == HUMAN)
	{
		prfmsg(MSG191);
	}
	else if (me.race == OGRE)
	{
		prfmsg(MSG192);
	}
	else if (me.race == HALFLING)
	{
		prfmsg(MSG193);
	}

	if (me.outlaw == 'Y')
	{
		prfmsg(MSG1285);
	}

	if (me.class == WARRIOR)
	{
		prfmsg(MSG194);
	}
	else if (me.class == SORCERER)
	{
		prfmsg(MSG195);
	}
	else if (me.class == BARBARIAN)
	{
		if (MY_PORT->berserk)
		{
			prfmsg(MSG1001);
		}
		else
		{
			prfmsg(MSG196);
		}
	}
	else if (me.class == THIEF)
	{
		prfmsg(MSG197);
	}
	else if (me.class == DUELIST)
	{
		prfmsg(MSG198);
	}
	else if (me.class == CLERIC)
	{
		prfmsg(MSG199);
	}
	else if (me.class == MYSTIC)
	{
		prfmsg(MSG200);
	}
	
	Titles(MY_PORT->index, str);
	if (str[0])
	{
		prf("%s\r", str);
	}
	
	if (me.guild_master && guild->master_name[me.in_guild][0])
	{
		prfmsg(MSG201, guild->master_name[me.in_guild]);
	}
	else if (me.in_guild && guild->member_name[me.in_guild][0])
	{
		prfmsg(MSG202, guild->member_name[me.in_guild]);
	}
	
	Calc_Weight(&num_items, &carrying, &carry_max);
	burden = (short) ((carrying * 100) / carry_max);

	maniac_t = find_timer(MANIA_TIME, ME);
	strong_t = find_timer(STRONG_TIME, ME);

	Compute_Bonus
	(
		&combat_bonus,
		me.Str, me.Int, me.Dex,
		maniac_t, strong_t,
		me.class
	);

	strength = me.Str;
	if (strong_t)
	{
		strength = strength * 2;
	}

	Combat_Bonus(&bonus, WITH_SPELLS);
	ac = Calc_Player_AC(&me, P, FULL_AC);

	sprintf
	(
		msg,
		getmsg(STATDISP),
		strength,
		me.dpts - me.damaged,
		me.dpts,
		me.wep_plus[EDGED_IND],
		me.shield,
		me.Dex,
		me.dpts - me.ftg,
		me.dpts,
		me.wep_plus[BLUNT_IND],
		me.defense,
		me.Con,
		me.mpts - me.magic_used,
		me.mpts,
		me.wep_plus[POLE_IND],
		me.thief,
		me.Int,
		combat_bonus,
		me.wep_plus[HAND_IND],
		me.bank,
		Local_Psy(P),
		Approximate_Level(P),
		me.two_wep,
		me.gold,
		me.evil,
		num_items,
		burden,
		"%%",
		me.guild_balance,
		ac,
		bonus
	);

	prf(msg);

	if (me.armor >= 0)
	{
		prfmsg(MSG206);
		Display_Item(&me.item[me.armor]);
		prf("\r");
	}

	if (ring1 >= 0)
	{
		prfmsg(MSG206);
		Display_Item(&me.item[ring1]);

		if (ring2 >= 0)
		{
			prf(", and ");
			Display_Item(&me.item[ring2]);
		}
		prf("\r");
	}
	
	if (me.rw >= 0)
	{
		++wielded;
	}

	if (me.lw >= 0)
	{
		++wielded;
	}

	if (me.shld >= 0)
	{
		++wielded;
	}

	if (me.focus >= 0)
	{
		++wielded;
	}

	if (wielded)
	{
		prfmsg(MSG203);

		if (me.rw >= 0)
		{
			++count;
			Display_Item(&me.item[me.rw]);
			prfmsg(MSG204);

			if (wielded > 1)
			{
				prf(", ");
			}
		}

		if (me.lw >= 0)
		{
			if (count == 1)
			{
				prf("and ");
			}

			Display_Item(&me.item[me.lw]);
			prfmsg(MSG205);
			++count;

			if (count == 1 && wielded > 1)
			{
				prf(", ");
			}
		}

		if (me.shld >= 0)
		{
			if (count == 1)
			{
				prf("and ");
			}

			++count;
			Display_Item(&me.item[me.shld]);

			if (count == 1 && wielded > 1)
			{
				prf(", ");
			}
		}

		if (me.focus >= 0)
		{
			if (count == 1)
			{
				prf("and ");
			}

			Display_Item(&me.item[me.focus]);
		}

		prf("\r");
	}

	if (me.spell[SAFE_RETURN])
	{
		if (me.return_to == me.location)
		{
			prfmsg(MSG1008);
		}
		else if (me.return_to)
		{
			prfmsg(MSG1009);
		}
		else
		{
			prfmsg(MSG1010);
		}
	}

	My_Current_Fame();
}
/****************************************************************************
	determine what they want to look at
*/
short Look_At_What(char *word, short which)
{
	short   i;
	short   g;
	short   m;
	short   invis_t;
	short   see_invis_t;
	short   invisible;
	short   absolute_match = 0;

	if (ABUF(B)->rm.text_file && sameas(word, ABUF(B)->rm.text_descriptor))
	{
		Print_Text_File("R", ABUF(B)->rm.id);
		DONE;
	}

	g = find_guy(word, 0, &absolute_match);
	m = find_monster(word, which, 0, &absolute_match);
	i = find_item(word, which, 0, &absolute_match);

	if
	(
		(g == NOT_UNIQUE || m == NOT_UNIQUE || i == NOT_UNIQUE) &&
		absolute_match == 0
	)
	{
		prfmsg(M167, word);
	}
	else if (g == NOT_FOUND && m == NOT_FOUND && i == NOT_FOUND)
	{
		prfmsg(M168, word);
	}
	else if
	(
		((g >= 0 && m >= 0) || (i >= 0 && g >= 0) || (m >= 0 && i >= 0)) &&
		absolute_match == 0
	)
	{
		prfmsg(M167, word);
	}
	else if (m == NOT_THAT_MANY || i == NOT_THAT_MANY)
	{
		prfmsg(M169, word);
	}
	else if (g >= 0 && absolute_match != ABS_ITM && absolute_match != ABS_MON)
	{
		see_invis_t = find_timer(SEE_INVIS_TIME, ME);
		invis_t = find_timer(INVISIBLE_TIME, GUY);

		if (me.perm[SUPER_PERM])
		{
			invisible = FALSE;
		}
		else if (invis_t && !see_invis_t && g != P)
		{
			invisible = TRUE;
		}
		else
		{
			invisible = FALSE;
		}

		if (invisible)
		{
			prfmsg(M168, word);
		}
		else
		{
			Look_At_Guy(g, FALSE);
			return (TRUE);
		}
	}
	else if (m >= 0 && absolute_match != ABS_ITM)
	{
		Look_At_Monster(m, FALSE);
		return(TRUE);
	}
	else if (i >= 0)
	{
		Look_At_Item(i);
		return(TRUE);
	}

	BAD_EXIT;
}
/****************************************************************************
	user wants to examine something/someone
*/
void Look_At(void)
{

	if (word1[0] == 0)
	{
		print_room();
	}
	else
	{
		Look_At_What(word1, which1);
	}
}
/****************************************************************************
	look at the specified monster
*/
void Look_At_Monster(short m, short elicited)
{
	short   sleep_t;
	short   invis_t;
	short   see_invis_t;
	short   mon_ac;
	short   my_ac;
	MLONG   dmg_max;
	MLONG   dmg_min;
	MLONG   bonus;
	MLONG   wep_hits;
	short   my_bonus;

	mon_ac = Calc_Mon_AC(m, EQUIP_ONLY);
	my_ac = Calc_Player_AC(&me, P, EQUIP_ONLY);
	Combat_Bonus(&my_bonus, WITH_SPELLS);

	if (mon_ac < my_ac)
	{
		AMON->my_ac_was_lower[P] = TRUE;
	}

	if (my_bonus > mon_ac)
	{
		AMON->easy_hit[P] = TRUE;
	}

	prfmsg(M170);
	print_mon(m);
	prfmsg(M171, AMON->Level);

	if (me.perm[SUPER_PERM] || elicited || Find_Ring(ELICITATION, ME))
	{
		if (AMON->alg)
		{
			prfmsg(MSG1377);
		}
		else
		{
			prfmsg(MSG1378);
		}
	}

	switch (AMON->what)
	{
		case NPC:
			prfmsg(M172);
			break;

		case WEIRD:
			prfmsg(M173);
			break;

		case LONER:
			prfmsg(M710);
			break;

		case MONSTER:
			prfmsg(M174);
			break;

		case ANIMAL:
			prfmsg(M175A);
			break;

		case AWESOME:
			prfmsg(M175B);
			break;

		case HUMANOID:
			prfmsg(M176);
			break;

		case ORACLE:
			prfmsg(M177);
			break;

		case HUNTRESS:
			prfmsg(M178);
			break;
	}

	sleep_t = find_timer(SLEEP_TIME, MON);

	if (sleep_t)
	{
		prfmsg(MSG179);
	}

	if (me.perm[SUPER_PERM] || elicited || Find_Ring(ELICITATION, ME))
	{
		Calc_Mon_Bonus(AMON, m, &bonus, &wep_hits);
		invis_t = find_timer(INVISIBLE_TIME, MON);
		see_invis_t = find_timer(SEE_INVIS_TIME, ME);

		if (invis_t && !see_invis_t)
		{
			bonus += 5L;
		}

		mon_ac = Calc_Mon_AC(m, FULL_AC);

		dmg_min = 1L + bonus;

		if (wep_hits)
		{
			dmg_max = wep_hits + bonus;
		}
		else if (AMON->what == AWESOME)
		{
			dmg_max = (((MLONG) AMON->Level / 2L) + 1L) + bonus;
		}
		else
		{
			dmg_max = (((MLONG) AMON->Level / 3L) + 1L) + bonus;
		}

		sprintf
		(
			str,
			getmsg(M180),
			dmg_min,
			dmg_max,
			mon_ac,
			AMON->dpts - AMON->damage,
			AMON->dpts,
			AMON->dpts - AMON->Tired,
			AMON->dpts,
			AMON->mpts - AMON->magic_used,
			AMON->mpts
		);
		prf("%s", str);

		sprintf
		(
			str,
			getmsg(M181),
			AMON->Str,
			AMON->Dex,
			AMON->Con,
			AMON->Psy,
			AMON->Int,
			bonus
		);
		prf(str);

		List_Mon_Timers(m);
	}

	if (AMON->magical || AMON->spell_caster)
	{
		prfmsg(M182);
	}

	if (!AMON->sees[P])
	{
		prfmsg(MSG183);
	}
	else
	{
		prfmsg(M184);
	}

	if (AMON->last_attacker >= 0)
	{
		if (AMON->last_attacker == P)
		{
			prfmsg(MSG185);
		}
		else
		{
			prfmsg(M186, APORT(AMON->last_attacker)->chr.name);
		}
	}

	show_mon_equip(m);

	if (AMON->look_text_file)
	{
		Print_Text_File("ML", AMON->which);
	}
}
/****************************************************************************
	look at the specified player
*/
void Look_At_Guy(short g, short elicited)
{
	short   count = 0;
	short   wielded = 0;
	short   bonus;
	short   maniac_t;
	short   strong_t;
	short   strength;
	short   i;
	short   ring1 = -1;
	short   ring2 = -1;
	short   old_p = P;
	char    *msg;

	for (i = 0; i != NUM_ITEMS; ++i)
	{
		if
		(
			AGUY->item[i].what == MAGIC_DEV &&
			AGUY->item[i].which == MAGIC_RING &&
			AGUY->item[i].ring_used
		)
		{
			if (ring1 < 0)
			{
				ring1 = i;
			}
			else
			{
				ring2 = i;
			}
		}
	}

	if (g != P)
	{
		prfmsg(MSG187, AGUY->name, AGUY->title);
	}
	else
	{
		prfmsg(MSG188, AGUY->name, AGUY->title);
	}

	if (AGUY->race == ELF)
	{
		prfmsg(MSG189);
	}
	else if (AGUY->race == DWARF)
	{
		prfmsg(MSG190);
	}
	else if (AGUY->race == HUMAN)
	{
		prfmsg(MSG191);
	}
	else if (AGUY->race == OGRE)
	{
		prfmsg(MSG192);
	}
	else if (AGUY->race == HALFLING)
	{
		prfmsg(MSG193);
	}

	if (AGUY->outlaw == 'Y')
	{
		prfmsg(MSG1285);
	}

	if (AGUY->class == WARRIOR)
	{
		prfmsg(MSG194);
	}
	else if (AGUY->class == SORCERER)
	{
		prfmsg(MSG195);
	}
	else if (AGUY->class == BARBARIAN)
	{
		if (APORT(g)->berserk)
		{
			prfmsg(MSG1001);
		}
		else
		{
			prfmsg(MSG196);
		}
	}
	else if (AGUY->class == THIEF)
	{
		prfmsg(MSG197);
	}
	else if (AGUY->class == DUELIST)
	{
		prfmsg(MSG198);
	}
	else if (AGUY->class == CLERIC)
	{
		prfmsg(MSG199);
	}
	else if (AGUY->class == MYSTIC)
	{
		prfmsg(MSG200);
	}
	
	Titles(APORT(g)->index, str);
	if (str[0])
	{
		prf("%s\r", str);
	}
	
	if (AGUY->guild_master && guild->master_name[AGUY->in_guild][0])
	{
		prfmsg(MSG201, guild->master_name[AGUY->in_guild]);
	}
	else if (AGUY->in_guild && guild->member_name[AGUY->in_guild][0])
	{
		prfmsg(MSG202, guild->member_name[AGUY->in_guild]);
	}
	
	if (AGUY->armor >= 0)
	{
		prfmsg(MSG206);
		Display_Item(&AGUY->item[AGUY->armor]);
		prf("\r");
	}

	if (ring1 >= 0)
	{
		prfmsg(MSG206);
		Display_Item(&AGUY->item[ring1]);

		if (ring2 >= 0)
		{
			prf(", and ");
			Display_Item(&AGUY->item[ring2]);
		}
		prf("\r");
	}
	
	if (AGUY->rw >= 0)
	{
		++wielded;
	}

	if (AGUY->lw >= 0)
	{
		++wielded;
	}

	if (AGUY->shld >= 0)
	{
		++wielded;
	}

	if (AGUY->focus >= 0)
	{
		++wielded;
	}

	if (wielded)
	{
		prfmsg(MSG203);

		if (AGUY->rw >= 0)
		{
			++count;
			Display_Item(&AGUY->item[AGUY->rw]);
			prfmsg(MSG204);

			if (wielded > 1)
			{
				prf(", ");
			}
		}

		if (AGUY->lw >= 0)
		{
			if (count == 1)
			{
				prf("and ");
			}

			Display_Item(&AGUY->item[AGUY->lw]);
			prfmsg(MSG205);
			++count;

			if (count == 1 && wielded > 1)
			{
				prf(", ");
			}
		}

		if (AGUY->shld >= 0)
		{
			if (count == 1)
			{
				prf("and ");
			}

			++count;
			Display_Item(&AGUY->item[AGUY->shld]);

			if (count == 1 && wielded > 1)
			{
				prf(", ");
			}
		}

		if (AGUY->focus >= 0)
		{
			if (count == 1)
			{
				prf("and ");
			}

			Display_Item(&AGUY->item[AGUY->focus]);
		}

		prf("\r");
	}

	if (elicited || me.perm[SUPER_PERM] || Find_Ring(ELICITATION, ME))
	{
		maniac_t = find_timer(MANIA_TIME, GUY);
		strong_t = find_timer(STRONG_TIME, GUY);

		Compute_Bonus
		(
			&bonus,
			AGUY->Str, AGUY->Int, AGUY->Dex,
			maniac_t, strong_t,
			AGUY->class
		);

		strength = AGUY->Str;
		if (strong_t)
		{
			strength = strength * 2;
		}

		msg = getmsg(MSG207);
		sprintf
		(
			str,
			msg,
			strength, 
			AGUY->Dex, 
			AGUY->Con, 
			Local_Psy(g), 
			AGUY->Int, 
			bonus
		);
		prf(str);

		Health(g);

		P = g;
		list_timers();
		P = old_p;
	}
}
/****************************************************************************
	display the S/R flags for a port
*/
void Ignore_Status(short p)
{

	if (P == -1)
	{
		prf("   ");
	}
	else if (p == P)
	{
		prf("   ");
	}
	else if (me.Option[IGNORE_GLOBAL] || MY_PORT->ignore[p])
	{
		prf("%sYes", cyan);
	}
	else
	{
		prf("%sNo ", cyan);
	}
}
/****************************************************************************
	print who is on
*/
void where(void)
{
	short   anyone = FALSE;
	short   i;
	char    g;
	char    outlaw;
	short   start = 1;
		
	if 
	(
		P != -1 &&
		(me.perm[GAMEOP_PERM] || me.perm[EDIT_PERM])
	)
	{
		start = 0;
	}

	for (i = start; i != NTERMS; ++i)
	{
		if (APORT(i)->status)
		{
			if (!anyone)
			{
				anyone = TRUE;
				prfmsg(MSG208A);
		
				if 
				(
					P != -1 &&
					(me.perm[GAMEOP_PERM] || me.perm[EDIT_PERM])
				)       
				{
					prfmsg(MSSG209);
				}
	
				prf("\r");
			}

			g = ' ';
			if (APORT(i)->chr.in_guild)
			{
				g = APORT(i)->chr.in_guild + '0';
			}

			outlaw = ' ';
			if (globals->outlaws && APORT(i)->chr.outlaw == 'Y')
			{
				outlaw = '*';
			}

			prfmsg(MSSG211, i, outlaw, APORT(i)->command);
			Ignore_Status(i);
			
			sprintf
			(
				name, 
				"%s the %s", 
				APORT(i)->chr.name, 
				APORT(i)->chr.title
			);

			prfmsg
			(
				MSSG212,
				Really_Brief_Userid(APORT(i)->chr.Userid),
				APORT(i)->time_on,
				g,
				Approximate_Level(i),
				name
			);

			if (P != -1)
			{
				if (me.perm[GAMEOP_PERM] || me.perm[EDIT_PERM])
				{
					prfmsg(MSSG213, ABUF(APORT(i)->B)->rm.id);
				}
			}

			prf("\r");
		}
	}

	if (!anyone)
	{   
		prfmsg(MSG1002);
	}
	else
	{
		prf("\r");
	}
}
/****************************************************************************
	print how much stuff user is carrying
*/
void Display_Burden(void)
{
	short   num_items;
	MLONG   carrying;
	MLONG   carry_max;
	MLONG   capacity;
	char    *msg;

	Calc_Weight(&num_items, &carrying, &carry_max);
	capacity = (carrying * 100) / carry_max;

	msg = getmsg(MSG214);
	sprintf
	(
		str,
		msg,
		num_items,
		me.gold,
		capacity,
		"%%",
		me.bank
	);
	prf(str);
}
/****************************************************************************
	print a list of what the user is carrying
*/
void Inventory(void)
{
	short   i;
	short   num_items;
	MLONG   carrying;
	MLONG   carry_max;

	Calc_Weight(&num_items, &carrying, &carry_max);
	Display_Burden();

	for (i = 0; i != NUM_ITEMS; ++i)
	{
		if (me.item[i].what)
		{
			item = me.item[i];

			prfmsg(MSG215, i + 1);
			Color_Display_Item(&item);

			if (me.lw == i)
			{
				prfmsg(MSG216);
			}
			else if (me.rw == i)
			{
				prfmsg(MSG217);
			}
			else if (me.armor == i)
			{
				prfmsg(MSG218);
			}
			else if (me.shld == i)
			{
				prfmsg(MSG219);
			}
			else if (me.focus == i)
			{
				prfmsg(MSG219);
			}
			else if
			(
				item.what == MAGIC_DEV &&
				item.which == MAGIC_RING &&
				item.ring_used
			)
			{
				prfmsg(MSG220);
			}

			if (ARSH(item) || WEAPON(item))
			{
				if (item.uses <= 10)
				{
					prfmsg(MSG221);
				}
			}
			else if (item.what == CONTAINER)
			{
				if (item.holding == 1)
				{
					prfmsg(MSG222);
				}
				else
				{
					prfmsg(MSG223, item.holding);
				}

				if (item.uses <= 10)
				{
					prfmsg(MSG221);
				}
			}

			if (WEAPON(item) || ARSH(item))
			{
				if (item.ring_used)
				{
					prfmsg(MSG224, spell_info[item.spell_cast].name);
				}
			}

			prf("\r");
		}
	}
}
/****************************************************************************
	print users cash and bank account
*/
void Guild_Balance()
{
	char    *msg;

	if (me.in_guild)
	{
		msg = getmsg(MSG225);
		
		sprintf(str, msg, me.guild_balance);
		prf(str);
	}
}
/****************************************************************************
	given an exit constant, print the direction it represents
*/
void print_exit(short dir)
{

	switch (dir)
	{
		case 0: prf(globals->north);
				break;
		case 1: prf(globals->south);
				break;
		case 2: prf(globals->east);
				break;
		case 3: prf(globals->west);
				break;
		case 4: prf(globals->up);
				break;
		case 5: prf(globals->down);
				break;
		case 6: prf(globals->out);
				break;
	}
}
/****************************************************************************
	print spells know by a character
*/
short Print_My_Spells(void)
{
	short   i;
	short   num_spells;
	short   col;
	short   pts;

	prfmsg(MSG239);

	for (i = num_spells = 0; i != NUM_SPELLS; ++i)
	{
		if (me.spell[i])
		{
			++num_spells;
		}
	}

	if (num_spells == 0)
	{
		prfmsg(MSG240);
		BAD_EXIT;
	}

	for (i = col = 0; i != NUM_SPELLS; ++i)
	{
		if (me.spell[i])
		{
			pts = spell_info[i].pts;
			if (me.class == CLERIC)
			{
				pts = pts / 2;
			}

			prfmsg
			(
				SPELDISP,
				i + 1, 
				spell_info[i].name,
				spell_info[i].dur, 
				pts
			);

			++col;

			if (col == 3)
			{
				col = 0;
				prf("\r");
			}
		}
	}

	prf("\r");
	DONE;
}
/****************************************************************************
	print all spells (used in item edit)
*/
void Print_All_Spells(void)
{
	short   i;
	short   col;

	for (i = col = 0; i != NUM_SPELLS; ++i)
	{
		prfmsg(MSG241, i, spell_info[i].name);
		++col;

		if (col == 3)
		{
		col = 0;
			prf("\r");
		}
	}

	prf("\r");
}
/****************************************************************************
	print all armor/shield instillable spells (used in item edit)
*/
void Print_Arsh_Spells(void)
{
	short   i;
	short   col;

	for (i = col = 0; i != NUM_SPELLS; ++i)
	{
		if 
		(
			i == VIGOR ||
			i == HEAL ||
			i == INVISIBILITY ||
			i == PURIFY ||
			i == MANIA ||
			i == REVEAL ||
			i == RESTORE ||
			i == PROTECT ||
			i == LEVITATE ||
			i == INVULNERABILITY ||
			i == STRENGTH ||
			i == STURDINESS ||
			i == MAGIC_SHIELD ||
			i == SEE_INVISIBLE ||
			i == HASTE ||
			i == STEALTH
		)
		{
			prfmsg(MSG241, i, spell_info[i].name);
			++col;

			if (col == 3)
			{
				col = 0;
				prf("\r");
			}
		}
	}

	prf("\r");
}
/****************************************************************************
	print all weapon instillable spells (used in item edit)
*/
void Print_Weapon_Spells(void)
{
	short   i;
	short   col;

	for (i = col = 0; i != NUM_SPELLS; ++i)
	{
		if 
		(
			i == LANGOUR ||
			i == MESMERIZE ||
			i == LIGHTNING ||
			i == BLAST ||
			i == EXHAUSTION ||
			i == FIREBALL ||  
			i == WEAKNESS ||
			i == DISPEL_MAGIC ||
			i == CURSE
		)
		{
			prfmsg(MSG241, i, spell_info[i].name);
			++col;

			if (col == 3)
			{
				col = 0;
				prf("\r");
			}
		}
	}

	prf("\r");
}
/****************************************************************************
	print damage, damaged, magic, magic used
*/
void Health(short g)
{

	prfmsg
	(
		MSG243,
		AGUY->dpts - AGUY->damaged, 
		AGUY->dpts,
		AGUY->mpts - AGUY->magic_used, 
		AGUY->mpts,
		AGUY->dpts - AGUY->ftg, 
		AGUY->dpts
	);
}
/****************************************************************************
	takes a level and returns "st", "nd", "rd", or "th"
*/
void level_fix(short level)
{
	short   l;
	char    fix[3];

	l = level;

	if (l > 9 && l < 20)
	{
		strcpy(fix, "th");
	}
	else
	{
		while (l > 9)
		{
			l -= 10;
		}

		if (l == 1)
		{
			strcpy(fix, "st");
		}
		else if (l == 2)
		{
			strcpy(fix, "nd");
		}
		else if (l == 3)
		{
			strcpy(fix, "rd");
		}
		else
		{
			strcpy(fix, "th");
		}
	}

	prf("%d%s", level, fix);
}
/****************************************************************************
	for anal-retentive neatness, print text numbers rather than digits
*/
void text_num(short num)
{

	switch(num)
	{
		case 1: prf("one");
				break;
		case 2: prf("two");
				break;
		case 3: prf("three");
				break;
		case 4: prf("four");
				break;
		case 5: prf("five");
				break;
		case 6: prf("six");
				break;
		case 7: prf("seven");
				break;
		case 8: prf("eight");
	}
}
/****************************************************************************
	print room description, exits, items, monster, and guys
*/
void print_room(void)
{

	Display_Room();
	Display_Items();
	Display_Monsters();
	Display_Guys();
	display_attacks();
	Listen();
	lucky_room_check();

	if (ABUF(B)->rm2.scrawl[0] && (me.in_guild || me.perm[GAMEOP_PERM]))
	{
		prfmsg(M254, ABUF(B)->rm2.scrawl);
	}

	if (SAFE_AREA)
	{
		prfmsg(MSG255);
	}
}
/****************************************************************************
	print who's attacking whom in a room
*/
void display_attacks(void)
{
	short   g;
	short   m;
	char    attacker[30];

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what && AMON->last_attacker >= 0)
		{
			Start_Mon_Name(attacker, m);
			g = AMON->last_attacker;

			if (g == P)
			{
				prfmsg(MSG256, attacker);
			}
			else
			{
				prfmsg(M257, attacker, AGUY->name);
			}
		}
	}
}
/****************************************************************************
	print room description and exits
*/
void Display_Room(void)
{
	short   exits;
	short   i;
	short   j;
	short   so_far;
	short   total;
	char    line[DESC_SIZE];
	char    *msg;

	if (IN_GUILD)
	{
		prfmsg(MSG258, guild->name[GUILD_NUM]);
	}
	else if (ABUF(B)->rm.rmtype == HALL_OF_FAME)
	{
		Hall_Of_Fame(0);
	}
	else if (ABUF(B)->rm.id == globals->newsstnd)
	{
		Display_Obits();
	}
	else
	{
		if (me.Option[SHORT_DESC])
		{
			for (j = 0; j != DESC_SIZE; ++j)
			{
				line[j] = 0;
			}

			for (i = 0; i < DESC_SIZE; ++i)
			{
				line[i] = ABUF(B)->rm.desc[0][i];

				if (ABUF(B)->rm.desc[0][i] == '.')
				{
					i = DESC_SIZE;
				}
			}

			prf(globals->room1, line);
		}
		else
		{
			for (i = 0; i != DESC_LINES; ++i)
			{
				if (ABUF(B)->rm.desc[i][0])
				{
					prf(globals->room2, ABUF(B)->rm.desc[i]);
				}
			}
		}

		if (ABUF(B)->rm.text_file && ABUF(B)->rm.text_descriptor[0])
		{
			prfmsg(MSG1386, ABUF(B)->rm.text_descriptor);
		}
	}

	prf(globals->room3);

	for (i = exits = 0; i != NUM_EXITS; ++i)
	{
		if
		(
			ABUF(B)->rm.exit[i] &&
			(ABUF(B)->visible[i] || Find_Ring(REVEAL, ME))
		)
		{
			++exits;
		}
	}

	for (i = so_far = 0; i != NUM_EXITS; ++i)
	{
		if
		(
			ABUF(B)->rm.exit[i] &&
			(ABUF(B)->visible[i] || Find_Ring(REVEAL, ME))
		)
		{
			++so_far;

			if (so_far == exits && exits != 1)
			{
				prf(" and ");
			}

			print_exit(i);

			if (so_far < exits - 1)
			{
				prf(", ");
			}
		}
	}

	Room_Cover(ABUF(B)->rm.cover);

	if
	(
		ABUF(B)->rm.spec_exit.type &&
		ABUF(B)->rm.spec_exit.leads_to &&
		(ABUF(B)->visible[NUM_EXITS] || Find_Ring(REVEAL, ME))
	)
	{
		prfmsg(M262A);
		Special_Exit(1);

		if
		(
			ABUF(B)->rm.spec_exit.filter &&
			ABUF(B)->rm.spec_exit.filter <= NUM_SAVED_PLACES - 1
		)
		{
			prfmsg(MSG263, guild->name[ABUF(B)->rm.spec_exit.filter]);
			Read_Guild_Catalog(ABUF(B)->rm.spec_exit.filter, a_closet);
		
			for (i = total = 0; i != MAX_ROOM_MON; ++i)
			{
				if (ABUF(B)->mon[i].what)
				{
					++total;
				}
			}

			if 
			(
				a_closet->item[0].what && 
				total == 0 && 
				!ABUF(B)->rm.enc_chance
			)
			{
				prfmsg(MSG1006);
			}
		}
	}

	if (IN_GUILD)
	{
		msg = getmsg(MSG264);
		sprintf(str, msg, guild->treasury[abs(ABUF(B)->rm.rmtype)]);
		prf(str);
	}
}
/****************************************************************************
	print room items
*/
void Display_Items(void)
{
	short   i;
	short   num_items;
	short   x;

	for (i = num_items = 0; i != NUM_ITEMS; ++i)
	{
		if (ABUF(B)->item[i].what)
		{
			++num_items;
		}
	}

	if (num_items)
	{
		prfmsg(M262B);

		for (i = 0, x = 1; i != NUM_ITEMS; ++i)
		{
			if (ABUF(B)->item[i].what)
			{
				if (num_items != 1 && x == num_items)
				{
					prf(" and ");
				}
				else if (num_items != 1 && x != 1)
				{
					prf(", ");
				}

				Display_Item(&ABUF(B)->item[i]);
				++x;
			}
		}
		
		prf("\r");
	}
}
/****************************************************************************
	print room monsters
*/
short Display_Monsters(void)
{
	short   m;
	short   i;
	short   n;
	short   x;
	short   prev;
	short   invaders = 0;
	short   count[MAX_ROOM_MON];
	short   which[MAX_ROOM_MON];
	char    index[MAX_ROOM_MON];

	for (i = 0; i != MAX_ROOM_MON; ++i)
	{
		count[i] = 0;
	}

	for (m = n = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what && !AMON->hidden)
		{
			prev = 0;
			if (n != 0)
			{
				for (i = 0; i != n; ++i)
				{
					if (AMON->which == which[i])
					{
						++count[i];
						prev = 1;
					}
				}
			}

			if (prev == 0)
			{
				which[n] = AMON->which;
				index[n] = m;
				count[n] = 1;
				++n;
			}
		}
	}
				
	if (n)
	{
		prfmsg(M275);

		for (i = 0, x = 1; i != MAX_ROOM_MON; ++i)
		{
			if (count[i])
			{
				if (n != 1 && x == n)
				{
					prf(" and ");
				}
				else if (n != 1 && x != 1)
				{
					prf(", ");
				}

				if (count[i] == 1)
				{
					print_mon(index[i]);
				}
				else
				{
					text_num(count[i]);
					prf(" %s", ABUF(B)->mon[index[i]].plural_name);
				}
				++x;
			}
		}
		prf("\r");
	}

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what && AMON->which == invasion->crit && invasion->active)
		{
			++invaders;
		}
	}

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if 
		(
			invaders &&
			AMON->what && 
			AMON->which == globals->rover && 
			invasion->active
		)
		{
			prfmsg(MSG830, globals->captive);
		}
	}

	return (n);
}
/****************************************************************************
	print lots of info about the monsters in this room
*/
short Monster_Summary(void)
{
	short   m;
	short   status;
	short   total = 0;
	short   invaders = 0;

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what && !AMON->hidden)
		{
			++total;
			Brief_Mon_Name(name, m);
			prfmsg(MSG1550, total, name);
			status = 0;

			if (AMON->sees[P])
			{
				if (status)
				{
					prf(" ");
				}
				
				++status;
				prfmsg(MSG1554);
			}

			if (find_timer(SLEEP_TIME, MON))
			{
				if (status)
				{
					prf(" ");
				}
				
				++status;
				prfmsg(MSG1551);
			}

			if (AMON->bashed)
			{
				if (status)
				{
					prf(" ");
				}
				
				++status;
				prfmsg(MSG1552);
			}

			if (find_timer(MES_TIME, MON))
			{
				if (status)
				{
					prf(" ");
				}
				
				++status;
				prfmsg(MSG1553);
			}

			if (AMON->last_attacker == P)
			{
				if (status)
				{
					prf(" ");
				}
				
				prfmsg(MSG1556);
			}
			else if (AMON->last_attacker >= 0)
			{
				if (status)
				{
					prf(" ");
				}
				
				prfmsg(MSG1557, APORT(AMON->last_attacker)->chr.name);
			}

			prf("\r");
		}
	}

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what && AMON->which == invasion->crit && invasion->active)
		{
			++invaders;
		}
	}

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if 
		(
			invaders &&
			AMON->what && 
			AMON->which == globals->rover && 
			invasion->active
		)
		{
			prfmsg(MSG830, globals->captive);
		}
	}

	return (total);
}
/****************************************************************************
	display a monster's name
*/
void print_mon(short m)
{

	if (AMON->article[0])
	{
		prf("%s ", AMON->article);
	}

	prf("%s", AMON->name);
}
/****************************************************************************
	print room guys
*/
short Display_Guys(void)
{
	short   g;
	short   vis_guys = 0;
	short   visible[MAX_CHANNELS];
	short   so_far = 1;
	short   invis_t;
	short   see_invis_t;
	short   hidden;

	see_invis_t = find_timer(SEE_INVIS_TIME, ME);

	for (g = 1; g != NTERMS; ++g)
	{
		visible[g] = FALSE;

		if (g != P && ABUF(B)->guy[g])
		{
			invis_t = find_timer(INVISIBLE_TIME, GUY);

			if (me.perm[SUPER_PERM])
			{
				hidden = FALSE;
			}
			else if (APORT(g)->hidden)
			{
				hidden = TRUE;
			}
			else if (invis_t && !see_invis_t)
			{
				hidden = TRUE;
			}
			else
			{
				hidden = FALSE;
			}

			if (!hidden)
			{
				++vis_guys;
				visible[g] = TRUE;
			}
		}
	}

	if (vis_guys)
	{
		prf("%s", red);

		for (g = 1; g != NTERMS; ++g)
		{
			if (visible[g])
			{
				if (vis_guys != 1 && so_far == vis_guys)
				{
					prf(" and ");
				}
				else if (vis_guys != 1 && so_far != 1)
				{
					prf(", ");
				}

				if (TYPE == ARENA)
				{
					sprintf(str, "%s (%ld)", AGUY->name, APORT(g)->my_bet);
					prf(str);
				}
				else
				{
					prf("%s", AGUY->name);
				}
				++so_far;
			}
		}

		if (vis_guys == 1)
		{
			prf(" is here.\r");
		}
		else
		{
			prf(" are here.\r");
		}
	}

	return (vis_guys);
}
/****************************************************************************
	print all the relevant information about a hidden special exit
*/
void Special_Exit(short option)
{

	if (ABUF(B)->rm.spec_exit.article[0])
	{
		prf("%s ", ABUF(B)->rm.spec_exit.article);
	}

	if (ABUF(B)->rm.spec_exit.adjective[0])
	{
		prf("%s ",ABUF(B)->rm.spec_exit.adjective);
	}

	prf("%s.", ABUF(B)->rm.spec_exit.descriptor);

	if (ABUF(B)->rm.spec_exit.type != NOT_SPECIAL && option)
	{
		if (!ABUF(B)->rm.spec_exit.locked)
		{
			prfmsg(MSG265);
		}
		else
		{
			prfmsg(M266);
		}
	}

	prf("\r");
}
/****************************************************************************
	print an inventory of items on the ground
*/
void display_ground_items(void)
{
	short   i;
	short   j;

	prfmsg(M262B);

	for (i = j = 0; i != NUM_ITEMS; ++i)
	{
		if (ABUF(B)->item[i].what)
		{
			item = ABUF(B)->item[i];
			++j;
			if (j == 1)
			{
				prf("\r");
			}

			prfmsg(MSG267, j);
			Color_Display_Item(&item);

			if (ARSH(item) || WEAPON(item))
			{
				if (item.uses <= 10)
				{
					prfmsg(MSG221);
				}
			}
			else if (item.what == CONTAINER)
			{
				if (item.holding == 1)
				{
					prfmsg(MSG222);
				}
				else
				{
					prfmsg(MSG223, item.holding);
				}
			}
			prf("\r");
		}
	}

	if (j == 0)
	{
		prfmsg(MSG268);
	}
}
/****************************************************************************
	show what a monster is wielding/wearing
*/
void show_mon_equip(short m)
{
	short   held = 0;
	short   i;
	short   printed;

	for (i = 0; i != MAX_MON_ITEM; ++i)
	{
		if (AMON->item_used[i])
		{
			if (AMON->item_has[i].what == ARMOR)
			{
				prfmsg(MSG206);
				Display_Item(&AMON->item_has[i]);
				prf("\r");
			}
			else
			{
				++held;
			}
		}
	}
	
	if (held)
	{
		prfmsg(MSG203);

		for (i = printed = 0; i != MAX_MON_ITEM; ++i)
		{
			if (AMON->item_used[i] && AMON->item_has[i].what != ARMOR)
			{
				++printed;
				Display_Item(&AMON->item_has[i]);
				if (printed != held)
				{
					if (printed == held - 1)
					{
						prf(", and ");
					}
					else
					{
						prf(", ");
					}
				}
			}
		}
		prf("\r");
	}
}
/****************************************************************************
	display the current bounty monster
*/
short Display_Current_Bounty(void)
{
	short   i;
	short   count;
	short   captive = FALSE;

	if (me.perm[GAMEOP_PERM] && word1[0])
	{
		globals->next_bounty = atoi(word1);
		
		if 
		(
			globals->next_bounty < 1 || 
			globals->next_bounty > globals->maxmon
		)
		{
			globals->next_bounty = 0;
			prf("Invalid monster index number\r");
			DONE;
		}
		
		globals->next_bounty_mins = real_which1;
		globals->bounty_timer = 1;

		prf("OK\r"); 
		DONE;
	}

	prfmsg
	(
		M269, 
		globals->bounty_timer / 60, 
		globals->bounty.plural_name
	);

	if (!invasion->active)
	{
		if (me.perm[GAMEOP_PERM])
		{
			prfmsg(MSG713, invasion->timer / 60);
		}
	}
	else
	{
		for (i = count = 0; i != MAX_INVASION_ROOMS; ++i)
		{
			if (invasion->room[i])
			{
				count += invasion->count[i];
			}
		}

		Read_Critter(invasion->crit, &crit);
		crit.plural_name[0] = toupper(crit.plural_name[0]);

		prfmsg(M270, crit.plural_name, invasion->num_left + count);

		if (me.perm[GAMEOP_PERM])
		{
			prfmsg(M271, invasion->origin);
		}
		prf("\r");

		if (me.perm[GAMEOP_PERM])
		{
			prfmsg(M712, invasion->level, invasion->duration / 60);
		}

		if (globals->captive_safe == FALSE)
		{
			for (i = 0; i != MAX_PERM_MON; ++i)
			{
				if 
				(
					globals->perm_mon_id[i] == globals->rover && 
					globals->perm_mon_loc[i]
				)
				{
					captive = TRUE;
				}
			}
		}

		if (captive)
		{
			prfmsg(MSG830, globals->captive);
		}
	}

	if (slow_mons)
	{
		prfmsg(M272);
	}
	else if (bp_mons)
	{
		prfmsg(M273);
	}
	else if (exp_mons)
	{
		prfmsg(M274);
	}

	DONE;
}
/****************************************************************************
	display a guy timer
*/
short FIND(short s, char *spell_name)
{
	short   t;
	short   found_it = FALSE;

	for (t = 0; t != NUM_GUY_TIMERS; ++t)
	{
		if (MY_PORT->misc_type[t] == s)
		{
			found_it = TRUE;
			prfmsg(ATIMER1, spell_name, MY_PORT->timer[t]);
		}
	}

	return (found_it);
}
/****************************************************************************
	display a monster timer
*/
short EXPORT FIND_MON(short m, short s, char *spell_name)
{
	short   t;
	short   found_it = FALSE;

	for (t = 0; t != NUM_MON_TIMERS; ++t)
	{
		if (AMON->misc_type[t] == s)
		{
			found_it = TRUE;
			prfmsg(ATIMER1, spell_name, AMON->timer[t]);
		}
	}

	return (found_it);
}
