#include <header.h>
#include <globals.h>

/****************************************************************************
	get the bigblock reference for a character
*/
struct charstruct * EXPORT Seek_Character(short p)
{
	struct port_struct *ptr;

	ptr = PORT[p];
	return (&ptr->chr);
}
/****************************************************************************
	get the bigblock reference for a room buffer
*/
struct room_buffer_struct *Seek_Buffer(short b)
{
	struct room_buffer_struct *ptr;

	ptr = BUF[b];
	return (ptr);
}
/****************************************************************************
	get the bigblock reference for a monster
*/
struct mon_struct *Seek_Monster(short m)
{
	struct room_buffer_struct *ptr;

	ptr = BUF[B];
	return(&ptr->mon[m]);
}
/****************************************************************************
	get the bigblock reference for a port
*/
struct port_struct *Seek_Port(short p)
{
	struct port_struct *ptr;

	ptr = PORT[p];
	return (ptr);
}
/*****************************************************************************
	switch context to a new user
*/
short Next_User(short p)
{

	globals->old_p[context_count] = P;
	globals->old_b[context_count] = B;
	++context_count;

	P = p;
	B = APORT(p)->B;
	DONE;
}
/*****************************************************************************
	switch back to the previous user
*/
short EXPORT Previous_User(void)
{

	--context_count;
	P = globals->old_p[context_count];
	B = globals->old_b[context_count];
	DONE;
}
