#include <header.h>
#include <globals.h>

/***************************************************************************
	execute user's command
*/
short EXPORT do_command(void)
{
	short   m;
	short   i;
	short   asleep = find_timer(SLEEP_TIME, ME);
	short   ko_d = find_timer(KO_TIME, ME);

	switch (command)
	{
		case ACTIVATE_MENU:
			MY_PORT->hot_menu = FALSE;

			if (TYPE == ACADEMY)
			{
				if (me.Option[NOVICE])
				{
					prfmsg(MSG1585);
				}
				else
				{
					No_Follow();
					prfmsg(MSG1587);
					Set_Prompt(getmsg(MSG1588), ACADEMY_PROMPT);
				}
			}
			else if (ABUF(B)->rm.rmtype == BANK)
			{
				No_Follow();
				prfmsg(MSG1504, l2as(me.bank), l2as(me.gold));

				if (me.in_guild)
				{
					prfmsg
					(
						MSG1505, 
						l2as(me.guild_balance), 
						l2as(guild->treasury[me.in_guild])
					);
				}

				prfmsg(MSG1506);
				Set_Prompt(getmsg(MSG1507), BANK_PROMPT);
			}
			else if (IN_GUILD)
			{
				No_Follow();
				prfmsg(MSG1504, l2as(me.bank), l2as(me.gold));
				prfmsg
				(
					MSG1505, 
					l2as(me.guild_balance), 
					l2as(guild->treasury[me.in_guild])
				);
				prfmsg(MSG1524);
				Set_Prompt(getmsg(MSG1507), TREASURY_PROMPT);
			}
			else if 
			(
				TYPE == ALCHEMIST ||
				TYPE == ARMORY ||
				TYPE == WEAPONSMITH ||
				TYPE == MERCANTILE ||
				(
					ABUF(B)->rm.spec_exit.filter &&
					ABUF(B)->rm.spec_exit.filter <= NUM_SAVED_PLACES - 1
				)
			)
			{
				if (margc > 1 && sameas(margv[1], "C"))
				{
					Catalog();
				}
				else if (margc > 1 && sameas(margv[1], "I"))
				{
					Inventory();
				}
				else if (margc > 1 && sameas(margv[1], "B"))
				{
					if (margc == 2)
					{
						if (Catalog())
						{
							MY_PORT->hot_menu = TRUE;
							Set_Prompt(getmsg(MSG1528), MERC_PROMPT1);
						}
					}
					else
					{
						Buy();
					}
				}
				else if (margc > 1 && sameas(margv[1], "S"))
				{
					MY_PORT->hot_menu = TRUE;

					if (margc == 2)
					{
						Inventory();
				
						if
						(
							TYPE == ALCHEMIST ||
							TYPE == ARMORY ||
							TYPE == WEAPONSMITH ||
							TYPE == MERCANTILE
						)
						{
							Set_Prompt(getmsg(MSG1529), MERC_PROMPT2);
						}
						else
						{
							Set_Prompt(getmsg(MSG1533), MERC_PROMPT2);
						}
					}
					else
					{
						Sell();
					}
				}
				else
				{
					No_Follow();
					prfmsg(MSG1504, l2as(me.bank), l2as(me.gold));
					prfmsg(MSG1526);
					Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
				}
			}
			else
			{
				prfmsg(MSG1549);
			}
			break;

		case MAIL_MENU:
			if (margc == 1)
			{
				MY_PORT->hot_menu = FALSE;
				Mail_Menu(0);
			}
			else
			{
				MY_PORT->hot_menu = TRUE;
				strcpy(margv[0], margv[1]);
				Mail_Menu(2);
			}
			break;

		case OFFICES:
			if (margc == 1)
			{
				MY_PORT->hot_menu = FALSE;
				Office_Menu(0);
			}
			else
			{
				MY_PORT->hot_menu = TRUE;
				strcpy(margv[0], margv[1]);
				Office_Menu(2);
			}
			break;

		case GUILDS:
			if (margc == 1)
			{
				MY_PORT->hot_menu = FALSE;
				Guild_Menu(0);
			}
			else
			{
				MY_PORT->hot_menu = TRUE;
				strcpy(margv[0], margv[1]);
				Guild_Menu(2);
			}
			break;

		case GAMEOP:
			if (margc == 1)
			{
				GameOp_Menu(0);
			}
			else
			{
				strcpy(margv[0], margv[1]);
				GameOp_Menu(1);
			}
			break;

		case HEALTH:
			Health(P);
			break;

		case BURDEN:
			Display_Burden();
			break;

		case SWAP:
			Inventory_Swap();
			break;

		case BERSERK:
			if (me.class != BARBARIAN)
			{
				prfmsg(MSG871);
			}
			else if (MY_PORT->berserk)
			{
				prfmsg(MSG872);
				MY_PORT->berserk = FALSE;
				sprintf(str, getmsg(MSG873), me.name);
				Message(str, QUIET_LOCAL);
			}
			else
			{
				prfmsg(MSG874);
				MY_PORT->berserk = TRUE;
				sprintf(str, getmsg(MSG875), me.name);
				Message(str, QUIET_LOCAL);
			}
			break;

		case INSTILL:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else
			{
				Instill();
			}
			break;

		case TRANCE:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else
			{
				Trance();
			}
			break;

		case GUARD:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else
			{
				Guards();
			}
			break;

		case DAYFILE:
			Dayfile();
			break;

		case QUIT:
			Quit(0);
			break;

		case BOUNTY:
			Display_Current_Bounty();
			break;

		case WHERE:
			who();
			break;
		
		case HELP:
			help();
			break;

		case LOOK:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else
			{
				Look_At();
			}
			break;

		case NORTH:
		case SOUTH:
		case EAST:
		case WEST:
		case UP:
		case DOWN:
		case OUT:
			if (MY_PORT->bashed)
			{
				prfmsg(MSG881);
			}
			else if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else
			{
				Moving(0);
			}
			break;

		case SEARCH:
			if (action_ok())
			{
				Set_Action_Time(10);
				Search();
				Reveal_Me(-1);
			}
			break;

		case GO:
			Go_Special(0);
			break;

		case DUMP:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else
			{
				Dump_Bag();
			}
			break;

		case INVENTORY:
			Inventory();
			break;

		case DROP:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else
			{
				i = drop_item();

				if (i)
				{
					Reveal_Me(-1);
				}
			}

			break;

		case GET:
			if (me.Dex < globals->speedbon)
			{
				i = action_ok();
			}
			else
			{
				i = TRUE;
			}

			if (i)
			{
				if (MY_PORT->bashed)
				{
					prfmsg(MSG881);
				}
				else if (asleep)
				{
					prfmsg(MSG310);
				}
				else if (ko_d)
				{
					prfmsg(MSG311);
				}
				else
				{
					i = get_item();

					if (i && !SAFE_AREA && me.Dex < globals->speedbon)
					{
						Set_Action_Time(2);
					}

					if (i)
					{
						Reveal_Me(-1);
					}
				}
			}
			break;

		case TOSS:
			i = find_timer(FLOAT_TIME, ME);

			if (i)
			{
				prfmsg(MSG884);
			}
			else if (MY_PORT->bashed)
			{
				prfmsg(MSG881);
			}
			else if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else
			{
				i = toss_item();

				if (i)
				{
					Reveal_Me(-1);
				}
			}
			break;

		case WHO:
			where();
			break;

		case SEND:
			do_send(GLOBAL);
			break;

		case GSEND:
			if (me.in_guild)
			{
				do_send(GUILD_GLOBAL);
			}
			else
			{  
				prfmsg(M727);
			}
			break;

		case BROADCAST:
			if (me.perm[GAMEOP_PERM])
			{
				do_send(GLOBAL);
			}
			else
			{
				prfmsg(M880);
			}
			break;

		case SAY:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else if (do_send(SAYING))
			{
				Reveal_Me(-1);
			}
			break;

		case WHISPER:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else
			{
				do_send(WHISPERING);
			}
			break;

		case IGNORE:
			Ignore();
			break;

		case HIDE:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else if (me.thief >= globals->thide || action_ok())
			{
				hide();
				if (me.thief < globals->thide)
				{
					Set_Action_Time(4);
				}
			}
			break;

		case TRACK:
			if (action_ok())
			{
				Track();
				Set_Action_Time(2);
				Reveal_Me(-1);
			}
			break;

		case LABEL:
			Label_Item(0);
			break;

		case USE:
			if (Use_Item())
			{
				Set_Action_Time(4);
				Reveal_Me(-1);
			}
			break;

		case SAVE:
			Write_My_Rec(EXISTS);
			prfmsg(MSG885);
			break;

		case FLEE:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else if (!Fatigue(NEEDED))
			{
				prfmsg(MSG887);
			}
			else if (MY_PORT->limbo_return)
			{
				prfmsg(MSG888);
			}
			else if (MY_PORT->fine)
			{
				prfmsg(MSG889);
			}
			else if (me.location == globals->townsq && MY_PORT->bashed)
			{
				prfmsg(MSG311);
			}
			else
			{
				short   num_items = 0;
				short   num_exits = 0;

				for (i = 0; i != NUM_EXITS; ++i)
				{
					if (ABUF(B)->rm.exit[i] && ABUF(B)->visible[i])
					{
						++num_exits;
					}
				}
				
				if 
				(
					ABUF(B)->rm.spec_exit.leads_to &&
					!ABUF(B)->rm.spec_exit.locked &&
					ABUF(B)->visible[NUM_EXITS] &&
					!ABUF(B)->rm.spec_exit.filter
				)
				{
					++num_exits;
				}

				if (num_exits == 0)
				{
					prfmsg(MSG890);
					BAD_EXIT;
				}
				else if 
				(
					RANDOM(4) != 1 && 
					(MY_PORT->bashed || (me.rw < 0 && me.lw < 0 && me.shld < 0 && me.focus < 0))
				)
				{
					for (i = 0; i != NUM_ITEMS; ++i)
					{
						if (me.item[i].what && i != me.armor)
						{
							++num_items;
						}
					}

					if (num_items)
					{
						do
						{
							i = RANDOM(NUM_ITEMS) - 1;
						}
						while (me.item[i].what == 0 || i == me.armor);

						strcpy(str, getmsg(MSG891));
						Cat_Item(str, &me.item[i]);
						Put_In_Room(&me.item[i]);
						Lose_Item(i);
						prf("%s\r", str);
					}
				}

				if (MY_PORT->bashed && RANDOM(10) > 3)
				{
					prfmsg(MSG892);
				}
				else
				{
					Flee();
					Reveal_Me(-1);
				}

				Fatigue(ADD);
			}
			break;

		case FOLLOW:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else
			{
				follow();
			}
			break;

		case LOSE:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else
			{
				lose();
			}
			break;

		case GIVE:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else
			{
				i = give_item();

				if (i)
				{
					Reveal_Me(-1);
				}
			}
			break;

		case DRAG:
			if (MY_PORT->bashed)
			{
				prfmsg(MSG881);
			}
			else if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else if (Drag())
			{
				Reveal_Me(-1);
			}
			break;

		case BASH:
			MY_PORT->last_attack = BASH;
			go_attack(GET_WORD);
			break;

		case HIT:
		case PARRY:
		case GREATBLOW:
			MY_PORT->last_attack = command;
			go_attack(GET_WORD);
			break;

		case UNCAST:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else
			{
				i = uncast_spells();
				if (i)
				{
					Reveal_Me(-1);
				}
			}
			break;

		case CAST:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else
			{
				if (cast())
				{
					if 
					(
						me.class == SORCERER ||
						me.class == CLERIC ||
						me.class == MYSTIC
					)
					{
						Set_Action_Time(4);
					}
					else
					{
						Set_Action_Time(6);
					}
					
					Reveal_Me(-1);

					if (MY_PORT->enemy_mon >= 0)
					{
						m = MY_PORT->enemy_mon;
		
						if (AMON->sees[P])
						{
							AMON->last_attacker = P;
						}
					}
				}
			}
			break;

		case SPELLS:
			Print_My_Spells();
			break;

		case TALK:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else if (talk())
			{
				Reveal_Me(-1);
			}
			break;

		case YELL:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else
			{
				do_send(LOUD_LOCAL);
				Reveal_Me(-1);
			}
			break;

		case SMASH:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else if (Smash_Door())
			{
				Reveal_Me(-1);
			}
			break;

		case OPTIONS:
			if (margc > 1)
			{
				i = Set_Options(&me);

				if (me.Option[NO_COLOR])
				{
					usaptr->ansifl = 0;
					stansi();
				}
				else
				{
					usaptr->ansifl = ANSON;
					stansi();
				}
				
				if (i)
				{
					List_Options(&me, i);
					Write_My_Rec(EXISTS);
				}
			}
			else
			{
				List_Options(&me, -1);
			}
			break;

		case STEAL:
			if (action_ok())
			{
				i = steal_item();
				if (i)
				{
					Reveal_Me(-1);
				}
			}
			break;

		case MACROS:
			if (margc > 1)
			{
				Set_Macro();
			}
			else
			{
				List_Macros();
			}
			break;

		case STATS:
			Stats();
			break;

		case TIMERS:
			list_timers();
			break;

		case LIMBO:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else
			{
				limbo();
			}
			break;

		case DISPLAY_ITEMS:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else if 
			(
				ABUF(B)->item[0].what == 0 &&
				(
					TYPE == ALCHEMIST ||
					TYPE == ARMORY ||
					TYPE == WEAPONSMITH ||
					TYPE == MERCANTILE
				) 
			)
			{
				Catalog();
			}
			else if
			(
				ABUF(B)->item[0].what == 0 &&
				ABUF(B)->rm.spec_exit.filter &&
				ABUF(B)->rm.spec_exit.filter <= NUM_SAVED_PLACES - 1
			)
			{
				Guild_Catalog(ABUF(B)->rm.spec_exit.filter);
			}
			else
			{
				display_ground_items();
			}
			break;

		case DISPLAY_OTHERS:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else
			{
				i = Monster_Summary();
				i += Display_Guys();

				if (i == 0)
				{
					prfmsg(MSG895);
				}
			}
			break;

		case LISTEN:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else
			{
				i = Listen();
				if (i == 0)
				{
					prfmsg(MSG896);
				}
			}
			break;

		case DO:
			if (asleep)
			{
				prfmsg(MSG310);
			}
			else if (ko_d)
			{
				prfmsg(MSG311);
			}
			else if (do_send(SAYING))
			{
				Reveal_Me(-1);
			}
			break;

		case EXPERIENCE:
			Display_Quests(ACTIVE_QUESTS);
			Display_Quests(INACTIVE_QUESTS);
			break;

		case POOBAHS:
			Poobahs();
			break;

		case VILLAINS:
			Villains();
			break;
	}
	DONE;
}
/****************************************************************************
	switch two items in my inventory 
*/
short Inventory_Swap(void)
{
	short   i1;
	short   i2;

	if (margc != 3)
	{
		prfmsg(MSG1341);
		BAD_EXIT;
	}

	i1 = INUM(margv[1]);
	i2 = INUM(margv[2]);

	if (i1 < 1 || i1 > NUM_ITEMS)
	{
		prfmsg(MSG1019, i1);
		BAD_EXIT;
	}
	
	if (i2 < 1 || i2 > NUM_ITEMS)
	{
		prfmsg(MSG1019, i2);
		BAD_EXIT;
	}

	--i1;
	--i2;

	if (me.item[i1].what == 0)
	{
		prfmsg(MSG1019, i1 + 1);
		BAD_EXIT;
	}
	
	if (me.item[i2].what == 0)
	{
		prfmsg(MSG1019, i2 + 1);
		BAD_EXIT;
	}

	if (i1 == i2)
	{
		DONE;
	}

	item = me.item[i1];
	me.item[i1] = me.item[i2];
	me.item[i2] = item;

	Display_Item(&me.item[i1]);
	prf("%s and ", white);
	Display_Item(&me.item[i2]);
	prf("%s swapped.\r", white);

	if (me.lw == i1)
	{
		me.lw = i2;
	}
	else if (me.lw == i2)
	{
		me.lw = i1;
	}

	if (me.rw == i1)
	{
		me.rw = i2;
	}
	else if (me.rw == i2)
	{
		me.rw = i1;
	}

	if (me.armor == i1)
	{
		me.armor = i2;
	}
	else if (me.armor == i2)
	{
		me.armor = i1;
	}

	if (me.shld == i1)
	{
		me.shld = i2;
	}
	else if (me.shld == i2)
	{
		me.shld = i1;
	}

	if (me.focus == i1)
	{
		me.focus = i2;
	}
	else if (me.focus == i2)
	{
		me.focus = i1;
	}

	DONE;
}
/****************************************************************************
	sysop wants to find something in the data files
*/
short Find_Stuff(void)
{
	short   x;
	
	rstrxf();
	
	if (MY_PORT->finding == FIND_ITEM)
	{
		++MY_PORT->find_i;
		
		if (MY_PORT->find_i > globals->maxitem)
		{
			MY_PORT->finding = FALSE;
		}
		else
		{
			Read_Item(MY_PORT->find_i, &item);
			
			if (sameto(MY_PORT->str, item.name))
			{
				if (!MY_PORT->misc)
				{
					prf("\r");
					MY_PORT->misc = TRUE;
				}

				prfmsg(MSG1336, MY_PORT->find_i);
				Display_Item(&item);
				prf("\r");
				
				MY_PORT->find_m = 1;
				MY_PORT->finding = FIND_ITEM_MON;
			}
		}
	}

	if (MY_PORT->finding == FIND_ITEM_MON)
	{
		++MY_PORT->find_m;

		if (MY_PORT->find_m > globals->maxmon)
		{
			MY_PORT->finding = FIND_ITEM;
		}
		else
		{
			Read_Critter(MY_PORT->find_m, &crit);
					
			for (x = 0; x < POSSIBLE_MON_ITEM; ++x)
			{
				if (crit.Item[x] == MY_PORT->find_i)
				{
					prf("       ");
					prfmsg(MSG1336, MY_PORT->find_m);
			
					if (crit.article[0])
					{
						prf("%s%s ", red, crit.article);
					}

					prf("%s%s\r", red, crit.name);
					x = POSSIBLE_MON_ITEM;
				}
			}
		}
	}

	if (MY_PORT->finding == FIND_CRIT)
	{
		++MY_PORT->find_m;

		if (MY_PORT->find_m > globals->maxmon)
		{
			MY_PORT->finding = FALSE;
		}
		else
		{
			Read_Critter(MY_PORT->find_m, &crit);
			
			if (sameto(MY_PORT->str, crit.name))
			{
				if (!MY_PORT->misc)
				{
					prf("\r");
					MY_PORT->misc = TRUE;
				}

				prfmsg(MSG1336, MY_PORT->find_m);

				if (crit.article[0])
				{
					prf("%s%s ", red, crit.article);
				}

				prf("%s%s\r", red, crit.name);
				
				MY_PORT->find_r = 1;
				MY_PORT->finding = FIND_CRIT_ROOM;
			}
		}
	}

	if (MY_PORT->finding == FIND_CRIT_ROOM)
	{
		++MY_PORT->find_r;

		if (MY_PORT->find_r > globals->maxroom)
		{
			MY_PORT->finding = FIND_CRIT;
		}
		else
		{
			Read_Room(MY_PORT->find_r, &a_room, &a_room2);

			if (a_room.enc_chance)
			{
				for (x = 0; x < POSSIBLE_MONS; ++x)
				{
					if (a_room.monster_here[x] == MY_PORT->find_m)
					{
						prf("       ");
						prfmsg(MSG1336, MY_PORT->find_r);
			
						strncpy(str, a_room.desc[0], 60);
						str[60] = 0;

						prf("%s%s\r", white, str);

						x = POSSIBLE_MONS;
					}
				}
			}
		}
	}

	if (!MY_PORT->finding)
	{
		if (!MY_PORT->misc)
		{
			prf("\rNo matches found.\r");
		}

		prf("%s", MY_PORT->prompt);
	}
	else
	{
		btuinj(usrnum, MYCYCLE);
	}

	outprf(MY_PORT->usrnum);
	clrprf();

	DONE;
}
/****************************************************************************
	user wants some help from the town guard
*/
short Guards(void)
{
	short   invader;
	short   m;
	short   hauled_away = FALSE;     

	sprintf(str, getmsg(MSG901), me.name);
	Message(str, LOUD_LOCAL);

	if (!ABUF(B)->rm.town)
	{
		strcpy(str, getmsg(MSG902));
		Message(str, LOUD_LOCAL);
		prf("%s\r", str);
		BAD_EXIT;
	}

	for (m = MAX_ROOM_MON - 1; m >= 0; --m)
	{
		if (invasion->active && AMON->which == invasion->crit)
		{
			invader = TRUE;
		}
		else
		{
			invader = FALSE;
		}

		if 
		(
			AMON->what && 
			!AMON->hurt_by[P] && 
			!AMON->alg &&
			!AMON->pursue_forever &&
			!invader
		)
		{
			if (!hauled_away)
			{
				hauled_away = TRUE;
				strcpy(str, getmsg(MSG903));
				Message(str, LOUD_LOCAL);
				prf("%s\r", str);
			}

			Start_Mon_Name(name, m);
			sprintf(str, getmsg(MSG904), name);
			Message(str, LOUD_LOCAL);
			prf("%s\r", str);
			
			Remove_Mon(m, FALSE);
		}
	}

	if (!hauled_away)
	{
		strcpy(str, getmsg(MSG902));
		Message(str, LOUD_LOCAL);
		prf("%s\r", str);
	}      

	DONE;
}
/*****************************************************************************
	user is raising hell with his voice
*/
void yelled(void)
{
	short   m;

	if (ABUF(B)->rm.enc_chance > 0)
	{
		ABUF(B)->yell = 100;
	}

	if (ABUF(B)->room_timer > 1)
	{
		ABUF(B)->room_timer = 1;
	}

	prfmsg(MSG916);

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what && AMON->hidden)
		{
			Monster_Name(name, AMON->article, AMON->name);
			sprintf(str, getmsg(MSG1349), name);
			Message(str, LOUD_LOCAL);
			prf("%s\r", str);
			AMON->hidden = FALSE;
			AMON->action_timer = AMON->action_timer / 3;
		}

		if 
		(
			AMON->what && 
			AMON->last_attacker < 0 && 
			AMON->action_timer == 0 &&
			!AMON->permanant
		)
		{
			if (!find_timer(SLEEP_TIME, MON))
			{
				Start_Mon_Name(name, m);
				sprintf(str, getmsg(MSG917), name, me.name);
				Message(str, LOUD_LOCAL);
				prfmsg(MSG918, name);
			}

			AMON->last_attacker = P;
			AMON->sees[P] = TRUE;
		}
	}
}
/****************************************************************************
	sysop wants to erase a character
*/
short Zap(void)
{
	short   old_usrnum;
	short   i;
	short   index;

	index = Find_A_Char(&a_char, margv[0]);

	if (index < 0)
	{
		prfmsg(M920, margv[0]);
		BAD_EXIT;
	}

	if (index == MY_PORT->index)
	{
		prfmsg(MSG921);
		BAD_EXIT;
	}

	for (i = 0; i != NTERMS; ++i)
	{
		if (APORT(i)->status && APORT(i)->index == index)
		{
			APORT(i)->zapped = TRUE;
			outprf(MY_PORT->usrnum);
			clrprf();
			old_usrnum = usrnum;
			usrnum = APORT(i)->usrnum;
			byenow(ZAPPED);
			usrnum = old_usrnum;
		}
	}
	
	index = Find_A_Char(&a_char, margv[0]);

	if (index >= 0)
	{
		prfmsg(MSG922, a_char.name);
		Remove_User(index);
	}

	DONE;
}
/****************************************************************************
	sysop wants to suspend a character
*/
short Suspend(void)
{
	short   old_usrnum;
	short   i;
	short   index;

	index = Find_A_Char(&a_char, margv[0]);

	if (index < 0)
	{
		prfmsg(M920, margv[0]);
		BAD_EXIT;
	}

	if (index == MY_PORT->index)
	{
		prfmsg(MSG924);
		BAD_EXIT;
	}

	if (a_char.suspended != -1)
	{
		for (i = 0; i != NTERMS; ++i)
		{
			if (APORT(i)->status && APORT(i)->index == index)
			{
				outprf(MY_PORT->usrnum);
				clrprf();
				old_usrnum = usrnum;
				usrnum = APORT(i)->usrnum;
				APORT(i)->zapped = TRUE;
				byenow(SUSPND);
				usrnum = old_usrnum;
			}
		}
	
		index = Find_A_Char(&a_char, margv[0]);
		prfmsg(MSG925, a_char.name);
		a_char.suspended = -1;
		Write_A_Char(index, &a_char);
	}
	else
	{
		index = Find_A_Char(&a_char, margv[0]);
		prfmsg(MSG926, a_char.name);
		a_char.suspended = 0;
		Write_A_Char(index, &a_char);
	}

	DONE;
}
/****************************************************************************
	talk to a monster
*/
short talk(void)
{
	short   m;
	short   absolute_match = 0;

	if (word1[0] == 0)
	{
		prfmsg(MSG939);
		BAD_EXIT;
	}

	m = find_monster(word1, which1, 1, &absolute_match);

	if (m < 0)
	{
		BAD_EXIT;
	}

	if (AMON->what == ANIMAL)
	{
		prfmsg(MSG940);
		BAD_EXIT;
	}

	Set_Mon_Name(name, m);
	sprintf(str, getmsg(MSG941), me.name, name);
	Message(str, LOUD_LOCAL);
	monster_talk(m);

	return (TRUE);
}
/****************************************************************************
	toggle an option
*/
short Set_Options(struct charstruct *guy)
{
	short   opt;

	opt = INUM(word1);

	if (opt < 1 || opt >= NUM_OPTS)
	{
		prfmsg(MSG943, opt);
		BAD_EXIT;
	}

	if (!globals->option7 && opt == 7)
	{
		prfmsg(MSG943, opt);
		BAD_EXIT;
	}

	if (!guy->Option[opt])
	{
		guy->Option[opt] = TRUE;
	}
	else
	{
		guy->Option[opt] = FALSE;
	}
		  
	return (opt);
}
/****************************************************************************
	prints user options
*/
void List_Options(struct charstruct *guy, short opt)
{

	OFF_ON(IGNORE_GLOBAL)
	prfmsg(MSG161);

	OFF_ON(SHORT_DESC)
	prfmsg(MSG162);

	OFF_ON(NO_SEND)
	prfmsg(M163);

	OFF_ON(NO_DANGER)
	prfmsg(MSG164);

	OFF_ON(NO_GUILD)
	prfmsg(MSG165);

	OFF_ON(HEALTH_STATUS)
	prfmsg(MSG1367);

	if (globals->option7)
	{
		OFF_ON(NO_POOBAH)
		prfmsg(MSG1289);
	}

	OFF_ON(ALL_BRING)
	prfmsg(MSG1315);

	OFF_ON(NO_TURF)
	prfmsg(MSG1325);

	OFF_ON(NO_SAY)
	prfmsg(MSG1326);

	OFF_ON(NO_COLOR)
	prfmsg(MSSG878);

	OFF_ON(NOVICE)
	prfmsg(MSG1362);

	OFF_ON(NO_AUTO_COMBAT)
	prfmsg(MSG1548);
}
/*******************************************************************************
	user has been offered some cash, see if he can carry it
*/
short cash_offered(short g, MLONG amt)
{
	MLONG   carrying;
	short   num_items;
	MLONG   carry_max;

	sprintf(str, getmsg(MSG952), me.name, amt);
	Message(str, g);
	sprintf(str, getmsg(MSG953), amt, AGUY->name);
	prf(str);
	Next_User(g);
	Calc_Weight(&num_items, &carrying, &carry_max);
	Previous_User();

	if (carrying + amt > carry_max)
	{
		prfmsg(MSG954, AGUY->name);
		strcpy(str, getmsg(MSSG955));
		Message(str, g);
		BAD_EXIT;
	}

	if ((double) AGUY->gold + (double) amt > GCMAXLONG)
	{
		BAD_EXIT;
	}
	
	if (!me.perm[SUPER_PERM])
	{
		me.gold -= amt;

		if (MY_PORT->my_bet > Money())
		{
			MY_PORT->my_bet = Money();
		}
	}

	prfmsg(MSG956, AGUY->name);
	AGUY->gold += amt;
	sprintf(str, getmsg(MSG957), me.name, AGUY->name, amt);
	Message(str, -(g + 1));
	return(TRUE);
}
/****************************************************************************
	user is looking for some tracks
*/
short Track(void)
{
	short   i;
	short   found_some = 0;

	if (ABUF(B)->rm.rmtype == BOAT || ABUF(B)->rm.rmtype == WATER_ROOM)
	{
		prfmsg(M958);
		BAD_EXIT;
	}

	for (i = 0; i != MAX_TRACKS; ++i)
	{
		if
		(
			globals->track_room[i] == ABUF(B)->rm.id &&
			globals->track_dir[i] <= NUM_EXITS &&
			(RANDOM(me.Int) != 1 || me.thief >= globals->ttrack)
		)
		{
			++found_some;

			prfmsg(MSG959);

			if (globals->track_dir[i] == NUM_EXITS)
			{
				prfmsg(MSG960);
				Special_Exit(0);
			}
			else
			{
				print_exit(globals->track_dir[i]);
				prf("!\r");
			}
		}
	}

	if (!found_some)
	{
		prfmsg(MSG961);
	}
	sprintf(str, getmsg(MSG962), me.name);
	Message(str, QUIET_LOCAL);
	DONE;
}
/****************************************************************************
	user wants to try to hide in the shadows
*/
short hide(void)
{
	short   success = 0;

	if (MY_PORT->hidden)
	{
		prfmsg(MSG963);
		BAD_EXIT;
	}

	if (ABUF(B)->rm.cover == 0)
	{
		success = FALSE;
	}
	else if (RANDOM(99) < ABUF(B)->rm.cover)
	{
		success = TRUE;
	}
	else if (me.thief >= globals->thide)
	{
		success = TRUE;
	}

	if (success)
	{
		prfmsg(MSG964);
		sprintf(str, getmsg(MSG965), me.name);
		Message(str, QUIET_LOCAL);
		MY_PORT->hidden = TRUE;
	}
	else
	{
		prfmsg(MSG966);
		sprintf(str, getmsg(MSG967), me.name);
		Message(str, QUIET_LOCAL);
	}

	DONE;
}
/****************************************************************************
	toggle ignore status
*/
short Ignore(void)
{
	short   p;

	if (word1[0] == 0)
	{
		prfmsg(MSG968A);
		BAD_EXIT;
	}

	p = find_remote_guy(word1);

	if (p <= 0)
	{
		BAD_EXIT;
	}

	MY_PORT->ignore[p] = abs(MY_PORT->ignore[p] - 1);

	if (MY_PORT->ignore[p])
	{
		prfmsg(MSG1488, APORT(p)->chr.name);
	}
	else
	{
		prfmsg(MSG1489, APORT(p)->chr.name);
	}

	DONE;
}
/****************************************************************************
	send messages between users
*/
short do_send(short which)
{
	short   j;
	short   i;
	short   g;
	short   send_to;
	short   text_start;
	short   saying = FALSE;
	char    start;

	if (MY_PORT->saying)
	{
		MY_PORT->saying = FALSE;
		saying = TRUE;
		text_start = 0;
	}
	else
	{
		text_start = 1;
	}

	if
	(
		margc > text_start &&
		command != YELL &&
		command != DO &&
		command != GSEND
	)
	{
		++text_start;

		if 
		(
			margv[text_start - 1][0] >= '0' && 
			margv[text_start - 1][0] <= '9'
		)
		{
			send_to = INUM(margv[text_start - 1]);
		
			if (send_to >= NTERMS)
			{
				send_to = -1;
			}
		}
		else
		{
			send_to = -1;

			for (i = 0; i != NTERMS; ++i)
			{
				if 
				(
					APORT(i)->status && 
					sameas(margv[text_start - 1], APORT(i)->chr.name)
				)
				{
					send_to = i;
				}
			}
		}

		if (send_to == -1)
		{
			if (which == WHISPERING)
			{
				prfmsg(M313);
				BAD_EXIT;
			}
			
			--text_start;
			send_to = which;

			if (command == GSEND)
			{
				start = 'G';
			}
			else
			{       
				start = 'P';
			}
		}
		else
		{
			start = '#';

			if (which == WHISPERING)
			{
				if (ABUF(B)->guy[send_to])
				{
					which = SAYING;
					command = SAY;
				}
				else
				{
					which = GLOBAL;
					command = SEND;
				}
			}
		}
	}
	else
	{
		text_start = 1;
		send_to = which;

		if (command == GSEND)
		{
			start = 'G';
		}
		else
		{
			start = 'P';
		}
	}

	globals->txt[0] = 0;
	for (i = text_start; i < margc; ++i)
	{
		if (strlen(globals->txt) + strlen(margv[i]) < 230)
		{
			strcat(globals->txt, margv[i]);
			if (i + 1 != margc)
			{
				strcat(globals->txt, " ");
			}
		}
	}

	if (globals->txt[0] == 0)
	{
		if (send_to == SAYING)
		{
			prfmsg(M315);
		}
		else if (command == YELL)
		{
			sprintf(str, getmsg(M316), me.name);
			Message(str, LOUD_LOCAL);
			yelled();
		}
		else
		{
			prfmsg(M317);
		}

		DONE;
	}
		
	if (command == BROADCAST)
	{
		strcpy(str, globals->txt);
	}
	else if (command == SAY && start == 'P')
	{
		sprintf(str, getmsg(MSG318), me.name, QUOTES, globals->txt, QUOTES);
	}
	else if (command == YELL)
	{
		sprintf(str, getmsg(M320), me.name, QUOTES, globals->txt, QUOTES);
	}
	else if (command == DO)
	{
		sprintf(str, getmsg(MSG321), me.name, globals->txt);
	}
	else if (command == GSEND)
	{
		sprintf
		(
			str,
			getmsg(MSG322A),
			start,
			P,
			me.name,
			QUOTES,
			globals->txt,
			QUOTES
		);
	}
	else
	{
		sprintf
		(
			str,
			getmsg(MSG322),
			start,
			P,
			me.name,
			QUOTES,
			globals->txt,
			QUOTES
		);
	}

	if (send_to == P)
	{
		prfmsg(M323);
		BAD_EXIT;
	}
	
	if (command == SAY && send_to != which && !ABUF(B)->guy[send_to])
	{
		prfmsg(M324);
		BAD_EXIT;
	}
	
	if (command == SAY && start != 'P')
	{
		sprintf(str, getmsg(MSG325), me.name, APORT(send_to)->chr.name);
		Message(str, -(send_to + 1));
			
		sprintf(str, getmsg(MSG326), me.name, QUOTES, globals->txt, QUOTES);
		Message(str, send_to);

		if (saying)
		{
			prfmsg(MSG1327);
		}

		DONE;
	}
	
	if (send_to == which || APORT(send_to)->status)
	{
		if (send_to != which && APORT(send_to)->ignore[P])
		{
			if (send_to)
			{
				prfmsg(M327A, APORT(send_to)->chr.name);
			}

			BAD_EXIT;
		}
		
		if (saying)
		{
			prfmsg(MSG1327);
		}

		Message(str, send_to);
		
		if (command == YELL)
		{
			for (g = 0; g != NTERMS; ++g)
			{
				if (APORT(g)->status)
				{
					if (AGUY->location == ABUF(B)->rm.spec_exit.leads_to)
					{
						Message(str, g);
					}

					for (j = 0; j != NUM_EXITS; ++j)
					{
						if (AGUY->location == ABUF(B)->rm.exit[j])
						{
							Message(str, g);
						}
					}
				}
			}
			yelled();
		}

		DONE;
	}
	
	if (send_to)
	{
		prfmsg(M328, send_to);
	}

	DONE;
}
/****************************************************************************
	user wants to leave the game
*/
short Quit(short option)
{
	short   i;
	MLONG   vote_mins;

	if (!me.perm[GAMEOP_PERM] || globals->sysfame)
	{
		Fame_Check();
	}

	if (option == 0)
	{
		if (!me.perm[GAMEOP_PERM] && !MY_PORT->can_quit)
		{
			prfmsg(M338);
			BAD_EXIT;
		}

		if (MY_PORT->limbo_return)
		{
			prfmsg(M339);
			BAD_EXIT;
		}

		if (ABUF(B)->rm.id == globals->prison && MY_PORT->fine)
		{
			prfmsg(M340);
			BAD_EXIT;
		}

		Set_Prompt(getmsg(MSG341), QUIT_PROMPT);
	}
	else
	{
		if (!sameas(margv[0], "y"))
		{
			BAD_EXIT;
		}

		for (i = 0; i != NUM_OFFICES; ++i)
		{
			vote_mins = MY_PORT->secs_on / 60;
			me.vote_mins[i] += (short) vote_mins;
		}

		No_Follow();
		move_me_to(0, CLEAR_OLD);
		Write_My_Rec(EXISTS);

		sprintf
		(
			str, 
			getmsg(MSG342), 
			P, 
			Brief_Userid(me.Userid), 
			me.name, 
			me.title
		);

		if (!me.perm[INVIS_PORT_PERM])
		{
			Message(str, GLOBAL);
		}

		sign_me_off();
	}
	DONE;
}
/****************************************************************************
	user is looking for hidden exits
*/
void Search(void)
{
	short   i;
	short   g;
	short   m;
	short   invis_t;
	short   see_invis_t;
	short   found_one = FALSE;

	for (i = 0; i != NUM_EXITS; ++i)
	{
		if (!ABUF(B)->visible[i] && ABUF(B)->rm.exit[i])
		{
			if (RANDOM(me.Int) != 1)
			{
				ABUF(B)->visible[i] = TRUE;

				if (!found_one)
				{
					prfmsg(MSG788);
				}
				else
				{
					prf(", ");
				}

				found_one = TRUE;
				print_exit(i);
			}
		}
	}

	if (found_one)
	{
		prf(".\r");
	}

	if 
	(
		ABUF(B)->rm.spec_exit.leads_to &&
		ABUF(B)->rm.spec_exit.type && 
		(!ABUF(B)->visible[NUM_EXITS])
	)
	{
		if (RANDOM(me.Int) != 1)
		{
			prfmsg(MSG789);
			Special_Exit(1);

			found_one = TRUE;
			ABUF(B)->visible[NUM_EXITS] = TRUE;
		}
	}

	see_invis_t = find_timer(SEE_INVIS_TIME, ME);

	for (g = 0; g != NTERMS; ++g)
	{
		if (ABUF(B)->guy[g] && g != P)
		{
			if (APORT(g)->hidden)
			{
				invis_t = find_timer(INVISIBLE_TIME, GUY);

				if (see_invis_t || !invis_t)
				{
					prfmsg(MSG790, AGUY->name);
					sprintf(str, getmsg(MSG969), me.name);
					Message(str, g);
					found_one = TRUE;
				}
			}
		}
	}

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what && AMON->hidden)
		{
			invis_t = find_timer(INVISIBLE_TIME, MON);

			if (see_invis_t || !invis_t)
			{
				Monster_Name(name, AMON->article, AMON->name);
				sprintf(str, getmsg(MSG1350), me.name, name);
				Message(str, LOUD_LOCAL);
				prfmsg(MSG1351, name);
				AMON->hidden = FALSE;
				AMON->action_timer = AMON->action_timer / 3;
				found_one = TRUE;
			}
		}
	}

	if (!found_one)
	{
		prfmsg(MSG970);
	}
}
/****************************************************************************
	user is trying to open a door through brute strength
*/
short Smash_Door(void)
{
	short   failed;
	short   dmg;
	struct  spec_exit_struct spec;

	if (word1[0] == 0)
	{
		prfmsg(MSG973);
		BAD_EXIT;
	}

	spec = ABUF(B)->rm.spec_exit;

	if (spec.type < DOOR || spec.leads_to == 0)
	{
		prfmsg(MSG974, me.name);
		BAD_EXIT;
	}

	if (!sameto(word1, spec.descriptor))
	{
		prfmsg(M542, word1);
		BAD_EXIT;
	}

	if (!spec.locked)
	{
		prfmsg(MSG975, me.name);
		BAD_EXIT;
	}

	if (spec.type != DOOR)
	{
		failed = TRUE;
	}
	else
	{
		failed = FALSE;
	}

	dmg = RANDOM(me.dpts);
	me.damaged += dmg;

	prfmsg(MSG976, dmg);
	sprintf(str, getmsg(MSG977), me.name);
	cat_spec_ex(str);
	Message(str, LOUD_LOCAL);

	if (me.damaged > me.dpts)
	{
		sprintf(str, getmsg(MSG978), me.name, me.title);
		cat_spec_ex(str);
		Message(str, GLOBAL);
		Got_Killed(USER_DEATH);
	}
	else if (!failed)
	{
		prfmsg(MSG979);
		sprintf(str, getmsg(MSG980), me.name);
		cat_spec_ex(str);
		Message(str, LOUD_LOCAL);
		ABUF(B)->rm.spec_exit.locked = FALSE;
	}

	return (TRUE);
}
/****************************************************************************
	user wants to take a break
*/
short limbo(void)
{
	short   m;
		
	if (ABUF(B)->rm.id == globals->prison && MY_PORT->fine)
	{
		prfmsg(MSG1293);
		BAD_EXIT;
	}

	if (MY_PORT->limbo_return)
	{
		prfmsg(MSG981);
		BAD_EXIT;
	}

	if (ABUF(B)->rm.rmtype == CLOSET)
	{
		prfmsg(MSG982);
		BAD_EXIT;
	}

	if (!me.perm[GAMEOP_PERM] && !MY_PORT->can_quit)
	{
		prfmsg(MSSG983);
		BAD_EXIT;
	}

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (ABUF(B)->mon[m].what && !ABUF(B)->mon[m].hidden)
		{
			prfmsg(MSG1345);
			BAD_EXIT;
		}
	}

	for (m = 0; m != NTERMS; ++m)
	{
		if (MY_PORT->follower[m])
		{
			if (ABUF(B)->guy[m])
			{
				prfmsg(MSG1371);
				BAD_EXIT;
			}
		}
	}

	No_Follow();
	sprintf(str, getmsg(MSG984), me.name);
	Message(str, QUIET_LOCAL);
	MY_PORT->limbo_return = me.location;
	me.location = globals->limboloc;
	move_me_to(globals->limboloc, CLEAR_OLD);
	DONE;
}
/****************************************************************************
	user wants to place an arena bet
*/
short EXPORT Arena_Bet(void)
{
	MLONG   bet;

	bet = LNUM(word1);

	if (bet > Money() && !me.perm[SUPER_PERM])
	{
		bet = Money();
	}

	if (bet == 0 && Money() >= 1)
	{
		bet = 1;
	}

	sprintf(str, getmsg(MSG1484), bet);
	prf(str);
	MY_PORT->my_bet = bet;
	DONE;
}
