#include <header.h>
#include <globals.h>

/****************************************************************************
	see if user is continuing or starting an attack, if starting tell everyone
	about it
*/
short EXPORT Perform_Attack(short g, short m)
{
	short   t;
	short   asleep = FALSE;
	short   my_factor = me.Dex;
	short   his_factor;
	short   invis_t;
	short   see_invis_t;
	short   stealth;
	short   helpless = FALSE;

	if (command != CAST && command != USE)
	{
		Fatigue(ADD);
	}

	if (m >= 0)
	{
		his_factor = AMON->Dex;
		
		if (SAFE_AREA && !me.perm[GAMEOP_PERM])
		{
			prfmsg(MSG255);
			return (TRUE);
		}

		if (AMON->summoned_by != -1 && AMON->summoned_by != MY_PORT->index)
		{
			AMON->summoned_by = -1;
		}

		if (AMON->attacked_vector == MORPH)
		{
			if (Morphed(m, P))
			{
				Start_Mon_Name(name, m);
				prfmsg(MSG1305, name, AMON->Level);
			}
		}

		for (t = 0; t != NUM_MON_TIMERS; ++t)
		{
			if (AMON->misc_type[t] == SLEEP_TIME)
			{
				asleep = TRUE;

				if (RANDOM(globals->wakeup) == 1)
				{
					AMON->timer[t] = 1;
				}
			}
		}

		if (AMON->sees[P] || command == DRAG)
		{
			AMON->last_attacker = P;
		}

		if (MY_PORT->enemy_mon != m)
		{
			Set_Mon_Name(name, m);

			if (command != DRAG)
			{
				MY_PORT->enemy_mon = m;

				if (command != CAST && command != USE)
				{
					sprintf(str, getmsg(MSG52), me.name, name);
					Message(str, LOUD_LOCAL);
				}
			}

			if (AMON->action_timer == 0 && !AMON->bashed && !asleep)
			{
				if (MY_PORT->hidden)
				{
					my_factor = my_factor * 2;
				}

				invis_t = find_timer(INVISIBLE_TIME, ME);

				if (me.thief >= globals->tstealth)
				{
					stealth = TRUE;
				}
				else
				{
					stealth = find_timer(STEALTH_TIME, ME);
				}

				see_invis_t = find_timer(SEE_INVIS_TIME, MON);

				if ((invis_t && !see_invis_t) || stealth)
				{
					my_factor = my_factor * 2;
				}

				if (AMON->what == AWESOME)
				{
					his_factor = his_factor * 2;
				}

				if
				(
					RANDOM(my_factor) < RANDOM(his_factor) &&
					!me.perm[KILLER_PERM]
				)
				{
					if (!AMON->sees[P])
					{
						Reveal_Me(m);
						if (!AMON->sees[P])
						{
							return (FALSE);
						}
					}

					AMON->last_attacker = P;
					name[0] = toupper(name[0]);
					prfmsg(MSG557, name);
					return (TRUE);
				}
			}
		}
	}
	else
	{
		if 
		(
			find_timer(KO_TIME, GUY) ||
			find_timer(SLEEP_TIME, GUY) ||
			find_timer(MES_TIME, GUY) ||
			APORT(g)->bashed
		)
		{
			helpless = TRUE;
		}

		if (command != DRAG || !helpless)
		{
			sprintf(str, getmsg(MSG53), me.name);
			Message(str, g);
			sprintf(str, getmsg(MSG52), me.name, AGUY->name);
			Message(str, -(g + 1));
		}
	}

	return (FALSE);
}
/****************************************************************************
	user wants to attack something
*/
short EXPORT attack(short get_word)
{
	short   i;
	short   m;
	short   invis_t;
	short   see_invis_t;
	short   absolute_match = 0;
	char    what[LINE_LEN];
	short   monster_is_gone;

	if (get_word && word1[0])
	{
		strcpy(what, word1);
	}
	else
	{
		what[0] = 0;
	}

	if (what[0] == 0 && MY_PORT->enemy_mon == -1)
	{
		for (m = 0; m != MAX_ROOM_MON; ++m)
		{
			if (AMON->what && AMON->last_attacker == P)
			{
				MY_PORT->enemy_mon = m;
			}
		}

		if (MY_PORT->enemy_mon == -1)
		{
			prfmsg(M405);
			BAD_EXIT;
		}
	}

	if (what[0])
	{
		i = find_guy(what, 0, &absolute_match);
		m = find_monster(what, which1, 0, &absolute_match);
	}
	else
	{
		i = -1;
		m = MY_PORT->enemy_mon;
	}

	if ((i == NOT_UNIQUE || m == NOT_UNIQUE) && absolute_match == 0)
	{
		prfmsg(M167, what);
		BAD_EXIT;
	}

	if (i == NOT_FOUND && m == NOT_FOUND)
	{
		prfmsg(M168, what);
		BAD_EXIT;
	}

	if (i >= 0 && m >= 0 && absolute_match == 0)
	{
		prfmsg(M167, what);
		BAD_EXIT;
	}

	if (m == NOT_THAT_MANY)
	{
		prfmsg(M169, what);
		BAD_EXIT;
	}

	if (i == P && (m < 0 || absolute_match == ABS_GUY))
	{
		prfmsg(M406);
		BAD_EXIT;
	}

	if (!action_ok())
	{
		BAD_EXIT;
	}

	if (!Fatigue(NEEDED))
	{
		prfmsg(M407);
		BAD_EXIT;
	}

	MY_PORT->next_hit = NORMAL;

	if (m >= 0 && absolute_match != ABS_GUY)
	{
		if (command == BASH)
		{
			if (find_timer(FLOAT_TIME, ME))
			{
				prfmsg(M408);
				BAD_EXIT;
			}

			monster_is_gone = Bash_Mon(m);
		}
		else
		{
			monster_is_gone = Attack_Mon(m);
		}

		if (!monster_is_gone)
		{
			Vector_Check(m);
		}
	}
	else
	{
		invis_t = find_timer(INVISIBLE_TIME, i, -1);
		see_invis_t = find_timer(SEE_INVIS_TIME, ME);

		if (invis_t && !see_invis_t)
		{
			prfmsg(M168, what);
			BAD_EXIT;
		}

		if (!Can_Attack_Guy(i))
		{
			BAD_EXIT;
		}

		if (command == BASH)
		{
			if (find_timer(FLOAT_TIME, ME))
			{
				prfmsg(M408);
				BAD_EXIT;
			}

			Bash_Guy(i);
		}
		else
		{
			Attack_Guy(i);
		}
	}

	return (TRUE);
}
/****************************************************************************
	user wants to drag someone or something into another room
*/
short EXPORT Drag(void)
{
	short   g;
	short   m;
	short   dir;
	short   invis_t;
	short   see_invis_t;
	short   absolute_match = 0;
	char    what[LINE_LEN];

	if (word1[0])
	{
		strcpy(what, word1);
	}
	else
	{
		what[0] = 0;
	}

	if (what[0] == 0 && MY_PORT->enemy_mon == -1)
	{
		prfmsg(MSG1538);
		BAD_EXIT;
	}

	if (what[0])
	{
		g = find_guy(what, 0, &absolute_match);
		m = find_monster(what, which1, 0, &absolute_match);
	}
	else
	{
		g = -1;
		m = MY_PORT->enemy_mon;
	}

	if ((g == NOT_UNIQUE || m == NOT_UNIQUE) && absolute_match == 0)
	{
		prfmsg(M167, what);
		BAD_EXIT;
	}

	if (g == NOT_FOUND && m == NOT_FOUND)
	{
		prfmsg(M168, what);
		BAD_EXIT;
	}

	if (g >= 0 && m >= 0 && absolute_match == 0)
	{
		prfmsg(M167, what);
		BAD_EXIT;
	}

	if (m == NOT_THAT_MANY)
	{
		prfmsg(M169, what);
		BAD_EXIT;
	}

	if (g == P && (m < 0 || absolute_match == ABS_GUY))
	{
		prfmsg(M406);
		BAD_EXIT;
	}

	if (!action_ok())
	{
		BAD_EXIT;
	}

	if (!Fatigue(NEEDED))
	{
		prfmsg(M407);
		BAD_EXIT;
	}

	if (word2[0] == 0)
	{
		prfmsg(MSG1539);
		BAD_EXIT;
	}
	
	if (sameto(word2, "north"))
	{
		dir = NORTH;
	}
	else if (sameto(word2, "south"))
	{
		dir = SOUTH;
	}
	else if (sameto(word2, "east"))
	{
		dir = EAST;
	}
	else if (sameto(word2, "west"))
	{
		dir = WEST;
	}
	else if (sameto(word2, "up"))
	{
		dir = UP;
	}
	else if (sameto(word2, "down"))
	{
		dir = DOWN;
	}
	else if (sameto(word2, "out"))
	{
		dir = OUT;
	}
	else if 
	(
		ABUF(B)->rm.spec_exit.type != 0 &&
		ABUF(B)->rm.spec_exit.leads_to != 0 &&
		(
			sameto(word2, ABUF(B)->rm.spec_exit.descriptor) ||
			sameto(word2, ABUF(B)->rm.spec_exit.adjective)
		)
	)
	{
		dir = GO;
	}
	else
	{
		prfmsg(MSG1540, word2);
		BAD_EXIT;
	}

	setmem(MY_PORT->str, 30, 0);

	if (dir != GO)
	{
		if (ABUF(B)->rm.exit[dir - NORTH] == 0)
		{
			prfmsg(M527);
			BAD_EXIT;
		}

		strcpy(MY_PORT->str, commands[dir]);
		strcat(MY_PORT->str, "!");
	}
	else
	{
		if 
		(
			ABUF(B)->rm.spec_exit.type == CHANT_DOOR &&
			ABUF(B)->rm.spec_exit.locked
		)   
		{
			prfmsg(MSG883);
			BAD_EXIT;
		}

		if 
		(
			ABUF(B)->rm.spec_exit.type == SPECIAL_DOOR &&
			ABUF(B)->rm.spec_exit.locked
		)   
		{
			prfmsg(MSG883);
			BAD_EXIT;
		}

		if (ABUF(B)->rm.spec_exit.locked && !Find_Ring(PASS_DOOR, ME))
		{
			if (ABUF(B)->rm.spec_exit.type == DOOR)
			{
				if (me.thief < globals->tlock)
				{
					prfmsg(MSG883);
					BAD_EXIT;
				}
			}
			else if (ABUF(B)->rm.spec_exit.type == MAGIC_DOOR)
			{
				if 
				(
					me.thief < globals->tlock ||
					me.class != THIEF
				)
				{
					prfmsg(MSG883);
					BAD_EXIT;
				}
			}
		}

		strcpy(MY_PORT->str, "to ");
		cat_spec_ex(MY_PORT->str);
	}

	MY_PORT->next_hit = NORMAL;

	if (m >= 0 && absolute_match != ABS_GUY)
	{
		if (find_timer(FLOAT_TIME, ME))
		{
			prfmsg(M408);
			BAD_EXIT;
		}

		Drag_Mon(m, dir);
	}
	else
	{
		if (APORT(g)->limbo_return)
		{
			prfmsg(MSG1298, AGUY->name);
			BAD_EXIT;
		}

		invis_t = find_timer(INVISIBLE_TIME, GUY);
		see_invis_t = find_timer(SEE_INVIS_TIME, ME);

		if (invis_t && !see_invis_t)
		{
			prfmsg(M168, what);
			BAD_EXIT;
		}

		if
		(
			!find_timer(KO_TIME, GUY) &&
			!find_timer(SLEEP_TIME, GUY) &&
			!find_timer(MES_TIME, GUY) &&
			!APORT(g)->bashed
		)
		{
			if (!Can_Attack_Guy(g))
			{
				BAD_EXIT;
			}
		}

		if (find_timer(FLOAT_TIME, ME))
		{
			prfmsg(M408);
			BAD_EXIT;
		}

		Drag_Guy(g, dir);
	}

	return (TRUE);
}
/****************************************************************************
	see if anything weird happens when we attack this monster
*/
short Vector_Check(short m)
{

	if (AMON->attacked_vector == JAILED)
	{
		Jailed(m);
		return (TRUE);
	}

	return (FALSE);
}
/****************************************************************************
	compute attack die rolls
*/
short Roll_Dice(short g, short m, short bonus)
{
	short   roll;
	short   invis_t, see_invis_t;
	MLONG   bonus_roll;
	
	if (me.class == DUELIST)
	{
		bonus_roll = ((MLONG) bonus * globals->duebonus) / 10L;
		roll = (short) bonus_roll;
	}
	else
	{
		roll = 0;
	}

	roll += RANDOM(40) + bonus;

	if (command == GREATBLOW)
	{
		prfmsg(MSG410);
		MY_PORT->next_hit = VULNERABLE;
	}
	else if (command == PARRY)
	{
		prfmsg(MSG411);
		MY_PORT->next_hit = PARRIED;
	}

	invis_t = find_timer(INVISIBLE_TIME, ME);

	if (invis_t)
	{
		if (g >= 0)
		{
			see_invis_t = find_timer(SEE_INVIS_TIME, GUY);
		}
		else
		{
			see_invis_t = find_timer(SEE_INVIS_TIME, MON);
		}

		if (see_invis_t)
		{
			roll -= 5;
		}
	}

	if (m >= 0 && !AMON->sees[P])
	{
		roll += 20;
		if (me.class == THIEF)
		{
			roll += 9999;
		}
	}

	return (roll);
}
/****************************************************************************
	user scored a hit, take care of some business
*/
short Entropy(void)
{
	short   hits;

	if (command == GREATBLOW)
	{
		hits = 2;
	}
	else
	{
		hits = 1;
	}

	if (me.rw >= 0 && !me.item[me.rw].infinite_uses)
	{
		me.item[me.rw].uses -= hits;

		if (me.item[me.rw].uses <= 0)
		{
			prfmsg(MSG90, me.item[me.rw].name);
			Lose_Item(me.rw);
		}
		else if (me.item[me.rw].uses == 10)
		{
			prfmsg(M91, me.item[me.rw].name);
		}
		else if (me.item[me.rw].uses < 10)
		{
			prfmsg(M92, me.item[me.rw].name);
		}
	}

	if (me.lw >= 0 && !me.item[me.lw].infinite_uses)
	{
		me.item[me.lw].uses -= hits;

		if (me.item[me.lw].uses <= 0)
		{
			prfmsg(MSG90, me.item[me.lw].name);
			Lose_Item(me.lw);
		}
		else if (me.item[me.lw].uses == 10)
		{
			prfmsg(M91, me.item[me.lw].name);
		}
		else if (me.item[me.lw].uses < 10)
		{
			prfmsg(M92, me.item[me.lw].name);
		}
	}

	DONE;
}
/****************************************************************************
	figure a monster's armor class
*/
short Calc_Mon_AC(short m, short option)
{
	short   his_ac = (short) (AMON->dpts / 100);
	short   invis_t;
	short   see_invis_t;
	short   i;

	invis_t     = find_timer(INVISIBLE_TIME, MON);
	see_invis_t = find_timer(SEE_INVIS_TIME, ME);

	if (AMON->what == NPC)
	{
		his_ac += 0;
	}
	else if
	(
		AMON->what == MONSTER ||
		AMON->what == WEIRD ||
		AMON->what == LONER ||
		AMON->what == ORACLE ||
		AMON->what == HUNTRESS
	)
	{
		his_ac += AMON->Level;
	}
	else if (AMON->what == ANIMAL)
	{
		his_ac += AMON->Level / 2;
	}
	else if (AMON->what == HUMANOID)
	{
		his_ac += AMON->Level / 3;
	}
	else if (AMON->what == AWESOME)
	{
		his_ac += AMON->Level * 2;
	}

	for (i = 0; i != MAX_MON_ITEM; ++i)
	{
		if (AMON->item_used[i])
		{
			if (ARSH(AMON->item_has[i]))
			{
				his_ac += AMON->item_has[i].bonus;
				his_ac += AMON->item_has[i].ac;
			}
		}
	}

	if (option == FULL_AC)
	{
		if (find_timer(INVULNERABLE_TIME, MON))
		{
			his_ac += INVULNERABLE_BONUS;
		}
	
		if (invis_t && !see_invis_t)
		{
			his_ac += 5;
		}

		if (AMON->next_hit == PARRIED)
		{
			his_ac += 10;
		}
		else if (AMON->next_hit == VULNERABLE)
		{
			his_ac -= 20;
		}
	}

	if (his_ac < 0)
	{
		his_ac = 0;
	}

	return (his_ac);
}
/****************************************************************************
	see if user flubbed
*/
short Flubbed(void)
{
	short   what;
	short   roll;
	short   factor;
	short   floating = find_timer(FLOAT_TIME, ME);

	factor = me.Dex;

	if (me.lw >= 0 && me.rw >= 0)
	{
		factor += me.two_wep;
	}
	else if ((me.lw >= 0) || (me.rw >= 0) && me.shld >= 0)
	{
		if (me.shield < 0)
		{
			factor += me.shield;
		}
	}
	else if ((me.lw >= 0) || (me.rw >= 0) && me.focus >= 0)
	{
		factor += me.two_wep;
	}

	if (factor < 1)
	{
		factor = 1;
	}

	if (RANDOM(factor * globals->flubfctr) != 1 || me.perm[SUPER_PERM])
	{
		BAD_EXIT;
	}

	roll = RANDOM(200);

	if (roll < 25)
	{
		what = me.lw;
	}
	else if (roll < 50)
	{
		what = me.rw;
	}
	else if (roll < 75)
	{
		what = me.shld;
	}
	else if (roll < 99)
	{
		what = me.focus;
	}
	else if (roll < 180 || floating)
	{
		if (floating)
		{
			prfmsg(MSG412);
		}
		else
		{
			prfmsg(MSG413);
		}

		sprintf(str, getmsg(MSG414), me.name);
		Message(str, LOUD_LOCAL);

		MY_PORT->action_timer = 5;
		return (TRUE);
	}
	else
	{
		prfmsg(MSG415);
		MY_PORT->action_timer = 10;
		MY_PORT->bashed_time = 10;
		MY_PORT->bashed = TRUE;

		sprintf(str, getmsg(MSG416), me.name);
		Message(str, LOUD_LOCAL);

		return (TRUE);
	}

	if (what < 0)
	{
		if (floating)
		{
			prfmsg(MSG412);
		}
		else
		{
			prfmsg(MSG417);
		}

		sprintf(str, getmsg(MSG418), me.name);
		Message(str, LOUD_LOCAL);

		MY_PORT->action_timer = 10;
		return (TRUE);
	}
	
	if (me.item[what].what != NOHAND)
	{
		if (what == me.shld && me.item[what].which == NODROP)
		{
			prfmsg(MSG419, me.item[what].name);
			BAD_EXIT;
		}

		Put_In_Room(&me.item[what]);
		prfmsg(MSG420, me.item[what].name);
		sprintf(str, getmsg(MSG421), me.name);
		Cat_Item(str, &me.item[what]);
		Message(str, LOUD_LOCAL);
		Lose_Item(what);
		return (TRUE);
	}

	if (floating)
	{
		prfmsg(MSG422);
	}
	else
	{
		prfmsg(MSG423);
	}

	MY_PORT->action_timer = 10;

	sprintf(str, getmsg(MSG414), me.name);
	Message(str, LOUD_LOCAL);
	return (TRUE);
}
/****************************************************************************
	instilled weapons do their damage
*/
short Instilled_Weapons(short g, short m, short i, short first_hit)
{
	short   tal_index;
	short   addevil;
	MLONG   e;
	short   s;
	short   dodged;
	short   dur;
	short   my_level;
	MLONG   dmg;
	char    what[80];

	if (!me.item[i].ring_used || ABUF(B)->rm.rmtype == NO_MAGIC)
	{
		BAD_EXIT;
	}

	s = me.item[i].spell_cast;
	dur = spell_info[s].dur;
		
	if (s == CURSE)
	{
		dur = 1;
	}

	if (me.class == SORCERER)
	{
		dur = (dur * globals->sorbonus) / 10;
	}
	else if (me.class == MYSTIC)
	{
		dur = (dur * globals->mysbonus) / 10;
	}

	if (m >= 0)
	{
		dodged = Dodged(MON, TRUE, s);

		if (dodged && dodged != PARTIAL_DODGE)
		{
			BAD_EXIT;
		}
		else if (!dodged)
		{
			dodged = 1;
		}
	}
	else if (g >= 0)
	{
		dodged = Dodged(GUY, TRUE, s);

		if (dodged && dodged != PARTIAL_DODGE)
		{
			BAD_EXIT;
		}
		else if (!dodged)
		{
			dodged = 1;
		}
	}

	if (s == LANGOUR)
	{
		dur += me.item[i].item_level;

		if (g >= 0)
		{
			prfmsg(MSG424, AGUY->name);
			strcpy(str, getmsg(MSG70));
			Message(str, g);
			Make_A_Timer(SLOW_TIME, dur / dodged, GUY, RESET);
		}
		else if (m >= 0)
		{
			prfmsg(MSG424, name);
			Make_A_Timer(SLOW_TIME, dur / dodged, MON, RESET);
		}
	}
	else if (s == MESMERIZE)
	{
		dur += me.item[i].item_level;

		if (g >= 0)
		{
			prfmsg(MSG426, AGUY->name);
			strcpy(str, getmsg(MSG73));
			Message(str, g);
			if (APORT(g)->action_timer < dur / dodged)
			{
				APORT(g)->action_timer = dur / dodged;
			}
		}
		else if (m >= 0)
		{
			prfmsg(MSG426, name);

			if (AMON->action_timer < dur / dodged)
			{
				AMON->action_timer = dur / dodged;
				Make_A_Timer(MES_TIME, dur / dodged, MON, RESET);
			}
		}
	}
	else if (s == LIGHTNING || s == BLAST || s == FIREBALL)
	{
		my_level = me.item[i].item_level;
		dmg = (MLONG) my_level * (MLONG) dur;
		dmg += RANDOM(my_level);
		dmg = dmg / (MLONG) dodged;

		if (dmg < 1)
		{
			dmg = 1;
		}
		
		if (me.class == SORCERER)
		{
			dmg = (dmg * globals->sordmg) / 10;
		}
		else if (me.class == MYSTIC)
		{
			dmg = (dmg * globals->mysdmg) / 10;
		}

		if (g >= 0)
		{
			if (dmg > AGUY->dpts && !me.perm[KILLER_PERM])
			{
				dmg = AGUY->dpts;
			}

			if (dmg > AGUY->dpts - AGUY->damaged)
			{
				dmg = (AGUY->dpts - AGUY->damaged) + 1;
			}

			sprintf(str, getmsg(MSSG428), me.name, dmg);
			Message(str, g);
			AGUY->damaged += (short) dmg;
			sprintf(str, getmsg(MSSG429), AGUY->name, dmg);
			prf(str);
		}
		else if (m >= 0)
		{
			if (!first_hit || dmg <= AMON->dpts - AMON->damage)
			{
				Set_Mon_Name(name, m);
				AMON->damage += dmg;
				sprintf(str, getmsg(MSSG429), name, dmg);
				prf(str);
			}
		}
	}
	else if (s == EXHAUSTION)
	{
		my_level = me.item[i].item_level;
		dmg = (MLONG) my_level * (MLONG) dur;
		dmg += RANDOM(my_level);
		dmg = dmg / (MLONG) dodged;

		if (dmg < 1)
		{
			dmg = 1;
		}
		
		if (me.class == SORCERER)
		{
			dmg = (dmg * globals->sordmg) / 10;
		}
		else if (me.class == MYSTIC)
		{
			dmg = (dmg * globals->mysdmg) / 10;
		}

		if (g >= 0)
		{
			if (dmg > AGUY->dpts - AGUY->ftg)
			{
				dmg = (AGUY->dpts - AGUY->ftg) + 1;
			}

			sprintf(str, getmsg(MSSG1332), me.name, dmg);
			Message(str, g);
			AGUY->ftg += (short) dmg;
			sprintf(str, getmsg(MSSG1333), dmg, AGUY->name);
			prf(str);
		}
		else if (m >= 0)
		{
			Set_Mon_Name(name, m);
			AMON->Tired += dmg;
			sprintf(str, getmsg(MSSG1333), dmg, name);
			prf(str);
		}
	}
	else if (s == WEAKNESS)
	{
		dur += me.item[i].item_level;

		if (g >= 0)
		{
			prfmsg(MSG430, AGUY->name);
			strcpy(str, getmsg(MSG71));
			Message(str, g);
			Make_A_Timer(WEAK_TIME, dur / dodged, GUY, RESET);
		}
		else if (m >= 0)
		{
			prfmsg(MSG430, name);
			Make_A_Timer(WEAK_TIME, dur / dodged, MON, RESET);
		}
	}
	else if (s == DISPEL_MAGIC)
	{
		Dispel_Magic(g, m, FALSE, dodged);
	}
	else if (s == CURSE && TYPE != ARENA)
	{
		if (g >= 0)
		{   
			for (i = 0, tal_index = -1; i != NUM_ITEMS; ++i)
			{
				if (AGUY->item[i].what == TALISMAN)
				{
					tal_index = i;
				}
			}

			if (tal_index != -1)
			{
				prfmsg
				(
					MSG1310, 
					AGUY->name, 
					AGUY->item[tal_index].article,
					AGUY->item[tal_index].name
				);
				sprintf(str, getmsg(MSG1091), AGUY->item[tal_index].name);
				Message(str, g);

				addevil = numopt(ADDEVIL, -32767, 32767);
				if (addevil)
				{
					prfmsg(M409, addevil);
					me.evil += addevil;
				}

				Next_User(g);
				Lose_Item(tal_index);
				Previous_User();
				DONE;
			}
		}

		i = RANDOM(5);

		if (i == 1)
		{
			strcpy(what, "less intelligent!");

			if (g >= 0)
			{
				if (AGUY->Int > dur)
				{
					AGUY->Int -= dur;

					e = Calc_Exp_Needed(AGUY->Int, FALSE);

					if (AGUY->int_exp > e)
					{
						AGUY->int_exp = e;
					}
				}
			}
			else
			{
				if (AMON->Int > dur)
				{
					AMON->Int -= dur;
				}
			}
		}
		else if (i == 2)
		{
			strcpy(what, "weaker!");
			if (g >= 0)
			{
				if (AGUY->Str > dur)
				{
					AGUY->Str -= dur;

					e = Calc_Exp_Needed(AGUY->Str, FALSE);

					if (AGUY->str_exp > e)
					{
						AGUY->str_exp = e;
					}
				}
			}
			else
			{
				if (AMON->Str > dur)
				{
					AMON->Str -= dur;
				}
			}
		}
		else if (i == 3)
		{
			strcpy(what, "less cosmic!");
			if (g >= 0)
			{
				if (AGUY->Psy > dur)
				{
					AGUY->Psy -= dur;

					e = Calc_Exp_Needed(AGUY->Psy, FALSE);

					if (AGUY->psy_exp > e)
					{
						AGUY->psy_exp = e;
					}

					Set_Guy_Points
					(
						&AGUY->dpts,
						&AGUY->mpts,
						AGUY->Str,
						AGUY->Con,
						AGUY->Psy,
						AGUY->class
					);
				}
			}
			else
			{
				if (AMON->Psy > dur)
				{
					AMON->Psy -= dur;

					Set_Mon_Points
					(
						&AMON->dpts,
						&AMON->mpts,
						AMON->Str,
						AMON->Con,
						AMON->Psy
					);

					if (bp_mons)
					{
						AMON->dpts = (AMON->dpts * 2L) / 3L;
					}
				}
			}
		}
		else if (i == 4)
		{
			strcpy(what, "clumsier!");
			if (g >= 0)
			{
				if (AGUY->Dex > dur)
				{
					AGUY->Dex -= dur;

					e = Calc_Exp_Needed(AGUY->Dex, FALSE);

					if (AGUY->dex_exp > e)
					{
						AGUY->dex_exp = e;
					}
				}
			}
			else
			{
				if (AMON->Dex > dur)
				{
					AMON->Dex -= dur;
				}
			}
		}
		else if (i == 5)
		{
			strcpy(what, "less sturdy!");
			if (g >= 0)
			{
				if (AGUY->Con > dur)
				{
					AGUY->Con -= dur;

					e = Calc_Exp_Needed(AGUY->Con, FALSE);

					if (AGUY->con_exp > e)
					{
						AGUY->con_exp = e;
					}

					Set_Guy_Points
					(
						&AGUY->dpts,
						&AGUY->mpts,
						AGUY->Str,
						AGUY->Con,
						AGUY->Psy,
						AGUY->class
					);
				}
			}
			else
			{
				if (AMON->Con > dur)
				{
					AMON->Con -= dur;

					Set_Mon_Points
					(
						&AMON->dpts,
						&AMON->mpts,
						AMON->Str,
						AMON->Con,
						AMON->Psy
					);

					if (bp_mons)
					{
						AMON->dpts = (AMON->dpts * 2L) / 3L;
					}
				}
			}
		}

		if (g >= 0)
		{
			prfmsg(MSG435, AGUY->name, what);
			sprintf(str, getmsg(MSG436), what);
			Message(str, g);
				
			addevil = numopt(ADDEVIL, -32767, 32767);
			if (addevil)
			{
				prfmsg(M409, addevil);
				me.evil += addevil;
			}
		}
		else if (m >= 0)
		{
			prfmsg(MSG435, name, what);
		}
	}

	DONE;
}
/****************************************************************************
	instilled weapons do their damage
*/
short Instilled_Monster_Weapons(short g, short m, short i, short first_hit)
{
	short   tal_index;
	MLONG   e;
	short   s;
	short   dodged;
	short   dur;
	short   my_level;
	MLONG   dmg;

	if (!AMON->item_has[i].ring_used)
	{
		BAD_EXIT;
	}

	s = AMON->item_has[i].spell_cast;
	dur = spell_info[s].dur;
		
	if (s == CURSE)
	{
		dur = 1;
	}

	if (AMON->spell_caster)
	{
		dur = (dur * 15) / 10;
	}

	dodged = Guy_Dodged(g, m, s, TRUE); 

	if (dodged && dodged != PARTIAL_DODGE)
	{
		BAD_EXIT;
	}
	else if (!dodged)
	{
		dodged = 1;
	}

	if (s == LANGOUR)
	{
		dur += AMON->item_has[i].item_level;
		prfmsg(MSG70);
		Server_Message(g);
		Make_A_Timer(SLOW_TIME, dur / dodged, GUY, RESET);
	}
	else if (s == MESMERIZE)
	{
		dur += AMON->item_has[i].item_level;
		
		prfmsg(MSG73);
		Server_Message(g);

		if (APORT(g)->action_timer < dur / dodged)
		{
			APORT(g)->action_timer = dur / dodged;
		}

		Make_A_Timer(MES_TIME, APORT(g)->action_timer, GUY, RESET);
	}
	else if (s == LIGHTNING || s == BLAST || s == FIREBALL)
	{
		my_level = AMON->item_has[i].item_level;
		dmg = (MLONG) my_level * (MLONG) dur;
		dmg += RANDOM(my_level);
		dmg = dmg / (MLONG) dodged;

		if (dmg < 1)
		{
			dmg = 1;
		}
		
		if (AMON->spell_caster)
		{
			dmg = dmg * 2;
		}
		
		if (dmg > AGUY->dpts && AGUY->dpts > 4 && !AGUY->damaged)
		{
			if (!AMON->permanant || AMON->which == globals->rover)
			{
				dmg = AGUY->dpts;
			}
		}

		if (dmg > AGUY->dpts - AGUY->damaged)
		{
			dmg = (AGUY->dpts - AGUY->damaged) + 1;
		}
		else if (dmg < 1)
		{
			dmg = 1;
		}

		if (!first_hit || dmg <= AGUY->dpts - AGUY->damaged)
		{
			AGUY->damaged += (short) dmg;
			AMON->I_hit[g] = TRUE;

			prfmsg(MSG1375, (short) dmg, AGUY->dpts - AGUY->damaged);
			Server_Message(g);
		
			if (AGUY->shld >= 0)
			{
				Armor_Entropy(g, AGUY->shld);
			}

			if (AGUY->armor >= 0)
			{
				Armor_Entropy(g, AGUY->armor);
			}
		}
	}
	else if (s == EXHAUSTION)
	{
		my_level = AMON->item_has[i].item_level;
		dmg = (MLONG) my_level * (MLONG) dur;
		dmg += RANDOM(my_level);
		dmg = dmg / (MLONG) dodged;

		if (dmg < 1)
		{
			dmg = 1;
		}
		
		if (AMON->spell_caster)
		{
			dmg = dmg * 2;
		}

		if (dmg > AGUY->dpts - AGUY->ftg)
		{
			dmg = (AGUY->dpts - AGUY->ftg) + 1;
		}
		else if (dmg < 1)
		{
			dmg = 1;
		}

		AGUY->ftg += (short) dmg;
		AMON->I_hit[g] = TRUE;

		prfmsg(MSG1376, dmg);
		Server_Message(g);
	}
	else if (s == WEAKNESS)
	{
		dur += AMON->item_has[i].item_level;
		prfmsg(MSG71);
		Server_Message(g);
		Make_A_Timer(WEAK_TIME, dur / dodged, GUY, RESET);
	}
	else if (s == DISPEL_MAGIC)
	{
		Monster_Dispels_Magic(g, dodged);
	}
	else if (s == CURSE)
	{
		for (i = 0, tal_index = -1; i != NUM_ITEMS; ++i)
		{
			if (AGUY->item[i].what == TALISMAN)
			{
				tal_index = i;
			}
		}

		if (tal_index != -1)
		{
			prfmsg(MSG1091, AGUY->item[tal_index].name);
			Server_Message(g);
			P = g;
			Lose_Item(tal_index);
			DONE;
		}

		i = RANDOM(5);

		if (i == 1)
		{
			prfmsg(MSG75);

			if (AGUY->Int > dur)
			{
				AGUY->Int -= dur;
				e = Calc_Exp_Needed(AGUY->Int, FALSE);

				if (AGUY->int_exp > e)
				{
					AGUY->int_exp = e;
				}
			}
		}
		else if (i == 2)
		{
			prfmsg(MSG76);

			if (AGUY->Str > dur)
			{
				AGUY->Str -= dur;
				e = Calc_Exp_Needed(AGUY->Str, FALSE);

				if (AGUY->str_exp > e)
				{
					AGUY->str_exp = e;
				}
			}
		}
		else if (i == 3)
		{
			prfmsg(MSG77);

			if (AGUY->Psy > dur)
			{
				AGUY->Psy -= dur;
				e = Calc_Exp_Needed(AGUY->Psy, FALSE);

				if (AGUY->psy_exp > e)
				{
					AGUY->psy_exp = e;
				}
			}
		}
		else if (i == 4)
		{
			prfmsg(MSG78);

			if (AGUY->Dex > dur)
			{
				AGUY->Dex -= dur;
				e = Calc_Exp_Needed(AGUY->Dex, FALSE);

				if (AGUY->dex_exp > e)
				{
					AGUY->dex_exp = e;
				}
			}
		}
		else if (i == 5)
		{
			prfmsg(MSG79);

			if (AGUY->Con > dur)
			{
				AGUY->Con -= dur;
				e = Calc_Exp_Needed(AGUY->Con, FALSE);

				if (AGUY->con_exp > e)
				{
					AGUY->con_exp = e;
				}
			}
		}

		Server_Message(g);

		Set_Guy_Points
		(
			&AGUY->dpts,
			&AGUY->mpts,
			AGUY->Str,
			AGUY->Con,
			AGUY->Psy,
			AGUY->class
		);
	}

	DONE;
}
/****************************************************************************
	figure out how much damage I did
*/
short Calc_Damage(short g, short m, short bonus)
{
	short   i;
	short   armor_ac;
	MLONG   orig_dmg;
	MLONG   dmg;
	short   next_hit;
	MLONG   range = 0;
	short   double_chance;
	short   triple = FALSE;
	short   damage;
	
	if (me.rw >= 0)
	{
		range += (MLONG) me.item[me.rw].Hits;
	}
	if (me.lw >= 0)
	{
		range += (MLONG) me.item[me.lw].Hits;
	}

	if (me.rw < 0 && me.lw < 0)
	{
		range = (MLONG) me.wep_plus[HAND_IND];
	}

	if (range <= 0)
	{
		range = 1;
	}

	if (me.class == WARRIOR)
	{
		dmg = ((MLONG) bonus * globals->warbonus) / 10L;
	}
	else
	{
		dmg = 0L;
	}

	dmg += LRAND(range) + (MLONG) bonus;

	if (m >= 0)
	{
		next_hit = AMON->next_hit;
	}
	else
	{
		next_hit = APORT(g)->next_hit;
	}

	if (next_hit == PARRIED)
	{
		dmg = dmg / 2L;
	}

	if (command == PARRY && me.class != DUELIST)
	{ 
		dmg = dmg / 2L;
	}
	else if (command == GREATBLOW)
	{
		dmg = dmg * 2L;
	}

	orig_dmg = dmg;
	
	if (me.class == WARRIOR)
	{
		double_chance = globals->wardd;
	}
	else if (me.class == DUELIST)
	{
		double_chance = globals->dueldd;
	}
	else if (me.class == THIEF && m >= 0 && !AMON->sees[P])
	{
		if (RANDOM(100) <= globals->tambush)
		{
			dmg += orig_dmg;
			double_chance = 100;
			triple = TRUE;
		}
		else
		{
			double_chance = globals->thiefdd;
		}
	}
	else if (me.class == THIEF)
	{
		double_chance = globals->thiefdd;
	}
	else if (me.class == BARBARIAN)
	{
		double_chance = globals->barbdd;
	}
	else if (me.class == SORCERER)
	{
		double_chance = globals->sorcdd;
	}
	else if (me.class == MYSTIC)
	{
		double_chance = globals->mystdd1;
	}
	else if (me.class == CLERIC)
	{
		double_chance = globals->clerdd1;
	}

	if (me.class == MYSTIC)
	{
		if (me.rw < 0 || me.item[me.rw].what == NOHAND)
		{
			if (me.lw < 0 || me.item[me.lw].what == NOHAND)
			{
				double_chance = globals->mystdd2;
			}
		}
	}
	else if (me.class == CLERIC && (me.rw >= 0 || me.lw >= 0))
	{
		if (me.rw < 0 || me.item[me.rw].what == BLUNT)
		{
			if (me.lw < 0 || me.item[me.lw].what == BLUNT)
			{
				double_chance = globals->clerdd2;
			}
		}
	}

	if (m >= 0 && !AMON->sees[P])
	{
		double_chance = double_chance * 2;
	}

	if (RANDOM(100) <= double_chance)
	{
		if (g >= 0)
		{
			Message(globals->msg62, g);
		}

		if (triple)
		{
			prfmsg(M437A);
		}
		else
		{
			prfmsg(M437);
		}

		dmg += orig_dmg;
	}

	if (m >= 0)
	{
		if (AMON->what == NPC)
		{
			armor_ac = 0;
		}
		else if
		(
			AMON->what == MONSTER ||
			AMON->what == WEIRD ||
			AMON->what == LONER ||
			AMON->what == ORACLE ||
			AMON->what == HUNTRESS
		)
		{
			armor_ac = AMON->Level / LEATHER_FACTOR;
		}
		else if (AMON->what == ANIMAL)
		{
			armor_ac = (AMON->Level / 2) / LEATHER_FACTOR;
		}
		else if (AMON->what == HUMANOID)
		{
			armor_ac = (AMON->Level / 3) / LEATHER_FACTOR;
		}
		else if (AMON->what == AWESOME)
		{
			armor_ac = AMON->Level / METAL_FACTOR;
		}

		for (i = 0; i != MAX_MON_ITEM; ++i)
		{
			if (AMON->item_used[i])
			{
				if (AMON->item_has[i].what == ARMOR)
				{
					if (AMON->item_has[i].which == LITE_ARMOR)
					{
						armor_ac += 
							(AMON->item_has[i].bonus + AMON->item_has[i].ac) /
							LEATHER_FACTOR;
					}
					else
					{
						armor_ac += 
							(AMON->item_has[i].bonus + AMON->item_has[i].ac) /
							METAL_FACTOR;
					}
				}
			}
		}

		dmg -= (MLONG) armor_ac;
	}
	else
	{
		if (AGUY->armor >= 0)
		{
			armor_ac = AGUY->item[AGUY->armor].ac; 
			armor_ac += AGUY->item[AGUY->armor].bonus;

			if (AGUY->item[AGUY->armor].which == LITE_ARMOR)
			{
				armor_ac = armor_ac / LEATHER_FACTOR;
			}
			else
			{
				armor_ac = armor_ac / METAL_FACTOR;
			}

			dmg -= (MLONG) armor_ac;
		}
	}

	if (dmg <= 0)
	{
		dmg = 1;
	}
	else if (dmg > 32767L)
	{
		dmg = 32767L;
	}

	damage = (short) dmg;

	return (damage);
}
/****************************************************************************
	figure out all of user's combat plusses (natural and from weps);
*/
short Combat_Bonus(short *bonus, short with_spells)
{
	short   invis_t;
	short   maniac_t;
	short   strong_t;
	short   wep_bonus = 0;
	short   weps = 0;
	
	if (with_spells)
	{
		maniac_t = find_timer(MANIA_TIME, ME);
		strong_t = find_timer(STRONG_TIME, ME);
	}
	else
	{
		maniac_t = strong_t = FALSE;
	}

	Compute_Bonus
	(
		bonus,
		me.Str, me.Int, me.Dex,
		maniac_t, strong_t,
		me.class
	);

	if (me.lw < 0 && me.rw < 0)
	{
		*bonus = me.wep_plus[HAND_IND];
	}
	else
	{
		if (me.rw >= 0)
		{
			wep_bonus += me.item[me.rw].bonus;
			wep_bonus += me.wep_plus[Wep_Index(me.rw)];
			++weps;
		}

		if (me.lw >= 0)
		{
			wep_bonus += me.item[me.lw].bonus;
			wep_bonus += me.wep_plus[Wep_Index(me.lw)];
			++weps;
		}

		wep_bonus = wep_bonus / weps;
		*bonus += wep_bonus;

		if (me.rw >= 0 && me.lw >= 0)
		{
			*bonus += me.two_wep;
		}
		else if ((me.rw >= 0 || me.lw >= 0) && me.shld >= 0)
		{
			if (me.shield < 0)
			{
				*bonus += me.shield;
			}
		}
	}

	*bonus += MY_PORT->lucky_room;

	invis_t = find_timer(INVISIBLE_TIME, ME);

	if (invis_t && with_spells)
	{
		*bonus += 5;
	}

	DONE;
}
/****************************************************************************
	get my weapon index
*/
short Wep_Index(short wep)
{

	if (wep == -1)
	{
		return(HAND_IND);
	}
	else if (me.item[wep].what == POLE)
	{
		return(POLE_IND);
	}
	else if (me.item[wep].what == BLUNT)
	{
		return(BLUNT_IND);
	}
	else if (me.item[wep].what == EDGED)
	{
		return(EDGED_IND);
	}
	else if (me.item[wep].what == NOHAND)
	{
		return(HAND_IND);
	}
	DONE;
}
/****************************************************************************
	see if a monster panics
*/
short EXPORT Monster_Fled(short m, short before)
{
	short   sleep_t;
	short   invis_t;
	short   see_invis_t;
	short   i;
	short   evaded;
	short   dpts = me.dpts;

	if (command == STEAL)
	{
		dpts += me.thief * 2;
	}

	if 
	(
		invasion->active && 
		AMON->which == invasion->crit &&
		RANDOM(2) == 1
	)
	{
		DONE;
	}

	if (AMON->bashed)
	{
		BAD_EXIT;
	}

	if (AMON->attacked_vector != AUTO_FLEE || (before && command != BASH))
	{
		if 
		(
			me.Con <= (globals->strtstat / 5) + 10 ||
			me.Str <= (globals->strtstat / 5) + 10
		)
		{
			BAD_EXIT;
		}

		if (AMON->permanant || me.perm[SUPER_PERM])
		{
			BAD_EXIT;
		}

		if (dpts <= AMON->dpts * 3)
		{   
			BAD_EXIT;
		}
	}

	invis_t     = find_timer(INVISIBLE_TIME, MON);
	see_invis_t = find_timer(SEE_INVIS_TIME, ME);
	sleep_t     = find_timer(SLEEP_TIME, MON);
	evaded      = RANDOM(AMON->Dex * 2) > RANDOM(me.Dex);
	
	Start_Mon_Name(name, m);

	if (sleep_t)
	{
		prfmsg(M50, name);
	}

	if ((!invis_t || see_invis_t) && evaded)
	{
		if (AMON->damage < AMON->dpts)
		{
			prfmsg(MSG438, name);
			sprintf(str, getmsg(MSG439), name, me.name);
			Message(str, LOUD_LOCAL);

			for (i = 0; i != MAX_MON_ITEM; ++i)
			{
				if
				(
					AMON->item_has[i].what == MAGIC_DEV &&
					AMON->item_has[i].which == SCROLL
				)
				{
					Find_Scroll(&AMON->item_has[i]);
				}
			}

			if 
			(
				!AMON->permanant &&
				(!invasion->active || AMON->which != invasion->crit)
			)
			{
				for (i = 0; i != MAX_MON_ITEM; ++i)
				{
					if (AMON->item_used[i] && WEAPON(AMON->item_has[i]))
					{
						if (AMON->item_has[i].finder < 0)
						{
							AMON->item_has[i].finder = MY_PORT->index;
						}

						Put_In_Room(&AMON->item_has[i]);
					}
					else if 
					(
						AMON->item_used[i] && 
						AMON->item_has[i].what == SHIELD
					)
					{
						if (AMON->item_has[i].finder < 0)
						{
							AMON->item_has[i].finder = MY_PORT->index;
						}

						Put_In_Room(&AMON->item_has[i]);
					}
				}
			}

			Remove_Mon(m, FALSE);
			return (TRUE);
		}

		prfmsg(MSG440, name);
		sprintf(str, getmsg(MSG441), name, me.name);
		Message(str, LOUD_LOCAL);
		BAD_EXIT;
	}

	prfmsg(MSG442, name);
	sprintf(str, getmsg(MSG443), name, me.name);
	Message(str, LOUD_LOCAL);

	for (i = 0; i != MAX_MON_ITEM; ++i)
	{
		if
		(
			AMON->item_has[i].what == MAGIC_DEV &&
			AMON->item_has[i].which == SCROLL
		)
		{
			Find_Scroll(&AMON->item_has[i]);
		}
	}

	Remove_Mon(m, FALSE);
	return (TRUE);
}
