#include <header.h>
#include <globals.h>

/****************************************************************************
    user wants to deposit some cash into the bank
*/
void EXPORT Bank_Deposit(void)
{

    if ((double) me.bank + (double) me.gold > GCMAXLONG)
    {
        prf("Abort\r");
        return;
    }

    me.bank += me.gold;
    prfmsg(MSG1510, l2as(me.gold));
    me.gold = 0;
    Write_My_Rec(EXISTS);
}
/****************************************************************************
    user wants to deposit some cash into guild treasury
*/
void EXPORT Guild_Deposit(void)
{

    if ((double) guild->treasury[me.in_guild] + (double) me.gold > GCMAXLONG)
    {
        prf("Abort\r");
        return;
    }

    guild->treasury[me.in_guild] += me.gold;
    prfmsg(MSG1509, l2as(me.gold));

    if ((double) me.guild_balance + (double) me.gold <= GCMAXLONG)
    {
        me.guild_balance += me.gold;
    }

    me.gold = 0;
    Write_My_Rec(EXISTS);
}
/****************************************************************************
    user wants to withdraw some cash from the bank
*/
void EXPORT Bank_Withdrawl(void)
{
    MLONG   amount;
    MLONG   carrying;
    short   num_items;
    MLONG   carry_max;

    amount = LNUM(margv[0]);

    if (amount > me.bank && !me.perm[SUPER_PERM])
    {
        amount = me.bank;
    }

    if (amount <= 0)
    {
        prfmsg(MSG1516);
        return;
    }

    Calc_Weight(&num_items, &carrying, &carry_max);

    if (carrying + amount > carry_max && !me.perm[SUPER_PERM])
    {
        amount = carry_max - carrying;

        if (amount > 0)
        {
            prfmsg(MSG1513, l2as(amount));
        }
        else
        {
            prfmsg(MSG1514);
            return;
        }
    }

    if ((double) me.gold + (double) amount > GCMAXLONG)
    {
        prf("Abort\r");
        return;
    }

    me.bank -= amount;
    me.gold += amount;
    prfmsg(MSG1515, l2as(amount));

    if (me.bank < 0 && me.perm[SUPER_PERM])
    {
        me.bank = 0;
    }
    Write_My_Rec(EXISTS);
}
/****************************************************************************
    user wants to withdraw some cash from their guild treasury
*/
void EXPORT Guild_Withdrawl(void)
{
    MLONG   amount;
    short   num_items;
    MLONG   carrying;
    MLONG   max;

    amount = LNUM(margv[0]);

    if (amount > guild->treasury[me.in_guild] && !me.perm[SUPER_PERM])
    {
        amount = guild->treasury[me.in_guild];
    }

    if (amount <= 0)
    {
        prfmsg(MSG1516);
        return;
    }

    Calc_Weight(&num_items, &carrying, &max);

    if (carrying + amount > max && !me.perm[SUPER_PERM])
    {
        amount = max - carrying;

        if (amount > 0)
        {
            prfmsg(MSG1513, l2as(amount));
        }
        else
        {
            prfmsg(MSG1514);
            return;
        }
    }

    if ((double) me.gold + (double) amount > GCMAXLONG)
    {
        prf("Abort\r");
        return;
    }

    me.gold += amount;
    me.guild_balance -= amount;
    guild->treasury[me.in_guild] -= amount;

    if (guild->treasury[me.in_guild] < 0 && me.perm[SUPER_PERM])
    {
        guild->treasury[me.in_guild] = 0;
    }

    prfmsg(MSG1515, l2as(amount));
    Write_My_Rec(EXISTS);
}
/****************************************************************************
    transfer funds to another character
*/
void EXPORT Transfer_Funds(short from)
{
    MLONG   amount;
    short   i;
    short   online = -1;

    if 
    (
        MY_PORT->status == BANK_PROMPT2 || 
        MY_PORT->status == TREASURY_PROMPT2
    )
    {
        MY_PORT->misc = Find_A_Char(&a_char, margv[0]);

        if (MY_PORT->misc < 0)
        {
            prfmsg(M920, margv[0]);

            if (IN_GUILD)
            {
                Set_Prompt(getmsg(MSG1507), BANK_PROMPT);
            }
            else
            {
                Set_Prompt(getmsg(MSG1507), TREASURY_PROMPT);
            }

            return;
        }
        
        if (IN_GUILD)
        {
            Set_Prompt(getmsg(MSG1518), TREASURY_PROMPT3);
        }
        else
        {
            Set_Prompt(getmsg(MSG1518), BANK_PROMPT3);
        }

        return;
    }

    amount = LNUM(margv[0]);

    if (from == FROM_BANK)
    {
        if (amount > me.bank && !me.perm[SUPER_PERM])
        {
            amount = me.bank;
        }
    }
    else if (from == FROM_GUILD)
    {
        if (amount > guild->treasury[me.in_guild] && !me.perm[SUPER_PERM])
        {
            amount = guild->treasury[me.in_guild];
        }
    }

    if (amount <= 0)
    {
        prfmsg(MSG1516);
        return;
    }

    for (i = 0; i != NTERMS && online < 0; ++i)
    {
        if (APORT(i)->status && APORT(i)->index == MY_PORT->misc)
        {
            if ((double) APORT(i)->chr.bank + (double) amount > GCMAXLONG)
            {
                prf("Abort\r");
                return;
            }

            APORT(i)->chr.bank += amount;

            sprintf(str, getmsg(MSG1519), me.name, amount);
            Message(str, i);
            online = i;
        }
    }

    Read_A_Char(MY_PORT->misc, &a_char);

    if (online < 0)
    {
        if ((double) a_char.bank + (double) amount > GCMAXLONG)
        {
            prf("Abort\r");
            return;
        }

        a_char.bank += amount;
        Write_A_Char(MY_PORT->misc, &a_char);
    }
    else
    {
        Write_Him(online);
    }

    if (from == FROM_BANK)
    {
        me.bank -= amount;

        if (me.bank < 0 && me.perm[SUPER_PERM])
        {
            me.bank = 0;
        }
    }
    else
    {
        guild->treasury[me.in_guild] -= amount;        
        me.guild_balance -= amount;

        if (guild->treasury[me.in_guild] < 0 && me.perm[SUPER_PERM])
        {
            guild->treasury[me.in_guild] = 0;
        }
    }

    Write_My_Rec(EXISTS);
    prfmsg(MSG1520, l2as(amount), a_char.name);
}
/****************************************************************************
    transfer from bank to guild
*/
void EXPORT Transfer_To_Guild(void)
{
    MLONG   amount;

    amount = LNUM(margv[0]);

    if (amount > me.bank && !me.perm[SUPER_PERM])
    {
        amount = me.bank;
    }

    if (amount <= 0)
    {
        prfmsg(MSG1516);
        return;
    }

    if ((double) guild->treasury[me.in_guild] + (double) amount > GCMAXLONG)
    {
        prf("Abort\r");
        return;
    }

    guild->treasury[me.in_guild] += amount;
    prfmsg(MSG1521, l2as(amount));
    me.bank -= amount;

    if ((double) me.guild_balance + (double) amount <= GCMAXLONG)
    {
        me.guild_balance += amount;
    }

    if (me.bank < 0 && me.perm[SUPER_PERM])
    {
        me.bank = 0;
    }

    Write_My_Rec(EXISTS);
}
