#include <header.h>
#include <globals.h>

/****************************************************************************
    set the path to the specified container file
*/
FILE   * EXPORT Open_Bag_Path(item, mode)
struct item_struct *item;
char   *mode;
{
    FILE    *fp;

    sprintf(globals->path, "%s\\BAG%d.DAT", BAG_PATH, item->id);
    fp = fopen(globals->path, mode);

    if (fp == NULL)
    {
        Create_New(globals->path);
        fp = fopen(globals->path, mode);

        if (fp == NULL)
        {
            catastro(str, "SoC: Open_Bag_Path %d FAILURE", item->id);
        }
    }

    return (fp);
}
/****************************************************************************
    initialize the available slots for a container
*/
void   EXPORT Init_Free_Bag(bag)
struct item_struct *bag;
{
    short   i;
    short   n;
    short   index = -1;
    short   f_index = -1;
    short   o_index = 0;
    MLONG   cur_time = time(0);
    FILE    *fp;

    for (i = 0; i != MAX_BAGS && f_index < 0; ++i)
    {
        if (free_bags->index[i] == 0 || free_bags->index[i] == bag->id)
        {
            f_index = i;
        }
    }

    if (f_index < 0)
    {
        catastro("SoC: Too many containers!");
    }

    for (i = 0; i != MAX_OPEN_SLOTS; ++i)
    {
        free_bags->open[f_index][i] = -1;
    }

    fp = Open_Bag_Path(bag, RDWR);
    free_bags->index[f_index] = bag->id;

    do
    {
        n = fread(a_container, CONTAINER_SIZE, 1, fp);
        ++index;

        if 
        (
            n == 1 && 
            cur_time - a_container->last_write > BAG_LIFE &&
            o_index < MAX_OPEN_SLOTS
        )
        {
            free_bags->open[f_index][o_index] = index;
            ++o_index;
        }
    }
    while (n == 1);
    
    free_bags->end[f_index] = index;
    fclose(fp);
}
/****************************************************************************
    find an item in a container
*/
short EXPORT Find_Bag_Item(short bag_index)
{
    FILE    *fp;
    short   i;
    short   n;
    short   index = -1;
    short   unique = 1;
    short   count;
    short   ret_val;
    short   done = FALSE;
    char    *word;
    char    match[LINE_LEN];

    if (!me.item[bag_index].new_bag)
    {
        me.item[bag_index].holding = 0;
        prfmsg(MSG1225);
        return (-1);
    }

    fp = Open_Bag_Path(&me.item[bag_index], RDWR);
    lsk = me.item[bag_index].bag_index * CONTAINER_SIZE;
    n = fseek(fp, lsk, TOP);

    if (n != 0)
    {
        fclose(fp);
        me.item[bag_index].holding = 0;
        me.item[bag_index].new_bag = FALSE;
        prfmsg(MSG1225);
        return (-1);
    }

    n = fread(a_container, CONTAINER_SIZE, 1, fp);
    fclose(fp);

    if (n != 1)
    {
        me.item[bag_index].holding = 0;
        me.item[bag_index].new_bag = FALSE;
        prfmsg(MSG1225);
        return (-1);
    }

    for (i = count = me.item[bag_index].holding = 0; i != CONTAINER_MAX; ++i)
    {
        if (a_container->item[i].what)
        {
            ++count;
            ++me.item[bag_index].holding;
        }
    }

    if (count == 0)
    {
        prfmsg(MSG1225);
        return (-1);
    }

    n = atoi(word1);

    if (n > 0 && n <= count)
    {
        return(n - 1);
    }
    else if (n > count)
    {
        prfmsg(MSG1226, me.item[bag_index].name);
        return (-1);
    }

    match[0] = 0;

    for (i = count = 0; i != CONTAINER_MAX && !done; ++i)
    {
        if (a_container->item[i].what)
        {
            ++index;
            strcpy(name, a_container->item[i].name);
            word = strtok(name, " ");

            if (sameto(word1, word))
            {
                if (match[0] == 0)
                {
                    strcpy(match, word);
                }
                else
                {
                    if (!sameas(word, match))
                    {
                        unique = 0;
                    }
                }

                ++count;

                if (count <= which1)
                {
                    ret_val = index;
                }

                if (sameas(word, word1) && which1 == 1)
                {
                    count = unique = done = 1;
                }
            }
        }
    }

    if (count == 0)
    {
        index = -1;
        prfmsg(M542, word1);
    }
    else if (!unique)
    {
        index = -1;
        prfmsg(M167, word1);
    }
    else if (count < which1)
    {
        prfmsg(MSG1227);
        index = -1;
    }
    else
    {
        index = ret_val;
    }

    return (index);
}
/****************************************************************************
    remove an item from a container file
*/
void EXPORT Lose_Bag_Item(short bag_index, short index)
{
    short   i;
    short   count;
    FILE    *fp;

    for (i = count = 0; i != CONTAINER_MAX; ++i)
    {
        if (a_container->item[i].what)
        {
            ++count;
        }
    }

    a_container->item[index].what = 0;

    if (index + 1 != CONTAINER_MAX)
    {
        for (i = index + 1; i != CONTAINER_MAX; ++i)
        {
           a_container->item[i - 1] = a_container->item[i];
        }
    }
    
    a_container->item[count - 1].what = 0;
    a_container->last_write = time(0);

    fp = Open_Bag_Path(&me.item[bag_index], RDWR);
    lsk = me.item[bag_index].bag_index * CONTAINER_SIZE;
    i = fseek(fp, lsk, TOP);

    if (i != 0)
    {
        me.item[bag_index].holding = 0;
        me.item[bag_index].new_bag = FALSE;
    }
    else
    {
        fwrite(a_container, CONTAINER_SIZE, 1, fp);
    }

    fclose(fp);
}
/****************************************************************************
    put something into a container
*/
short EXPORT Put_In_Bag(short item_index, short bag_index)
{
    short   i;
    short   n;
    short   f_index = -1;
    short   done;
    FILE    *fp;

    if (!me.item[bag_index].new_bag)
    {
        for (i = 0; i != MAX_BAGS && f_index < 0; ++i)
        {
            if (free_bags->index[i] == me.item[bag_index].id)
            {
                f_index = i;
            }
        }

        if (f_index < 0)
        {
            Init_Free_Bag(&me.item[bag_index]);
            prfmsg(MSG1368);
            BAD_EXIT;
        }
        
        for (i = done = 0; i != MAX_OPEN_SLOTS && !done; ++i)
        {
            if (free_bags->open[f_index][i] != -1)
            {
                me.item[bag_index].bag_index = free_bags->open[f_index][i];
                free_bags->open[f_index][i] = -1;
                done = TRUE;
            }
        }

        setmem(a_container, CONTAINER_SIZE, 0);
        a_container->last_write = time(0);
        a_container->item[0] = me.item[item_index]; 
        me.item[bag_index].new_bag = TRUE; 

        if (done)
        {
            fp = Open_Bag_Path(&me.item[bag_index], RDWR);
            lsk = me.item[bag_index].bag_index * CONTAINER_SIZE;
            n = fseek(fp, lsk, TOP);
        
            if (n != 0)
            {
                prfmsg(MSG1368);
                fclose(fp);
                BAD_EXIT;
            }
                
            fwrite(a_container, CONTAINER_SIZE, 1, fp);
            fclose(fp);
        }
        else
        {
            me.item[bag_index].bag_index = free_bags->end[f_index];
            ++free_bags->end[f_index];

            fp = Open_Bag_Path(&me.item[bag_index], APPEND);
            fwrite(a_container, CONTAINER_SIZE, 1, fp);
            fclose(fp);
        }

        Write_My_Rec(EXISTS);
    }
    else
    {
        fp = Open_Bag_Path(&me.item[bag_index], RDWR);
        lsk = me.item[bag_index].bag_index * CONTAINER_SIZE;
        n = fseek(fp, lsk, TOP);

        if (n != 0)
        {
            fclose(fp);
            prfmsg(MSG1368);
            me.item[bag_index].new_bag = FALSE;
            me.item[bag_index].holding = 0;
            BAD_EXIT;
        }

        n = fread(a_container, CONTAINER_SIZE, 1, fp);
    
        if (n != 1)
        {
            fclose(fp);
            prfmsg(MSG1368);
            me.item[bag_index].new_bag = FALSE;
            me.item[bag_index].holding = 0;
            BAD_EXIT;
        }

        for (i = done = 0; i != CONTAINER_MAX && !done; ++i)
        {
            if (a_container->item[i].what == 0)
            {
                a_container->item[i] = me.item[item_index];
                done = TRUE;
            }
        }

        a_container->last_write = time(0);
        fseek(fp, lsk, TOP);
        fwrite(a_container, CONTAINER_SIZE, 1, fp);
        fclose(fp);

        if (!done)
        {
            prfmsg(MSG1356, me.item[bag_index].name, CONTAINER_MAX);
            BAD_EXIT;
        }
    }

    prfmsg(MSG1122);
    Display_Item(&me.item[item_index]);
    prfmsg(MSG1123);
    Display_Item(&me.item[bag_index]);
    prf(NL);

    sprintf(str, getmsg(MSG1124), me.name);
    Cat_Item(str, &me.item[bag_index]);
    Message(str, QUIET_LOCAL);

    ++me.item[bag_index].holding;

    if (!me.item[bag_index].infinite_uses)
    {
        --me.item[bag_index].uses;
    }

    Lose_Item(item_index);

    if (bag_index > item_index)
    {
        --bag_index;
    }

    if (me.item[bag_index].uses <= 0)
    {
        Bag_Broke(bag_index);
    }
    else
    {
        if (me.item[bag_index].uses == 10)
        {
            prfmsg(M91, me.item[bag_index].name);
        }
        else if (me.item[bag_index].uses < 10)
        {
            prfmsg(M92, me.item[bag_index].name);
        }
    }

    return (TRUE);
}
/****************************************************************************
    take an item out of a container
*/
short EXPORT Get_From_Bag(short bag_index)
{
    short   index;
    short   i;

    index = Find_Bag_Item(bag_index);
    if (index < 0)
    {
        BAD_EXIT;
    }

    i = Give_Me(&a_container->item[index]);

    if (i == 0)
    {
        BAD_EXIT;
    }

    prfmsg(MSG1228);
    Display_Item(&a_container->item[index]);
    prf(NL);

    --me.item[bag_index].holding;
    Lose_Bag_Item(bag_index, index);

    sprintf(str, getmsg(MSG1229), me.name);
    Cat_Item(str, &me.item[bag_index]);
    Message(str, QUIET_LOCAL);

    return (TRUE);
}
/****************************************************************************
    take an item out of a container
*/
short EXPORT Toss_From_Bag(short bag_index)
{
    short   index;

    index = Find_Bag_Item(bag_index);
    if (index < 0)
    {
        BAD_EXIT;
    }

    prfmsg(MSG1230);
    Display_Item(&a_container->item[index]);
    prf(NL);

    Lose_Bag_Item(bag_index, index);
    --me.item[bag_index].holding;
    sprintf(str, getmsg(MSG1231), me.name);
    Cat_Item(str, &me.item[bag_index]);
    Message(str, QUIET_LOCAL);
    
    return(TRUE);
}
/*******************************************************************************
    user's bag broke open
*/
void EXPORT Bag_Broke(short bag_index)
{
    short   done;
    FILE    *fp;
    short   i;
    short   x;
    short   skip = FALSE;

    prfmsg(MSG1223, me.item[bag_index].name);

    fp = Open_Bag_Path(&me.item[bag_index], RDWR);
    lsk = me.item[bag_index].bag_index * CONTAINER_SIZE;
    i = fseek(fp, lsk, TOP);

    if (i != 0)
    {
        skip = TRUE;
    }
    else
    {
        i = fread(a_container, CONTAINER_SIZE, 1, fp);

        if (i != 1)
        {
            skip = TRUE;
        }
    }

    fclose(fp);

    if (!skip)
    {
        for (i = CONTAINER_MAX - 1, done = FALSE; i >= 0 && !done; --i)
        {
            if (a_container->item[i].what)
            {
                x = Dump_In_Room(&a_container->item[i]);
                
                if (x)
                {
                    prfmsg(MSG1224);
                    Display_Item(&a_container->item[i]);
                    prf(NL);
                }
                else
                {
                    done = TRUE;
                }
            }
        }
    }
    
    Kill_Container(&me.item[bag_index]);
    Lose_Item(bag_index);
}
/*****************************************************************************
    user wants to empty out a bag
*/
short EXPORT Dump_Bag(void)
{           
    FILE    *fp;
    short   i;
    short   x;
    short   done;
    short   bag_index;
    short   absolute_match = 0;

    if (word1[0] == 0)
    {
        prfmsg(MSG1232);
        BAD_EXIT;
    }

    bag_index = find_item(word1, which1, 1, &absolute_match);

    if (bag_index < 0)
    {
        BAD_EXIT;
    }

    if (me.item[bag_index].what != CONTAINER)
    {
        prfmsg(MSG1233);
        Display_Item(&me.item[bag_index]);
        prf(NL);
        BAD_EXIT;
    }

    if (!me.item[bag_index].new_bag)
    {
        prfmsg(MSG1225);
        BAD_EXIT;
    }

    prfmsg(MSG1234);
    Display_Item(&me.item[bag_index]);
    prf(NL);

    fp = Open_Bag_Path(&me.item[bag_index], RDWR);
    lsk = me.item[bag_index].bag_index * CONTAINER_SIZE;
    i = fseek(fp, lsk, TOP);

    if (i != 0)
    {
        me.item[bag_index].new_bag = FALSE;
        me.item[bag_index].holding = 0;
        fclose(fp);
        BAD_EXIT;
    }

    i = fread(a_container, CONTAINER_SIZE, 1, fp);

    if (i != 1)
    {
        me.item[bag_index].new_bag = FALSE;
        me.item[bag_index].holding = 0;
        fclose(fp);
        BAD_EXIT;
    }

    for (i = CONTAINER_MAX - 1, done = FALSE; i >= 0 && !done; --i)
    {
        if (a_container->item[i].what)
        {
            x = Dump_In_Room(&a_container->item[i]);
            
            if (x)
            {
                prfmsg(MSG1224);
                Display_Item(&a_container->item[i]);
                prf(NL);

                --me.item[bag_index].holding;
                a_container->item[i].what = 0;
            }
            else
            {
                done = TRUE;
            }
        }
    }

    a_container->last_write = time(0);            
    fseek(fp, lsk, TOP);
    fwrite(a_container, CONTAINER_SIZE, 1, fp);
    fclose(fp);

    sprintf(str, getmsg(MSG1235), me.name);
    Cat_Item(str, &me.item[bag_index]);
    Message(str, LOUD_LOCAL);
    DONE;
}
/****************************************************************************
    print a list of what the user is carrying in a container
*/
short EXPORT Print_Bag_Contents(short option, short bag_index)
{
    short   done = FALSE;
    short   l = 0;
    FILE    *fp;
    short   i;

    if (option == 0)
    {
        if (!me.item[bag_index].new_bag)
        {
            me.item[bag_index].holding = 0;
            prfmsg(MSG1225);
            BAD_EXIT;
        }

        if (me.item[bag_index].holding == 0)
        {
            Kill_Container(&me.item[bag_index]);
            me.item[bag_index].new_bag = FALSE;
            prfmsg(MSG1225);
            BAD_EXIT;
        }

        MY_PORT->misc = 0;
        MY_PORT->misc2 = bag_index;
    }
    else if (margc && sameas(margv[0], "n"))
    {
        MY_PORT->status = DO_PROMPT;
        BAD_EXIT;
    }

    fp = Open_Bag_Path(&me.item[MY_PORT->misc2], RDWR);
    lsk = me.item[MY_PORT->misc2].bag_index * CONTAINER_SIZE;
    i = fseek(fp, lsk, TOP);

    if (i != 0)
    {
        fclose(fp);
        me.item[bag_index].new_bag = FALSE;
        me.item[bag_index].holding = 0;
        prfmsg(MSG1225);
        MY_PORT->status = DO_PROMPT;
        BAD_EXIT;
    }

    i = fread(a_container, CONTAINER_SIZE, 1, fp);
    fclose(fp);

    if (i != 1)
    {
        me.item[bag_index].new_bag = FALSE;
        me.item[bag_index].holding = 0;
        prfmsg(MSG1225);
        MY_PORT->status = DO_PROMPT;
        BAD_EXIT;
    }

    for (i = MY_PORT->misc; i != CONTAINER_MAX && !done; ++i)
    {
        ++MY_PORT->misc;

        if (a_container->item[i].what)
        {
            ++l;

            if (l == 15)
            {
                done = TRUE;
            }

            if (MY_PORT->misc == 1)
            {
                prfmsg(MSG1236);
            }

            prfmsg(MSG1237, MY_PORT->misc);
            Color_Display_Item(&a_container->item[i]);

            if (WEAPON(a_container->item[i]) || ARSH(a_container->item[i]))
            {
                if (a_container->item[i].uses <= 10)
                {
                    prfmsg(MSG221);
                }
            }
               
            if (a_container->item[i].ring_used)
            {
                prfmsg
                (
                    MSG224, 
                    spell_info[a_container->item[i].spell_cast].name
                );
            }

            prf(NL);
        }
    }

    if (MY_PORT->misc < CONTAINER_MAX)
    {
        if (a_container->item[MY_PORT->misc].what == 0)
        {
            done = TRUE;
        }
        else
        {
            done = FALSE;
        }
    }
    else
    {
        done = TRUE;
    }

    if (done)
    {
        MY_PORT->status = DO_PROMPT;
    }
    else
    {
        Set_Prompt(getmsg(MSG1209), CONTAINER_PROMPT);
    }

    DONE;
}
/****************************************************************************
    find out how many talismans are in a container
*/            
short EXPORT Talisman_Count(struct item_struct *bag)
{
    FILE    *fp;
    short   i;
    short   count = 0;

    if (!bag->new_bag)
    {
        return (count);
    }

    fp = Open_Bag_Path(bag, RDWR);
    lsk = bag->bag_index * CONTAINER_SIZE;
    i = fseek(fp, lsk, TOP);

    if (i != 0)
    {
        fclose(fp);
        bag->new_bag = FALSE;
        bag->holding = 0;
        BAD_EXIT;
    }

    i = fread(a_container, CONTAINER_SIZE, 1, fp);
    fclose(fp);

    if (i != 1)
    {
        bag->new_bag = FALSE;
        bag->holding = 0;
        BAD_EXIT;
    }

    for (i = 0; i != CONTAINER_MAX; ++i)
    {
        if (a_container->item[i].what == TALISMAN)
        {
            ++count;
        }
    }

    return (count);
}
/****************************************************************************
    figure out the weight of a bag and it's contents
*/
MLONG EXPORT Weigh_Bag_Contents(struct item_struct *bag)
{
    FILE    *fp;
    short   i;
    MLONG   weight = 0;

    if (!bag->new_bag)
    {
        bag->holding = 0;
        return (weight);
    }

    fp = Open_Bag_Path(bag, RDWR);
    lsk = bag->bag_index * CONTAINER_SIZE;
    i = fseek(fp, lsk, TOP);

    if (i != 0)
    {
        fclose(fp);
        bag->new_bag = FALSE;
        bag->holding = 0;
        return (weight);
    }

    i = fread(a_bag, CONTAINER_SIZE, 1, fp);
    fclose(fp);
    
    if (i != 1)
    {
        bag->new_bag = FALSE;
        bag->holding = 0;
        return (weight);
    }

    for (i = bag->holding = 0; i != CONTAINER_MAX; ++i)
    {
        if (a_bag->item[i].what)
        {
            weight += Weight(&a_bag->item[i]);
            ++bag->holding;
        }
    }

    return (weight);
}
/****************************************************************************
    figure out the value of a bag's contents
*/
MLONG EXPORT Bag_Value(struct item_struct *bag)
{
    FILE    *fp;
    short   i;
    MLONG   value = 0;

    if (!bag->new_bag)
    {
        return (value);
    }

    fp = Open_Bag_Path(bag, RDWR);
    lsk = bag->bag_index * CONTAINER_SIZE;
    i = fseek(fp, lsk, TOP);

    if (i != 0)
    {
        fclose(fp);
        bag->new_bag = FALSE; 
        bag->holding = 0;
        return (value);
    }

    i = fread(a_bag, CONTAINER_SIZE, 1, fp);
    fclose(fp);
    
    if (i != 1)
    {
        bag->new_bag = FALSE; 
        bag->holding = 0;
        return (value);
    }

    for (i = bag->holding = 0; i != CONTAINER_MAX; ++i)
    {
        if (a_bag->item[i].what)
        {
            value += Calc_Val(&a_bag->item[i]);
            ++bag->holding;
        }
    }

    return (value);
}
/****************************************************************************
    a container has ceased to be, free the file slot
*/
short EXPORT Kill_Container(struct item_struct *cont)
{
    short   i;
    short   done;
    short   f_index = -1;
    FILE    *fp;

    cont->holding = 0;

    if (!cont->new_bag)
    {
        BAD_EXIT;
    }

    cont->new_bag = FALSE;

    fp = Open_Bag_Path(cont, RDWR);
    setmem(a_container, CONTAINER_SIZE, 0);
    lsk = cont->bag_index * CONTAINER_SIZE;
    i = fseek(fp, lsk, TOP);

    if (i == 0)
    {
        fwrite(a_container, CONTAINER_SIZE, 1, fp);
    }

    fclose(fp);

    for (i = 0; i != MAX_BAGS && f_index < 0; ++i)
    {
        if (free_bags->index[i] == cont->id)
        {
            f_index = i;
        }
    }

    if (f_index >= 0)
    {
        for (i = done = 0; i != MAX_OPEN_SLOTS && !done; ++i)
        {
            if (free_bags->open[f_index][i] == -1)
            {
                done = TRUE;
                free_bags->open[f_index][i] = cont->bag_index;
            }
        }
    }

    DONE;
}
