/**********************************************************************
*       Swords of Chaos                                               *
*       Origin Date: 12/20/94                                         *
*       Last Mod:    10/20/97                                         *
*                                                                     *
*       Programmer:  Mark Peterson                                    *
*                                                                     *
*       Copyright (C) 1997 by Mark Peterson, All Rights Reserved      *
***********************************************************************/
/*#define SOC2*/ /* To compile SoC Annex, uncomment this #define */

#ifdef GCDOS
#define MSHORT      SHORT
#else
#ifdef GCWINNT
#define MSHORT      SHORT
#else
#define MBBS
#define GCMAXLONG   MAXLONG
#define GBOOL       int
#define MSHORT      int
#endif
#endif

#define MLONG       long
#define VERSION     "Version 4.17"

/* include files */

#include <GCOMM.H>
#include <MAJORBBS.h>
#include <FILEXFER.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <sys\stat.h>
#include <muichaos.h>
#include <fsdbbs.h>

#ifdef SOC2

#define CHAOS_USER_FILE         "MUISOC\\DATA\\USERFILE.DAT"
#define CHAOS_NAME_FILE         "MUISOC\\DATA\\NAMEFILE.DAT"
#define CHAOS_MACRO_FILE        "MUISOC\\DATA\\MACROS.DAT"
#define PUBLIC_FORUM            "MUISOC\\DATA\\BIZNESS.DAT"
#define GUILD_FILE              "MUISOC\\DATA\\GUILDS.DAT"
#define CLOSET_FILE             "MUISOC\\DATA\\CLOSETS.DAT"
#define CHAOS_DAYFILE           "MUISOC\\DATA\\LOG.DAT"
#define ROOM2_FILE              "MUISOC\\DATA\\ROOMADD.DAT"
#define VOTE_FILE               "MUISOC\\DATA\\OFFICES.DAT"

#define CATALOG_PATH            "MUISOC\\DATA\\CAT%d.DAT"
#define STICKY_PATH             "MUISOC\\DATA\\ITM%d.DAT"

#define ITEM_FILE               "MUISOC\\DATA\\ITEMFILE.DAT"
#define MONSTER_FILE            "MUISOC\\DATA\\CRITFILE.DAT"
#define ROOM_FILE               "MUISOC\\DATA\\ROOMFILE.DAT"

#define CHAOS_FAME              "MUISOC\\DATA\\FAME.DAT"
#define NEWS_FILE               "MUISOC\\DATA\\NEWSTAND.DAT"

#define DATA_PATH               "MUISOC\\DATA"
#define BAG_PATH                "MUISOC\\DATA\\BAGS"
#define GUILD_FORUM_PATH        "MUISOC\\DATA\\GFORUMS"
#define ROOM_ITEM_PATH          "MUISOC\\DATA\\ROOMITMS"
#define COWARD_PATH             "MUISOC\\DATA\\COWARDS"
#define CHAOS_HELP_PATH         "MUISOC\\DATA\\HELP"
#define MAIL_PATH               "MUISOC\\DATA\\MAIL"

#define MONSTER_REPORT_FILE     "MUISOC\\DATA\\MONSTER.RPT"
#define ITEM_REPORT_FILE        "MUISOC\\DATA\\ITEM.RPT"
#define ROOM_REPORT_FILE        "MUISOC\\DATA\\ROOM.RPT"

#else

#define CHAOS_USER_FILE         "MUICHAOS\\DATA\\USERFILE.DAT"
#define CHAOS_NAME_FILE         "MUICHAOS\\DATA\\NAMEFILE.DAT"
#define CHAOS_MACRO_FILE        "MUICHAOS\\DATA\\MACROS.DAT"
#define PUBLIC_FORUM            "MUICHAOS\\DATA\\BIZNESS.DAT"
#define GUILD_FILE              "MUICHAOS\\DATA\\GUILDS.DAT"
#define CLOSET_FILE             "MUICHAOS\\DATA\\CLOSETS.DAT"
#define CHAOS_DAYFILE           "MUICHAOS\\DATA\\LOG.DAT"
#define ROOM2_FILE              "MUICHAOS\\DATA\\ROOMADD.DAT"
#define VOTE_FILE               "MUICHAOS\\DATA\\OFFICES.DAT"

#define CATALOG_PATH            "MUICHAOS\\DATA\\CAT%d.DAT"
#define STICKY_PATH             "MUICHAOS\\DATA\\ITM%d.DAT"

#ifndef EDITOR
#define ITEM_FILE               "MUICHAOS\\DATA\\ITEMFILE.DAT"
#define MONSTER_FILE            "MUICHAOS\\DATA\\CRITFILE.DAT"
#define ROOM_FILE               "MUICHAOS\\DATA\\ROOMFILE.DAT"
#else
#define ITEM_FILE               "ITEMFILE.DAT"
#define MONSTER_FILE            "CRITFILE.DAT"
#define ROOM_FILE               "ROOMFILE.DAT"
#endif

#define CHAOS_FAME              "MUICHAOS\\DATA\\FAME.DAT"
#define NEWS_FILE               "MUICHAOS\\DATA\\NEWSTAND.DAT"

#define DATA_PATH               "MUICHAOS\\DATA"
#define BAG_PATH                "MUICHAOS\\DATA\\BAGS"
#define GUILD_FORUM_PATH        "MUICHAOS\\DATA\\GFORUMS"
#define ROOM_ITEM_PATH          "MUICHAOS\\DATA\\ROOMITMS"
#define COWARD_PATH             "MUICHAOS\\DATA\\COWARDS"
#define CHAOS_HELP_PATH         "MUICHAOS\\DATA\\HELP"
#define MAIL_PATH               "MUICHAOS\\DATA\\MAIL"

#define MONSTER_REPORT_FILE     "MUICHAOS\\DATA\\MONSTER.RPT"
#define ITEM_REPORT_FILE        "MUICHAOS\\DATA\\ITEM.RPT"
#define ROOM_REPORT_FILE        "MUICHAOS\\DATA\\ROOM.RPT"

#endif

#ifdef SOC2
#define TEMP_ITEM_FILE          "SOCITEMS.DAT"
#define TEMP_MONSTER_FILE       "SOCCRITS.DAT"
#define TEMP_ROOM_FILE          "SOCROOMS.DAT"
#else
#define TEMP_ITEM_FILE          "ITEMFILE.DAT"
#define TEMP_MONSTER_FILE       "CRITFILE.DAT"
#define TEMP_ROOM_FILE          "ROOMFILE.DAT"
#endif

#define SYSOP_HELP_FILE         "SYSOP.TXT"
#define MAGIC_HELP_FILE         "MAGIC.TXT"
#define START_HELP_FILE         "START.TXT"
#define CLASS_HELP_FILE         "CLASSES.TXT"
#define HINTS_FILE              "HINTS.TXT"
#define MAP_FILE                "MAP.TXT"
#define CHANGE_LOG              "CHANGE.LOG"

#define TOP                     SEEK_SET
#define CURRENT_LOC             SEEK_CUR
#define BOTTOM                  SEEK_END

/* limits */

#define NTERMS                  globals->maxuser
#define MAX_CHANNELS            101

#define NUM_OFFICES             4
#define EQUIP_ONLY              1
#define FULL_AC                 2
#define LINE_SIZE               80
#define NUM_MACROS              20
#define NUM_WEAPONS             4
#define NUM_GUY_TIMERS          21
#define NUM_MON_TIMERS          11
#define NUM_EXITS               7
#define MAX_MERC_ITEM           6
#define MAX_PAWNED              16
#define NUM_ITEMS               20
#define NUM_SAVED_PLACES        10
#define MAX_MON_ITEM            6
#define POSSIBLE_MON_ITEM       5
#define POSSIBLE_MONS           5
#define MAX_ROOM_MON            8
#define MAX_PERM_MON            120
#define MAX_PERM_ITEM           120
#define MAX_ROOM_CACHE          100

#define MAX_ROOM                (globals->maxroom + 1)
#define MAX_MONSTER             (globals->maxmon + 1)
#define MAX_ITEM                (globals->maxitem + 1)

#define NAME_LEN                15
#define LINE_LEN                140
#define MESSAGE_LEN             10

/* Character Classes */                               

#define WARRIOR                 'W'
#define SORCERER                'S'
#define BARBARIAN               'B'
#define THIEF                   'T'
#define DUELIST                 'D'
#define CLERIC                  'C'
#define MYSTIC                  'M'

/* Races */

#define ELF                     'E'
#define DWARF                   'D'
#define HUMAN                   'H'
#define OGRE                    'O'
#define HALFLING                'L'

/* Prompt status */

#define DO_PROMPT               1
#define ORACLE_PROMPT           2
#define RENAME_PROMPT           3
#define RETITLE_PROMPT          4
#define LABEL_PROMPT            5
#define EDIT_GUY_PROMPT1        6
#define EDIT_ROOM_PROMPT1       7
#define EDIT_ITEM_PROMPT1       8
#define EDIT_MON_PROMPT1        9
#define EDIT_GUILD_PROMPT       10
#define SUICIDE_PROMPT          11
#define QUIT_PROMPT             12
#define RESIGN_PROMPT           13
#define CLOSE_GUILD_PROMPT      14
#define HUNTRESS_PROMPT         16
#define EDIT_PERM_PROMPT        17
#define DUMP_FILE_PROMPT        18
#define WHO_PROMPT              19
#define MEMBERS_PROMPT          20
#define ENTERING_CHAOS          21
#define REPORT_PROMPT           22
#define MAIN_MENU_PROMPT        23
#define DISPLAYING_POOBAHS      24
#define DISPLAYING_FAME         25
#define DISPLAYING_OBITS        26
#define DISPLAYING_WHERE        27
#define GET_PUB_BODY_PROMPT     28
#define READ_FORUM_PROMPT       29
#define GET_MSG_BODY_PROMPT     31
#define NEXT_MSG_PROMPT         32
#define ERASE_MSG_PROMPT        33
#define ENTERING_CLASS_PROMPT   34
#define SCRAWL_PROMPT           35
#define VOTE_PROMPT             36
#define ABDICATE_PROMPT         37
#define DANGER_MOVE_PROMPT      38
#define DANGER_GO_PROMPT        39
#define ENTERING_RACE_PROMPT    40
#define GUILD_SELL_PROMPT       41
#define EDIT_STORE_PROMPT       42
#define CONTAINER_PROMPT        43
#define SWITCH_PROMPT           45
#define OUTLAW_PROMPT           46
#define INVASION_MON_PROMPT     47
#define INVASION_MINS_PROMPT    48
#define INVASION_SIZE_PROMPT    49
#define INVASION_HEIR_PROMPT    50
#define INVASION_ROOM_PROMPT    51
#define INVASION_LEVEL_PROMPT   52
#define FINISHED_DOWNLOAD       53
#define EDIT_OFFICE_PROMPT      54
#define GAMEOP_PROMPT           55
#define LOCATE_ITEM_PROMPT      56
#define LOCATE_MON_PROMPT       57
#define CREATE_NUM_PROMPT       58
#define CREATE_LEVEL_PROMPT     59
#define ZAP_PROMPT              60
#define SUSPEND_PROMPT          61
#define BOUNTY_PROMPT1          62
#define BOUNTY_PROMPT2          63
#define PERMIT_PROMPT           64
#define GUILD_PROMPT            65
#define MEMBER_PROMPT           66
#define ACCEPT_PROMPT           67
#define BLACKBALL_PROMPT        68
#define APPOINT_PROMPT          69
#define DEBT_PROMPT1            70
#define DEBT_PROMPT2            71
#define OFFICE_PROMPT           72
#define VOTE_NAME_PROMPT        73
#define IMPEACH_PROMPT          74
#define ARREST_PROMPT1          75
#define ARREST_PROMPT2          76
#define FINE_MOVE_PROMPT        77
#define FINE_GO_PROMPT          78
#define PAROLE_PROMPT           79
#define PARDON_PROMPT1          80
#define PARDON_PROMPT2          81
#define PENALIZE_PROMPT1        82
#define PENALIZE_PROMPT2        83
#define EDIT_GUY_PROMPT2        84
#define EDIT_GUY_PROMPT3        85
#define EDIT_GUY_PROMPT4        86
#define EDIT_GUY_PROMPT5        87
#define EDIT_MON_PROMPT3        88
#define EDIT_MON_PROMPT5        89
#define EDIT_MON_PROMPT7        90
#define EDIT_MON_PROMPT9        91
#define EDIT_MON_PROMPT11       92
#define EDIT_MON_PROMPT13       93
#define EDIT_MON_PROMPT15       94
#define EDIT_ROOM_PROMPT3       95
#define EDIT_ROOM_PROMPT5       96
#define EDIT_ROOM_PROMPT7       97 
#define EDIT_ROOM_PROMPT9       98 
#define EDIT_ROOM_PROMPT11      99 
#define EDIT_ROOM_PROMPT13      100 
#define EDIT_ROOM_PROMPT15      101
#define EDIT_ITEM_PROMPT2       102
#define EDIT_ITEM_PROMPT3       103
#define EDIT_ITEM_PROMPT4       104
#define EDIT_ITEM_PROMPT5       105
#define EDIT_ITEM_PROMPT6       106
#define EDIT_ITEM_PROMPT7       107
#define EDIT_ITEM_PROMPT9       108
#define EDIT_ITEM_PROMPT11      109
#define EDIT_ITEM_PROMPT13      110
#define EDIT_ITEM_PROMPT14      111
#define EDIT_ITEM_PROMPT16      112
#define CHANT_PROMPT            113
#define BET_PROMPT              114
#define MAIL_PROMPT             115
#define POST_PROMPT             116
#define FORUM_PROMPT            117
#define CENSOR_PROMPT           118
#define POST_GUILD_PROMPT       119
#define GUILD_FORUM_PROMPT      120
#define READ_GUILD_FORUM_PROMPT 121
#define FAME_PROMPT             122
#define BANK_PROMPT             123
#define BANK_PROMPT1            124
#define BANK_PROMPT2            125
#define BANK_PROMPT3            126
#define BANK_PROMPT4            127
#define BANK_PROMPT5            128
#define TREASURY_PROMPT         129
#define TREASURY_PROMPT1        130
#define TREASURY_PROMPT2        131
#define TREASURY_PROMPT3        132
#define TREASURY_PROMPT4        133
#define MERC_PROMPT             134
#define MERC_PROMPT1            135
#define MERC_PROMPT2            136
#define ANNOUNCE_PROMPT         137
#define CONFIRM_SELL_PROMPT     138
#define ACADEMY_PROMPT          139
#define ACADEMY_PROMPT1         140
#define ACADEMY_PROMPT2         141

/* Huntress defines */

#define KILL_QUEST              1
#define ITEM_QUEST              2

/* Monster attacked vectors */

#define JAILED              1
#define ADD_EVIL            2
#define MORPH               3
#define AUTO_FLEE           4
#define NUM_ATT_VECTORS     5

/* Monster hit vectors */

#define POISONER            1
#define STEALER             2
#define DRAINER             3
#define PEST                4
#define NUM_HIT_VECTORS     5

/* summon options */

#define SUMMON_PERM         1
#define SUMMON_RANDOM       2
#define SUMMON_INVADER      3

/* "Find_Stuff" types */

#define FIND_ITEM           1
#define FIND_ITEM_MON       2
#define FIND_CRIT           3
#define FIND_CRIT_ROOM      4

/* Misc */

#define BAG_LIFE            (3600L * 24L * 180L)
#define DEATH               1
#define AUTOTRAIN           2
#define TRAININIT           3

#define ARENA_TIME          5
#define MYCYCLE             CYCLE
#define DATA3               "data3"

#ifdef SOC2
#define MSG_FILE            "MUISOC.MSG"  
#else
#define MSG_FILE            "MUICHAOS.MSG"
#endif

#define ITEM_CNF            "MAXITEM"
#define ROOM_CNF            "MAXROOM"
#define MON_CNF             "MAXMON"
#define NL                  "\r"
#define METAL_FACTOR        1
#define LEATHER_FACTOR      5
#define INVULNERABLE_BONUS  10
#define MAX_TRACKS          50
#define ASSASSIN_TIME       60
#define START_THIEF         5
#define RDWR                "r+b"
#define APPEND              "a+b"

#ifdef MBBS
#define READONLY            "r  "
#define WRITEA              "w+ "
#define READB               "rb "
#else
#define READONLY            "r"
#define WRITEA              "w+"
#define READB               "rb"
#endif

#define MAX_ORACLE_TRIES    50
#define OPEN_GUILD          "available"
#define SERVER_DEATH        1
#define USER_DEATH          2
#define MURDERED            3
#define BLANK_RECORD        "OPEN"
#if     !defined(TRUE) || ((TRUE) != 1)
#define TRUE    1
#endif
#if     !defined(FALSE) || ((FALSE) != 0)
#define FALSE   0
#endif
#define NO_SPELLS               0
#define WITH_SPELLS             1
#define GET_WORD                1
#define PARTIAL_DODGE           2
#define ACTIVE_QUESTS           1
#define INACTIVE_QUESTS         2
#define DO_RANDOM               1
#define NO_RANDOM               2
#define DO_MINIMUM              3
#define TO_MONSTER              0
#define QUOTES                  34
#define NEEDED                  0
#define ADD                     1
#define OFFENSIVE               1
#define DEFENSIVE               2
#define TOTAL_RESTORE           1
#define PARTIAL_RESTORE         0
#define VULNERABLE              2
#define PARRIED                 1
#define NORMAL                  0
#define FROM_BANK               0
#define FROM_GUILD              1
#define CLEAR_OLD               1
#define NO_CLEAR                0

#define DISTRIBUTE_EXPERIENCE   1
#define COUNT_ACTUALS           3
#define AVAILABLE_QUESTS        1
#define CURRENT_QUESTS          2

/* Trap types */

#define POISON_TRAP             1
#define BOMB_TRAP               2
#define TELEPORT_TRAP           3
#define LANGOUR_TRAP            4
#define SLEEP_TRAP              5
#define AGGRIVATION_TRAP        6
#define WEAKNESS_TRAP           7
#define DISPEL_TRAP             8
#define NUM_TRAPS               9

/* exit filters */

#define UNUSED_FILTER           10
#define ITEM_FILTER             11
#define CLASS_FILTER            12
#define RACE_FILTER             13
#define OFFICER_FILTER          14
#define GUV_FILTER              15
#define ASSASSIN_FILTER         16
#define PALADIN_FILTER          17
#define JUDGE_FILTER            18
#define LEVEL_FILTER            19
#define MAX_FILTERS             20

/* permission indexes */

#define PLAYER_EDIT_PERM        0
#define SUPER_PERM              1
#define NOHIT_PERM              2
#define KILLER_PERM             3
#define ROB_PERM                4
#define INVIS_PORT_PERM         5
#define ACTION_PERM             6
#define MPTS_PERM               7
#define GAMEOP_PERM             8
#define INTERCEPT_PERM          9
#define DEATH_PERM              10
#define EDIT_PERM               11
#define NUM_PERMS               12

/* Option indexes */

#define IGNORE_GLOBAL           1
#define SHORT_DESC              2
#define NO_SEND                 3
#define NO_DANGER               4
#define NO_GUILD                5
#define HEALTH_STATUS           6
#define NO_POOBAH               7
#define ALL_BRING               8
#define NO_TURF                 9
#define NO_SAY                  10
#define NO_COLOR                11
#define NOVICE                  12
#define NO_AUTO_COMBAT          13
#define NUM_OPTS                14

/* absolute match flags */

#define ABS_MON                 1
#define ABS_GUY                 2
#define ABS_ITM                 3

/* indexes for monster or guy routines */

#define GUY             g, -1
#define ME              P, -1
#define MON             -1, m

/* spells */

#define VIGOR                   0
#define LANGOUR                 1
#define HEAL                    2
#define SLEEP                   3
#define FEAR                    4
#define INVISIBILITY            5
#define PURIFY                  6
#define ENCHANT                 7
#define MESMERIZE               8
#define ELICITATION             9
#define PASS_DOOR               10
#define KEY                     11
#define MAGIC_KEY               12
#define TELEPORT                13
#define RESTORE                 14
#define PROTECT                 15
#define LIGHTNING               16
#define LEVITATE                17
#define VISION                  18
#define BLAST                   19
#define SEEK                    20
#define INVULNERABILITY         21
#define STRENGTH                22
#define MAGIC_CIRCLE            23
#define STURDINESS              24
#define ENHANCE                 25
#define WEAKNESS                26
#define BRING                   27
#define MAGIC_SHIELD            28
#define DISPEL_MAGIC            29
#define SAFE_RETURN             30
#define SEE_INVISIBLE           31
#define SUMMON                  32
#define HASTE                   33
#define STEALTH                 34
#define AGGRAVATE               35
#define MANIA                   36
#define SPY                     37
#define REVEAL                  38
#define CURSE                   39
#define FIREBALL                40
#define EXHAUSTION              41
#define ALCHEMY                 42
#define SHOCKWAVE               43
#define NUM_SPELLS              44
#define REPAIR                  1000

/* misc timer types */

#define RESET                   1
#define ADD_ON                  0
#define STURDY_TIME             1
#define MANIA_TIME              2
#define SLOW_TIME               3
#define CIRCLE_TIME             4
#define INVISIBLE_TIME          5
#define SEE_INVIS_TIME          6
#define SLEEP_TIME              7
#define INVULNERABLE_TIME       8
#define PROTECTED_TIME          9
#define SHIELD_TIME             10
#define STEALTH_TIME            11
#define MES_TIME                12
#define FLOAT_TIME              13
#define MAGNET_TIME             14
#define FAST_TIME               15
#define WEAK_TIME               16
#define KO_TIME                 17
#define STRONG_TIME             18
								
/* monster what's */

#define NPC             1
#define MONSTER         2
#define ANIMAL          3
#define WEIRD           4
#define HUMANOID        5
#define ORACLE          6
#define HUNTRESS        7
#define AWESOME         8
#define LONER           9
#define MAX_MON_WHAT    10

/* looking reponses */

#define NOT_FOUND       -1
#define NOT_UNIQUE      -3
#define NOT_THAT_MANY   -2

/* commands */

#define STATS                   1
#define BOUNTY                  2
#define OFFICES                 3
#define WHERE                   4
#define INSTILL                 5
#define DRAG                    6
#define DO                      7
#define VILLAINS                8
#define HELP                    9
#define LOOK                    10
#define NORTH                   11
#define SOUTH                   12
#define EAST                    13
#define WEST                    14
#define UP                      15
#define DOWN                    16
#define OUT                     17
#define SEARCH                  18
#define GO                      19
#define DUMP                    20
#define BERSERK                 21
#define SAVE                    22
#define EXPERIENCE              23
#define BURDEN                  24
#define INVENTORY               25
#define DROP                    26
#define GET                     27
#define GAMEOP                  28
#define WHO                     29
#define SEND                    30
#define BROADCAST               31
#define SAY                     32
#define DAYFILE                 33
#define TOSS                    34
#define IGNORE                  35
#define GUARD                   36
#define MACROS                  37
#define LISTEN                  38
#define HIDE                    39
#define TRACK                   40
#define USE                     41
#define FLEE                    42
#define FOLLOW                  43
#define LOSE                    44
#define GSEND                   45
#define TRANCE                  46
#define GIVE                    47
#define POOBAHS                 48
#define HIT                     49
#define BASH                    50
#define PARRY                   51
#define GREATBLOW               52
#define MAIL_MENU               53
#define DISPLAY_OTHERS          54
#define WHISPER                 55
#define CAST                    56
#define SPELLS                  57
#define HEALTH                  58
#define TALK                    59
#define ACTIVATE_MENU           60
#define TIMERS                  61
#define LABEL                   62
#define YELL                    63
#define SMASH                   64
#define GUILDS                  65
#define LIMBO                   66
#define OPTIONS                 67
#define SWAP                    68
#define STEAL                   69
#define DISPLAY_ITEMS           70
#define UNCAST                  71
#define NUM_COMMANDS            72
#define QUIT                    NUM_COMMANDS + 1

/* Color/Screen Constants */

#define CLEAR_SCREEN            "\x1B[2J"
#define CLEAR_RIGHT             "\x1B[2K"
#define red                     "\x1B[31m"
#define green                   "\x1B[32m"
#define white                   "\x1B[37m"
#define yellow                  "\x1B[33m"
#define magenta                 "\x1B[35m"
#define blue                    "\x1B[34m"
#define cyan                    "\x1B[0m\x1B[1m\x1B[36m"
#define BOLD                    "\x1B[0m\x1B[1m"

/* some message queue defines */

#define GLOBAL                  300
#define LOUD_LOCAL              400
#define QUIET_LOCAL             500
#define SAYING                  600
#define WHISPERING              650
#define GUILD_GLOBAL            700

/* Macros */

#define RAND(x) random(x)
#define INUM(x) abs(atoi(x))
#define LNUM(x) labs(atol(x))
#define BAD_EXIT return (0)
#define DONE return (0)
#define STATE usrptr->substt
#define NOW(x) strncpy(x, nctime(now()), TIME_SIZE - 1); x[TIME_SIZE - 1]=0
#define TODAY(x) strncpy(x, ncdate(today()), DATE_SIZE - 1); x[DATE_SIZE - 1]=0
#define CONV_DATE(x, y) strncpy(x, ncdate(y), DATE_SIZE - 1); x[DATE_SIZE-1]=0
#define ELAPSE(x) --x; if (x < 0) x = 0
#define ON_OFF(x) if (perm == x || perm < 0){ if (!guy->perm[x]) prfmsg(MSG276, x); else prfmsg(MSG277, x);} if (perm == x || perm < 0)
#define OFF_ON(x) if (opt==x || opt<0){ if (!guy->Option[x]) prfmsg(MSG276, x); else prfmsg(MSG277, x);} if (opt == x || opt < 0)
#define AGUY    Seek_Character(g)
#define AMON    Seek_Monster(m)
#define MY_PORT Seek_Port(P)
#define APORT(x) Seek_Port(x)
#define ABUF(x) Seek_Buffer(x)
#define EXTRA (guild->rooms_controlled[MY_PORT->room_owner] / globals->feefctr)
#define WEAPON_P(x) (x->what == EDGED || x->what == BLUNT || x->what == POLE || x->what == NOHAND)
#define ARSH_P(x) (x->what == ARMOR || x->what == SHIELD)
#define WEAPON(x) (x.what == EDGED || x.what == BLUNT || x.what == POLE || x.what == NOHAND)
#define ARSH(x) (x.what == ARMOR || x.what == SHIELD)
#define TYPE (ABUF(B)->rm.rmtype)
#define IN_GUILD (ABUF(B)->rm.rmtype < 0)
#define GUILD_NUM abs(ABUF(B)->rm.rmtype)
#define SAVED_AREA (TYPE < 0)
#define SAFE_AREA \
		( \
			TYPE == HAVEN || \
			ABUF(B)->rm.id == globals->townsq || \
			TYPE == MERCANTILE || \
			TYPE == BANK || \
			IN_GUILD || \
			TYPE == CLOSET || \
			TYPE == ACADEMY || \
			TYPE == ARMORY || \
			TYPE == WEAPONSMITH || \
			TYPE == HALL_OF_FAME || \
			TYPE == CLOSET || \
			TYPE == ALCHEMIST \
		)

#define SAFE_HAVEN \
		( \
			globals->next_room.rmtype == HAVEN || \
			globals->next_room.rmtype == ARENA || \
			globals->next_room.id == globals->townsq || \
			globals->next_room.rmtype == MERCANTILE || \
			globals->next_room.rmtype == BANK || \
			globals->next_room.rmtype < 0 || \
			globals->next_room.rmtype == CLOSET || \
			globals->next_room.rmtype == ACADEMY || \
			globals->next_room.rmtype == ARMORY || \
			globals->next_room.rmtype == WEAPONSMITH || \
			globals->next_room.rmtype == HALL_OF_FAME || \
			globals->next_room.rmtype == ALCHEMIST \
		)

#define me MY_PORT->chr
#define GUY_OR_MON g = -1; m = -1; if (i > 0) g = i - 1; else if (i < 0) m = (-i) - 1

#define INVASION_SIZE           sizeof(struct invasion_struct)
#define FREE_BAG_SIZE           sizeof(struct free_bag_struct)
#define STORE_SIZE              sizeof(struct store_struct)
#define GLOBALS_SIZE            sizeof(struct globals_struct)
#define DAYSIZE                 sizeof(struct day_struct)
#define OFFICE_SIZE             sizeof(struct office_struct)
#define POOBAH_SIZE             sizeof(struct poobah_struct)
#define TURF_SIZE               sizeof(struct turf_struct)
#define GUILD_INFO_SIZE         sizeof(struct guild_info_struct)
#define PURSUER_SIZE            sizeof(struct pursuer_struct)
#define ROOMSIZE                sizeof(struct room_struct)
#define F_ROOMSIZE              701
#define ROOM2_SIZE              sizeof(struct room2_struct)
#define PUBLIC_MSG_SIZE         sizeof(struct public_post_struct)
#define MSG_SIZE                sizeof(struct post_struct)
#define DEATH_STATS_SIZE        sizeof(struct death_stats_struct)
#define NEWS_SIZE               sizeof(struct news_struct)
#define RECORD_SIZE             sizeof(struct record_struct)
#define FAME_SIZE               sizeof(struct fame_struct)
#define SPEC_EXIT_SIZE          sizeof(struct spec_exit_struct)
#define MSGSIZE                 sizeof(struct msg_buff_struct)
#define ITEMSIZE                sizeof(struct item_struct)
#define F_ITEMSIZE              111
#define CLOSET_SIZE             sizeof(struct closet_struct)
#define CONTAINER_SIZE          sizeof(struct container_struct)
#define EDIT_INFO_SIZE          sizeof(struct edit_info_struct)
#define CHAR_SIZE               sizeof(struct charstruct)
#define MACRO_SIZE              sizeof(struct macro_struct)
#define ROOM_CACHE_SIZE         sizeof(struct room_cache_struct)
#define BRIEF_CHAR_SIZE         sizeof(struct brief_char_struct)
#define CRIT_SIZE               sizeof(struct crit_struct)
#define F_CRIT_SIZE             188
#define MON_SIZE                sizeof(struct mon_struct)
#define PORT_SIZE               sizeof(struct port_struct)
#define BUF_SIZE                sizeof(struct room_buffer_struct)
								
/* character file constants */

#define EXISTS          1
#define SUICIDE         2

/* special exit types */

#define NOT_SPECIAL     1
#define DOOR            2
#define MAGIC_DOOR      3
#define SPECIAL_DOOR    4
#define CHANT_DOOR      5
#define NUM_SPEC_TYPES  6

/* item types */

#define EDGED           1
#define BLUNT           2
#define MAGIC_DEV       3
#define ARMOR           4
#define SHIELD          5
#define POLE            6
#define CASH            7
#define JOOLS           8
#define TRINKET         9
#define NOHAND          10
#define CONTAINER       11
#define TALISMAN        12
#define TRANSPORTER     13
#define AMULET          14
#define PSY_FOCUS       15
#define MAX_ITEM_WHAT   16

/* item which's */

#define TWOHAND         1
#define LITE_ARMOR      2
#define LITE_WEP        3
#define SKELETON_KEY    4
#define SCROLL          5
#define NODROP          6
#define LITE_SHIELD     7
#define MAGIC_RING      8
#define MAGIC_CONT      9
#define SPECIAL_KEY     10
#define PUZZLE          11
#define MAX_ITEM_WHICH  12

/* room types */

#define ACADEMY         1
#define ARENA           2
#define ARMORY          3
#define HALL_OF_FAME    4
#define WATER_ROOM      5
#define MERCANTILE      6
#define BANK            7
#define HAVEN           8
#define BOAT            9
#define CLOSET          10
#define FIRE_ROOM       11
#define DAMAGE_ROOM     12
#define NO_CAST         13
#define NO_MAGIC        14
#define WEAPONSMITH     15
#define ALCHEMIST       16
#define UNUSED_RMTYPE   17
#define SOLO_ROOM       18
#define NUM_ROOM_TYPES  28

/* weapon skill index */

#define EDGED_IND       0
#define BLUNT_IND       1
#define POLE_IND        2
#define HAND_IND        3

/* structure definitions */

#define MAX_BAGS        50
#define MAX_OPEN_SLOTS  50

struct free_bag_struct
{
	short   index[MAX_BAGS];
	short   end[MAX_BAGS];
	MLONG   open[MAX_BAGS][MAX_OPEN_SLOTS];
};

#define ARTICLE_SIZE    5
#define LABEL_SIZE      10
#define ITEM_NOUN_SIZE  20
#define ITEM_NAME_SIZE  (ARTICLE_SIZE + LABEL_SIZE + ITEM_NOUN_SIZE)

struct  item_struct
{
	short   id;
	short   room;
	char    article[ARTICLE_SIZE];
	char    adjective[LABEL_SIZE];
	char    name[ITEM_NOUN_SIZE];
	short   what;
	short   which;
	short   item_level;
	MLONG   uses;
	short   spell_cast;
	short   bonus;
	MLONG   bag_index;
	short   ac;
	MLONG   worth;
	short   Hits;
	short   holding;
	short   merc_item;
	short   ring_used;
	short   permanant;
	short   labeled;
	short   finder;
	short   static_item;
	short   new_bag;
	MLONG   old_worth;
	short   text_file;
	short   org_item_level;
	short   no_instill;
	short   no_repair;
	short   infinite_uses;
	char    race;
	char    class;
	short   available[7];
};

#define TYPE_SIZE       11
#define DATE_SIZE       6
#define USERID_SIZE     UIDSIZ

struct  charstruct
{
	char    data3[6];
	char    name[NAME_LEN];
	char    title[TYPE_SIZE];
	char    Userid[USERID_SIZE];

	short   in_guild;
	short   guild_master;
	MLONG   guild_balance;
	short   public_read;

	short   Str;
	MLONG   str_exp;
	short   Dex;
	MLONG   dex_exp;
	short   Con;
	MLONG   con_exp;
	short   Psy;
	MLONG   psy_exp;
	short   Int;
	MLONG   int_exp;

	short   location;
	short   perm[NUM_PERMS];
	short   available1[1];
	MLONG   generic_exp;
	short   Option[NUM_OPTS];
	char    class;
	char    newbie;
	short   evil;
	short   vote_mins[NUM_OFFICES];
	short   available3[5];
	short   suspended;
	short   switches;

	short   thief;
	MLONG   thief_exp;
	short   shield;
	MLONG   shield_exp;
	short   two_wep;
	MLONG   two_wep_exp;
	short   wep_plus[NUM_WEAPONS];
	short   available4[3];
	MLONG   wep_exp[NUM_WEAPONS];
	short   available5[3];
	short   defense;
	MLONG   defense_exp;
			
	char    race;
	char    outlaw;
	short   dpts;
	short   damaged;
	short   mpts;
	short   magic_used;
			
	short   last_date;
	MLONG   bank;
	MLONG   gold;
	short   spell[NUM_SPELLS];
	short   available6[16];

	short   lw;
	short   rw;
	short   armor;
	short   shld;
	MLONG   secs_today;
	short   posts;
	short   ftg;
	short   lo_room, hi_room;
	short   lo_crit, hi_crit;
	short   lo_item, hi_item;
	short   guild_read;
	short   focus;
	short   poison_timer;
	short   available7[6];
	short   return_to;  

	struct  item_struct item[NUM_ITEMS];
};

#define MACRO_NAME_SIZE     10   

struct macro_struct
{
	char    macro_name[NUM_MACROS][MACRO_NAME_SIZE];
	char    macro_txt[NUM_MACROS][LINE_SIZE - 10];
};

#define PLURAL_SIZE     (NAME_LEN + 5)

#define TALK_SIZE   74

struct  crit_struct
{
	short   what;
	short   which;
	short   loc;
	char    article[ARTICLE_SIZE];
	char    name[NAME_LEN];
	char    plural_name[PLURAL_SIZE];
	short   Level;
	short   alg;
	short   spell_caster;
	short   magical;
	short   blocks;
	short   roving;
	short   permanant;
	short   Item[POSSIBLE_MON_ITEM];
	short   attacked_vector;
	char    talk[TALK_SIZE];
	short   hit_vector;
	short   huntress_item;
	short   morph;
	short   magic_immune;
	short   quests;
	short   evil_pts;
	MLONG   last_kill;
	short   kills;
	short   static_rover;
	short   look_text_file;
	short   talk_text_file;
	MLONG   perm_damage;
	short   available[7];
};

struct  mon_struct
{
	short   what;
	short   which;
	short   loc;
	char    article[ARTICLE_SIZE];
	char    name[NAME_LEN];
	char    plural_name[NAME_LEN + 5];
	short   Level;
	short   alg;
	short   spell_caster;
	short   magical;
	short   blocks;
	short   roving;
	short   permanant;
	short   Item[POSSIBLE_MON_ITEM];
	short   attacked_vector;
	char    talk[TALK_SIZE];
	short   hit_vector;
	short   huntress_item;
	short   morph;
	short   magic_immune;
	short   quests;
	short   evil_pts;
	MLONG   last_kill;
	short   kills;
	short   static_rover;
	short   look_text_file;
	short   talk_text_file;
	MLONG   perm_damage;
	short   available[7];
	short   bashed;
	short   next_hit;
	short   pursue_forever;
	short   summoned_by;
	short   Str;
	short   Dex;
	short   Con;
	short   Psy;
	short   Int;
	short   action_timer;
	short   misc_type[NUM_MON_TIMERS];
	short   timer[NUM_MON_TIMERS];
	short   heal_time;
	short   magic_time;
	short   bashed_time;
	MLONG   dpts, damage;
	MLONG   mpts, magic_used;
	MLONG   Tired;
	short   hurt_by[MAX_CHANNELS];
	short   hurters[MAX_CHANNELS]; 
	short   spelled_by[MAX_CHANNELS];
	short   tranced_by[MAX_CHANNELS];
	short   struck_by[MAX_CHANNELS];
	short   I_hit[MAX_CHANNELS];
	short   my_ac_was_lower[MAX_CHANNELS];
	short   easy_hit[MAX_CHANNELS];
	short   sees[MAX_CHANNELS];
	short   last_attacker;
	struct  item_struct item_has[MAX_MON_ITEM];
	short   item_used[MAX_MON_ITEM];
	char    spell[NUM_SPELLS];
	short   avail[10];
	short   hidden;
	short   enhanced;
};

#define DESCRIPTOR_SIZE 15
#define SPEC_ARTICLE_SIZE (ARTICLE_SIZE - 1)

struct  spec_exit_struct
{
	char    article[SPEC_ARTICLE_SIZE];
	char    adjective[LABEL_SIZE];
	char    descriptor[DESCRIPTOR_SIZE];
	short   type;
	short   locked;
	short   leads_to;
	short   Visible;
	short   filter;
};

#define DESC_LINES              6
#define DESC_SIZE               LINE_SIZE
#define CHANT_SIZE              40
#define TEXT_DESCRIPTOR_SIZE    21

struct  room_struct
{
	short   id;
	short   rmtype;
	char    desc[DESC_LINES][DESC_SIZE];
	short   exit[NUM_EXITS];
	short   Visible[NUM_EXITS];
	struct  spec_exit_struct spec_exit;
	short   monster_here[POSSIBLE_MONS];
	short   enc_chance;
	short   trap;
	short   cover;
	MLONG   door_index;
	short   no_teleport;
	short   town;   
	short   filter_spec;
	short   unused[2];
	char    chant[CHANT_SIZE];
	char    invaders;
	short   text_file;
	char    text_descriptor[TEXT_DESCRIPTOR_SIZE];
	char    items_or_mons;
	char    sticky_fix;
	char    evil_mons;
	char    mons;
	char    visible_mons;
	char    available[51];
};

#define SCRAWL_SIZE 68

struct room2_struct
{
	MLONG   Turf_Kills[NUM_SAVED_PLACES];
	char    scrawl[SCRAWL_SIZE];
	short   last_kill;
};

struct  room_buffer_struct 
{
	short   in_use;
	short   turf_change;
	short   item_change;
	short   crit_change;
	short   death_room;
	short   guy[MAX_CHANNELS];
	short   enc_speed;
	short   room_timer;
	short   yell;
	short   visible[NUM_EXITS + 1];
	struct  room_struct     rm;
	struct  room2_struct    rm2;
	struct  mon_struct      mon[MAX_ROOM_MON];
	struct  item_struct     item[NUM_ITEMS];
};

struct room_cache_struct
{
	struct  room_struct     rm;
	struct  room2_struct    rm2;
};

struct turf_struct
{
	short   controlled[NUM_SAVED_PLACES];
	short   index;
};

struct edit_info_struct
{
	short   i;
	short   b;
	short   p;
	short   active;
	short   index;
	short   item_num;
	short   room_num;
	short   office_num;
	char    where;
	char    old_name[NAME_LEN];
	struct  charstruct   a_char;
	struct  item_struct  item;
	struct  crit_struct  crit;
	struct  room_struct  room;
	struct  room2_struct room2;
};

#define COMMAND_SIZE        15
#define TIME_SIZE           6

struct  port_struct
{
	short   dragged;
	short   drag_mon;
	short   drag_guy;
	short   focused;
	short   announce;
	short   hot_menu;
	short   saying;
	char    misc_type[NUM_GUY_TIMERS];
	short   timer[NUM_GUY_TIMERS];
	short   misc;   /* catchall */
	short   misc2;  /* another catchall */
	MLONG   misc3;  /* ditto */
	short   invader_count;
	short   arena_timer;
	short   show_pts;
	short   last_bp;
	short   last_ftg;
	short   last_mp;
	FILE    *fp;
	MLONG   fine;
	char    need_lf;
	char    zapped;
	short   assassin_timer;
	short   arrest_timer;
	char    berserk;
	char    trance;
	char    guv, paladin, assassin, judge;
	short   turfing;
	short   finding;
	short   editing;
	short   status;
	short   old_credit_rate;
	short   B;
	short   usrnum;
	short   index;
	char    hidden;
	short   lucky_room;
	short   room_owner;
	short   can_quit;
	short   damage_timer;
	short   action_timer;
	short   last_attack;
	short   last_spell;
	short   limbo_return;
	short   big_sleep;
	short   enemy_mon;
	char    follower[MAX_CHANNELS];
	char    bashed;
	short   heal_time;
	short   magic_time;
	short   bashed_time;
	short   next_hit;
	MLONG   my_bet;
	char    intercepting;
	char    selling[NUM_ITEMS];
	char    ignore[MAX_CHANNELS];
	char    command[COMMAND_SIZE];
	char    death[LINE_LEN];
	char    last_input[LINE_LEN];
	char    next_input[LINE_LEN];
	char    input[LINE_LEN];
	char    time_on[TIME_SIZE];
	char    prompt[150];
	char    hung_up;
	char    warn_5;
	char    warn_1;

	char    quest_mon[NAME_LEN]; 
	short   questing;
	short   quests_left;
	short   quest_timer;
	short   quest_type;
	short   quest_reward;
	char    quest_thing[LINE_SIZE];

	short   find_r;
	short   find_i;
	short   find_m;
	char    str[30];

	struct  charstruct          chr;
	struct  turf_struct         turf;
	struct  edit_info_struct    edit;

	MLONG   secs_on;
	MLONG   experience;
	MLONG   theft_exp;
	MLONG   kills;
	MLONG   murders;
	MLONG   cash;
	MLONG   deaths;
	MLONG   thefts;
	MLONG   quests;
	MLONG   mon_level;
	MLONG   rovers;
	MLONG   invaders;
	MLONG   bounty_gold;
};

struct  closet_struct
{
	struct item_struct item[NUM_ITEMS];
};

#define CONTAINER_MAX 100

struct  container_struct
{
	MLONG   last_write; 
	struct  item_struct item[CONTAINER_MAX];
};

#define GUILD_NAME_SIZE 40

struct  guild_info_struct
{
	char    name[NUM_SAVED_PLACES][GUILD_NAME_SIZE];
	char    master_name[NUM_SAVED_PLACES][GUILD_NAME_SIZE];
	char    member_name[NUM_SAVED_PLACES][GUILD_NAME_SIZE];
	MLONG   dues[NUM_SAVED_PLACES];
	short   anyone_accept[NUM_SAVED_PLACES];
	short   rooms_controlled[NUM_SAVED_PLACES];
	short   status[NUM_SAVED_PLACES][NUM_SAVED_PLACES];
	MLONG   treasury[NUM_SAVED_PLACES];
};

struct pursuer_struct
{
	struct mon_struct mon[MAX_ROOM_MON];
};

struct  brief_char_struct
{
	char    name[NAME_LEN];
	char    Userid[USERID_SIZE];
	short   in_guild;
	short   guild_master;
	MLONG   guild_balance;
	short   last_date;
};          

struct  spell_info_struct
{
	short   index;
	char    name[30];
	short   power;
	short   pts;
	short   dur;
};          

struct  news_struct
{
	char    news[LINE_LEN];
};

#define QUESTS_DONE     0
#define EXP_EARNED      1
#define MAX_STATS       2
#define KILLS           3
#define MURDERS         4
#define CASH_FOUND      5
#define DEATHS          6
#define THEFTS          7
#define MON_LEVEL       8
#define SECS_ON         9
#define ROVER_KILLS     10
#define THEFT_EXP       11
#define INVADER_KILLS   12
#define BOUNTY_GOLD     13
#define MAX_FAME        14

struct  fame_struct
{
	char    date[MAX_FAME][DATE_SIZE];
	char    name[MAX_FAME][NAME_LEN];
	char    title[MAX_FAME][TYPE_SIZE];
	MLONG   record[MAX_FAME];
};

#define STAT_LEVELS             21

struct stat_struct
{
	MLONG   level;
	MLONG   factor;
	MLONG   base;
};

struct public_post_struct
{
	short   from;
	short   to;
	short   msg_num;
	char    header[LINE_LEN];
	char    body[MESSAGE_LEN][LINE_LEN];
};

struct post_struct
{
	char    from[LINE_LEN];
	char    body[MESSAGE_LEN][LINE_SIZE];
};

struct day_struct
{
	short   port;
	char    dateon[DATE_SIZE];
	char    timeon[TIME_SIZE];
	MLONG   secs;
	char    userid[USERID_SIZE];
};

#define DEMO_DAYS 14

struct demo_record_struct
{
	char    userid[UIDSIZ];
	char    modnam[MNMSIZ];
	short   install_date;
};

struct poobah_struct
{
	short   low_index;
	MLONG   pts[20];
	char    outlaw[20];
	short   level[20];
	short   index[20];
	short   user_index;
	short   w_index;
	MLONG   w_stats;
	short   s_index;
	MLONG   s_stats;
	short   b_index;
	MLONG   b_stats;
	short   t_index;
	MLONG   t_stats;
	short   d_index;
	MLONG   d_stats;
	short   c_index;
	MLONG   c_stats;
	short   m_index;
	MLONG   m_stats;
};

#define MAX_VOTES   500

struct office_struct
{
	short   office;
	short   index;
	short   last_vote;
	short   active;
	short   votes_for[MAX_VOTES];
	short   votes_by[MAX_VOTES];
};

struct room_exit_struct
{
	short   room_num;
	short   exit[NUM_EXITS + 1];
};

#define MAX_INVASION_ROOMS  20

struct invasion_struct
{
	short   active;
	short   timer;
	short   duration;
	short   crit;
	short   level;
	short   origin;
	short   num_left;
	short   room[MAX_INVASION_ROOMS];
	short   count[MAX_INVASION_ROOMS];
	struct  room_exit_struct old_rooms[MAX_INVASION_ROOMS];
};

struct store_struct
{
	short   new[MAX_MERC_ITEM];
	struct  item_struct old[NUM_ITEMS];
};

#define NUM_CAPTIVE_MOVES   200

struct globals_struct
{
	short   last_invasion_room;
	short   cachbufs;
	short   monleave;
	short   pursued;
	char    *textdir;
	char    *anncfile;
	short   invdtuff;
	short   yell2;
	short   autorpts;
	short   turfmons;
	short   poobvote;
	char    who[LINE_SIZE];
	char    txt[280];
	char    itxt[280];
	MLONG   monregen;
	short   extmon;
	short   mondd;
	short   sorcdd;
	short   thiefdd;
	short   barbdd;
	short   wardd;
	short   dueldd;
	short   mystdd1;
	short   mystdd2;
	short   clerdd1;
	short   clerdd2;
	short   ambush;
	short   ambushm;
	MLONG   barbbsk;
	short   itmboost;
	MLONG   warbonus;
	MLONG   duebonus;
	short   clebonus;
	short   sorbonus;
	MLONG   sordmg;
	short   mysbonus;
	MLONG   mysdmg;
	short   focus1;
	MLONG   focus2;
	MLONG   focus3;
	short   option7;
	short   robthfs;
	short   monspell;
	short   monreact;
	short   monrob;
	short   mongb;
	short   monbash;
	short   monparry;
	short   fexplev;
	short   xplev15;
	MLONG   perm_regen_timer;
	MLONG   item_regen_timer;
	MLONG   perm_mon_dmg[MAX_PERM_MON];
	short   perm_mon_loc[MAX_PERM_MON];
	short   perm_mon_id[MAX_PERM_MON];
	short   perm_item_loc[MAX_PERM_ITEM];
	short   perm_item_id[MAX_PERM_ITEM];
	short   next_bounty;
	short   next_bounty_mins;
	short   next_invader;
	short   next_invasion_mins;
	short   next_invasion_size;
	char    next_invasion_heir;
	short   next_invasion_room;
	short   next_invasion_level;
	char    *main_prompt1;
	char    *main_prompt2;
	char    *main_prompt3;
	char    *room1;     /* 259 */
	char    *room2;     /* 260 */
	char    *room3;     /* 261 */
	char    *cover1;    /* 553 */
	char    *cover2;    /* 554 */
	char    *cover3;    /* 555 */
	char    *cover4;    /* 556 */
	char    *turf1;     /* 718 */
	char    *turf2;     /* 719 */
	char    *turf3;     /* 720 */
	char    *turf4;     /* 721 */
	char    *turf5;     /* 722 */
	char    *turf6;     /* 723 */
	char    *north;     /* 227 */
	char    *south;     /* 228 */
	char    *east;      /* 229 */
	char    *west;      /* 230 */
	char    *up;        /* 231 */
	char    *down;      /* 232 */
	char    *out;       /* 233 */
	char    *captive;
	struct  crit_struct bounty;
	short   bounty_timer;
	short   captive_timer;
	short   captive_safe;
	short   captive_next_room;
	short   captive_moves[NUM_CAPTIVE_MOVES];
	short   captive_speed;
	struct  room_struct next_room;
	char    *intercept;
	struct  store_struct a_store;
	MLONG   maxgenxp;
	short   selldisc;
	short   buydisc;
	short   joekill1;
	short   joekill2;
	short   minarmor;
	short   minwep;
	short   minmagic;
	short   outlaws;
	short   sticky;
	char    *playkey;
	char    *guildkey;
	short   blurbon;
	char    *blurb;
	char    temp_buf[1025];
	char    poobing[256];
	char    eviling[256];
	char    destination[256];
	short   track_room[MAX_TRACKS];
	short   track_dir[MAX_TRACKS];
	short   old_p[MAX_CHANNELS];
	short   old_b[MAX_CHANNELS];
	char    path[LINE_SIZE];
	char    *msg61;
	char    *msg62;
	char    *msg103;
	char    *msg104;
	char    *msg105;
	char    *msg106;
	char    *msg107;
	char    *msg108;
	char    *msg109;
	char    *msg110;
	char    *msg111;
	char    *msg112;
	char    *msg113;
	char    *msg114;
	char    *msg1364;
	char    *msg1365;
	char    *msg1366;
	MLONG   rover_timer;
	char    *againkey;
	short   sysfame;
	short   minturf;
	struct  public_post_struct msg;
	MLONG   wepfactr;
	short   armfactr;
	short   shdfactr;
	short   combat;
	short   daymins;
	short   talindex;
	MLONG   slowtics;
	short   turfmin;
	short   autobank;
	short   evilness;
	short   bagtals;
	short   bntyitem;
	short   invasmin;
	short   invasmax;
	MLONG   instlgld;
	short   minint;
	short   votemins;
	short   votestat;
	short   votedays;
	short   voteterm;
	short   inactdys;
	short   namesize;
	short   pvplevel;
	short   rovrsecs;
	short   invdsecs;
	short   rover;
	short   bntymins;
	short   gldmsmx;
	short   validus_users;
	short   demo;
	char    *actcode;
	char    *sysopkey;
	char    *socvote;
	char    *g1;
	char    *g2;
	char    *g3;
	char    *g4;
	char    *g5;
	short   maxuser;
	short   maxroom;
	short   maxmon;
	short   maxitem;
	short   socccr;
	short   wephits;
	short   huntmins;
	short   huntqsts;
	MLONG   oraclegd;
	short   strfctr;
	short   baguses;
	short   baseexp;
	short   monexp;
	short   encrate;
	short   flubfctr;
	short   goldfctr;
	short   treasure;
	short   statcurv;
	short   bashftg;
	short   moveftg;
	short   folchnc;
	short   bashtime;
	short   gbftg;
	short   turfdur;
	short   hitftg;
	short   ringdur;
	short   curvecut;
	short   strtstat;
	short   noteable;
	short   feefctr;
	MLONG   armorwgt;
	MLONG   shldwgt;
	MLONG   wepwgt;
	short   miscwgt;
	short   limboloc;
	short   thiefexp;
	short   escape;
	short   startgld;
	MLONG   cheapexp;
	MLONG   bonusexp;
	short   speedbon;
	short   start2wp;
	short   startshd;
	short   shoplevl;
	short   twohndst;
	short   wakeup;
	short   basempts;
	short   ttrack;
	short   tfollow;
	short   thide;
	short   tlose;
	short   tstealth;
	short   tlock;
	short   tambush;
	short   townsq;
	short   newsstnd;
	short   prison;
	short   sanctum;
	short   abank;
	short   amerc;
	short   anacad;
	char    *offices[NUM_OFFICES]; 
	short   officers[NUM_OFFICES];
	char    *badchars;
	short   maxposts;
};

#ifndef EDITOR
#include <proto.h>
#endif
