/***************************************************************************
 *                                                                         *
 *   UPLOAD.C                                                              *
 *                                                                         *
 *   Copyright (C) 1987 GALACTICOMM, Inc.      All Rights Reserved.        *
 *                                                                         *
 *   This is the demo board upload utility.                                *
 *                                                                         *
 *                                            - T. Stryker 3/29/87         *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "majorbbs.h"
#include "usracc.h"
#include "dnuload.h"
 
int iniupl(),upload(),upsthn(),uplhup(),clsupl();
 
#define UPLSTT      07        /* upload utility state                 */
struct module module07={      /* module interface block               */
     'U',                     /*    main menu select character        */
     "Upload utility",        /*    description for main menu         */
     &iniupl,                 /*    system initialization routine     */
     NULL,                    /*    user logon supplemental routine   */
     &upload,                 /*    input routine if selected         */
     &upsthn,                 /*    status-input routine if selected  */
     &uplhup,                 /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     &clsupl                  /*    finish-up (sys shutdown) routine  */
};
 
#define UPTMAX 1000000L       /* upload dir total bytes max at upload start*/
#define UP1MAX 200000L        /* maximum upload size per file              */
#define FNSIZE 23             /* maximum filespec size (non-sysop 12 only) */
 
static
struct uplusr {               /* upload utility user data blocks           */
     char filnam[FNSIZE+1];   /*   file name specified for upload          */
     long filen;              /*   cumulative length used for max test     */
     int secctr;              /*   seconds counter for timeouts            */
     int xmblkn;              /*   XMODEM block number in effect           */
     FILE *fp;                /*   file pointer when actually uploading    */
} upldat[NTERMS],*updptr;
 
extern
FILE *dnumb,*opnmsg();        /* down/up named-message file block pointer  */
extern
int numdnu;                   /* number of users down/uploading at moment  */
 
extern
struct usracc usracc[NTERMS], /* user accounting block array               */
              *usaptr;        /* user accounting block pointer for usrnum  */
extern
int usrnum;                   /* global user-number (channel) in effect    */
extern
struct user *usrptr,          /* global pointer to user data in effect     */
            user[NTERMS];     /* user volatile-data structure array        */
extern
char input[INPSIZ],           /* raw user input data buffer                */
     *margv[INPSIZ/2];        /* array of ptrs to word starts, a la argv[] */
extern
int margc,                    /* number of words in margv[], a la argc     */
    status;                   /* raw status from btusts, where appropriate */
extern
struct sysvbl sv;             /* sys-variables record instance for updates */
 
#define ACK  6                /* ASCII controls chars used in XMODEM       */
#define NAK 21
#define SOH  1
#define EOT  4
#define CAN 24
 
iniupl()
{
     if (dnumb == NULL) {
          dnumb=opnmsg("dnuload.mcv");
     }
     uplrti();
}
 
upload()
{
     int c,newstt;
     char *tptr;
     long upltot();
 
     setmbk(dnumb);
     updptr=&upldat[usrnum];
     switch (newstt=usrptr->substt) {
     case 0:
          if (usrptr->class < PAYING) {
               prfmsg(UPLIVE);
               return(0);
          }
          else if (numdnu >= 8) {
               prfmsg(UPDNUF);
               return(0);
          }
          else if (upltot() > UPTMAX-UP1MAX
            && !sameas(usaptr->userid,"Sysop")) {
               prfmsg(UPFULL);
               return(0);
          }
          else {
               numdnu+=1;
               prfmsg(newstt=WFIHLP);
          }
          break;
     case WFIHLP:
     case WHATFI:
          if (margc == 0) {
               prfmsg(WHATFI);
          }
          else if (margc > 1 || input[0] == 32) {
               prfmsg(RENTFI);
          }
          else if (sameas(input,"x")) {
               numdnu-=1;
               prfmsg(EXIUPL);
               return(0);
          }
          else if (sameas(input,"?") || sameas(input,"help")) {
               prfmsg(WFIHLP);
          }
          else if (!fileok()) {
               prfmsg(CANTUP);
          }
          else {
               strcpy(updptr->filnam,input);
               strcpy(input,"upllib\\");
               strcat(input,updptr->filnam);
               if (!sameas(usaptr->userid,"Sysop")
                 && (updptr->fp=fopen(input,"rb")) != NULL) {
                    fclose(updptr->fp);
                    prfmsg(DUPLUP);
               }
               else if ((updptr->fp=fopen(input,"wb")) == NULL) {
                    prfmsg(CANTUP);
               }
               else {
                    prfmsg(newstt=UPMODE);
               }
          }
          break;
     case UPMODE:
          if (sameas(input,"x")) {
               numdnu-=1;
               prfmsg(EXIUPL);
               fclose(updptr->fp);
               return(0);
          }
          else if (margc == 0 || margc > 1 || (c=atoi(input)) < 1 || c > 2) {
               prfmsg(UPMODH);
          }
          else if (c == 1) {
               usrptr->flags|=NOINJO;
               btumil(usrnum,INPSIZ);
               prfmsg(newstt=UPASC);
               updptr->secctr=0;
               updptr->filen=0L;
          }
          else {
               usrptr->flags|=NOINJO;
               btumil(usrnum,INPSIZ);
               prfmsg(newstt=UPXMDM);
               btutrg(usrnum,132);
               updptr->secctr=10;
               updptr->xmblkn=1;
               updptr->filen=0L;
          }
          break;
     case UPASC:
          rstrin();
          if (!sameas(input,"OK")) {
               if (btuibw(usrnum) > INPSIZ/2) {
                    btuxmt(usrnum,"\23");         /* CTRL-S */
                    updptr->secctr=2;
               }
               if ((updptr->filen+=strlen(input)+2) < UP1MAX
                || sameas(usaptr->userid,"Sysop")) {
                    fprintf(updptr->fp,"%s\r\n",input);
                    return(1);
               }
          }
          fprintf(updptr->fp,"\32");
          fclose(updptr->fp);
          prfmsg(newstt=UPDONE,updptr->filnam);
          usrptr->flags&=~NOINJO;
          btumil(usrnum,DFTIMX);
          sv.uplds+=1;
          break;
     case UPDONE:
          for (tptr=input ; *tptr != '\0' && !isalpha(*tptr) ; tptr++) {
          }
          if ((c=tolower(*tptr)) != 'y' && c != 'n' && c != 'x') {
               prfmsg(UPMORE);
          }
          else if (c == 'y') {
               prfmsg(newstt=WHATFI);
          }
          else {
               numdnu-=1;
               prfmsg(EXIUPL);
               return(0);
          }
          break;
     }
     outprf(usrnum);
     usrptr->substt=newstt;
     return(1);
}
 
uplrti()
{
     setmbk(dnumb);
     for (usrnum=0 ; usrnum < NTERMS ; usrnum++) {
          usrptr=&user[usrnum];
          usaptr=&usracc[usrnum];
          if (usrptr->state == UPLSTT) {
               updptr=&upldat[usrnum];
               uprtch();
          }
     }
     rtkick(1,&uplrti);
}
 
uprtch()
{
     switch (usrptr->substt) {
     case UPASC:
          if (updptr->secctr != 0 && --(updptr->secctr) == 0) {
               btuxmt(usrnum,"\21");                   /* CTRL-Q */
          }
          break;
     case UPXMDM:
          if (btuibw(usrnum) < 130) {
               setmem(input,sizeof(input),0);
               btuict(usrnum,input);
               if (input[0] == EOT
               || (updptr->filen > UP1MAX && !sameas(usaptr->userid,"Sysop"))) {
                    btuxmt(usrnum,"\6");               /* ACK, done */
                    btucli(usrnum);
                    prfmsg(usrptr->substt=UPDONE,updptr->filnam);
                    outprf(usrnum);
                    fclose(updptr->fp);
                    usrptr->flags&=~NOINJO;
                    btumil(usrnum,DFTIMX);
                    btutrg(usrnum,0);
                    sv.uplds+=1;
                    break;
               }
               else if ((updptr->secctr&1) && input[0] != SOH) {
                    updptr->secctr-=1;
                    btuxmt(usrnum,"\25");              /* NAK */
                    btucli(usrnum);
                    break;
               }
          }
          if (--(updptr->secctr) <= 0) {
               updptr->secctr=10;
               btuxmt(usrnum,"\25");                   /* NAK */
               btucli(usrnum);
          }
          break;
     }
}
 
upsthn()
{
     setmbk(dnumb);
     updptr=&upldat[usrnum];
     switch (usrptr->substt) {
     case UPXMDM:
          if (status == INBLK) {
               updptr->secctr=10;
               btuict(usrnum,input);
               if (input[0] != SOH) {
                    btuxmt(usrnum,"\25");              /* NAK */
               }
               else if (input[1] == ((updptr->xmblkn-1)&0xFF)
                     && input[2] == (((updptr->xmblkn-1)^0xFF)&0xFF)) {
                    btuxmt(usrnum,"\6");               /* ACK but ignore */
               }
               else if (input[1] == (updptr->xmblkn&0xFF)
                     && input[2] == ((updptr->xmblkn^0xFF)&0xFF)
                     && cksumv(input+3,128) == input[131]) {
                         btuxmt(usrnum,"\6");          /* ACK and accept */
                         updptr->xmblkn+=1;
                         fwrite(input+3,1,128,updptr->fp);
                         updptr->filen+=128;
               }
               else {
                    btuxmt(usrnum,"\25");              /* NAK */
               }
          }
          break;
     }
     if (status != INBLK) {
          dfsthn();
     }
}
 
uplhup()
{
     updptr=&upldat[usrnum];
     if (usrptr->state == UPLSTT) {
          numdnu-=1;
          switch (usrptr->substt) {
          case UPMODE:
          case UPASC:
          case UPXMDM:
               fprintf(updptr->fp,"\r\n\r\n*** LOST CARRIER ***\r\n\32");
               fclose(updptr->fp);
               break;
          }
     }
     setmem(updptr,sizeof(struct uplusr),0);
}
 
long upltot()
{
     long retval=0;
     extern long ffllen;
 
     if (fnd1st("upllib\\*.*")) {
          do {
               retval+=ffllen;
          } while (fndnxt());
     }
     return(retval);
}
 
clsupl()
{
     if (dnumb != NULL) {
          clsmsg(dnumb);
          dnumb=NULL;
     }
}
