/***************************************************************************
 *                                                                         *
 *   TYPUACC.C                                                             *
 *                                                                         *
 *   Copyright (C) 1986, 1987 by GALACTICOMM, Inc.  All Rights Reserved.   *
 *                                                                         *
 *   This is the account file formatter (human-readable output) mainline.  *
 *                                                                         *
 *                                            - T. Stryker 10/20/86        *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "setjmp.h"
#include "btvstf.h"
#include "majorbbs.h"
#include "usracc.h"
 
extern jmp_buf disaster;      /* master error-recovery longjmp save block  */
 
main()
{
     BTVFILE *fp;
     struct usracc acct;
     long numact,numpai,numale,numfem,usetot,usefre,usepai,useavl;
     static char *filnam={"usracc.dat"};
 
     if (setjmp(&disaster)) {
          exit();
     }
     numact=0L;
     numpai=0L;
     numale=0L;
     numfem=0L;
     usetot=0L;
     usefre=0L;
     usepai=0L;
     useavl=0L;
     fp=opnbtv(filnam,sizeof(struct usracc));
     setbtv(fp);
     if (!qlobtv(0)) {
          catastro("file is empty!");
     }
     do {
          gcrbtv(&acct,0);
          fprintf(stdout,"USER-ID: %-10s PASSWORD: %-10s SYSTYP: %d  SCNWID: %2d  AGE: %2d  SEX: %c\n",
             acct.userid,acct.psword,acct.systyp,acct.scnwid,acct.age,acct.sex);
          fprintf(stdout,"%-48s %30s\n",acct.usrnam,acct.usrad1);
          fprintf(stdout,"%s, %s   Phone: %s\n",
             acct.usrad2,acct.usrad3,acct.usrpho);
          fprintf(stdout,"Created %s, Last Used %s   Non-live time: %ld minutes\n",
             acct.credat,acct.usedat,acct.frescu/60L);
          fprintf(stdout,"CREDITS:      %ld total      %ld paid      %ld available\n\n",
             acct.tcktot,acct.tckpai,acct.tckavl);
          numact+=1;
          if (acct.tckpai != 0L) {
               numpai+=1;;
          }
          if (acct.sex == 'M') {
               numale+=1;
          }
          else {
               numfem+=1;
          }
          usetot+=acct.frescu+(acct.tcktot-acct.tckavl);
          usefre+=acct.frescu;
          usepai+=max(0L,acct.tckpai-acct.tckavl);
          useavl+=min(acct.tckpai,acct.tckavl);
     } while (qnxbtv());
     clsbtv(fp);
 
     fprintf(stdout,"\14\nTotal Accounts:  %ld\n",numact);
     fprintf(stdout,"Paying Accounts: %ld\n",numpai);
     fprintf(stdout,"Male Accounts:   %ld\n",numale);
     fprintf(stdout,"Female Accounts: %ld\n",numfem);
     fprintf(stdout,"\nTotal Usage:          %ld user-hours\n",usetot/3600L);
     fprintf(stdout,"Total Non-Live Usage: %ld user-hours\n",usefre/3600L);
     fprintf(stdout,"Total Paid Usage:     %ld user-hours\n",usepai/3600L);
     fprintf(stdout,"Total Paid Time Left: %ld user-hours\n",useavl/3600L);
 
}
 
