/***************************************************************************
 *                                                                         *
 *   MSGUTL.C                                                              *
 *                                                                         *
 *   Copyright (C) 1987 GALACTICOMM, Inc.      All Rights Reserved.        *
 *                                                                         *
 *   This file contains a library of routines for dealing with .MCV files  *
 *   (output from MSGIDX).  These routines allow the converted messages    *
 *   to be retrieved by message number, which will generally be done thru  *
 *   the symbolic names "#defined" in MSGIDX's output header file.         *
 *                                                                         *
 *                                            - T. Stryker 6/10/86         *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
 
#define MBFSIZ 2001                /* maximum size of each msg (incl '\0') */
 
struct msgblk {                    /* named-message file block             */
     FILE *msgfp;                  /*   fopen()-style file block pointer   */
     int msgcnt;                   /*   count of messages in this file     */
     long *msgloc;                 /*   dynam-alloc'd fseek() msg offsets  */
};
 
static char *msgbuf=NULL;          /* message text buffer                  */
 
struct msgblk *opnmsg(mcvfil)
char *mcvfil;
{
     char *alcmem();
     struct msgblk *mb;
 
     mb=(struct msgblk *)alcmem(sizeof(struct msgblk));
     if ((mb->msgfp=fopen(mcvfil,"rb")) == NULL) {
          catastro("INIMSG: CAN'T OPEN \"%s\" FOR INPUT",mcvfil);
     }
     if (fread(&(mb->msgcnt),sizeof(int),1,mb->msgfp) != 1) {
          catastro("INIMSG: CAN'T READ COUNT IN \"%s\"",mcvfil);
     }
     mb->msgloc=(long *)alcmem(mb->msgcnt*sizeof(long));
     if (fread(mb->msgloc,sizeof(long),mb->msgcnt,mb->msgfp) != mb->msgcnt) {
          catastro("INIMSG: CAN'T READ POINTERS IN \"%s\"",mcvfil);
     }
     mb->msgcnt-=1;
     return(mb);
}
 
char *getmsg(mb,msgnum)
struct msgblk *mb;
int msgnum;
{
     char *alcmem();
     long msgbgn;
 
     if (msgbuf == NULL) {
          msgbuf=alcmem(MBFSIZ);
     }
     if (msgnum < 0 || msgnum >= mb->msgcnt) {
          catastro("GETMSG: MESSAGE NO. %d OUT OF RANGE",msgnum);
     }
     msgbgn=mb->msgloc[msgnum];
     if (fseek(mb->msgfp,msgbgn,0) != 0) {
          catastro("GETMSG: ERROR SEEKING MESSAGE NO. %d",msgnum);
     }
     if (fread(msgbuf,(int)(mb->msgloc[msgnum+1]-msgbgn),1,mb->msgfp) != 1) {
          catastro("GETMSG: ERROR READING MESSAGE NO. %d",msgnum);
     }
     return(msgbuf);
}
 
clsmsg(mb)
struct msgblk *mb;
{
     if (mb != NULL) {
          fclose(mb->msgfp);
          deamem(mb->msgloc,mb->msgcnt*sizeof(long));
          deamem(mb,sizeof(struct msgblk));
          if (msgbuf != NULL) {
               deamem(msgbuf,MBFSIZ);
               msgbuf=NULL;
          }
     }
}
