/***************************************************************************
 *                                                                         *
 *   MJRTLC.C                                                              *
 *                                                                         *
 *   Copyright (C) 1987 GALACTICOMM, Inc.      All Rights Reserved.        *
 *                                                                         *
 *   This is the Major BBS default teleconference handler.                 *
 *                                                                         *
 *                                            - T. Stryker 6/29/86         *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "majorbbs.h"
#include "usracc.h"
#include "mjrtlc.h"
 
int initlc(),telecn(),dfsthn(),tlchup(),clstlc();
 
#define TLCSTT      01        /* teleconferencing state               */
struct module module01={      /* module interface block               */
     'T',                     /*    main menu select character        */
     "Teleconferencing",      /*    description for main menu         */
     &initlc,                 /*    system initialization routine     */
     NULL,                    /*    user logon supplemental routine   */
     &telecn,                 /*    input routine if selected         */
     &dfsthn,                 /*    status-input routine if selected  */
     &tlchup,                 /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     &clstlc                  /*    finish-up (sys shutdown) routine  */
};
 
#define MAXFRE 32767          /* top freeloader telecon channel       */
 
static
FILE *tlcmb,*opnmsg();        /* teleconf named-message file block pointer */
static
struct tlc {                  /* teleconference per-user volatile data     */
     int flags;               /*   telecon user "flag" bits                */
     int paged;               /*   intervals-since-last-paged counter      */
     unsigned channel;        /*   teleconference channel number in use    */
     int inpcnt;              /*   input message counter for freeloaders   */
} tlclst[NTERMS];             /* one to a customer                         */
 
                              /* definition of telecon user bit "flags"    */
#define NOPAGE 1              /*   user page-flag set to "off"             */
#define SHWCHN 2              /*   user's channel is displayed in scan     */
 
#define NPAYMX 10             /* max times can talk per session if no pay  */
 
extern
struct usracc usracc[NTERMS], /* user accounting block array               */
              *usaptr;        /* user accounting block pointer for usrnum  */
extern
int usrnum;                   /* global user-number (channel) in effect    */
extern
struct user *usrptr,          /* global pointer to user data in effect     */
            user[NTERMS];     /* user volatile-data structure array        */
extern
char input[INPSIZ],           /* raw user input data buffer                */
     *margv[INPSIZ/2];        /* array of ptrs to word starts, a la argv[] */
extern
int margc,                    /* number of words in margv[], a la argc     */
    inplen,                   /* overall raw input string length           */
    status,                   /* raw status from btusts, where appropriate */
    pfnlvl;                   /* profanity level of current input (0-3)    */
 
extern int othusn;            /* general purpose other-user channel number */
extern struct user *othusp;   /* gen purp other-user user structure ptr    */
extern struct usracc *othuap; /* gen purp other-user accounting data ptr   */
 
initlc()
{
     int tlctck();
 
     tlcmb=opnmsg("mjrtlc.mcv");
     rtkick(10,&tlctck);
}
 
telecn()
{
     unsigned actchn;
     int sysop;
 
     setmbk(tlcmb);
     switch (usrptr->substt) {
     case 0:
          prfmsg(ENTTLC,usaptr->userid);
          outtlc();
          prfmsg(INTRO);
          tlcctx();
          btupmt(usrnum,':');
          usrptr->substt=1;
          break;
     case 1:
          if (margc == 0) {
               tlcctx();
               break;
          }
          if (margc == 1 && (sameas(margv[0],"?")
                || sameas(margv[0],"'?'")
                || sameas(margv[0],"\"?\"")
                || sameas(margv[0],"help"))) {
               prfmsg(TLCHLP);
               break;
          }
          if (sameas(margv[0],"page") && margc < 3) {
               page();
               break;
          }
          if (margc == 1 &&
            (sameas(margv[0],"exit") || sameas(margv[0],"x"))) {
               prfmsg(LVITLC,usaptr->userid);
               outtlc();
               prfmsg(EXITLC);
               btupmt(usrnum,0);
               return(0);
          }
          if (margc == 1 && sameas(margv[0],"scan")) {
               sysop=sameas(usaptr->userid,"Sysop");
               prf("USER-ID ...... CHANNEL\r");
               for (othusn=0 ; othusn < NTERMS ; othusn++) {
                    if (user[othusn].state == TLCSTT) {
                         prf("%-11s... ",usracc[othusn].userid);
                         if ((tlclst[othusn].flags&SHWCHN) || sysop
                           || tlclst[othusn].channel == 0) {
                              prf("%5u\r",tlclst[othusn].channel+1);
                         }
                         else {
                              prf("(Unlisted)\r");
                         }
                    }
               }
               break;
          }
          if (margc == 1 && sameas(margv[0],"unlist")) {
               tlclst[usrnum].flags&=~SHWCHN;
               prfmsg(UNLSTC);
               break;
          }
          if (margc == 1 && sameas(margv[0],"list")) {
               tlclst[usrnum].flags|=SHWCHN;
               prfmsg(LSTCHN);
               break;
          }
          if (margc <= 2 && sameas(margv[0],"channel")) {
               if (margc == 1) {
                    prfmsg(WHATCH,tlclst[usrnum].channel+1);
               }
               else if (sscanf(margv[1],"%d",&actchn) != 1 || actchn == 0) {
                    prfmsg(OUTORG);
               }
               else if (actchn == tlclst[usrnum].channel+1) {
                    prfmsg(YOURCH);
               }
               else if (actchn > MAXFRE && usrptr->class < PAYING) {
                    prfmsg(PAYONL);
               }
               else {
                    prfmsg(LEFTCH,usaptr->userid);
                    outtlc();
                    tlclst[usrnum].channel=actchn-1;
                    prfmsg(CAMEIN,usaptr->userid);
                    outtlc();
                    tlcctx();
               }
               break;
          }
          if (usrptr->pfnacc > MAXPFN) {
               btuinj(usrnum,RING);
               return(1);
          }
          if (pfnlvl >= 2 && usrptr->pfnacc > WRNPFN) {
               prfmsg(RAUNCH);
               break;
          }
          if (pfnlvl > 2) {
               prfmsg(PFNWRD);
               break;
          }
          if (usrptr->class < PAYING && (tlclst[usrnum].inpcnt)++ >= NPAYMX) {
               prfmsg(NPAYXC);
               break;
          }
          if (sameas(margv[0],"whisper")) {
               whisper();
               break;
          }
          rstrin();
          prf("***\rFrom %s: %s\r",usaptr->userid,input);
          outtlc();
          if (chncnt() == 1) {
               prfmsg(BYSELF,tlclst[usrnum].channel+1);
          }
          else {
               prf("-- Message sent --\r");
          }
          break;
     }
     outprf(usrnum);
     return(1);
}
 
tlcctx()
{
     char *tlsrui(),*onebck,*curguy;
     unsigned chan;
 
     initls();
     chan=tlclst[usrnum].channel+1;
     switch (chncnt()) {
     case 1:
          prfmsg(BYSELF,chan);
          break;
     case 2:
          prfmsg(ONEOTH,tlsrui(),chan);
          break;
     case 3:
          prfmsg(TWOOTH,tlsrui(),tlsrui(),chan);
          break;
     default:
          prf("\r");
          onebck=tlsrui();
          while ((curguy=tlsrui()) != NULL) {
               prf("%s, ",onebck);
               onebck=curguy;
          }
          prfmsg(SEVOTH,onebck,chan);
     }
     prfmsg(IROEPI);
}
 
page()
{
     char *heshe();
 
     if (margc != 2) {
          prfmsg(PAGFMT);
     }
     else if (!onsys(margv[1])) {
          if (sameas(margv[1],"on")) {
               tlclst[usrnum].flags&=~NOPAGE;
               prfmsg(PAGTON);
          }
          else if (sameas(margv[1],"off")) {
               tlclst[usrnum].flags|=NOPAGE;
               prfmsg(PAGTOF);
          }
          else {
               prfmsg(PAGNON,margv[1]);
          }
     }
     else if (tlclst[othusn].flags&NOPAGE) {
          prfmsg(PAGOFF,othuap->userid);
     }
     else if (tlclst[othusn].paged) {
          prfmsg(PAGL2M,othuap->userid);
     }
     else if (othusp->state == TLCSTT &&
         tlclst[othusn].channel == tlclst[usrnum].channel) {
          prfmsg(PAGATC,othuap->userid,heshe(othusn));
     }
     else {
          prfmsg(PAGMSG,usaptr->userid,tlclst[usrnum].channel+1);
          if (injoth()) {
               tlclst[othusn].paged=8;
               prfmsg(PAGEOK,othuap->userid);
          }
          else {
               prfmsg(PAGNPS,othuap->userid);
          }
     }
}
 
chncnt()
{
     int i,cnt;
     unsigned chan;
 
     chan=tlclst[usrnum].channel;
     for (i=0,cnt=0 ; i < NTERMS ; i++) {
          if (user[i].state == TLCSTT && tlclst[i].channel == chan) {
               cnt+=1;
          }
     }
     return(cnt);
}
 
char *heshe(usr)
int usr;
{
     return(usracc[usr].sex == 'M' ? "he" : "she");
}
 
whisper()
{
     if (margc < 4) {
          prfmsg(WHSFMT);
     }
     else if (!instat(margv[2],TLCSTT)
       || tlclst[othusn].channel != tlclst[usrnum].channel) {
          prfmsg(WHSNHR,margv[2]);
     }
     else {
          rstrin();
          prfmsg(WHSTO,usaptr->userid,margv[3]);
          outprf(othusn);
          prf("-- Message sent only to %s --\r",othuap->userid);
     }
}
 
outtlc()
{
     for (othusn=0,othusp=user ; othusn < NTERMS ; othusn++,othusp++) {
          if (othusn != usrnum && othusp->state == TLCSTT) {
               if (tlclst[usrnum].channel == tlclst[othusn].channel) {
                    outprf(othusn);
               }
          }
     }
     clrprf();
}
 
tlctck()
{
     struct tlc *tlcptr;
 
     for (othusn=0,tlcptr=tlclst ; othusn < NTERMS ; othusn++,tlcptr++) {
          if (tlcptr->paged != 0) {
               tlcptr->paged-=1;
          }
     }
     rtkick(15,&tlctck);
}
 
initls()
{
     othusn=-1;
     othusp=user-1;
     othuap=usracc-1;
}
 
char *tlsrui()
{
     while (othusn < NTERMS) {
          othusn+=1;
          othusp+=1;
          othuap+=1;
          if (othusp->state == TLCSTT && othusn != usrnum &&
              tlclst[othusn].channel == tlclst[usrnum].channel) {
               return(othuap->userid);
          }
     }
     return(NULL);
}
 
tlchup()
{
     if (usrptr->state == TLCSTT) {
          setmbk(tlcmb);
          prfmsg(TLCHUP,usaptr->userid);
          outtlc();
     }
     setmem(&tlclst[usrnum],sizeof(struct tlc),0);
}
 
clstlc()
{
     clsmsg(tlcmb);
}
