/***************************************************************************
 *                                                                         *
 *   MAJORBBS.H                                                            *
 *                                                                         *
 *   Copyright (C) 1987 GALACTICOMM, Inc.      All Rights Reserved.        *
 *                                                                         *
 *   This is the main Major BBS header file.                               *
 *                                                                         *
 *                                            - T. Stryker 6/24/86         *
 *                                                                         *
 ***************************************************************************/
 
#define NMODS     20          /* number of run-time modules supported      */
#define NTERMS    16          /* number of users to allow for              */
#define INPSIZ   256          /* input buffer size for each channel        */
#define OUTSIZ  2048          /* output buffer size for each channel       */
#define BPORT  0x2F0          /* default base port of breakthrough card(s) */
#define MTXSIZ   400          /* maximum message-text string size          */
#define DFTIMX   127          /* default input-char count maximum per line */
#define NCOMTY     8          /* number of computer type codes             */
#define NAGEBK     5          /* number of age brackets tallied            */
#define AUDSIZ    65          /* size of audit trail records               */
 
struct user {                 /* volatile per-user info maintained         */
     int class;               /*    class (offline, or flavor of online)   */
     int state;               /*    state (module number in effect)        */
     int substt;              /*    substate (for convenience of module)   */
     int usetmr;              /*    usage timer (for nonlive timeouts etc) */
     int minut4;              /*    total minutes of use, times 4          */
     int countr;              /*    general purpose counter                */
     int pfnacc;              /*    profanity accumulator                  */
     int flags;               /*    runtime flags                          */
};
                                   /* user class codes                     */
#define VACANT 0                   /*    vacant, offline                   */
#define ONLINE 1                   /*    online, not logged on             */
#define SUPIPG 2                   /*    signup in progress                */
#define FRELOA 3                   /*    logged on and freeloading         */
#define PAYING 4                   /*    logged on and paying              */
 
                                   /* standard profanity thresholds        */
#define WRNPFN 5                   /*    warning level                     */
#define MAXPFN 8                   /*    logoff level                      */
 
                                   /* user runtime flag bit values         */
#define NOINJO 1                   /*    unable to receive injoth() msgs   */
#define INJOIP 2                   /*    injoth() operation in progress    */
#define BYEBYE 4                   /*    going away, just wait for msg done*/
#define NOHDWE 8                   /*    no hardware, emulation chan only  */
#define OPCHAT 16                  /*    chatting-with-sysop flag          */
#define ACTIVE 32                  /*    channel-is-active (gen'ing status)*/
 
#define RING   1              /* btusts() return for ringing/lost carrier  */
#define CMDOK  2              /* btusts() return for command completed ok  */
#define CRSTG  3              /* btusts() return for CR-term'd string avail*/
#define INBLK  4              /* btusts() return for count-trg input avail */
#define OUTMT  5              /* btusts() return for output buffer empty   */
 
struct module {                    /* module interface block               */
     char select;                  /*    main menu select character        */
     char *descrp;                 /*    description for main menu         */
     int (*inirou)();              /*    system initialization routine     */
     int (*lonrou)();              /*    user logon supplemental routine   */
     int (*sttrou)();              /*    input routine if selected         */
     int (*stsrou)();              /*    status-input routine if selected  */
     int (*huprou)();              /*    hangup (lost carrier) routine     */
     int (*mcurou)();              /*    midnight cleanup routine          */
     int (*dlarou)();              /*    delete-account routine            */
     int (*finrou)();              /*    finish-up (sys shutdown) routine  */
};
 
struct sysvbl {                    /* system-variable btrieve record layout*/
     char key[4];                  /*    4-character dummy key of "key"    */
     int dspopt[3];                /*    display options by position number*/
     unsigned numero;              /*    message-number counter            */
     unsigned numact;              /*    number of user accounts total     */
     unsigned numpai;              /*    number of paying accounts         */
     long usedytd;                 /*    "tickies" used year-to-date       */
     long liveytd;                 /*    live "tickies" used year-to-date  */
     long usedmtd;                 /*    "tickies" used month-to-date      */
     long livemtd;                 /*    live "tickies" used month-to-date */
     long useddtd;                 /*    "tickies" used day-to-date        */
     long livedtd;                 /*    live "tickies" used day-to-date   */
     long paidytd;                 /*    "tickies" paid-for year-to-date   */
     long paidmtd;                 /*    "tickies" paid-for month-to-date  */
     long paiddtd;                 /*    "tickies" paid-for day-to-date    */
     char lonmsg[MTXSIZ];          /*    log-on message in effect          */
     unsigned numfre;              /*    number of free sample accounts    */
     unsigned numdem;              /*    number of "demo" live accounts    */
     unsigned numfem;              /*    number of female accounts         */
     unsigned numcor;              /*    number of corporate accounts      */
     long dwnlds;                  /*    total downloads to date           */
     long uplds;                   /*    total uploads to date             */
     long ctdtot;                  /*    total calls-to-date               */
     long ctdpai;                  /*    paid calls-to-date                */
     long emltot;                  /*    EMAIL total to date               */
     long csitot;                  /*    Classified ads total to date      */
     unsigned emlopn;              /*    EMAIL open at the moment          */
     unsigned csiopn;              /*    classified ads open at the moment */
     char spare[504-488];          /*    spare space, decrease when adding */
};
 
struct sysvb2 {                    /* second system variable btrieve layout*/
     char ky2[4];                  /*    4-character dummy key of "ky2"    */
     unsigned matrix[NCOMTY][NAGEBK];   /*    matrx of accts (computer/age)*/
     long moduse[NMODS];           /*    array of module use (in minutes)  */
     long modliv[NMODS];           /*    array of live module use (in mins)*/
     char spare[504-244];          /*    spare space, decrease when adding */
};
