/***************************************************************************
 *                                                                         *
 *   DOWNLOAD.C                                                            *
 *                                                                         *
 *   Copyright (C) 1987 GALACTICOMM, Inc.      All Rights Reserved.        *
 *                                                                         *
 *   This is the demo board download utility.                              *
 *                                                                         *
 *                                            - T. Stryker 1/31/87         *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "majorbbs.h"
#include "usracc.h"
#include "dnuload.h"
 
int inidnl(),dnload(),dnsthn(),dnlhup(),clsdnl();
 
#define DNLSTT      06        /* download utility state               */
struct module module06={      /* module interface block               */
     'D',                     /*    main menu select character        */
     "Download utility",      /*    description for main menu         */
     &inidnl,                 /*    system initialization routine     */
     NULL,                    /*    user logon supplemental routine   */
     &dnload,                 /*    input routine if selected         */
     &dnsthn,                 /*    status-input routine if selected  */
     &dnlhup,                 /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     &clsdnl                  /*    finish-up (sys shutdown) routine  */
};
 
#define FNSIZE 23             /* maximum filespec size (non-sysop 12 only) */
 
FILE *dnumb,*opnmsg();        /* up/down named-message file block pointer  */
int numdnu=0;                 /* number of users down/uploading at moment  */
 
static
char *fnlist;                 /* ptr to dynam alloc'd area for filenames   */
static
int numgrp;                   /* number of groups (screens) in file list   */
static
struct dnlusr {               /* download utility user data blocks         */
     int grpctr;              /*   group counter for use in list display   */
     char filnam[FNSIZE+1];   /*   file name specified for download        */
     int xmblkn;              /*   XMODEM block number in effect           */
     int lstbsz;              /*   last block size sent                    */
     long curpos;             /*   current position within file            */
     FILE *fp;                /*   file pointer when actually downloading  */
} dnldat[NTERMS],*dndptr;
 
extern
struct usracc usracc[NTERMS], /* user accounting block array               */
              *usaptr;        /* user accounting block pointer for usrnum  */
extern
int usrnum;                   /* global user-number (channel) in effect    */
extern
struct user *usrptr,          /* global pointer to user data in effect     */
            user[NTERMS];     /* user volatile-data structure array        */
extern
char input[INPSIZ],           /* raw user input data buffer                */
     *margv[INPSIZ/2];        /* array of ptrs to word starts, a la argv[] */
extern
int margc,                    /* number of words in margv[], a la argc     */
    status;                   /* raw status from btusts, where appropriate */
extern
char prfbuf[];                /* 2K buffer used by prfutl, used for staging*/
extern
struct sysvbl sv;             /* sys-variables record instance for updates */
 
#define DIRCPL 20             /* directory characters per line             */
 
#define OUTFNL -1             /* outputting-filename-list state            */
#define OUTASC -2             /* outputting-ASCII-file state               */
#define DNLDUN -3             /* download-done (awaiting status 2) state   */
 
#define ACK  6                /* ASCII controls chars used in XMODEM       */
#define NAK 21
#define SOH  1
#define EOT  4
#define CAN 24
 
char *curtim(),*curdat();     /* time and date formatter routines          */
 
inidnl()
{
     char *getmem();
     int i,numfil;
     extern char fndfil[];
     extern long ffllen;
     int dnlrti();
 
     if (dnumb == NULL) {
          dnumb=opnmsg("dnuload.mcv");
     }
     if (!fnd1st("dnllib\\*.*")) {
          module06.select='\0';
     }
     else {
          for (numfil=1 ; fndnxt() ; numfil++) {
          }
          fnlist=getmem(numfil*DIRCPL+1);
          fnd1st("dnllib\\*.*");
          sprintf(fnlist,"%-12s %6ld\r",fndfil,ffllen);
          while (fndnxt()) {
               sprintf(fnlist+strlen(fnlist),"%-12s %6ld\r",fndfil,ffllen);
          }
          for (numgrp=1,i=11 ; i < numfil ; numgrp+=1,i+=23) {
               fnlist[i*DIRCPL-1]='\0';
          }
     }
     rtkick(2,&dnlrti);
}
 
dnload()
{
     int c,newstt;
     char *tptr;
 
     setmbk(dnumb);
     dndptr=&dnldat[usrnum];
     switch (newstt=usrptr->substt) {
     case 0:
          newstt=reyak();
          break;
     case OUTFNL:
          if (sameas(input,"x")) {
               prfmsg(EXIDNL);
               return(0);
          }
          newstt=pfnlut();
          break;
     case LIVONL:
     case SOFULL:
          return(0);
     case ENTCHC:
     case ENTCH2:
          if (margc == 0) {
               prfmsg(ENTCH2);
          }
          else if (margc > 1 || input[0] == 32) {
               prfmsg(RENTCH);
          }
          else if (sameas(input,"x")) {
               numdnu-=1;
               prfmsg(EXIDNL);
               return(0);
          }
          else if (sameas(input,"?") || sameas(input,"help")) {
               numdnu-=1;
               newstt=reyak();
          }
          else if (!fileok()) {
               prfmsg(NOSUCH);
          }
          else {
               strcpy(dndptr->filnam,input);
               strcpy(input,"DNLLIB\\");
               strcat(input,dndptr->filnam);
               if ((dndptr->fp=fopen(input,"rb")) == NULL) {
                    prfmsg(NOSUCH);
               }
               else {
                    prfmsg(newstt=ASCORX);
               }
          }
          break;
     case ASCORX:
          if (sameas(input,"x")) {
               numdnu-=1;
               prfmsg(EXIDNL);
               fclose(dndptr->fp);
               return(0);
          }
          else if (margc == 0 || margc > 1 || (c=atoi(input)) < 1 || c > 2) {
               prfmsg(ASCXHL);
          }
          else if (c == 1) {
               usrptr->flags|=NOINJO;
               prf("\r\nFile: %s\r\n",dndptr->filnam);
               prfmsg(DLIDLN,curdat(7),curtim(5));
               prf("\r\n<<< Press CTRL-S to pause, CTRL-Q to resume, RETURN to abort >>>\r\n\r\n");
               btuxct(usrnum,strlen(prfbuf),prfbuf);
               clrprf();
               usrptr->substt=OUTASC;
               dnrtch();
               return(1);
          }
          else {
               usrptr->flags|=NOINJO;
               prfmsg(usrptr->substt=GOXMDM);
               outprf(usrnum);
               btutrg(usrnum,1);
               dndptr->xmblkn=1;
               dndptr->lstbsz=0;
               dndptr->curpos=0L;
               return(1);
          }
          break;
     case OUTASC:
     case GOXMDM:
     case DNLDUN:
          btuoes(usrnum,0);
          btuclo(usrnum);
          btutrg(usrnum,0);
          fclose(dndptr->fp);
          usrptr->flags&=~NOINJO;
          prfmsg(newstt=ABORTD);
          break;
     case ABORTD:
     case COMPLT:
          for (tptr=input ; *tptr != '\0' && !isalpha(*tptr) ; tptr++) {
          }
          if ((c=tolower(*tptr)) != 'y' && c != 'n' && c != 'x') {
               prfmsg(ANOTHER);
          }
          else if (c == 'y') {
               prfmsg(newstt=ENTCH2);
          }
          else {
               numdnu-=1;
               prfmsg(EXIDNL);
               return(0);
          }
          break;
     }
     outprf(usrnum);
     usrptr->substt=newstt;
     return(1);
}
 
dnlrti()
{
     for (usrnum=0 ; usrnum < NTERMS ; usrnum++) {
          usrptr=&user[usrnum];
          if (usrptr->state == DNLSTT) {
               dndptr=&dnldat[usrnum];
               dnrtch();
          }
     }
     rtkick(1,&dnlrti);
}
 
dnrtch()
{
     int rc;
 
     switch (usrptr->substt) {
     case OUTASC:
          if (btuoba(usrnum) > 1024) {
               if ((rc=fread(prfbuf,1,1024,dndptr->fp)) != 0) {
                    btuxct(usrnum,rc,prfbuf);
               }
               else {
                    usrptr->substt=DNLDUN;
                    btuoes(usrnum,1);
                    if (btuoba(usrnum) == OUTSIZ-1) {
                         btuinj(usrnum,OUTMT);
                    }
               }
          }
          break;
     }
}
 
dnsthn()
{
     char ch;
 
     setmbk(dnumb);
     dndptr=&dnldat[usrnum];
     switch (usrptr->substt) {
     case DNLDUN:
          if (status == OUTMT) {
               btuoes(usrnum,0);
               prfmsg(usrptr->substt=COMPLT,dndptr->filnam);
               outprf(usrnum);
               btutrg(usrnum,0);
               fclose(dndptr->fp);
               usrptr->flags&=~NOINJO;
               sv.dwnlds+=1;
               return;
          }
          break;
     case GOXMDM:
          if (status == INBLK) {
               btuict(usrnum,&ch);
               switch (ch) {
               case NAK:
                    dndptr->curpos-=dndptr->lstbsz;
                    if (fseek(dndptr->fp,dndptr->curpos,0) != 0) {
                         catastro("DNSTHN: GOXMDM FSEEK ERROR");
                    }
                    dndptr->xmblkn-=1;
               case ACK:
                    setmem(prfbuf+3,128,0);
                    if ((dndptr->lstbsz=fread(prfbuf+3,1,128,dndptr->fp)) > 0) {
                         dndptr->xmblkn=((dndptr->xmblkn+1)&0xFF);
                         prfbuf[0]=SOH;
                         prfbuf[1]=dndptr->xmblkn;
                         prfbuf[2]=dndptr->xmblkn^0xFF;
                         prfbuf[131]=cksumv(prfbuf+3,128);
                         btuxct(usrnum,132,prfbuf);
                         dndptr->curpos+=dndptr->lstbsz;
                    }
                    else {
                         btuoes(usrnum,1);
                         setmem(prfbuf,10,EOT);
                         btuxct(usrnum,10,prfbuf);
                         usrptr->substt=DNLDUN;
                    }
                    break;
               case CAN:
                    btuoes(usrnum,0);
                    btuclo(usrnum);
                    btutrg(usrnum,0);
                    fclose(dndptr->fp);
                    usrptr->flags&=~NOINJO;
                    prfmsg(usrptr->substt=ABORTD);
                    outprf(usrnum);
                    break;
               }
               return;
          }
          break;
     }
     if (status != INBLK) {
          dfsthn();
     }
}
 
reyak()
{
     dndptr->grpctr=0;
     prfmsg(INTRO);
     return(pfnlut());
}
 
pfnlut()
{
     int newstt;
 
     prf("%s",fnlist+(dndptr->grpctr ? ((dndptr->grpctr-1)*23+11)*DIRCPL : 0));
     if (dndptr->grpctr == numgrp-1) {
          if (usrptr->class < PAYING) {
               prfmsg(newstt=LIVONL);
          }
          else if (numdnu >= 8) {
               prfmsg(newstt=SOFULL);
          }
          else {
               numdnu+=1;
               dndptr->grpctr=numgrp;
               prfmsg(newstt=ENTCHC);
          }
     }
     else {
          prf("\r--- press RETURN for more ---");
          dndptr->grpctr+=1;
          newstt=OUTFNL;
     }
     return(newstt);
}
 
dnlhup()
{
     dndptr=&dnldat[usrnum];
     if (dndptr->grpctr == numgrp) {
          numdnu-=1;
          switch (usrptr->substt) {
          case ASCORX:
          case OUTASC:
          case GOXMDM:
          case DNLDUN:
               fclose(dndptr->fp);
               break;
          }
     }
     setmem(dndptr,sizeof(struct dnlusr),0);
}
 
fileok()
{
     char *tptr;
 
     input[FNSIZE]='\0';
     if (!sameas(usaptr->userid,"Sysop")) {
          if (sameas(input,"con")
           || sameas(input,"prn")
           || sameas(input,"aux")
           || sameas(input,"com1")
           || sameas(input,"com2")
           || sameas(input,"nul")
           || sameas(input,"lpt1")
           || sameas(input,"lpt2")
           || sameas(input,"lpt3")) {
               return(0);
          }
          for (tptr=input ; *tptr != '\0' ; tptr++) {
               if (!isalpha(*tptr) && !isdigit(*tptr) && *tptr != '.') {
                    return(0);
               }
               *tptr=toupper(*tptr);
          }
     }
     return(1);
}
 
cksumv(stg,len)
char *stg;
int len;
{
     int cks=0;
 
     while (--len >= 0) {
          cks+=*stg++;
     }
     return(cks&0xFF);
}
 
clsdnl()
{
     if (dnumb != NULL) {
          clsmsg(dnumb);
          dnumb=NULL;
     }
}
