/*        Header file for use with Btrieve utilities in BTVSTF.C           */
/*   Copyright (C) 1987 GALACTICOMM, Inc.      All Rights Reserved.        */
 
struct btvblk {                    /* btrieve file data block definition   */
     long posblk[128/4];           /*   position block                     */
     char *filnam;                 /*   file name                          */
     int reclen;                   /*   record length                      */
     char *data;                   /*   actual record contents             */
     char *key;                    /*   key for searching, etc.            */
     int lastkn;                   /*   last key number used               */
};
 
#define BTVFILE struct btvblk      /* shorthand for btrieve file structure */
 
BTVFILE *opnbtv();                 /* non-int btvstf routine returns       */
long absbtv();
 
#define qeqbtv(key,keynum) qrybtv(key, keynum,55)
#define qnxbtv()           qrybtv(NULL,    -1,56)
#define qprbtv()           qrybtv(NULL,    -1,57)
#define qgtbtv(key,keynum) qrybtv(key, keynum,58)
#define qgebtv(key,keynum) qrybtv(key, keynum,59)
#define qltbtv(key,keynum) qrybtv(key, keynum,60)
#define qlebtv(key,keynum) qrybtv(key, keynum,61)
#define qlobtv(keynum)     qrybtv(NULL,keynum,62)
#define qhibtv(keynum)     qrybtv(NULL,keynum,63)
 
#define geqbtv(recp,key,keynum) getbtv(recp,key, keynum,5)
#define gnxbtv(recp)            getbtv(recp,NULL,    -1,6)
#define gprbtv(recp)            getbtv(recp,NULL,    -1,7)
#define ggtbtv(recp,key,keynum) getbtv(recp,key, keynum,8)
#define ggebtv(recp,key,keynum) getbtv(recp,key, keynum,9)
#define gltbtv(recp,key,keynum) getbtv(recp,key, keynum,10)
#define glebtv(recp,key,keynum) getbtv(recp,key, keynum,11)
#define globtv(recp,keynum)     getbtv(recp,NULL,keynum,12)
#define ghibtv(recp,keynum)     getbtv(recp,NULL,keynum,13)
 
#define gcrbtv(recp,keynum)     gabbtv(recp,absbtv(),keynum)
 
