/***************************************************************************
 *                                                                         *
 *   BTVSTF.C                                                              *
 *                                                                         *
 *   Copyright (C) 1987 GALACTICOMM, Inc.      All Rights Reserved.        *
 *                                                                         *
 *   This file contains a library of routines for accessing BTRIEVE files  *
 *   with fixed length records.                                            *
 *                                                                         *
 *                                            - T. Stryker 9/30/86         *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "dos.h"
#include "btvstf.h"
 
static struct btvblk *bb;               /* current btvu file pointer set   */
 
struct btvblk *opnbtv(filnam,reclen)
char *filnam;
int reclen;
{
     char *alcmem();
     int stat;
 
     bb=(struct btvblk *)alcmem(sizeof(struct btvblk));
     bb->filnam=alcmem(strlen(filnam)+1);
     strcpy(bb->filnam,filnam);
     bb->reclen=reclen;
     bb->data=alcmem(reclen);
     bb->key=alcmem(reclen);
     if ((stat=btvu(0,NULL,filnam,0)) != 0) {
          catastro("OPNBTV: BTVU ERROR %d ON FILE \"%s\"",stat,filnam);
     }
     return(bb);
}
 
setbtv(bbptr)
struct btvblk *bbptr;
{
     bb=bbptr;
}
 
qrybtv(key,keynum,qryopt)
char *key;
int keynum;
int qryopt;
{
     int stat;
 
     if (key != NULL) {
          movmem(key,bb->key,bb->reclen);
     }
     if (keynum < 0) {
          keynum=bb->lastkn;
     }
     else {
          bb->lastkn=keynum;
     }
     if ((stat=btvu(qryopt,NULL,bb->key,keynum)) != 0) {
          if (stat == 4 || stat == 9) {
               return(0);
          }
          catastro("QRYBTV: BTVU ERROR %d ON FILE \"%s\"",stat,bb->filnam);
     }
     return(1);
}
 
getbtv(recptr,key,keynum,getopt)
char *recptr;
char *key;
int keynum;
int getopt;
{
     int stat;
 
     if (recptr == NULL) {
          recptr=bb->data;
     }
     if (key != NULL) {
          movmem(key,bb->key,bb->reclen);
     }
     if (keynum < 0) {
          keynum=bb->lastkn;
     }
     else {
          bb->lastkn=keynum;
     }
     if ((stat=btvu(getopt,recptr,bb->key,keynum)) != 0) {
          catastro("GETBTV: BTVU ERROR %d ON FILE \"%s\"",stat,bb->filnam);
     }
}
 
long absbtv()
{
     int stat;
     long abspos;
 
     if ((stat=btvu(22,&abspos,NULL,0)) != 0) {
          catastro("ABSBTV: BTVU ERROR %d ON FILE \"%s\"",stat,bb->filnam);
     }
     return(abspos);
}
 
gabbtv(recptr,abspos,keynum)
char *recptr;
long abspos;
int keynum;
{
     int stat;
 
     if (recptr == NULL) {
          recptr=bb->data;
     }
     *(long *)recptr=abspos;
     bb->lastkn=keynum;
     if ((stat=btvu(23,recptr,bb->key,keynum)) != 0) {
          catastro("GABBTV: BTVU ERROR %d ON FILE \"%s\"",stat,bb->filnam);
     }
}
 
sabbtv(recptr)
char *recptr;
{
     int stat;
 
     if (recptr == NULL) {
          recptr=bb->data;
     }
     if ((stat=btvu(24,recptr,NULL,0)) != 0) {
          catastro("SABBTV: BTVU ERROR %d ON FILE \"%s\"",stat,bb->filnam);
     }
}
 
updbtv(recptr)
char *recptr;
{
     int stat;
 
     if (recptr == NULL) {
          recptr=bb->data;
     }
     if ((stat=btvu(3,recptr,bb->key,bb->lastkn)) != 0) {
          catastro("UPDBTV: BTVU ERROR %d ON FILE \"%s\"",stat,bb->filnam);
     }
}
 
insbtv(recptr)
char *recptr;
{
     int stat;
 
     if (recptr == NULL) {
          recptr=bb->data;
     }
     if ((stat=btvu(2,recptr,bb->key,0)) != 0) {
          catastro("INSBTV: BTVU ERROR %d ON FILE \"%s\"",stat,bb->filnam);
     }
}
 
delbtv()
{
     int stat;
 
     if ((stat=btvu(4,NULL,NULL,bb->lastkn)) != 0) {
          catastro("DELBTV: BTVU ERROR %d ON FILE \"%s\"",stat,bb->filnam);
     }
}
 
acqbtv(recptr,key,keynum)
char *recptr;
char *key;
int keynum;
{
     if (qeqbtv(key,keynum)) {
          geqbtv(recptr,key,keynum);
          return(1);
     }
     return(0);
}
 
aqnbtv(recptr)
char *recptr;
{
     movmem(bb->key,bb->data,bb->reclen);
     if (qnxbtv() && strcmp(bb->data,bb->key) == 0) {
          gcrbtv(recptr,bb->lastkn);
          return(1);
     }
     return(0);
}
 
clsbtv(bbp)
struct btvblk *bbp;
{
     int stat;
 
     bb=bbp;
     if (bb != NULL) {
          if ((stat=btvu(1,NULL,NULL,0)) != 0) {
               catamsg("CLSBTV: BTVU ERROR %d ON FILE \"%s\"",stat,bb->filnam);
          }
          if (rlsmem(bb->key,bb->reclen) != 0
           || rlsmem(bb->data,bb->reclen) != 0
           || rlsmem(bb->filnam,strlen(bb->filnam)+1) != 0
           || rlsmem(bb,sizeof(struct btvblk)) != 0) {
               catamsg("CLSBTV: ERROR RELEASING MEMORY");
          }
     }
}
 
struct btvdat {   /* btrieve parameter block structure for use with INT 0x7B */
     char *datbuf;
     int dbflen;
     char *posp38;
     char *posblk;
     int funcno;
     char *key;
     char keylen;
     char keyno;
     int *statpt;
     int magic;
};
 
btvu(funcno,datbuf,key,keyno)
int funcno;
char *datbuf;
char *key;
int keyno;
{
     struct XREG xregs;
     struct SREGS sregs;
     struct btvdat btvdat;
     int status;
     static int btrvup=0,alrcat=0;
 
     if (!btrvup) {
          xregs.ax=0x357B;
          int86x(0x21,&xregs,&xregs,&sregs);
          if (xregs.bx != 0x33) {
               if (alrcat) {
                    return(0);
               }
               alrcat=1;
               catastro(
               "\14You must run BTRIEVE first, before you can run Major BBS!");
          }
          btrvup=1;
     }
     btvdat.datbuf=datbuf;
     btvdat.dbflen=bb->reclen;
     btvdat.posp38=((char *)bb->posblk)+38;
     btvdat.posblk=(char *)bb->posblk;
     btvdat.funcno=funcno;
     btvdat.key=key;
     btvdat.keylen=255;
     btvdat.keyno=keyno;
     btvdat.statpt=&status;
     btvdat.magic=30305;
     xregs.dx=(short)&btvdat;
     segread(&sregs);
     sregs.ds=sregs.ss;
     status=0;
     int86x(0x7B,&xregs,&xregs,&sregs);
     return(status);
}
 
