/***************************************************************************/
/*   KEYFLASH.C     Flash implementation of KEYCODES.C                     */
/*                                                                         */
/*   I enable the new keyboard interrupt code when entering the game       */
/*   itself and restore it when exiting.  That way no new code is required */
/*   to handle normal chatting on the chat screen.                         */
/*                                                                         */
/*   example:                                                              */
/*    .-> (flash chat mode)                                                */
/*    |   (F9 pressed to play game)                                        */
/*    |   setkeyi();          - key interrupt enabled                      */
/*    |   (game over - ESC pressed?)                                       */
/*    |   rstkeyi();          - restore original interrupt vector          */
/*    |        |                                                           */
/*    `--<-----'                                                           */
/*                                                     12/10/91 Les Bird   */
/***************************************************************************/

void interrupt                /* this is the new keyboard interrupt code   */
newkeyi(void)
{
     int  v;

     if (inportb(0x64)&0x01) {
          v=inportb(0x60);
          outportb(0x20,0x20);
          if (v == 129) {
               setvect(0x09,oldkeyi);
          }
          ecoutp(v);          /* send to the Flash pool                    */
     }
     enable();
}

void                          /* setup the new interrupt vector            */
setkeyi(void)                 /*   call this routine to turn on the above  */
{                             /*   new interrupt code.                     */
     disable();
     oldkeyi=getvect(0x09);
     setvect(0x09,newkeyi);
     enable();
}

void                          /* reset keyboard interrupt vector           */
rstkeyi(void)                 /*   call this routine to reset keyboard to  */
{                             /*   normal operation.                       */
     disable();
     setvect(0x09,oldkeyi);
     enable();
}
