/*
 *   INSTALL.C for Flash Pack
 */

#include "\bbsv6\src\gcomm.h"
#include "process.h"
#include "errno.h"

#define NDIRS       22
#define INSTALL     1
#define UNINSTALL   0

#define HILINE      0x07
#define LOLINE      0x79

#define BASEY       10

extern
char scntbl[][SCNSIZ];
extern
int  errno;

char dltr[256],
     ddir[42],
     *dlist[]={     /* list of directories to create                       */
          "",
          "\\asm",
          "\\include",
          "\\lib",
          "\\obj",
          "\\src",
          "\\fmaze",
          "\\fmaze\\include",
          "\\fmaze\\obj",
          "\\fmaze\\scn",
          "\\fmaze\\src",
          "\\ftanks",
          "\\ftanks\\include",
          "\\ftanks\\obj",
          "\\ftanks\\scn",
          "\\ftanks\\src",
          "\\fspace",
          "\\fspace\\include",
          "\\fspace\\obj",
          "\\fspace\\scn",
          "\\fspace\\src"
     },
     *flist[]={     /* list of files to install                            */
          /*   default FLASHPAK\ files       */
          "map.ans flscn*.asm *.bat *.cfg *.lnk *.mac *.mak",
          /*   FLASHPAK\ASM\ files           */
          "noises.asm flutil.asm jstick.asm sercom.asm",
          /*   FLASHPAK\INCLUDE\ files       */
          "dosface.h fkcode.h portable.h sintab.h costab.h tantab.h",
          /*   FLASHPAK\LIB\ files           */
          "mbbst.lib",
          /*   FLASHPAK\OBJ\ files           */
          "egavga.obj",
          /*   FLASHPAK\SRC\ files           */
          "flkick.c dosface.c genutl.c keycodes.c keyflash.c",
          /*   FLASHPAK\FMAZE\ files         */
          "",
          /*   FLASHPAK\FMAZE\INCLUDE\ files */
          "fm*.h",
          /*   FLASHPAK\FMAZE\OBJ\ files     */
          "",
          /*   FLASHPAK\FMAZE\SCN\ files     */
          "fm*.scn maz*.scn",
          /*   FLASHPAK\FMAZE\SRC\ files     */
          "fm*.c set*.asm",
          /*   FLASHPAK\FTANKS\ files        */
          "",
          /*   FLASHPAK\FTANKS\INCLUDE\ files*/
          "ft*.h",
          /*   FLASHPAK\FTANKS\OBJ\ files    */
          "",
          /*   FLASHPAK\FTANKS\SCN\ files    */
          "ft*.scn",
          /*   FLASHPAK\FTANKS\SRC\ files    */
          "ft*.c",
          /*   FLASHPAK\FSPACE\ files        */
          "",
          /*   FLASHPAK\FSPACE\INCLUDE\ files*/
          "fs*.h",
          /*   FLASHPAK\FSPACE\OBJ\ files    */
          "",
          /*   FLASHPAK\FSPACE\SCN\ files    */
          "fs*.scn",
          /*   FLASHPAK\FSPACE\SRC\ files    */
          "fs*.c"
     },
     *savscn;

int  err=0,
     gambit=7,
     idrv,
     maxd,
     mode=INSTALL,
     msgbit=0,
     sdrv,
     sx,sy;

void
readrvs(int argc,char *argv[])     /* map out valid drives on system       */
{
     int  d,dcntr=0;
     char drive[MAXDRIVE],dir[MAXPATH];

     idrv=getdisk();
     maxd=setdisk(idrv);
     for (d=0 ; d < maxd ; d++) {
          setdisk(d);
          if (getdisk() == d) {
               dltr[dcntr]='A'+d;
               dcntr++;
          }
     }
     dltr[dcntr]=0xFF;
     setdisk(idrv);
     fnsplit(argv[0],drive,dir,NULL,NULL);
     sdrv=toupper(drive[0])-'A';
}

void
hilite(int x1,int y1,int x2,int atr) /* highlight screen position          */
{
     int  x,y;

     y=y1*160;
     for (x=x1 ; x < x2 ; x++) {
          *(((frzseg()+y)+x*2)+1)=atr;
     }
}

int
anygam(void)                  /* any game directories left?                */
{
     int  i,retval=0;
     char *tdirs[]={
          "\\flashpak\\fmaze","\\flashpak\\ftanks","\\flashpak\\fspace"
     };
     struct fndblk *tmpff;

     tmpff=(struct fndblk *)alczer(sizeof(struct fndblk));
     for (i=0 ; i < 3 ; i++) {
          if (fnd1st(tmpff,tdirs[i],FAMDIR)) {
               retval=1;
               break;
          }
     }
     free(tmpff);
     return(retval);
}

int
insgam(int g)                 /* install game 'g'?                         */
{
     if (strstr(dlist[g],"fmaze") != NULL) {
          if (gambit&1) {
               if (!(msgbit&1)) {
                    printf("\n%sInstalling FLASH MAZE files...........",
                                             (mode == INSTALL) ? "" : "Un-");
                    msgbit|=1;
               }
          }
          else {
               return(0);
          }
     }
     else if (strstr(dlist[g],"ftanks") != NULL) {
          if (gambit&2) {
               if (!(msgbit&2)) {
                    printf("\n%sInstalling FLASH TANKS files..........",
                                             (mode == INSTALL) ? "" : "Un-");
                    msgbit|=2;
               }
          }
          else {
               return(0);
          }
     }
     else if (strstr(dlist[g],"fspace") != NULL) {
          if (gambit&4) {
               if (!(msgbit&4)) {
                    printf("\n%sInstalling FLASH SPACEWARS files......",
                                             (mode == INSTALL) ? "" : "Un-");
                    msgbit|=4;
               }
          }
          else {
               return(0);
          }
     }
     return(1);
}

void
rstscn(void)
{
     movmem(savscn,frzseg(),SCNSIZ);
     free(savscn);
     locate(sx,sy);
     cursiz(LILCURS);
}

int
validch(int c,char *sval)
{
     int  i,f=0;
     char badchars[]={" |<>?:\"'*"};

     if (isascii(c)) {
          for (i=0 ; i < strlen(badchars) && f == 0 ; i++) {
               if (c == badchars[i]) {
                    f=1;
               }
          }
          if (f == 0) {
               return(1);
          }
     }
     return(0);
}

void
main(int argc,char *argv[])
{
     int  c,d=0,i,j,y=0;
     char doscmd[80],idir[80],tmp[80],zfile[80];
     struct fndblk *tmpff;

     sx=curcurx();
     sy=curcury();
     movmem(frzseg(),savscn=alcmem(SCNSIZ),SCNSIZ);
     cursiz(NOCURS);
     readrvs(argc,argv);
     explode(scntbl[0],0,0,79,24);
     stzcpy(ddir,"\\FLASHPAK",42);
     locate(19,21);
     setatr(LOLINE);
     printf("%s",ddir);
     locate(55,BASEY+6);
     setatr(LOLINE);
     printf("%c",dltr[sdrv]);
     hilite(18,BASEY+y,54,HILINE);
     do {
          if (kbhit()) {
               hilite(18,BASEY+y,54,LOLINE);
               c=getchc();
               switch (c) {
               case ' ':
                    belper(500);
                    printf("\7");
                    if (y < 6) {
                         if (gambit&(1<<(y/2))) {
                              gambit&=~(1<<(y/2));
                              locate(55,BASEY+y);
                              setatr(0x4F);
                              printf("  NO ");
                         }
                         else {
                              gambit|=(1<<(y/2));
                              locate(55,BASEY+y);
                              setatr(0x2F);
                              printf(" YES ");
                         }
                    }
                    else {
                         d=(y == 6) ? sdrv+1 : idrv+1;
                         if (d > maxd || dltr[d] == 0xFF) {
                              d=0;
                         }
                         locate(55,BASEY+y);
                         setatr(LOLINE);
                         printf("%c:",dltr[d]);
                         if (y == 6) {
                              sdrv=d;
                         }
                         else {
                              idrv=d;
                         }
                    }
                    break;
               case CRSRUP:
                    belper(250);
                    printf("\7");
                    y=(y > 0) ? y-2 : 10;
                    if (mode == UNINSTALL && y == 6) {
                         y-=2;
                    }
                    else if (y == 10) {
                         edtval(19,21,42,ddir,validch,ALLCAPS+MULTIEX);
                         if (ddir[strlen(ddir)-1] == '\\') {
                              ddir[strlen(ddir)-1]='\0';
                              locate(19,21);
                              setatr(LOLINE);
                              printf("%s",ddir);
                         }
                         belper(250);
                         printf("\7");
                         y=8;
                    }
                    break;
               case CRSRDN:
                    belper(250);
                    printf("\7");
                    y=(y < 10) ? y+2 : 0;
                    if (mode == UNINSTALL && y == 6) {
                         y+=2;
                    }
                    else if (y == 10) {
                         edtval(19,21,42,ddir,validch,ALLCAPS+MULTIEX);
                         if (ddir[strlen(ddir)-1] == '\\') {
                              ddir[strlen(ddir)-1]='\0';
                              locate(19,21);
                              setatr(LOLINE);
                              printf("%s",ddir);
                         }
                         belper(250);
                         printf("\7");
                         y=0;
                    }
                    break;
               case F1:
                    mode=(mode == INSTALL) ? UNINSTALL : INSTALL;
                    if (mode == UNINSTALL) {
                         setatr(0x4F);
                         locate(37,3);
                         printf(" UNINSTALL ");
                         setatr(LOLINE);
                         locate(42,7);
                         printf("uninstall");
                         hilite(55,17,57,0x78);
                    }
                    else {
                         setatr(0x2F);
                         locate(37,3);
                         printf("  INSTALL  ");
                         setatr(LOLINE);
                         locate(42,7);
                         printf(" install ");
                         hilite(55,17,57,LOLINE);
                    }
                    break;
               case F10:
                    belper(2000);
                    printf("\7\7");
                    belper(1000);
                    printf("\7");
                    break;
               default:
                    belper(1000);
                    printf("\7");
                    belper(2000);
                    printf("\7\7");
               }
               hilite(18,BASEY+y,54,HILINE);
          }
     } while (c != F10 && c != ESC);
     if (c == F10 && mode == INSTALL) {
          explodeto(scntbl[1],0,0,44,4,20,6);
          locate(22,8);
          setatr(0x2F);
          setwin(NULL,22,8,63,8,1);
          printf("Creating FLASH PACK directories.........");
          for (i=0 ; i < NDIRS && err == 0 ; i++) {
               if (kbhit() && getchc() == ESC) {
                    err=1;
               }
               if (!err && insgam(i)) {
                    setmem(tmp,sizeof(tmp),0);
                    sprintf(tmp,"%c:%s%s",dltr[idrv],ddir,dlist[i]);
                    mkdir(tmp);
               }
          }
          if (!err) {
               msgbit=0;
               printf("\nInstalling default FLASH PACK files.....");
               sprintf(zfile,"%c:%s\\",dltr[sdrv],ddir);
               for (i=0 ; i < NDIRS && err == 0 ; i++) {
                    if (kbhit() && getchc() == ESC) {
                         err=1;
                    }
                    if (!err && strlen(flist[i]) > 0) {
                         if (insgam(i)) {
                              setmem(tmp,sizeof(tmp),0);
                              sprintf(tmp,"%c:%s%s",dltr[idrv],ddir,dlist[i]);
                              stzcpy(idir,tmp,sizeof(idir));
                              setmem(doscmd,sizeof(doscmd),0);
                              sprintf(doscmd,"%c:pkunzip >nul: -o %s %s %s",
                                             dltr[sdrv],zfile,flist[i],idir);
                              system(doscmd);
                         }
                    }
                    printf("\b\b\b%3d",i);
               }
          }
     }
     else if (c == F10 && mode == UNINSTALL) {
          tmpff=(struct fndblk *)alcmem(sizeof(struct fndblk));
          explodeto(scntbl[1],0,5,44,9,20,6);
          setatr(0x4F);
          setwin(NULL,22,8,63,8,1);
          locate(22,8);
          for (i=NDIRS-1 ; i > -1 && err == 0 ; i--) {
               if (kbhit() && getchc() == ESC) {
                    err=1;
               }
               if (i <= 5 && anygam()) {
                    err=1;
               }
               if (!err && insgam(i)) {
                    setmem(idir,sizeof(idir),0);
                    sprintf(idir,"%c:%s%s",dltr[idrv],ddir,dlist[i]);
                    if (fnd1st(tmpff,idir,FAMDIR)) {
                         setmem(tmp,sizeof(tmp),0);
                         sprintf(tmp,"%s\\*.*",idir);
                         if (fnd1st(tmpff,tmp,0)) {
                              do {
                                   setmem(zfile,sizeof(zfile),0);
                                   sprintf(zfile,"%s\\%s",idir,tmpff->name);
                                   printf("\nDeleting file %-25s",tmpff->name);
                                   remove(zfile);
                              } while (fndnxt(tmpff));
                         }
                         printf("\nRemoving directory %-21.21s",idir);
                         rmdir(idir);
                    }
               }
          }
     }
     rstwin();
     if (mode == INSTALL && c != ESC) {
          sprintf(doscmd,"type %s\\map.ans",dlist[0]);
          system(doscmd);
          setatr(0x0F);
          printf("                        << any key when ready >>");
          getch();
     }
     rstscn();
     exit(0);
}
