/***************************************************************************/
/*   KEYCODES.C     - program to display "make" and "break" keycodes for   */
/*                  IBM PC's.                                              */
/*                                                                         */
/*                  "break" codes (when the key is released) is simply the */
/*                  "make" code value plus 128.                            */
/*                                                                         */
/*   to compile:    bcc -ml keycodes.c                                     */
/*                                                                         */
/*                                                     12/05/91 Les Bird   */
/***************************************************************************/

#include "stdio.h"
#include "dos.h"

int  done;

void interrupt (*oldkeyi)();
void interrupt newkeyi(void);

void interrupt                /* new interrupt code for keyboard           */
newkeyi(void)
{
     unsigned char v;

     if (inportb(0x64)&0x01) {     /* read the status reg, output buf full?*/
          v=inportb(0x60);         /* read the scan code..                 */
          printf("%d\n",v);        /*   ..and display it.                  */
          outportb(0x20,0x20);     /* send EOI code (end of interrupt)     */
          if (v == 129) {          /* if release code 129 (ESC key)..      */
               if (++done == 2) {  /*   .. pressed twice? ..               */
                    setvect(0x09,oldkeyi);   /* restore original int. vect */
               }
          }
     }
     enable();                /* turn on interrupt processing.             */
}

void
main(void)
{
     disable();               /* turn off interrupt processing.            */
     oldkeyi=getvect(0x09);   /* get original keyboard interrupt vector    */
     setvect(0x09,newkeyi);   /* setup new interrupt vector                */
     enable();                /* process interrupts...                     */
     done=0;
     printf("\nPress ESC twice to quit\n");
     while (done < 2) {
     }
}
