/***************************************************************************
 *                                                                         *
 *  FLKICK.C                                                               *
 *                                                                         *
 *  Copyright (C) 1989 GALACTICOMM, Inc.                                   *
 *                                                                         *
 *  This source is for use by Galacticomm "FLASH" Protocol Licensees ONLY. *
 *  Any use of the contents of this file, or any functional derivative or  *
 *  part or portion thereof, outside of the provisions of the Galacticomm  *
 *  "FLASH" Protocol Developers' License Agreement is strictly prohibited. *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *  This is the Flash utility real-time kicktable handler, which invokes   *
 *  a subroutine a specified number "ticks" (calls to prcrtk()) from the   *
 *  present time.                                                          *
 *                                                                         *
 *                                            - T. Stryker 5/19/89         *
 *                                                                         *
 ***************************************************************************/
 
#define KTSIZE 70                  /* kicktable size                       */
 
struct kook {                      /* kicktable entry layout               */
     int countr;                   /*   number of intervals yet to go      */
     int (*dest)();                /*   subroutine address to invoke       */
     long parm1;                   /*   parm 1 to pass when kicking off    */
     long parm2;                   /*   parm 2 to pass when kicking off    */
     long parm3;                   /*   parm 3 to pass when kicking off    */
} kcktbl[KTSIZE],*kckptr;
 
inirtk()                           /* initialize real-time kicktable       */
{
     int i;
 
     for (i=0,kckptr=kcktbl ; i < KTSIZE ; i++,kckptr++) {
          kckptr->countr=0;
     }
}
 
rtkick(delay,dstrou,p1,p2,p3)      /* real-time kicktable handler          */
int delay;
int (*dstrou)();
long p1,p2,p3;
{
     int i;
     struct kook *sptr;
 
     for (i=0,sptr=kcktbl+KTSIZE-1 ; i < KTSIZE ; i++,sptr--) {
          if (sptr->countr == 0) {
               sptr->countr=delay;
               sptr->dest=dstrou;
               sptr->parm1=p1;
               sptr->parm2=p2;
               sptr->parm3=p3;
               return;
          }
     }
     catastro("RTKICK: KCKTBL OVERFLOW");
}
 
prcrtk()                           /* call an rtkick's specified routine   */
{
     int i;
 
     for (i=0,kckptr=kcktbl ; i < KTSIZE ; i++,kckptr++) {
          if (kckptr->countr != 0 && --(kckptr->countr) == 0) {
               (*(kckptr->dest))(kckptr->parm1,kckptr->parm2,kckptr->parm3);
          }
     }
}
