/***************************************************************************
 *                                                                         *
 *   PORTABLE.H                                                            *
 *                                                                         *
 *   Copyright (C) 1988 GALACTICOMM, Inc.      All Rights Reserved.        *
 *                                                                         *
 *   This header file supports compatibility of the source code of The     *
 *   Major BBS with multiple C language compilers, specifically, those     *
 *   of Microsoft, Lattice, and Borland (Turbo).                           *
 *                                                                         *
 *   This declaration:  include "portable.h"  should appear in each        *
 *   source file, immediately following the other include directives.      *
 *                                                                         *
 *                                 WARNING!                                *
 *                                                                         *
 *   Your compiler command line must define one of these symbols:          *
 *   MSC_C  LSC_C  or  TSC_C   This identifies the C compiler              *
 *   (Microsoft, Lattice, or Turbo).  If Microsoft C 5.0 is in use,        *
 *   you must also define the symbol MS5.                                  *
 *                                                                         *
 *                                              - R. Stein 1/24/88         *
 *                                                                         *
 ***************************************************************************/
 
#ifdef LSC_C
char *getml();
#define ADDR_OFdisaster     &disaster
#define ADDR_OFeximod       &eximod
#define FOPRB  "rb"     /* fopen() 2nd parameter for read binary mode       */
#define FOPRA  "ra"     /* fopen() 2nd parameter for read ASCII mode        */
#define FOPWB  "wb"     /* fopen() 2nd parameter for write binary mode      */
#define FOPWA  "wa"     /* fopen() 2nd parameter for write ASCII mode       */
#define FOPRWB "rb+"    /* fopen() 2nd parameter for read/write binary mode */
#define FOPRWA "ra+"    /* fopen() 2nd parameter for read/write ASCII mode  */
#define FOPAB  "ab"     /* fopen() 2nd parameter for append binary mode     */
#define FOPAA  "aa"     /* fopen() 2nd parameter for append ASCII mode      */
#define CNTLIT 1        /* does sscanf() count literal matches?             */
#define CFREGS 0        /* 0=no cflag field in REGS, use int86() ret value  */
#define CKNOWN
#endif
 
#ifdef MSC_C
#define allmem()            ;
#define setmem(p,n,c)       memset(p,c,n)
#define getml(ln)           halloc(ln,1)
char huge *halloc();
#define ADDR_OFdisaster     disaster
#define ADDR_OFeximod       eximod
#define FOPRB  "rb"     /* fopen() 2nd parameter for read binary mode       */
#define FOPRA  "ra"     /* fopen() 2nd parameter for read ASCII mode        */
#define FOPWB  "wb"     /* fopen() 2nd parameter for write binary mode      */
#define FOPWA  "wa"     /* fopen() 2nd parameter for write ASCII mode       */
#define FOPRWB "r+b"    /* fopen() 2nd parameter for read/write binary mode */
#define FOPRWA "r+a"    /* fopen() 2nd parameter for read/write ASCII mode  */
#define FOPAB  "ab"     /* fopen() 2nd parameter for append binary mode     */
#define FOPAA  "aa"     /* fopen() 2nd parameter for append ASCII mode      */
#define CNTLIT 0        /* does sscanf() count literal matches?             */
#define CFREGS 1        /* REGS has a cflag field (see TurboC dos.h)        */
#define CKNOWN
#ifdef MS5
#define movmem(s,d,n)       memmove(d,s,n)   /* microsoft 5.0 memcpy does   */
#else                                        /*   not deal with overlaps    */
#define movmem(s,d,n)       memcpy(d,s,n)
#endif
#endif
 
#ifdef TSC_C
#define allmem()            ;
#define sizmem()            coreleft()
#define getml(ln)           farmalloc(ln)
void far *farmalloc(unsigned long size);
#define ADDR_OFdisaster     disaster
#define ADDR_OFeximod       eximod
#define FOPRB  "rb"     /* fopen() 2nd parameter for read binary mode       */
#define FOPRA  "rt"     /* fopen() 2nd parameter for read ASCII mode        */
#define FOPWB  "wb"     /* fopen() 2nd parameter for write binary mode      */
#define FOPWA  "wt"     /* fopen() 2nd parameter for write ASCII mode       */
#define FOPRWB "r+b"    /* fopen() 2nd parameter for read/write binary mode */
#define FOPRWA "r+t"    /* fopen() 2nd parameter for read/write ASCII mode  */
#define FOPAB  "ab"     /* fopen() 2nd parameter for append binary mode     */
#define FOPAA  "at"     /* fopen() 2nd parameter for append ASCII mode      */
#define CNTLIT 0        /* does sscanf() count literal matches?             */
#define CFREGS 1        /* REGS has a cflag field (see TurboC dos.h)        */
#define CKNOWN
#endif
 
#ifndef min
#define min(a,b)        (((a) < (b)) ? (a) : (b))
#define max(a,b)        (((a) > (b)) ? (a) : (b))
#define abs(a)          (((a) < 0) ? -(a) : (a))
#endif
 
#ifdef CKNOWN
#undef CKNOWN
#else
#error YOU SHOULD IDENTIFY THE COMPILER!  (See the warning in PORTABLE.H)
#endif
 
