/***************************************************************************
 *                                                                         *
 *  FTNOISE.C                                                              *
 *                                                                         *
 *  Copyright (C) 1989 GALACTICOMM, Inc.                                   *
 *                                                                         *
 *  This source is for use by Galacticomm "FLASH" Protocol Licensees ONLY. *
 *  Any use of the contents of this file, or any functional derivative or  *
 *  part or portion thereof, outside of the provisions of the Galacticomm  *
 *  "FLASH" Protocol Developers' License Agreement is strictly prohibited. *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *  This file contains the Flash Tank C sound effects code.  This works    *
 *  in close conjunction with the routines in NOISES.ASM.                  *
 *                                                                         *
 *                                            - T. Stryker 12/26/89        *
 *                                            - Les Bird    5/13/91        *
 *                                                                         *
 ***************************************************************************/
 
#include "portable.h"
#include "ftsnds.h"
 
int fornoi=0,                      /* foreground noise number in effect    */
    bcknoi=0,                      /* background noise number in effect    */
    period;                        /* period for return to noisemaker      */
 
int enoise=1;                      /* enable-noise flag                    */
 
extern
int fstick,                        /* fast-ticker (145.6 Hz)               */
    forctr,                        /* "foreground" noise counter (145.6 Hz)*/
    bckctr,                        /* "background" noise counter (145.6 Hz)*/
    pyrn;
 
int chbeep(),bell(),bonus();
 
int (*fnorou[])()={                /* "foreground" noise routine ptrs      */
     chbeep,bell,bonus
};
 
int nada(),newusr(),byeusr(),blowup(),shoot(),dropm();
 
int (*bnorou[])()={                /* "background" noise routine ptrs      */
     nada,newusr,byeusr,blowup,shoot,dropm
};
 
noise(n)                           /* make a noise                         */
int n;                             /*    noise number from FCNOISE.H       */
{
     if (enoise) {
          if (n > 99) {
               forctr=0;
               setnoi(fnorou[(fornoi=n)-100]);
          }
          else {
               bckctr=0;
               bcknoi=n;
               if (fornoi == 0) {
                    setnoi(bnorou[bcknoi]);
               }
          }
     }
}
 
nada()                             /* no noise                             */
{
     return(0);
}
 
chbeep()                           /* chat beep                            */
{
     period=0x180+(pyrn*0x80);
     if (forctr >= 5) {
          fornoi=0;
          setnoi(bnorou[bcknoi]);
     }
     return(period);
}
 
bell()                             /* terminal-mode bell                   */
{
     if (forctr >= 20) {
          fornoi=0;
          setnoi(bnorou[bcknoi]);
     }
     return(1000);
}
 
newusr()                           /* new-user tune (background)           */
{
     period=1000-bckctr;
     bckctr+=50;
     if (!enoise || period < 250) {
          bcknoi=0;
          setnoi(nada);
     }
     return(period);
}

byeusr()                           /* user left the line-up                */
{
     period=250+bckctr;
     bckctr+=50;
     if (!enoise || period >= 1000) {
          bcknoi=0;
          setnoi(nada);
     }
     return(period);
}

blowup()                           /* user got hit by mine or shell        */
{
     int bpseq[]={
          10000, 8000,15000, 2000, 9000,12000, 8000,15000, 5000,15000,
          15000, 5000,15000, 8000,12000, 9000, 2000,15000, 8000,10000,
          10000, 8000,15000, 2000, 9000,12000, 8000,15000, 5000,15000,
          15000, 5000,15000, 8000,12000, 9000, 2000,15000, 8000,10000,
          10000, 8000,15000, 2000, 9000,12000, 8000,15000, 5000,15000,
          15000, 5000,15000, 8000,12000, 9000, 2000,15000, 8000,10000,
          10000, 8000,15000, 2000, 9000,12000, 8000,15000, 5000,15000,
          15000, 5000,15000, 8000,12000, 9000, 2000,15000, 8000,10000,
          10000, 8000,15000, 2000, 9000,12000, 8000,15000, 5000,15000,
          15000, 5000,15000, 8000,12000, 9000, 2000,15000, 8000,10000
     };

     if (!enoise || bckctr > sizeof(bpseq)/sizeof(int)) {
          bcknoi=0;
          setnoi(nada);
     }
     period=bpseq[bckctr++];
     return(period);
}

shoot()                            /* noise when player fires shell        */
{
     int bpseq[]={
          10000, 5000,    0,
          12000, 7000,    0,
          14000, 9000,    0
     };

     if (!enoise || bckctr > sizeof(bpseq)/sizeof(int)) {
          bcknoi=0;
          setnoi(nada);
     }
     period=bpseq[bckctr++];
     return(period);
}

dropm()                            /* noise when player drops a mine       */
{
     int bpseq[]={
          15000,2000,0,
          12000,4000,0,
          10000,6000,0
     };

     if (!enoise || bckctr > sizeof(bpseq)/sizeof(int)) {
          bcknoi=0;
          setnoi(nada);
     }
     period=bpseq[bckctr++];
     return(period);
}

bonus()                            /* noise if bonus tank awarded          */
{
     int bpseq[]={
           4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000,
              0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
           4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000,
              0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
           4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000,
              0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
           4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000,
              0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
           4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000,
              0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
           4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000
     };

     if (!enoise || forctr > sizeof(bpseq)/sizeof(int)) {
          fornoi=0;
          setnoi(bnorou[bcknoi]);
     }
     period=bpseq[forctr++];
     return(period);
}
