/***************************************************************************
 *                                                                         *
 *  FLCOMM.C                                                               *
 *                                                                         *
 *  Copyright (C) 1989 GALACTICOMM, Inc.                                   *
 *                                                                         *
 *  This source is for use by Galacticomm "FLASH" Protocol Licensees ONLY. *
 *  Any use of the contents of this file, or any functional derivative or  *
 *  part or portion thereof, outside of the provisions of the Galacticomm  *
 *  "FLASH" Protocol Developers' License Agreement is strictly prohibited. *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *  This file contains the user-side Flash Protocol setup and support      *
 *  routines, in a general-purpose form that can be used for any Flash     *
 *  game.                                                                  *
 *                                                                         *
 *                                            - T. Stryker 5/27/89         *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "dos.h"
#include "dosface.h"
#include "fkcode.h"
#include "portable.h"
#include "ftanks.h"
 
int npyrs,                    /* number of players in Flash pool           */
    pyrn;                     /* player number that input was received for */
char *names[MAXPYR+2];        /* user name as function of user number      */
int rseed;                    /* random number generator seed              */
int solo;                     /* flag indicating solo operation            */
 
#define OKDSIZ  512           /* OK-data buffer size                       */
#define OKMASK  (OKDSIZ-1)    /* mask for buffer index wraparound          */
 
static
char okdata[OKDSIZ];          /* OK-data (error-corrected data) buffer     */
 
                              /* communications state-machine states:      */
#define EXPHDR    1           /*    expecting header byte (even parity)    */
#define EXPBDY    2           /*    expecting body byte (odd parity)       */
#define XPHNKA    3           /*    expecting a NAK-ACK header byte        */
#define XPBNKA    4           /*    expecting a NAK-ACK body byte          */
 
static
int indact,                   /* input-data ahead-counter                  */
    okdact,                   /* OK-data ahead-counter                     */
    okdbct;                   /* OK-data behind-counter                    */
 
static
int naknum,                   /* number accompanying most recent NAK       */
    w4nact;                   /* ctr for waiting out 3 packets after NAK   */
 
static
char lupbuf[(MAXPYR+3)*UIDSIZ],*lupptr; /* LINEUP buffer & scratch ptr     */
static
long flsser,                  /* serial number used in entry attempt       */
     lupser,                  /* LINEUP serial number received             */
     flmcld;                  /* flashm() has-been-called flag             */
 
static                        /* special (non-printable) key codes         */
int spcls[32]={
     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     -1,                /* NAK */
     0,0,
     -1,                /* CAN */
     0,0,0,0,0,0,0
};
 
static
int escdpn=-1;                /* "escaped" player no. pending (-1 if none) */
 
extern
int enoise;                   /* enable-noise flag                         */
 
inicom(argc,argv)             /* initialize communications                 */
int argc;
char *argv[];
{
     static char *ptnams[]={
          "1","com1","2","com2","3","com3","4","com4","solo",""
     };
     static char chrbuf[20];
     int x;
     char *chrp;
 
     if (argc > 1) {
          strncpy(chrbuf,argv[1],sizeof(chrbuf)-1);
     }
     while (1) {
          for (chrp=chrbuf ; *chrp != '\0' ; chrp++) {
               if (isalnum(*chrp)) {
                    *chrp=tolower(*chrp);
               }
               else {
                    *chrp='\0';
                    break;
               }
          }
          if ((x=tblidx(chrbuf,ptnams)) >= 0) {
               break;
          }
          if (chrbuf[0] == '\0') {
               printf("\nYou need to specify a port for communications,\n");
               printf("or indicate that there will be no communications\n");
               printf("by typing the word SOLO.\n");
          }
          else {
               printf("\nPlease enter a number 1 through 4, or type\n");
               printf("the word \"SOLO\" (without the quotes).\n");
          }
          printf("\n  1. COM1\n  2. COM2\n  3. COM3\n  4. COM4\n");
          printf("\nPlease select one of the above, or SOLO: ");
          if (fgets(chrbuf,sizeof(chrbuf),stdin) == NULL) {
               exit();
          }
     }
     switch (x) {
     case 0:
     case 1:
          iniser(0,0x3F8,4);
          break;
     case 2:
     case 3:
          iniser(0,0x2F8,3);
          break;
     case 4:
     case 5:
          iniser(0,0x3E8,4);
          break;
     case 6:
     case 7:
          iniser(0,0x2E8,3);
          break;
     case 8:
          solo=1;
          npyrs=1;
          rseed=now();
     }
}
 
flashm(namver,serno)          /* attempt to enter Flash Protocol operation */
char *namver;
long serno;
{
     char *sptr;
     int c;
     static char idstg[120],serstg[16];
 
     flmcld=1;
     lvpool();
     if (serno == 0) {
          strcpy(serstg,"/");
     }
     else {
          sprintf(serstg,"#%ld",serno);
     }
     flsser=serno;
     sprintf(idstg,"\b%s %s Flash Protocol Copyright 1989 Galacticomm, Inc.\r",
             namver,serstg);
     for (sptr=idstg ; *sptr != '\0' ; sptr++) {
          outser(0,*sptr);
          for (fstick=0 ; fstick < 4 ; ) {   /* fstick auto-incs at 145.6 Hz */
               if ((c=rdser(0)) == *sptr) {
                    break;
               }
               if (c == '\0') {
                    return;
               }
          }
     }
}
 
parsln()                      /* parse LINEUP received                     */
{
     char *inpptr;
     long atol();
 
     npyrs=0;
     inpptr=lupbuf-1;
     while (1) {
          while (*++inpptr == ' ') {
          }
          if (npyrs >= MAXPYR+2) {
               catastro("Too many players! Try later or change channels.");
          }
          if (*inpptr == '*') {
               inpptr+=1;
          }
          names[npyrs++]=inpptr;
          while (*++inpptr != ' ') {
               if (*inpptr == '\0') {
                    if (names[npyrs-1][0] == '#') {
                         lupser=atol(names[--npyrs]+1);
                    }
                    else {
                         lupser=0L;
                    }
                    rseed=atoi(names[--npyrs]);
                    if ((flsser>=900000000L)&&(lupser==(flsser-900000000L))){
                         return(1);
                    }
                    else if ((flsser>=900000000L)&&(lupser!=(flsser-900000000L))){
                         return(0);
                    }
                    else {
                         return(lupser == flsser && flmcld);
                    }
               }
          }
          *inpptr='\0';
     }
}
 
tblidx(stg,stgtbl)            /* find a string in a table of strings       */
char *stg;
char *stgtbl[];
{
     int i;
 
     for (i=0 ; *stgtbl[i] != '\0' ; i++) {
          if (strcmp(stg,stgtbl[i]) == 0) {
               return(i);
          }
     }
     return(-1);
}
 
setspc(sparr)                 /* set special (non-printable) key codes     */
int *sparr;
{
     int n;
 
     for (n=0 ; *sparr != 0 && n < sizeof(spcls)/sizeof(int) ; n++) {
          if (spcls[n] >= 0) {
               spcls[n]=*sparr++;
          }
     }
}
 
prcrin()                      /* process raw Flash Protocol input          */
{
     int c,i;
     static int comstt=EXPHDR;
     static int crc3,pakctr,pakcrc,paklen;
     static char pakbuf[15];
 
     if (!solo) {
          while ((c=rdser(0)) != EOF) {
               fstick=0;
               switch (comstt) {
               case EXPHDR:
                    if (c != odd(c) && (paklen=(c&15)) != 0) {
                         crc3=(c&0x70);
                         pakctr=0;
                         pakcrc=0;
                         comstt=EXPBDY;
                    }
                    else {
                         outnak();
                         comstt=XPHNKA;
                    }
                    break;
               case EXPBDY:
                    if (c == odd(c)) {
                         if (pakctr == paklen) {
                              if ((pakcrc&127) == (c&127)
                               && ((pakcrc>>3)&0x70) == crc3) {
                                   if (pakbuf[0] != NAKACK) {
                                        takeok(pakbuf,paklen);
                                        comstt=EXPHDR;
                                   }
                                   else if (pakbuf[1] == naknum) {
                                        indact=naknum<<2;
                                        takeok(pakbuf+2,paklen-2);
                                        comstt=EXPHDR;
                                   }
                                   else {
                                        outnak();
                                        comstt=XPHNKA;
                                   }
                              }
                              else {
                                   outnak();
                                   comstt=XPHNKA;
                              }
                         }
                         else {
                              pakcrc=calcrc(pakcrc,c);
                              pakbuf[pakctr++]=(c&127);
                         }
                    }
                    else {
                         outnak();
                         comstt=XPHNKA;
                    }
                    break;
               case XPHNKA:
                    if (c != odd(c) && (paklen=(c&15)) != 0) {
                         crc3=(c&0x70);
                         pakctr=0;
                         pakcrc=0;
                         comstt=XPBNKA;
                    }
                    break;
               case XPBNKA:
                    if (c == odd(c)) {
                         if (pakctr == paklen) {
                              if ((pakcrc&127) == (c&127)
                               && ((pakcrc>>3)&0x70) == crc3) {
                                   if (pakbuf[0] != NAKACK) {
                                        if (++w4nact == 3) {
                                             outnak();
                                        }
                                        comstt=XPHNKA;
                                   }
                                   else if (pakbuf[1] == naknum) {
                                        indact=naknum<<2;
                                        takeok(pakbuf+2,paklen-2);
                                        comstt=EXPHDR;
                                   }
                                   else {
                                        outnak();
                                        comstt=XPHNKA;
                                   }
                              }
                              else {
                                   comstt=XPHNKA;
                              }
                         }
                         else {
                              pakcrc=calcrc(pakcrc,c);
                              pakbuf[pakctr++]=(c&127);
                         }
                    }
                    else if ((paklen=(c&15)) != 0) {
                         crc3=(c&0x70);
                         pakctr=0;
                         pakcrc=0;
                    }
                    else {
                         comstt=XPHNKA;
                    }
                    break;
               }
          }
          if (fstick >= 150) {
               okdata[okdact]=NODATA;
               okdact=((okdact+1)&OKMASK);
               fstick=0;
          }
     }
}
 
outnak()                      /* output a NAK w/appropriate location code  */
{
     outser(0,NAK);                     /* NAK is odd parity as it stands  */
     outser(0,naknum=(okdact>>2));      /* parity bit on this is ignored   */
     w4nact=0;
}
 
takeok(buf,len)               /* take received data as "OK"                */
char *buf;
int len;
{
     int i;
 
     for (i=0 ; i < len ; i++) {
          if (indact == okdact) {
               okdata[okdact]=buf[i];
               okdact=((okdact+1)&OKMASK);
               if (okdact == okdbct) {
                    catastro("OKDATA OVERFLOW");
               }
          }
          indact=((indact+1)&OKMASK);
     }
}
 
clreci()                      /* clear error-correcting input stuff        */
{
     okdbct=okdact=indact=0;
     escdpn=-1;
     lupptr=NULL;
}
 
ecinp()                       /* get a byte of error-corrected input       */
{
     int c;
 
     prcrin();
     if (okdbct != okdact) {
          c=okdata[okdbct];
          okdbct=((okdbct+1)&OKMASK);
          if (escdpn >= 0) {
               pyrn=escdpn;
               escdpn=-1;
          }
          else if (lupptr != NULL) {
               if (c == LINEUP) {
                    *lupptr='\0';
                    lupptr=NULL;
                    return(-c);
               }
               *lupptr++=c;
               if (lupptr-lupbuf >= sizeof(lupbuf)-1) {
                    catastro("LINEUP TOO LONG: %s",lupbuf);
               }
               return(-1);
          }
          else if (c < 110) {
               pyrn=c%10;
               c/=10;
          }
          else if (c < 120) {
               if (okdbct != okdact) {
                    pyrn=c-110;
                    c=okdata[okdbct];
                    okdbct=((okdbct+1)&OKMASK);
               }
               else {
                    escdpn=c-110;
                    return(-1);
               }
          }
          else if (c == LINEUP) {
               lupptr=lupbuf;
               return(-1);
          }
          else if (c == REMOVE) {
               if (okdbct == okdact) {
                    okdbct=((okdbct-1)&OKMASK);
                    return(-1);
               }
               else {
                    escdpn=1;
                    return(-REMOVE);
               }
          }
          else {
               return(-c);
          }
     }
     else {
          return(-1);
     }
     if (pyrn >= npyrs) {
          catastro("BAD PYRN=%d ... NPYRS=%d",pyrn,npyrs);
     }
     if (c < sizeof(spcls)/sizeof(int)) {
          c=spcls[c];
     }
     return(c);
}
 
ecoutp(c)                     /* output a key code to BBS                  */
int c;
{
     int i,*sp;
 
     for (i=0,sp=spcls ; i < sizeof(spcls)/sizeof(int) ; i++,sp++) {
          if (c == *sp) {
               eco(i);
               return;
          }
          if (*sp == 0) {
               break;
          }
     }
     if (c <= 127 && c >= 32) {
          eco(c);
     }
     else if (c == 0x2F00) {       /* alt-V */
          enoise^=1;
     }
}
 
eco(c)                        /* low-level output utility                  */
char c;
{
     static char pair[2]={110,0};
 
     if (solo) {
          pair[1]=c;
          takeok(pair,2);
     }
     else {
          outser(0,odd(c));
     }
}
 
lvpool()                      /* leaving pool, tell the BBS about it       */
{
     outser(0,CAN);
     outser(0,CAN);
     outser(0,CAN);
     for (fstick=0 ; fstick < 12 ; ) {       /* this auto-incs at 145.6 Hz */
     }
}
