/***************************************************************************
 *                                                                         *
 *  FTCHAT.C                                                               *
 *                                                                         *
 *  Copyright (C) 1991 Galacticomm, Inc. by Les Bird & Tim Stryker         *
 *                                                                         *
 *  This source is the basic Flash Chat module provided with the "FLASH"   *
 *  Developer's Toolkit with modifications for Flash Tank.                 *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "stdlib.h"
#include "ctype.h"
#include "setjmp.h"
#include "dos.h"
#include "dosface.h"
#include "fkcode.h"
#include "portable.h"
#include "ftanks.h"
#include "ftsnds.h"
 
#define AT4WRT 0x0A           /* attribute for writes inside chat-windows  */
#define AT4CHW 0x0B           /* attribute for the chat-windows themselves */
 
                              /* screen-image table indexes                */
#define SFCHAT      0         /*    main flash chat screen                 */
#define SFCHELP     1         /*    flash chat help screen                 */
#define SFCHELP1    2         /*    help screen #2                         */
#define SFCHELP2    3         /*    help screen #3                         */
#define SFCHELP3    4         /*    help screen #4                         */
#define SFCHELPT    5         /*    terminal-mode help screen              */

#define ALTC        11776     /* keycode for ALT-C keystroke               */
#define ALTD        8192      /*   "    "    ALT-D     "                   */
#define ALTO        6144      /*   "    "    ALT-O     "                   */
#define ALTX        11520     /*   "    "    ALT-X     "                   */
#define ALTZ        11264     /*   "    "    ALT-Z     "                   */

#define scrnad(x,y) (frzseg()+(x)*2+(y)*160)   /* CRT address of (x,y)     */

extern
char scntbl[],                /* in-memory screen-image table              */
     rg[],rs[];

extern
int  compd[MAXPYR][MAXCOM],
     compx[MAXPYR][MAXCOM],
     compy[MAXPYR][MAXCOM],
     cretar(),
     endogam,
     ingame(),
     namtmr,
     omode,
     startd[MAXPYR][MAXPYR],  /* starting positions for tanks              */
     startx[MAXPYR][MAXPYR],
     starty[MAXPYR][MAXPYR],
     tensec(),
     tentmr;

extern
jmp_buf disaster;             /* master error-recovery longjmp save block  */

extern
long rn;

struct player player[MAXPYR+MAXCOM+1],
              *optr,*pyrp,*tankptr;

struct debug debug,*dbg;

int  byself,                  /* non-zero if playing alone while online    */
     compena,                 /* enable computer players                   */
     compplr,                 /* number of artificial players              */
     disp,                    /* the received character is this guy's      */
     gpyrs,                   /* actual number of players in game          */
     gtype,                   /* ingame() value for player[self]           */
     hlpscn[MAXPYR],          /* per user help screens                     */
     ogtyp,                   /* ingame() value for player[n] (other plr)  */
     omode,                   /* old video mode                            */
     onscrn,                  /* on-screen flag (help-screen-bar)          */
     ostick,                  /* used in SOLO for old fstick value         */
     ready[5],                /* array of games selected to play           */
     self,                    /* this user's own user number (0-5)         */
     tpyrs,                   /* total players including computers         */
     trmscx,                  /* terminal-mode saved x cursor position     */
     trmscy;                  /* terminal-mode saved y cursor position     */

int  compn[MAXPYR]={
     5,4,3,2,1,0
};

char gname[]={"Flash Tank"},
     gvers[]={"V1.4"},
     trmscn[4000];            /* saved terminal-mode screen image          */

char *frzseg();               /* CRT screen address (from MBBST.LIB)       */

char targmsg[]={
     ' ',0x10,'S',0x10,'H',0x10,'O',0x10,'O',0x10,'T',0x10,' ',0x10,'M',0x10,
     'O',0x10,'V',0x10,'I',0x10,'N',0x10,'G',0x10,' ',0x10,'D',0x10,'R',0x10,
     'O',0x10,'N',0x10,'E',0x10,'S',0x10,' ',0x10,'A',0x10,'N',0x10,'D',0x10,
     ' ',0x10,'O',0x10,'T',0x10,'H',0x10,'E',0x10,'R',0x10,' ',0x10,'P',0x10,
     'L',0x10,'A',0x10,'Y',0x10,'E',0x10,'R',0x10,'S',0x10,' ',0x10,'U',0x10,
     'N',0x10,'T',0x10,'I',0x10,'L',0x10,' ',0x10,'F',0x10,'I',0x10,'R',0x10,
     'S',0x10,'T',0x10,' ',0x10,'S',0x10,'C',0x10,'O',0x10,'R',0x10,'E',0x10,
     ' ',0x10,'O',0x10,'F',0x10,' ',0x10,'5',0x10,'0',0x10,'0',0x10,' ',0x10,
     '(',0x10,'P',0x10,'R',0x10,'E',0x10,'S',0x10,'S',0x10,' ',0x10,'F',0x10,
     '5',0x10,')',0x10,' ',0x10,' ',0x10,' ',0x10,' ',0x10
};
char timemsg[]={
     ' ',0x20,' ',0x20,' ',0x20,' ',0x20,' ',0x20,' ',0x20,' ',0x20,' ',0x20,
     ' ',0x20,' ',0x20,' ',0x20,' ',0x20,'P',0x20,'L',0x20,'A',0x20,'Y',0x20,
     ' ',0x20,'U',0x20,'N',0x20,'T',0x20,'I',0x20,'L',0x20,' ',0x20,' ',0x20,
     '2',0x20,' ',0x20,' ',0x20,'M',0x20,'I',0x20,'N',0x20,'U',0x20,'T',0x20,
     'E',0x20,' ',0x20,'T',0x20,'I',0x20,'M',0x20,'E',0x20,'R',0x20,' ',0x20,
     'E',0x20,'X',0x20,'P',0x20,'I',0x20,'R',0x20,'E',0x20,'S',0x20,' ',0x20,
     ' ',0x20,' ',0x20,' ',0x20,' ',0x20,' ',0x20,' ',0x20,' ',0x20,' ',0x20,
     ' ',0x20,' ',0x20,' ',0x20,' ',0x20,' ',0x20,' ',0x20,' ',0x20,' ',0x20,
     '(',0x20,'P',0x20,'R',0x20,'E',0x20,'S',0x20,'S',0x20,' ',0x20,'F',0x20,
     '6',0x20,')',0x20,' ',0x20,' ',0x20,' ',0x20,' ',0x20
};
char scormsg[]={
     ' ',0x30,' ',0x30,' ',0x30,' ',0x30,' ',0x30,'P',0x30,'L',0x30,'A',0x30,
     'Y',0x30,' ',0x30,'U',0x30,'N',0x30,'T',0x30,'I',0x30,'L',0x30,' ',0x30,
     'F',0x30,'I',0x30,'R',0x30,'S',0x30,'T',0x30,' ',0x30,'P',0x30,'E',0x30,
     'R',0x30,'S',0x30,'O',0x30,'N',0x30,' ',0x30,'R',0x30,'E',0x30,'A',0x30,
     'C',0x30,'H',0x30,'E',0x30,'S',0x30,' ',0x30,'A',0x30,' ',0x30,'S',0x30,
     'C',0x30,'O',0x30,'R',0x30,'E',0x30,' ',0x30,'O',0x30,'F',0x30,' ',0x30,
     '4',0x30,'0',0x30,'0',0x30,' ',0x30,'P',0x30,'O',0x30,'I',0x30,'N',0x30,
     'T',0x30,'S',0x30,' ',0x30,' ',0x30,' ',0x30,' ',0x30,' ',0x30,' ',0x30,
     '(',0x30,'P',0x30,'R',0x30,'E',0x30,'S',0x30,'S',0x30,' ',0x30,'F',0x30,
     '7',0x30,')',0x30,' ',0x30,' ',0x30,' ',0x30,' ',0x30
};
char tankmsg[]={
     ' ',0x50,' ',0x50,' ',0x50,' ',0x50,' ',0x50,' ',0x50,' ',0x50,'P',0x50,
     'L',0x50,'A',0x50,'Y',0x50,' ',0x50,'U',0x50,'N',0x50,'T',0x50,'I',0x50,
     'L',0x50,' ',0x50,'T',0x50,'A',0x50,'N',0x50,'K',0x50,'S',0x50,' ',0x50,
     'A',0x50,'R',0x50,'E',0x50,' ',0x50,'G',0x50,'O',0x50,'N',0x50,'E',0x50,
     ' ',0x50,'A',0x50,'N',0x50,'D',0x50,' ',0x50,'O',0x50,'N',0x50,'E',0x50,
     ' ',0x50,'P',0x50,'E',0x50,'R',0x50,'S',0x50,'O',0x50,'N',0x50,' ',0x50,
     'I',0x50,'S',0x50,' ',0x50,'L',0x50,'E',0x50,'F',0x50,'T',0x50,' ',0x50,
     ' ',0x50,' ',0x50,' ',0x50,' ',0x50,' ',0x50,' ',0x50,' ',0x50,' ',0x50,
     '(',0x50,'P',0x50,'R',0x50,'E',0x50,'S',0x50,'S',0x50,' ',0x50,'F',0x50,
     '8',0x50,')',0x50,' ',0x50,' ',0x50,' ',0x50,' ',0x50
};
char nolimsg[]={
     ' ',0x60,' ',0x60,' ',0x60,' ',0x60,' ',0x60,' ',0x60,' ',0x60,' ',0x60,
     ' ',0x60,' ',0x60,'N',0x60,'O',0x60,' ',0x60,'L',0x60,'I',0x60,'M',0x60,
     'I',0x60,'T',0x60,'A',0x60,'T',0x60,'I',0x60,'O',0x60,'N',0x60,'S',0x60,
     ' ',0x60,' ',0x60,'-',0x60,' ',0x60,' ',0x60,' ',0x60,'O',0x60,'P',0x60,
     'E',0x60,'N',0x60,' ',0x60,'F',0x60,'I',0x60,'E',0x60,'L',0x60,'D',0x60,
     ' ',0x60,' ',0x60,' ',0x60,' ',0x60,' ',0x60,' ',0x60,' ',0x60,' ',0x60,
     ' ',0x60,' ',0x60,' ',0x60,' ',0x60,' ',0x60,' ',0x60,' ',0x60,' ',0x60,
     ' ',0x60,' ',0x60,' ',0x60,' ',0x60,' ',0x60,' ',0x60,' ',0x60,' ',0x60,
     '(',0x60,'P',0x60,'R',0x60,'E',0x60,'S',0x60,'S',0x60,' ',0x60,'F',0x60,
     '4',0x60,')',0x60,' ',0x60,' ',0x60,' ',0x60,' ',0x60
};
char helpmsg[]={
     ' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,
     ' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,
     ' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,
     ' ',0x70,' ',0x70,' ',0x70,'R',0x70,'E',0x70,'A',0x70,'D',0x70,'I',0x70,
     'N',0x70,'G',0x70,' ',0x70,'T',0x70,'H',0x70,'E',0x70,' ',0x70,'H',0x70,
     'E',0x70,'L',0x70,'P',0x70,' ',0x70,'S',0x70,'C',0x70,'R',0x70,'E',0x70,
     'E',0x70,'N',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,
     ' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,
     ' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,
     ' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70,' ',0x70
};
char noevga[]={
     ' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,
     ' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,
     ' ',0xCF,' ',0xCF,' ',0xCF,'M',0xCF,'U',0xCF,'S',0xCF,'T',0xCF,' ',0xCF,
     'H',0xCF,'A',0xCF,'V',0xCF,'E',0xCF,' ',0xCF,'E',0xCF,'G',0xCF,'A',0xCF,
     ' ',0xCF,'O',0xCF,'R',0xCF,' ',0xCF,'V',0xCF,'G',0xCF,'A',0xCF,' ',0xCF,
     'D',0xCF,'I',0xCF,'S',0xCF,'P',0xCF,'L',0xCF,'A',0xCF,'Y',0xCF,' ',0xCF,
     'T',0xCF,'O',0xCF,' ',0xCF,'P',0xCF,'L',0xCF,'A',0xCF,'Y',0xCF,' ',0xCF,
     ' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,
     ' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,
     ' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF,' ',0xCF
};

char ingtarg[]={
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,'G',0x40,'A',0x40,'M',0x40,'E',0x40,' ',0x40,'C',0x40,
     'U',0x40,'R',0x40,'R',0x40,'E',0x40,'N',0x40,'T',0x40,'L',0x40,'Y',0x40,
     ' ',0x40,'I',0x40,'N',0x40,' ',0x40,'P',0x40,'R',0x40,'O',0x40,'G',0x40,
     'R',0x40,'E',0x40,'S',0x40,'S',0x40,':',0x40,' ',0x40,' ',0x40,' ',0x40,
     'D',0x40,'R',0x40,'O',0x40,'N',0x40,'E',0x40,' ',0x40,'S',0x40,'H',0x40,
     'O',0x40,'O',0x40,'T',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40
};
char ingtime[]={
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,'G',0x40,'A',0x40,'M',0x40,'E',0x40,' ',0x40,'C',0x40,
     'U',0x40,'R',0x40,'R',0x40,'E',0x40,'N',0x40,'T',0x40,'L',0x40,'Y',0x40,
     ' ',0x40,'I',0x40,'N',0x40,' ',0x40,'P',0x40,'R',0x40,'O',0x40,'G',0x40,
     'R',0x40,'E',0x40,'S',0x40,'S',0x40,':',0x40,' ',0x40,' ',0x40,' ',0x40,
     'T',0x40,'I',0x40,'M',0x40,'E',0x40,'D',0x40,' ',0x40,'G',0x40,'A',0x40,
     'M',0x40,'E',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40
};
char ingsudd[]={
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,'G',0x40,'A',0x40,'M',0x40,'E',0x40,' ',0x40,'C',0x40,
     'U',0x40,'R',0x40,'R',0x40,'E',0x40,'N',0x40,'T',0x40,'L',0x40,'Y',0x40,
     ' ',0x40,'I',0x40,'N',0x40,' ',0x40,'P',0x40,'R',0x40,'O',0x40,'G',0x40,
     'R',0x40,'E',0x40,'S',0x40,'S',0x40,':',0x40,' ',0x40,' ',0x40,' ',0x40,
     '4',0x40,'0',0x40,'0',0x40,' ',0x40,'P',0x40,'O',0x40,'I',0x40,'N',0x40,
     'T',0x40,' ',0x40,'B',0x40,'L',0x40,'O',0x40,'W',0x40,'O',0x40,'U',0x40,
     'T',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40
};
char ingsole[]={
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,'G',0x40,'A',0x40,'M',0x40,'E',0x40,' ',0x40,'C',0x40,
     'U',0x40,'R',0x40,'R',0x40,'E',0x40,'N',0x40,'T',0x40,'L',0x40,'Y',0x40,
     ' ',0x40,'I',0x40,'N',0x40,' ',0x40,'P',0x40,'R',0x40,'O',0x40,'G',0x40,
     'R',0x40,'E',0x40,'S',0x40,'S',0x40,':',0x40,' ',0x40,' ',0x40,' ',0x40,
     'S',0x40,'O',0x40,'L',0x40,'E',0x40,' ',0x40,'S',0x40,'U',0x40,'R',0x40,
     'V',0x40,'I',0x40,'V',0x40,'O',0x40,'R',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40
};
char ingopen[]={
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,'G',0x40,'A',0x40,'M',0x40,'E',0x40,' ',0x40,'C',0x40,
     'U',0x40,'R',0x40,'R',0x40,'E',0x40,'N',0x40,'T',0x40,'L',0x40,'Y',0x40,
     ' ',0x40,'I',0x40,'N',0x40,' ',0x40,'P',0x40,'R',0x40,'O',0x40,'G',0x40,
     'R',0x40,'E',0x40,'S',0x40,'S',0x40,':',0x40,' ',0x40,' ',0x40,' ',0x40,
     'A',0x40,'L',0x40,'L',0x40,' ',0x40,'O',0x40,'U',0x40,'T',0x40,' ',0x40,
     'W',0x40,'A',0x40,'R',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,
     ' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40,' ',0x40
};

long rndnum;                  /* pseudo-random number accumulator          */

FILE *dbgfp;

main(argc,argv)               /* Flash Chat mainline                       */
int argc;
char *argv[];
{
     if (setjmp(ADDR_OFdisaster) != 0) {
          finft();
     }
     init(argc,argv);
     if (solo) {
          savscn();
          names[0]="YOU";
          noise(NEWUSR);
     }
     else {
          outser(0,'\r');
          termnl("\14");
     }
     dbg=&debug;
     setmem(dbg,sizeof(struct debug),0);
     setmem(hlpscn,sizeof(hlpscn),0);
     endogam=0;
     chat();
}
 
init(argc,argv)               /* initialize communications, etc.           */
int argc;
char *argv[];
{
     static int spckys[]={
          CRSRUP,CRSRDN,CRSRLF,CRSRRT,PGUP,HOME,
          F1,F4,F5,F6,F7,F8,SHIFT+F9,SHIFT+F10,27,
          8,
          13,ONHELP1,ONHELP2,ONHELP3,ONHELP4,ONHELP5,
          TIMEDGM,TANKSGM,SCOREGM,TARGAME,
          ALTC,ALTO,ALTZ,ALTD
     };
 
     inicom(argc,argv);
     ininoi();
     setspc(spckys);
}
 
chat()                        /* main chat loop                            */
{
     int c;
 
     shocha();
     inirtk();
     while (1) {
          if (kbhit()) {
               ecoutp(getchc());
          }
          switch (c=ecinp()) {
          case -1:
               if (solo && (fstick-ostick) >= 8) {
                    rseed+=1;
                    prcrtk();
                    if (dbg->debug) {
                         dbg->dbgtck+=1;
                         fprintf(dbgfp,"  -TICK     %5d\n",dbg->dbgtck);
                    }
                    if ((gtype=ingame(&player[self])) != 0) {
                         movtnk(0,npyrs);
                         if (compplr > 0) {
                              movtnk(MAXPYR,MAXPYR+compplr);
                         }
                         movtar();
                         movshl();
                    }
                    ostick=fstick;
               }
               break;
          case -TICK:
               rseed+=1;
               prcrtk();
               if (dbg->debug) {
                    dbg->dbgtck+=1;
                    fprintf(dbgfp,"  -TICK     %5d\n",dbg->dbgtck);
               }
               if ((gtype=ingame(&player[self])) != 0) {
                    movtnk(0,npyrs);
                    if (compplr > 0) {
                         movtnk(MAXPYR,MAXPYR+compplr);
                    }
                    movtar();
                    movshl();
               }
               break;
          case -REMOVE:
               pyrn=ecinp()-'0';
               pyrp=&player[pyrn];
               gtype=ingame(&player[self]);
               if (ingame(pyrp) != 0 && gtype != 0) {
                    remexp(pyrp);
                    drawobj(pyrp->erapts,0);
                    shoscr(pyrn,0);
                    remshl(pyrn);
               }
               setmem(pyrp->chawin,CHWSIZ*2,0);
               if (onscrn) {
                    loccwl(pyrn);
                    setatr(AT4CHW);
                    printf("\315\315\315\315\315\315\315\315\315\315\315\315\315\315");
                    printf("\315\315\315\315\315\315\315\315\315\315\315\315\315\315");
                    rstloc();
                    dspchw(pyrn);
               }
               setmem(pyrp,sizeof(struct player),0);
               if (onscrn) {
                    shosta();
               }
               if (--npyrs != pyrn) {
                    movmem(&player[npyrs],pyrp,sizeof(struct player));
                    setmem(&player[npyrs],sizeof(struct player),0);
                    names[pyrn]=names[npyrs];
                    cpyshl(npyrs,pyrn);
                    if (self == npyrs) {
                         self=pyrn;
                    }
                    loccwl(pyrn);
                    setatr((pyrn+2)*16);
                    if (!endogam) {
                         printf("%c%s%c",(compena > 0) ? '>' : ' ',names[pyrn],
                              (dbg->debug != 0) ? '-' : ' ');
                    }
                    else {
                         printf("%c%-9s%c  Score: %5d ",(compena > 0) ? '>' : ' ',
                              names[pyrn],(dbg->debug) ? '-' : ' ',player[pyrn].score);
                    }
                    rstloc();
               }
               break;
          case -LINEUP:
               linem();
               compena=0;
               if (player[self].ingame != 0) {
                    ecoutp(player[self].ingame);
               }
               else {
                    dbg->debug=0;
                    shosta();
                    shocha();
               }
               break;
          case -NODATA:
               gtype=ingame(&player[self]);
               if (gtype != 0) {
                    setmode(omode);
               }
               lvpool();
               outser(0,'\r');
               termnl("\n*** LOST CONTACT ***\n");
               shocha();
               inirtk();
               break;
          case TIMEDGM:
          case TANKSGM:
          case SCOREGM:
          case TARGAME:
          case NOLIMIT:
          case ONHELP1:
          case ONHELP2:
          case ONHELP3:
          case ONHELP4:
          case ONHELP5:
               player[pyrn].ingame=c;
               shosta();
               break;
          default:
               setpyr(pyrn);
               ogtyp=ingame(pyrp);
               gtype=ingame(&player[self]);
               if (gtype != 0 && ogtyp != 0) {
                    plrinp(c);
               }
               else {
                    dwcchr(c);
               }
          }
     }
}

zerogam()                     /* zero ingame flags                         */
{
     int n;

     for (n=0 ; n < npyrs ; n++) {
          if (!ingame(&player[n]) && !onhelp(&player[n])) {
               player[n].ingame=0;
          }
     }
}

setpyr(pn)                    /* set global player-id values to specd user */
int pn;
{
     pyrn=pn;
     pyrp=&player[pyrn];
}
 
shocha()                      /* show current chat windows on CRT          */
{
     int color,i;
 
     onscrn=1;
     setwin(0L,0,0,79,24,1);
     iniscn(SFCHAT,frzseg());
     for (i=0 ; i < npyrs ; i++) {
          color=((i+2)*16);
          setatr(color);
          loccwl(i);
          if (!endogam) {
               printf("%c%s%c",(compena > 0) ? '>' : ' ',names[i],
                    (dbg->debug != 0) ? '-' : ' ');
          }
          else {
               printf("%c%-9s%c  Score: %5d ",(compena > 0) ? '>' : ' ',
                    names[i],(dbg->debug) ? '-' : ' ',player[i].score);
          }
          locate(50,3);
          if (compena >= 0 && !solo) {
               setatr(0x0A);
               printf("ON ");
          }
          else {
               setatr(0x0C);
               printf("OFF");
          }
          rstloc();
          player[i].chawin[CHWSIZ*2-1]=AT4WRT;
          dspchw(i);
     }
     i=player[self].chapos;
     locate(CHWSIZ,5+i*3);
}
 
linem()                       /* LINEUP command handler during chat        */
{
     int color,i,j;
 
     for (i=0 ; i < npyrs ; i++) {
          for (j=0 ; j < npyrs ; j++) {
               if (player[j].chapos == i) {
                    break;
               }
          }
          if (j == npyrs) {
               break;
          }
     }
     parsln();
     noise(NEWUSR);
     setmem(pyrp=&player[npyrs-1],sizeof(struct player),0);
     pyrp->chapos=i;
     if (onscrn) {
          color=((npyrs-1)+2)*16;
          loccwl(npyrs-1);
          setatr(color);
          printf(" %s ",names[npyrs-1]);
          rstloc();
     }
}
 
dwcchr(c)                     /* deal with a chat character                */
int c;
{
     if (c == 0x1B) {
          if (onhelp(pyrp)) {
               pyrp->ingame=0;
               hlpscn[pyrn]=0;
               if (pyrn == self) {
                    shocha();
               }
               shosta();
               return;
          }
          else if ((pyrn == self && pyrp->ingame == NOGRAF) || ingame(pyrp)) {
               pyrp->ingame=0;
               shosta();
               return;
          }
          else if (pyrp->ingame == 0) {
               setmem(pyrp->chawin,CHWSIZ*2,0);
               pyrp->chawin[CHWSIZ*2-1]=AT4WRT;
               if (onscrn) {
                    dspchw(pyrn);
               }
               return;
          }
     }
     if (ogtyp == 0) {
          disp=((pyrn == self) && onscrn);
          chachr(c);
     }
}
 
chachr(c)                     /* process a chat character, rest of the way */
int c;
{
     int n,helps[]={
          SFCHELP,SFCHELP1,SFCHELP2,SFCHELP3,SFCHELPT
     };
     char stg[80];

     switch (c) {
     case F1:
          if (hlpscn[pyrn] == 5) {
               pyrp->ingame=0;
               hlpscn[pyrn]=0;
               if (pyrn == self) {
                    shocha();
               }
          }
          else {
               pyrp->ingame=ONHELP1+hlpscn[pyrn];
               if (pyrn == self) {
                    iniscn(helps[hlpscn[pyrn]],frzseg());
                    onscrn=0;
                    locate(0,0);
               }
               hlpscn[pyrn]+=1;
          }
          shosta();
          break;
     case F4:
          if (!onhelp(pyrp) && dbg->debug != 0) {
               pyrp->ingame=c;
               shosta();
          }
          break;
     case F5:
     case F6:
     case F7:
     case F8:
          if (!onhelp(pyrp)) {
               pyrp->ingame=c;
               shosta();
          }
          break;
     case SHIFT+F9:
          if (solo) {
               noise(NEWUSR);
          }
          else if (disp) {
               lvpool();
               lvpool();
               sprintf(stg,"\n*** Hit F9 to return to %s %s ***\n",gname,gvers);
               termnl(stg);
               shocha();
               inirtk();
          }
          else {
               noise(BYEUSR);
          }
          break;
     case SHIFT+F10:
          if (disp) {
               rstscn();
               finft();
          }
          break;
     case ALTC:
          if (!strcmp(names[pyrn],"Sysop")) {
               compena=(compena == 1) ? 0 : 1;
               shocha();
               shosta();
          }
          break;
     case ALTD:
          if (!strcmp(names[pyrn],"Sysop")) {
               dbg->debug=1;
               shocha();
               shosta();
          }
          break;
     case ALTO:
          if (*(names[pyrn]-1) == '*' || !strcmp(names[pyrn],"Sysop")) {
               compena=(compena == -1) ? 0 : -1;
               shocha();
               shosta();
          }
          break;
     case ALTZ:
          if (!strcmp(names[pyrn],"Sysop")) {
               dbg->debug=0;
               compena=0;
               shocha();
               shosta();
          }
          break;
     default:
          if ((c&0xFF00) == 0) {
               if (pyrp->ingame != 0) {
                    pyrp->ingame=0;
                    hlpscn[pyrn]=0;
                    if (pyrn == self) {
                         shocha();
                    }
                    shosta();
                    break;
               }
               noise(CHBEEP);
               if (c == 8 || c == 127) {
                    movmem(pyrp->chawin,pyrp->chawin+2,(CHWSIZ-1)*2);
                    pyrp->chawin[0]=0;
               }
               else {
                    movmem(pyrp->chawin+2,pyrp->chawin,(CHWSIZ-1)*2);
                    pyrp->chawin[CHWSIZ*2-2]=(c == '\r' ? 17 : c);
                    pyrp->chawin[CHWSIZ*2-1]=AT4WRT;
               }
               dspchw(pyrn);
          }
     }
}
 
loccwl(pyrn)                  /* locate cursor at chat window title point  */
int pyrn;
{
     int j;
 
     j=player[pyrn].chapos;
     locate(2,4+j*3);
}
 
dspchw(pyrn)                  /* display chat-window contents for a user   */
int pyrn;
{
     int j;
     char *src;
 
     if (onscrn) {
          j=player[pyrn].chapos;
          src=player[pyrn].chawin;
          movmem(src,scrnad(1,5+j*3),CHWSIZ*2);
     }
}

shosta()                      /* show status of users on chat screen       */
{
     int j,n;

     if (!onscrn) {
          return;
     }
     setmem(&ready[0],sizeof(ready),0);
     for (n=0 ; n < npyrs ; n++) {
          j=player[n].chapos;
          switch (player[n].ingame) {
          case TIMEDGM:
               movmem(ingtime,scrnad(1,5+j*3),CHWSIZ*2);
               break;
          case TANKSGM:
               movmem(ingsole,scrnad(1,5+j*3),CHWSIZ*2);
               break;
          case SCOREGM:
               movmem(ingsudd,scrnad(1,5+j*3),CHWSIZ*2);
               break;
          case NOLIMIT:
               movmem(ingopen,scrnad(1,5+j*3),CHWSIZ*2);
               break;
          case TARGAME:
               movmem(ingtarg,scrnad(1,5+j*3),CHWSIZ*2);
               break;
          case ONHELP1:
          case ONHELP2:
          case ONHELP3:
          case ONHELP4:
          case ONHELP5:
               movmem(helpmsg,scrnad(1,5+j*3),CHWSIZ*2);
               break;
          case NOGRAF:
               movmem(noevga,scrnad(1,5+j*3),CHWSIZ*2);
               break;
          case F5:
               movmem(targmsg,scrnad(1,5+j*3),CHWSIZ*2);
               ready[4]+=1;
               break;
          case F6:
               movmem(timemsg,scrnad(1,5+j*3),CHWSIZ*2);
               ready[0]+=1;
               break;
          case F7:
               movmem(scormsg,scrnad(1,5+j*3),CHWSIZ*2);
               ready[1]+=1;
               break;
          case F8:
               movmem(tankmsg,scrnad(1,5+j*3),CHWSIZ*2);
               ready[2]+=1;
               break;
          case F4:
               movmem(nolimsg,scrnad(1,5+j*3),CHWSIZ*2);
               ready[3]+=1;
               break;
          default:
               player[n].ingame=0;
               dspchw(n);
          }
     }
     chkrdy();
}

chkrdy()                      /* see if it's time to start the game        */
{
     int glimt,n,siz,tpyrn,x1,x2,y1,y2;
     char fname[16];

     gtype=0;
     if (ready[0] == npyrs) {
          gtype=TIMEDGM;
          glimt=GAMTIME;
     }
     else if (ready[1] == npyrs) {
          gtype=SCOREGM;
          glimt=GAMSCOR;
     }
     else if (ready[2] == npyrs) {
          gtype=TANKSGM;
          glimt=TNKSPLR;
     }
     else if (ready[3] == npyrs) {
          gtype=NOLIMIT;
          glimt=0;
     }
     else if (ready[4] == npyrs) {
          gtype=TARGAME;
          glimt=TARSCOR;
     }
     if (gtype != 0) {
          inirtk();
          endogam=0;
          rndnum=rseed;
          byself=((gpyrs=npyrs) == 1) ? 1 : 0;
          if (!setvid6()) {
               player[self].ingame=NOGRAF;
               for (n=0 ; n < npyrs ; n++) {
                    if (n != self) {
                         player[n].ingame=gtype;
                    }
               }
               shosta();
               ecoutp(0x1B);
               return;
          }
          if (dbg->debug) {
               setmem(dbg,sizeof(struct debug),0);
               sprintf(fname,"%s.dbg",names[self]);
               if ((dbgfp=fopen(fname,FOPWA)) == 0) {
                    catastro("\nUnable to open output file\n");
               }
               dbg->debug=1;
          }
          if (gtype == TIMEDGM) {
               rtkick(glimt-180,tensec);
          }
          else if (gtype == TARGAME || gtype == NOLIMIT) {
               rtkick(36,cretar);
          }
          drawline(1,13,MAXXP-2,13,15);                  /* white borders    */
          drawline(1,13,1,MAXYP-13,15);
          drawline(MAXXP-2,13,MAXXP-2,MAXYP-13,15);
          drawline(1,MAXYP-13,MAXXP-2,MAXYP-13,15);
          siz=sizeof(struct player)-((CHWSIZ*2)+sizeof(int));
          compplr=0;
          if (compena >= 0 && npyrs < MAXPYR) {
               if (!solo) {
                    compplr=1;
                    if (compena > 0) {
                         compplr=compn[npyrs-1];
                    }
               }
          }
          tpyrs=npyrs+compplr;
          for (n=0 ; n < npyrs ; n++) {
               setmem(&player[n].tnknum,siz,0);
               tankptr=&player[n];
               tankptr->tnknum=n;
               tankptr->ingame=gtype;
               tankptr->sd=startd[tpyrs-1][n];
               tankptr->sx=startx[tpyrs-1][n];
               tankptr->sy=starty[tpyrs-1][n];
               tankptr->color=n+2;
               tankptr->glimt=glimt;
               deftnk(n);
          }
          setmem(&player[MAXPYR],sizeof(struct player)*MAXCOM,0);
          if (compplr > 0) {
               for (n=MAXPYR ; n < MAXPYR+compplr ; n++) {
                    tpyrn=(n-MAXPYR)+npyrs;
                    tankptr=&player[n];
                    tankptr->tnknum=tpyrn;
                    tankptr->ingame=gtype;
                    tankptr->sd=startd[tpyrs-1][tpyrn];
                    tankptr->sx=startx[tpyrs-1][tpyrn];
                    tankptr->sy=starty[tpyrs-1][tpyrn];
                    tankptr->color=tpyrn+2;
                    tankptr->glimt=glimt;
                    deftnk(n);
               }
          }
          tentmr=180;
          namtmr=54*npyrs;
          onscrn=0;
          initnk();
     }
}
 
finft()                       /* finish up Flash Chat, return to DOS       */
{
     if (!solo) {
          lvpool();
          lvpool();
          finser(0);
     }
     finnoi();
     locate(0,24);
     exit(0);
}

termnl(stg)                   /* terminal-mode utility, with message string*/
char *stg;
{
     int i,c;
     static char ansiid[]={"\33[6n"};
     static char fname[16];
     char *ansptr,*comput();

     strcpy(rs,rg);
     rn=atol(comput(rs));     /* rn=un-encrypted registration number       */
     if (trmscn[0] != 0) {
          rstscn();
     }
     locate(0,0);
     setatr(0x70);
     printf("\4 %s %s \4 Copr. 1991 Galacticomm, Inc \4 F1=HELP \4 F9=CHAT \4 F10=EXIT \4",gname,gvers);
     rstloc();
     setatr(AT4WRT);
     setwin(0L,0,1,79,24,1);
     printf(stg);
     ansptr=ansiid;
     while (1) {
          while ((c=rdser(0)) != '\0') {
               if (c != -1) {
                    if (c == 7) {
                         noise(BELL);
                    }
                    else if (c == *ansptr) {
                         printf("%c",c);
                         if (*++ansptr == '\0') {
                              outser(0,'R');
                              ansptr=ansiid;
                         }
                    }
                    else {
                         ansptr=ansiid;
                         printf("%c",c);
                    }
               }
               if (kbhit()) {
                    switch (c=getchc()) {
                    case F1:
                         savscn();
                         iniscn(SFCHELPT,frzseg());
                         locate(0,0);
                         getchc();
                         rstscn();
                         break;
                    case F9:
                         if (regok()) {
                              compena=0;
                              printf("\n... Attempting to enter %s ...\n",gname);
                              sprintf(fname,"%s %s",gname,gvers);
                              flashm(fname,rn);
                         }
                         break;
                    case F10:
                    case ALTX:
                         finft();
                         break;
                    default:
                         if (c >= 0 && c <= 127) {
                              outser(0,c);
                         }
                    }
               }
          }
          for (i=0 ; i < 5 ; i++) {
               while ((c=rdser(0)) == EOF && !kbhit()) {
               }
               if (c != '\0') {
                    break;
               }
          }
          fstick=0;
          clreci();
          while ((c=ecinp()) == -1 && !kbhit()) {
          }
          if (c == -LINEUP) {
               if (parsln()) {
                    break;
               }
               lvpool();
          }
          printf("\n*** NO INITIAL LINEUP ***\n");
     }
     noise(NEWUSR);
     for (i=0 ; i < npyrs ; i++) {
          setmem(pyrp=&player[i],sizeof(struct player),0);
          pyrp->chapos=i;
     }
     self=npyrs-1;
     printf("\n... Entering %s ...\n",gname);
     savscn();
}

savscn()                      /* save current CRT contents & cursor pos    */
{
     movmem(frzseg(),trmscn,4000);
     trmscx=curcurx();
     trmscy=curcury();
}
 
rstscn()                      /* restore CRT contents & cursor from saved  */
{
     movmem(trmscn,frzseg(),4000);
     locate(trmscx,trmscy);
}
 
rnd()                         /* generate next pseudo-random number        */
{
     rndnum=rndnum*33821223L+871L;
     return((int)(rndnum>>16)&32767);
}
 
iniscn(scnnum,where)          /* initialize a screen from screen image     */
int scnnum;
char *where;
{
     movmem(scntbl+scnnum*4000,where,4000);
}

onhelp(sptr)                  /* return TRUE if on a help screen           */
struct player *sptr;
{
     if (sptr->ingame >= ONHELP1 && sptr->ingame <= ONHELP5) {
          return(1);
     }
     return(0);
}

char *
catfix1()                     /* "catastro" debug output, line 1 (if any)  */
{
     return("");
}
 
char *
catfix2()                     /* "catastro" debug output, line 2 (if any)  */
{
     return("");
}
