/***************************************************************************
 *   TANKS.C   - A Flash game using vector graphics techniques.            *
 *                                                                         *
 *                                                5/13/91 by Les Bird      *
 ***************************************************************************/

#include "stdio.h"
#include "stdlib.h"
#include "dos.h"
#include "fkcode.h"
#include "portable.h"
#include "ftanks.h"
#include "ftsnds.h"
#include "costab.h"
#include "sintab.h"

extern
int  byself,                  /* non-zero if playing byself while online   */
     compplr,                 /* number of artificial players in game      */
     gpyrs,                   /* players on the battle field (start of game)*/
     gtype,                   /* ingame() status for self                  */
     ogtyp,                   /* other players ingame() status             */
     omode,                   /* old video mode                            */
     onscrn,                  /* this player is on the chat screen? 1=yes  */
     opyrs,                   /* saved npyrs value when playing solo game  */
     self,                    /* this tasks player number                  */
     tpyrs;                   /* total players including computers         */

extern
struct debug debug,*dbg;

extern
FILE *dbgfp;

union REGS regs;

int  diflvl[MAXCOM],          /* difficulty levels for computers           */
     drwpts[TOTPTS],          /* rotated x,y defs of objects               */
     endogam,                 /* end of game flag                          */
     glimt[MAXPYR],           /* game limitations currently being disp'd   */
     mincnt,                  /* global counter for next avaialble mine    */
     namtmr,                  /* timer for displaying names                */
     score[MAXPYR],           /* score currently being displayed           */
     shlcnt,                  /* global counter for next available shell   */
     tenclr,                  /* ten second color for timed games          */
     tentmr,                  /* ten second timer and color (for TIMEDGM)  */
     x1,y1,                   /* start point for vector                    */
     x2,y2,                   /* end point for vector                      */
     xr,yr;                   /* rotate values for x,y                     */

int  endgam(),                /* function to end the game unconditionally  */
     ingame(),                /* function to see if player is in a game    */
     remnam(),                /* function to remove displayed names        */
     tensec();                /* function to show 10 secs left in game     */

int t1def[]={
     -3,-2,-3,-5,-5,-5,-5, 5,-3, 5,-3, 2,-1, 2,-1,10, 1,10, 1, 2,
      3, 2, 3, 5, 5, 5, 5,-5, 3,-5, 3,-2, 1,-4,-1,-4,-3,-2, 0, 0
};
int t2def[]={
     -3, 1,-3,-5,-5,-5,-5, 5,-3, 5,-3, 2,-1, 2,-1,10, 1,10, 1, 2,
      3, 2, 3, 5, 5, 5, 5,-5, 3,-5, 3, 1, 3,-5, 0,-2,-3,-5, 0, 0
};
int t3def[]={
     -3, 1,-3,-5,-5,-5,-5, 5,-3, 5,-3, 2,-1, 4,-1,10, 1,10, 1, 4,
      3, 2, 3, 5, 5, 5, 5,-5, 3,-5, 3, 1, 3,-2, 1,-4,-1,-4,-3,-2, 0, 0
};
int t4def[]={
     -3,-2,-3,-5,-5,-5,-5, 5,-3, 5,-3, 2,-1, 4,-1,10, 1,10, 1, 4,
      3, 2, 3, 5, 5, 5, 5,-5, 3,-5, 3,-2, 0,-5,-3,-2, 0, 0
};
int t5def[]={
     -3, 0,-3,-5,-5,-5,-5, 5,-3, 5,-3, 0,-1, 2,-1,10, 1,10, 1, 2,
      3, 0, 3, 5, 5, 5, 5,-5, 3,-5, 3, 0, 0,-5,-3, 0, 0, 0
};
int t6def[]={
     -3, 1,-3,-5,-5,-5,-5, 5,-3, 5,-3, 2,-1, 2,-1,10, 1,10, 1, 2,
      3, 2, 3, 5, 5, 5, 5,-5, 3,-5, 3, 1, 3,-3,-3,-3, 0, 0
};
int *objdef[]={
     t1def,t2def,t3def,t4def,t5def,t6def
};

int tarstar[]={
     -6, 0,-1,-1, 0,-6, 1,-1, 6, 0, 1, 1, 0, 6,-1, 1,-6, 0, 0, 0
};
int tardiam[]={
      0,-5,-3, 0, 0, 5, 3, 0, 0,-5, 0, 0
};
int tarcolm[]={
     -2,-6, 2,-6, 2, 6,-2, 6,-2,-6, 0, 0
};
int tartria[]={
      0,-4, 4, 4,-4, 4, 0,-4, 0, 0
};
int *objtar[TAROBJ]={
     tarstar,tardiam,tarcolm,tartria
};

int expdef[]={
       0, 0, 0, 2,
      22, 0, 0, 2,
      45, 0, 0, 2,
      67, 0, 0, 2,
      90, 0, 0, 2,
     112, 0, 0, 2,
     135, 0, 0, 2,
     157, 0, 0, 2,
     180, 0, 0, 2,
     202, 0, 0, 2,
     225, 0, 0, 2,
     247, 0, 0, 2,
     270, 0, 0, 2,
     292, 0, 0, 2,
     315, 0, 0, 2,
     337, 0, 0, 2
};
int shldef[]={
      0, 0, 1, 0,
      0, 1, 1, 1
};
int mindef[]={
            0,-1,
     -1, 0, 0, 0, 1, 0,
            0, 1
};
int startd[MAXPYR][MAXPYR]={  /* directional degrees at start of game for..*/
       0,  0,  0,  0,  0,  0, /*   player #1; 1 player game (byself)       */
     270, 90,  0,  0,  0,  0, /*   players #1,2; 2 player game             */
       0,225,135,  0,  0,  0, /*   players #1,2,3; 3 player game           */
       0,270,180, 90,  0,  0, /*   players #1,2,3,4; 4 player game         */
       0,280,190,170, 80,  0, /*   players #1,2,3,4,5; 5 player game       */
       0,290,250,180,110, 70  /*   players #1 through 6; 6 player game     */
};
int startx[MAXPYR][MAXPYR]={
     320,  0,  0,  0,  0,  0,
      15,625,  0,  0,  0,  0,
     320, 15,625,  0,  0,  0,
     320, 15,320,625,  0,  0,
     320, 15,160,480,625,  0,
     320, 15, 15,320,625,625
};
int starty[MAXPYR][MAXPYR]={
     175,  0,  0,  0,  0,  0,
     175,175,  0,  0,  0,  0,
      20,335,335,  0,  0,  0,
      20,175,335,175,  0,  0,
      20,132,335,335,132,  0,
      20, 88,262,335,262, 88
};
int scorex[MAXPYR][MAXPYR]={       /* positions 5, 235, 455 */
     235,  0,  0,  0,  0,  0,      /* 1 human               */
     235,235,  0,  0,  0,  0,      /* 2 humans              */
     235,  5,455,  0,  0,  0,      /* 3 humans              */
       5,  5,455,455,  0,  0,      /* 4 humans              */
     235,  5,  5,455,455,  0,      /* 5 humans              */
     235,  5,  5,235,455,455       /* 6 humans              */
};
int scorey[MAXPYR][MAXPYR]={       /* positions 5, 345      */
       5,  0,  0,  0,  0,  0,
       5,344,  0,  0,  0,  0,
       5,344,344,  0,  0,  0,
       5,344,344,  5,  0,  0,
       5,  5,344,344,  5,  0,
       5,  5,344,344,344,  5
};

char comnam[][10]={
     "I R A Q","U S A","I R A N","U S S R","C U B A"
};

struct shells {
     int  d;
     int  x,y;
     int  rng;
     int  spd;
     int  color;
     int  owner;
} shells[SHLMAX],*shlptr;

struct mines {
     int  x,y;
     int  color;
     int  timer;
     int  owner;
} mines[MINMAX],*minptr;

struct target {
     int  rd,md;
     int  x,y;
     int  spd;
     int  move;
     int  color;
     int  rr,rm;
     int  timer;
     int  steps;
     int  tdef[TOTPTS];
     int  erapts[TOTPTS];
     int  explo[EXPPTS];
} target[MAXTAR],*tarptr;

struct high {
     char score[10];
     char name[10];
     int  tnum;
} high[MAXPYR];

initnk()                      /* initialize shells and mines               */
{
     int n;

     setmem(shells,sizeof(struct shells)*SHLMAX,0);
     setmem(mines,sizeof(struct mines)*SHLMAX,0);
     setmem(target,sizeof(struct target)*MAXTAR,0);
     for (n=0 ; n < MAXPYR+MAXCOM ; n++) {
          glimt[n]=0;
          score[n]=0;
     }
     for (n=0 ; n < MAXCOM ; n++) {
          diflvl[n]=1;
     }
     shlcnt=mincnt=0;
}

setvid6()                     /* turn on video mode 16 if possible         */
{
     getmode();
     if (setmode(0x10) != 0) {
          return(1);
     }
     return(0);
}

getmode()                     /* get starting video mode; restore later    */
{
     regs.h.ah=0x0f;
     int86(0x10,&regs,&regs);
     omode=regs.h.al;
}

setmode(m)                    /* change video mode, save original          */
char m;
{
     int p;
     char far *sysptr;

     regs.h.ah=0x1A;
     regs.h.al=0x00;
     int86(0x10,&regs,&regs);
     if (regs.h.al != 0x1A) {
          sysptr=MK_FP(0x0F000,0x0FFFE);
          if (*sysptr == 0x0FD || *sysptr == 0x0F9) {
               return(0);
          }
          sysptr=MK_FP(0x0040,0x0010);
          if ((*sysptr&0x30) == 0x30) {
               return(0);
          }
          regs.h.ah=18;
          regs.h.al=16;
          int86(0x10,&regs,&regs);
          if (regs.h.bl == 16) {
               return(0);
          }
     }
     regs.h.ah=0;
     regs.h.al=m;
     int86(0x10,&regs,&regs);
     return(1);
}

plrinp(c)                     /* get input for active tank                 */
int c;
{
     int tshls;

     if (plralv(pyrp)) {
          if (dbg->debug) {
               dbgout("pressed key",pyrn,c);
          }
          switch (c) {
          case '2':
          case CRSRDN:
               dbg->dbgdns+=1;
               if (pyrp->spd > -30) {
                    pyrp->spd-=SPDINC;
               }
               break;
          case '4':
          case CRSRLF:
               dbg->dbglft+=1;
               pyrp->move=ROTATE;
               if (pyrp->trate > -6) {
                    pyrp->trate-=SPDTRN;
               }
               break;
          case '5':
               dbg->dbgnon+=1;
               pyrp->move=NONE;
               pyrp->trate=0;
               break;
          case '6':
          case CRSRRT:
               dbg->dbgrgt+=1;
               pyrp->move=ROTATE;
               if (pyrp->trate < 6) {
                    pyrp->trate+=SPDTRN;
               }
               break;
          case '7':
          case 0x0D:
          case HOME:
               dbg->dbgmin+=1;
               minptr=&mines[mincnt];
               if (minptr->timer == 0 && pyrp->mines < MINPLR) {
                    if (dbg->debug) {
                         dbgout("dropped mine #",pyrn,mincnt);
                    }
                    rot2d(pyrp->d,pyrp->x,pyrp->y,0,-(SHLOFF+1));
                    minptr->x=xr;
                    minptr->y=yr;
                    minptr->timer=MINTMR;
                    minptr->color=pyrp->color+8;
                    minptr->owner=pyrn;
                    mincnt=(mincnt+1)%MINMAX;
                    pyrp->mines+=1;
                    if (pyrn == self) {
                         noise(DROPM);
                    }
               }
               else if (dbg->debug) {
                    if (minptr->timer != 0) {
                         dbgout("mine in use #",pyrn,mincnt);
                    }
                    else {
                         dbgout("no mines left",pyrn,pyrp->mines);
                    }
               }
               break;
          case '8':
          case CRSRUP:
               dbg->dbgups+=1;
               if (pyrp->spd < 30) {
                    pyrp->spd+=SPDINC;
               }
               break;
          case '9':
          case ' ':
          case PGUP:
               dbg->dbgsht+=1;
               tshls=SHLMAX/tpyrs;
               shlptr=&shells[shlcnt];
               if (shlptr->rng == 0 && pyrp->shells < tshls) {
                    if (dbg->debug) {
                         dbgout("shot shell #",pyrn,shlcnt);
                    }
                    rot2d(pyrp->d,pyrp->x,pyrp->y,0,SHLOFF);
                    shlptr->d=pyrp->d;
                    shlptr->x=xr;
                    shlptr->y=yr;
                    shlptr->rng=SHLRNG;
                    shlptr->spd=pyrp->spd+SPDSHL;
                    shlptr->color=pyrp->color+8;
                    shlptr->owner=pyrn;
                    shlcnt=(shlcnt+1)%SHLMAX;
                    pyrp->shells+=1;
                    noise(SHOOT);
               }
               else if (dbg->debug) {
                    if (shlptr->rng != 0) {
                         dbgout("shell in use #",pyrn,shlcnt);
                    }
                    else {
                         dbgout("shells used up",pyrn,pyrp->shells);
                    }
               }
               break;
          case 'a':
          case 'A':
               rotrgt();
               spdfor();
               break;
          case 'z':
          case 'Z':
               rotlft();
               spdbck();
               break;
          case '\'':
               rotlft();
               spdfor();
               break;
          case '/':
               rotrgt();
               spdbck();
               break;
          }
     }
     if (c == 0x1B) {
          if (gtype != 0) {
               remexp(pyrp);
               drawobj(pyrp->erapts,0);
               shoscr(pyrn,0);
               remshl(pyrn);
          }
          pyrp->ingame=0;
          if (dbg->debug) {
               dbgcls();
          }
          if (pyrn == self || gtype == 0) {
               if (pyrn == self) {
                    setmode(omode);
               }
               shocha();
               shosta();
          }
     }
}

rotlft()
{
     pyrp->trate-=3;
     if (pyrp->trate != 0) {
          pyrp->move=ROTATE;
          if (pyrp->trate < -6) {
               pyrp->trate=-6;
          }
     }
     else {
          pyrp->move=NONE;
     }
}

rotrgt()
{
     pyrp->trate+=3;
     if (pyrp->trate != 0) {
          pyrp->move=ROTATE;
          if (pyrp->trate > 6) {
               pyrp->trate=6;
          }
     }
     else {
          pyrp->move=NONE;
     }
}

spdfor()
{
     pyrp->spd+=15;
     if (pyrp->spd > 30) {
          pyrp->spd=30;
     }
}

spdbck()
{
     pyrp->spd-=15;
     if (pyrp->spd < -30) {
          pyrp->spd=-30;
     }
}

deftnk(pn)                    /* define default tank parameters            */
int pn;
{
     int adjpn,tn;

     tn=player[pn].tnknum;
     movmem(objdef[tn],&player[pn].tdef,TOTPTS*sizeof(int));
     if (ogtyp == TANKSGM && player[pn].glimt == 0) {
          player[pn].move=GHOST;
     }
     else {
          player[pn].d=player[pn].sd;
          player[pn].x=player[pn].sx*SCALE;
          player[pn].y=player[pn].sy*SCALE;
          player[pn].spd=0;
          player[pn].trate=0;
          player[pn].timer=0;
          player[pn].move=NONE;
          player[pn].protct=PRTTIM*16;
          if (pn >= MAXPYR) {
               adjpn=pn-MAXPYR;
               if (diflvl[adjpn] < 10) {
                    diflvl[adjpn]+=1;
               }
          }
     }
     tn=player[pn].tartnk;
     if (!plralv(&player[tn])) {
          lockon(pn);
     }
}

cretar()                      /* rtkick'd routine creates all targets      */
{
     int n;

     for (n=0 ; n < MAXTAR ; n++) {
          deftar(n);
     }
}

deftar(tn)                    /* reset target                              */
int tn;
{
     movmem(objtar[(rnd()%TAROBJ)],&target[tn].tdef,TOTPTS*sizeof(int));
     target[tn].x=rnd()%MAXBX;
     target[tn].y=(rnd()%MAXBY)+10;
     target[tn].rd=rnd()%359;
     target[tn].md=rnd()%359;
     target[tn].spd=(rnd()%10)*SPDINC;
     target[tn].rr=(rnd()%15)+1;
     if (rnd() > 16384) {
          target[tn].rr=-target[tn].rr;
     }
     target[tn].rm=(rnd()%8)+1;
     if (rnd() > 16384) {
          target[tn].rm=-target[tn].rm;
     }
     target[tn].color=(rnd()%5)+10;
     target[tn].move=NONE;
}

movtnk(start,end)             /* move all tanks, update screen             */
int start,end;
{
     int i,n;
     unsigned ea,ex,ey,es;

     for (n=start ; n < end ; n++) {
          tankptr=&player[n];
          if ((ogtyp=ingame(tankptr)) != 0 && tankptr->move != GHOST) {
               if (n >= MAXPYR && tankptr->move != BLOWUP) {
                    movopn(n);
               }
               if (ogtyp == TIMEDGM && tankptr->glimt > 0) {
                    tankptr->glimt-=1;
               }
               if (tankptr->protct > 0) {
                    tankptr->protct-=1;
                    tankptr->steps=tankptr->protct%16;
               }
               switch (tankptr->move) {
               case NONE:
                    cmptnk(n);
                    break;
               case ROTATE:
                    tankptr->d+=tankptr->trate;
                    adjang(&tankptr->d);
                    cmptnk(n);
                    break;
               case BLOWUP:
                    if (tankptr->timer == 0) {
                         drawobj(tankptr->erapts,0);
                         movmem(expdef,tankptr->explo,sizeof(expdef));
                         for (i=0 ; i < EXPPTS ; i+=4) {
                              tankptr->explo[i]+=rnd()%5;
                              tankptr->explo[i+1]=tankptr->x;
                              tankptr->explo[i+2]=tankptr->y;
                              tankptr->explo[i+3]+=rnd()%3;
                         }
                         tankptr->timer=EXPTIM;
                         tankptr->steps=8;
                    }
                    else {
                         tankptr->timer-=1;
                         for (i=0 ; i < EXPPTS ; i+=4) {
                              ea=tankptr->explo[i];
                              ex=tankptr->explo[i+1];
                              ey=tankptr->explo[i+2];
                              es=tankptr->explo[i+3];
                              mov2d(ea,ex,ey,0);
                              adjbnds(&xr,MINSX,MAXSX);
                              adjbnds(&yr,MINSY,MAXSY);
                              pixelset(xr/SCALE,yr/SCALE,0);
                              if (tankptr->timer > 1) {
                                   mov2d(ea,ex,ey,es);
                                   adjbnds(&xr,MINSX,MAXSX);
                                   adjbnds(&yr,MINSY,MAXSY);
                                   pixelset(xr/SCALE,yr/SCALE,tankptr->steps);
                                   tankptr->explo[i+1]=xr;
                                   tankptr->explo[i+2]=yr;
                              }
                         }
                         tankptr->steps+=1;
                         if (tankptr->steps > 15) {
                              tankptr->steps=8;
                         }
                         if (tankptr->timer == 1) {
                              if (endogam) {
                                   tankptr->move=GHOST;
                              }
                              else {
                                   deftnk(n);
                              }
                         }
                    }
                    break;
               }
               if (n < npyrs && namtmr > 0) {
                    shonam(n,tankptr->color);
               }
          }
     }
}

remexp(sptr)                  /* remove explosion pixels                   */
struct player *sptr;
{
     int i;

     for (i=0 ; i < EXPPTS ; i+=4) {
          mov2d(sptr->explo[i],sptr->explo[i+1],sptr->explo[i+2],0);
          adjbnds(&xr,MINSX,MAXSX);
          adjbnds(&yr,MINSY,MAXSY);
          pixelset(xr/SCALE,yr/SCALE,0);
     }
}

movtar()                      /* move/rotate targets if target game in play*/
{
     int i,n;
     unsigned ea,ex,ey,es;

     if (gtype == TARGAME || gtype == NOLIMIT) {
          for (n=0 ; n < MAXTAR ; n++) {
               tarptr=&target[n];
               if (tarptr->move == BLOWUP) {
                    if (tarptr->timer == 0) {
                         drawobj(tarptr->erapts,0);
                         movmem(expdef,tarptr->explo,sizeof(expdef));
                         for (i=0 ; i < EXPPTS ; i+=4) {
                              tarptr->explo[i]+=rnd()%5;
                              tarptr->explo[i+1]=tarptr->x;
                              tarptr->explo[i+2]=tarptr->y;
                              tarptr->explo[i+3]+=rnd()%3;
                         }
                         tarptr->timer=EXPTIM;
                         tarptr->steps=8;
                    }
                    else {
                         tarptr->timer-=1;
                         for (i=0 ; i < EXPPTS ; i+=4) {
                              ea=tarptr->explo[i];
                              ex=tarptr->explo[i+1];
                              ey=tarptr->explo[i+2];
                              es=tarptr->explo[i+3];
                              mov2d(ea,ex,ey,0);
                              adjbnds(&xr,MINSX,MAXSX);
                              adjbnds(&yr,MINSY,MAXSY);
                              pixelset(xr/SCALE,yr/SCALE,0);
                              if (tarptr->timer > 1) {
                                   mov2d(ea,ex,ey,es);
                                   adjbnds(&xr,MINSX,MAXSX);
                                   adjbnds(&yr,MINSY,MAXSY);
                                   pixelset(xr/SCALE,yr/SCALE,tarptr->steps);
                                   tarptr->explo[i+1]=xr;
                                   tarptr->explo[i+2]=yr;
                              }
                         }
                         tarptr->steps+=1;
                         if (tarptr->steps > 15) {
                              tarptr->steps=8;
                         }
                         if (tarptr->timer == 1) {
                              if (endogam) {
                                   tarptr->move=GHOST;
                              }
                              else {
                                   deftar(n);
                              }
                         }
                    }
               }
               else if (tarptr->move != GHOST) {
                    tarptr->rd+=tarptr->rr;
                    adjang(&tarptr->rd);
                    tarptr->md+=tarptr->rm;
                    adjang(&tarptr->md);
                    cmptar();
               }
          }
     }
}

adjang(rdeg)                  /* adjust angle if > 360 or < 0              */
int *rdeg;
{
     if (*rdeg > 359) {
          *rdeg-=360;
     }
     else if (*rdeg < 0) {
          *rdeg+=360;
     }
}

cmptnk(tn)                    /* compute motion and rotation of tanks      */
int tn;
{
     int *p,*dcnt,*dptr,xo,yo;

     p=tankptr->tdef;
     dptr=drwpts;
     dcnt=drwpts;
     setmem(drwpts,sizeof(drwpts),0);
     while (*p != 0 || *(p+1) != 0) {
          if (tankptr->protct > 0 && tn == self) {
               xo=*p;
               yo=*(p+1);
               if (tankptr->steps > 8) {
                    xo+=(xo < 0) ? -1 : 1;
                    yo+=(yo < 0) ? -1 : 1;
               }
               else if (tankptr->steps > 1) {
                    xo+=(xo < 0) ? 1 : -1;
                    yo+=(yo < 0) ? 1 : -1;
               }
               *p++=xo;
               *p++=yo;
          }
          else {
               xo=*p++;
               yo=*p++;
          }
          rot2d(tankptr->d,tankptr->x,tankptr->y,xo,yo);
          *++dptr=(xr/SCALE);
          *++dptr=(yr/SCALE);
          *dcnt+=2;
     }
     drawobj(tankptr->erapts,0);
     if (tankptr->protct > 0 && tn != self) {
          if (tankptr->steps&2) {
               drawobj(drwpts,0);
          }
          else {
               drawobj(drwpts,tankptr->color);
          }
          tankptr->steps+=1;
     }
     else {
          drawobj(drwpts,tankptr->color);
     }
     movmem(drwpts,tankptr->erapts,sizeof(int)*TOTPTS);
     mov2d(tankptr->d,tankptr->x,tankptr->y,tankptr->spd);
     tankptr->x=xr;
     adjbnds(&tankptr->x,MINBX,MAXBX);
     tankptr->y=yr;
     adjbnds(&tankptr->y,MINBY,MAXBY);
}

cmptar()                      /* compute motion and rotation of targets    */
{
     int *p,*dcnt,*dptr,xo,yo;

     p=tarptr->tdef;
     dptr=drwpts;
     dcnt=drwpts;
     setmem(drwpts,sizeof(drwpts),0);
     while (*p != 0 || *(p+1) != 0) {
          xo=*p++;
          yo=*p++;
          rot2d(tarptr->rd,tarptr->x,tarptr->y,xo,yo);
          *++dptr=(xr/SCALE);
          *++dptr=(yr/SCALE);
          *dcnt+=2;
     }
     drawobj(tarptr->erapts,0);
     drawobj(drwpts,tarptr->color);
     movmem(drwpts,tarptr->erapts,sizeof(int)*TOTPTS);
     mov2d(tarptr->md,tarptr->x,tarptr->y,tarptr->spd);
     tarptr->x=xr;
     adjbnds(&tarptr->x,MINBX,MAXBX);
     tarptr->y=yr;
     adjbnds(&tarptr->y,MINBY,MAXBY);
}

adjbnds(val,minv,maxv)        /* adjust X or Y boundaries                  */
int *val;
int minv,maxv;
{
     if (*val > maxv) {
          *val=maxv;
     }
     else if (*val < minv) {
          *val=minv;
     }
}

movshl()                      /* move any projectiles or update mines      */
{
     int c,n,off,x,y;

     for (n=0 ; n < SHLMAX ; n++) {
          shlptr=&shells[n];
          tankptr=&player[shlptr->owner];
          if (shlptr->rng > 1) {
               mov2d(shlptr->d,shlptr->x,shlptr->y,shlptr->spd);
               drawshl(shlptr->x,shlptr->y,0);
               shlptr->x=xr;
               shlptr->y=yr;
               if (xr > MAXSX || xr < MINSX || yr > MAXSY || yr < MINSY) {
                    tankptr->shells-=1;
                    setmem(shlptr,sizeof(struct shells),0);
                    if (dbg->debug) {
                         dbgout("reset shell #",tankptr->tnknum,n);
                    }
               }
               else if ((c=chkshl(xr,yr)) != 0) {
                    if (c >= PLRLO && c <= COMHI) {
                         optr=&player[c-1];
                         pldied(shlptr->owner,c-1,SHLVAL);
                         shlptr->rng=1;
                         noise(KABOOM);
                    }
                    else if (c >= TARLO && c <= TARHI) {
                         c-=TARLO;
                         tarptr=&target[c];
                         trdied(shlptr->owner,c,TARVAL);
                         shlptr->rng=1;
                         noise(KABOOM);
                    }
                    else {
                         drawshl(xr,yr,shlptr->color);
                         shlptr->rng-=1;
                    }
               }
               else {
                    drawshl(xr,yr,shlptr->color);
                    shlptr->rng-=1;
               }
          }
          else if (shlptr->rng == 1) {
               drawshl(shlptr->x,shlptr->y,0);
               tankptr->shells-=1;
               setmem(shlptr,sizeof(struct shells),0);
               if (dbg->debug) {
                    dbgout("reset shell #",shlptr->owner,n);
               }
          }
          minptr=&mines[n];
          tankptr=&player[minptr->owner];
          if (minptr->timer > 1) {
               if ((c=chkmin(minptr->x,minptr->y)) != 0) {
                    if (c >= PLRLO && c <= COMHI) {
                         optr=&player[c-1];
                         pldied(minptr->owner,c-1,MINVAL);
                         minptr->timer=-MINTMR;
                         noise(KABOOM);
                    }
                    else if (c >= TARLO && c <= TARHI) {
                         c-=TARLO;
                         tarptr=&target[c];
                         trdied(minptr->owner,c,TARVAL);
                         minptr->timer=-MINTMR;
                         noise(KABOOM);
                    }
               }
               else {
                    showmin(minptr->x,minptr->y);
                    minptr->timer-=1;
               }
          }
          else if (minptr->timer < 0) {
               drawmin(minptr->x,minptr->y,minptr->color);
               minptr->timer+=1;
               if (minptr->timer == 0) {
                    minptr->timer=1;
               }
          }
          else if (minptr->timer == 1) {
               drawmin(minptr->x,minptr->y,0);
               tankptr->mines-=1;
               setmem(minptr,sizeof(struct mines),0);
               if (dbg->debug) {
                    dbgout("reset mine #",minptr->owner,n);
               }
          }
     }
}

pldied(owner,plrhit,points)   /* player died, adjust scores                */
int owner,plrhit,points;
{
     int bonchk,n,tarlock,tartnk;

     if (dbg->debug) {
          dbg->dbgkil+=1;
          dbgout("killed player #",owner,plrhit);
     }
     optr->move=BLOWUP;
     optr->timer=0;
     optr->tartnk=owner;
     if (owner != plrhit) {
          tankptr->score+=points;
     }
     if (gtype == SCOREGM || gtype == TARGAME) {
          if (tankptr->score >= tankptr->glimt) {
               tankptr->glimt=tankptr->score;
               endgam();
          }
     }
     else if (gtype == TANKSGM) {
          optr->glimt-=1;
          bonchk=tankptr->score-tankptr->lstbns;
          if (bonchk >= BONUSP) {
               tankptr->lstbns=tankptr->score;
               tankptr->glimt+=1;
               if (owner < MAXPYR && owner == self) {
                    noise(BONUS);
               }
          }
          allgone();
     }
     else if (gtype == NOLIMIT) {
          tankptr->glimt+=1;
     }
     if (compplr > 0 && !endogam) {
          for (n=MAXPYR ; n < MAXPYR+compplr ; n++) {
               if (ingame(&player[n])) {
                    if (plrhit == player[n].tartnk && owner != n) {
                         player[n].tartnk=owner;
                    }
               }
          }
          lockon(owner);
     }
     shoscr(owner,tankptr->color+8);
     shoscr(plrhit,optr->color+8);
}

allgone()                     /* are all players destroyed?                */
{
     int n,pyrlft;

     if (byself && !compplr) {
          if (player[self].glimt == 0) {
               endgam();
          }
          return;
     }
     pyrlft=0;
     for (n=0 ; n < MAXPYR+compplr ; n++) {
          if (ingame(&player[n]) && player[n].glimt > 0) {
               pyrlft+=1;
          }
     }
     if (pyrlft < 2) {
          endgam();
     }
}

trdied(owner,tarhit,points)   /* target destroyed                          */
int owner,tarhit,points;
{
     int score;

     if (dbg->debug) {
          dbg->dbgtar+=1;
          dbgout("hit target #",owner,tarhit);
     }
     tarptr->move=BLOWUP;
     tarptr->timer=0;
     if (tarptr->color-8 == tankptr->color) {
          points+=points;
     }
     tankptr->score+=points;
     if (gtype == TARGAME) {
          if (tankptr->score >= tankptr->glimt) {
               tankptr->glimt=tankptr->score;
               endgam();
          }
     }
     else if (gtype == NOLIMIT) {
          tankptr->glimt+=1;
     }
     shoscr(owner,tankptr->color+8);
}

drawshl(x,y,c)                /* draw the projectile (shell)               */
int x,y,c;
{
     int n;

     x=x/SCALE;
     y=y/SCALE;
     pixelset(x+shldef[0],y+shldef[1],c);
     pixelset(x+shldef[2],y+shldef[3],c);
     pixelset(x+shldef[4],y+shldef[5],c);
     pixelset(x+shldef[6],y+shldef[7],c);
}

chkshl(x,y)                   /* collision detection for shells            */
int x,y;
{
     int n;

     for (n=0 ; n < MAXPYR+compplr ; n++) {
          if (plralv(&player[n]) && player[n].protct == 0) {
               if (abs(x-player[n].x) < TANKSIZE && abs(y-player[n].y) < TANKSIZE) {
                    return(n+PLRLO);
               }
          }
     }
     if (gtype == TARGAME || gtype == NOLIMIT) {
          for (n=0 ; n < MAXTAR ; n++) {
               if (target[n].move != BLOWUP && target[n].move != GHOST) {
                    if (abs(x-target[n].x) < TARGSIZE && abs(y-target[n].y) < TARGSIZE) {
                         return(n+TARLO);
                    }
               }
          }
     }
     return(0);
}

showmin(x,y)                  /* show mine if own, else don't show         */
int x,y;
{
     if (minptr->owner == self) {
          drawmin(x,y,MINCLR);
     }
}

drawmin(x,y,c)                /* draw the mine on the screen               */
int x,y,c;
{
     int n;

     x=x/SCALE;
     y=y/SCALE;
     pixelset(x+mindef[0],y+mindef[1],c);
     pixelset(x+mindef[2],y+mindef[3],c);
     pixelset(x+mindef[4],y+mindef[5],c);
     pixelset(x+mindef[6],y+mindef[7],c);
     pixelset(x+mindef[8],y+mindef[9],c);
}

chkmin(x,y)                   /* collision detection for mines             */
int x,y;
{
     int c,n;

     for (n=0 ; n < MAXPYR+compplr ; n++) {
          if (plralv(&player[n]) && player[n].protct == 0) {
               if (abs(x-player[n].x) < TANKSIZE && abs(y-player[n].y) < TANKSIZE) {
                    return(n+PLRLO);
               }
          }
     }
     if (gtype == TARGAME || gtype == NOLIMIT) {
          for (n=0 ; n < MAXTAR ; n++) {
               if (target[n].move != BLOWUP && target[n].move != GHOST) {
                    if (abs(x-target[n].x) < TARGSIZE && abs(y-target[n].y) < TARGSIZE) {
                         return(n+TARLO);
                    }
               }
          }
     }
     return(0);
}

dspovr()                      /* display "end of game" message             */
{
     shostr(280,140,SCRCLR,"GAME OVER");
}

dspesc()                      /* display "hit esc" message                 */
{
     shostr(290,155,SCRCLR,"HIT ESC");
}

shoscr(pn,color)              /* show score for player pn                  */
int pn,color;
{
     int cn,mins,tn,secs,sx,sy;
     char strbuf[20];
     struct player *sptr;

     sptr=&player[pn];
     tn=sptr->tnknum;
     cn=pn-MAXPYR;
     if (gtype == TANKSGM) {
          if (pn >= MAXPYR) {
               sprintf(strbuf,"%-9s %4d (%d)",comnam[cn],score[tn],glimt[tn]);
          }
          else {
               sprintf(strbuf,"%-9s %4d (%d)",names[pn],score[tn],glimt[tn]);
          }
     }
     else {
          if (pn >= MAXPYR) {
               sprintf(strbuf,"%-9s %4d",comnam[cn],score[tn]);
          }
          else {
               sprintf(strbuf,"%-9s %4d",names[pn],score[tn]);
          }
     }
     sx=scorex[tpyrs-1][tn];
     sy=scorey[tpyrs-1][tn];
     shostr(sx,sy,0,strbuf);
     score[tn]=sptr->score;
     if (gtype == TANKSGM) {
          glimt[tn]=sptr->glimt;
          if (pn >= MAXPYR) {
               sprintf(strbuf,"%-9s %4d (%d)",comnam[cn],score[tn],glimt[tn]);
          }
          else {
               sprintf(strbuf,"%-9s %4d (%d)",names[pn],score[tn],glimt[tn]);
          }
     }
     else {
          if (gtype == TARGAME || gtype == SCOREGM) {
               glimt[tn]=sptr->glimt-sptr->score;
          }
          if (pn >= MAXPYR) {
               sprintf(strbuf,"%-9s %4d",comnam[cn],score[tn]);
          }
          else {
               sprintf(strbuf,"%-9s %4d",names[pn],score[tn]);
          }
     }
     shostr(sx,sy,color,strbuf);
}

shonam(n,color)               /* show player names by their tanks at start */
int n,color;
{
     int i,len,sx,sy;
     char str[10];

     strcpy(str,names[n]);
     len=strlen(str)*10;
     sx=startx[tpyrs-1][n];
     if (sx > 540) {
          sx-=len;
     }
     else if (sx >= 320) {
          sx-=len/2;
     }
     sy=starty[tpyrs-1][n];
     if (sy > 320) {
          sy-=24;
     }
     namtmr-=1;
     if (namtmr == 18) {
          for (i=0 ; i < MAXPYR+compplr ; i++) {
               if (ingame(&player[i])) {
                    shoscr(i,player[i].color+8);
               }
          }
          rtkick(18,remnam);
     }
     else if ((++player[n].timer)%9 == 0 && color != 0) {
          shostr(sx,sy,15,str);
     }
     else if ((player[n].timer)%10 == 0 || color == 0) {
          shostr(sx,sy,color,str);
     }
}

remnam()                      /* rtkick'd routine to remove name display   */
{
     int n;

     if (ingame(&player[self])) {
          namtmr=-1;
          for (n=0 ; n < npyrs ; n++) {
               if (ingame(&player[n])) {
                    player[n].timer=8;
                    shonam(n,0);
               }
          }
          namtmr=0;
     }
}

tensec()                      /* 10 second notification 'til end of game   */
{
     int color,len,sx;
     char msg[16];

     if (ingame(&player[self])) {
          sprintf(msg,"%2d SECS",tentmr/18);
          sx=(MAXXP/2)-6;
          shostr(sx,40,0,msg);
          tentmr-=18;
          if (tentmr == 0) {
               rtkick(18,endgam);
               return;
          }
          sprintf(msg,"%2d SECS",tentmr/18);
          shostr(sx,40,15,msg);
          rtkick(18,tensec);
     }
}

endgam()                      /* end this game (unconditionally)           */
{
     int i,n,qcomp(),shohigh();
     char str[10];

     if (dbg->debug) {
          dbgcls();
     }
     if ((gtype=ingame(&player[self])) == 0) {
          return;
     }
     setmem(high,sizeof(struct high)*MAXPYR,0);
     for (n=0,i=0 ; n < MAXPYR+compplr ; n++) {
          if ((ogtyp=ingame(&player[n])) != 0) {
               if (n < MAXPYR) {
                    strcpy(str,names[n]);
               }
               else {
                    strcpy(str,comnam[n-MAXPYR]);
               }
               if (ogtyp == TANKSGM) {
                    if (player[n].glimt > 0) {
                         high[0].tnum=player[n].tnknum;
                         sprintf(high[0].score,"%8u",player[n].score);
                         strcpy(high[0].name,str);
                    }
               }
               else {
                    high[i].tnum=player[n].tnknum;
                    sprintf(high[i].score,"%8u",player[n].score);
                    strcpy(high[i].name,str);
                    i+=1;
               }
               if (player[n].move != BLOWUP) {
                    player[n].move=GHOST;
                    drawobj(player[n].erapts,0);
               }
          }
     }
     if (gtype != TANKSGM) {
          qsort(high,tpyrs,sizeof(struct high),qcomp);
     }
     if (gtype == TARGAME || gtype == NOLIMIT) {
          for (n=0 ; n < MAXTAR ; n++) {
               if (target[n].move != BLOWUP) {
                    target[n].move=GHOST;
                    drawobj(target[n].erapts,0);
               }
          }
     }
     endogam=1;
     rtkick(54,shohigh);
     dspovr();
}

qcomp(arg1,arg2)              /* qsort compare routine                     */
char *arg1,*arg2;
{
     return(strncmp(arg1,arg2,10));
}

shohigh()                     /* show high scores when game over           */
{
     int i,n,usrn;

     if ((gtype=ingame(&player[self])) == 0) {
          return;
     }
     dspesc();
     if (gtype == TANKSGM) {
          dsphigh(1,0);
     }
     else {
          for (n=MAXPYR,i=0 ; n > 0 ; n--) {
               if (*high[n-1].score != '\0') {
                    dsphigh(++i,n-1);
               }
          }
     }
}

dsphigh(place,n)              /* setup buf[] with player[n] name & score   */
int place,n;
{
     int color,len;
     char buf[22],*ptr;

     setmem(buf,sizeof(buf),0);
     color=high[n].tnum+10;
     len=strlen(high[n].name);
     sprintf(buf,"%d  %-9s %8s",place,high[n].name,high[n].score);
     for (ptr=&buf[len+3] ; *ptr == ' ' ; ptr++) {
          *ptr='.';
     }
     shostr(220,180+(place*15),color,buf);
}

shostr(x,y,color,stg)
int x,y,color;
char *stg;
{
     int n,len;

     len=strlen(stg);
     for (n=0 ; n < len ; n++) {
          dspchr(x,y,color,*stg++);
          x+=10;
     }
}

dspchr(x,y,color,chr)
int x,y,color;
char chr;
{
     int n,vecs[][34]={
           3,-3,-3, 3,-4, 2,-4,-2,-2,-4, 2,-4, 4,-2, 4, 2, 2, 4,-2, 4,-3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* 0 */
           1,-3, 2,-4, 2, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* 1 */
          -4,-2,-2,-4, 2,-4, 4,-2, 4,-1,-3, 2,-4, 3,-4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* 2 */
          -4,-4, 4,-4,-1,-1, 2,-1, 4, 1, 4, 2, 2, 4,-4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* 3 */
           2, 4, 2,-4,-4, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* 4 */
           4,-4,-4,-4,-4,-0, 2,-0, 4, 1, 4, 2, 2, 4,-4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* 5 */
           4,-4,-2,-4,-4,-2,-4, 2,-2, 4, 2, 4, 4, 2, 4, 1, 2,-1,-2,-1,-4, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* 6 */
          -4,-4, 4,-4,-4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* 7 */
          -2, 0,-3,-1,-4,-2,-2,-4, 2,-4, 4,-2, 4,-1, 2, 0, 4, 1, 4, 2, 2, 4,-2, 4,-4, 2,-4, 1,-2, 0, 2, 0, 0, 0,   /* 8 */
           4, 0,-2, 0,-4,-1,-4,-2,-2,-4, 2,-4, 4,-2, 4, 2, 2, 4,-2, 4,-4, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* 9 */
          -4, 4,-4,-1,-1,-4, 1,-4, 4,-1, 4, 4, 4, 1,-4, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* A */
          -4,-1,-4,-4, 2,-4, 3,-3, 3,-2, 2,-1, 4, 1, 4, 2, 2, 4,-4, 4,-4,-1, 2,-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* B */
           4, 4,-2, 4,-4, 2,-4,-2,-2,-4, 4,-4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* C */
          -4,-4, 2,-4, 4,-2, 4, 2, 2, 4,-4, 4,-4,-4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* D */
           4, 4,-4, 4,-4, 0, 1, 0,-4, 0,-4,-4, 4,-4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* E */
          -4, 4,-4, 0,-1, 0,-4, 0,-4,-4, 4,-4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* F */
           4,-3, 3,-4,-2,-4,-4,-2,-4, 2,-2, 4, 4, 4, 4, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* G */
          -4,-4,-4, 4,-4, 0, 4, 0, 4, 4, 4,-4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* H */
           1,-4, 1, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* I */
          -4, 3,-3, 4, 0, 4, 1, 3, 1,-4, 4,-4,-3,-4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* J */
          -4, 4,-4, 0, 4, 4,-4, 0, 4,-4,-4, 0,-4,-4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* K */
          -4,-4,-4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* L */
          -4, 4,-4,-4,-1, 0, 4,-4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* M */
          -4, 4,-4,-4, 4, 4, 4,-4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* N */
          -2, 4,-4, 2,-4,-2,-2,-4, 2,-4, 4,-2, 4, 2, 2, 4,-2, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* O */
          -4, 4,-4,-4, 1,-4, 2,-3, 2,-1, 1, 0,-4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* P */
           2, 2, 3, 3, 2, 4,-2, 4,-4, 2,-4,-2,-2,-4, 2,-4, 4,-2, 4, 2, 3, 3, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* Q */
          -4, 4,-4,-4, 2,-4, 3,-3, 3,-1, 2, 0,-1, 0, 3, 4,-1, 0,-4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* R */
          -4, 4, 2, 4, 3, 3, 3, 2,-3,-2,-3,-3,-2,-4, 4,-4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* S */
          -1, 4,-1,-4,-4,-4, 4,-4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* T */
          -4,-4,-4, 2,-2, 4, 2, 4, 4, 2, 4,-4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* U */
          -4,-4,-1, 4, 4,-4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* V */
          -4,-4,-2, 4, 0,-1, 2, 4, 4,-4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* W */
          -5,-4, 3, 4,-1, 0, 3,-4,-5, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* X */
          -5,-4,-1, 0,-1, 4,-1, 0, 3,-4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* Y */
          -4,-4, 4,-4,-4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* Z */
           1,-4,-1,-2,-1, 2, 1, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* ( */
          -1,-4, 1,-2, 1, 2,-1, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0    /* ) */
     };

     if (isdigit(chr)) {
          chr=chr-'0';
     }
     else if (isalpha(chr)) {
          chr=toupper(chr)-55;
     }
     else if (chr == '(' || chr == ')') {
          chr=chr-4;
     }
     else if (chr == '.') {
          pixelset(x,y,color);
          return;
     }
     else {
          return;
     }
     x1=x+vecs[chr][0];
     y1=y+vecs[chr][1];
     for (n=2 ; n < sizeof(vecs[chr])/sizeof(int) ; n+=2) {
          if (vecs[chr][n] == 0 && vecs[chr][n+1] == 0) {
               break;
          }
          x2=x+vecs[chr][n];
          y2=y+vecs[chr][n+1];
          drawline(x1,y1,x2,y2,color);
          x1=x2;
          y1=y2;
     }
}

rot2d(ang,x,y,xo,yo)          /* compute rotated x,y; set xr,yr            */
int ang;
int x,y;
int xo,yo;
{
     int xc,xs,yc,ys;

/*   rot2dasm(ang,x,y,xo,yo);      */

     xc=xo*costab[ang];
     xs=xo*sintab[ang];
     yc=yo*costab[ang];
     ys=yo*sintab[ang];
     xr=x+((xc-ys)/SCALER);
     if (xr > MAXSX) {
          xr=MAXSX;
     }
     else if (xr < MINSX) {
          xr=MINSX;
     }
     yr=y+((yc+xs)/SCALER);
     if (yr > MAXSY) {
          yr=MAXSY;
     }
     else if (yr < MINSY) {
          yr=MINSY;
     }
}

mov2d(ang,x,y,yo)             /* compute only rotated y for motion         */
int ang;
int x,y;
int yo;
{
     int yc,ys;

     yc=yo*costab[ang]/10;
     ys=yo*sintab[ang]/10;
     xr=x-ys/SCALER;
     yr=y+yc/SCALER;

/*   mov2dasm(ang,x,y,0,yo);       */

}

drawobj(vecs,c)               /* draw object given vector points           */
int *vecs;
int c;
{
     int n,pts;

     pts=*vecs;
     x1=*++vecs;
     y1=*++vecs;
     for (n=2 ; n < pts ; n+=2) {
          x2=*++vecs;
          y2=*++vecs;
          drawline(x1,y1,x2,y2,c);
          x1=x2;
          y1=y2;
     }
}

pixelset(x,y,c)               /* Pixel set routine                         */
int x,y,c;
{
     pixel_set(x,y,c);
}

drawline(x1,y1,x2,y2,c)       /* Draw a line between 2 points              */
int x1,y1,x2,y2,c;
{
     line(x1,y1,x2,y2,c);
}

int ingame(sptr)              /* return 0 if not in game, otherwise game # */
struct player *sptr;
{
     if (sptr->ingame > INGAME && sptr->ingame <= TARGAME) {
          return(sptr->ingame);
     }
     return(0);
}

int plralv(sptr)              /* return 1 if player is alive, else 0       */
struct player *sptr;
{
     if (ingame(sptr) && sptr->move != GHOST && sptr->move != BLOWUP) {
          return(1);
     }
     return(0);
}

remshl(pn)                    /* when -REMOVE, set owner to dummy user #   */
int pn;
{
     int n;

     if (!gtype) {
          return;
     }
     for (n=0 ; n < SHLMAX ; n++) {
          if (shells[n].owner == pn) {
               shells[n].owner=DUMMY;
          }
          if (mines[n].owner == pn) {
               mines[n].owner=DUMMY;
          }
     }
}

cpyshl(spyrn,dpyrn)           /* when -REMOVE, lineup is shuffled.  This   */
int spyrn,dpyrn;              /* routine changes shells & mines to match.  */
{
     int n;

     if (!gtype) {
          return;
     }
     for (n=0 ; n < SHLMAX ; n++) {
          shlptr=&shells[n];
          minptr=&mines[n];
          if (shlptr->owner == spyrn) {
               shlptr->owner=dpyrn;
          }
          if (minptr->owner == spyrn) {
               minptr->owner=dpyrn;
          }
     }
}

dbgout(dsc,pn,mov)            /* output a line of debug code               */
char *dsc;
int pn,mov;
{
     fprintf(dbgfp,"%d (%-9s) %-16s %6d\n",pn,names[pn],dsc,mov);
}

dbgcls()
{
     fprintf(dbgfp,"\n\n Totals recorded:\n");
     fprintf(dbgfp," -TICKS............ %u\n",dbg->dbgtck);
     fprintf(dbgfp," UP movements...... %u\n",dbg->dbgups);
     fprintf(dbgfp," DOWN movements.... %u\n",dbg->dbgdns);
     fprintf(dbgfp," LEFT movements.... %u\n",dbg->dbglft);
     fprintf(dbgfp," RIGHT movements... %u\n",dbg->dbgrgt);
     fprintf(dbgfp," MINES dropped..... %u\n",dbg->dbgmin);
     fprintf(dbgfp," SHELLS shot....... %u\n",dbg->dbgsht);
     fprintf(dbgfp," '5' movements..... %u\n",dbg->dbgnon);
     fprintf(dbgfp," KILLS recorded.... %u\n",dbg->dbgkil);
     fprintf(dbgfp," TARGETS shot...... %u\n",dbg->dbgtar);
     setmem(dbg,sizeof(struct debug),0);
     fclose(dbgfp);
}
