/***************************************************************************
 *   TANKC.C   - Computer opponent module for Flash Tanks.                 *
 *                                                                         *
 *                                                9/11/91 by Les Bird      *
 ***************************************************************************/

#include "stdio.h"
#include "stdlib.h"
#include "portable.h"
#include "ftanks.h"
#include "ftsnds.h"
#include "tantab.h"

extern
int  shlcnt,
     mincnt,
     gpyrs,
     xr,
     yr,
     compplr;

extern
int  compn[MAXPYR],
     diflvl[MAXCOM];

extern
struct shells {
     int  d;
     int  x,y;
     int  rng;
     int  spd;
     int  color;
     int  owner;
} shells[SHLMAX],*shlptr;

extern
struct mines {
     int  x,y;
     int  color;
     int  timer;
     int  owner;
} mines[MINMAX],*minptr;

/*   difficulty table - tanks get faster as the game progresses            */

/*                .---- if rotation rate is less than this number
                  |  .-- then rotate by this amount
                  |  |                                                     */
int  difrot[20]={ 6, 1, 6, 1, 6, 2, 6, 3, 8, 2, 8, 2,12, 3,12, 4,12, 4,12, 6},
     difspd[20]={20, 1,20, 2,20, 4,30, 2,30, 5,30,10,40, 2,40, 5,40,10,50,10};
/*                |  |
                  |  `-- increase speed by this amount,
                  `---- if speed is less than this amount.                 */

movopn(cpyrn)                 /* move computerized opponents for solo game */
int cpyrn;
{
     int adjpn,ang,ang1,ang2,dif,dx,dy,tartnk,tpyr;

     tpyr=compplr+gpyrs;
     adjpn=cpyrn-MAXPYR;
     dif=(diflvl[adjpn]-1)<<1;
     tartnk=tankptr->tartnk;
     dx=((tankptr->x-player[tartnk].x)/SCALER)/2;
     dy=((tankptr->y-player[tartnk].y)/SCALER)/2;
     ang=rec2pol(dx,dy);
     if (tankptr->d < ang-1) {
          tankptr->move=ROTATE;
          if (tankptr->trate < difrot[dif]) {
               tankptr->trate+=difrot[dif+1];
          }
     }
     else if (tankptr->d > ang+1) {
          tankptr->move=ROTATE;
          if (tankptr->trate > -difrot[dif]) {
               tankptr->trate-=difrot[dif+1];
          }
     }
     else if ((tankptr->shells < dif) && (tankptr->shells < SHLMAX/tpyr)) {
          tankptr->move=NONE;
          if (plralv(&player[tartnk]) && player[tartnk].protct < 18) {
               shlptr=&shells[shlcnt];
               if (shlptr->rng == 0) {
                    rot2d(tankptr->d,tankptr->x,tankptr->y,0,SHLOFF);
                    shlptr->d=tankptr->d;
                    shlptr->x=xr;
                    shlptr->y=yr;
                    shlptr->rng=SHLRNG;
                    shlptr->spd=tankptr->spd+SPDSHL;
                    shlptr->color=tankptr->color;
                    shlptr->owner=cpyrn;
                    shlcnt=(shlcnt+1)%SHLMAX;
                    tankptr->shells+=1;
                    noise(SHOOT);
               }
          }
     }
     if (nearmine(cpyrn) && tankptr->spd > -10) {
          tankptr->spd-=difspd[dif+1];
     }
     else if (tankptr->spd < difspd[dif]) {
          tankptr->spd+=difspd[dif+1];
     }
     if (plralv(&player[tartnk]) && player[tartnk].protct == 0) {
          ang2=abs(tankptr->d-ang);
          if (ang2 > 170 && ang2 < 190 && tankptr->mines < MINPLR) {
               minptr=&mines[mincnt];
               if (minptr->timer == 0) {
                    rot2d(tankptr->d,tankptr->x,tankptr->y,0,-(SHLOFF+1));
                    minptr->x=xr;
                    minptr->y=yr;
                    minptr->timer=MINTMR;
                    minptr->color=tankptr->color;
                    minptr->owner=cpyrn;
                    mincnt=(mincnt+1)%MINMAX;
                    tankptr->mines+=1;
               }
          }
     }
}

rec2pol(dx,dy)                /* rectangular to polar conversion           */
int dx,dy;
{
     int ang,dist,high,low;

     low=0;
     high=900;
     ang=450;
     if (dx != 0) {
          dist=abs(dy)*100/abs(dx);
          while (1) {
               if (dist == tantab[ang] || (dist > tantab[ang] && dist < tantab[ang+1])) {
                    break;
               }
               if (dist > tantab[ang]) {
                    low=ang;
                    ang+=(high-low)/2;
               }
               else if (dist < tantab[ang]) {
                    high=ang;
                    ang-=(high-low)/2;
               }
          }
          ang/=10;
     }
     else {
          if (dy > 0) {
               ang=180;
          }
          else {
               ang=0;
          }
     }
     if (dx > 0) {
          if (dy > 0) {       /* quadrant 4 (dx > 0 && dy > 0)   */
               ang=90+ang;
          }
          else if (dy < 0) {  /* quadrant 3 (dx > 0 && dy < 0)   */
               ang=90-ang;
          }
          else {
               ang=90;
          }
     }
     else if (dx < 0) {
          if (dy > 0) {       /* quadrant 1 (dx < 0 && dy > 0)   */
               ang=270-ang;
          }
          else if (dy < 0) {  /* quadrant 2 (dx < 0 && dy < 0)   */
               ang=270+ang;
          }
          else {
               ang=270;
          }
     }
     adjang(&ang);
     return(ang);
}

nearmine(cpyrn)               /* check for mines in vicinity               */
int cpyrn;
{
     int a,dx,dy,n;

     for (n=0 ; n < SHLMAX ; n++) {
          if (abs(tankptr->x-mines[n].x) < TANKSIZE*6
             && abs(tankptr->y-mines[n].y) < TANKSIZE*6
             && mines[n].owner != cpyrn) {
               return(1);
          }
     }
     return(0);
}

lockon(pnum)                  /* find next target to "lock-on" to          */
int pnum;
{
     int n,tartnk,tpyr;

     tpyr=MAXPYR+compplr;
     tartnk=player[pnum].tartnk;
     for (n=0 ; n < tpyr ; n++) {  /* look for "live" player first */
          if (plralv(&player[tartnk]) && tartnk != pnum) {
               player[pnum].tartnk=tartnk;
               return;
          }
          tartnk=(tartnk+1)%tpyr;
     }
     tartnk=player[pnum].tartnk;
     for (n=0 ; n < tpyr ; n++) {  /* look for non-GHOST player    */
          if (player[tartnk].move != GHOST && tartnk != pnum) {
               player[pnum].tartnk=tartnk;
               return;
          }
          tartnk=(tartnk+1)%tpyr;
     }
}
