/***************************************************************************
 *                                                                         *
 *  FLCOMM.H                                                               *
 *                                                                         *
 *  Copyright (C) 1989 GALACTICOMM, Inc.                                   *
 *                                                                         *
 *  This source is for use by Galacticomm "FLASH" Protocol Licensees ONLY. *
 *  Any use of this software outside of the provisions of the Galacticomm  *
 *  "FLASH" Protocol Developers' License Agreement is strictly prohibited. *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *  This file contains user-side Flash Protocol defines and declarations.  *
 *                                                                         *
 *                                            - T. Stryker 5/27/89         *
 *                                                                         *
 ***************************************************************************/
 
#define NAK         21        /* non-acknowledge (ASCII)                   */
#define CAN         24        /* cancel this user (ASCII)                  */
#define NAKACK      120       /* NAK-scknowledgement (Flash)               */
#define REMOVE      121       /* remove user from pool (Flash)             */
#define TICK        122       /* 18 Hz clock tick (Flash)                  */
#define NODATA      123       /* no data, lost contact (internal)          */
#define LINEUP      127       /* new user joining pool (Flash)             */

#define MAXPYR      6         /* max number of users per pool              */
#define MAXCOM      5         /* max number of computer opponents          */
#define MAXTAR      6         /* maximum targets onscreen at once          */
#define UIDSIZ      10        /* max user-id size of each one              */
#define DUMMY       MAXPYR+MAXCOM  /* dummy user player[] number           */

#define CHWSIZ      78        /* chat-window sizes in printable bytes      */

#define SCALE       10        /* scale for computing points                */
#define SCALER      10        /* scale for rotating objects                */
#define TOTPTS      43        /* total allowed drawing points for an obj   */
#define EXPPTS      64        /* total allowed points for explosion pixels */
#define MAXXP       640       /* maximum X value (screen width)            */
#define MAXYP       350       /* maximum Y value (screen lenth)            */
#define MAXX        MAXXP*SCALE /* max X screen width * 100                */
#define MAXY        MAXYP*SCALE /* max Y screen height * 100               */
#define MINBX       12*SCALE    /* minimum X border (left side)            */
#define MAXBX       MAXX-MINBX  /* maximum X border (right side)           */
#define MINBY       24*SCALE    /* minimum Y border (top screen)           */
#define MAXBY       MAXY-MINBY  /* maximum Y border (bottom of screen)     */
#define MINSX       (3*SCALE)   /* minimum X shell border                  */
#define MAXSX       (MAXX-MINSX)-1  /* maximum X shell border              */
#define MINSY       (14*SCALE)  /* minimum Y shell border                  */
#define MAXSY       MAXY-MINSY-1 /* maximum Y shell border                 */
#define SHLMAX      30        /* max simultaneous shell projectiles        */
#define SHLRNG      75        /* range of shell (not necc. pixels)         */
#define SHLOFF      11        /* pix offset from tank (pixs)               */
#define MINPLR      5         /* mines per player                          */
#define MINMAX      30        /* max mines on screen at once               */
#define MINTMR      50        /* lifespan of mine                          */
#define MINCLR      0x07      /* color of mine on layer's screen           */
#define EXPTIM      50        /* explosion time                            */
#define PRTTIM      8         /* player safe for this time * 16            */
#define SCRCLR      0x0F      /* color for displaying the score            */
#define SPDSHL      50        /* speed of shell (pixels/10)                */
#define SPDTRN      1         /* degrees to rotate each pass               */
#define SPDINC      5         /* tank speed increase                       */

#define SHLVAL      10        /* score value of a kill by shell            */
#define MINVAL      50        /* score value of a kill by mine             */
#define TARVAL      10        /* target value when destroyed               */
#define BONUSP      200       /* bonus tank every 200 points               */

#define TANKSIZE    72        /* size of tank in pixels * SCALE            */
#define TARGSIZE    60        /* size of targets in pixels * SCALE         */

#define TAROBJ      4

#define PLRLO       1         /* collision detection values                */
#define PLRHI       MAXPYR
#define COMLO       PLRHI+1
#define COMHI       COMLO+MAXCOM-1
#define TARLO       COMHI+1
#define TARHI       TARLO+MAXTAR-1

#define NONE        0         /* tank moves being performed                */
#define ROTATE      1
#define BLOWUP      2
#define GHOST       3

#define ONHELP1     128       /* on the help screen                        */
#define ONHELP2     129       /* on the help screen                        */
#define ONHELP3     130       /* on the help screen                        */
#define ONHELP4     131       /* on the help screen                        */
#define ONHELP5     132       /* on the help screen                        */

#define NOGRAF      135       /* no EGA/VGA graphics for pyrn              */
#define INGAME      136       /* currently in the game                     */

#define TIMEDGM     140       /* playing a timed game                      */
#define GAMTIME     2160      /* -TICKS for a 2 minute game                */

#define SCOREGM     141       /* playing a game by high score              */
#define GAMSCOR     400       /* first to 400 wins                         */

#define TANKSGM     142       /* playing a game limited by tanks           */
#define TNKSPLR     10        /* give each player this many tanks at start */

#define NOLIMIT     143       /* open field battle (debug purposes only)   */

#define TARGAME     144       /* target game                               */
#define TARSCOR     500       /* first to 500 points wins                  */

struct player {               /* per-user "model" data                     */
     int  chapos;             /*   chat-window position no. (0-5)          */
     char chawin[CHWSIZ*2];   /*   chat-window video RAM image             */
     int  tnknum;             /*   tank this person is controlling         */
     int  glimt;              /*   game limitations imposed at start       */
     int  ingame;             /*   player is in game?                      */
     int  move;               /*   current move being performed            */
     int  color;              /*   color for this tank                     */
     int  d,sd;               /*   angle tank is traveling (0-360)         */
     int  x,sx;               /*   x and startx of tank                    */
     int  y,sy;               /*   y and starty of tank                    */
     int  spd;                /*   speed of tank                           */
     int  trate;              /*   turning rate                            */
     int  score;              /*   score for this player                   */
     int  lstbns;             /*   score of last bonus                     */
     int  shells;             /*   shells used                             */
     int  mines;              /*   mines used                              */
     int  timer;              /*   misc timer variable                     */
     int  steps;              /*   current step of explosion anim          */
     int  protct;             /*   protection time after player regens     */
     int  tartnk;             /*   computer tank's tank number to kill     */
     int  tdef[TOTPTS];
     int  erapts[TOTPTS];
     int  explo[EXPPTS];
};

struct debug {
     unsigned  debug;
     unsigned  dbgcnt;
     unsigned  dbgtck;
     unsigned  dbgups;
     unsigned  dbgdns;
     unsigned  dbglft;
     unsigned  dbgrgt;
     unsigned  dbgmin;
     unsigned  dbgsht;
     unsigned  dbgnon;
     unsigned  dbgkil;
     unsigned  dbgtar;
};

extern
struct player player[MAXPYR+MAXCOM+1],
              *optr,*pyrp,*tankptr;
extern
struct debug debug,*dbg;

extern
int npyrs,                              /* number of players in pool       */
    pyrn;                               /* player # input received for     */
extern
char *names[MAXPYR+2];                  /* user name as function of user # */
extern
int rseed;                              /* random number generator seed    */
extern
int fstick;                             /* fast-ticker (145.6 Hz inc rate) */
extern
int solo;                               /* flag indicating solo operation  */
