/***************************************************************************
 *                                                                         *
 *  FCNOISE.C                                                              *
 *                                                                         *
 *  Copyright (C) 1989 GALACTICOMM, Inc.                                   *
 *                                                                         *
 *  This source is for use by Galacticomm "FLASH" Protocol Licensees ONLY. *
 *  Any use of the contents of this file, or any functional derivative or  *
 *  part or portion thereof, outside of the provisions of the Galacticomm  *
 *  "FLASH" Protocol Developers' License Agreement is strictly prohibited. *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *  This file contains the Flash Chat C sound effects code.  This works    *
 *  in close conjunction with the routines in NOISES.ASM.                  *
 *                                                                         *
 *                                            - T. Stryker 12/26/89        *
 *                                                                         *
 ***************************************************************************/
 
#include "portable.h"
#include "fssnds.h"
 
int fornoi=0,                      /* foreground noise number in effect    */
    bcknoi=0,                      /* background noise number in effect    */
    period;                        /* period for return to noisemaker      */
 
int enoise=1;                      /* enable-noise flag                    */
 
extern
int fstick,                        /* fast-ticker (145.6 Hz)               */
    forctr,                        /* "foreground" noise counter (145.6 Hz)*/
    bckctr;                        /* "background" noise counter (145.6 Hz)*/
 
int chbeep(),bell(),nlaser(),ntorp(),chblop(),ncloak1(),ncloak2(),
     nshield4(),nexplo();
 
int (*fnorou[])()={                /* "foreground" noise routine ptrs      */
     chbeep,bell,nlaser,ntorp,chblop,ncloak1,ncloak2,nshield4,nexplo
};
 
int nada(),newusr(),nshield1(),nshield2(),nshield3();
 
int (*bnorou[])()={                /* "background" noise routine ptrs      */
     nada,newusr,nshield1,nshield2,nshield3
};
 
noise(n)                           /* make a noise                         */
int n;                             /*    noise number from FCNOISE.H       */
{
     if (enoise) {
          if (n > 99) {
               forctr=0;
               setnoi(fnorou[(fornoi=n)-100]);
          }
          else {
               bckctr=0;
               bcknoi=n;
               if (fornoi == 0) {
                    setnoi(bnorou[bcknoi]);
               }
          }
     }
}
 
nada()                             /* no noise                             */
{
     return(0);
}
 
chbeep()                           /* chat beep                            */
{
     period=((forctr&2) ? 0x380 : 0x300);
     if (forctr >= 5) {
          fornoi=0;
          setnoi(bnorou[bcknoi]);
     }
     return(period);
}

chblop()
{
     period=((forctr&2) ? 0x200 : 0x400);
     if (forctr >= 5) {
          fornoi=0;
          setnoi(bnorou[bcknoi]);
     }
     return(period);
}

bell()                             /* terminal-mode bell                   */
{
     if (forctr >= 20) {
          fornoi=0;
          setnoi(bnorou[bcknoi]);
     }
     return(900);
}
 
newusr()                           /* new-user tune (background)           */
{
     period=1000-bckctr;
     bckctr+=50;
     if (!enoise || period < 250) {
          bcknoi=0;
          setnoi(nada);
     }
     return(period);
}

nlaser()                           /* noise for laser fire                 */
{
     period=200-forctr;
     forctr+=10;
     if (!enoise || period < 100) {
          fornoi=0;
          setnoi(bnorou[bcknoi]);
     }
     return(period);
}

ntorp()
{
     period=100+forctr;
     forctr+=10;
     if (!enoise || period > 200) {
          fornoi=0;
          setnoi(bnorou[bcknoi]);
     }
     return(period);
}

nexplo()
{
     int kaboom[]={
          2000,5000,3000,8000,9000,4000,6000,11000,1000,7000,10000,
          2500,5500,3500,8500,9500,4500,6500,11500,1500,7500,10500,
          3000,6000,4000,9000,10000,5000,7000,12000,2000,8000,11000,
          3500,6500,4500,9500,10500,5500,7500,12500,2500,8500,11500,
          4000,7000,5000,10000,11000,6000,8000,13000,3000,9000,12000,
          4500,7500,5500,10500,11500,6500,8500,13500,3500,9500,12500,
          5000,8000,6000,11000,12000,7000,9000,14000,4000,10000,13000,
          5500,8500,6500,11500,12500,7500,9500,14500,4500,10500,13500,
          6000,9000,7000,12000,13000,8000,10000,15000,5000,11000,14000
     };

     if (forctr > sizeof(kaboom)/sizeof(int)) {
          fornoi=0;
          setnoi(bnorou[bcknoi]);
     }
     else {
          return(kaboom[forctr]);
     }
}

ncloak1()
{
     period=1000+forctr;
     forctr+=500;
     if (forctr > 10000) {
          fornoi=0;
          setnoi(bnorou[bcknoi]);
     }
     return(period);
}

ncloak2()
{
     period=11000-forctr;
     forctr+=1000;
     if (forctr > 10000) {
          fornoi=0;
          setnoi(bnorou[bcknoi]);
     }
     return(period);
}

nshield1()
{
     period=(bckctr&2) ? 30000 : 20000;
     return(period);
}

nshield2()
{
     bcknoi=0;
     setnoi(nada);
}

nshield3()
{
     int shldhit[]={
          200,20000,200,30000
     };

     if (bckctr > sizeof(shldhit)/sizeof(int)) {
          bcknoi=SHIELDUP;
          setnoi(bnorou[bcknoi]);
     }
     else {
          return(shldhit[bckctr]);
     }
}

nshield4()
{
     int hitshld[]={
          200,20000,200,30000
     };

     if (forctr > sizeof(hitshld)/sizeof(int)) {
          fornoi=0;
          setnoi(bnorou[bcknoi]);
     }
     else {
          return(hitshld[forctr]);
     }
}
