/***************************************************************************
 *                                                                         *
 *  FSCHAT.C                                                               *
 *                                                                         *
 *  Copyright (C) 1991 GALACTICOMM, Inc.                                   *
 *                                                                         *
 *  Flash SpaceWars - up to 10 players can participate in this space       *
 *                    shoot'em up game.                                    *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *  This file is the Flash SpaceWars Chat module.                          *
 *                                                                         *
 *                                            - Les Bird   12/10/91        *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "setjmp.h"
#include "dos.h"
#include "dosface.h"
#include "fkcode.h"
#include "portable.h"
#include "fscomm.h"
#include "fssnds.h"

                              /* screen-image table indexes                */
#define SFCHAT      0         /*    main flash chat screen                 */
#define SFCHELP     1         /*    flash chat help screen                 */
#define SFCHELPT    2         /*    terminal-mode help screen              */

#define ALTX   11520          /* ALT-X key code                            */

struct player player[MAXPYR],*pyrp;

extern
char scntbl[];                /* in-memory screen-image table              */
 
int onscrn,                   /* on-screen flag (help-screen-bar)          */
    ostick,                   /* old "fstick" value                        */
    self,                     /* this user's own user number (0-5)         */
    disp;                     /* the received character is this guy's      */
 
int oldcx,oldcy,              /* DOS screen cursor x,y positions           */
    trmscx,trmscy;            /* terminal-mode saved cursor coordinates    */
char dosscn[4000],            /* saved DOS screen                          */
     trmscn[4000];            /* saved terminal-mode screen image          */
 
#define scrnad(x,y) (frzseg()+(x)*2+(y)*160)   /* CRT address of (x,y)     */
 
long rndnum;                  /* pseudo-random number accumulator          */
 
char *frzseg();               /* CRT screen address (from MBBST.LIB)       */
char *alcmem();               /* memory allocator   (from GENUTL.C)        */
 
extern jmp_buf disaster;      /* master error-recovery longjmp save block  */
 
main(argc,argv)               /* Flash Chat mainline                       */
int argc;
char *argv[];
{
     if (setjmp(ADDR_OFdisaster) != 0) {
          finft();
     }
     init(argc,argv);
     oldcx=curcurx();
     oldcy=curcury();
     savscn(dosscn);
     if (solo) {
          names[0]="YOU";
          noise(NEWUSR);
     }
     else {
          outser(0,'\r');
          termnl("\14");
     }
     chat();
     rstscn(dosscn);
     locate(oldcx,oldcy);
}
 
init(argc,argv)               /* initialize communications, etc.           */
int argc;
char *argv[];
{
     static int spckys[]={
          F1,F5,F6,F7,F8,SHIFT+F9,SHIFT+F10,13,27,
          1,30,30+128,31,31+128,32+128,
          8,
          37+128,38+128,39+128,42+128,71+128,72+128,73+128,75+128,77+128,
          PIKSHIP,WAITING,PLAYING,ONHELP
     };
 
     inicom(argc,argv);
     ininoi();
     setspc(spckys);
}
 
chat()                        /* main chat loop                            */
{
     int c;
 
     shocha();
     inirtk();
     ostick=fstick;
     while (1) {
          if (!(ingame(player[self].state))) {
               if (kbhit()) {
                    ecoutp(getchc());
               }
          }
          switch (c=ecinp()) {
          case -1:
               if (solo && (fstick-ostick) >= 8) {
                    rseed+=1;
                    prcrtk();
                    if (ingame(player[self].state)) {
                         fpmovp1();
                    }
                    ostick=fstick;
               }
               break;
          case -TICK:
               rseed+=1;
               prcrtk();
               if (ingame(player[self].state)) {
                    fpmovp1();
               }
               break;
          case -REMOVE:
               pyrn=ecinp()-'0';
               if (onscrn) {
                    loccwl(pyrn);
                    setatr(AT4CHW);
                    if (player[pyrn].chapos == 0) {
                         printf("");
                    }
                    else {
                         printf("");
                    }
                    rstloc();
                    setmem(player[pyrn].chawin,CHWSIZ*2,0);
                    dspchw(pyrn);
               }
               rmvplr();
               if (--npyrs != pyrn) {
                    movmem(&player[npyrs],&player[pyrn],sizeof(struct player));
                    names[pyrn]=names[npyrs];
                    if (self == npyrs) {
                         self=pyrn;
                    }
               }
               break;
          case -LINEUP:
               linem();
               linem2();
               break;
          case -NODATA:
               if (!onscrn) {
                    rstvid6();
                    rstkeyi();
               }
               lvpool();
               outser(0,'\r');
               termnl("\n*** LOST CONTACT ***\n");
               shocha();
               inirtk();
               break;
          default:
               setpyr(pyrn);
               if (ingame(pyrp->state)) {
                    dwgchr(c);
               }
               else {
                    dwcchr(c);
               }
          }
     }
}
 
setpyr(pn)                    /* set global player-id values to specd user */
int pn;
{
     pyrn=pn;
     pyrp=&player[pyrn];
}
 
shocha()                      /* show current chat windows on CRT          */
{
     int i;
     char msg[40];
 
     onscrn=1;
     setwin(0L,0,0,79,24,1);
     iniscn(SFCHAT,frzseg());
     for (i=0 ; i < npyrs ; i++) {
          loccwl(i);
          if (player[i].score > 0) {
               sprintf(msg,"  LAST SCORE: %3d ",player[i].score);
               setatr(0x70);
               printf(" %-9s%s ",names[i],msg);
          }
          else {
               if (player[i].chapos == 0) {
                    strcpy(msg,"");
               }
               else {
                    strcpy(msg,"");
               }
               setatr(0x70);
               printf(" %-9s ",names[i]);
               setatr(AT4CHW);
               printf("%s",msg);
          }
          player[i].chawin[CHWSIZ*2-1]=AT4WRT;
          dspchw(i);
     }
     i=player[self].chapos;
     locate(CHWSIZ,2+i*2);
}
 
linem()                       /* LINEUP command handler during chat        */
{
     int i,j;
 
     for (i=0 ; i < npyrs ; i++) {
          for (j=0 ; j < npyrs ; j++) {
               if (player[j].chapos == i) {
                    break;
               }
          }
          if (j == npyrs) {
               break;
          }
     }
     parsln();
     noise(NEWUSR);
     setmem(pyrp=&player[npyrs-1],sizeof(struct player),0);
     pyrp->chapos=i;
     iniplr();
     if (onscrn) {
          loccwl(npyrs-1);
          setatr(0x70);
          printf(" %-9s ",names[npyrs-1]);
          rstloc();
     }
}
 
dwcchr(c)                     /* deal with a chat character                */
int c;
{
     if (pyrp->state == ONHELP) {
          if (c < 128) {
               if (pyrn == self) {
                    shocha();
               }
               else {
                    rstchw(pyrn);
               }
               pyrp->state=0;
          }
          return;
     }
     disp=((pyrn == self) && onscrn);
     if (addchr(c)) {
          return;
     }
     chachr(c);
}
 
chachr(c)                     /* process a chat character, rest of the way */
int c;
{
     switch (c) {
     case F1:
          if (disp) {
               iniscn(SFCHELP,frzseg());
               onscrn=0;
               locate(0,0);
          }
          else {
               rmvsel(pyrn);
               savchw(pyrn,onhelp);
          }
          pyrp->state=ONHELP;
          break;
     case SHIFT+F9:
          if (solo) {
               noise(NEWUSR);
          }
          else if (disp) {
               lvpool();
               lvpool();
               termnl("\n*** HIT F9 TO RETURN TO FLASH SPACEWAR CHAT ***\n");
               shocha();
               inirtk();
          }
          break;
     case SHIFT+F10:
          if (disp) {
               finft();
          }
          break;
     default:
          if ((c&0xFF00) == 0) {
               noise(CHBEEP);
               if (c == 8 || c == 127) {
                    movmem(pyrp->chawin,
                           pyrp->chawin+2,(CHWSIZ-1)*2);
                    pyrp->chawin[0]=0;
               }
               else if (c != 0x1B) {
                    movmem(pyrp->chawin+2,
                           pyrp->chawin,(CHWSIZ-1)*2);
                    pyrp->chawin[CHWSIZ*2-2]=(c == '\r' ? 17 : c);
                    pyrp->chawin[CHWSIZ*2-1]=AT4WRT;
               }
               dspchw(pyrn);
          }
     }
}
 
loccwl(pyrn)                  /* locate cursor at chat window title point  */
int pyrn;
{
     int j;
 
     j=player[pyrn].chapos;
     locate(2,1+j*2);
}
 
dspchw(pyrn)                  /* display chat-window contents for a user   */
int pyrn;
{
     int j;
     char *src;
 
     if (onscrn) {
          j=player[pyrn].chapos;
          src=player[pyrn].chawin;
          movmem(src,scrnad(1,2+j*2),CHWSIZ*2);
     }
     shosel(pyrn);
}
 
termnl(stg)                   /* terminal-mode utility, with message string*/
char *stg;
{
     int i,c,gackf;
     long protct();
     static char ansiid[]={"\33[6n"};
     char *ansptr;

     gackf=0;
     if (trmscn[0] != 0) {
          rstscn(trmscn);
     }
     locate(0,0);
     setatr(0x70);
     printf(" Flash SpaceWars Copr.1992 by ELB, RJS & TJS  F1=HELP  F9=CHAT  ALT-X=EXIT ");
     rstloc();
     setatr(AT4WRT);
     setwin(0L,0,1,79,24,1);
     printf(stg);
     ansptr=ansiid;
     while (1) {
          while ((c=rdser(0)) != '\0') {
               if (c != -1) {
                    if (c == 7) {
                         noise(BELL);
                    }
                    else if (c == *ansptr) {
                         printf("%c",c);
                         if (*++ansptr == '\0') {
                              outser(0,'R');
                              ansptr=ansiid;
                         }
                    }
                    else {
                         ansptr=ansiid;
                         printf("%c",c);
                    }
               }
               if (kbhit()) {
                    switch (c=getchc()) {
                    case F1:
                         savscn(trmscn);
                         iniscn(SFCHELPT,frzseg());
                         locate(0,0);
                         getchc();
                         rstscn(trmscn);
                         break;
                    case F9:
                         gackf=1;
                         entgam();
                         break;
                    case SHIFT+F10:
                    case ALTX:
                         finft();
                         break;
                    default:
                         if (c >= 0 && c <= 127) {
                              outser(0,c);
                         }
                    }
               }
          }
          for (i=0 ; i < 5 ; i++) {
               while ((c=rdser(0)) == EOF && !kbhit()) {
               }
               if (c != '\0') {
                    break;
               }
          }
          fstick=0;
          clreci();
          while ((c=ecinp()) == -1 && !kbhit()) {
          }
          if (c == -LINEUP) {
               if (!parsln()) {
                    break;
               }
               lvpool();
          }
     }
     if (!gackf) {
          lvpool();
          lvpool();
          lvpool();
     }
     noise(NEWUSR);
     for (i=0 ; i < npyrs ; i++) {
          setmem(pyrp=&player[i],sizeof(struct player),0);
          pyrp->chapos=i;
          iniplr();
     }
     self=npyrs-1;
     printf("\n... Entering Flash %s %s...\n",GAMNAM,GAMVER);
     savscn(trmscn);
}
 
savscn(savbuf)                /* save current CRT contents & cursor pos    */
char *savbuf;
{
     movmem(frzseg(),savbuf,4000);
     trmscx=curcurx();
     trmscy=curcury();
}
 
rstscn(rstbuf)                /* restore CRT contents & cursor from saved  */
char *rstbuf;
{
     movmem(rstbuf,frzseg(),4000);
     locate(trmscx,trmscy);
}
 
rnd()                         /* generate next pseudo-random number        */
{
     rndnum=rndnum*33821223L+871L;
     return((int)(rndnum>>16)&32767);
}
 
iniscn(scnnum,where)          /* initialize a screen from screen image     */
int scnnum;
char *where;
{
     movmem(scntbl+scnnum*4000,where,4000);
}
 
finft()                       /* finish up Flash Chat, return to DOS       */
{
     if (!solo) {
          lvpool();
          lvpool();
          finser(0);
     }
     finnoi();
     rstscn(dosscn);
     locate(oldcx,oldcy);
     exit();
}
 
char *
catfix1()                     /* "catastro" debug output, line 1 (if any)  */
{
     return("");
}
 
char *
catfix2()                     /* "catastro" debug output, line 2 (if any)  */
{
     return("");
}
 
