/***************************************************************************
 *                                                                         *
 *  FSCOMM.H                                                               *
 *                                                                         *
 *  Copyright (C) 1991 GALACTICOMM, Inc.                                   *
 *                                                                         *
 *  This source is for use by Galacticomm "FLASH" Protocol Licensees ONLY. *
 *  Any use of this software outside of the provisions of the Galacticomm  *
 *  "FLASH" Protocol Developers' License Agreement is strictly prohibited. *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *  This file contains user-side Flash Protocol defines and declarations.  *
 *                                                                         *
 *                                            - T. Stryker 5/27/89         *
 *                                                                         *
 ***************************************************************************/
 
#define NAK      21                     /* non-acknowledge (ASCII)         */
#define CAN      24                     /* cancel this user (ASCII)        */
#define NAKACK  120                     /* NAK-scknowledgement (Flash)     */
#define REMOVE  121                     /* remove user from pool (Flash)   */
#define TICK    122                     /* 18 Hz clock tick (Flash)        */
#define NODATA  123                     /* no data, lost contact (internal)*/
#define LINEUP  127                     /* new user joining pool (Flash)   */
#define MAXPYR   10                     /* maximum users allowed           */
#define UIDSIZ   10                     /* max user-id size of each one    */
#define CHWSIZ   78

#define NPTS     64                     /* total drawing points/object     */
#define PIKSHIP 256                     /* game state - picking a ship     */
#define WAITING 257                     /* game state - waiting for others */
#define PLAYING 258                     /* game state - playing a game     */
#define GAMOVER 259                     /* game state - game is over       */
#define NOEVGA  260                     /* game state - no ega/vga display */
#define ONHELP  261                     /* game state - reading help screen*/
#define AT4WRT  0x0A          /* attribute for writes inside chat-windows  */
#define AT4CHW  0x0B          /* attribute for the chat-windows themselves */

#define GAMNAM  "Spacewar"
#define GAMVER  "V1.7"

struct player {               /* per-user "model" data                     */
     int chapos;              /*   chat-window position no. (0-9)          */
     char chawin[CHWSIZ*2];   /*   chat-window video RAM image             */
     int accel;               /*   acceleration                            */
     int ang;                 /*   rotated angle                           */
     int color;               /*   this player's color                     */
     int explo;               /*   explosion timer                         */
     int firec;               /*   fire control (1=firing weapon)          */
     int flags;               /*   CLOAK, SHIELDS                          */
     int fstorp;              /*   first torp for this player in torp[]    */
     int hyper;               /*   hyperspace timer                        */
     int lstorp;              /*   last torpedo before wrap-around         */
     int mass;                /*   mass of this ship                       */
     int nxtorp;              /*   next torpedo for this ship to fire      */
     int objn;                /*   this objects assigned number (color)    */
     int pyrn;                /*   pyrn assigned at start of game          */
     int rrate;               /*   rotation rate                           */
     int score;               /*   this player's score                     */
     int shield;              /*   shield strength                         */
     int state;               /*   state player is in                      */
     int x,y;                 /*   current x, y coordinate                 */
     int xo,yo;               /*   x offset, y offset                      */
     int pts[NPTS];           /*   draw vector endpoints                   */
};

extern
struct player player[MAXPYR],*pyrp;
 
extern
int npyrs,                              /* number of players in pool       */
    pyrn;                               /* player # input received for     */
extern
char *names[MAXPYR+2];                  /* user name as function of user # */
extern
int rseed;                              /* random number generator seed    */
extern
int fstick;                             /* fast-ticker (145.6 Hz inc rate) */
extern
int solo;                               /* flag indicating solo operation  */
extern
char onhelp[];
