; SETLUMAZ.ASM (son et lumiere for Flash Maze)
;
; by Tim Stryker (with Flash Maze modifications by Scott Brinker)
; Copyright (c) 1989 Galacticomm, Inc.
; All Rights Reserved
; ...and...
; Copyright (c) 1990 Galactic Innovations, Inc.
; All Rights Reserved
;
; inisnd();                     initialize for action
;
; noilvl(onoff);                turn sounds on or off
; int onoff;                       non-zero is on, 0 is off
;
; noise(noinum);                make a noise
; int noinum;                      noise number: 0=silence
;                                                1=short, medium-pitch beep
;                                                2=quick descending zing
;                                                3=quick ascending zing
;                                                4=explosion
;                                                5=long descending whistle
;                                                6=laser singe
;                                                7=gloorp
;                                                8=seeker varying dweeb
;                                                9=comm twiddle
;                                               10=ongoing "burglar alarm"
;                                               11=tread grind
;                                               12=base pod explosion
;                                               13=chat comm twiddle
;                                               14=lose-game whoosh
;                                               15=neurubble touch
;
; fldbas(faddr,fwidth);         set playfield base address and width
; char *faddr;                     memory address of playfield upper left
; int fwidth;                      playfield width in characters
;
; crtbas(daddr,dwidth);         set CRT base address and width
; char *daddr;                     memory address of display upper left
; int dwidth;                      display width in characters
;
; wcoord(wnum,ulx,uly);         set base/tank window coordinates
; int wnum;                        window number: 0=base, 1-4=tanks
; int ulx,uly;                     upperleft x and y coords (ulx == -1 disables)
;
; showin();                     refresh tank and base windows to crt
;
; seebas(sfsizx,sfsizy,sfcrtx,sfcrty) set seefld() size and CRT base coords
; int sfsizx,sfsizy;                    x and y size of seefld() output
; int sfcrtx,sfcrty;                    x and y coords of (0,0) point on CRT
;
; seefld(ulx,uly);              one-shot display of playfield to screen
; int ulx,uly;                     upperleft x and y playfield coords
;
; finsnd();                     restore vectors etc. upon shutdown
;

        include model.mac

        if lcode
ARGOFF  equ     6
        else
ARGOFF  equ     4
        endif

                                ; motherboard hardware control info
TIMER   equ     40H             ;   8253 counter/timer port address
OCW2    equ     20H             ;   8259 port addr for writing EOI info
NSEOI   equ     20H             ;   8259 non-specific EOI command code

SSTSIZ  equ     16              ; up to this many sounds pending

NWINS   equ      1              ; this many display windows
BASWID  equ     59              ; base window width
BASHGT  equ     21              ; base window height
DULX0   equ      1              ; display upper left x-coord for base
DULY0   equ      1              ; display upper left y-coord for base

        dseg
        public  _fstick,_fstick2
_fstick dw      0               ; increments appx. 145.6 times per second
_fstick2 dw     0               ; ditto
onoff   dw      1               ; volume is on by default
rtvec   dw      offset nada     ; real-time vector
addend  dw      ?               ; addend for rti selection
cycler  dw      ?               ; cyclic counter for rti selection
nsound  dw      0               ; number of sounds in stack
sounds  dw      SSTSIZ dup(?)   ; sound stack
doctor  db      ?               ; flag indicating we "doctored" the RTI period
docler  db      ?               ; cyclic counter for doctoring purposes

lastim  dw      ?               ; laser-only sound timer
mtime   dw      ?               ; medium-length sound timer
ltime   dw      ?               ; long sound timer
wtime   dw      ?               ; whistle timer
stime   dw      ?               ; short sound timer
atime   dw      ?               ; all-over sound timer
dzper   dw      ?               ; specialized period-holders
azper   dw      ?
whper   dw      ?
whoctr  dw      ?
bpfreq  dw      4000,3000,2000,1600,1300  ; periods for pod-base explo
        dw      1100,950,900,875,900,925,950,975,1000,1030
rndst1  dw      ?               ; random number generator stage 1
rndnum  dw      ?               ; random number itself

ddfbas  label   dword
faddr   dw      ?               ; playfield base address
        dw      ?
fwidth  dw      ?               ; playfield width in ram bytes
dddbas  label   dword
daddr   dw      ?               ; display base address
        dw      ?
dwidth  dw      ?               ; display width in ram bytes

s0ptr   dw      -1              ; memory offset of base window start

d0ptr   dw      ?               ; display offset of base window start

sfsizx  dw      ?               ; seefld() output width
sfsizy  dw      ?               ; seefld() output height
dsfptr  dw      ?               ; display offset of seefld() window start

        endds

        pseg    setlu

oldrdw  label   dword           ; old real-time interrupt vector for feed-thru
oldrti  dw      0,0

        proc_def    inisnd      ; initialize sound stuff
        push    bp
        mov     bp,sp

        push    ds                      ; read and record old rti vector
        xor     ax,ax
        mov     ds,ax
        assume  ds:nothing
        mov     bx,8*4
        cli
        mov     cx,[bx]
        mov     dx,[bx+2]
        mov     cs:oldrti,cx
        mov     cs:oldrti+2,dx
        mov     word ptr [bx],offset rtirpt  ; set new rti vector
        mov     [bx+2],cs

;       in      al,TIMER                ; how fast are timer irpts now?
;       mov     cl,al
;       in      al,TIMER
;       mov     ch,al
;       mov     dl,0
;       or      cx,cx
;       jnz     storaw                  ; assume >4x (GSBL is >=16x)
                                        ; otherwise normal
        out     TIMER,al                ; set timer 0 latch to 2000H
        mov     al,20H                  ;   (8 * normal speed)
        out     TIMER,al                ;   (appx. 145.6 Hz)
        mov     cx,2000H                ; pretend that's what we read
        mov     dl,1                    ; set "doctored" flag

storaw: pop     ds                      ; switch back to dgroup
        assume  ds:dgroup

        mov     addend,cx               ; remember for interrupt pass-off
        mov     doctor,dl               ; nonzero if doctored
        sti

        mov     al,0B6H                 ; sel ch#2, r/w LSB-MSB, mode 3, binary
        out     43H,al
        mov     al,2                    ; make inaudibly-high pitch
        out     42H,al
        xor     al,al
        out     42H,al

        cli
        in      al,61H                  ; turn on speaker
        or      al,3
        out     61H,al
        sti

        pop     bp
        ret
        end_proc


        proc_def    noilvl      ; turn volume on or off
        push    bp
        mov     bp,sp
        mov     ax,[bp+ARGOFF]
        mov     onoff,ax
        or      ax,ax
        jnz     lvlret
        call    silence
lvlret: pop     bp
        ret
        end_proc


        proc_def    noise       ; make a joyful noise!
        push    bp
        mov     bp,sp
        push    si
        push    di

        xor     bx,bx
        test    onoff,0FFFFH            ; volume off?
        jz      noisil                  ; off, ignore

        mov     bx,[bp+ARGOFF]          ; look up handler routine
        shl     bx,1
        call    cs:soundr[bx]           ; go to it

noisil: pop     di
        pop     si
        pop     bp
        ret

soundr  label   word
        dw      offset silence          ; 0=silence
        dw      offset beep             ; 1=short, medium-pitch beep
        dw      offset dzing            ; 2=quick descending zing
        dw      offset azing            ; 3=quick ascending zing
        dw      offset explo            ; 4=explosion
        dw      offset dwhis            ; 5=long descending whistle
        dw      offset laser            ; 6=laser dweeb
        dw      offset glorp            ; 7=gloorp
        dw      offset dweeb            ; 8=quick descending dweeb
        dw      offset twidd            ; 9=comm twiddle
        dw      offset alarm            ;10=ongoing "burglar alarm"
        dw      offset tread            ;11=tread grind
        dw      offset baspod           ;12=base pod explosion
        dw      offset ctwidd           ;13=chat comm twiddle
        dw      offset whoosh           ;14=lose-game whoosh
        dw      offset yeep             ;15=neurubble touch
        end_proc

silence proc    near
        mov     rtvec,offset nada       ; silenzio
        mov     nsound,0
        mov     al,2
        out     42H,al
        xor     al,al
        out     42H,al
nada:   ret
silence endp

beep    proc    near
        mov     mtime,10
        mov     ax,offset ibeep
        call    isound

ibeep:  test    mtime,0FFFFH    ; time out beep
        js      beepdn
        mov     al,7                    ; medium frequency
        out     42H,al
        out     42H,al
        ret
beepdn: call    esound
        ret
beep    endp

dzing   proc    near
        mov     mtime,10
        mov     dzper,1024
        mov     ax,offset idzing
        call    isound

idzing: test    mtime,0FFFFH
        js      dzidun
        mov     ax,dzper
        shr     ax,1
        shr     ax,1
        add     ax,dzper
        mov     dzper,ax
        out     42H,al
        mov     al,ah
        out     42H,al
        ret
dzidun: call    esound
        ret
dzing   endp

azing   proc    near
        mov     mtime,14
        mov     azper,1000H
        mov     ax,offset iazing
        call    isound

iazing: test    mtime,0FFFFH
        js      azidun
        mov     ax,azper
        sub     azper,220
        out     42H,al
        mov     al,ah
        out     42H,al
        ret
azidun: call    esound
        ret
azing   endp

explo   proc    near
        mov     mtime,16
        mov     ax,offset iexplo
        call    isound

iexplo: test    mtime,0FFFFH
        js      expdun
        mov     ax,mtime
        neg     ax
        and     ax,3
        mov     cl,12
        shl     ax,cl
        mov     dx,ltime
        and     dx,15
        neg     dx
        add     dx,16
        mov     dh,dl
        add     ax,dx
        out     42H,al
        mov     al,ah
        out     42H,al
        ret
expdun: call    esound
        ret
explo   endp

dwhis   proc    near
        mov     wtime,600
        mov     whper,256
        mov     ax,offset idwhis
        call    isound

idwhis: test    wtime,0FFFFH
        js      dwhdun
        mov     ax,whper
        shr     ax,1
        shr     ax,1
        shr     ax,1
        shr     ax,1
        shr     ax,1
        shr     ax,1
        shr     ax,1
        shr     ax,1
        add     ax,whper
        mov     whper,ax
        out     42H,al
        mov     al,ah
        out     42H,al
        ret
dwhdun: call    esound
        ret
dwhis   endp

laser   proc    near
        mov     lastim,50
        mov     azper,80H
        mov     ax,offset ilase
        call    isound

ilase:  test    lastim,0FFFFH
        js      lasedn
        mov     ax,azper
        add     azper,40H
        mov     al,ah
        out     42H,al
        and     al,127
        out     42H,al
        ret
lasedn: call    esound
        ret
laser   endp

glorp   proc    near
        mov     mtime,20
        mov     ax,offset iglorp
        call    isound

iglorp: test    mtime,0FFFFH
        js      glpdun
        mov     ax,mtime
        and     ax,3
        mov     cl,10
        shl     ax,cl
        mov     dx,mtime
        shl     dx,1
        shl     dx,1
        shl     dx,1
        shl     dx,1
        add     ax,dx
        add     ax,80H
        out     42H,al
        mov     al,ah
        out     42H,al
        ret
glpdun: call    esound
        ret
glorp   endp

dweeb   proc    near
        mov     mtime,16
        mov     ax,offset ilaser
        call    isound

ilaser: test    mtime,0FFFFH
        js      lsrdun
;       add     rndst1,29111
        add     rndst1,11
        mov     ax,rndst1
        add     rndnum,ax
        mov     ax,rndnum
        and     ax,63
;       and     ax,127
        mov     dx,ltime
;       shl     dx,1
;       shl     dx,1
;       shl     dx,1
        shl     dx,1
        shl     dx,1
        shl     dx,1
        and     dx,3FFH
        test    dx,200H
        jz      lasadd
        sub     dx,400H
        neg     dx
lasadd: add     dx,800
        add     ax,dx
        out     42H,al
        mov     al,ah
        out     42H,al
        ret
lsrdun: call    esound
        ret
dweeb   endp

twidd   proc    near
        mov     stime,11
        mov     ax,offset itwidd
        call    isound

itwidd: test    stime,0FFFFH    ; time out twiddle
        js      twidun
        mov     ax,stime
        and     ax,4
        mov     cl,7
        shl     ax,cl
        add     ax,500H
        out     42H,al
        mov     al,ah
        out     42H,al
        ret
twidun: call    esound
        ret
twidd   endp

alarm   proc    near
        mov     rtvec,offset ialarm
        mov     nsound,0
        mov     atime,0

ialarm: mov     ax,atime
        shl     ax,1
        shl     ax,1
        shl     ax,1
        shl     ax,1
        shl     ax,1
        shl     ax,1
        and     ax,8191
        add     ax,1400
        out     42H,al
        mov     al,ah
        out     42H,al
        ret
alarm   endp

tread   proc    near
        mov     stime,4
        mov     ax,offset itread
        call    isound

itread: test    stime,0FFFFH
        js      trddun
        add     rndst1,29111
        mov     ax,rndst1
        add     rndnum,ax
        mov     ax,rndnum
        and     ax,03FFFH
        or      ax,2000H
        out     42H,al
        mov     al,ah
        out     42H,al
        ret
trddun: call    esound
        ret
tread   endp

baspod  proc    near
        mov     mtime,14
        mov     ax,offset ibspod
        call    isound

ibspod: test    mtime,0FFFFH
        js      ibsdun
        mov     bx,mtime
        add     bx,bx
        mov     ax,bpfreq[bx]
        out     42H,al
        mov     al,ah
        out     42H,al
        ret
ibsdun: call    esound
        ret
baspod  endp

ctwidd  proc    near
        mov     stime,4
        mov     ax,offset ictwid
        call    isound

ictwid: test    stime,0FFFFH    ; time out twiddle
        js      ictdun
        mov     ax,stime
        and     ax,2
        mov     cl,7
        shl     ax,cl
        add     ax,300H
        out     42H,al
        mov     al,ah
        out     42H,al
        ret
ictdun: call    esound
        ret
ctwidd  endp

whoosh  proc    near
        mov     ltime,100
        mov     whoctr,0C00H
        mov     ax,offset iwhoo
        call    isound

iwhoo:  test    ltime,0FFFFH    ; time out whoosh
        js      iwhdun
        mov     ax,ltime
        add     ax,32
        shl     ax,1
        add     ax,whoctr
        and     ax,0FFFH
        or      ax,0C00H
        mov     whoctr,ax
        out     42H,al
        mov     al,ah
        out     42H,al
        ret
iwhdun: call    esound
        ret
whoosh  endp

yeep    proc    near
        mov     stime,4
        mov     ax,offset iyeep
        call    isound

iyeep:  test    stime,0FFFFH    ; time out yeep
        js      yeepdn
        mov     al,6                    ; middling frequency
        out     42H,al
        out     42H,al
        ret
yeepdn: call    esound
        ret
yeep    endp

isound  proc    near            ; install new sound (when done, old continues)
        push    bx
        push    cx
        mov     bx,nsound               ; too many concurrently?
        cmp     bx,SSTSIZ
        jae     isret                   ; yes, ignore
        cmp     rtvec,ax                ; same as one currently going on?
        je      isret                   ; yes, ignore
        shl     bx,1                    ; no, save old one
        cli
        mov     cx,rtvec
        mov     sounds[bx],cx
        inc     nsound                  ; indicate one more on stack
        mov     rtvec,ax                ; set new
        sti
isret:  pop     cx
        pop     bx
        ret
isound  endp

esound  proc    near            ; end current sound, return to old (irpt lvl)
        dec     nsound                  ; one less on the stack now
        mov     bx,nsound               ; pop one and make it current
        shl     bx,1
        mov     ax,sounds[bx]
        mov     rtvec,ax
        cmp     ax,offset nada          ; is this going to silence?
        jne     esoret                  ; no
        mov     al,2                    ; yes, turn off sound
        out     42H,al
        xor     al,al
        out     42H,al
esoret: ret
esound  endp

rtirpt  proc    far             ; MASTER REAL-TIME INTERRUPT VECTOR DEST

        push    ax                      ; save regs
        push    bx
        push    cx
        push    dx
        push    si
        push    di
        push    ds
        push    es
        mov     ax,dgroup               ; establish addressability
        mov     ds,ax

irpdch: mov     ax,addend               ; time for one of ours?
        add     cycler,ax
        test    cycler,0E000H
        jz      irprtr                  ; not yet
        and     cycler,01FFFH           ; yeppo
        inc     _fstick
        inc     _fstick2

        dec     mtime                   ; time out various processes
        dec     ltime
        dec     lastim
        dec     wtime
        dec     stime
        dec     atime

        call    [rtvec]                 ; do current sound effect if any

irprtr: test    doctor,0FFH             ; did we doctor the RTI ourselves?
        jz      regrtr                  ; no, just hitchhiking
        add     docler,20H              ; yes, every eighth time do regular
        jc      regrtr

        mov     al,NSEOI                ; 7/8 of time finish it up ourselves
        out     OCW2,al
        pop     es
        pop     ds
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        iret

regrtr: pop     es                      ; don't EOI yet, just pop regs
        pop     ds
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        jmp     cs:[oldrdw]             ; give that regular rti guy a chance

rtirpt  endp

up1win  proc    near            ; update one window
        cmp     si,-1                   ; window disabled?
        je      up1ret                  ; yes
        mov     ax,fwidth               ; get playfield and display widths
        mov     bx,dwidth
        push    ds
        cld                             ; (this will be restored by iret)
        mov     es,daddr+2              ; address display
        mov     ds,faddr+2              ; address playfield
anothr: push    cx
        push    si
        push    di
        rep     movsw                   ; show a line
        pop     di
        pop     si
        pop     cx
        add     si,ax                   ; move on to next line
        add     di,bx
        dec     dx
        jnz     anothr                  ; if there is one
        pop     ds
up1ret: ret
up1win  endp

        proc_def finsnd         ; put everything back

        mov     cx,cs:oldrti            ; anything need to be put back?
        mov     dx,cs:oldrti+2
        mov     ax,cx
        or      ax,dx
        jz      nnoret                  ; no

        cli
        in      al,61H                  ; turn off speaker
        and     al,0FFH-3
        out     61H,al
        sti

        xor     ax,ax                   ; address zero page
        push    ds
        mov     ds,ax
        assume  ds:nothing
        mov     bx,8*4                  ; restore old rti vector
        cli
        mov     [bx],cx
        mov     [bx+2],dx

        pop     ds                      ; switch back to dgroup
        assume  ds:dgroup

        test    doctor,0FFH             ; did doctor before?
        jz      nnosti                  ; no, leave alone
        out     TIMER,al                ; set timer 0 latch back to normal
        out     TIMER,al
nnosti: sti

nnoret: ret

        end_proc

; fldbas(faddr,fwidth);         set playfield base address and width
        proc_def fldbas
        push    bp                      ; access args
        mov     bp,sp
        push    es
        les     ax,[bp+ARGOFF]          ; stick faddr in memory
        cli
        mov     faddr,ax
        mov     faddr+2,es
        mov     ax,[bp+ARGOFF+4]        ; stick fwidth in memory
        add     ax,ax
        mov     fwidth,ax
        sti
        pop     es
        pop     bp
        ret
        end_proc

; crtbas(daddr,dwidth);         set CRT base address and width
        proc_def crtbas
        push    bp                      ; access args
        mov     bp,sp
        push    es
        les     ax,[bp+ARGOFF]          ; stick daddr in memory
        cli
        mov     daddr,ax
        mov     daddr+2,es
        mov     ax,[bp+ARGOFF+4]        ; stick dwidth in memory
        add     ax,ax
        mov     dwidth,ax

        mov     ax,DULY0
        mul     dwidth
        add     ax,DULX0*2
        add     ax,daddr
        mov     d0ptr,ax
        sti

        pop     es
        pop     bp
        ret
        end_proc

; wcoord(wnum,ulx,uly);         set base/tank window coordinates
        proc_def wcoord
        push    bp                      ; access args
        mov     bp,sp
        mov     bx,[bp+ARGOFF]          ; form window index
        add     bx,bx
        mov     ax,[bp+ARGOFF+2]        ; x equal -1?
        cmp     ax,-1
        je      wrtcor                  ; yes
        mov     ax,[bp+ARGOFF+4]        ; compute offset
        mul     fwidth
        add     ax,[bp+ARGOFF+2]
        add     ax,[bp+ARGOFF+2]
        add     ax,faddr
wrtcor: mov     s0ptr[bx],ax            ; set window source offset
wcoret: pop     bp
        ret
        end_proc

; showin();                     refresh tank and base windows to crt
        proc_def showin
        push    bp                      ; save regs
        push    si
        push    di
        push    es
        pushf

        mov     si,s0ptr                ; base
        mov     di,d0ptr
        mov     cx,BASWID
        mov     dx,BASHGT
        call    up1win

        popf
        pop     es
        pop     di
        pop     si
        pop     bp
        ret
        end_proc


; seebas(sfsizx,sfsizy,sfcrtx,sfcrty) set seefld() size and CRT base coords
        proc_def seebas
        push    bp                      ; access args
        mov     bp,sp
        mov     ax,[bp+ARGOFF]          ; store sizes for future reference
        mov     sfsizx,ax
        mov     ax,[bp+ARGOFF+2]
        mov     sfsizy,ax

        mov     ax,[bp+ARGOFF+6]        ; pre-compute destination offset
        mul     dwidth
        add     ax,[bp+ARGOFF+4]
        add     ax,[bp+ARGOFF+4]
        add     ax,daddr
        mov     dsfptr,ax

        pop     bp
        ret
        end_proc

; seefld(ulx,uly);              one-shot display of playfield to screen
        proc_def seefld
        push    bp                      ; access args
        mov     bp,sp
        push    si                      ; save regs
        push    di
        push    es
        pushf

        mov     ax,[bp+ARGOFF+2]        ; compute offset
        mul     fwidth
        add     ax,[bp+ARGOFF]
        add     ax,[bp+ARGOFF]
        add     ax,faddr

        mov     si,ax                   ; set window source offset
        mov     di,dsfptr               ; recall display dest offset
        mov     cx,sfsizx               ; set x window size
        mov     dx,sfsizy               ; set y window size
        call    up1win                  ; update window (re-entrant!)

        popf
        pop     es
        pop     di
        pop     si
        pop     bp
        ret
        end_proc

        endps

        end

;dweeb   proc    near                   ; this routine badly screws up
;        mov     dx,fstick              ; keyboard input!
;        add     dx,10
;        mov     si,400
;        mov     bx,500
;
;dwmore: cli
;        in      al,61H                  ; turn on speaker
;        or      al,3
;        out     61H,al
;        sti
;
;        mov     ax,si
;        sub     ax,6
;        and     ax,1023
;        add     ax,2048
;        mov     si,ax
;        add     bx,6
;
;        cli
;        out     42H,al
;        mov     al,ah
;        out     42H,al
;        sti
;        mov     cx,bx
;dwloop: loop    dwloop
;        cli
;        in      al,61H                  ; turn off speaker
;        and     al,0FFH-2
;        out     61H,al
;        sti
;        mov     cx,bx
;d2loop: loop    d2loop
;        cmp     dx,fstick
;        jne     dwmore
;        cli
;        cmp     rtvec,offset nada
;        je      dwbret
;        in      al,61H                  ; turn on speaker
;        or      al,3
;        out     61H,al
;dwbret: sti
;        ret
;dweeb   endp
;
