/*
     Flash Maze, Version 1.1

     FMKICK.C
     This is the Flash Maze real-time kicktable handler, which invokes a
     subroutine a specified number "ticks" (calls to prcrtk()) from the
     present time.

     by Scott J. Brinker and Chris Robert (and TJS)         3/24/90

     Copyright (c) 1992 Galactic Innovations, Inc.     All rights reserved.

     NOTE:  This code was developed using the "Flash Attack" sources,
            under license from Galacticomm, Inc.
*/

#define KTSIZE 200                 /* kicktable size                       */

struct kook {                      /* kicktable entry layout               */
     int countr;                   /*   number of intervals yet to go      */
     int (*dest)();                /*   subroutine address to invoke       */
     long parm1;                   /*   parm 1 to pass when kicking off    */
     long parm2;                   /*   parm 2 to pass when kicking off    */
     long parm3;                   /*   parm 3 to pass when kicking off    */
} kcktbl[KTSIZE],*kckptr;

inirtk()                           /* initialize real-time kicktable       */
{
     int i;

     for (i=0,kckptr=kcktbl ; i < KTSIZE ; i++,kckptr++) {
          kckptr->countr=0;
     }
}

rtkick(delay,dstrou,p1,p2,p3)      /* real-time kicktable handler          */
int delay;
int (*dstrou)();
long p1,p2,p3;
{
     int i;
     struct kook *sptr;

     for (i=0,sptr=kcktbl+KTSIZE-1 ; i < KTSIZE ; i++,sptr--) {
          if (sptr->countr == 0) {
               sptr->countr=delay;
               sptr->dest=dstrou;
               sptr->parm1=p1;
               sptr->parm2=p2;
               sptr->parm3=p3;
               return;
          }
     }
     catastro("RTKICK: KCKTBL OVERFLOW");
}

prcrtk()                           /* call an rtkick's specified routine   */
{
     int i;

     colorpd();
     for (i=0,kckptr=kcktbl ; i < KTSIZE ; i++,kckptr++) {
          if (kckptr->countr != 0 && --(kckptr->countr) == 0) {
               (*(kckptr->dest))(kckptr->parm1,kckptr->parm2,kckptr->parm3);
          }
     }
}

