/*
     Flash Maze, Version 1.1

     FMINIT.C
     These are the Flash Maze initialization routines/algorithims.

     by Scott J. Brinker and Chris Robert (and TJS)                3/24/90

     Copyright (c) 1992 Galacticomm, Inc.              All rights reserved.

     NOTE:  This code was developed using the "Flash Attack" sources,
            under license from Galacticomm, Inc.
*/

#include "stdio.h"
#include "ctype.h"
#include "setjmp.h"
#include "dos.h"
#include "dosface.h"
#include "fkcode.h"
#include "portable.h"
#include "fm.h"


char *snames[]={
     "You",
     "Target"
};

extern
long seed;

char *plyscn,                 /* player's screen address                   */
     *pysptr;                 /* pointer to player's screen address        */

#define WALL   219

int y,x;
int *loc;

#define LEFT   x-1,y
#define RIGHT  x+1,y
#define ABOVE  x,y-1
#define BELOW  x,y+1

#define MAXHWL 6
#define MAXVWL 3
#define MAXSPC 2
#define OUTERW 5

init(argc,argv)
int argc;
char *argv[];
{
     static int spckys[]={
          CRSRLF,CRSRRT,CRSRUP,CRSRDN,HOME,END,PGUP,PGDN,'m','p',
          F1,F2,F3,F4,F5,F6,F7,F8,F9,F10,13,8,27,IMINCH,IMINGM,0
     };

     inicom(argc,argv);
     inisnd();
     setspc(spckys);
     maze_array=(int *)alcmem(MAZWID*MAZLEN*sizeof(int));
     bhnd_array=(int *)alcmem(MAZWID*MAZLEN*sizeof(int));
     plyscn=alcmem(4000);
     fldbas(maze_array,MAZWID);
     crtbas(frzseg(),80);
     wcoord(0,0,0);
}

inigam()
{
     int i,j;

     iniscn(SMAZE,pysptr=frzseg());
     locate(0,0);
     seed=rseed;
     inirtk();
     gmdisp=1;
     onscrn=0;
     cdcolor=0;
     makmaz();
     for (i=0 ; i < MAZWID ; i++) {
          for (j=0 ; j < MAZLEN ; j++) {
               *bhnd(i,j)=*maze(i,j);
          }
     }
     if (npyrs == 1) {
          npying=npyrs;
     }
     else {
          npying=npyrs;
     }
     for (i=0 ; i < npying ; i++) {
          setpyr(i);
          pyrp->pinpmo=MAIN;
          pyrp->gamguy=i;
          setgam(i);
          gamp->playno=i;
          gamp->photons=32;
          gamp->zappers=9;
          gamp->drillers=9;
          gamp->bombs=6;
          gamp->cubes=6;
          gamp->stamina=16;
          gamp->status=3;
          updwdw(i);
          gamp->curwep=0;
          gamp->laying=0;
          gamgxy();
     }
     for ( ; i < MAXPYR ; i++) {
          player[i].gamguy=-1;
          gamguys[i].playno=-1;
     }
     setmem(pds,sizeof(struct xyloc)*NUMPDS,0);
     inibom();
     setebc();
     makepp();
     makepp();
     initpd();
     initcd();
     gamovr=0;
}

inibom()
{
     int bombing();

     setmem(bombs,sizeof(struct bomb)*MAXPYR*6,0);
     rtkick(5,bombing);
}

setebc()
{
     static int ex,ey;

     getaxy(&ex,&ey);
     *bhnd(ex,ey)=15+enrbatr[cdcolor];
     *maze(ex,ey)=15+enrbatr[cdcolor];
}

makepp()
{
     static int ppx,ppy;

     getaxy(&ppx,&ppy);
     *bhnd(ppx,ppy)=232+phopatr[cdcolor];
     *maze(ppx,ppy)=232+phopatr[cdcolor];
}

initpd()
{
     static int i;

     for (i=0 ; i < NUMPDS ; i++) {
          if ((*maze(pds[i].x,pds[i].y)&0xFF) == 177) {
               *maze(pds[i].x,pds[i].y)=*bhnd(pds[i].x,pds[i].y)=32+spacatr[cdcolor];
          }
          getaxy(&pds[i].x,&pds[i].y);
          *maze(pds[i].x,pds[i].y)=*bhnd(pds[i].x,pds[i].y)=177+0x1000;
     }
}

chngpd(x,y)
int x,y;
{
     static int i;

     for (i=0 ; i < NUMPDS ; i++) {
          if (pds[i].x == x && pds[i].y == y) {
               getaxy(&pds[i].x,&pds[i].y);
               *maze(pds[i].x,pds[i].y)=*bhnd(pds[i].x,pds[i].y)=177+0x1000;
               break;
          }
     }
}

initcd()
{
     int codown();

     rtkick(CNTDOWN,codown);
}

updwdw(gnum)
int gnum;
{
     static char *pyrsts[]={
          "ZOMBIE",
          "   RED",
          "YELLOW",
          " GREEN",
          "WINNER"
     };
     static int wdwatr[]={
          0x07,
          0x8C,
          0x0E,
          0x0A,
          0x8B
     };

     setatr(wdwatr[gamguys[gnum].status]);
     locate(63,12+gnum);
     printf("%s",solo ? snames[gamguys[gnum].playno] : names[gamguys[gnum].playno]);
     rstloc();
     locate(73,12+gnum);
     printf("%s",pyrsts[gamguys[gnum].status]);
     rstloc();
}

deaden(gnum)
int gnum;
{
     noise(0);
     noise(14);
     gamguys[gnum].status=0;
     updwdw(gnum);
     *maze(gamguys[gnum].x,gamguys[gnum].y)=148+zombatr[cdcolor];
     *bhnd(gamguys[gnum].x,gamguys[gnum].y)=148+zombatr[cdcolor];
     hidecursor();
}

makmaz()
{
     make_maze();
     cvt_maze();
}

make_maze()
{
     int ycnt=0,xcnt=0;
     int walls,i;
     int rndspc=0;
     int *mazptr;

     for (mazptr=maze_array,i=0 ; i < MAZWID*MAZLEN ; i++,mazptr++) {
          *mazptr=32+spacatr[cdcolor];
     }
     for (y=1 ; y < MAZLEN ; y+=2) {
          walls=-1;
          rndspc=MAXSPC;
          for (x=1 ; x < MAZWID-1 ; x++) {
               if (walls == -1) {
                    if (++rndspc < MAXSPC) {
                         continue;
                    }
                    rndspc=0;
                    walls=(rnd()%MAXHWL)+2;       /* +1 */
                    *maze(x,y)=WALL+WALLATR;
               }
               if (walls > 0) {
                    *maze(x,y)=WALL+WALLATR;
               }
               walls--;
          }
     }
     walls=4;
     for  (y=1 ; y < MAZLEN-1 ; y++) {
          for (x=2 ; x < MAZWID-2 ; x+=2) {
               if (walls == 0) {
                    if (*maze(x,y-1) == WALL+WALLATR) {
                         *maze(x,y)=WALL+WALLATR;
                         walls=(rnd()%MAXVWL)+2;
                    }
                    else {
                         continue;
                    }
               }
               walls--;
          }
     }
     for  (y=1 ; y < MAZLEN-1 ; y+=2) {
          if ((rnd()%OUTERW) == 0) {
               *maze(0,y)=196+WALLATR;
          }
          if ((rnd()%OUTERW) == 0) {
               *maze(MAZWID-1,y)=196+WALLATR;
          }
     }
     for  (x=1 ; x < MAZWID-1 ; x++) {
          if ((rnd()%OUTERW) == 0 && xcnt == 0 && *maze(x,1) == WALL+WALLATR) {
               *maze(x,0)=179+WALLATR;
               xcnt=4;
          }
          if ((rnd()%OUTERW) == 0 && ycnt == 0 && *maze(x,MAZLEN-2) == WALL+WALLATR) {
               *maze(x,MAZLEN-1)=179+WALLATR;
               ycnt=4;
          }
          if (ycnt > 0) ycnt--;
          if (xcnt > 0) xcnt--;
     }
     for (y=0 ; y < MAZLEN ; y+=2) {
          for (x=0 ; x < MAZWID-1 ; x++) {
               if (iiswall(x,y)) {
                    if (y !=0 && !iiswall(ABOVE)) {
                         if (iiswall(x-1,y-1) ||
                             iiswall(x+1,y-1)) {
                              *maze(x,y-1)=WALL+WALLATR;
                         }
                    }
                    if (y != MAZLEN-1 && !iiswall(BELOW)) {
                         if (iiswall(x-1,y+1) ||
                             iiswall(x+1,y+1)) {
                              *maze(x,y+1)=WALL+WALLATR;
                         }
                    }
               }
          }
     }
}

cvt_maze()
{
     for (y=1 ; y < MAZLEN-1 ; y++) {
          for (x=1 ; x < MAZWID-1 ; x++) {
               if (*(loc=maze(x,y)) == WALL+WALLATR) {
                    if ((y%2) != 0) {
                         if (iiswall(ABOVE)) {
                              chkabo();
                         }
                         else if (iiswall(BELOW)) {
                              chkbel();
                         }
                         else if (iiswall(LEFT)) {
                              *loc=196+WALLATR;
                         }
                         else if (iiswall(RIGHT)) {
                              *loc=196+WALLATR;
                         }
                         else {
                              *loc=196+WALLATR;
                         }
                    }
                    else {
                         *loc=179+WALLATR;
                    }
               }
          }
     }
}

chkabo()
{
     if (iiswall(BELOW)) {
          if (iiswall(LEFT)) {
               if (iiswall(RIGHT)) {
                    *loc=197+WALLATR;
               }
               else {
                    *loc=180+WALLATR;
               }
          }
          else if (iiswall(RIGHT)) {
               *loc=195+WALLATR;
          }
          else {
               *loc=179+WALLATR;
          }
     }
     else if (iiswall(LEFT)) {
          if (iiswall(RIGHT)) {
               *loc=193+WALLATR;
          }
          else {
               *loc=217+WALLATR;
          }
     }
     else if (iiswall(RIGHT)) {
          *loc=192+WALLATR;
     }
     else {
          *loc=179+WALLATR;
     }
}

chkbel()
{
     if (iiswall(LEFT)) {
          if (iiswall(RIGHT)) {
               *loc=194+WALLATR;
          }
          else {
               *loc=191+WALLATR;
          }
     }
     else if (iiswall(RIGHT)) {
          *loc=218+WALLATR;
     }
     else {
          *loc=179+WALLATR;
     }
}

iiswall(xa,ya)
int xa,ya;
{
     if (((*maze(xa,ya))&0xFF) == 32) {
          return(0);
     }
     return(1);
}

iswall(xa,ya)
int xa,ya;
{
     if (((*bhnd(xa,ya))&0xFF) == 32 && !isbomb(xa,ya)) {
          return(0);
     }
     return(1);
}

isrwall(xa,ya)
int xa,ya;
{
     switch (*bhnd(xa,ya)) {
     case WALL+WALLATR:
     case 179+WALLATR:
     case 218+WALLATR:
     case 196+WALLATR:
     case 197+WALLATR:
     case 195+WALLATR:
     case 192+WALLATR:
     case 194+WALLATR:
     case 193+WALLATR:
     case 217+WALLATR:
     case 180+WALLATR:
     case 176+WALLATR:
     case 191+WALLATR:
          return(1);
     }
     return(0);
}

gamgxy()
{
     getaxy(&gamp->x,&gamp->y);
     plcgmg(gamn,gamp->x,gamp->y);
}

getaxy(getx,gety)
int *getx,*gety;
{
     static int tryx,tryy;

     do {
          tryx=rnd()%MAZWID;
          tryy=rnd()%MAZLEN;
     } while (iswall(tryx,tryy));
     *getx=tryx;
     *gety=tryy;
}

iniscn(scnnum,where)               /* initialize a screen from screen image */
int scnnum;
char *where;
{
     movmem(scntbl+scnnum*4000,where,4000);
}

setpyr(pn)
int pn;
{
     pyrn=pn;
     pyrp=&player[pyrn];
}

setgam(pn)
int pn;
{
     if (pn != -1) {
          gamn=pn;
          gamp=&gamguys[gamn];
     }
}

