/*
     Flash Maze, Version 1.1

     FMCOMM.C
     This is the Flash Maze communications interface.

     by Scott J. Brinker and Chris Robert (and TJS)    3/24/90

     Copyright (c) 1992 Galacticomm, Inc.              All rights reserved.

     NOTE:  This code was developed using the "Flash Attack" sources,
            under license from Galacticomm, Inc.
*/

#include "stdio.h"
#include "ctype.h"
#include "dos.h"
#include "dosface.h"
#include "fkcode.h"
#include "portable.h"
#include "fm.h"

#define OKDSIZ  512           /* size of "ok data buffer"                  */
#define OKMASK  (OKDSIZ-1)

char copyright[28]={"Copyright (c) 1990 Galactic "},
          mask1[9]={"Innovatio"},
          mask2[9]={"ns, Inc. "},
         reg_no[9]={"*REGNKEY*"};

char okdata[OKDSIZ];          /* circular-buffer array of "ok data"        */

int indact,                   /* shadow "ok data buffer" ahead counter     */
    okdact,                   /* "ok data buffer" ahead counter            */
    okdbct;                   /* "ok data buffer" behind counter           */

int naknum,
    w4nact;

int solo=0;                   /* are we in solo mode?  1=Yes  0=No         */
int offline=0;

int debug=0;                  /* are we in debug mode?  1=Yes  0=No        */

#define EXPHDR    1           /*   expecting block header                  */
#define EXPBDY    2           /*   expecting block body                    */
#define XPHNKA    3           /*   expecting block header NAK ACK          */
#define XPBNKA    4           /*   expecting block body NAK ACK            */

int spcls[32]={               /* array of "special keys" for Flash protocol*/
     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     -1,                /* NAK */
     0,0,
     -1,                /* CAN */
     0,0,0,0,0,0,0
};

char *rcvrno;
char junk_ahead[11]={"10002499103"},
     mask1_regno[9]={"*ENC1KEY*"},
 junk_inbetween[11]={"84205569000"},
     mask2_regno[9]={"*ENC2KEY*"},
    junk_behind[11]={"2478123040"};


static
char lupbuf[120],             /* line-up character buffer                  */
     *lupptr;                 /* pointer into line-up buffer               */

static
int escdpn=-1;

int onoff=1;                  /* keep sound turned on?  1=Yes  0=No        */

inicom(argc,argv)
int argc;
char *argv[];
{
     static char *ptnams[]={
          "1","com1","2","com2","3","com3","4","com4","solo",""
     };
     static char chrbuf[20];
     int x,i;
     char *chrp;

     if (argc > 1) {
          strncpy(chrbuf,argv[1],sizeof(chrbuf)-1);
          if (argc == 3) {
               debug=1;
          }
     }
     while (1) {
          for (chrp=chrbuf ; *chrp != '\0' ; chrp++) {
               if (isalnum(*chrp)) {
                    *chrp=tolower(*chrp);
               }
               else {
                    *chrp='\0';
                    break;
               }
          }
          if ((x=tblidx(chrbuf,ptnams)) >= 0) {
               break;
          }
          if (chrbuf[0] == '\0') {
               printf("\nYou need to specify a port for communications,\n");
               printf("or indicate that there will be no communications\n");
               printf("by typing the word SOLO.\n");
          }
          else {
               printf("\nPlease enter a number 1 through 4, or type\n");
               printf("the word \"SOLO\" (without the quotes).\n");
          }
          printf("\n  1. COM1\n  2. COM2\n  3. COM3\n  4. COM4\n");
          printf("\nPlease select one of the above, or SOLO: ");
          if (fgets(chrbuf,sizeof(chrbuf),stdin) == NULL) {
               exit();
          }
     }
     switch (x) {
     case 0:
     case 1:                       /* COM1   */
          iniser(0,0x3F8,4);
          break;
     case 2:
     case 3:                       /* COM2   */
          iniser(0,0x2F8,3);
          break;
     case 4:
     case 5:                       /* COM3   */
          iniser(0,0x3E8,4);
          break;
     case 6:
     case 7:                       /* COM4   */
          iniser(0,0x2E8,3);
          break;
     case 8:                       /* SOLO mode   */
          solo=1;
          offline=1;
          npyrs=1;
          rseed=now();
     }
}

parsln()
{
     char *inpptr,*stg;
     int i,j;

     npyrs=0;
     inpptr=lupbuf-1;
     while (1) {
          while (*++inpptr == ' ') {
          }
          if (npyrs >= MAXPYR+2) {
               catastro("TOO MANY PLAYERS!");
          }
          if (*inpptr == '*') {
               inpptr+=1;
          }
          names[npyrs++]=inpptr;
          while (*++inpptr != ' ') {
               if (*inpptr == '\0') {
                    if (*names[npyrs-1] == '#') {
                         --npyrs;
                         if (self == -1) {
                              rcvrno=names[npyrs];
                              rcvrno++;
                              for (i=0,stg=rcvrno ; i < 9 ; i++,stg++) {
                                   if (reg_no[0] == '9') {
                                        j=i+1;
                                   }
                                   else {
                                        j=i;
                                   }
                              }
                         }
                    }
                    rseed=atoi(names[--npyrs]);   /* rseed set to now()    */
                    return;
               }
          }
          *inpptr='\0';
     }
}

tblidx(stg,stgtbl)
char *stg;
char *stgtbl[];
{
     int i;

     for (i=0 ; *stgtbl[i] != '\0' ; i++) {
          if (strcmp(stg,stgtbl[i]) == 0) {
               return(i);
          }
     }
     return(-1);
}

setspc(sparr)
int *sparr;
{
     int n;

     for (n=0 ; *sparr != 0 && n < sizeof(spcls)/sizeof(int) ; n++) {
          if (spcls[n] >= 0) {
               spcls[n]=*sparr++;
          }
     }
}

prcrin()
{
     int c;
     static int comstt=EXPHDR;
     static int crc3,pakctr,pakcrc,paklen;
     static char pakbuf[15];

     if (!offline) {
          while ((c=rdser(0)) != EOF) {
               fstick=0;
               switch (comstt) {
               case EXPHDR:
                    if (c != odd(c) && (paklen=(c&15)) != 0) {
                         crc3=(c&0x70);
                         pakctr=0;
                         pakcrc=0;
                         comstt=EXPBDY;
                    }
                    else {
                         outnak();
                         comstt=XPHNKA;
                    }
                    break;
               case EXPBDY:
                    if (c == odd(c)) {
                         if (pakctr == paklen) {
                              if ((pakcrc&127) == (c&127)
                               && ((pakcrc>>3)&0x70) == crc3) {
                                   if (pakbuf[0] != NAKACK) {
                                        takeok(pakbuf,paklen);
                                        comstt=EXPHDR;
                                   }
                                   else if (pakbuf[1] == naknum) {
                                        indact=naknum<<2;
                                        takeok(pakbuf+2,paklen-2);
                                        comstt=EXPHDR;
                                   }
                                   else {
                                        outnak();
                                        comstt=XPHNKA;
                                   }
                              }
                              else {
                                   outnak();
                                   comstt=XPHNKA;
                              }
                         }
                         else {
                              pakcrc=calcrc(pakcrc,c);
                              pakbuf[pakctr++]=(c&127);
                         }
                    }
                    else {
                         outnak();
                         comstt=XPHNKA;
                    }
                    break;
               case XPHNKA:
                    if (c != odd(c) && (paklen=(c&15)) != 0) {
                         crc3=(c&0x70);
                         pakctr=0;
                         pakcrc=0;
                         comstt=XPBNKA;
                    }
                    break;
               case XPBNKA:
                    if (c == odd(c)) {
                         if (pakctr == paklen) {
                              if ((pakcrc&127) == (c&127)
                               && ((pakcrc>>3)&0x70) == crc3) {
                                   if (pakbuf[0] != NAKACK) {
                                        if (++w4nact == 3) {
                                             outnak();
                                        }
                                        comstt=XPHNKA;
                                   }
                                   else if (pakbuf[1] == naknum) {
                                        indact=naknum<<2;
                                        takeok(pakbuf+2,paklen-2);
                                        comstt=EXPHDR;
                                   }
                                   else {
                                        outnak();
                                        comstt=XPHNKA;
                                   }
                              }
                              else {
                                   comstt=XPHNKA;
                              }
                         }
                         else {
                              pakcrc=calcrc(pakcrc,c);
                              pakbuf[pakctr++]=(c&127);
                         }
                    }
                    else if ((paklen=(c&15)) != 0) {
                         crc3=(c&0x70);
                         pakctr=0;
                         pakcrc=0;
                    }
                    else {
                         comstt=XPHNKA;
                    }
                    break;
               }
          }
          if (fstick >= 150) {
               okdata[okdact]=NODATA;
               okdact=((okdact+1)&OKMASK);
               fstick=0;
          }
     }
}

outnak()
{
     outser(0,NAK);                     /* NAK is odd parity as it stands  */
     outser(0,naknum=(okdact>>2));      /* parity bit on this is ignored   */
     w4nact=0;
}

takeok(buf,len)
char *buf;
int len;
{
     int i;

     for (i=0 ; i < len ; i++) {
          if (indact == okdact) {
               okdata[okdact]=buf[i];
               okdact=((okdact+1)&OKMASK);
               if (okdact == okdbct) {
                    catastro("OKDATA OVERFLOW");
               }
          }
          indact=((indact+1)&OKMASK);
     }
}

clreci()
{
     okdbct=okdact=indact=0;
     escdpn=-1;
     lupptr=NULL;
}

/* the following for debug only!! */

FILE *fp;
ecinp()
{
     int c;
     char *sp,buf[10];
     static int nonline;

     if (!debug) {
          return(tecinp());
     }
     if (fp == NULL) {
          fp=fopen("fadebug.txt",FOPWA);
     }
     switch (c=tecinp()) {
     case -1:
          break;
     case -TICK:
          if (++nonline == 80) {
               fprintf(fp,"\n");
               nonline=0;
          }
          fprintf(fp,"T");
          break;
     case -REMOVE:
          fprintf(fp,"\nREMOVE");
          nonline=0;
          break;
     case -NODATA:
          fprintf(fp,"\nNODATA\n");
          nonline=0;
          break;
     case -LINEUP:
          fclose(fp);
          fp=fopen("fadebug.txt",FOPWA);
          fprintf(fp,"\nLINEUP \"%s\"\n",lupbuf);
          nonline=0;
          break;
     default:
          switch (c) {
          case CRSRLF:  sp="CRSRLF"; break;
          case CRSRRT:  sp="CRSRRT"; break;
          case CRSRUP:  sp="CRSRUP"; break;
          case CRSRDN:  sp="CRSRDN"; break;
          case HOME:    sp="HOME"; break;
          case END:     sp="END"; break;
          case PGUP:    sp="PGUP"; break;
          case PGDN:    sp="PGDN"; break;
          case F1:      sp="F1"; break;
          case F2:      sp="F2"; break;
          case F3:      sp="F3"; break;
          case F4:      sp="F4"; break;
          case F5:      sp="F5"; break;
          case F6:      sp="F6"; break;
          case F7:      sp="F7"; break;
          case F8:      sp="F8"; break;
          case F9:      sp="F9"; break;
          case F10:     sp="F10"; break;
          default:
               if (c < 32) {
                    sprintf(buf,"0x%02x",c);
               }
               else {
                    buf[0]=c;
                    buf[1]='\0';
               }
               sp=buf;
          }
          fprintf(fp,"\nP%d:%s\n",pyrn,sp);
          nonline=0;
          if (pyrn >= npyrs || pyrn >= MAXPYR) {
               catastro("PYRN IS %d!  UPLOAD FADEBUG.TXT TO DEMO SYSTEM!",pyrn);
          }
     }
     return(c);
}

putdbg(num)
int num;
{
     if (debug) {
          fprintf(fp,"(%d)\n",num);
     }
}

/* to remove debug stuff, zap the above and set the following to ecinp() */

tecinp()
{
     int c;

     prcrin();
     if (okdbct != okdact) {
          c=okdata[okdbct];
          okdbct=((okdbct+1)&OKMASK);
          if (escdpn >= 0) {
               pyrn=escdpn;
               escdpn=-1;
          }
          else if (lupptr != NULL) {
               if (c == LINEUP) {
                    *lupptr='\0';
                    lupptr=NULL;
                    return(-c);
               }
               *lupptr++=c;
               if (lupptr-lupbuf >= sizeof(lupbuf)-1) {
                    catastro("LINEUP TOO LONG: %s",lupbuf);
               }
               return(-1);
          }
          else if (c < 110) {
               pyrn=c%10;
               c/=10;
          }
          else if (c < 120) {
               if (okdbct != okdact) {
                    pyrn=c-110;
                    c=okdata[okdbct];
                    okdbct=((okdbct+1)&OKMASK);
               }
               else {
                    escdpn=c-110;
                    return(-1);
               }
          }
          else if (c == LINEUP) {
               lupptr=lupbuf;
               return(-1);
          }
          else if (c == REMOVE) {
               if (okdbct == okdact) {
                    okdbct=((okdbct-1)&OKMASK);
                    return(-1);
               }
               else {
                    escdpn=1;
                    return(-REMOVE);
               }
          }
          else {
               return(-c);
          }
     }
     else {
          return(-1);
     }
     if (c < sizeof(spcls)/sizeof(int)) {
          c=spcls[c];
     }
     return(c);
}

ecoutp(c)
int c;
{
     int i,*sp;

     for (i=0,sp=spcls ; i < sizeof(spcls)/sizeof(int) ; i++,sp++) {
          if (c == *sp) {
               eco(i);
               return;
          }
          if (*sp == 0) {
               break;
          }
     }
     if (c <= 127 && c >= 32) {
          eco(c);
     }
     else if (c == 0x2F00) {       /* alt-V */
          noilvl(onoff^=1);
     }
}

eco(c)
char c;
{
     static char pair[2]={110,0};

     if (offline) {
          pair[1]=c;
          takeok(pair,2);
     }
     else {
          outser(0,odd(c));
     }
}

static
uhoh()
{
     lvpool();
     lvpool();
     finser(0);
     finsnd();
}


