/*
     Flash Maze, Version 1.1

     FMCHAT.C
     This is the Flash Maze pre- and post-game chat handler.

     by Scott J. Brinker and Chris Robert (and TJS)    3/24/90

     Copyright (c) 1992 Galacticomm, Inc.              All rights reserved.

     NOTE:  This code was developed using the "Flash Attack" sources,
            under license from Galacticomm, Inc.
*/

#include "stdio.h"
#include "ctype.h"
#include "dos.h"
#include "dosface.h"
#include "fkcode.h"
#include "portable.h"
#include "fm.h"

int begin;
int gotimi;
int trmscx,trmscy;
char trmscn[4000];

int ylocs[MAXPYR]={
     15,15,
     18,18,
     21,21
};

shocha()
{
     int i;

     setwin(0L,0,0,79,24,1);
     iniscn(SFMCHAT,frzseg());
     setatr(0x70);
     for (i=0 ; i < npyrs ; i++) {
          loccwl(i);
          printf(" %s ",names[i]);
          player[i].chawin[CHWSIZ*2-1]=0x0F;
          dspchw(i);
     }
     i=player[self].chapos;
     locate((i&1) ? 78 : 37,ylocs[i]);
}

loccwl(pyrn)
int pyrn;
{
     int j;

     j=player[pyrn].chapos;
     locate((j&1) ? 43 : 2,ylocs[j]-1);
}

dwchat()
{
     int c;

     inirtk();
     begin=0;
     while (!begin) {
          if (kbhit()) {
               ecoutp(getchc());
          }
          switch (c=ecinp()) {
          case -1:
               break;
          case -TICK:
               rseed+=1;
               prcrtk();
               break;
          case -REMOVE:
               pyrn=ecinp()-'0';
               if (onscrn) {
                    player[pyrn].pinpmo=INCHAT;
                    setmem(player[pyrn].chawin,CHWSIZ*2,0);
                    if ((player[self].pinpmo == RDY2GO) || (player[self].pinpmo == INCHAT)) {
                         dspchw(pyrn);
                         loccwl(pyrn);
                         setatr(0x0D);
                         printf("\315\315\315\315\315\315\315\315\315\315\315\315");
                         rstloc();
                    }
               }
               if (--npyrs != pyrn) {
                    movmem(&player[npyrs],&player[pyrn],sizeof(struct player));
                    names[pyrn]=names[npyrs];
                    if (self == npyrs) {
                         self=pyrn;
                    }
               }
               clardy();
               break;
          case -LINEUP:
               linem();
               if (player[self].pinpmo >= MAIN) {
                    outimi(IMINGM);
               }
               break;
          case -NODATA:
               lvpool();
               outser(0,'\r');
               termnl("\n*** LOST CONTACT ***\n");
               inirtk();
               shocha();
               break;
          default:
               setpyr(pyrn);
               if (!chkimi(c)) {
                    dwcchr(c);
               }
          }
     }
}

outimi(code)
int code;
{
     gotimi=0;
     sptimi(code);
}

sptimi(code)
int code;
{
     if (!gotimi) {
          ecoutp(code);
          rtkick(9,sptimi,code);
     }
}

chkimi(c)
int c;
{
     if (c == IMINGM) {
          if (pyrn == self) {
               gotimi=1;
          }
          else if (pyrp->pinpmo < MAIN) {
               pyrp->pinpmo=MAIN;
               if ((player[self].pinpmo == RDY2GO) || (player[self].pinpmo == INCHAT)) {
                    dspchw(pyrn);
               }
          }
     }
     else if (c == IMINCH) {
          if (pyrn == self) {
               gotimi=1;
          }
          else if (pyrp->pinpmo >= MAIN) {
               pyrp->pinpmo=INCHAT;
               if ((player[self].pinpmo == RDY2GO) || (player[self].pinpmo == INCHAT)) {
                    dspchw(pyrn);
               }
          }
     }
     else {
          return(0);
     }
     return(1);
}

linem()
{
     int i,j;

     for (i=0 ; i < npyrs ; i++) {
          for (j=0 ; j < npyrs ; j++) {
               if (player[j].chapos == i) {
                    break;
               }
          }
          if (j == npyrs) {
               break;
          }
     }
     parsln();
     setmem(pyrp=&player[npyrs-1],sizeof(struct player),0);
     pyrn=npyrs-1;
     pyrp->pinpmo=INCHAT;
     pyrp->chapos=i;
     if (onscrn) {
          loccwl(npyrs-1);
          setatr(0x70);
          printf(" %s ",names[npyrs-1]);
          rstloc();
     }
     clardy();
}

dwcchr(c)
int c;
{
     if (player[self].pinpmo >= MAIN) {
          disp=((pyrn == self) && gmdisp);
     }
     else {
          disp=((pyrn == self) && onscrn);
     }
     switch (pyrp->pinpmo) {
     case MAIN:
          break;
     case WT4ESC:
          if (c != 27 && c != F7) {
               break;
          }
          if (pyrp->pinpmo >= MAIN) {
               pyrp->pinpmo=INCHAT;
          }
          if (pyrn == self) {
               outimi(IMINCH);
               onscrn=1;
               solo=gmdisp=0;
               shocha();
          }
          else {
               dspchw(pyrn);
          }
          break;
     case HLPSCN:
          pyrp->pinpmo=INCHAT;
          if (pyrn == self) {
               onscrn=1;
               shocha();
          }
          if (c == F7) {
               chachr(c);
          }
          break;
     case RDY2GO:
          pyrp->pinpmo=INCHAT;
          if ((player[self].pinpmo == RDY2GO) || (player[self].pinpmo == INCHAT)) {
               dspchw(pyrn);
          }
          if (c != F7) {
               chachr(c);
          }
          break;
     case INCHAT:
          chachr(c);
          break;
     default:
          catastro("PLAYER %d INPUT MODE %d",pyrn,pyrp->pinpmo);
     }
}

chachr(c)
int c;
{
     switch (c) {
     case F1:
          pyrp->pinpmo=HLPSCN;
          if (disp) {
               iniscn(SFMHELPC,frzseg());
               onscrn=0;
               locate(0,0);
          }
          break;
     case F7:
          pyrp->pinpmo=RDY2GO;
          if ((player[self].pinpmo == RDY2GO) || (player[self].pinpmo == INCHAT)) {
               dspchw(pyrn);
          }
          begin=ok2bgn();
          break;
     case F9:
          if (disp) {
               lvpool();
               lvpool();
               termnl("\n*** HIT F9 TO RETURN TO FLASH MAZE V1.1 ***\n");
               inirtk();
               shocha();
          }
          break;
     case F10:
          if (disp) {
               rstscn();
               finfm();
          }
          break;
     default:
          if ((c&0xFF00) == 0) {
               if (c == 8 || c == 127) {
                    movmem(pyrp->chawin,
                           pyrp->chawin+2,(CHWSIZ-1)*2);
                    pyrp->chawin[0]=0;
               }
               else {
                    movmem(pyrp->chawin+2,
                           pyrp->chawin,(CHWSIZ-1)*2);
                    pyrp->chawin[CHWSIZ*2-2]=(c == '\r' ? 17 : c);
                    pyrp->chawin[CHWSIZ*2-1]=0x0F;
               }
               if ((player[self].pinpmo == RDY2GO) || (player[self].pinpmo == INCHAT)) {
                    dspchw(pyrn);
                    noise(13);
               }
          }
     }
}

clardy()
{
     int i;

     for (i=0,pyrp=player ; i < npyrs ; i++,pyrp++) {
          if (pyrp->pinpmo == RDY2GO) {
               pyrp->pinpmo=INCHAT;
               if ((player[self].pinpmo == RDY2GO) || (player[self].pinpmo == INCHAT)) {
                    dspchw(pyrn);
                    noise(13);
               }
          }
     }
}

ok2bgn()
{
     int i;

     for (i=0 ; i < npyrs ; i++) {
          if (player[i].pinpmo != RDY2GO) {
               return(0);
          }
     }
     return(1);
}

dspchw(pyrn)
int pyrn;
{
     int j;
     char *src;
     static char rdystg[CHWSIZ*2]={
          32,0x20,32,0x20,32,0x20,32,0x20,32,0x20,32,0x20,
          32,0x20,32,0x20,32,0x20,32,0x20,32,0x20,32,0x20,
          'R',0x20,'E',0x20,'A',0x20,'D',0x20,'Y',0x20,' ',0x20,
          'T',0x20,'O',0x20,' ',0x20,'P',0x20,'L',0x20,'A',0x20,
          'Y',0x20,
          32,0x20,32,0x20,32,0x20,32,0x20,32,0x20,32,0x20,
          32,0x20,32,0x20,32,0x20,32,0x20,32,0x20,32,0x20
     };
     static char pngstg[CHWSIZ*2]={
          32,0x40,32,0x40,32,0x40,32,0x40,32,0x40,32,0x40,
          'N',0x40,'O',0x40,'W',0x40,' ',0x40,'P',0x40,'L',0x40,
          'A',0x40,'Y',0x40,'I',0x40,'N',0x40,'G',0x40,' ',0x40,
           4 ,0x40,' ',0x40,'P',0x40,'L',0x40,'E',0x40,'A',0x40,
          'S',0x40,'E',0x40,' ',0x40,'W',0x40,'A',0x40,'I',0x40,
          'T',0x40,
          32,0x40,32,0x40,32,0x40,32,0x40,32,0x40,32,0x40
     };

     if (onscrn) {
          j=player[pyrn].chapos;
          switch (player[pyrn].pinpmo) {
          case RDY2GO:
               src=rdystg;
               break;
          case MAIN:
          case PLYHLP:
          case WT4ESC:
               src=pngstg;
               break;
          default:
               src=player[pyrn].chawin;
          }
          movmem(src,scrnad((j&1) ? 42 : 1,ylocs[j]),CHWSIZ*2);
     }
}

lvpool()
{
     outser(0,CAN);
     outser(0,CAN);
     outser(0,CAN);
     for (fstick=0 ; fstick < 12 ; ) {
     }
}

termnl(stg)
char *stg;
{
     int i,c;
     static char ansiid[]={"\33[6n"};
     char *ansptr;

     if (trmscn[0] != 0) {
          rstscn();
     }
     locate(0,0);
     setatr(0x0E);
     printf("(");
     setatr(0x0F);
     printf(" FLASH MAZE ");
     setatr(0x0E);
     printf(")");
     setatr(0x0C);
     printf("    Copyright 1990 Galactic Innovations, Inc. \4 F1=HELP \4 F9=CHAT \4 F10=EXIT    ");
     setatr(0x0E);
     printf("");
     printf("");
     rstloc();
     setatr(0x0A);
     setwin(0L,0,3,79,24,1);
     printf(stg);
     ansptr=ansiid;
     self=-1;
     while (1) {
          while ((c=rdser(0)) != '\0') {
               if (c != -1) {
                    if (c == 7) {
                         noise(1);
                    }
                    else if (c == *ansptr) {
                         printf("%c",c);
                         if (*++ansptr == '\0') {
                              outser(0,'R');
                              ansptr=ansiid;
                         }
                    }
                    else {
                         ansptr=ansiid;
                         printf("%c",c);
                    }
               }
               if (kbhit()) {
                    switch (c=getchc()) {
                    case F1:
                         savscn();
                         iniscn(SFMHELPT,frzseg());
                         locate(0,0);
                         getchc();
                         rstscn();
                         break;
                    case F9:
                         printf("\n... Attempting to enter Flash Maze ...\n");
                         flashm();
                         break;
                    case F10:
                         finfm();
                         break;
                    default:
                         if (c >= 0 && c <= 127) {
                              outser(0,c);
                         }
                    }
               }
          }
          for (i=0 ; i < 5 ; i++) {
               while ((c=rdser(0)) == EOF) {
               }
               if (c != '\0') {
                    break;
               }
          }
          fstick=0;
          clreci();
          while ((c=ecinp()) == -1) {
               if (kbhit()) {
                    break;
               }
          }
          if (c == -LINEUP) {
               break;
          }
          printf("\n*** NO INITIAL LINEUP ***\n");
     }
     parsln();
     for (i=0 ; i < npyrs ; i++) {
          setmem(pyrp=&player[i],sizeof(struct player),0);
          pyrp->pinpmo=INCHAT;
          pyrp->chapos=i;
     }
     self=npyrs-1;
     printf("\n... Entering Flash Maze ...\n");
     savscn();
}

savscn()
{
     movmem(frzseg(),trmscn,4000);
     trmscx=curcurx();
     trmscy=curcury();
}

rstscn()
{
     movmem(trmscn,frzseg(),4000);
     locate(trmscx,trmscy);
}

static
char idstg1[18]={"\bFlash Maze V1.1 #"},
     idstg2[9]={"*REGNKEY*"},
     idstg3[50]={" Flash Protocol Copyright 1989 Galacticomm, Inc.\r"};

flashm()
{
     char *sptr;
     int c;

     for (sptr=idstg1 ; *sptr != '\0' ; sptr++) {
          outser(0,*sptr);
          for (fstick=0 ; fstick < 3 ; ) {   /* fstick auto-incs at 145.6 Hz */
               if ((c=rdser(0)) == *sptr) {
                    break;
               }
               if (c == '\0') {
                    return;
               }
          }
     }
}

pstgam()
{
     for (pyrn=0,pyrp=player ; pyrn < npyrs ; pyrn++,pyrp++) {
          if (pyrp->pinpmo >= MAIN) {
               if (pyrp->pinpmo == PLYHLP) {
                    xpyhlp();
               }
               pyrp->pinpmo=WT4ESC;
          }
     }
     locate(11,0);
     setatr(0x8F);
     printf("\20\20\20");
     setatr(0x0F);
     printf("    Game Over, Hit ESC to Chat    ");
     setatr(0x8F);
     printf("\21\21\21");
     locate(0,0);
}

