/*
     Flash Maze, Version 1.1

     FM.C
     This is the Flash Maze mainline.

     by Scott J. Brinker and Chris Robert (and TJS)                3/24/90

     Copyright (c) 1992 Galacticomm, Inc.              All rights reserved.

     NOTE:  This code was developed using the "Flash Attack" sources,
            under license from Galacticomm, Inc.
*/

#include "stdio.h"
#include "ctype.h"
#include "setjmp.h"
#include "dos.h"
#include "dosface.h"
#include "fkcode.h"
#include "portable.h"
#include "fm.h"

extern jmp_buf disaster;      /* master error-recovery longjmp save block  */

char *names[MAXPYR+2];
int rseed;
struct player player[MAXPYR];
struct gamguy gamguys[MAXPYR];
struct bomb bombs[MAXPYR][6];
struct xyloc pds[NUMPDS];     /* phase doors (x,y) locations               */
extern
unsigned _stklen=8192;

int gamovr,
    npyrs,
    npying,
    onscrn,
    gmdisp,
    pyrn,
    basn,
    self,
    disp,
    tnkn,
    tnkrow;

int spacatr[5]={0x1F00,0x4F00,0x5F00},
    upyratr[5]={0x1E00,0x4E00,0x5E00},
    opyratr[5]={0x9B00,0xCB00,0xDB00},
     zapatr[5]={0x1C00,0x4900,0x5C00},
    enrbatr[5]={0x1A00,0x4A00,0x5A00},
    zombatr[5]={0x1700,0x4700,0x5700},
    phopatr[5]={0x1C00,0x4F00,0x5C00};

int cdcolor;


int gamn;                     /* current gamguy index                      */
struct player *pyrp;
struct gamguy *gamp;

int *maze_array;
int *bhnd_array;

long seed;

main(argc,argv)                    /* Flash Attack main program loop       */
int argc;
char *argv[];
{
     if (setjmp(ADDR_OFdisaster) != 0) {
          finfm();
     }
     init(argc,argv);
     onscrn=1;
     if ((solo) && (offline)) {
          fstick=0;
          inigam();
          while (!gamovr) {
               dwinp();
               if (fstick > 7) {
                    fstick-=8;
                    prcrtk();
               }
               showin();
          }
          finfm();
     }
     else {
          outser(0,'\r');
          termnl("\14");
          shocha();
          while (1) {
               dwchat();
               inigam();
               while (!gamovr) {
                    dwinp();
                    showin();
               }
               noise(0);
               pstgam();
          }
     }
}

chklft()
{
     static int i;

     if (numlft() <= 1) {
          for (i=0 ; i < npying ; i++) {
               if ((gamguys[i].playno != -1) && (gamguys[i].status)) {
                    gamguys[i].status=4;
                    updwdw(i);
               }
          }
          gamovr++;
          showin();
     }
}

numlft()
{
     int retval=0,i;

     for (i=0 ; i < npying ; i++) {
          if ((gamguys[i].playno != -1) && (gamguys[i].status)) {
               retval++;
          }
     }
     return(retval);
}

dwinp()
{
     int c,rempyr();

     if (kbhit()) {
          ecoutp(getchc());
     }
     switch (c=ecinp()) {
     case -1:
          break;
     case -TICK:
          rseed+=1;
          prcrtk();
          break;
     case -REMOVE:
          setpyr(ecinp()-'0');
          flash_remove();
          break;
     case -NODATA:
          gamovr=1;
          break;
     case -LINEUP:
          outimi(IMINGM);
          linem();
          break;
     default:
          setpyr(pyrn);
          if (!chkimi(c)) {
               if (pyrp->pinpmo < MAIN) {
                    dwcchr(c);
               }
               else {
                    dwgchr(c);
               }
          }
     }
}

flash_remove()
{
     if (pyrp->gamguy != -1 && pyrp->pinpmo >= MAIN) {
          setgam(pyrp->gamguy);
          gamp->playno=-1;
          rempyr();
          setmem(gamp,sizeof(struct gamguy),0);
          gamp->playno=-1;
     }
     if (--npyrs != pyrn) {
          movmem(&player[npyrs],pyrp,sizeof(struct player));
          names[pyrn]=names[npyrs];
          if (self == npyrs) {
               self=pyrn;
          }
     }
}

rempyr()
{
     noise(14);
     *bhnd(gamp->x,gamp->y)=' '+spacatr[cdcolor];
     *maze(gamp->x,gamp->y)=' '+spacatr[cdcolor];
     locate(63,12+gamn);
     printf("         ");
     rstloc();
     locate(73,12+gamn);
     printf("      ");
     rstloc();
     gamp->status=0;
     chklft();
}

dwgchr(c)
int c;
{
     setgam(pyrp->gamguy);
     if (player[self].pinpmo >= MAIN) {
          disp=((pyrn == self) && gmdisp);
     }
     else {
          disp=((pyrn == self) && onscrn);
     }
     if (c == F10 || c == 27) {
          if (pyrp->pinpmo == PLYHLP) {
               xpyhlp();
          }
          else if (disp) {
               finfm();
          }
     }
     else {
          switch (pyrp->pinpmo) {
          case PLYHLP:
               xpyhlp();
               break;
          case MAIN:
               mainky(c);
               break;
          }
     }
}


xpyhlp()
{
     if (pyrn == self) {
          gmdisp=1;
          setwin(0L,0,0,79,24,1);
          pysptr=frzseg();
          movmem(plyscn,pysptr,4000);
          crtbas(pysptr,80);
          pyrp->pinpmo=MAIN;
     }
}

mainky(c)
int c;
{
int brkwll();

     pyrp->pinpmo=MAIN;
     if (disp) {
          hidecursor();
     }
     switch (c) {
     case CRSRUP:
          trymov(0,-1);
          break;
     case CRSRDN:
          trymov(0,1);
          break;
     case CRSRLF:
          trymov(-1,0);
          break;
     case CRSRRT:
          trymov(1,0);
          break;
     case '8':
          trywep(0,-1);
          break;
     case '2':
          trywep(0,1);
          break;
     case '4':
          trywep(-1,0);
          break;
     case '6':
          trywep(1,0);
          break;
     case 13:
          cngwep();
          break;
     case 'C':
     case 'c':
          laycub();
          break;
     case 'B':
     case 'b':
          laybom();
          break;
     case 'S':
     case 's':
          genhit(pyrp->gamguy,16);
          break;
     case F1:
          if (pyrn == self) {
               gmdisp=0;
               pysptr=plyscn;
               movmem(frzseg(),plyscn,4000);
               crtbas(plyscn,80);
               iniscn(SFMHELPG,frzseg());
               setwin(plyscn,0,0,79,24,1);
          }
          pyrp->pinpmo=PLYHLP;
          break;
     }
}

laycub()
{
     if ((gamp->cubes != 0) && (gamp->status)) {
          gamp->cubes--;
          if (disp) {
               setatr(RDOTATR);
               locate(73+gamp->cubes,6);
               printf("\xF9");
               rstloc();
          }
          gamp->laying=176+WALLATR;
     }
}

laybom()
{
     if ((gamp->bombs != 0) && (gamp->status)) {
          gamp->bombs--;
          if (disp) {
               setatr(RDOTATR);
               locate(73+gamp->bombs,4);
               printf("\xF9");
               rstloc();
               gamp->laying=235+spacatr[cdcolor];
          }
          bombs[gamn][gamp->bombs].timer=XPLTIM;
          bombs[gamn][gamp->bombs].x=gamp->x;
          bombs[gamn][gamp->bombs].y=gamp->y;
     }
}

cngwep()
{
     static int pos;
     static int weapons[]={0,3,5};

     pos=gamp->curwep;
     if (disp) {
          setatr(0x70);
          locate(62,weapons[pos]);
          printf(" ");
          rstloc();
     }
     pos=++gamp->curwep;
     if (pos == 3) {
          pos=gamp->curwep=0;
     }
     if (disp) {
          locate(62,weapons[pos]);
          printf("\x10");
          rstloc();
     }
}

trywep(dx,dy)
int dx,dy;
{
     if (gamp->status) {
          switch (gamp->curwep) {
          case 0:
               tryfir(dx,dy);
               break;
          case 1:
               tryzap(dx,dy);
               break;
          case 2:
               trydrl(dx,dy);
               break;
          }
     }
}

brkwll(xd,yd)
int xd,yd;
{
     *maze(xd,yd)=' '+spacatr[cdcolor];
     *bhnd(xd,yd)=' '+spacatr[cdcolor];
}


bombing()
{
     static int i,j;
     int bombing();

     for (i=0 ; i < npying ; i++) {
          if (player[i].pinpmo >= MAIN) {
               gamp=&gamguys[gamn=player[i].gamguy];
               for (j=0 ; j < 6 ; j++) {
                    if ((bombs[i][j].timer) && (!--bombs[i][j].timer)) {
                         blowup(bombs[i][j].x,bombs[i][j].y);
                    }
               }
          }
     }
     rtkick(5,bombing);
}

blowup(x,y)
int x,y;
{
     static int dy,dx,thisx,thisy,curp,curb;

     for (dx=-2 ; dx < 3 ; dx++) {
          for (dy=-1 ; dy < 2 ; dy++) {
               if (!isborder(x,y,dx,dy)) {
                    thisx=x+dx;
                    thisy=y+dy;
                    if (dx < 2 && dx > -2 && dy < 2 && dy > -2) {
                         if (isrwall(thisx,thisy) ||
                            ((*bhnd(thisx,thisy))&0xFF) == 235 ||
                            *bhnd(thisx,thisy) == 208+WALLATR) {
                              *bhnd(thisx,thisy)=32+spacatr[cdcolor];
                              *maze(thisx,thisy)=32+spacatr[cdcolor];
                         }
                         if (isbomb(thisx,thisy,&curp,&curb)) {
                              bombs[curp][curb].timer=0;
                         }
                    }
                    if (isgamg(thisx,thisy,&curp)) {
                         gamguys[curp].laying=0;
                    }
                    explo(thisx,thisy,3,3);
               }
          }
     }
}

codown()
{
     int c,oldcol,codown();
     static int x,y;

     oldcol=cdcolor;
     if (++cdcolor == 3) {
          cdcolor=0;
     }
     for (x=0 ; x < MAZWID ; x++) {
          for (y=0 ; y < MAZLEN ; y++) {
               switch ((c=*maze(x,y))&0xFF) {
               case 148:
                    if (c == 148+opyratr[oldcol]) {
                         *maze(x,y)=148+opyratr[cdcolor];
                    }
                    else if (c == 148+zombatr[oldcol]) {
                         *maze(x,y)=148+zombatr[cdcolor];
                    }
                    else {
                         *maze(x,y)=148+upyratr[cdcolor];
                    }
                    break;
               case 32:
                    *maze(x,y)=32+spacatr[cdcolor];
                    break;
               case 235:
                    *maze(x,y)=235+spacatr[cdcolor];
                    break;
               case 15:
                    *maze(x,y)=15+enrbatr[cdcolor];
                    break;
               case 232:
                    *maze(x,y)=232+phopatr[cdcolor];
                    break;
               }
               switch ((c=*bhnd(x,y))&0xFF) {
               case 148:
                    if (c == 148+opyratr[oldcol]) {
                         *bhnd(x,y)=148+opyratr[cdcolor];
                    }
                    else if (c == 148+zombatr[oldcol]) {
                         *bhnd(x,y)=148+zombatr[cdcolor];
                    }
                    else {
                         *bhnd(x,y)=148+upyratr[cdcolor];
                    }
                    break;
               case 32:
                    *bhnd(x,y)=32+spacatr[cdcolor];
                    break;
               case 235:
                    *bhnd(x,y)=235+spacatr[cdcolor];
                    break;
               case 15:
                    *bhnd(x,y)=15+enrbatr[cdcolor];
                    break;
               case 232:
                    *bhnd(x,y)=232+phopatr[cdcolor];
                    break;
               }
          }
     }
     for (pyrn=0 ; pyrn < npying ; pyrn++) {
          pyrp=&player[pyrn];
          gamp=&gamguys[gamn=pyrp->gamguy];
          switch (gamp->laying&0xFF) {
          case 32:
               gamp->laying=32+spacatr[cdcolor];
               break;
          case 235:
               gamp->laying=235+spacatr[cdcolor];
               break;
          }
          explo(gamp->x,gamp->y,4,CNTHITS);
     }
     initpd();
     rtkick(CNTDOWN,codown);
}

trymov(dx,dy)
int dx,dy;
{
     static int candx,candy,isbomb;

     isbomb=0;
     if ((candx=gamp->x+dx) < 0 || candx >= MAZWID) {
          noise(12);
          return;
     }
     if ((candy=gamp->y+dy) < 0 || candy >= MAZLEN) {
          noise(12);
          return;
     }
     switch (*bhnd(candx,candy)&0xFF) {
     case 177:
          noise(14);
          moveto(candx,candy);
          *bhnd(gamp->x,gamp->y)=32+spacatr[cdcolor];
          *maze(gamp->x,gamp->y)=32+spacatr[cdcolor];
          gamgxy();
          chngpd(candx,candy);
          break;
     case 232:
          grabpp();
          noise(2);
          moveto(candx,candy);
          makepp();
          break;
     case 15:
          grabeb();
          noise(15);
          moveto(candx,candy);
          break;
     case 235:
          isbomb=1;
     case 32:
          noise(11);
          moveto(candx,candy);
          if (isbomb) {
               gamp->laying=235+spacatr[cdcolor];
          }
          break;
     case 148:
          noise(12);
          break;
     case 176:
          noise(15);
          genhit(gamn,1);
     default:
          noise(12);
     }
}

grabpp()
{
     static int phos;

     phos=PPVALUE;
     while (phos-- && gamp->photons != 32) {
          if (disp) {
               setatr(0x0E);
               locate(63+gamp->photons%16,1+gamp->photons/16);
               printf("\xFE");
               rstloc();
          }
          gamp->photons++;
     }
}

grabeb()
{
     static int hits;
     int setebc();

     hits=EBVALUE;
     while (hits-- && gamp->stamina != 16) {
          gamp->stamina++;
          cngwin(gamn);
          if (disp) {
               locate(62+gamp->stamina,9);
               printf("\xFE");
               rstloc();
          }
     }
     rtkick(EBDELAY,setebc);
}

cngwin(guy)
int guy;
{
     struct gamguy *gptr;
     static int atr;

     gptr=&gamguys[guy];
     if (gptr->stamina < 3) {
          atr=0x0C;
          gptr->status=1;
     }
     else if (gptr->stamina < 7) {
          atr=0x0E;
          noise(0);
          gptr->status=2;
     }
     else {
          atr=0x0A;
          gptr->status=3;
     }
     updwdw(guy);
     setatr(atr);
}

trydrl(dx,dy)
int dx,dy;
{
     static int x,y,c;
     int drling();

     if (gamp->drillers != 0) {
          gamp->drillers--;
          if (disp) {
               setatr(RDOTATR);
               locate(63+gamp->drillers,6);
               printf("\xF9");
               rstloc();
          }
          x=gamp->x;
          y=gamp->y;
          if (isborder(x,y,dx,dy)) {
               drldth(32,x,y);
               return;
          }
          x+=dx;
          y+=dy;
          c=(*bhnd(x,y)&0xFF);
          if ((c != 32) && (c != 235) && (!isrwall(x,y))) {
               drldth(c,x,y);
               return;
          }
          *maze(x,y)=47+spacatr[cdcolor];
          rtkick(1,drling,x,y,dx,dy,0);
     }
}

drling(x,y,dx,dy,cnt)
int x,y,dx,dy,cnt;
{
     static int c,lim;
     static int drlarr[]={
          196,                                              /*  */
           47,                                              /* / */
          124,                                              /* | */
           92                                               /* \ */
     };

     if (isrwall(x,y)) {
          *bhnd(x,y)=32+spacatr[cdcolor];
          noise(4);
     }
     *maze(x,y)=*bhnd(x,y);
     lim=(dy == 0 ? 6 : 2);
     if (cnt < (lim*2)) {
          cnt++;
          if (isborder(x,y,dx,dy)) {
               drldth(32,x,y);
               return;
          }
          if (!(cnt%2)) {
               x+=dx;
               y+=dy;
               c=(*bhnd(x,y)&0xFF);
               if ((c != 32) && (c != 235) && (!isrwall(x,y))) {
                    drldth(c,x,y);
                    return;
               }
          }
          *maze(x,y)=drlarr[cnt%4]+spacatr[cdcolor];
          rtkick(1,drling,x,y,dx,dy,cnt);
     }
}

drldth(c,x,y)
int c,x,y;
{
     switch (c) {
     case 32:
          noise(1);
          break;
     case 148:
          explo(x,y,8,3);
          break;
     default:
          break;
     }
}

tryfir(dx,dy)
int dx,dy;
{
     static int x,y,c,lim,i;
     int fired(),firing();

     if (gamp->photons != 0) {
          gamp->photons--;
          if (disp) {
               setatr(RDOTATR);
               locate(63+gamp->photons%16,1+gamp->photons/16);
               printf("\xF9");
               rstloc();
          }
          x=gamp->x;
          y=gamp->y;
          lim=(dy == 0 ? 12 : 6);
          for (i=0 ; i < lim ; i++) {
               if (isborder(x,y,dx,dy)) {
                    fired(x,y,dx,dy);
                    break;
               }
               x+=dx;
               y+=dy;
               c=(*bhnd(x,y)&0xFF);
               if (c != 32 && c != 235) {
                    fired(x,y,dx,dy);
                    break;
               }
               if (!dy) {
                    *maze(x,y)=''+(i%2 ? spacatr[cdcolor]-0x0300 : spacatr[cdcolor]);
               }
               else {
                    *maze(x,y)=''+(i%2 ? spacatr[cdcolor]-0x0300 : spacatr[cdcolor]);
               }
          }
          if (i == lim) {
               fired(x,y,dx,dy);
          }
          rtkick(2,firing,x,y,dx,dy,i);
     }
}

fired(x,y,dx,dy)
int x,y,dx,dy;
{
     if (isrwall(x,y)) {
          explo(x-dx,y-dy,6,1);
     }
     else {
          explo(x,y,6,1);
     }
}

tryzap(dx,dy)
int dx,dy;
{
     static int x,y,c,lim,i;
     int zapped(),firing();

     if (gamp->zappers != 0) {
          gamp->zappers--;
          if (disp) {
               setatr(RDOTATR);
               locate(63+gamp->zappers%9,4);
               printf("\xF9");
               rstloc();
          }
          x=gamp->x;
          y=gamp->y;
          lim=(dy == 0 ? 8 : 4);
          for (i=0 ; i < lim ; i++) {
               if (isborder(x,y,dx,dy)) {
                    break;
               }
               x+=dx;
               y+=dy;
               c=(*bhnd(x,y)&0xFF);
               if (c == 148) {
                    zapped(x,y);
               }
               *maze(x,y)=219+zapatr[cdcolor];
          }
          rtkick(2,firing,x,y,dx,dy,i);
     }
}

zapped(x,y)
int x,y;
{
     static int gn;

     noise(14);
     isgamg(x,y,&gn);
     getaxy(&gamguys[gn].x,&gamguys[gn].y);
     if (gamguys[gn].laying) {
          *maze(x,y)=*bhnd(x,y)=gamguys[gn].laying;
          gamguys[gn].laying=0;
     }
     else {
          *maze(x,y)=*bhnd(x,y)=32+spacatr[cdcolor];
     }
     plcgmg(gn,gamguys[gn].x,gamguys[gn].y);
}

plcgmg(g,x,y)
int g,x,y;
{
     static int atr;

     if (gamguys[g].status) {
          atr=(self == gamguys[g].playno ? upyratr[cdcolor] : opyratr[cdcolor]);
     }
     else {
          atr=zombatr[cdcolor];
     }
     *bhnd(x,y)=*maze(x,y)=148+atr;
}


explo(x,y,ns,hits)
int x,y,ns,hits;
{
     int phtexp();

     switch(*bhnd(x,y)&0xFF) {
     case 148:
          guyhit(x,y,hits);
          rtkick(1,phtexp,x,y,0);
          break;
     default:
          if ((ns) && (ns < 16)) {
               noise(ns);
          }
          rtkick(1,phtexp,x,y,0);
          break;
     }
}

isbomb(x,y,retp,retb)
int x,y,*retp,*retb;
{
     static int i,j;

     for (i=0 ; i < npying ; i++) {
          for (j=0 ; j < 6 ; j++) {
               if (bombs[i][j].timer && bombs[i][j].x == x && bombs[i][j].y == y) {
                    *retp=i;
                    *retb=j;
                    return(1);
               }
          }
     }
     return(0);
}

isgamg(x,y,retp)
int x,y,*retp;
{
     static int i;

     for (i=0 ; i < npying ; i++) {
          if (player[i].pinpmo >= MAIN) {
               if (gamguys[player[i].gamguy].x == x && gamguys[player[i].gamguy].y == y) {
                    *retp=i;
                    return(1);
               }
          }
     }
     return(0);
}

isborder(xp,yp,dx,dy)
int xp,yp;
int dx,dy;
{
     if ((xp+dx) < 0 ||
         (xp+dx) > MAZWID-1 ||
         (yp+dy) < 0 ||
         (yp+dy) > MAZLEN-1) {
          return(1);
     }
     return(0);
}

colorpd()
{
     static int i;
     static int color=0;
     static int colors[16]={
          0x0000,
          0x0100,
          0x0200,
          0x0300,
          0x0400,
          0x0500,
          0x0600,
          0x0700,
          0x0800,
          0x0900,
          0x0A00,
          0x0B00,
          0x0C00,
          0x0D00,
          0x0E00,
          0x0F00
     };

     for (i=0 ; i < NUMPDS ; i++) {
          *maze(pds[i].x,pds[i].y)=*bhnd(pds[i].x,pds[i].y)=177+colors[color];
     }
     if (++color == 16) {
          color=0;
     }
}


firing(fx, fy, dx, dy, cnt)
int fx,fy,dx,dy,cnt;
{
     static int i;

     for (i=0 ; i <= cnt ; i++) {
          *maze(fx,fy)=*bhnd(fx,fy);
          fx-=dx;
          fy-=dy;
     }
}

guyhit(cx,cy,hits)
int cx,cy,hits;
{
     static int i;

     for (i=0 ; i < npying ; i++) {
          if (player[i].pinpmo >= MAIN) {
               if ((gamguys[player[i].gamguy].x == cx) && (gamguys[player[i].gamguy].y == cy)) {
                    genhit(player[i].gamguy,hits);
               }
          }
     }
}

genhit(guy,hits)
int guy,hits;
{
     static struct gamguy *gptr;

     gptr=&gamguys[guy];
     while (hits-- && gptr->stamina != 0) {
          if (guy == self) {
               setatr(RDOTATR);
               locate(62+gptr->stamina,9);
               printf("\xF9");
               rstloc();
          }
          gptr->stamina--;
     }
     if (gptr->stamina == 0) {
          deaden(guy);
          chklft();
     }
     else if (gptr->stamina < 3) {
          if (gptr->playno == self) {
               noise(6);
               noise(10);
          }
          else {
               noise(6);
               noise(7);
          }
          gptr->status=1;
          updwdw(guy);
     }
     else if (gptr->stamina < 7) {
          if (gptr->playno == self) {
               noise(6);
               noise(4);
          }
          else {
               noise(6);
               noise(7);
          }
          gptr->status=2;
          updwdw(guy);
     }
     else if (gptr->playno == self) {
          noise(6);
          noise(4);
     }
     else {
          noise(6);
          noise(7);
     }
}

phtexp(nx,ny,count)
int nx,ny,count;
{
     static char exploc[]={249,254,15,240,178};
     static int expatr[]={0x0F00,0x0E00,0x0C00};

     if (count != sizeof(exploc)) {
          rtkick(1,phtexp,nx,ny,count+1);
     }
     if (count == sizeof(exploc)) {
          *maze(nx,ny)=*bhnd(nx,ny);
     }
     else {
          *maze(nx,ny)=exploc[count]+expatr[count/2];
     }
}

moveto(newx,newy)
int newx,newy;
{
     if (gamp->laying) {
          *maze(gamp->x,gamp->y)=gamp->laying;
          *bhnd(gamp->x,gamp->y)=gamp->laying;
          gamp->laying=0;
     }
     else {
          *maze(gamp->x,gamp->y)=32+spacatr[cdcolor];
          *bhnd(gamp->x,gamp->y)=32+spacatr[cdcolor];
     }
     if (gamp->status) {
          *maze(newx,newy)=148+(self == pyrn ? upyratr[cdcolor] : opyratr[cdcolor]);
          *bhnd(newx,newy)=148+(self == pyrn ? upyratr[cdcolor] : opyratr[cdcolor]);
     }
     else {
          *maze(newx,newy)=148+zombatr[cdcolor];
          *bhnd(newx,newy)=148+zombatr[cdcolor];
     }
     gamp->x=newx;
     gamp->y=newy;
}

rnd()
{
     static int temp;

     seed=seed*33821223L+871L;
     temp=((int)(seed>>16)&32767);
     return(temp);
}

finfm()
{
     if (!solo) {
          lvpool();
          lvpool();
          finser(0);
     }
     noise(0);
     finsnd();
     locate(0,24);
     exit();
}

char *
catfix1()
{
     return("");
}

char *
catfix2()
{
     return("");
}

