/*
     Flash Maze, Version 1.1

     FM.H
     This is the header file for the Flash Maze game.

     by Scott J. Brinker and Chris Robert (and TJS)                3/24/90

     Copyright (c) 1992 Galacticomm, Inc.              All rights reserved.

     NOTE:  This code was developed using the "Flash Attack" sources,
            under license from Galacticomm, Inc.
*/

#define MAXPYR  6             /* maximum number of user per pool           */

char *frzseg();
char *alcmem();

#define CHWSIZ 37             /* size of player's before-game chat window  */

extern
int *bhnd_array;              /* dynamic array of maze structure (behind)  */
extern
int *maze_array;              /* dynamic array of maze structure           */
extern
char *plyscn,                 /* player's screen address                   */
     *pysptr;                 /* pointer to player's screen address        */

struct xyloc {
     int x,y;
};
#define NUMPDS      4         /* number of phase doors                     */
extern
struct xyloc pds[NUMPDS];     /* phase doors (x,y) locations               */

#define MAZWID 59             /* width (in character cells) of maze (x-axis*/
#define MAZLEN 21             /* length (in character cells) of maze (y-axi*/

#define maze(xcoor,ycoor) (maze_array+(ycoor)*MAZWID+(xcoor))
#define bhnd(xcoor,ycoor) (bhnd_array+(ycoor)*MAZWID+(xcoor))
#define hidecursor()     locate(1,26)
#define scrnad(x,y) (frzseg()+(x)*2+(y)*160)

extern
struct player {               /* player structure                          */
     int pinpmo;              /*   player's "input mode" state             */
     int chapos;              /*   player's position in "chat window"      */
     int gamguy;              /*   player's index in gamguys[]             */
     char chawin[CHWSIZ*2];   /*   player's "chat window" character array  */
} player[MAXPYR],             /* static array of players                   */
  *pyrp;                      /* pointer to current player                 */

extern
struct gamguy {
     int x,y;                 /*   player's coordinate   maze(x,y)         */
     int photons;             /*   number of photons remaining             */
     int zappers;             /*   number of zappers remaining             */
     int drillers;            /*   number of drillers remaining            */
     int bombs;               /*   number of bombs remaining               */
     int cubes;               /*   number of cubes remaining               */
     int stamina;             /*   player's stamina remaining              */
     int curwep;              /*   current weapon selected                 */
     int laying;              /*   cell to be laid behind player           */
     int status;              /*   player status (Green,yellow,red,dead)   */
     int playno;              /*   index into player[]                     */
} gamguys[MAXPYR],            /* static array of players                   */
  *gamp;                      /* pointer to current player                 */

extern
int gamn;                     /* current gamguy index                      */

#define XPLTIM     10         /*   time until activated bomb explodes (*5) */

extern
struct bomb {                 /* bomb structure                            */
     int timer;               /*   timer (0=inactive, > 0=active)          */
     int x,y;                 /*   x,y coordinate of bomb                  */
} bombs[MAXPYR][6];           /* array of bombs for all players            */

                              /* player[].pinpmo input mode state codes    */
#define INGAME   -5
#define INCHAT   -3           /*   player is in pre/post-game chat         */
#define RDY2GO   -2           /*   player in chat is "ready to play"       */
#define HLPSCN   -1           /*   player is in chat-originated help screen*/
#define MAIN      0
#define WT4ESC    4           /*   game finished, hit esc to chat          */
#define PLYHLP   11           /*   player is in game-originated help screen*/

                              /* screen attributes for...                  */
#define TERHATR     0x70      /*   ...terminal-mode header                 */
#define TERTATR     0x0A      /*   ...terminal-mode text                   */
#define CHATATR     0x0F      /*   ...chat text before game begins         */
#define CHAWATR     0x0D      /*   ...chat window (box) color              */
#define CHANATR     0x70      /*   ...chat window name plate               */
#define CHARATR     0x30      /*   ...chat window "READY TO PLAY" message  */
#define CHAPATR     0x40      /*   ...chat window "NOW PLAYING" message    */
#define RDOTATR     0x04      /*   ...attribute for little red dot         */
#define WALLATR     0x3F00    /*   ...walls in maze                        */
#define SPACATR     0x1F00    /*   ...blank (open) spaces in maze          */
#define UPYRATR     0x1E00    /*   ...color of your player symbol          */
#define OPYRATR     0x9B00    /*   ...color of other players' symbols      */
#define HUNTATR     0x9D00    /*   ...color of female hunter               */
#define ENRBATR     0x1A00    /*   ...color of energy beacon               */
#define PHOPATR     0x1C00    /*   ...color of photon pack                 */

extern
int spacatr[5],               /*   ...blank (open) spaces in maze          */
    upyratr[5],               /*   ...color of your player symbol          */
    opyratr[5],               /*   ...color of other players' symbols      */
     zapatr[5],               /*   ...color of zapping beam                */
    enrbatr[5],               /*   ...color of energy beacon               */
    zombatr[5],               /*   ...color of zombie player               */
    phopatr[5];               /*   ...color of photon pack                 */

extern
int cdcolor;

#define EBDELAY     100       /*   time delay before new energy beacon     */
#define EBVALUE     4         /*   value of energy beacon in stamina       */
#define PPVALUE     4         /*   value of photon packs                   */

#define CNTDOWN     500       /*   countdown effect, colors/stamina/etc.   */
#define CNTHITS     1         /*   damage done during count down           */

                              /* indexes into scntbl[] for screens         */
#define SMAZE       0         /*   main-game maze screen                   */
#define SFMCHAT     1         /*   chat-mode screen                        */
#define SFMHELPC    2         /*   help screen from chat-mode              */
#define SFMHELPG    3         /*   help screen from game-mode              */
#define SFMHELPT    4         /*   help screen from terminal-mode          */

                              /* communications protocol defines           */
#define NAK    21             /*   standard NAK (non-acknowledgement)      */
#define CAN    24             /*   stand CAN (cancel block)                */
#define NAKACK 120            /*   standard NAK ACK (NAK-acknowledgement)  */
#define REMOVE 121            /*   remove one of the users from the pool   */
#define TICK   122            /*   a tick of 18Hz master clock in host     */
#define NODATA 123            /*   contact with the host has been lost     */
#define LINEUP 127            /*   another user just joined this pool      */

#define IMINCH 1              /* "I'm in chat" sound-off                   */
#define IMINGM 2              /* "I'm in game" sound-off                   */

extern
int gamovr,                   /* is game over?  1=Yes  0=No                */
    solo,                     /* are we in solo mode?  1=Yes  0=No         */
    offline,                  /* are we offline right now?  1=yes 0=no     */
    npyrs,                    /* number of players in pool                 */
    npying,                   /* number of players still playing game  ??? */
    onscrn,                   /* is player at the chat screen?  1=Yes  0=No*/
    gmdisp,                   /* is player at the game screen?  1=Yes  0=No*/
    pyrn,                     /* current player number                     */
    self,                     /* this machine's player's number in npyrs   */
    disp;

extern
char *names[MAXPYR+2];        /* array of player names (User-ID's)         */
extern
char *rcvrno;                 /* pointer to received reg. number           */
extern
int rseed;                    /* random number seed                        */
extern
char scntbl[];                /* table of in-memory "screens"              */

extern
int fstick,fstick2;           /* fast-tickers (125.6 Hz) from SETLUMAZ.ASM */



extern int debug;
extern FILE *fp;
