        page ,132
 
; SERCOM.ASM
;
; by Tim Stryker
;
; Copyright (C) 1989 Galacticomm, Inc.
;
; This source is for use by Galacticomm "FLASH" Protocol Licensees ONLY.
; Any use of the contents of this file, or any functional derivative or
; part or portion thereof, outside of the provisions of the Galacticomm
; "FLASH" Protocol Developers' License Agreement is strictly prohibited.
 
        include model.mac
 
; This package includes the following C-callable utilities:
;
; iniser(chan,uart,irpt)              initialize circular-buffered comm channel
; int chan;                             channel number (0 or 1)
; int uart;                             uart (8250) address
; int irpt;                             hardware interrupt number
;
; setser(chan,baud,parity)            set comm channel characteristics
; int chan;                             channel number (0 or 1)
; int baud;                             baud rate code:
;                                          0 = 110
;                                          1 = 300
;                                          2 = 600
;                                          3 = 1200
;                                          4 = 2400
;                                          5 = 4800
;                                          6 = 9600
;                                          7 = 19200
;                                          8 = 38400
; int parity;                           parity code:
;                                          0 = even  (7/E/1)
;                                          1 = odd   (7/O/1)
;                                          2 = mark  (7/N/2)
;                                          3 = space (8/N/1)
;
; outser(chan,c)                      output a char to comm channel
; int chan;                             channel number (0 or 1)
; char c;                               char to be output
;
; c=rdser(chan)                       read 1 character from comm channel
; char c;                               character read, or EOF if none
; int chan;                             channel number (0 or 1)
;
; finser(chan)                        finish up and restore a comm channel
; int chan;                             channel number (0 or 1)
 
EOF     equ     0ffffh          ; buffer-empty code (matches EOF in stdio.h)
OCW1    equ     21h             ; 8259 port addr for irpt masking info
OCW2    equ     20h             ; 8259 port addr for writing EOI info
NSEOI   equ     20h             ; 8259 non-specific EOI command code
BASIRP  equ     8               ; 8259 base interrupt level
DTR     equ     1               ; DTR mdcreg bit
RTS     equ     2               ; RTS mdcreg bit
OUT2ON  equ     8               ; OUT2 mdcreg bit (uart->pcbus irpt enable)
IRERCV  equ     01h             ; interrupt enable for rcvr-data-ready
IREXMT  equ     02h             ; interrupt enable for xmit-hold-empty
RCVRDY  equ     01h             ; lnsreg rcv-data-ready bit
XHRE    equ     20h             ; lnsreg xmit-hold-reg-empty bit
WRDSTF  equ     1eh             ; break, framing, parity & overrun error bits
WRDSUB  equ     0               ; data byte to substitute when inp w/WRDSTF
 
                                ; uart register offsets
xmtreg  equ     0               ;   uart transmit data reg offset
rcvreg  equ     0               ;   uart receive data reg offset
bdrlo   equ     0               ;   uart baud rate divisor LSB (when DLAB=1)
bdrhi   equ     1               ;   uart baud rate divisor MSB (when DLAB=1)
irereg  equ     1               ;   uart interrupt-enable register offset
irireg  equ     2               ;   uart interrupt-identification reg offset
lncreg  equ     3               ;   uart line-control register offset
mdcreg  equ     4               ;   uart modem-control register offset
lnsreg  equ     5               ;   uart line-status register offset
mdsreg  equ     6               ;   uart modem-status register offset
 
; the following two equates must both be powers of two
 
IBFSIZ  equ    8192             ; comm input buffer size in bytes
OBFSIZ  equ     128             ; comm output buffer size in bytes
 
comlin  struc                   ; comm line data structure
uart    dw      ?               ;   uart port address
irpacc  db      ?               ;   irpt conditions enabled
old59i  db      ?               ;   orig 8259 irpt bitmask
oldire  db      ?               ;   orig 8250 interrupt enable reg contents
irplvl  db      ?               ;   irpt level in use
oldmdc  db      0FFH            ;   orig modem ctl reg conts
        db      ?
oldvec  dw      ?               ;   orig irpt vector contents
        dw      ?
inbuf   db      IBFSIZ dup(?)   ;   input buffer
outbuf  db      OBFSIZ dup(?)   ;   output buffer
inaptr  dw      ?               ;   input ahead circular pointer
inbptr  dw      ?               ;   input behind circular pointer
ouaptr  dw      ?               ;   output ahead circular pointer
oubptr  dw      ?               ;   output behind circular pointer
comlin  ends
 
        dseg
 
comln0  comlin <>               ; comm line data structures
comln1  label word ;comlin <> (not used much, re-enable if needed)
 
pcbdlo  db      23,128,192,96,48,24,12,6,3  ; LO/HO for 110,300,600,1200,2400,
pcbdhi  db      4,1,0,0,0,0,0,0,0           ; 4800,9600,19200, and 38400 baud
 
parbts  db      1ah,0ah,2ah,3ah             ; line ctl reg for parity codes
 
stradr  dw      offset comln0,offset comln1 ; comm structure addrs
comrou  dw      offset irp0,offset irp1     ; comm rou irpt addrs
 
        endds
 
        pseg    sercom
        extrn   stivec:near,rdivec:near,formim:near
 
        proc_def iniser
        push    bp                      ; keep c happy
        mov     bp,sp
        push    si
        push    di
 
        mov     bx,[bp+@]               ; point to comm data block
        add     bx,bx
        mov     bx,stradr[bx]
 
        mov     dx,[bp+@+2]             ; disable irpts from chip
        add     dx,irereg
        in      al,dx                   ;   (remember old pattern for finser)
        mov     [bx+oldire],al
        xor     al,al
        out     dx,al
        mov     [bx+irpacc],al
 
        sub     dx,irereg               ; write uart addr to data block
        mov     [bx+uart],dx
        xor     ax,ax                   ; init circular ptrs
        mov     [bx+inaptr],ax
        mov     [bx+inbptr],ax
        mov     [bx+ouaptr],ax
        mov     [bx+oubptr],ax
 
        push    bx
        mov     bx,[bp+@+4]             ; read current irpt vector contents
        add     bx,BASIRP
        call    rdivec
        pop     bx
        mov     [bx+oldvec],ax          ; remember it for restoration later
        mov     [bx+oldvec+2],dx
 
        push    bx
        mov     bx,[bp+@+4]             ; set irpt vector
        add     bx,BASIRP
        mov     si,[bp+@]
        shl     si,1
        mov     ax,comrou[si]
        mov     dx,cs
        call    stivec
        pop     bx
 
        in      al,OCW1                 ; remember current irpt mask for finser
        mov     [bx+old59i],al
        mov     cl,[bp+@+4]             ; form interrupt mask for irpt
        mov     [bx+irplvl],cl          ;   (remember level num for finser)
        push    bx
        call    formim
        xor     bl,0ffh                 ; enable irpt in 8259
        in      al,OCW1
        and     al,bl
        out     OCW1,al
        pop     bx
 
        call    enaprt                  ; fire up port for action
 
        pop     di
        pop     si
        pop     bp
        ret
        end_proc
 
        proc_def setser
        push    bp                      ; keep c happy
        mov     bp,sp
        push    si
        push    di
 
        mov     bx,[bp+@]               ; point to comm data block
        add     bx,bx
        mov     bx,stradr[bx]
 
        mov     dx,[bx+uart]            ; point to uart
        add     dx,lncreg               ; get access to baud rate regs in uart
        mov     al,80h
        out     dx,al
        add     dx,bdrlo-lncreg         ; set baud rate from passed rate code
        mov     si,[bp+@+2]
        mov     al,pcbdlo[si]
        out     dx,al
        mov     al,pcbdhi[si]
        add     dx,bdrhi-bdrlo
        out     dx,al
        add     dx,lncreg-bdrhi         ; set parity stuff from passed code
        mov     si,[bp+@+4]
        mov     al,parbts[si]
        out     dx,al
 
        call    enaprt                  ; enable port for action
        pop     di
        pop     si
        pop     bp
        ret
        end_proc
 
enaprt  proc    near                    ; ENABLE-PORT UTILITY (bx=comlin ptr)
        mov     dx,[bx+uart]            ; get uart addr
        add     dx,mdcreg               ; turn DTR, RTS, and OUT2 on
        cmp     [bx+oldmdc],0FFH        ;   (if not recorded already, then
        jne     eparec
        in      al,dx                   ;    save for restoration later)
        mov     [bx+oldmdc],al
eparec:
        mov     al,DTR+RTS+OUT2ON
        out     dx,al
        mov     al,RCVRDY+XHRE          ; say xmit & rcv irpts enabled
 
        cli
 
        mov     [bx+irpacc],al
        add     dx,irereg-mdcreg        ; enable xmit and receive irpts
        xor     al,al
        out     dx,al                   ;   (ensure edge in case hung)
        mov     al,IREXMT+IRERCV
        out     dx,al
        add     dx,rcvreg-irereg        ; clear old error conds etc.
        in      al,dx
 
        sti
 
        ret
enaprt  endp
 
        proc_def outser
        push    bp                      ; keep c happy
        mov     bp,sp
        push    si
        push    di
 
        mov     bx,[bp+@]               ; point to comm data block
        add     bx,bx
        mov     bx,stradr[bx]
 
        mov     di,[bx+ouaptr]          ; buffer full?
        mov     si,di
        inc     di
        and     di,OBFSIZ-1
        cmp     di,[bx+oubptr]
        je      oucret                  ; yes, ignore
 
        mov     al,[bp+@+2]             ; drop char in output buffer
        mov     [bx+outbuf][si],al
        mov     ax,(RCVRDY+XHRE)*256+IRERCV+IREXMT   ; prep to enable irpts
        mov     dx,[bx+uart]
        add     dx,irereg
 
        cli
        mov     [bx+ouaptr],di          ; bump the output ahead ptr
        mov     [bx+irpacc],ah          ; enable xmit irpts
        out     dx,al
        sti
 
oucret: pop     di
        pop     si
        pop     bp
        ret
        end_proc
 
        proc_def rdser
        push    bp                      ; keep c happy
        mov     bp,sp
        push    si
        push    di
 
        mov     bx,[bp+@]               ; point to comm data block
        add     bx,bx
        mov     bx,stradr[bx]
 
        mov     si,[bx+inbptr]          ; buffer empty?
        cmp     si,[bx+inaptr]
        je      bufemp                  ; yes
 
        mov     al,[bx+inbuf][si]       ; get next char
        xor     ah,ah
        inc     si                      ; bump input-behind ptr
        and     si,IBFSIZ-1
        mov     [bx+inbptr],si
        jmp short rdcret
 
bufemp: mov     ax,EOF                  ; buffer empty, return EOF
 
rdcret: pop     di
        pop     si
        pop     bp
        ret
        end_proc
 
        proc_def finser
        push    bp                      ; keep c happy
        mov     bp,sp
 
        mov     bx,[bp+@]               ; point to comm data block
        add     bx,bx
        mov     bx,stradr[bx]
 
        mov     al,[bx+old59i]          ; restore orig 8259 irpt bitmask
        out     OCW1,al
 
        mov     al,[bx+oldmdc]          ; restore orig modem ctl reg conts
        mov     dx,[bx+uart]
        add     dx,mdcreg
        out     dx,al
 
        cli
        mov     al,[bx+oldire]          ; restore orig irpt enable reg conts
        mov     dx,[bx+uart]
        add     dx,irereg
        out     dx,al
 
        mov     ax,[bx+oldvec]          ; restore old irpt vector contents
        mov     dx,[bx+oldvec+2]
        mov     bl,[bx+irplvl]
        xor     bh,bh
        add     bx,BASIRP
        call    stivec
        sti
 
        pop     bp
        ret
        end_proc
 
 
irp0    proc    far                     ; channel 0 irpt
        push    bx
        mov     bx,offset dgroup:comln0
        jmp short hdlirp
 
irp1    proc    far                     ; channel 1 irpt
        push    bx
        mov     bx,offset dgroup:comln1
 
hdlirp: push    ax                      ; save rest of regs used
        push    dx
        push    si
        push    di
        push    ds
        mov     ax,dgroup               ; establish addressability
        mov     ds,ax
 
hdlbos: mov     dx,[bx+uart]            ; get active line-status info
        add     dx,lnsreg
        in      al,dx
        sub     dx,lnsreg
        and     al,[bx+irpacc]          ; any accepted conditions active?
        jz      fine                    ; no
        test    al,RCVRDY               ; yes, receive irpt?
        jz      mustbx                  ; no
 
        in      al,dx                   ; yes, get that char
        mov     di,[bx+inaptr]          ; buffer full?
        mov     si,di
        inc     di
        and     di,IBFSIZ-1
        cmp     di,[bx+inbptr]
        je      hdlbos                  ; yes, ignore
        mov     [bx+inbuf][si],al       ; drop char into input buffer
        mov     [bx+inaptr],di          ; bump the input ahead ptr
        jmp short hdlbos
 
mustbx: mov     si,[bx+oubptr]          ; buffer empty?
        cmp     si,[bx+ouaptr]
        je      xmbemp                  ; yes
 
        mov     al,[bx+outbuf][si]      ; send next char
        out     dx,al
        inc     si                      ; bump output behind ptr
        and     si,OBFSIZ-1
        mov     [bx+oubptr],si
        jmp short hdlbos
 
xmbemp: mov     ax,RCVRDY*256+IRERCV    ; buffer empty, disable xmits
        add     dx,irereg
        out     dx,al
        mov     [bx+irpacc],ah
        jmp short hdlbos
 
fine:   mov     al,NSEOI                ; clear irpt in 8259
        out     OCW2,al
 
        mov     dx,[bx+uart]            ; this bull should not be
        inc     dx                      ;   necessary, but for some
        in      al,dx                   ;   reason it is!  if XHRE
        mov     ah,al                   ;   and RCVRDY were both
        xor     al,al                   ;   low, there should be no
        out     dx,al                   ;   way we can miss an edge,
        mov     al,ah                   ;   yet that is what happens
        out     dx,al                   ;   if we don't do this
 
        pop     ds
        pop     di
        pop     si
        pop     dx
        pop     ax
        pop     bx
        iret
 
irp1    endp
irp0    endp
 
        endps
 
        end
